/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl.ps;

import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.prism.BasicStroke;
import com.sun.prism.Graphics;
import com.sun.prism.Texture;
import com.sun.prism.impl.Disposer;
import com.sun.prism.impl.VertexBuffer;
import com.sun.prism.impl.ps.BaseShaderContext;
import com.sun.prism.impl.ps.BaseShaderGraphics;
import com.sun.prism.impl.shape.MaskData;
import com.sun.prism.impl.shape.ShapeUtil;
import com.sun.prism.paint.Gradient;
import com.sun.prism.paint.Paint;
import java.util.ArrayList;
import java.util.List;

class CachingShapeRepState {
    private static final BaseTransform IDENT = BaseTransform.IDENTITY_TRANSFORM;
    private static final MaskCache maskCache = new MaskCache();
    private int renderCount;
    private Boolean tryCache;
    private BaseTransform lastXform;
    private final MaskTexData texData;
    private final Object disposerReferent = new Object();
    private final Disposer.Record disposerRecord;

    private static boolean equalsIgnoreTranslation(BaseTransform baseTransform, BaseTransform baseTransform2) {
        if (baseTransform == baseTransform2) {
            return true;
        }
        return baseTransform.getMxx() == baseTransform2.getMxx() && baseTransform.getMxy() == baseTransform2.getMxy() && baseTransform.getMyx() == baseTransform2.getMyx() && baseTransform.getMyy() == baseTransform2.getMyy();
    }

    private static boolean dimensionsAreSimilar(RectBounds rectBounds, RectBounds rectBounds2) {
        return (double)Math.abs(rectBounds.getWidth() - rectBounds2.getWidth()) < 0.001 && (double)Math.abs(rectBounds.getHeight() - rectBounds2.getHeight()) < 0.001;
    }

    CachingShapeRepState() {
        this.texData = new MaskTexData();
        this.disposerRecord = new CSRDisposerRecord(this.texData);
        Disposer.addRecord(this.disposerReferent, this.disposerRecord);
    }

    void fillNoCache(Graphics graphics, Shape shape) {
        graphics.fill(shape);
    }

    void drawNoCache(Graphics graphics, Shape shape) {
        graphics.draw(shape);
    }

    void invalidate() {
        this.renderCount = 0;
        this.tryCache = null;
        this.lastXform = null;
    }

    private void invalidateMaskTexData() {
        this.tryCache = null;
        this.lastXform = null;
        maskCache.unref(this.texData);
    }

    void render(Graphics graphics, Shape shape, BasicStroke basicStroke) {
        BaseTransform baseTransform = graphics.getTransformNoClone();
        if (this.lastXform == null || !CachingShapeRepState.equalsIgnoreTranslation(baseTransform, this.lastXform)) {
            this.invalidateMaskTexData();
            if (this.lastXform != null) {
                this.renderCount = 0;
            }
        }
        RectBounds rectBounds = null;
        RectBounds rectBounds2 = null;
        if (this.tryCache == null) {
            rectBounds = shape.getBounds();
            if (baseTransform.isIdentity()) {
                rectBounds2 = rectBounds;
            } else {
                rectBounds2 = new RectBounds();
                rectBounds2 = (RectBounds)baseTransform.transform(rectBounds, rectBounds2);
            }
            this.tryCache = maskCache.hasRoom(rectBounds2);
        }
        BaseShaderGraphics baseShaderGraphics = (BaseShaderGraphics)graphics;
        BaseShaderContext baseShaderContext = baseShaderGraphics.getContext();
        ++this.renderCount;
        if (this.tryCache == Boolean.FALSE || this.renderCount <= 1 || baseShaderGraphics.isComplexPaint()) {
            if (basicStroke == null) {
                this.fillNoCache(graphics, shape);
            } else {
                this.drawNoCache(graphics, shape);
            }
            return;
        }
        if (this.lastXform == null || !this.lastXform.equals(baseTransform)) {
            if (rectBounds == null) {
                rectBounds = shape.getBounds();
            }
            if (rectBounds2 == null) {
                if (baseTransform.isIdentity()) {
                    rectBounds2 = rectBounds;
                } else {
                    rectBounds2 = new RectBounds();
                    rectBounds2 = (RectBounds)baseTransform.transform(rectBounds, rectBounds2);
                }
            }
            if (this.texData.cacheEntry != null) {
                this.texData.adjustOrigin(baseTransform);
            } else {
                if (basicStroke != null) {
                    shape = basicStroke.createStrokedShape(shape);
                    rectBounds = shape.getBounds();
                    rectBounds2 = baseTransform.isIdentity() ? rectBounds : (RectBounds)baseTransform.transform(rectBounds, rectBounds2);
                }
                maskCache.get(baseShaderContext, this.texData, shape, baseTransform, rectBounds2);
            }
            if (this.lastXform == null) {
                this.lastXform = baseTransform.copy();
            } else {
                this.lastXform.setTransform(baseTransform);
            }
        }
        Paint paint = baseShaderGraphics.getPaint();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (paint.getType().isGradient() && ((Gradient)paint).isProportional()) {
            if (rectBounds == null) {
                rectBounds = shape.getBounds();
            }
            f = rectBounds.getMinX();
            f2 = rectBounds.getMinY();
            f3 = rectBounds.getWidth();
            f4 = rectBounds.getHeight();
        }
        baseShaderContext.validatePaintOp(baseShaderGraphics, IDENT, this.texData.maskTex, f, f2, f3, f4);
        int n = this.texData.maskW;
        int n2 = this.texData.maskH;
        float f5 = this.texData.maskX;
        float f6 = this.texData.maskY;
        float f7 = f5 + (float)n;
        float f8 = f6 + (float)n2;
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = f9 + (float)n / (float)this.texData.maskTex.getPhysicalWidth();
        float f12 = f10 + (float)n2 / (float)this.texData.maskTex.getPhysicalHeight();
        VertexBuffer vertexBuffer = baseShaderContext.getVertexBuffer();
        vertexBuffer.addQuad(f5, f6, f7, f8, f9, f10, f11, f12);
    }

    void dispose() {
        this.invalidate();
    }

    private static class CSRDisposerRecord
    implements Disposer.Record {
        private MaskTexData texData;

        private CSRDisposerRecord(MaskTexData maskTexData) {
            this.texData = maskTexData;
        }

        @Override
        public void dispose() {
            if (this.texData != null) {
                maskCache.unref(this.texData);
                this.texData = null;
            }
        }
    }

    private static class CacheEntry {
        Shape shape;
        BaseTransform xform;
        RectBounds xformBounds;
        MaskTexData texData;
        int refCount;

        private CacheEntry() {
        }
    }

    private static class MaskCache {
        private static final int MAX_MASK_DIM = 512;
        private static final int MAX_SIZE_IN_PIXELS = 0x400000;
        private final List<CacheEntry> entries = new ArrayList<CacheEntry>();
        private int totalPixels;

        private MaskCache() {
        }

        boolean hasRoom(RectBounds rectBounds) {
            int n = (int)(rectBounds.getWidth() + 0.5f);
            int n2 = (int)(rectBounds.getHeight() + 0.5f);
            int n3 = n * n2;
            return n <= 512 && n2 <= 512 && this.totalPixels + n3 <= 0x400000;
        }

        void get(BaseShaderContext baseShaderContext, MaskTexData maskTexData, Shape shape, BaseTransform baseTransform, RectBounds rectBounds) {
            if (maskTexData == null) {
                throw new InternalError("MaskTexData must be non-null");
            }
            if (maskTexData.cacheEntry != null) {
                throw new InternalError("CacheEntry should already be null");
            }
            for (int i = 0; i < this.entries.size(); ++i) {
                CacheEntry cacheEntry = this.entries.get(i);
                if (!CachingShapeRepState.dimensionsAreSimilar(rectBounds, cacheEntry.xformBounds) || !CachingShapeRepState.equalsIgnoreTranslation(baseTransform, cacheEntry.xform) || !cacheEntry.shape.equals(shape)) continue;
                ++cacheEntry.refCount;
                cacheEntry.texData.copyInto(maskTexData);
                maskTexData.cacheEntry = cacheEntry;
                maskTexData.adjustOrigin(baseTransform);
                return;
            }
            MaskData maskData = ShapeUtil.rasterizeShape(shape, null, rectBounds, baseTransform, true);
            int n = maskData.getWidth();
            int n2 = maskData.getHeight();
            maskTexData.maskX = maskData.getOriginX();
            maskTexData.maskY = maskData.getOriginY();
            maskTexData.maskW = n;
            maskTexData.maskH = n2;
            maskTexData.maskTex = baseShaderContext.getResourceFactory().createMaskTexture(n, n2);
            maskData.uploadToTexture(maskTexData.maskTex, 0, 0, false);
            CacheEntry cacheEntry = new CacheEntry();
            cacheEntry.shape = shape.copy();
            cacheEntry.xform = baseTransform.copy();
            cacheEntry.xformBounds = rectBounds;
            cacheEntry.texData = maskTexData.copy();
            cacheEntry.refCount = 1;
            maskTexData.cacheEntry = cacheEntry;
            this.entries.add(cacheEntry);
            this.totalPixels += n * n2;
        }

        void unref(MaskTexData maskTexData) {
            if (maskTexData == null) {
                throw new InternalError("MaskTexData must be non-null");
            }
            CacheEntry cacheEntry = maskTexData.cacheEntry;
            if (cacheEntry == null) {
                return;
            }
            maskTexData.cacheEntry = null;
            maskTexData.maskTex = null;
            --cacheEntry.refCount;
            if (cacheEntry.refCount <= 0) {
                cacheEntry.shape = null;
                cacheEntry.xform = null;
                cacheEntry.xformBounds = null;
                cacheEntry.texData.maskTex.dispose();
                cacheEntry.texData = null;
                this.entries.remove(cacheEntry);
                this.totalPixels -= maskTexData.maskW * maskTexData.maskH;
            }
        }
    }

    private static class MaskTexData {
        private CacheEntry cacheEntry;
        private Texture maskTex;
        private float maskX;
        private float maskY;
        private int maskW;
        private int maskH;

        private MaskTexData() {
        }

        void adjustOrigin(BaseTransform baseTransform) {
            float f = (float)(baseTransform.getMxt() - this.cacheEntry.xform.getMxt());
            float f2 = (float)(baseTransform.getMyt() - this.cacheEntry.xform.getMyt());
            this.maskX = this.cacheEntry.texData.maskX + f;
            this.maskY = this.cacheEntry.texData.maskY + f2;
        }

        MaskTexData copy() {
            MaskTexData maskTexData = new MaskTexData();
            maskTexData.cacheEntry = this.cacheEntry;
            maskTexData.maskTex = this.maskTex;
            maskTexData.maskX = this.maskX;
            maskTexData.maskY = this.maskY;
            maskTexData.maskW = this.maskW;
            maskTexData.maskH = this.maskH;
            return maskTexData;
        }

        void copyInto(MaskTexData maskTexData) {
            if (maskTexData == null) {
                throw new InternalError("MaskTexData must be non-null");
            }
            maskTexData.cacheEntry = this.cacheEntry;
            maskTexData.maskTex = this.maskTex;
            maskTexData.maskX = this.maskX;
            maskTexData.maskY = this.maskY;
            maskTexData.maskW = this.maskW;
            maskTexData.maskH = this.maskH;
        }
    }
}

