/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.X509CertificateObject;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;

public class Name {
    final X500Name name;
    private transient int hash = 0;

    public Name(X500Principal principal) {
        this.name = X500Name.getInstance((Object)principal.getEncoded());
    }

    public Name(X500Name name2) {
        this.name = name2;
    }

    public static int hash(X500Name name2) throws IOException {
        try {
            byte[] bytes = name2.getEncoded();
            MessageDigest md5 = SecurityHelper.getMessageDigest("MD5");
            byte[] digest2 = md5.digest(bytes);
            int result = 0;
            result |= digest2[3] & 0xFF;
            result <<= 8;
            result |= digest2[2] & 0xFF;
            result <<= 8;
            result |= digest2[1] & 0xFF;
            result <<= 8;
            return (result |= digest2[0] & 0xFF) & 0xFFFFFFFF;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public final int hash() {
        try {
            return this.hash == 0 ? (this.hash = Name.hash(this.name)) : this.hash;
        }
        catch (IOException e) {
            return 0;
        }
        catch (RuntimeException e) {
            return 0;
        }
    }

    public int hashCode() {
        return this.hash();
    }

    public boolean equals(Object that) {
        if (that instanceof Name) {
            return this.name.equals((Object)((Name)that).name);
        }
        return false;
    }

    public boolean equalTo(X500Name name2) {
        return this.name.equals((Object)name2);
    }

    final boolean equalTo(Principal principal) {
        return new X509Principal(this.name).equals((Object)principal);
    }

    public boolean equalTo(X500Principal principal) {
        try {
            return new X500Principal(this.name.getEncoded("DER")).equals(principal);
        }
        catch (IOException e) {
            return false;
        }
    }

    public final boolean equalToCertificateSubject(X509AuxCertificate wrapper) {
        X509Certificate cert2 = wrapper.cert;
        if (cert2 == null) {
            return this.equalTo(wrapper.getSubjectX500Principal());
        }
        if (cert2 instanceof X509CertificateObject) {
            return this.equalTo(cert2.getSubjectDN());
        }
        return this.equalTo(cert2.getSubjectX500Principal());
    }
}

