/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.base.incremental;

import java.io.File;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kapt3.base.incremental.IncrementalProcessorsKt;
import org.jetbrains.kotlin.kapt3.base.incremental.RuntimeProcType;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J)\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0010\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00100\u000fH\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001b\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\r\u0010\u0016\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0017R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/kapt3/base/incremental/AnnotationProcessorDependencyCollector;", "", "runtimeProcType", "Lorg/jetbrains/kotlin/kapt3/base/incremental/RuntimeProcType;", "(Lorg/jetbrains/kotlin/kapt3/base/incremental/RuntimeProcType;)V", "generatedToSource", "", "Ljava/io/File;", "isFullRebuild", "", "add", "", "createdFile", "Ljava/net/URI;", "originatingElements", "", "Ljavax/lang/model/element/Element;", "add$kotlin_annotation_processing_base", "(Ljava/net/URI;[Ljavax/lang/model/element/Element;)V", "getGeneratedToSources", "", "getGeneratedToSources$kotlin_annotation_processing_base", "getRuntimeType", "getRuntimeType$kotlin_annotation_processing_base", "kotlin-annotation-processing-base"})
public final class AnnotationProcessorDependencyCollector {
    private final Map<File, File> generatedToSource;
    private boolean isFullRebuild;
    private final RuntimeProcType runtimeProcType;

    public final void add$kotlin_annotation_processing_base(@NotNull URI createdFile, @NotNull Element[] originatingElements) {
        Intrinsics.checkParameterIsNotNull((Object)createdFile, (String)"createdFile");
        Intrinsics.checkParameterIsNotNull((Object)originatingElements, (String)"originatingElements");
        if (this.isFullRebuild) {
            return;
        }
        File generatedFile = new File(createdFile);
        if (this.runtimeProcType == RuntimeProcType.AGGREGATING) {
            this.generatedToSource.put(generatedFile, null);
        } else {
            List srcFiles = IncrementalProcessorsKt.access$getSrcFiles(originatingElements);
            if (srcFiles.size() != 1) {
                this.isFullRebuild = true;
            } else {
                this.generatedToSource.put(generatedFile, (File)CollectionsKt.single((List)srcFiles));
            }
        }
    }

    @NotNull
    public final Map<File, File> getGeneratedToSources$kotlin_annotation_processing_base() {
        return this.isFullRebuild ? MapsKt.emptyMap() : this.generatedToSource;
    }

    @NotNull
    public final RuntimeProcType getRuntimeType$kotlin_annotation_processing_base() {
        return this.isFullRebuild ? RuntimeProcType.NON_INCREMENTAL : this.runtimeProcType;
    }

    public AnnotationProcessorDependencyCollector(@NotNull RuntimeProcType runtimeProcType) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)((Object)runtimeProcType), (String)"runtimeProcType");
        this.runtimeProcType = runtimeProcType;
        AnnotationProcessorDependencyCollector annotationProcessorDependencyCollector = this;
        boolean bl = false;
        annotationProcessorDependencyCollector.generatedToSource = map = (Map)new LinkedHashMap();
        this.isFullRebuild = !this.runtimeProcType.isIncremental();
    }
}

