/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

public final class JsAstUtils {
    private static final JsNameRef DEFINE_PROPERTY = JsAstUtils.pureFqn("defineProperty", null);
    private static final JsNameRef VALUE = new JsNameRef("value");
    private static final JsPropertyInitializer WRITABLE = new JsPropertyInitializer(JsAstUtils.pureFqn("writable", null), new JsBooleanLiteral(true));
    private static final JsPropertyInitializer ENUMERABLE = new JsPropertyInitializer(JsAstUtils.pureFqn("enumerable", null), new JsBooleanLiteral(false));

    private JsAstUtils() {
    }

    @NotNull
    public static JsStatement convertToStatement(@NotNull JsNode jsNode) {
        if (jsNode == null) {
            JsAstUtils.$$$reportNull$$$1(0);
        }
        if (jsNode == null) {
            JsAstUtils.$$$reportNull$$$0(0);
        }
        assert (jsNode instanceof JsExpression || jsNode instanceof JsStatement) : "Unexpected node of type: " + jsNode.getClass().toString();
        if (jsNode instanceof JsExpression) {
            JsExpression expression2 = (JsExpression)jsNode;
            JsExpressionStatement statement2 = new JsExpressionStatement(expression2);
            if (expression2 instanceof JsNullLiteral || MetadataProperties.getSynthetic(expression2)) {
                MetadataProperties.setSynthetic(statement2, true);
            }
            JsExpressionStatement jsExpressionStatement = statement2;
            if (jsExpressionStatement == null) {
                JsAstUtils.$$$reportNull$$$0(1);
            }
            if (jsExpressionStatement == null) {
                JsAstUtils.$$$reportNull$$$1(1);
            }
            return jsExpressionStatement;
        }
        JsStatement jsStatement = (JsStatement)jsNode;
        if (jsStatement == null) {
            JsAstUtils.$$$reportNull$$$0(2);
        }
        if (jsStatement == null) {
            JsAstUtils.$$$reportNull$$$1(2);
        }
        return jsStatement;
    }

    @NotNull
    public static JsBlock convertToBlock(@NotNull JsNode jsNode) {
        if (jsNode == null) {
            JsAstUtils.$$$reportNull$$$1(3);
        }
        if (jsNode == null) {
            JsAstUtils.$$$reportNull$$$0(3);
        }
        if (jsNode instanceof JsBlock) {
            JsBlock jsBlock = (JsBlock)jsNode;
            if (jsBlock == null) {
                JsAstUtils.$$$reportNull$$$0(4);
            }
            if (jsBlock == null) {
                JsAstUtils.$$$reportNull$$$1(4);
            }
            return jsBlock;
        }
        JsBlock block = new JsBlock();
        block.getStatements().add(JsAstUtils.convertToStatement(jsNode));
        JsBlock jsBlock = block;
        if (jsBlock == null) {
            JsAstUtils.$$$reportNull$$$0(5);
        }
        if (jsBlock == null) {
            JsAstUtils.$$$reportNull$$$1(5);
        }
        return jsBlock;
    }

    @NotNull
    private static JsStatement deBlockIfPossible(@NotNull JsStatement statement2) {
        if (statement2 == null) {
            JsAstUtils.$$$reportNull$$$1(6);
        }
        if (statement2 == null) {
            JsAstUtils.$$$reportNull$$$0(6);
        }
        if (statement2 instanceof JsBlock && ((JsBlock)statement2).getStatements().size() == 1) {
            JsStatement jsStatement = ((JsBlock)statement2).getStatements().get(0);
            if (jsStatement == null) {
                JsAstUtils.$$$reportNull$$$0(7);
            }
            if (jsStatement == null) {
                JsAstUtils.$$$reportNull$$$1(7);
            }
            return jsStatement;
        }
        JsStatement jsStatement = statement2;
        if (jsStatement == null) {
            JsAstUtils.$$$reportNull$$$0(8);
        }
        if (jsStatement == null) {
            JsAstUtils.$$$reportNull$$$1(8);
        }
        return jsStatement;
    }

    @NotNull
    public static JsIf newJsIf(@NotNull JsExpression ifExpression, @NotNull JsStatement thenStatement, @Nullable JsStatement elseStatement) {
        if (ifExpression == null) {
            JsAstUtils.$$$reportNull$$$1(9);
        }
        if (thenStatement == null) {
            JsAstUtils.$$$reportNull$$$1(10);
        }
        if (ifExpression == null) {
            JsAstUtils.$$$reportNull$$$0(9);
        }
        if (thenStatement == null) {
            JsAstUtils.$$$reportNull$$$0(10);
        }
        elseStatement = elseStatement != null ? JsAstUtils.deBlockIfPossible(elseStatement) : null;
        JsIf jsIf = new JsIf(ifExpression, JsAstUtils.deBlockIfPossible(thenStatement), elseStatement);
        if (jsIf == null) {
            JsAstUtils.$$$reportNull$$$0(11);
        }
        if (jsIf == null) {
            JsAstUtils.$$$reportNull$$$1(11);
        }
        return jsIf;
    }

    @NotNull
    public static JsIf newJsIf(@NotNull JsExpression ifExpression, @NotNull JsStatement thenStatement) {
        if (ifExpression == null) {
            JsAstUtils.$$$reportNull$$$1(12);
        }
        if (thenStatement == null) {
            JsAstUtils.$$$reportNull$$$1(13);
        }
        if (ifExpression == null) {
            JsAstUtils.$$$reportNull$$$0(12);
        }
        if (thenStatement == null) {
            JsAstUtils.$$$reportNull$$$0(13);
        }
        JsIf jsIf = JsAstUtils.newJsIf(ifExpression, thenStatement, null);
        if (jsIf == null) {
            JsAstUtils.$$$reportNull$$$0(14);
        }
        if (jsIf == null) {
            JsAstUtils.$$$reportNull$$$1(14);
        }
        return jsIf;
    }

    @Nullable
    public static JsExpression extractExpressionFromStatement(@Nullable JsStatement statement2) {
        return statement2 instanceof JsExpressionStatement ? ((JsExpressionStatement)statement2).getExpression() : null;
    }

    @NotNull
    public static JsStatement mergeStatementInBlockIfNeeded(@NotNull JsStatement statement2, @NotNull JsBlock block) {
        if (statement2 == null) {
            JsAstUtils.$$$reportNull$$$1(15);
        }
        if (block == null) {
            JsAstUtils.$$$reportNull$$$1(16);
        }
        if (statement2 == null) {
            JsAstUtils.$$$reportNull$$$0(15);
        }
        if (block == null) {
            JsAstUtils.$$$reportNull$$$0(16);
        }
        if (block.isEmpty()) {
            JsStatement jsStatement = statement2;
            if (jsStatement == null) {
                JsAstUtils.$$$reportNull$$$0(17);
            }
            if (jsStatement == null) {
                JsAstUtils.$$$reportNull$$$1(17);
            }
            return jsStatement;
        }
        if (JsAstUtils.isEmptyStatement(statement2)) {
            JsStatement jsStatement = JsAstUtils.deBlockIfPossible(block);
            if (jsStatement == null) {
                JsAstUtils.$$$reportNull$$$0(18);
            }
            if (jsStatement == null) {
                JsAstUtils.$$$reportNull$$$1(18);
            }
            return jsStatement;
        }
        block.getStatements().add(statement2);
        JsBlock jsBlock = block;
        if (jsBlock == null) {
            JsAstUtils.$$$reportNull$$$0(19);
        }
        if (jsBlock == null) {
            JsAstUtils.$$$reportNull$$$1(19);
        }
        return jsBlock;
    }

    public static boolean isEmptyStatement(@NotNull JsStatement statement2) {
        if (statement2 == null) {
            JsAstUtils.$$$reportNull$$$1(20);
        }
        if (statement2 == null) {
            JsAstUtils.$$$reportNull$$$0(20);
        }
        return statement2 instanceof JsEmpty;
    }

    @NotNull
    public static JsInvocation invokeKotlinFunction(@NotNull String name, JsExpression ... argument) {
        if (name == null) {
            JsAstUtils.$$$reportNull$$$1(21);
        }
        if (argument == null) {
            JsAstUtils.$$$reportNull$$$1(22);
        }
        if (name == null) {
            JsAstUtils.$$$reportNull$$$0(21);
        }
        if (argument == null) {
            JsAstUtils.$$$reportNull$$$0(22);
        }
        JsInvocation jsInvocation = JsAstUtils.invokeMethod(Namer.kotlinObject(), name, argument);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(23);
        }
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$1(23);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsInvocation invokeMethod(@NotNull JsExpression thisObject, @NotNull String name, JsExpression ... arguments2) {
        if (thisObject == null) {
            JsAstUtils.$$$reportNull$$$1(24);
        }
        if (name == null) {
            JsAstUtils.$$$reportNull$$$1(25);
        }
        if (arguments2 == null) {
            JsAstUtils.$$$reportNull$$$1(26);
        }
        if (thisObject == null) {
            JsAstUtils.$$$reportNull$$$0(24);
        }
        if (name == null) {
            JsAstUtils.$$$reportNull$$$0(25);
        }
        if (arguments2 == null) {
            JsAstUtils.$$$reportNull$$$0(26);
        }
        JsInvocation jsInvocation = new JsInvocation((JsExpression)JsAstUtils.pureFqn(name, thisObject), arguments2);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(27);
        }
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$1(27);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression toInt32(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$1(28);
        }
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(28);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.BIT_OR, expression2, new JsIntLiteral(0));
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(29);
        }
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$1(29);
        }
        return jsBinaryOperation;
    }

    @Nullable
    public static JsExpression extractToInt32Argument(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$1(30);
        }
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(30);
        }
        if (!(expression2 instanceof JsBinaryOperation)) {
            return null;
        }
        JsBinaryOperation binary = (JsBinaryOperation)expression2;
        if (binary.getOperator() != JsBinaryOperator.BIT_OR) {
            return null;
        }
        if (!(binary.getArg2() instanceof JsIntLiteral)) {
            return null;
        }
        JsIntLiteral arg2 = (JsIntLiteral)binary.getArg2();
        return arg2.value == 0 ? binary.getArg1() : null;
    }

    @NotNull
    public static JsExpression charToInt(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$1(31);
        }
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(31);
        }
        JsExpression jsExpression = JsAstUtils.toInt32(expression2);
        if (jsExpression == null) {
            JsAstUtils.$$$reportNull$$$0(32);
        }
        if (jsExpression == null) {
            JsAstUtils.$$$reportNull$$$1(32);
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression charToString(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$1(33);
        }
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(33);
        }
        JsInvocation jsInvocation = new JsInvocation((JsExpression)new JsNameRef("fromCharCode", (JsExpression)new JsNameRef("String")), expression2);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(34);
        }
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$1(34);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression compareTo(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$1(35);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$1(36);
        }
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(35);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(36);
        }
        JsInvocation jsInvocation = JsAstUtils.invokeKotlinFunction(OperatorNameConventions.COMPARE_TO.getIdentifier(), left, right);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(37);
        }
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$1(37);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression primitiveCompareTo(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$1(38);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$1(39);
        }
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(38);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(39);
        }
        JsInvocation jsInvocation = JsAstUtils.invokeKotlinFunction("primitiveCompareTo", left, right);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(40);
        }
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$1(40);
        }
        return jsInvocation;
    }

    public static JsExpression newLong(long value) {
        JsExpression result2;
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            if (value == Long.MAX_VALUE) {
                return new JsNameRef("MAX_VALUE", (JsExpression)Namer.kotlinLong());
            }
            if (value == Long.MIN_VALUE) {
                return new JsNameRef("MIN_VALUE", (JsExpression)Namer.kotlinLong());
            }
            int low = (int)value;
            int high = (int)(value >> 32);
            SmartList<JsIntLiteral> args = new SmartList<JsIntLiteral>();
            args.add(new JsIntLiteral(low));
            args.add(new JsIntLiteral(high));
            result2 = new JsNew(Namer.kotlinLong(), args);
        } else {
            result2 = value == 0L ? new JsNameRef("ZERO", (JsExpression)Namer.kotlinLong()) : (value == 1L ? new JsNameRef("ONE", (JsExpression)Namer.kotlinLong()) : (value == -1L ? new JsNameRef("NEG_ONE", (JsExpression)Namer.kotlinLong()) : JsAstUtils.longFromInt(new JsIntLiteral((int)value))));
        }
        MetadataProperties.setSideEffects(result2, SideEffectKind.PURE);
        return result2;
    }

    @NotNull
    public static JsExpression longFromInt(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$1(41);
        }
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(41);
        }
        JsInvocation jsInvocation = JsAstUtils.invokeMethod(Namer.kotlinLong(), "fromInt", expression2);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(42);
        }
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$1(42);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression longFromNumber(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$1(43);
        }
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(43);
        }
        JsInvocation jsInvocation = JsAstUtils.invokeMethod(Namer.kotlinLong(), "fromNumber", expression2);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(44);
        }
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$1(44);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression longToNumber(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$1(45);
        }
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(45);
        }
        JsInvocation jsInvocation = JsAstUtils.invokeMethod(expression2, "toNumber", new JsExpression[0]);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(46);
        }
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$1(46);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression byteToUByte(byte value, @NotNull TranslationContext context) {
        if (context == null) {
            JsAstUtils.$$$reportNull$$$1(47);
        }
        if (context == null) {
            JsAstUtils.$$$reportNull$$$0(47);
        }
        JsExpression jsExpression = JsAstUtils.toUnsignedNumber(new JsIntLiteral(value), context, KotlinBuiltIns.FQ_NAMES.uByte);
        if (jsExpression == null) {
            JsAstUtils.$$$reportNull$$$0(48);
        }
        if (jsExpression == null) {
            JsAstUtils.$$$reportNull$$$1(48);
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression shortToUShort(short value, @NotNull TranslationContext context) {
        if (context == null) {
            JsAstUtils.$$$reportNull$$$1(49);
        }
        if (context == null) {
            JsAstUtils.$$$reportNull$$$0(49);
        }
        JsExpression jsExpression = JsAstUtils.toUnsignedNumber(new JsIntLiteral(value), context, KotlinBuiltIns.FQ_NAMES.uShort);
        if (jsExpression == null) {
            JsAstUtils.$$$reportNull$$$0(50);
        }
        if (jsExpression == null) {
            JsAstUtils.$$$reportNull$$$1(50);
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression intToUInt(int value, @NotNull TranslationContext context) {
        if (context == null) {
            JsAstUtils.$$$reportNull$$$1(51);
        }
        if (context == null) {
            JsAstUtils.$$$reportNull$$$0(51);
        }
        JsExpression jsExpression = JsAstUtils.toUnsignedNumber(new JsIntLiteral(value), context, KotlinBuiltIns.FQ_NAMES.uInt);
        if (jsExpression == null) {
            JsAstUtils.$$$reportNull$$$0(52);
        }
        if (jsExpression == null) {
            JsAstUtils.$$$reportNull$$$1(52);
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression longToULong(@NotNull JsExpression expression2, @NotNull TranslationContext context) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$1(53);
        }
        if (context == null) {
            JsAstUtils.$$$reportNull$$$1(54);
        }
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(53);
        }
        if (context == null) {
            JsAstUtils.$$$reportNull$$$0(54);
        }
        JsExpression jsExpression = JsAstUtils.toUnsignedNumber(expression2, context, KotlinBuiltIns.FQ_NAMES.uLong);
        if (jsExpression == null) {
            JsAstUtils.$$$reportNull$$$0(55);
        }
        if (jsExpression == null) {
            JsAstUtils.$$$reportNull$$$1(55);
        }
        return jsExpression;
    }

    private static JsExpression toUnsignedNumber(@NotNull JsExpression expression2, @NotNull TranslationContext context, @NotNull ClassId unsignedClassId) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$1(56);
        }
        if (context == null) {
            JsAstUtils.$$$reportNull$$$1(57);
        }
        if (unsignedClassId == null) {
            JsAstUtils.$$$reportNull$$$1(58);
        }
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(56);
        }
        if (context == null) {
            JsAstUtils.$$$reportNull$$$0(57);
        }
        if (unsignedClassId == null) {
            JsAstUtils.$$$reportNull$$$0(58);
        }
        ClassDescriptor classDescriptor2 = FindClassInModuleKt.findClassAcrossModuleDependencies(context.getCurrentModule(), unsignedClassId);
        assert (classDescriptor2 != null) : "Class descriptor is null for " + unsignedClassId;
        return new JsNew(ReferenceTranslator.translateAsTypeReference(classDescriptor2, context), Collections.singletonList(expression2));
    }

    @NotNull
    public static JsExpression compareForObject(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$1(59);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$1(60);
        }
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(59);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(60);
        }
        JsInvocation jsInvocation = JsAstUtils.invokeMethod(left, Namer.COMPARE_TO_METHOD_NAME, right);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(61);
        }
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$1(61);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression notOptimized(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$1(62);
        }
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(62);
        }
        if (expression2 instanceof JsUnaryOperation) {
            JsUnaryOperation unary = (JsUnaryOperation)expression2;
            if (unary.getOperator() == JsUnaryOperator.NOT) {
                JsExpression jsExpression = unary.getArg();
                if (jsExpression == null) {
                    JsAstUtils.$$$reportNull$$$0(63);
                }
                if (jsExpression == null) {
                    JsAstUtils.$$$reportNull$$$1(63);
                }
                return jsExpression;
            }
        } else if (expression2 instanceof JsBinaryOperation) {
            JsBinaryOperation binary = (JsBinaryOperation)expression2;
            switch (binary.getOperator()) {
                case AND: {
                    JsBinaryOperation jsBinaryOperation = JsAstUtils.or(JsAstUtils.notOptimized(binary.getArg1()), JsAstUtils.notOptimized(binary.getArg2()));
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$0(64);
                    }
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$1(64);
                    }
                    return jsBinaryOperation;
                }
                case OR: {
                    JsBinaryOperation jsBinaryOperation = JsAstUtils.and(JsAstUtils.notOptimized(binary.getArg1()), JsAstUtils.notOptimized(binary.getArg2()));
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$0(65);
                    }
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$1(65);
                    }
                    return jsBinaryOperation;
                }
                case EQ: {
                    JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.NEQ, binary.getArg1(), binary.getArg2());
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$0(66);
                    }
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$1(66);
                    }
                    return jsBinaryOperation;
                }
                case NEQ: {
                    JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.EQ, binary.getArg1(), binary.getArg2());
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$0(67);
                    }
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$1(67);
                    }
                    return jsBinaryOperation;
                }
                case REF_EQ: {
                    JsBinaryOperation jsBinaryOperation = JsAstUtils.inequality(binary.getArg1(), binary.getArg2());
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$0(68);
                    }
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$1(68);
                    }
                    return jsBinaryOperation;
                }
                case REF_NEQ: {
                    JsBinaryOperation jsBinaryOperation = JsAstUtils.equality(binary.getArg1(), binary.getArg2());
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$0(69);
                    }
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$1(69);
                    }
                    return jsBinaryOperation;
                }
                case LT: {
                    JsBinaryOperation jsBinaryOperation = JsAstUtils.greaterThanEq(binary.getArg1(), binary.getArg2());
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$0(70);
                    }
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$1(70);
                    }
                    return jsBinaryOperation;
                }
                case LTE: {
                    JsBinaryOperation jsBinaryOperation = JsAstUtils.greaterThan(binary.getArg1(), binary.getArg2());
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$0(71);
                    }
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$1(71);
                    }
                    return jsBinaryOperation;
                }
                case GT: {
                    JsBinaryOperation jsBinaryOperation = JsAstUtils.lessThanEq(binary.getArg1(), binary.getArg2());
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$0(72);
                    }
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$1(72);
                    }
                    return jsBinaryOperation;
                }
                case GTE: {
                    JsBinaryOperation jsBinaryOperation = JsAstUtils.lessThan(binary.getArg1(), binary.getArg2());
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$0(73);
                    }
                    if (jsBinaryOperation == null) {
                        JsAstUtils.$$$reportNull$$$1(73);
                    }
                    return jsBinaryOperation;
                }
            }
        }
        JsPrefixOperation jsPrefixOperation = JsAstUtils.not(expression2);
        if (jsPrefixOperation == null) {
            JsAstUtils.$$$reportNull$$$0(74);
        }
        if (jsPrefixOperation == null) {
            JsAstUtils.$$$reportNull$$$1(74);
        }
        return jsPrefixOperation;
    }

    @NotNull
    public static JsBinaryOperation and(@NotNull JsExpression op1, @NotNull JsExpression op2) {
        if (op1 == null) {
            JsAstUtils.$$$reportNull$$$1(75);
        }
        if (op2 == null) {
            JsAstUtils.$$$reportNull$$$1(76);
        }
        if (op1 == null) {
            JsAstUtils.$$$reportNull$$$0(75);
        }
        if (op2 == null) {
            JsAstUtils.$$$reportNull$$$0(76);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.AND, op1, op2);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(77);
        }
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$1(77);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation or(@NotNull JsExpression op1, @NotNull JsExpression op2) {
        if (op1 == null) {
            JsAstUtils.$$$reportNull$$$1(78);
        }
        if (op2 == null) {
            JsAstUtils.$$$reportNull$$$1(79);
        }
        if (op1 == null) {
            JsAstUtils.$$$reportNull$$$0(78);
        }
        if (op2 == null) {
            JsAstUtils.$$$reportNull$$$0(79);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.OR, op1, op2);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(80);
        }
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$1(80);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation equality(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$1(83);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$1(84);
        }
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$0(83);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$0(84);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.REF_EQ, arg1, arg2);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(85);
        }
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$1(85);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation inequality(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$1(86);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$1(87);
        }
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$0(86);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$0(87);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.REF_NEQ, arg1, arg2);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(88);
        }
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$1(88);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation lessThanEq(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$1(89);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$1(90);
        }
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$0(89);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$0(90);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.LTE, arg1, arg2);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(91);
        }
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$1(91);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation lessThan(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$1(92);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$1(93);
        }
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$0(92);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$0(93);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.LT, arg1, arg2);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(94);
        }
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$1(94);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation greaterThan(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$1(95);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$1(96);
        }
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$0(95);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$0(96);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.GT, arg1, arg2);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(97);
        }
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$1(97);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation greaterThanEq(@NotNull JsExpression arg1, @NotNull JsExpression arg2) {
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$1(98);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$1(99);
        }
        if (arg1 == null) {
            JsAstUtils.$$$reportNull$$$0(98);
        }
        if (arg2 == null) {
            JsAstUtils.$$$reportNull$$$0(99);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.GTE, arg1, arg2);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(100);
        }
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$1(100);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation assignment(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$1(101);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$1(102);
        }
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(101);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(102);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.ASG, left, right);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(103);
        }
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$1(103);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsStatement assignmentToThisField(@NotNull String fieldName, @NotNull JsExpression right) {
        if (fieldName == null) {
            JsAstUtils.$$$reportNull$$$1(104);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$1(105);
        }
        if (fieldName == null) {
            JsAstUtils.$$$reportNull$$$0(104);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(105);
        }
        JsStatement jsStatement = JsAstUtils.assignment(new JsNameRef(fieldName, (JsExpression)new JsThisRef()), right).source(right.getSource()).makeStmt();
        if (jsStatement == null) {
            JsAstUtils.$$$reportNull$$$0(106);
        }
        if (jsStatement == null) {
            JsAstUtils.$$$reportNull$$$1(106);
        }
        return jsStatement;
    }

    public static JsStatement asSyntheticStatement(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$1(107);
        }
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(107);
        }
        JsExpressionStatement statement2 = new JsExpressionStatement(expression2);
        MetadataProperties.setSynthetic(statement2, true);
        return statement2;
    }

    @Nullable
    public static Pair<JsExpression, JsExpression> decomposeAssignment(@NotNull JsExpression expr) {
        if (expr == null) {
            JsAstUtils.$$$reportNull$$$1(108);
        }
        if (expr == null) {
            JsAstUtils.$$$reportNull$$$0(108);
        }
        if (!(expr instanceof JsBinaryOperation)) {
            return null;
        }
        JsBinaryOperation binary = (JsBinaryOperation)expr;
        if (binary.getOperator() != JsBinaryOperator.ASG) {
            return null;
        }
        return new Pair<JsExpression, JsExpression>(binary.getArg1(), binary.getArg2());
    }

    @Nullable
    public static Pair<JsName, JsExpression> decomposeAssignmentToVariable(@NotNull JsExpression expr) {
        Pair<JsExpression, JsExpression> assignment;
        if (expr == null) {
            JsAstUtils.$$$reportNull$$$1(109);
        }
        if (expr == null) {
            JsAstUtils.$$$reportNull$$$0(109);
        }
        if ((assignment = JsAstUtils.decomposeAssignment(expr)) == null || !(assignment.getFirst() instanceof JsNameRef)) {
            return null;
        }
        JsNameRef nameRef = (JsNameRef)assignment.getFirst();
        if (nameRef.getName() == null || nameRef.getQualifier() != null) {
            return null;
        }
        return new Pair<JsName, JsExpression>(nameRef.getName(), assignment.getSecond());
    }

    @NotNull
    public static JsBinaryOperation sum(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$1(110);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$1(111);
        }
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(110);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(111);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.ADD, left, right);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(112);
        }
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$1(112);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation addAssign(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$1(113);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$1(114);
        }
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(113);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(114);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.ASG_ADD, left, right);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(115);
        }
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$1(115);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation subtract(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$1(116);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$1(117);
        }
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(116);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(117);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.SUB, left, right);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(118);
        }
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$1(118);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation mul(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$1(119);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$1(120);
        }
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(119);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(120);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.MUL, left, right);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(121);
        }
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$1(121);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation div(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$1(122);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$1(123);
        }
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(122);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(123);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.DIV, left, right);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(124);
        }
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$1(124);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation mod(@NotNull JsExpression left, @NotNull JsExpression right) {
        if (left == null) {
            JsAstUtils.$$$reportNull$$$1(125);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$1(126);
        }
        if (left == null) {
            JsAstUtils.$$$reportNull$$$0(125);
        }
        if (right == null) {
            JsAstUtils.$$$reportNull$$$0(126);
        }
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.MOD, left, right);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(127);
        }
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$1(127);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsPrefixOperation not(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$1(128);
        }
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(128);
        }
        JsPrefixOperation jsPrefixOperation = new JsPrefixOperation(JsUnaryOperator.NOT, expression2);
        if (jsPrefixOperation == null) {
            JsAstUtils.$$$reportNull$$$0(129);
        }
        if (jsPrefixOperation == null) {
            JsAstUtils.$$$reportNull$$$1(129);
        }
        return jsPrefixOperation;
    }

    @NotNull
    public static JsBinaryOperation typeOfIs(@NotNull JsExpression expression2, @NotNull JsStringLiteral string) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$1(130);
        }
        if (string == null) {
            JsAstUtils.$$$reportNull$$$1(131);
        }
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(130);
        }
        if (string == null) {
            JsAstUtils.$$$reportNull$$$0(131);
        }
        JsBinaryOperation jsBinaryOperation = JsAstUtils.equality(new JsPrefixOperation(JsUnaryOperator.TYPEOF, expression2), string);
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$0(132);
        }
        if (jsBinaryOperation == null) {
            JsAstUtils.$$$reportNull$$$1(132);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsVars newVar(@NotNull JsName name, @Nullable JsExpression expr) {
        if (name == null) {
            JsAstUtils.$$$reportNull$$$1(133);
        }
        if (name == null) {
            JsAstUtils.$$$reportNull$$$0(133);
        }
        JsVars jsVars = new JsVars(new JsVars.JsVar(name, expr));
        if (jsVars == null) {
            JsAstUtils.$$$reportNull$$$0(134);
        }
        if (jsVars == null) {
            JsAstUtils.$$$reportNull$$$1(134);
        }
        return jsVars;
    }

    @NotNull
    public static JsExpression newSequence(@NotNull List<JsExpression> expressions) {
        if (expressions == null) {
            JsAstUtils.$$$reportNull$$$1(135);
        }
        if (expressions == null) {
            JsAstUtils.$$$reportNull$$$0(135);
        }
        assert (!expressions.isEmpty());
        if (expressions.size() == 1) {
            JsExpression jsExpression = expressions.get(0);
            if (jsExpression == null) {
                JsAstUtils.$$$reportNull$$$0(136);
            }
            if (jsExpression == null) {
                JsAstUtils.$$$reportNull$$$1(136);
            }
            return jsExpression;
        }
        JsExpression result2 = expressions.get(0);
        for (int i = 1; i < expressions.size(); ++i) {
            result2 = new JsBinaryOperation(JsBinaryOperator.COMMA, result2, expressions.get(i));
        }
        JsExpression jsExpression = result2;
        if (jsExpression == null) {
            JsAstUtils.$$$reportNull$$$0(137);
        }
        if (jsExpression == null) {
            JsAstUtils.$$$reportNull$$$1(137);
        }
        return jsExpression;
    }

    @NotNull
    public static JsFunction createFunctionWithEmptyBody(@NotNull JsScope parent2) {
        if (parent2 == null) {
            JsAstUtils.$$$reportNull$$$1(138);
        }
        if (parent2 == null) {
            JsAstUtils.$$$reportNull$$$0(138);
        }
        JsFunction jsFunction = new JsFunction(parent2, new JsBlock(), "<anonymous>");
        if (jsFunction == null) {
            JsAstUtils.$$$reportNull$$$0(139);
        }
        if (jsFunction == null) {
            JsAstUtils.$$$reportNull$$$1(139);
        }
        return jsFunction;
    }

    @NotNull
    public static List<JsExpression> toStringLiteralList(@NotNull List<String> strings) {
        if (strings == null) {
            JsAstUtils.$$$reportNull$$$1(140);
        }
        if (strings == null) {
            JsAstUtils.$$$reportNull$$$0(140);
        }
        if (strings.isEmpty()) {
            List<JsExpression> list2 = Collections.emptyList();
            if (list2 == null) {
                JsAstUtils.$$$reportNull$$$0(141);
            }
            if (list2 == null) {
                JsAstUtils.$$$reportNull$$$1(141);
            }
            return list2;
        }
        SmartList<JsExpression> result2 = new SmartList<JsExpression>();
        for (String str : strings) {
            result2.add(new JsStringLiteral(str));
        }
        SmartList<JsExpression> smartList = result2;
        if (smartList == null) {
            JsAstUtils.$$$reportNull$$$0(142);
        }
        if (smartList == null) {
            JsAstUtils.$$$reportNull$$$1(142);
        }
        return smartList;
    }

    @NotNull
    public static JsInvocation defineProperty(@NotNull JsExpression receiver2, @NotNull String name, @NotNull JsExpression value) {
        if (receiver2 == null) {
            JsAstUtils.$$$reportNull$$$1(143);
        }
        if (name == null) {
            JsAstUtils.$$$reportNull$$$1(144);
        }
        if (value == null) {
            JsAstUtils.$$$reportNull$$$1(145);
        }
        if (receiver2 == null) {
            JsAstUtils.$$$reportNull$$$0(143);
        }
        if (name == null) {
            JsAstUtils.$$$reportNull$$$0(144);
        }
        if (value == null) {
            JsAstUtils.$$$reportNull$$$0(145);
        }
        JsInvocation jsInvocation = new JsInvocation((JsExpression)DEFINE_PROPERTY.deepCopy(), receiver2, new JsStringLiteral(name), value);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(146);
        }
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$1(146);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsStatement defineSimpleProperty(@NotNull JsName name, @NotNull JsExpression value, @Nullable SourceElement source) {
        if (name == null) {
            JsAstUtils.$$$reportNull$$$1(147);
        }
        if (value == null) {
            JsAstUtils.$$$reportNull$$$1(148);
        }
        if (name == null) {
            JsAstUtils.$$$reportNull$$$0(147);
        }
        if (value == null) {
            JsAstUtils.$$$reportNull$$$0(148);
        }
        JsBinaryOperation assignment = JsAstUtils.assignment(new JsNameRef(name, (JsExpression)new JsThisRef()), value);
        if (source != null) {
            assignment.setSource(KotlinSourceElementKt.getPsi(source));
        }
        JsStatement jsStatement = assignment.makeStmt();
        if (jsStatement == null) {
            JsAstUtils.$$$reportNull$$$0(149);
        }
        if (jsStatement == null) {
            JsAstUtils.$$$reportNull$$$1(149);
        }
        return jsStatement;
    }

    @NotNull
    public static JsObjectLiteral createDataDescriptor(@NotNull JsExpression value, boolean writable, boolean enumerable) {
        if (value == null) {
            JsAstUtils.$$$reportNull$$$1(150);
        }
        if (value == null) {
            JsAstUtils.$$$reportNull$$$0(150);
        }
        JsObjectLiteral dataDescriptor = new JsObjectLiteral();
        dataDescriptor.getPropertyInitializers().add(new JsPropertyInitializer(VALUE.deepCopy(), value));
        if (writable) {
            dataDescriptor.getPropertyInitializers().add(WRITABLE.deepCopy());
        }
        if (enumerable) {
            dataDescriptor.getPropertyInitializers().add(ENUMERABLE.deepCopy());
        }
        JsObjectLiteral jsObjectLiteral = dataDescriptor;
        if (jsObjectLiteral == null) {
            JsAstUtils.$$$reportNull$$$0(151);
        }
        if (jsObjectLiteral == null) {
            JsAstUtils.$$$reportNull$$$1(151);
        }
        return jsObjectLiteral;
    }

    @NotNull
    public static JsObjectLiteral wrapValue(@NotNull JsExpression label, @NotNull JsExpression value) {
        if (label == null) {
            JsAstUtils.$$$reportNull$$$1(152);
        }
        if (value == null) {
            JsAstUtils.$$$reportNull$$$1(153);
        }
        if (label == null) {
            JsAstUtils.$$$reportNull$$$0(152);
        }
        if (value == null) {
            JsAstUtils.$$$reportNull$$$0(153);
        }
        JsObjectLiteral jsObjectLiteral = new JsObjectLiteral(Collections.singletonList(new JsPropertyInitializer(label, value)));
        if (jsObjectLiteral == null) {
            JsAstUtils.$$$reportNull$$$0(154);
        }
        if (jsObjectLiteral == null) {
            JsAstUtils.$$$reportNull$$$1(154);
        }
        return jsObjectLiteral;
    }

    @NotNull
    public static List<JsStatement> flattenStatement(@NotNull JsStatement statement2) {
        if (statement2 == null) {
            JsAstUtils.$$$reportNull$$$1(155);
        }
        if (statement2 == null) {
            JsAstUtils.$$$reportNull$$$0(155);
        }
        if (statement2 instanceof JsBlock) {
            List<JsStatement> list2 = ((JsBlock)statement2).getStatements();
            if (list2 == null) {
                JsAstUtils.$$$reportNull$$$0(156);
            }
            if (list2 == null) {
                JsAstUtils.$$$reportNull$$$1(156);
            }
            return list2;
        }
        SmartList<JsStatement> smartList = new SmartList<JsStatement>(statement2);
        if (smartList == null) {
            JsAstUtils.$$$reportNull$$$0(157);
        }
        if (smartList == null) {
            JsAstUtils.$$$reportNull$$$1(157);
        }
        return smartList;
    }

    @NotNull
    public static JsNameRef pureFqn(@NotNull String identifier, @Nullable JsExpression qualifier) {
        if (identifier == null) {
            JsAstUtils.$$$reportNull$$$1(158);
        }
        if (identifier == null) {
            JsAstUtils.$$$reportNull$$$0(158);
        }
        JsNameRef result2 = new JsNameRef(identifier, qualifier);
        MetadataProperties.setSideEffects(result2, SideEffectKind.PURE);
        JsNameRef jsNameRef = result2;
        if (jsNameRef == null) {
            JsAstUtils.$$$reportNull$$$0(159);
        }
        if (jsNameRef == null) {
            JsAstUtils.$$$reportNull$$$1(159);
        }
        return jsNameRef;
    }

    @NotNull
    public static JsNameRef pureFqn(@NotNull JsName identifier, @Nullable JsExpression qualifier) {
        if (identifier == null) {
            JsAstUtils.$$$reportNull$$$1(160);
        }
        if (identifier == null) {
            JsAstUtils.$$$reportNull$$$0(160);
        }
        JsNameRef result2 = new JsNameRef(identifier, qualifier);
        MetadataProperties.setSideEffects(result2, SideEffectKind.PURE);
        JsNameRef jsNameRef = result2;
        if (jsNameRef == null) {
            JsAstUtils.$$$reportNull$$$0(161);
        }
        if (jsNameRef == null) {
            JsAstUtils.$$$reportNull$$$1(161);
        }
        return jsNameRef;
    }

    @NotNull
    public static JsInvocation invokeBind(@NotNull JsExpression receiver2, @NotNull JsExpression method) {
        if (receiver2 == null) {
            JsAstUtils.$$$reportNull$$$1(162);
        }
        if (method == null) {
            JsAstUtils.$$$reportNull$$$1(163);
        }
        if (receiver2 == null) {
            JsAstUtils.$$$reportNull$$$0(162);
        }
        if (method == null) {
            JsAstUtils.$$$reportNull$$$0(163);
        }
        JsInvocation jsInvocation = JsAstUtils.invokeMethod(method, "bind", receiver2);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(164);
        }
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$1(164);
        }
        return jsInvocation;
    }

    public static boolean isUndefinedExpression(JsExpression expression2) {
        if (!(expression2 instanceof JsUnaryOperation)) {
            return false;
        }
        JsUnaryOperation unary = (JsUnaryOperation)expression2;
        return unary.getOperator() == JsUnaryOperator.VOID;
    }

    @NotNull
    public static JsExpression defineGetter(@NotNull JsExpression receiver2, @NotNull String name, @NotNull JsExpression body) {
        if (receiver2 == null) {
            JsAstUtils.$$$reportNull$$$1(165);
        }
        if (name == null) {
            JsAstUtils.$$$reportNull$$$1(166);
        }
        if (body == null) {
            JsAstUtils.$$$reportNull$$$1(167);
        }
        if (receiver2 == null) {
            JsAstUtils.$$$reportNull$$$0(165);
        }
        if (name == null) {
            JsAstUtils.$$$reportNull$$$0(166);
        }
        if (body == null) {
            JsAstUtils.$$$reportNull$$$0(167);
        }
        JsObjectLiteral propertyLiteral = new JsObjectLiteral(true);
        propertyLiteral.getPropertyInitializers().add(new JsPropertyInitializer(new JsNameRef("get"), body));
        JsInvocation jsInvocation = JsAstUtils.defineProperty(receiver2, name, propertyLiteral);
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$0(168);
        }
        if (jsInvocation == null) {
            JsAstUtils.$$$reportNull$$$1(168);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsExpression prototypeOf(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$1(169);
        }
        if (expression2 == null) {
            JsAstUtils.$$$reportNull$$$0(169);
        }
        JsNameRef jsNameRef = JsAstUtils.pureFqn("prototype", expression2);
        if (jsNameRef == null) {
            JsAstUtils.$$$reportNull$$$0(170);
        }
        if (jsNameRef == null) {
            JsAstUtils.$$$reportNull$$$1(170);
        }
        return jsNameRef;
    }

    @NotNull
    public static JsExpression stateMachineReceiver() {
        JsNameRef result2 = JsAstUtils.pureFqn("$this$", null);
        MetadataProperties.setCoroutineReceiver(result2, true);
        JsNameRef jsNameRef = result2;
        if (jsNameRef == null) {
            JsAstUtils.$$$reportNull$$$0(171);
        }
        if (jsNameRef == null) {
            JsAstUtils.$$$reportNull$$$1(171);
        }
        return jsNameRef;
    }

    static {
        JsNameRef globalObjectReference = new JsNameRef("Object");
        DEFINE_PROPERTY.setQualifier(globalObjectReference);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 55: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 77: 
            case 80: 
            case 85: 
            case 88: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 103: 
            case 106: 
            case 112: 
            case 115: 
            case 118: 
            case 121: 
            case 124: 
            case 127: 
            case 129: 
            case 132: 
            case 134: 
            case 136: 
            case 137: 
            case 139: 
            case 141: 
            case 142: 
            case 146: 
            case 149: 
            case 151: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 161: 
            case 164: 
            case 168: 
            case 170: 
            case 171: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 55: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 77: 
            case 80: 
            case 85: 
            case 88: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 103: 
            case 106: 
            case 112: 
            case 115: 
            case 118: 
            case 121: 
            case 124: 
            case 127: 
            case 129: 
            case 132: 
            case 134: 
            case 136: 
            case 137: 
            case 139: 
            case 141: 
            case 142: 
            case 146: 
            case 149: 
            case 151: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 161: 
            case 164: 
            case 168: 
            case 170: 
            case 171: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsNode";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 55: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 77: 
            case 80: 
            case 85: 
            case 88: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 103: 
            case 106: 
            case 112: 
            case 115: 
            case 118: 
            case 121: 
            case 124: 
            case 127: 
            case 129: 
            case 132: 
            case 134: 
            case 136: 
            case 137: 
            case 139: 
            case 141: 
            case 142: 
            case 146: 
            case 149: 
            case 151: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 161: 
            case 164: 
            case 168: 
            case 170: 
            case 171: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/utils/JsAstUtils";
                break;
            }
            case 6: 
            case 15: 
            case 20: 
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifExpression";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thenStatement";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 21: 
            case 25: 
            case 133: 
            case 144: 
            case 147: 
            case 166: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisObject";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 41: 
            case 43: 
            case 45: 
            case 53: 
            case 56: 
            case 62: 
            case 107: 
            case 128: 
            case 130: 
            case 169: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 35: 
            case 38: 
            case 59: 
            case 101: 
            case 110: 
            case 113: 
            case 116: 
            case 119: 
            case 122: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 36: 
            case 39: 
            case 60: 
            case 102: 
            case 105: 
            case 111: 
            case 114: 
            case 117: 
            case 120: 
            case 123: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 47: 
            case 49: 
            case 51: 
            case 54: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unsignedClassId";
                break;
            }
            case 75: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "op1";
                break;
            }
            case 76: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "op2";
                break;
            }
            case 81: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 83: 
            case 86: 
            case 89: 
            case 92: 
            case 95: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg1";
                break;
            }
            case 84: 
            case 87: 
            case 90: 
            case 93: 
            case 96: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg2";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 108: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 143: 
            case 162: 
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 145: 
            case 148: 
            case 150: 
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 158: 
            case 160: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 167: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/utils/JsAstUtils";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToStatement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToBlock";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "deBlockIfPossible";
                break;
            }
            case 11: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "newJsIf";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeStatementInBlockIfNeeded";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeKotlinFunction";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeMethod";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "toInt32";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "charToInt";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "charToString";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "compareTo";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "primitiveCompareTo";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "longFromInt";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "longFromNumber";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "longToNumber";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "byteToUByte";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "shortToUShort";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "intToUInt";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "longToULong";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "compareForObject";
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "notOptimized";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "and";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "or";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "equality";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "inequality";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "lessThanEq";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "lessThan";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "greaterThan";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "greaterThanEq";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "assignment";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "assignmentToThisField";
                break;
            }
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "sum";
                break;
            }
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "addAssign";
                break;
            }
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "subtract";
                break;
            }
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "mul";
                break;
            }
            case 124: {
                objectArray = objectArray2;
                objectArray2[1] = "div";
                break;
            }
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "mod";
                break;
            }
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "not";
                break;
            }
            case 132: {
                objectArray = objectArray2;
                objectArray2[1] = "typeOfIs";
                break;
            }
            case 134: {
                objectArray = objectArray2;
                objectArray2[1] = "newVar";
                break;
            }
            case 136: 
            case 137: {
                objectArray = objectArray2;
                objectArray2[1] = "newSequence";
                break;
            }
            case 139: {
                objectArray = objectArray2;
                objectArray2[1] = "createFunctionWithEmptyBody";
                break;
            }
            case 141: 
            case 142: {
                objectArray = objectArray2;
                objectArray2[1] = "toStringLiteralList";
                break;
            }
            case 146: {
                objectArray = objectArray2;
                objectArray2[1] = "defineProperty";
                break;
            }
            case 149: {
                objectArray = objectArray2;
                objectArray2[1] = "defineSimpleProperty";
                break;
            }
            case 151: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataDescriptor";
                break;
            }
            case 154: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapValue";
                break;
            }
            case 156: 
            case 157: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenStatement";
                break;
            }
            case 159: 
            case 161: {
                objectArray = objectArray2;
                objectArray2[1] = "pureFqn";
                break;
            }
            case 164: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeBind";
                break;
            }
            case 168: {
                objectArray = objectArray2;
                objectArray2[1] = "defineGetter";
                break;
            }
            case 170: {
                objectArray = objectArray2;
                objectArray2[1] = "prototypeOf";
                break;
            }
            case 171: {
                objectArray = objectArray2;
                objectArray2[1] = "stateMachineReceiver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertToStatement";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 55: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 77: 
            case 80: 
            case 85: 
            case 88: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 103: 
            case 106: 
            case 112: 
            case 115: 
            case 118: 
            case 121: 
            case 124: 
            case 127: 
            case 129: 
            case 132: 
            case 134: 
            case 136: 
            case 137: 
            case 139: 
            case 141: 
            case 142: 
            case 146: 
            case 149: 
            case 151: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 161: 
            case 164: 
            case 168: 
            case 170: 
            case 171: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertToBlock";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deBlockIfPossible";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "newJsIf";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "mergeStatementInBlockIfNeeded";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyStatement";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "invokeKotlinFunction";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "invokeMethod";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "toInt32";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "extractToInt32Argument";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "charToInt";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "charToString";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "primitiveCompareTo";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "longFromInt";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "longFromNumber";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "longToNumber";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "byteToUByte";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "shortToUShort";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "intToUInt";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "longToULong";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "toUnsignedNumber";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "compareForObject";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "notOptimized";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "and";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "or";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "setQualifier";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "setQualifierForNameRef";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "equality";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "inequality";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "lessThanEq";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "lessThan";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "greaterThan";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "greaterThanEq";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "assignment";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "assignmentToThisField";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "asSyntheticStatement";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "decomposeAssignment";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "decomposeAssignmentToVariable";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "sum";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "addAssign";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "subtract";
                break;
            }
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "mul";
                break;
            }
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "div";
                break;
            }
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "mod";
                break;
            }
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "not";
                break;
            }
            case 130: 
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "typeOfIs";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "newVar";
                break;
            }
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "newSequence";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "createFunctionWithEmptyBody";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "toStringLiteralList";
                break;
            }
            case 143: 
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "defineProperty";
                break;
            }
            case 147: 
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "defineSimpleProperty";
                break;
            }
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "createDataDescriptor";
                break;
            }
            case 152: 
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "wrapValue";
                break;
            }
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "flattenStatement";
                break;
            }
            case 158: 
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "pureFqn";
                break;
            }
            case 162: 
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "invokeBind";
                break;
            }
            case 165: 
            case 166: 
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "defineGetter";
                break;
            }
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "prototypeOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 55: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 77: 
            case 80: 
            case 85: 
            case 88: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 103: 
            case 106: 
            case 112: 
            case 115: 
            case 118: 
            case 121: 
            case 124: 
            case 127: 
            case 129: 
            case 132: 
            case 134: 
            case 136: 
            case 137: 
            case 139: 
            case 141: 
            case 142: 
            case 146: 
            case 149: 
            case 151: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 161: 
            case 164: 
            case 168: 
            case 170: 
            case 171: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 55: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 77: 
            case 80: 
            case 85: 
            case 88: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 103: 
            case 106: 
            case 112: 
            case 115: 
            case 118: 
            case 121: 
            case 124: 
            case 127: 
            case 129: 
            case 132: 
            case 134: 
            case 136: 
            case 137: 
            case 139: 
            case 141: 
            case 142: 
            case 146: 
            case 149: 
            case 151: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 161: 
            case 164: 
            case 168: 
            case 170: 
            case 171: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 55: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 77: 
            case 80: 
            case 85: 
            case 88: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 103: 
            case 106: 
            case 112: 
            case 115: 
            case 118: 
            case 121: 
            case 124: 
            case 127: 
            case 129: 
            case 132: 
            case 134: 
            case 136: 
            case 137: 
            case 139: 
            case 141: 
            case 142: 
            case 146: 
            case 149: 
            case 151: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 161: 
            case 164: 
            case 168: 
            case 170: 
            case 171: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsNode";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 55: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 77: 
            case 80: 
            case 85: 
            case 88: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 103: 
            case 106: 
            case 112: 
            case 115: 
            case 118: 
            case 121: 
            case 124: 
            case 127: 
            case 129: 
            case 132: 
            case 134: 
            case 136: 
            case 137: 
            case 139: 
            case 141: 
            case 142: 
            case 146: 
            case 149: 
            case 151: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 161: 
            case 164: 
            case 168: 
            case 170: 
            case 171: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/utils/JsAstUtils";
                break;
            }
            case 6: 
            case 15: 
            case 20: 
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifExpression";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thenStatement";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 21: 
            case 25: 
            case 133: 
            case 144: 
            case 147: 
            case 166: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisObject";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 41: 
            case 43: 
            case 45: 
            case 53: 
            case 56: 
            case 62: 
            case 107: 
            case 128: 
            case 130: 
            case 169: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 35: 
            case 38: 
            case 59: 
            case 101: 
            case 110: 
            case 113: 
            case 116: 
            case 119: 
            case 122: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 36: 
            case 39: 
            case 60: 
            case 102: 
            case 105: 
            case 111: 
            case 114: 
            case 117: 
            case 120: 
            case 123: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 47: 
            case 49: 
            case 51: 
            case 54: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unsignedClassId";
                break;
            }
            case 75: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "op1";
                break;
            }
            case 76: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "op2";
                break;
            }
            case 81: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 83: 
            case 86: 
            case 89: 
            case 92: 
            case 95: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg1";
                break;
            }
            case 84: 
            case 87: 
            case 90: 
            case 93: 
            case 96: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg2";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 108: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 143: 
            case 162: 
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 145: 
            case 148: 
            case 150: 
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 158: 
            case 160: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 167: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/utils/JsAstUtils";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToStatement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToBlock";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "deBlockIfPossible";
                break;
            }
            case 11: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "newJsIf";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeStatementInBlockIfNeeded";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeKotlinFunction";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeMethod";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "toInt32";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "charToInt";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "charToString";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "compareTo";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "primitiveCompareTo";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "longFromInt";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "longFromNumber";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "longToNumber";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "byteToUByte";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "shortToUShort";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "intToUInt";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "longToULong";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "compareForObject";
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "notOptimized";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "and";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "or";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "equality";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "inequality";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "lessThanEq";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "lessThan";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "greaterThan";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "greaterThanEq";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "assignment";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "assignmentToThisField";
                break;
            }
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "sum";
                break;
            }
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "addAssign";
                break;
            }
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "subtract";
                break;
            }
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "mul";
                break;
            }
            case 124: {
                objectArray = objectArray2;
                objectArray2[1] = "div";
                break;
            }
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "mod";
                break;
            }
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "not";
                break;
            }
            case 132: {
                objectArray = objectArray2;
                objectArray2[1] = "typeOfIs";
                break;
            }
            case 134: {
                objectArray = objectArray2;
                objectArray2[1] = "newVar";
                break;
            }
            case 136: 
            case 137: {
                objectArray = objectArray2;
                objectArray2[1] = "newSequence";
                break;
            }
            case 139: {
                objectArray = objectArray2;
                objectArray2[1] = "createFunctionWithEmptyBody";
                break;
            }
            case 141: 
            case 142: {
                objectArray = objectArray2;
                objectArray2[1] = "toStringLiteralList";
                break;
            }
            case 146: {
                objectArray = objectArray2;
                objectArray2[1] = "defineProperty";
                break;
            }
            case 149: {
                objectArray = objectArray2;
                objectArray2[1] = "defineSimpleProperty";
                break;
            }
            case 151: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataDescriptor";
                break;
            }
            case 154: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapValue";
                break;
            }
            case 156: 
            case 157: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenStatement";
                break;
            }
            case 159: 
            case 161: {
                objectArray = objectArray2;
                objectArray2[1] = "pureFqn";
                break;
            }
            case 164: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeBind";
                break;
            }
            case 168: {
                objectArray = objectArray2;
                objectArray2[1] = "defineGetter";
                break;
            }
            case 170: {
                objectArray = objectArray2;
                objectArray2[1] = "prototypeOf";
                break;
            }
            case 171: {
                objectArray = objectArray2;
                objectArray2[1] = "stateMachineReceiver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertToStatement";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 55: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 77: 
            case 80: 
            case 85: 
            case 88: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 103: 
            case 106: 
            case 112: 
            case 115: 
            case 118: 
            case 121: 
            case 124: 
            case 127: 
            case 129: 
            case 132: 
            case 134: 
            case 136: 
            case 137: 
            case 139: 
            case 141: 
            case 142: 
            case 146: 
            case 149: 
            case 151: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 161: 
            case 164: 
            case 168: 
            case 170: 
            case 171: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertToBlock";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deBlockIfPossible";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "newJsIf";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "mergeStatementInBlockIfNeeded";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyStatement";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "invokeKotlinFunction";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "invokeMethod";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "toInt32";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "extractToInt32Argument";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "charToInt";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "charToString";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "primitiveCompareTo";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "longFromInt";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "longFromNumber";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "longToNumber";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "byteToUByte";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "shortToUShort";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "intToUInt";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "longToULong";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "toUnsignedNumber";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "compareForObject";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "notOptimized";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "and";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "or";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "setQualifier";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "setQualifierForNameRef";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "equality";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "inequality";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "lessThanEq";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "lessThan";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "greaterThan";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "greaterThanEq";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "assignment";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "assignmentToThisField";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "asSyntheticStatement";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "decomposeAssignment";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "decomposeAssignmentToVariable";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "sum";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "addAssign";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "subtract";
                break;
            }
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "mul";
                break;
            }
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "div";
                break;
            }
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "mod";
                break;
            }
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "not";
                break;
            }
            case 130: 
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "typeOfIs";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "newVar";
                break;
            }
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "newSequence";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "createFunctionWithEmptyBody";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "toStringLiteralList";
                break;
            }
            case 143: 
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "defineProperty";
                break;
            }
            case 147: 
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "defineSimpleProperty";
                break;
            }
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "createDataDescriptor";
                break;
            }
            case 152: 
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "wrapValue";
                break;
            }
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "flattenStatement";
                break;
            }
            case 158: 
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "pureFqn";
                break;
            }
            case 162: 
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "invokeBind";
                break;
            }
            case 165: 
            case 166: 
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "defineGetter";
                break;
            }
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "prototypeOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 55: 
            case 61: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 77: 
            case 80: 
            case 85: 
            case 88: 
            case 91: 
            case 94: 
            case 97: 
            case 100: 
            case 103: 
            case 106: 
            case 112: 
            case 115: 
            case 118: 
            case 121: 
            case 124: 
            case 127: 
            case 129: 
            case 132: 
            case 134: 
            case 136: 
            case 137: 
            case 139: 
            case 141: 
            case 142: 
            case 146: 
            case 149: 
            case 151: 
            case 154: 
            case 156: 
            case 157: 
            case 159: 
            case 161: 
            case 164: 
            case 168: 
            case 170: 
            case 171: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

