#
# Copyright (C) 2004-2016 ZNC, see the NOTICE file for details.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

include("${CMAKE_CURRENT_LIST_DIR}/znc_internal.cmake")
include("${CMAKE_CURRENT_LIST_DIR}/znc_public.cmake")
include(CMakeParseArguments)

# For some reason cygwin fails to build modules if Threads::Threads
# is not found.
if(NOT CYGWIN)
	set(ZNC_NO_INCLUDE_THREADS true)
endif()

if(NOT ZNC_NO_INCLUDE_THREADS)
	set(CMAKE_THREAD_PREFER_PTHREAD true)
	set(THREADS_PREFER_PTHREAD_FLAG true)
	find_package(Threads REQUIRED)
	if(NOT CMAKE_USE_PTHREADS_INIT)
		message(FATAL_ERROR "This compiler/OS doesn't seem "
			"to support pthreads.")
	endif()
endif()

function(znc_setup_module)
	cmake_parse_arguments(znc_mod "" "TARGET;NAME" "" ${ARGN})
	set_target_properties("${znc_mod_TARGET}" PROPERTIES
		OUTPUT_NAME "${znc_mod_NAME}"
		PREFIX ""
		SUFFIX ".so"
		NO_SONAME true
		CXX_VISIBILITY_PRESET "hidden")
	target_link_libraries("${znc_mod_TARGET}" PRIVATE ZNC::ZNC)
endfunction()

message(STATUS "Found ZNC 1.7.3")
