/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.LinkedList;
import org.apache.fop.layoutmgr.AbstractLayoutManager;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceResolver;

public final class AreaAdditionUtil {
    private AreaAdditionUtil() {
    }

    public static void addAreas(AbstractLayoutManager parentLM, PositionIterator parentIter, LayoutContext layoutContext) {
        LayoutManager childLM;
        LayoutContext lc = LayoutContext.offspringOf(layoutContext);
        LayoutManager firstLM = null;
        LayoutManager lastLM = null;
        Position firstPos = null;
        Position lastPos = null;
        if (parentLM != null) {
            parentLM.addId();
        }
        LinkedList<Position> positionList = new LinkedList<Position>();
        while (parentIter.hasNext()) {
            Position pos = parentIter.next();
            if (pos == null) continue;
            if (pos.getIndex() >= 0) {
                if (firstPos == null) {
                    firstPos = pos;
                }
                lastPos = pos;
            }
            if (pos instanceof NonLeafPosition) {
                positionList.add(pos.getPosition());
                lastLM = pos.getPosition().getLM();
                if (firstLM != null) continue;
                firstLM = lastLM;
                continue;
            }
            if (!(pos instanceof SpaceResolver.SpaceHandlingBreakPosition)) continue;
            positionList.add(pos);
        }
        if (firstPos == null) {
            return;
        }
        if (parentLM != null) {
            parentLM.registerMarkers(true, parentLM.isFirst(firstPos), parentLM.isLast(lastPos));
        }
        PositionIterator childPosIter = new PositionIterator(positionList.listIterator());
        while ((childLM = childPosIter.getNextChildLM()) != null) {
            lc.setFlags(4, childLM == firstLM);
            lc.setFlags(8, childLM == lastLM);
            lc.setSpaceAdjust(layoutContext.getSpaceAdjust());
            lc.setSpaceBefore(childLM == firstLM ? layoutContext.getSpaceBefore() : 0);
            lc.setSpaceAfter(layoutContext.getSpaceAfter());
            lc.setStackLimitBP(layoutContext.getStackLimitBP());
            childLM.addAreas(childPosIter, lc);
        }
        if (parentLM != null) {
            parentLM.registerMarkers(false, parentLM.isFirst(firstPos), parentLM.isLast(lastPos));
        }
    }
}

