/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.protege.editor.core.ui.util.Icons;
import org.protege.editor.owl.ui.util.ProgressView;

public class ProgressViewImpl
extends JPanel
implements ProgressView {
    private final JLabel messageLabel = new JLabel();
    private final JLabel subMessageLabel = new JLabel();

    public ProgressViewImpl() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JPanel holder = new JPanel(new GridBagLayout());
        this.add((Component)holder, "North");
        Insets insets = new Insets(0, 0, 0, 0);
        JLabel iconLabel = new JLabel();
        iconLabel.setPreferredSize(new Dimension(48, 48));
        iconLabel.setIcon(Icons.getIcon((String)"logo.48x48.png"));
        holder.add((Component)iconLabel, new GridBagConstraints(0, 1, 1, 3, 0.0, 0.0, 10, 3, new Insets(0, 0, 0, 10), 0, 0));
        this.messageLabel.setFont(this.messageLabel.getFont().deriveFont(1));
        FontMetrics fm = this.getFontMetrics(this.messageLabel.getFont());
        Dimension labelMinSize = new Dimension(500, fm.getHeight() + 2);
        this.messageLabel.setPreferredSize(labelMinSize);
        holder.add((Component)this.messageLabel, new GridBagConstraints(1, 1, 1, 1, 100.0, 0.0, 15, 2, insets, 0, 0));
        JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        holder.add((Component)progressBar, new GridBagConstraints(1, 2, 1, 1, 100.0, 0.0, 10, 2, new Insets(4, 0, 2, 0), 0, 0));
        this.subMessageLabel.setFont(this.subMessageLabel.getFont().deriveFont(10.0f));
        this.subMessageLabel.setMinimumSize(labelMinSize);
        this.subMessageLabel.setPreferredSize(labelMinSize);
        holder.add((Component)this.subMessageLabel, new GridBagConstraints(1, 3, 1, 1, 100.0, 0.0, 11, 2, insets, 0, 0));
    }

    @Override
    public void setMessage(String message) {
        this.messageLabel.setText(String.format(message, new Object[0]));
    }

    @Override
    public void setSubMessage(String subMessage) {
        this.subMessageLabel.setText(subMessage);
    }

    @Override
    public JComponent asJComponent() {
        return this;
    }

    @Override
    public void clearSubMessage() {
        this.subMessageLabel.setText("");
    }
}

