/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.upgrade;

import java.io.EOFException;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.coyote.http11.upgrade.AbstractServletInputStream;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.OS;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.util.net.SocketWrapper;

public class AprServletInputStream
extends AbstractServletInputStream {
    private static final Log log = LogFactory.getLog(AprServletInputStream.class);
    private final SocketWrapper<Long> wrapper;
    private final long socket;
    private volatile boolean eagain = false;
    private volatile boolean closed = false;

    public AprServletInputStream(SocketWrapper<Long> wrapper) {
        this.wrapper = wrapper;
        this.socket = wrapper.getSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doRead(boolean block, byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException(sm.getString("apr.closed", new Object[]{this.socket}));
        }
        Lock readLock = this.wrapper.getBlockingStatusReadLock();
        ReentrantReadWriteLock.WriteLock writeLock = this.wrapper.getBlockingStatusWriteLock();
        boolean readDone = false;
        int result = 0;
        try {
            readLock.lock();
            if (this.wrapper.getBlockingStatus() == block) {
                result = Socket.recv(this.socket, b, off, len);
                readDone = true;
            }
        }
        finally {
            readLock.unlock();
        }
        if (!readDone) {
            try {
                writeLock.lock();
                this.wrapper.setBlockingStatus(block);
                Socket.optSet(this.socket, 8, block ? 0 : 1);
                try {
                    readLock.lock();
                    writeLock.unlock();
                    result = Socket.recv(this.socket, b, off, len);
                }
                finally {
                    readLock.unlock();
                }
            }
            finally {
                if (writeLock.isHeldByCurrentThread()) {
                    writeLock.unlock();
                }
            }
        }
        if (result > 0) {
            this.eagain = false;
            return result;
        }
        if (-result == 120002) {
            this.eagain = true;
            return 0;
        }
        if (-result == 20014 && this.wrapper.isSecure()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("apr.read.sslGeneralError", new Object[]{this.socket, this.wrapper}));
            }
            this.eagain = true;
            return 0;
        }
        if (-result == 70014) {
            throw new EOFException(sm.getString("apr.clientAbort"));
        }
        if ((OS.IS_WIN32 || OS.IS_WIN64) && -result == 730053) {
            throw new EOFException(sm.getString("apr.clientAbort"));
        }
        throw new IOException(sm.getString("apr.read.error", new Object[]{-result, this.socket, this.wrapper}));
    }

    @Override
    protected boolean doIsReady() {
        return !this.eagain;
    }

    @Override
    protected void doClose() throws IOException {
        this.closed = true;
    }
}

