/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.flow;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.TryFlowContext;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class FinallyFlowContext
extends TryFlowContext {
    Reference[] finalAssignments;
    VariableBinding[] finalVariables;
    int assignCount;
    LocalVariableBinding[] nullLocals;
    ASTNode[] nullReferences;
    int[] nullCheckTypes;
    int nullCount;
    public FlowContext tryContext;

    public FinallyFlowContext(FlowContext flowContext, ASTNode aSTNode, ExceptionHandlingFlowContext exceptionHandlingFlowContext) {
        super(flowContext, aSTNode);
        this.tryContext = exceptionHandlingFlowContext;
    }

    public void complainOnDeferredChecks(FlowInfo flowInfo, BlockScope blockScope) {
        TypeConstants typeConstants;
        int n;
        Object object;
        int n2;
        for (n2 = 0; n2 < this.assignCount; ++n2) {
            object = this.finalVariables[n2];
            if (object == null) continue;
            n = 0;
            if (object instanceof FieldBinding) {
                if (flowInfo.isPotentiallyAssigned((FieldBinding)object)) {
                    n = 1;
                    blockScope.problemReporter().duplicateInitializationOfBlankFinalField((FieldBinding)object, this.finalAssignments[n2]);
                }
            } else if (flowInfo.isPotentiallyAssigned((LocalVariableBinding)object)) {
                ((VariableBinding)object).tagBits &= 0xFFFFFFFFFFFFF7FFL;
                if (((VariableBinding)object).isFinal()) {
                    n = 1;
                    blockScope.problemReporter().duplicateInitializationOfFinalLocal((LocalVariableBinding)object, this.finalAssignments[n2]);
                }
            }
            if (n == 0) continue;
            for (typeConstants = this.getLocalParent(); typeConstants != null; typeConstants = typeConstants.getLocalParent()) {
                typeConstants.removeFinalAssignmentIfAny(this.finalAssignments[n2]);
            }
        }
        if ((this.tagBits & 1) != 0) {
            block23: for (n2 = 0; n2 < this.nullCount; ++n2) {
                object = this.nullReferences[n2];
                switch (this.nullCheckTypes[n2] & 0xFFFF0FFF) {
                    case 128: {
                        n = flowInfo.nullStatus(this.nullLocals[n2]);
                        if (n == 4) continue block23;
                        this.parent.recordNullityMismatch(blockScope, (Expression)object, this.providedExpectedTypes[n2][0], this.providedExpectedTypes[n2][1], flowInfo, n, null);
                        continue block23;
                    }
                    case 16: {
                        this.checkUnboxing(blockScope, (Expression)object, flowInfo);
                        continue block23;
                    }
                    default: {
                        this.parent.recordUsingNullReference(blockScope, this.nullLocals[n2], this.nullReferences[n2], this.nullCheckTypes[n2], flowInfo);
                    }
                }
            }
        } else {
            block24: for (n2 = 0; n2 < this.nullCount; ++n2) {
                object = this.nullReferences[n2];
                LocalVariableBinding localVariableBinding = this.nullLocals[n2];
                switch (this.nullCheckTypes[n2] & 0xFFFF0FFF) {
                    case 256: 
                    case 512: {
                        if (flowInfo.isDefinitelyNonNull(localVariableBinding)) {
                            if ((this.nullCheckTypes[n2] & 0xFFFF0FFF) == 512) {
                                if ((this.nullCheckTypes[n2] & 0x1000) != 0) continue block24;
                                blockScope.problemReporter().localVariableRedundantCheckOnNonNull(localVariableBinding, (ASTNode)object);
                                continue block24;
                            }
                            blockScope.problemReporter().localVariableNonNullComparedToNull(localVariableBinding, (ASTNode)object);
                            continue block24;
                        }
                    }
                    case 257: 
                    case 513: 
                    case 769: 
                    case 1025: {
                        typeConstants = (Expression)object;
                        if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                            switch (this.nullCheckTypes[n2] & 0xFFFF0F00) {
                                case 256: {
                                    if ((this.nullCheckTypes[n2] & 0xFF & 0xFFFF0FFF) == 1 && (((Expression)typeConstants).implicitConversion & 0x400) != 0) {
                                        blockScope.problemReporter().localVariableNullReference(localVariableBinding, (ASTNode)typeConstants);
                                        continue block24;
                                    }
                                    if ((this.nullCheckTypes[n2] & 0x1000) != 0) continue block24;
                                    blockScope.problemReporter().localVariableRedundantCheckOnNull(localVariableBinding, (ASTNode)typeConstants);
                                    continue block24;
                                }
                                case 512: {
                                    if ((this.nullCheckTypes[n2] & 0xFF & 0xFFFF0FFF) == 1 && (((Expression)typeConstants).implicitConversion & 0x400) != 0) {
                                        blockScope.problemReporter().localVariableNullReference(localVariableBinding, (ASTNode)typeConstants);
                                        continue block24;
                                    }
                                    blockScope.problemReporter().localVariableNullComparedToNonNull(localVariableBinding, (ASTNode)typeConstants);
                                    continue block24;
                                }
                                case 768: {
                                    blockScope.problemReporter().localVariableRedundantNullAssignment(localVariableBinding, (ASTNode)typeConstants);
                                    continue block24;
                                }
                                case 1024: {
                                    blockScope.problemReporter().localVariableNullInstanceof(localVariableBinding, (ASTNode)typeConstants);
                                    continue block24;
                                }
                            }
                            continue block24;
                        }
                        if (!flowInfo.isPotentiallyNull(localVariableBinding)) continue block24;
                        switch (this.nullCheckTypes[n2] & 0xFFFF0F00) {
                            case 256: {
                                this.nullReferences[n2] = null;
                                if ((this.nullCheckTypes[n2] & 0xFF & 0xFFFF0FFF) != 1 || (((Expression)typeConstants).implicitConversion & 0x400) == 0) break;
                                blockScope.problemReporter().localVariablePotentialNullReference(localVariableBinding, (ASTNode)typeConstants);
                                break;
                            }
                            case 512: {
                                this.nullReferences[n2] = null;
                                if ((this.nullCheckTypes[n2] & 0xFF & 0xFFFF0FFF) != 1 || (((Expression)typeConstants).implicitConversion & 0x400) == 0) break;
                                blockScope.problemReporter().localVariablePotentialNullReference(localVariableBinding, (ASTNode)typeConstants);
                                break;
                            }
                        }
                        continue block24;
                    }
                    case 3: {
                        if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                            blockScope.problemReporter().localVariableNullReference(localVariableBinding, (ASTNode)object);
                            continue block24;
                        }
                        if (!flowInfo.isPotentiallyNull(localVariableBinding)) continue block24;
                        blockScope.problemReporter().localVariablePotentialNullReference(localVariableBinding, (ASTNode)object);
                        continue block24;
                    }
                    case 128: {
                        int n3 = flowInfo.nullStatus(localVariableBinding);
                        if (n3 == 4) continue block24;
                        char[][] cArray = blockScope.environment().getNonNullAnnotationName();
                        blockScope.problemReporter().nullityMismatch((Expression)object, this.providedExpectedTypes[n2][0], this.providedExpectedTypes[n2][1], n3, cArray);
                        continue block24;
                    }
                    case 16: {
                        this.checkUnboxing(blockScope, (Expression)object, flowInfo);
                        continue block24;
                    }
                }
            }
        }
    }

    @Override
    public String individualToString() {
        StringBuffer stringBuffer = new StringBuffer("Finally flow context");
        stringBuffer.append("[finalAssignments count - ").append(this.assignCount).append(']');
        stringBuffer.append("[nullReferences count - ").append(this.nullCount).append(']');
        return stringBuffer.toString();
    }

    @Override
    public boolean isSubRoutine() {
        return true;
    }

    @Override
    protected boolean recordFinalAssignment(VariableBinding variableBinding, Reference reference) {
        if (this.assignCount == 0) {
            this.finalAssignments = new Reference[5];
            this.finalVariables = new VariableBinding[5];
        } else {
            if (this.assignCount == this.finalAssignments.length) {
                this.finalAssignments = new Reference[this.assignCount * 2];
                System.arraycopy(this.finalAssignments, 0, this.finalAssignments, 0, this.assignCount);
            }
            this.finalVariables = new VariableBinding[this.assignCount * 2];
            System.arraycopy(this.finalVariables, 0, this.finalVariables, 0, this.assignCount);
        }
        this.finalAssignments[this.assignCount] = reference;
        this.finalVariables[this.assignCount++] = variableBinding;
        return true;
    }

    @Override
    public void recordUsingNullReference(Scope scope, LocalVariableBinding localVariableBinding, ASTNode aSTNode, int n, FlowInfo flowInfo) {
        block51: {
            block53: {
                int n2;
                block52: {
                    if ((flowInfo.tagBits & 3) != 0 || flowInfo.isDefinitelyUnknown(localVariableBinding)) break block51;
                    n2 = (n |= this.tagBits & 0x1000) & 0xFFFF0FFF;
                    if ((this.tagBits & 1) == 0) break block52;
                    switch (n2) {
                        case 256: 
                        case 257: 
                        case 512: 
                        case 513: 
                        case 769: 
                        case 1025: {
                            Expression expression = (Expression)aSTNode;
                            if (flowInfo.cannotBeNull(localVariableBinding)) {
                                if (n2 == 512) {
                                    if ((n & 0x1000) == 0) {
                                        scope.problemReporter().localVariableRedundantCheckOnNonNull(localVariableBinding, expression);
                                    }
                                    flowInfo.initsWhenFalse().setReachMode(2);
                                } else if (n2 == 256) {
                                    scope.problemReporter().localVariableNonNullComparedToNull(localVariableBinding, expression);
                                    flowInfo.initsWhenTrue().setReachMode(2);
                                }
                                return;
                            }
                            if (flowInfo.canOnlyBeNull(localVariableBinding)) {
                                switch (n2 & 0xFFFF0F00) {
                                    case 256: {
                                        if ((n2 & 0xFF) == 1 && (expression.implicitConversion & 0x400) != 0) {
                                            scope.problemReporter().localVariableNullReference(localVariableBinding, expression);
                                            return;
                                        }
                                        if ((n & 0x1000) == 0) {
                                            scope.problemReporter().localVariableRedundantCheckOnNull(localVariableBinding, expression);
                                        }
                                        flowInfo.initsWhenFalse().setReachMode(2);
                                        return;
                                    }
                                    case 512: {
                                        if ((n2 & 0xFF) == 1 && (expression.implicitConversion & 0x400) != 0) {
                                            scope.problemReporter().localVariableNullReference(localVariableBinding, expression);
                                            return;
                                        }
                                        scope.problemReporter().localVariableNullComparedToNonNull(localVariableBinding, expression);
                                        flowInfo.initsWhenTrue().setReachMode(2);
                                        return;
                                    }
                                    case 768: {
                                        scope.problemReporter().localVariableRedundantNullAssignment(localVariableBinding, expression);
                                        return;
                                    }
                                    case 1024: {
                                        scope.problemReporter().localVariableNullInstanceof(localVariableBinding, expression);
                                        return;
                                    }
                                }
                                break;
                            }
                            if (flowInfo.isPotentiallyNull(localVariableBinding)) {
                                switch (n2 & 0xFFFF0F00) {
                                    case 256: {
                                        if ((n2 & 0xFF) != 1 || (expression.implicitConversion & 0x400) == 0) break;
                                        scope.problemReporter().localVariablePotentialNullReference(localVariableBinding, expression);
                                        return;
                                    }
                                    case 512: {
                                        if ((n2 & 0xFF) != 1 || (expression.implicitConversion & 0x400) == 0) break;
                                        scope.problemReporter().localVariablePotentialNullReference(localVariableBinding, expression);
                                        return;
                                    }
                                }
                                break;
                            }
                            break block53;
                        }
                        case 3: {
                            if (flowInfo.cannotBeNull(localVariableBinding)) {
                                return;
                            }
                            if (flowInfo.canOnlyBeNull(localVariableBinding)) {
                                scope.problemReporter().localVariableNullReference(localVariableBinding, aSTNode);
                                return;
                            }
                            break block53;
                        }
                    }
                    break block53;
                }
                switch (n2) {
                    case 256: 
                    case 512: {
                        if (flowInfo.isDefinitelyNonNull(localVariableBinding)) {
                            if (n2 == 512) {
                                if ((n & 0x1000) == 0) {
                                    scope.problemReporter().localVariableRedundantCheckOnNonNull(localVariableBinding, aSTNode);
                                }
                                flowInfo.initsWhenFalse().setReachMode(2);
                            } else {
                                scope.problemReporter().localVariableNonNullComparedToNull(localVariableBinding, aSTNode);
                                flowInfo.initsWhenTrue().setReachMode(2);
                            }
                            return;
                        }
                    }
                    case 257: 
                    case 513: 
                    case 769: 
                    case 1025: {
                        Expression expression = (Expression)aSTNode;
                        if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                            switch (n2 & 0xFFFF0F00) {
                                case 256: {
                                    if ((n2 & 0xFF) == 1 && (expression.implicitConversion & 0x400) != 0) {
                                        scope.problemReporter().localVariableNullReference(localVariableBinding, expression);
                                        return;
                                    }
                                    if ((n & 0x1000) == 0) {
                                        scope.problemReporter().localVariableRedundantCheckOnNull(localVariableBinding, expression);
                                    }
                                    flowInfo.initsWhenFalse().setReachMode(2);
                                    return;
                                }
                                case 512: {
                                    if ((n2 & 0xFF) == 1 && (expression.implicitConversion & 0x400) != 0) {
                                        scope.problemReporter().localVariableNullReference(localVariableBinding, expression);
                                        return;
                                    }
                                    scope.problemReporter().localVariableNullComparedToNonNull(localVariableBinding, expression);
                                    flowInfo.initsWhenTrue().setReachMode(2);
                                    return;
                                }
                                case 768: {
                                    scope.problemReporter().localVariableRedundantNullAssignment(localVariableBinding, expression);
                                    return;
                                }
                                case 1024: {
                                    scope.problemReporter().localVariableNullInstanceof(localVariableBinding, expression);
                                    return;
                                }
                            }
                            break;
                        }
                        if (!flowInfo.isPotentiallyNull(localVariableBinding)) break;
                        switch (n2 & 0xFFFF0F00) {
                            case 256: {
                                if ((n2 & 0xFF) != 1 || (expression.implicitConversion & 0x400) == 0) break;
                                scope.problemReporter().localVariablePotentialNullReference(localVariableBinding, expression);
                                return;
                            }
                            case 512: {
                                if ((n2 & 0xFF) != 1 || (expression.implicitConversion & 0x400) == 0) break;
                                scope.problemReporter().localVariablePotentialNullReference(localVariableBinding, expression);
                                return;
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                            scope.problemReporter().localVariableNullReference(localVariableBinding, aSTNode);
                            return;
                        }
                        if (flowInfo.isPotentiallyNull(localVariableBinding)) {
                            scope.problemReporter().localVariablePotentialNullReference(localVariableBinding, aSTNode);
                            return;
                        }
                        if (!flowInfo.isDefinitelyNonNull(localVariableBinding)) break;
                        return;
                    }
                }
            }
            this.recordNullReference(localVariableBinding, aSTNode, n, flowInfo);
        }
    }

    @Override
    void removeFinalAssignmentIfAny(Reference reference) {
        for (int i = 0; i < this.assignCount; ++i) {
            if (this.finalAssignments[i] != reference) continue;
            this.finalAssignments[i] = null;
            this.finalVariables[i] = null;
            return;
        }
    }

    @Override
    protected void recordNullReference(LocalVariableBinding localVariableBinding, ASTNode aSTNode, int n, FlowInfo flowInfo) {
        if (this.nullCount == 0) {
            this.nullLocals = new LocalVariableBinding[5];
            this.nullReferences = new ASTNode[5];
            this.nullCheckTypes = new int[5];
        } else if (this.nullCount == this.nullLocals.length) {
            int n2 = this.nullCount * 2;
            this.nullLocals = new LocalVariableBinding[n2];
            System.arraycopy(this.nullLocals, 0, this.nullLocals, 0, this.nullCount);
            this.nullReferences = new ASTNode[n2];
            System.arraycopy(this.nullReferences, 0, this.nullReferences, 0, this.nullCount);
            this.nullCheckTypes = new int[n2];
            System.arraycopy(this.nullCheckTypes, 0, this.nullCheckTypes, 0, this.nullCount);
        }
        this.nullLocals[this.nullCount] = localVariableBinding;
        this.nullReferences[this.nullCount] = aSTNode;
        this.nullCheckTypes[this.nullCount++] = n;
    }

    @Override
    public void recordUnboxing(Scope scope, Expression expression, int n, FlowInfo flowInfo) {
        if (n == 2) {
            super.recordUnboxing(scope, expression, n, flowInfo);
        } else {
            this.recordNullReference(null, expression, 16, flowInfo);
        }
    }

    @Override
    protected boolean internalRecordNullityMismatch(Expression expression, TypeBinding typeBinding, FlowInfo flowInfo, int n, TypeBinding typeBinding2, int n2) {
        if (n == 1 || (this.tagBits & 1) != 0 && n != 2) {
            this.recordProvidedExpectedTypes(typeBinding, typeBinding2, this.nullCount);
            this.recordNullReference(expression.localVariableBinding(), expression, n2, flowInfo);
            return true;
        }
        return false;
    }
}

