/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.core.conf;

import com.mysql.cj.api.conf.PropertyDefinition;
import com.mysql.cj.api.conf.RuntimeProperty;
import com.mysql.cj.api.exceptions.ExceptionInterceptor;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.naming.RefAddr;
import javax.naming.Reference;

public abstract class AbstractRuntimeProperty<T>
implements RuntimeProperty<T>,
Serializable {
    private static final long serialVersionUID = -3424722534876438236L;
    private PropertyDefinition<T> propertyDefinition;
    protected T valueAsObject;
    protected T initialValueAsObject;
    protected boolean wasExplicitlySet = false;
    private List<WeakReference<RuntimeProperty.RuntimePropertyListener>> listeners;

    public AbstractRuntimeProperty() {
    }

    protected AbstractRuntimeProperty(PropertyDefinition<T> propertyDefinition) {
        this.propertyDefinition = propertyDefinition;
        this.valueAsObject = this.getPropertyDefinition().getDefaultValue();
    }

    @Override
    public PropertyDefinition<T> getPropertyDefinition() {
        return this.propertyDefinition;
    }

    @Override
    public void initializeFrom(Properties extractFrom, ExceptionInterceptor exceptionInterceptor) {
        String extractedValue = extractFrom.getProperty(this.getPropertyDefinition().getName());
        extractFrom.remove(this.getPropertyDefinition().getName());
        this.initializeFrom(extractedValue, exceptionInterceptor);
    }

    @Override
    public void initializeFrom(Reference ref, ExceptionInterceptor exceptionInterceptor) {
        RefAddr refAddr = ref.get(this.getPropertyDefinition().getName());
        if (refAddr != null) {
            String refContentAsString = (String)refAddr.getContent();
            this.initializeFrom(refContentAsString, exceptionInterceptor);
        }
    }

    protected void initializeFrom(String extractedValue, ExceptionInterceptor exceptionInterceptor) {
        if (extractedValue != null) {
            this.setFromString(extractedValue, exceptionInterceptor);
        }
    }

    public void setFromString(String value, ExceptionInterceptor exceptionInterceptor) {
        this.valueAsObject = this.getPropertyDefinition().parseObject(value, exceptionInterceptor);
        this.wasExplicitlySet = true;
    }

    @Override
    public void resetValue() {
    }

    @Override
    public boolean isExplicitlySet() {
        return this.wasExplicitlySet;
    }

    @Override
    public void addListener(RuntimeProperty.RuntimePropertyListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<WeakReference<RuntimeProperty.RuntimePropertyListener>>();
        }
        if (!this.listeners.contains(l)) {
            this.listeners.add(new WeakReference<RuntimeProperty.RuntimePropertyListener>(l));
        }
    }

    @Override
    public void removeListener(RuntimeProperty.RuntimePropertyListener listener) {
        if (this.listeners != null) {
            for (WeakReference<RuntimeProperty.RuntimePropertyListener> wr : this.listeners) {
                RuntimeProperty.RuntimePropertyListener l = (RuntimeProperty.RuntimePropertyListener)wr.get();
                if (l != listener) continue;
                this.listeners.remove(wr);
                break;
            }
        }
    }

    protected void invokeListeners() {
        if (this.listeners != null) {
            for (WeakReference<RuntimeProperty.RuntimePropertyListener> wr : this.listeners) {
                RuntimeProperty.RuntimePropertyListener l = (RuntimeProperty.RuntimePropertyListener)wr.get();
                if (l != null) {
                    l.handlePropertyChange(this);
                    continue;
                }
                this.listeners.remove(wr);
            }
        }
    }
}

