/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.AbstractUploadDialog;
import org.openstreetmap.josm.gui.io.BasicUploadSettingsPanel;
import org.openstreetmap.josm.gui.io.ChangesetCommentModel;
import org.openstreetmap.josm.gui.io.ChangesetManagementPanel;
import org.openstreetmap.josm.gui.io.ChangesetReviewModel;
import org.openstreetmap.josm.gui.io.ConfigurationParameterRequestHandler;
import org.openstreetmap.josm.gui.io.IUploadDialog;
import org.openstreetmap.josm.gui.io.TagSettingsPanel;
import org.openstreetmap.josm.gui.io.UploadParameterSummaryPanel;
import org.openstreetmap.josm.gui.io.UploadStrategySelectionPanel;
import org.openstreetmap.josm.gui.io.UploadedObjectsSummaryPanel;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.MultiLineFlowLayout;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.UploadStrategy;
import org.openstreetmap.josm.io.UploadStrategySpecification;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.PreferenceChangeEvent;
import org.openstreetmap.josm.spi.preferences.PreferenceChangedListener;
import org.openstreetmap.josm.spi.preferences.Setting;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageOverlay;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.Utils;

public class UploadDialog
extends AbstractUploadDialog
implements PropertyChangeListener,
PreferenceChangedListener {
    private static UploadDialog uploadDialog;
    private static final Collection<Component> customComponents;
    private static final String CREATED_BY = "created_by";
    private UploadedObjectsSummaryPanel pnlUploadedObjects;
    private ChangesetManagementPanel pnlChangesetManagement;
    private BasicUploadSettingsPanel pnlBasicUploadSettings;
    private UploadStrategySelectionPanel pnlUploadStrategySelectionPanel;
    private TagSettingsPanel pnlTagSettings;
    private JTabbedPane tpConfigPanels;
    private JButton btnUpload;
    private final transient ChangesetCommentModel changesetCommentModel = new ChangesetCommentModel();
    private final transient ChangesetCommentModel changesetSourceModel = new ChangesetCommentModel();
    private final transient ChangesetReviewModel changesetReviewModel = new ChangesetReviewModel();
    private transient DataSet dataSet;

    public UploadDialog() {
        super((Window)GuiHelper.getFrameForComponent(MainApplication.getMainFrame()), Dialog.ModalityType.DOCUMENT_MODAL);
        this.build();
        this.pack();
    }

    public static synchronized UploadDialog getUploadDialog() {
        if (uploadDialog == null) {
            uploadDialog = new UploadDialog();
        }
        return uploadDialog;
    }

    protected JPanel buildContentPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.pnlUploadedObjects = new UploadedObjectsSummaryPanel();
        pnl.add((Component)this.pnlUploadedObjects, GBC.eol().fill(1));
        for (Component c : customComponents) {
            pnl.add(c, GBC.eol().fill(2));
        }
        this.tpConfigPanels = new CompactTabbedPane();
        this.pnlBasicUploadSettings = new BasicUploadSettingsPanel(this.changesetCommentModel, this.changesetSourceModel, this.changesetReviewModel);
        this.tpConfigPanels.add(this.pnlBasicUploadSettings);
        this.tpConfigPanels.setTitleAt(0, I18n.tr("Settings", new Object[0]));
        this.tpConfigPanels.setToolTipTextAt(0, I18n.tr("Decide how to upload the data and which changeset to use", new Object[0]));
        this.pnlTagSettings = new TagSettingsPanel(this.changesetCommentModel, this.changesetSourceModel, this.changesetReviewModel);
        this.tpConfigPanels.add(this.pnlTagSettings);
        this.tpConfigPanels.setTitleAt(1, I18n.tr("Tags of new changeset", new Object[0]));
        this.tpConfigPanels.setToolTipTextAt(1, I18n.tr("Apply tags to the changeset data is uploaded to", new Object[0]));
        this.pnlChangesetManagement = new ChangesetManagementPanel(this.changesetCommentModel);
        this.tpConfigPanels.add(this.pnlChangesetManagement);
        this.tpConfigPanels.setTitleAt(2, I18n.tr("Changesets", new Object[0]));
        this.tpConfigPanels.setToolTipTextAt(2, I18n.tr("Manage open changesets and select a changeset to upload to", new Object[0]));
        this.pnlUploadStrategySelectionPanel = new UploadStrategySelectionPanel();
        this.tpConfigPanels.add(this.pnlUploadStrategySelectionPanel);
        this.tpConfigPanels.setTitleAt(3, I18n.tr("Advanced", new Object[0]));
        this.tpConfigPanels.setToolTipTextAt(3, I18n.tr("Configure advanced settings", new Object[0]));
        pnl.add((Component)this.tpConfigPanels, GBC.eol().fill(2));
        pnl.add((Component)this.buildActionPanel(), GBC.eol().fill(2));
        return pnl;
    }

    protected JPanel buildActionPanel() {
        JPanel pnl = new JPanel(new MultiLineFlowLayout(1));
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.btnUpload = new JButton(new UploadAction(this));
        pnl.add(this.btnUpload);
        this.btnUpload.setFocusable(true);
        InputMapUtils.enableEnter(this.btnUpload);
        InputMapUtils.addCtrlEnterAction(this.getRootPane(), this.btnUpload.getAction());
        CancelAction cancelAction = new CancelAction(this);
        pnl.add(new JButton(cancelAction));
        InputMapUtils.addEscapeAction(this.getRootPane(), cancelAction);
        pnl.add(new JButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Dialog/Upload"))));
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/Dialog/Upload"));
        return pnl;
    }

    protected void build() {
        this.setTitle(I18n.tr("Upload to ''{0}''", OsmApi.getOsmApi().getBaseUrl()));
        this.setContentPane(this.buildContentPanel());
        this.addWindowListener(new WindowEventHandler());
        this.pnlChangesetManagement.addPropertyChangeListener(this);
        this.pnlChangesetManagement.addPropertyChangeListener(this.pnlBasicUploadSettings.getUploadParameterSummaryPanel());
        this.pnlChangesetManagement.addPropertyChangeListener(this);
        this.pnlUploadedObjects.addPropertyChangeListener(this.pnlBasicUploadSettings.getUploadParameterSummaryPanel());
        this.pnlUploadedObjects.addPropertyChangeListener(this.pnlUploadStrategySelectionPanel);
        this.pnlUploadStrategySelectionPanel.addPropertyChangeListener(this.pnlBasicUploadSettings.getUploadParameterSummaryPanel());
        this.pnlBasicUploadSettings.getUploadParameterSummaryPanel().setConfigurationParameterRequestListener(new ConfigurationParameterRequestHandler(){

            @Override
            public void handleUploadStrategyConfigurationRequest() {
                UploadDialog.this.tpConfigPanels.setSelectedIndex(3);
            }

            @Override
            public void handleChangesetConfigurationRequest() {
                UploadDialog.this.tpConfigPanels.setSelectedIndex(2);
            }
        });
        this.pnlBasicUploadSettings.setUploadTagDownFocusTraversalHandlers(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UploadDialog.this.btnUpload.requestFocusInWindow();
            }
        });
        this.setMinimumSize(new Dimension(600, 350));
        Config.getPref().addPreferenceChangeListener(this);
    }

    public void setUploadedPrimitives(APIDataSet toUpload) {
        if (toUpload == null) {
            if (this.pnlUploadedObjects != null) {
                List<OsmPrimitive> emptyList = Collections.emptyList();
                this.pnlUploadedObjects.setUploadedPrimitives(emptyList, emptyList, emptyList);
            }
            return;
        }
        this.pnlUploadedObjects.setUploadedPrimitives(toUpload.getPrimitivesToAdd(), toUpload.getPrimitivesToUpdate(), toUpload.getPrimitivesToDelete());
    }

    public void setChangesetTags(DataSet dataSet) {
        this.setChangesetTags(dataSet, false);
    }

    private void setChangesetTags(DataSet dataSet, boolean keepSourceComment) {
        HashMap<String, String> tags = new HashMap<String, String>();
        if (!keepSourceComment) {
            tags.put("source", UploadDialog.getLastChangesetSourceFromHistory());
            tags.put("comment", UploadDialog.getLastChangesetCommentFromHistory());
        }
        if (dataSet != null) {
            tags.putAll(dataSet.getChangeSetTags());
        }
        this.dataSet = dataSet;
        if (this.pnlChangesetManagement.getSelectedChangeset() != null) {
            tags.putAll(this.pnlChangesetManagement.getSelectedChangeset().getKeys());
        }
        String agent = Version.getInstance().getAgentString(false);
        String createdBy = (String)tags.get(CREATED_BY);
        if (createdBy == null || createdBy.isEmpty()) {
            tags.put(CREATED_BY, agent);
        } else if (!createdBy.contains(agent)) {
            tags.put(CREATED_BY, createdBy + ';' + agent);
        }
        Iterator it = tags.keySet().iterator();
        while (it.hasNext()) {
            String v = (String)tags.get(it.next());
            if (v != null && !v.isEmpty()) continue;
            it.remove();
        }
        if (keepSourceComment) {
            tags.put("source", this.changesetSourceModel.getComment());
            tags.put("comment", this.changesetCommentModel.getComment());
        }
        this.pnlTagSettings.initFromTags(tags);
        this.pnlTagSettings.tableChanged(null);
        this.pnlBasicUploadSettings.discardAllUndoableEdits();
    }

    @Override
    public void rememberUserInput() {
        this.pnlBasicUploadSettings.rememberUserInput();
        this.pnlUploadStrategySelectionPanel.rememberUserInput();
    }

    public void startUserInput() {
        this.tpConfigPanels.setSelectedIndex(0);
        this.pnlBasicUploadSettings.startUserInput();
        this.pnlTagSettings.startUserInput();
        this.pnlUploadStrategySelectionPanel.initFromPreferences();
        UploadParameterSummaryPanel pnl = this.pnlBasicUploadSettings.getUploadParameterSummaryPanel();
        pnl.setUploadStrategySpecification(this.pnlUploadStrategySelectionPanel.getUploadStrategySpecification());
        pnl.setCloseChangesetAfterNextUpload(this.pnlChangesetManagement.isCloseChangesetAfterUpload());
        pnl.setNumObjects(this.pnlUploadedObjects.getNumObjectsToUpload());
    }

    public Changeset getChangeset() {
        Changeset cs = Optional.ofNullable(this.pnlChangesetManagement.getSelectedChangeset()).orElseGet(Changeset::new);
        cs.setKeys(this.pnlTagSettings.getTags(false));
        return cs;
    }

    public void setSelectedChangesetForNextUpload(Changeset cs) {
        this.pnlChangesetManagement.setSelectedChangesetForNextUpload(cs);
    }

    @Override
    public UploadStrategySpecification getUploadStrategySpecification() {
        UploadStrategySpecification spec = this.pnlUploadStrategySelectionPanel.getUploadStrategySpecification();
        spec.setCloseChangesetAfterUpload(this.pnlChangesetManagement.isCloseChangesetAfterUpload());
        return spec;
    }

    @Override
    public String getUploadComment() {
        return this.changesetCommentModel.getComment();
    }

    @Override
    public String getUploadSource() {
        return this.changesetSourceModel.getComment();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(MainApplication.getMainFrame(), new Dimension(400, 600))).applySafe(this);
            this.startUserInput();
        } else if (this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(visible);
    }

    public static boolean addCustomComponent(Component c) {
        if (c != null) {
            return customComponents.add(c);
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(ChangesetManagementPanel.SELECTED_CHANGESET_PROP)) {
            Changeset cs = (Changeset)evt.getNewValue();
            this.setChangesetTags(this.dataSet, cs == null);
            if (cs == null) {
                this.tpConfigPanels.setTitleAt(1, I18n.tr("Tags of new changeset", new Object[0]));
            } else {
                this.tpConfigPanels.setTitleAt(1, I18n.tr("Tags of changeset {0}", cs.getId()));
            }
        }
    }

    @Override
    public void preferenceChanged(PreferenceChangeEvent e) {
        if (e.getKey() != null && e.getSource() != this.getClass() && e.getSource() != BasicUploadSettingsPanel.class) {
            switch (e.getKey()) {
                case "osm-server.url": {
                    this.osmServerUrlChanged(e.getNewValue());
                    break;
                }
                case "upload.comment.history": 
                case "upload.source.history": {
                    this.pnlBasicUploadSettings.refreshHistoryComboBoxes();
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    private void osmServerUrlChanged(Setting<?> newValue) {
        String url = newValue == null || newValue.getValue() == null ? OsmApi.getOsmApi().getBaseUrl() : newValue.getValue().toString();
        this.setTitle(I18n.tr("Upload to ''{0}''", url));
    }

    private static String getLastChangesetTagFromHistory(String historyKey, List<String> def) {
        List<String> history = Config.getPref().getList(historyKey, def);
        long age = System.currentTimeMillis() / 1000L - Config.getPref().getLong("upload.comment.last-used", 0L);
        if (age < Config.getPref().getLong("upload.comment.max-age", TimeUnit.HOURS.toSeconds(4L)) && !history.isEmpty()) {
            return (String)history.iterator().next();
        }
        return null;
    }

    public static String getLastChangesetCommentFromHistory() {
        return UploadDialog.getLastChangesetTagFromHistory("upload.comment.history", new ArrayList<String>());
    }

    public static String getLastChangesetSourceFromHistory() {
        return UploadDialog.getLastChangesetTagFromHistory("upload.source.history", BasicUploadSettingsPanel.getDefaultSources());
    }

    @Override
    public Map<String, String> getTags(boolean keepEmpty) {
        return this.pnlTagSettings.getTags(keepEmpty);
    }

    @Override
    public void handleMissingComment() {
        this.tpConfigPanels.setSelectedIndex(0);
        this.pnlBasicUploadSettings.initEditingOfUploadComment();
    }

    @Override
    public void handleMissingSource() {
        this.tpConfigPanels.setSelectedIndex(0);
        this.pnlBasicUploadSettings.initEditingOfUploadSource();
    }

    @Override
    public void handleIllegalChunkSize() {
        this.tpConfigPanels.setSelectedIndex(0);
    }

    @Override
    public void forceUpdateActiveField() {
        if (this.tpConfigPanels.getSelectedComponent() == this.pnlBasicUploadSettings) {
            this.pnlBasicUploadSettings.forceUpdateActiveField();
        }
    }

    public void clean() {
        this.setUploadedPrimitives(null);
        this.dataSet = null;
    }

    static {
        customComponents = new ArrayList<Component>();
    }

    class WindowEventHandler
    extends WindowAdapter {
        private boolean activatedOnce;

        WindowEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            UploadDialog.this.setCanceled(true);
        }

        @Override
        public void windowActivated(WindowEvent e) {
            if (!this.activatedOnce && UploadDialog.this.tpConfigPanels.getSelectedIndex() == 0) {
                UploadDialog.this.pnlBasicUploadSettings.initEditingOfUploadComment();
                this.activatedOnce = true;
            }
        }
    }

    static class CancelAction
    extends AbstractAction {
        private final transient IUploadDialog dialog;

        CancelAction(IUploadDialog dialog) {
            this.dialog = dialog;
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            new ImageProvider("cancel").getResource().attachImageIcon(this, true);
            this.putValue("ShortDescription", I18n.tr("Cancel the upload and resume editing", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.dialog instanceof AbstractUploadDialog) {
                ((AbstractUploadDialog)this.dialog).setCanceled(true);
                ((AbstractUploadDialog)this.dialog).setVisible(false);
            }
        }
    }

    static class UploadAction
    extends AbstractAction {
        private final transient IUploadDialog dialog;

        UploadAction(IUploadDialog dialog) {
            this.dialog = dialog;
            this.putValue("Name", I18n.tr("Upload Changes", new Object[0]));
            new ImageProvider("upload").getResource().attachImageIcon(this, true);
            this.putValue("ShortDescription", I18n.tr("Upload the changed primitives", new Object[0]));
        }

        protected boolean warnUploadComment() {
            return this.warnUploadTag(I18n.tr("Please revise upload comment", new Object[0]), I18n.tr("Your upload comment is <i>empty</i>, or <i>very short</i>.<br /><br />This is technically allowed, but please consider that many users who are<br />watching changes in their area depend on meaningful changeset comments<br />to understand what is going on!<br /><br />If you spend a minute now to explain your change, you will make life<br />easier for many other mappers.", new Object[0]), "upload_comment_is_empty_or_very_short");
        }

        protected boolean warnUploadSource() {
            return this.warnUploadTag(I18n.tr("Please specify a changeset source", new Object[0]), I18n.tr("You did not specify a source for your changes.<br />It is technically allowed, but this information helps<br />other users to understand the origins of the data.<br /><br />If you spend a minute now to explain your change, you will make life<br />easier for many other mappers.", new Object[0]), "upload_source_is_empty");
        }

        protected boolean warnRejectedUploadComment(String details) {
            return this.warnRejectedUploadTag(I18n.tr("Please revise upload comment", new Object[0]), I18n.tr("Your upload comment is <i>rejected</i>.", new Object[0]) + "<br />" + details);
        }

        protected boolean warnRejectedUploadSource(String details) {
            return this.warnRejectedUploadTag(I18n.tr("Please revise changeset source", new Object[0]), I18n.tr("Your changeset source is <i>rejected</i>.", new Object[0]) + "<br />" + details);
        }

        protected boolean warnUploadTag(String title, String message, String togglePref) {
            return this.warnUploadTag(title, message, togglePref, true);
        }

        protected boolean warnRejectedUploadTag(String title, String message) {
            return this.warnUploadTag(title, message, null, false);
        }

        private boolean warnUploadTag(String title, String message, String togglePref, boolean allowContinue) {
            ArrayList<String> buttonTexts = new ArrayList<String>(Arrays.asList(I18n.tr("Revise", new Object[0]), I18n.tr("Cancel", new Object[0])));
            ArrayList<ImageIcon> buttonIcons = new ArrayList<ImageIcon>(Arrays.asList(new ImageProvider("ok").setMaxSize(ImageProvider.ImageSizes.LARGEICON).get(), new ImageProvider("cancel").setMaxSize(ImageProvider.ImageSizes.LARGEICON).get()));
            ArrayList<String> tooltips = new ArrayList<String>(Arrays.asList(I18n.tr("Return to the previous dialog to enter a more descriptive comment", new Object[0]), I18n.tr("Cancel and return to the previous dialog", new Object[0])));
            if (allowContinue) {
                buttonTexts.add(I18n.tr("Continue as is", new Object[0]));
                buttonIcons.add(new ImageProvider("upload").setMaxSize(ImageProvider.ImageSizes.LARGEICON).addOverlay(new ImageOverlay(new ImageProvider("warning-small"), 0.5, 0.5, 1.0, 1.0)).get());
                tooltips.add(I18n.tr("Ignore this hint and upload anyway", new Object[0]));
            }
            ExtendedDialog dlg = new ExtendedDialog((Component)((Object)this.dialog), title, buttonTexts.toArray(new String[0])){

                @Override
                public void setupDialog() {
                    super.setupDialog();
                    InputMapUtils.addCtrlEnterAction(this.getRootPane(), ((JButton)this.buttons.get(this.buttons.size() - 1)).getAction());
                }
            };
            dlg.setContent("<html>" + message + "</html>");
            dlg.setButtonIcons(buttonIcons.toArray(new Icon[0]));
            dlg.setToolTipTexts(tooltips.toArray(new String[0]));
            dlg.setIcon(2);
            if (allowContinue) {
                dlg.toggleEnable(togglePref);
            }
            dlg.setCancelButton(1, 2);
            return dlg.showDialog().getValue() != 3;
        }

        protected void warnIllegalChunkSize() {
            HelpAwareOptionPane.showOptionDialog((Component)((Object)this.dialog), I18n.tr("Please enter a valid chunk size first", new Object[0]), I18n.tr("Illegal chunk size", new Object[0]), 0, HelpUtil.ht("/Dialog/Upload#IllegalChunkSize"));
        }

        static boolean isUploadCommentTooShort(String comment) {
            String s = Utils.strip(comment);
            boolean result = true;
            if (!s.isEmpty()) {
                Character.UnicodeBlock block = Character.UnicodeBlock.of(s.charAt(0));
                result = block != null && block.toString().contains("CJK") ? s.length() < 4 : s.length() < 10;
            }
            return result;
        }

        private static String lc(String s) {
            return s.toLowerCase(Locale.ENGLISH);
        }

        static String validateUploadTag(String uploadValue, String preferencePrefix, List<String> defMandatory, List<String> defForbidden) {
            String uploadValueLc = UploadAction.lc(uploadValue);
            List missingTerms = Config.getPref().getList(preferencePrefix + ".mandatory-terms", defMandatory).stream().map(UploadAction::lc).filter(x -> !uploadValueLc.contains((CharSequence)x)).collect(Collectors.toList());
            if (!missingTerms.isEmpty()) {
                return I18n.tr("The following required terms are missing: {0}", missingTerms);
            }
            List forbiddenTerms = Config.getPref().getList(preferencePrefix + ".forbidden-terms", defForbidden).stream().map(UploadAction::lc).filter(uploadValueLc::contains).collect(Collectors.toList());
            if (!forbiddenTerms.isEmpty()) {
                return I18n.tr("The following forbidden terms have been found: {0}", forbiddenTerms);
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.dialog.forceUpdateActiveField();
            List<String> def = Collections.emptyList();
            String uploadComment = this.dialog.getUploadComment();
            String uploadCommentRejection = UploadAction.validateUploadTag(uploadComment, "upload.comment", def, def);
            if (UploadAction.isUploadCommentTooShort(uploadComment) && this.warnUploadComment() || uploadCommentRejection != null && this.warnRejectedUploadComment(uploadCommentRejection)) {
                this.dialog.handleMissingComment();
                return;
            }
            String uploadSource = this.dialog.getUploadSource();
            String uploadSourceRejection = UploadAction.validateUploadTag(uploadSource, "upload.source", def, Collections.singletonList("google"));
            if (Utils.isStripEmpty(uploadSource) && this.warnUploadSource() || uploadSourceRejection != null && this.warnRejectedUploadSource(uploadSourceRejection)) {
                this.dialog.handleMissingSource();
                return;
            }
            ArrayList<String> emptyChangesetTags = new ArrayList<String>();
            for (Map.Entry<String, String> i : this.dialog.getTags(true).entrySet()) {
                boolean ignoreKey;
                boolean isKeyEmpty = Utils.isStripEmpty(i.getKey());
                boolean isValueEmpty = Utils.isStripEmpty(i.getValue());
                boolean bl = ignoreKey = "comment".equals(i.getKey()) || "source".equals(i.getKey());
                if (!(isKeyEmpty ^ isValueEmpty) || ignoreKey) continue;
                emptyChangesetTags.add(I18n.tr("{0}={1}", i.getKey(), i.getValue()));
            }
            if (!emptyChangesetTags.isEmpty() && 0 != JOptionPane.showConfirmDialog(MainApplication.getMainFrame(), I18n.trn("<html>The following changeset tag contains an empty key/value:<br>{0}<br>Continue?</html>", "<html>The following changeset tags contain an empty key/value:<br>{0}<br>Continue?</html>", emptyChangesetTags.size(), Utils.joinAsHtmlUnorderedList(emptyChangesetTags)), I18n.tr("Empty metadata", new Object[0]), 2, 2)) {
                this.dialog.handleMissingComment();
                return;
            }
            UploadStrategySpecification strategy = this.dialog.getUploadStrategySpecification();
            if (strategy.getStrategy() == UploadStrategy.CHUNKED_DATASET_STRATEGY && strategy.getChunkSize() == -1) {
                this.warnIllegalChunkSize();
                this.dialog.handleIllegalChunkSize();
                return;
            }
            if (this.dialog instanceof AbstractUploadDialog) {
                ((AbstractUploadDialog)this.dialog).setCanceled(false);
                ((AbstractUploadDialog)this.dialog).setVisible(false);
            }
        }
    }

    static final class CompactTabbedPane
    extends JTabbedPane {
        CompactTabbedPane() {
        }

        @Override
        public Dimension getPreferredSize() {
            return super.getMinimumSize();
        }
    }
}

