/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.util.AstUtil;

public final class JsIf
extends SourceInfoAwareJsNode
implements JsStatement {
    @NotNull
    private JsExpression ifExpression;
    @NotNull
    private JsStatement thenStatement;
    @Nullable
    private JsStatement elseStatement;

    public JsIf(@NotNull JsExpression ifExpression, @NotNull JsStatement thenStatement, @Nullable JsStatement elseStatement) {
        this.ifExpression = ifExpression;
        this.thenStatement = thenStatement;
        this.elseStatement = elseStatement;
    }

    public JsIf(@NotNull JsExpression ifExpression, @NotNull JsStatement thenStatement) {
        this(ifExpression, thenStatement, null);
    }

    @Nullable
    public JsStatement getElseStatement() {
        return this.elseStatement;
    }

    @NotNull
    public JsExpression getIfExpression() {
        return this.ifExpression;
    }

    @NotNull
    public JsStatement getThenStatement() {
        return this.thenStatement;
    }

    public void setElseStatement(@Nullable JsStatement elseStatement) {
        this.elseStatement = elseStatement;
    }

    public void setIfExpression(@NotNull JsExpression ifExpression) {
        this.ifExpression = ifExpression;
    }

    public void setThenStatement(@NotNull JsStatement thenStatement) {
        this.thenStatement = thenStatement;
    }

    @Override
    public void accept(JsVisitor v2) {
        v2.visitIf(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.accept(this.ifExpression);
        visitor2.accept(this.thenStatement);
        if (this.elseStatement != null) {
            visitor2.accept(this.elseStatement);
        }
    }

    @Override
    public void traverse(JsVisitorWithContext v2, JsContext ctx) {
        if (v2.visit(this, ctx)) {
            this.ifExpression = v2.accept(this.ifExpression);
            this.thenStatement = v2.acceptStatement(this.thenStatement);
            if (this.elseStatement != null) {
                this.elseStatement = v2.acceptStatement(this.elseStatement);
            }
        }
        v2.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsIf deepCopy() {
        JsExpression ifCopy = AstUtil.deepCopy(this.ifExpression);
        JsStatement thenCopy = AstUtil.deepCopy(this.thenStatement);
        JsStatement elseCopy = AstUtil.deepCopy(this.elseStatement);
        return new JsIf(ifCopy, thenCopy, elseCopy).withMetadataFrom(this);
    }
}

