/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jdom;

import org.jetbrains.kotlin.org.jdom.Attribute;
import org.jetbrains.kotlin.org.jdom.Element;
import org.jetbrains.kotlin.org.jdom.Namespace;

public class IllegalAddException
extends IllegalArgumentException {
    IllegalAddException(Element base, Attribute added, String reason) {
        super("The attribute \"" + added.getQualifiedName() + "\" could not be added to the element \"" + base.getQualifiedName() + "\": " + reason);
    }

    IllegalAddException(Element added, String reason) {
        super("The element \"" + added.getQualifiedName() + "\" could not be added as the root of the document: " + reason);
    }

    IllegalAddException(Element base, Namespace added, String reason) {
        super("The namespace xmlns" + (added.getPrefix().equals("") ? "=" : ":" + added.getPrefix() + "=") + "\"" + added.getURI() + "\" could not be added as a namespace to \"" + base.getQualifiedName() + "\": " + reason);
    }

    public IllegalAddException(String reason) {
        super(reason);
    }
}

