/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openstreetmap.josm.actions.AbstractSelectAction;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.conflict.IConflictListener;
import org.openstreetmap.josm.data.osm.DataSelectionListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.OsmPrimitiveVisitor;
import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.PopupMenuHandler;
import org.openstreetmap.josm.gui.PrimitiveRenderer;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.conflict.pair.ConflictResolver;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.gui.dialogs.ConflictResolutionDialog;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;

public final class ConflictDialog
extends ToggleDialog
implements MainLayerManager.ActiveLayerChangeListener,
IConflictListener,
DataSelectionListener {
    private static final NamedColorProperty CONFLICT_COLOR = new NamedColorProperty(I18n.marktr("conflict"), Color.GRAY);
    private static final NamedColorProperty BACKGROUND_COLOR = new NamedColorProperty(I18n.marktr("background"), Color.BLACK);
    private transient ConflictCollection conflicts;
    private transient ConflictListModel model;
    private JList<OsmPrimitive> lstConflicts;
    private final JPopupMenu popupMenu = new JPopupMenu();
    private final transient PopupMenuHandler popupMenuHandler = new PopupMenuHandler(this.popupMenu);
    private final ResolveAction actResolve = new ResolveAction();
    private final SelectAction actSelect = new SelectAction();

    public ConflictDialog() {
        super(I18n.tr("Conflict", new Object[0]), "conflict", I18n.tr("Resolve conflicts", new Object[0]), Shortcut.registerShortcut("subwindow:conflict", I18n.tr("Toggle: {0}", I18n.tr("Conflict", new Object[0])), 67, 5007), 100);
        this.build();
        this.refreshView();
    }

    public static Color getColor() {
        return CONFLICT_COLOR.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void build() {
        ConflictDialog conflictDialog = this;
        synchronized (conflictDialog) {
            this.model = new ConflictListModel();
            this.lstConflicts = new JList<OsmPrimitive>(this.model);
            this.lstConflicts.setSelectionMode(2);
            this.lstConflicts.setCellRenderer(new PrimitiveRenderer());
            this.lstConflicts.addMouseListener(new MouseEventHandler());
        }
        this.addListSelectionListener(e -> MainApplication.getMap().mapView.repaint());
        SideButton btnResolve = new SideButton(this.actResolve);
        this.addListSelectionListener(this.actResolve);
        SideButton btnSelect = new SideButton(this.actSelect);
        this.addListSelectionListener(this.actSelect);
        this.createLayout(this.lstConflicts, true, Arrays.asList(btnResolve, btnSelect));
        this.popupMenuHandler.addAction(MainApplication.getMenu().autoScaleActions.get("conflict"));
        ResolveToMyVersionAction resolveToMyVersionAction = new ResolveToMyVersionAction();
        ResolveToTheirVersionAction resolveToTheirVersionAction = new ResolveToTheirVersionAction();
        this.addListSelectionListener(resolveToMyVersionAction);
        this.addListSelectionListener(resolveToTheirVersionAction);
        JMenuItem btnResolveMy = this.popupMenuHandler.addAction(resolveToMyVersionAction);
        JMenuItem btnResolveTheir = this.popupMenuHandler.addAction(resolveToTheirVersionAction);
        this.popupMenuHandler.addListener(new ResolveButtonsPopupMenuListener(btnResolveTheir, btnResolveMy));
    }

    @Override
    public void showNotify() {
        MainApplication.getLayerManager().addAndFireActiveLayerChangeListener(this);
    }

    @Override
    public void hideNotify() {
        MainApplication.getLayerManager().removeActiveLayerChangeListener(this);
        this.removeDataLayerListeners(MainApplication.getLayerManager().getEditLayer());
    }

    public synchronized void addListSelectionListener(ListSelectionListener listener) {
        this.lstConflicts.getSelectionModel().addListSelectionListener(listener);
    }

    public synchronized void removeListSelectionListener(ListSelectionListener listener) {
        this.lstConflicts.getSelectionModel().removeListSelectionListener(listener);
    }

    public PopupMenuHandler getPopupMenuHandler() {
        return this.popupMenuHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolve() {
        ConflictDialog conflictDialog = this;
        synchronized (conflictDialog) {
            if (this.conflicts == null || this.model.getSize() == 0) {
                return;
            }
            int index = this.lstConflicts.getSelectedIndex();
            if (index < 0) {
                index = 0;
            }
            Conflict<?> c = this.conflicts.get(index);
            ConflictResolutionDialog dialog = new ConflictResolutionDialog((Component)MainApplication.getMainFrame());
            dialog.getConflictResolver().populate(c);
            dialog.showDialog();
            if (index < this.conflicts.size() - 1) {
                this.lstConflicts.setSelectedIndex(index);
            } else {
                this.lstConflicts.setSelectedIndex(index - 1);
            }
        }
        MainApplication.getMap().mapView.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshView() {
        DataSet editDs = MainApplication.getLayerManager().getEditDataSet();
        ConflictDialog conflictDialog = this;
        synchronized (conflictDialog) {
            this.conflicts = editDs == null ? new ConflictCollection() : editDs.getConflicts();
        }
        GuiHelper.runInEDT(() -> {
            this.model.fireContentChanged();
            this.updateTitle();
        });
    }

    private synchronized void updateTitle() {
        int conflictsCount = this.conflicts.size();
        if (conflictsCount > 0) {
            this.setTitle(I18n.trn("Conflict: {0} unresolved", "Conflicts: {0} unresolved", conflictsCount, conflictsCount) + " (" + I18n.tr("Rel.:{0} / Ways:{1} / Nodes:{2}", this.conflicts.getRelationConflicts().size(), this.conflicts.getWayConflicts().size(), this.conflicts.getNodeConflicts().size()) + ')');
        } else {
            this.setTitle(I18n.tr("Conflict", new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintConflicts(Graphics g, NavigatableComponent nc) {
        Color preferencesColor = ConflictDialog.getColor();
        if (preferencesColor.equals(BACKGROUND_COLOR.get())) {
            return;
        }
        g.setColor(preferencesColor);
        ConflictPainter conflictPainter = new ConflictPainter(nc, g);
        ConflictDialog conflictDialog = this;
        synchronized (conflictDialog) {
            for (OsmPrimitive o : this.lstConflicts.getSelectedValuesList()) {
                if (this.conflicts == null || !this.conflicts.hasConflictForMy(o)) continue;
                ((OsmPrimitive)this.conflicts.getConflictForMy(o).getTheir()).accept(conflictPainter);
            }
        }
    }

    @Override
    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        this.removeDataLayerListeners(e.getPreviousDataLayer());
        this.addDataLayerListeners(e.getSource().getActiveDataLayer());
        this.refreshView();
    }

    private void addDataLayerListeners(OsmDataLayer newLayer) {
        if (newLayer != null) {
            newLayer.getConflicts().addConflictListener(this);
            newLayer.data.addSelectionListener(this);
        }
    }

    private void removeDataLayerListeners(OsmDataLayer oldLayer) {
        if (oldLayer != null) {
            oldLayer.getConflicts().removeConflictListener(this);
            oldLayer.data.removeSelectionListener(this);
        }
    }

    public synchronized ConflictCollection getConflicts() {
        return this.conflicts;
    }

    public synchronized Conflict<? extends OsmPrimitive> getSelectedConflict() {
        if (this.conflicts == null || this.model.getSize() == 0) {
            return null;
        }
        int index = this.lstConflicts.getSelectedIndex();
        return index >= 0 && index < this.conflicts.size() ? this.conflicts.get(index) : null;
    }

    private synchronized boolean isConflictSelected() {
        ListSelectionModel selModel = this.lstConflicts.getSelectionModel();
        return selModel.getMinSelectionIndex() >= 0 && selModel.getMaxSelectionIndex() >= selModel.getMinSelectionIndex();
    }

    @Override
    public void onConflictsAdded(ConflictCollection conflicts) {
        this.refreshView();
    }

    @Override
    public void onConflictsRemoved(ConflictCollection conflicts) {
        Logging.info("1 conflict has been resolved.");
        this.refreshView();
    }

    @Override
    public synchronized void selectionChanged(DataSelectionListener.SelectionChangeEvent event) {
        this.lstConflicts.setValueIsAdjusting(true);
        this.lstConflicts.clearSelection();
        for (OsmPrimitive osm : event.getSelection()) {
            int pos;
            if (this.conflicts == null || !this.conflicts.hasConflictForMy(osm) || (pos = this.model.indexOf(osm)) < 0) continue;
            this.lstConflicts.addSelectionInterval(pos, pos);
        }
        this.lstConflicts.setValueIsAdjusting(false);
    }

    @Override
    public String helpTopic() {
        return HelpUtil.ht("/Dialog/ConflictList");
    }

    public void warnNumNewConflicts(int numNewConflicts) {
        if (numNewConflicts == 0) {
            return;
        }
        String msg1 = I18n.trn("There was {0} conflict detected.", "There were {0} conflicts detected.", numNewConflicts, numNewConflicts);
        StringBuilder sb = new StringBuilder();
        sb.append("<html>").append(msg1).append("</html>");
        if (numNewConflicts > 0) {
            HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("OK", new Object[0]), new ImageProvider("ok"), I18n.tr("Click to close this dialog and continue editing", new Object[0]), null)};
            GuiHelper.runInEDT(() -> {
                HelpAwareOptionPane.showOptionDialog(MainApplication.getMainFrame(), sb.toString(), I18n.tr("Conflicts detected", new Object[0]), 2, null, options, options[0], HelpUtil.ht("/Concepts/Conflict#WarningAboutDetectedConflicts"));
                this.unfurlDialog();
                MainApplication.getMap().repaint();
            });
        }
    }

    public static class ConflictPainter
    implements OsmPrimitiveVisitor {
        private final Set<Relation> visited = new HashSet<Relation>();
        private final NavigatableComponent nc;
        private final Graphics g;

        ConflictPainter(NavigatableComponent nc, Graphics g) {
            this.nc = nc;
            this.g = g;
        }

        @Override
        public void visit(Node n) {
            Point p = this.nc.getPoint(n);
            this.g.drawRect(p.x - 1, p.y - 1, 2, 2);
        }

        private void visit(Node n1, Node n2) {
            Point p1 = this.nc.getPoint(n1);
            Point p2 = this.nc.getPoint(n2);
            this.g.drawLine(p1.x, p1.y, p2.x, p2.y);
        }

        @Override
        public void visit(Way w) {
            Node lastN = null;
            for (Node n : w.getNodes()) {
                if (lastN == null) {
                    lastN = n;
                    continue;
                }
                this.visit(lastN, n);
                lastN = n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visit(Relation e) {
            if (!this.visited.contains(e)) {
                this.visited.add(e);
                try {
                    for (RelationMember em : e.getMembers()) {
                        em.getMember().accept(this);
                    }
                }
                finally {
                    this.visited.remove(e);
                }
            }
        }
    }

    class ResolveToTheirVersionAction
    extends ResolveToAction {
        ResolveToTheirVersionAction() {
            super(I18n.tr("Resolve to their versions", new Object[0]), I18n.tr("Resolves all unresolved conflicts to ''their'' version", new Object[0]), MergeDecisionType.KEEP_THEIR);
        }
    }

    class ResolveToMyVersionAction
    extends ResolveToAction {
        ResolveToMyVersionAction() {
            super(I18n.tr("Resolve to my versions", new Object[0]), I18n.tr("Resolves all unresolved conflicts to ''my'' version", new Object[0]), MergeDecisionType.KEEP_MINE);
        }
    }

    abstract class ResolveToAction
    extends ResolveAction {
        private final String name;
        private final MergeDecisionType type;

        ResolveToAction(String name, String description, MergeDecisionType type) {
            this.name = name;
            this.type = type;
            this.putValue("Name", name);
            this.putValue("ShortDescription", description);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            ConflictResolver resolver = new ConflictResolver();
            ArrayList<Command> commands = new ArrayList<Command>();
            ResolveToAction resolveToAction = this;
            synchronized (resolveToAction) {
                for (OsmPrimitive osmPrimitive : ConflictDialog.this.lstConflicts.getSelectedValuesList()) {
                    Conflict<?> c = ConflictDialog.this.conflicts.getConflictForMy(osmPrimitive);
                    if (c == null) continue;
                    resolver.populate(c);
                    resolver.decideRemaining(this.type);
                    commands.add(resolver.buildResolveCommand());
                }
            }
            UndoRedoHandler.getInstance().add(new SequenceCommand(this.name, commands));
            ConflictDialog.this.refreshView();
        }
    }

    final class SelectAction
    extends AbstractSelectAction
    implements ListSelectionListener {
        private SelectAction() {
            this.putValue("help", HelpUtil.ht("/Dialog/ConflictList#SelectAction"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            LinkedList<OsmPrimitive> sel = new LinkedList<OsmPrimitive>();
            SelectAction selectAction = this;
            synchronized (selectAction) {
                for (OsmPrimitive o : ConflictDialog.this.lstConflicts.getSelectedValuesList()) {
                    sel.add(o);
                }
            }
            DataSet ds = MainApplication.getLayerManager().getEditDataSet();
            if (ds != null) {
                ds.setSelected(sel);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(ConflictDialog.this.isConflictSelected());
        }
    }

    class ResolveAction
    extends AbstractAction
    implements ListSelectionListener {
        ResolveAction() {
            this.putValue("Name", I18n.tr("Resolve", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Open a merge dialog of all selected items in the list above.", new Object[0]));
            new ImageProvider("dialogs", "conflict").getResource().attachImageIcon(this, true);
            this.putValue("help", HelpUtil.ht("/Dialog/ConflictList#ResolveAction"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConflictDialog.this.resolve();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(ConflictDialog.this.isConflictSelected());
        }
    }

    class ConflictListModel
    implements ListModel<OsmPrimitive> {
        private final CopyOnWriteArrayList<ListDataListener> listeners = new CopyOnWriteArrayList();

        ConflictListModel() {
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            if (l != null) {
                this.listeners.addIfAbsent(l);
            }
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listeners.remove(l);
        }

        protected void fireContentChanged() {
            ListDataEvent evt = new ListDataEvent(this, 0, 0, this.getSize());
            for (ListDataListener listener : this.listeners) {
                listener.contentsChanged(evt);
            }
        }

        @Override
        public synchronized OsmPrimitive getElementAt(int index) {
            if (index < 0 || index >= this.getSize()) {
                return null;
            }
            return ConflictDialog.this.conflicts.get(index).getMy();
        }

        @Override
        public synchronized int getSize() {
            return ConflictDialog.this.conflicts != null ? ConflictDialog.this.conflicts.size() : 0;
        }

        public synchronized int indexOf(OsmPrimitive my) {
            if (ConflictDialog.this.conflicts != null) {
                for (int i = 0; i < ConflictDialog.this.conflicts.size(); ++i) {
                    if (!ConflictDialog.this.conflicts.get(i).isMatchingMy(my)) continue;
                    return i;
                }
            }
            return -1;
        }

        public synchronized OsmPrimitive get(int idx) {
            return ConflictDialog.this.conflicts != null ? (OsmPrimitive)ConflictDialog.this.conflicts.get(idx).getMy() : null;
        }
    }

    class MouseEventHandler
    extends PopupMenuLauncher {
        MouseEventHandler() {
            super(ConflictDialog.this.popupMenu);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (MouseEventHandler.isDoubleClick(e)) {
                ConflictDialog.this.resolve();
            }
        }
    }

    static final class ResolveButtonsPopupMenuListener
    implements PopupMenuListener {
        private final JMenuItem btnResolveTheir;
        private final JMenuItem btnResolveMy;

        ResolveButtonsPopupMenuListener(JMenuItem btnResolveTheir, JMenuItem btnResolveMy) {
            this.btnResolveTheir = btnResolveTheir;
            this.btnResolveMy = btnResolveMy;
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.btnResolveMy.setVisible(ExpertToggleAction.isExpert());
            this.btnResolveTheir.setVisible(ExpertToggleAction.isExpert());
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }
}

