/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.variable.AbstractVariable;
import org.jruby.embed.variable.BiVariable;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.runtime.builtin.IRubyObject;

public class GlobalVariable
extends AbstractVariable {
    private static final String VALID_NAME = "\\$(([a-zA-Z]|_|\\d)*|-[a-zA-Z]|[!-~&&[^#%()-\\{\\}\\[\\]\\|\\^]])";
    private static final String[] PREDEFINED_PATTERNS = new String[]{"\\$([\\u0021-\\u0040]|\\u005c|[\\u005e-\\u0060]|\\u007e)", "\\$-(\\d|[A-z])"};
    private static final Set<String> PREDEFINED_NAMES = new HashSet<String>();

    public static BiVariable getInstance(RubyObject receiver2, String name2, Object ... javaObject) {
        if (name2.matches(VALID_NAME)) {
            GlobalVariable var = new GlobalVariable(receiver2, name2, javaObject);
            var.tryEagerInjection(null);
            return var;
        }
        return null;
    }

    protected GlobalVariable(RubyObject receiver2, String name2, Object ... javaObjects) {
        super(receiver2, name2, false);
        this.updateByJavaObject(receiver2.getRuntime(), javaObjects);
    }

    GlobalVariable(RubyObject receiver2, String name2, IRubyObject irubyObject) {
        super(receiver2, name2, true, irubyObject);
    }

    public static void retrieve(IRubyObject receiver2, BiVariableMap vars) {
        if (vars.isLazy()) {
            return;
        }
        GlobalVariables globalVars = receiver2.getRuntime().getGlobalVariables();
        for (String name2 : globalVars.getNames()) {
            if (GlobalVariable.isPredefined(name2)) continue;
            IRubyObject value2 = globalVars.get(name2);
            GlobalVariable.updateGlobalVar(vars, GlobalVariable.getTopSelf(receiver2), name2, value2);
        }
    }

    private static void updateGlobalVar(BiVariableMap vars, RubyObject receiver2, String name2, IRubyObject value2) {
        BiVariable var = vars.getVariable(receiver2, name2);
        if (var != null) {
            var.setRubyObject(value2);
        } else {
            var = new GlobalVariable(receiver2, name2, value2);
            vars.update(name2, var);
        }
    }

    public static void retrieveByKey(Ruby runtime2, BiVariableMap vars, String key2) {
        GlobalVariables globalVars = runtime2.getGlobalVariables();
        if (!globalVars.getNames().contains(key2)) {
            return;
        }
        IRubyObject value2 = globalVars.get(key2);
        GlobalVariable.updateGlobalVar(vars, (RubyObject)runtime2.getTopSelf(), key2, value2);
    }

    protected static boolean isPredefined(String name2) {
        for (String pattern : PREDEFINED_PATTERNS) {
            if (!name2.matches(pattern)) continue;
            return true;
        }
        return PREDEFINED_NAMES.contains(name2);
    }

    @Override
    public BiVariable.Type getType() {
        return BiVariable.Type.GlobalVariable;
    }

    public static boolean isValidName(Object name2) {
        return GlobalVariable.isValidName(VALID_NAME, name2);
    }

    @Override
    public void setJavaObject(Ruby runtime2, Object javaObject) {
        this.updateByJavaObject(runtime2, javaObject);
        this.tryEagerInjection(runtime2, null);
    }

    @Override
    public void inject() {
    }

    @Deprecated
    public void tryEagerInjection(Ruby runtime2, IRubyObject receiver2) {
        this.tryEagerInjection(receiver2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryEagerInjection(IRubyObject receiver2) {
        String name2 = this.name.startsWith("$") ? this.name : "$" + this.name;
        Ruby ruby = this.getRuntime();
        synchronized (ruby) {
            this.getRuntime().getGlobalVariables().set(name2.intern(), this.irubyObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() {
        Ruby ruby = this.getRuntime();
        synchronized (ruby) {
            this.getRuntime().getGlobalVariables().clear(this.name.intern());
        }
    }

    @Override
    public boolean isReceiverIdentical(RubyObject recv2) {
        return true;
    }

    static {
        String[] NAMES = new String[]{"$DEBUG", "$F", "$FILENAME", "$KCODE", "$LOAD_PATH", "$SAFE", "$VERBOSE", "$CLASSPATH", "$LOADED_FEATURES", "$PROGRAM_NAME", "$FIELD_SEPARATOR", "$ERROR_POSITION", "$DEFAULT_OUTPUT", "$PREMATCH", "$RS", "$MATCH", "$LAST_READ_LINE", "$FS", "$INPUT_RECORD_SEPARATOR", "$PID", "$NR", "$ERROR_INFO", "$PROCESS_ID", "$OUTPUT_RECORD_SEPARATOR", "$INPUT_LINE_NUMBER", "$LAST_PAREN_MATCH", "$LAST_MATCH_INFO", "$CHILD_STATUS", "$IGNORECASE", "$DEFAULT_INPUT", "$OFS", "$OUTPUT_FIELD_SEPARATOR", "$POSTMATCH", "$ORS", "$configure_args", "$deferr", "$defout", "$expect_verbose", "$stderr", "$stdin", "$stdout"};
        PREDEFINED_NAMES.addAll(Arrays.asList(NAMES));
    }
}

