/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.sg.BackgroundFill;
import com.sun.javafx.sg.BackgroundImage;
import com.sun.javafx.sg.BaseEffectFilter;
import com.sun.javafx.sg.Border;
import com.sun.javafx.sg.BorderStyle;
import com.sun.javafx.sg.ImageBorder;
import com.sun.javafx.sg.PGRegion;
import com.sun.javafx.sg.PGShape;
import com.sun.javafx.sg.Repeat;
import com.sun.javafx.sg.StrokedBorder;
import com.sun.javafx.sg.prism.NGGroup;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGShape;
import com.sun.prism.BasicStroke;
import com.sun.prism.Graphics;
import com.sun.prism.Image;
import com.sun.prism.Texture;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.ImagePattern;
import com.sun.prism.paint.Paint;
import com.sun.scenario.effect.Offset;

public class NGRegion
extends NGGroup
implements PGRegion {
    private float x1;
    private float y1;
    private float x2;
    private float y2;
    private Shape shape;
    private float width;
    private float height;
    private BackgroundFill[] backgroundFills;
    private Shape[] backgroundShapeCache;
    private BackgroundImage[] backgroundImages;
    private Border[] borders;
    private Shape[] borderShapeCache;
    private boolean resizeShape;
    private boolean positionShape;
    private static Offset nopEffect = new Offset(0, 0, null);
    private BaseEffectFilter nopEffectFilter;
    private static final float[] SIN_VALS = new float[]{1.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f};

    @Override
    public void setBorders(Border[] borderArray) {
        this.borders = borderArray;
        this.updateGeom();
    }

    @Override
    public void setBackgroundImages(BackgroundImage[] backgroundImageArray) {
        this.backgroundImages = backgroundImageArray;
        this.updateGeom();
    }

    @Override
    public void setBackgroundFills(BackgroundFill[] backgroundFillArray) {
        this.backgroundFills = backgroundFillArray;
        this.updateGeom();
    }

    @Override
    public void setShape(PGShape pGShape) {
        this.shape = pGShape == null ? null : ((NGShape)pGShape).getShape();
        this.updateGeom();
    }

    @Override
    public void setResizeShape(boolean bl) {
        if (this.resizeShape != bl) {
            this.resizeShape = bl;
            this.updateGeom();
        }
    }

    @Override
    public void setPositionShape(boolean bl) {
        if (this.positionShape != bl) {
            this.positionShape = bl;
            this.updateGeom();
        }
    }

    @Override
    public void setSize(float f, float f2) {
        if (this.width != f || this.height != f2) {
            this.width = f;
            this.height = f2;
            this.updateGeom();
        }
    }

    private float getReducingRatio(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = 1.0f;
        if (f3 + f4 > f) {
            f7 = Math.min(f7, f / (f3 + f4));
        }
        if (f4 + f6 > f2) {
            f7 = Math.min(f7, f2 / (f4 + f6));
        }
        if (f6 + f5 > f) {
            f7 = Math.min(f7, f / (f6 + f5));
        }
        if (f5 + f3 > f2) {
            f7 = Math.min(f7, f2 / (f5 + f3));
        }
        return f7;
    }

    private void updateGeom() {
        float f;
        float f2;
        float f3;
        float f4;
        if (this.shape != null && !this.resizeShape) {
            RectBounds rectBounds = this.shape.getBounds();
            if (this.positionShape) {
                f4 = (this.width - rectBounds.getWidth()) / 2.0f;
                f3 = (this.height - rectBounds.getHeight()) / 2.0f;
                f2 = f4 + rectBounds.getWidth();
                f = f3 + rectBounds.getHeight();
            } else {
                f4 = rectBounds.getMinX();
                f3 = rectBounds.getMinY();
                f2 = rectBounds.getMaxX();
                f = rectBounds.getMaxY();
            }
        } else {
            f3 = 0.0f;
            f4 = 0.0f;
            f2 = this.width;
            f = this.height;
        }
        float f5 = f4;
        float f6 = f3;
        float f7 = f2;
        float f8 = f;
        if (this.backgroundFills != null) {
            for (BackgroundFill object : this.backgroundFills) {
                f5 = Math.min(f5, f4 + object.leftOffset);
                f6 = Math.min(f6, f3 + object.topOffset);
                f7 = Math.max(f7, f2 - object.rightOffset);
                f8 = Math.max(f8, f - object.bottomOffset);
            }
        }
        if (this.backgroundImages != null) {
            for (BackgroundImage f14 : this.backgroundImages) {
                f5 = Math.min(f5, f4 + f14.left);
                f6 = Math.min(f6, f3 + f14.top);
                f7 = Math.max(f7, f2 - f14.right);
                f8 = Math.max(f8, f - f14.bottom);
            }
        }
        if (this.borders != null) {
            for (Border border : this.borders) {
                f5 = Math.min(f5, f4 + border.leftOffset - border.leftWidth / 2.0f);
                f6 = Math.min(f6, f3 + border.topOffset - border.topWidth / 2.0f);
                f7 = Math.max(f7, f2 - border.rightOffset + border.rightWidth / 2.0f);
                f8 = Math.max(f8, f - border.bottomOffset + border.bottomWidth / 2.0f);
            }
        }
        if (this.x1 != f5 || this.y1 != f6 || this.x2 != f7 || this.y2 != f8) {
            this.x1 = f5;
            this.x2 = f7;
            this.y1 = f6;
            this.y2 = f8;
            this.geometryChanged();
        } else {
            this.visualsChanged();
        }
        if (this.shape == null) {
            this.backgroundShapeCache = null;
            this.borderShapeCache = null;
        } else {
            float f9;
            float f10;
            int n;
            this.backgroundShapeCache = new Shape[this.backgroundFills.length];
            for (n = 0; n < this.backgroundFills.length; ++n) {
                BackgroundFill backgroundFill = this.backgroundFills[n];
                float f11 = backgroundFill.topOffset;
                float f12 = backgroundFill.leftOffset;
                f10 = backgroundFill.bottomOffset;
                f9 = backgroundFill.rightOffset;
                this.backgroundShapeCache[n] = this.createShape(this.shape, f11, f12, f10, f9);
            }
            this.borderShapeCache = new Shape[this.borders.length];
            for (n = 0; n < this.borders.length; ++n) {
                if (!(this.borders[n] instanceof StrokedBorder)) continue;
                StrokedBorder strokedBorder = (StrokedBorder)this.borders[n];
                float f13 = strokedBorder.topOffset + strokedBorder.topWidth / 2.0f;
                float f14 = strokedBorder.leftOffset + strokedBorder.leftWidth / 2.0f;
                f10 = strokedBorder.bottomOffset + strokedBorder.bottomWidth / 2.0f;
                f9 = strokedBorder.rightOffset + strokedBorder.rightWidth / 2.0f;
                this.borderShapeCache[n] = this.createShape(this.shape, f13, f14, f10, f9);
            }
        }
    }

    @Override
    protected void renderContent(Graphics graphics) {
        Object object;
        if (!graphics.getTransformNoClone().is2D() && this.isContentBounds2D()) {
            assert (this.getEffectFilter() == null);
            if (this.nopEffectFilter == null) {
                this.nopEffectFilter = this.createEffectFilter(nopEffect);
            }
            ((NGNode.EffectFilter)this.nopEffectFilter).render(graphics);
            return;
        }
        if (this.backgroundFills != null) {
            for (int i = 0; i < this.backgroundFills.length; ++i) {
                BackgroundFill backgroundFill = this.backgroundFills[i];
                graphics.setPaint((Paint)backgroundFill.fill);
                this.fillShape(graphics, backgroundFill, i);
            }
        }
        if (this.backgroundImages != null) {
            BackgroundImage[] backgroundImageArray = this.backgroundImages;
            int n = backgroundImageArray.length;
            for (int i = 0; i < n; ++i) {
                float f;
                float f2;
                float f3;
                float f4;
                float f5;
                float f6;
                float f7;
                float f8;
                BackgroundImage object22 = backgroundImageArray[i];
                object = (Image)object22.getImage();
                if (object == null) continue;
                float f9 = object22.getProportionalWidth() ? object22.getWidth() * this.width : object22.getWidth();
                float f10 = object22.getProportionalHeight() ? object22.getHeight() * this.height : object22.getHeight();
                if (object22.getCover() || object22.getContain()) {
                    f8 = this.width / (float)((Image)object).getWidth();
                    f7 = this.height / (float)((Image)object).getHeight();
                    f6 = object22.getContain() ? Math.min(f8, f7) : Math.max(f8, f7);
                    f5 = (float)Math.ceil(f6 * (float)((Image)object).getWidth());
                    f4 = (float)Math.ceil(f6 * (float)((Image)object).getHeight());
                } else if (object22.getWidth() > 0.0f && object22.getHeight() > 0.0f) {
                    f5 = f9;
                    f4 = f10;
                } else if (f9 > 0.0f) {
                    f5 = f9;
                    f8 = f5 / (float)((Image)object).getWidth();
                    f4 = (float)((Image)object).getHeight() * f8;
                } else if (f10 > 0.0f) {
                    f4 = f10;
                    f8 = f4 / (float)((Image)object).getHeight();
                    f5 = (float)((Image)object).getWidth() * f8;
                } else {
                    f5 = ((Image)object).getWidth();
                    f4 = ((Image)object).getHeight();
                }
                f8 = 0.0f;
                f7 = 0.0f;
                if (object22.getProportionalHPos()) {
                    f6 = object22.getLeft() * (this.width - f5);
                    f3 = object22.getRight() * (this.width - f5);
                } else {
                    f6 = object22.getLeft();
                    f3 = object22.getRight();
                }
                if (object22.getProportionalVPos()) {
                    f2 = object22.getTop() * (this.height - f4);
                    f = object22.getBottom() * (this.height - f4);
                } else {
                    f2 = object22.getTop();
                    f = object22.getBottom();
                }
                if (f6 != 0.0f) {
                    f8 = f6;
                } else if (f3 != 0.0f) {
                    f8 = this.width - f3;
                }
                if (f2 != 0.0f) {
                    f7 = f2;
                } else if (f != 0.0f) {
                    f7 = this.height - f;
                }
                this.paintTiles(graphics, (Image)object, object22.getRepeatX(), object22.getRepeatY(), 0.0f, 0.0f, this.width, this.height, 0, 0, -1, -1, f8, f7, f5, f4);
            }
        }
        if (this.borders != null) {
            for (Border border : this.borders) {
                if (!(border instanceof ImageBorder) || !((ImageBorder)border).fillCenter) continue;
                object = (ImageBorder)border;
                Image image = (Image)((ImageBorder)object).image;
                if (image == null) continue;
                int n = Math.round(((ImageBorder)object).leftOffset) + Math.round(((ImageBorder)object).leftWidth);
                int n2 = Math.round(((ImageBorder)object).topOffset) + Math.round(((ImageBorder)object).topWidth);
                int n3 = Math.round(this.width) - Math.round(((ImageBorder)object).rightOffset) - Math.round(((ImageBorder)object).rightWidth) - n;
                int n4 = Math.round(this.height) - Math.round(((ImageBorder)object).bottomOffset) - Math.round(((ImageBorder)object).bottomWidth) - n2;
                int n5 = ((ImageBorder)object).repeatX == Repeat.NO_REPEAT ? n3 : -1;
                int n6 = ((ImageBorder)object).repeatY == Repeat.NO_REPEAT ? n4 : -1;
                this.paintTiles(graphics, image, ((ImageBorder)object).repeatX, ((ImageBorder)object).repeatY, n, n2, n3, n4, (int)((ImageBorder)object).leftSlice, (int)((ImageBorder)object).topSlice, (int)((float)image.getWidth() - ((ImageBorder)object).leftSlice - ((ImageBorder)object).rightSlice), (int)((float)image.getHeight() - ((ImageBorder)object).topSlice - ((ImageBorder)object).bottomSlice), 0.0f, 0.0f, n5, n6);
            }
            for (int i = 0; i < this.borders.length; ++i) {
                Border border;
                Border border2 = this.borders[i];
                if (border2 instanceof StrokedBorder) {
                    border = (StrokedBorder)border2;
                    this.fillShape(graphics, (StrokedBorder)border, i);
                    continue;
                }
                border = (ImageBorder)border2;
                Image image = (Image)((ImageBorder)border).image;
                if (image == null) continue;
                int n = Math.round(((ImageBorder)border).leftWidth);
                int n7 = Math.round(((ImageBorder)border).rightWidth);
                int n8 = Math.round(((ImageBorder)border).topWidth);
                int n9 = Math.round(((ImageBorder)border).bottomWidth);
                int n10 = Math.round(((ImageBorder)border).leftOffset);
                int n11 = Math.round(((ImageBorder)border).rightOffset);
                int n12 = Math.round(((ImageBorder)border).topOffset);
                int n13 = Math.round(((ImageBorder)border).bottomOffset);
                int n14 = Math.round(((ImageBorder)border).leftSlice);
                int n15 = Math.round(((ImageBorder)border).rightSlice);
                int n16 = Math.round(((ImageBorder)border).topSlice);
                int n17 = Math.round(((ImageBorder)border).bottomSlice);
                if ((float)(n10 + n + n11 + n7) > this.width || (float)(n12 + n8 + n13 + n9) > this.height) continue;
                int n18 = n10 + n;
                int n19 = n12 + n8;
                int n20 = Math.round(this.width) - n11 - n7 - n18;
                int n21 = Math.round(this.height) - n13 - n9 - n19;
                int n22 = n20 + n18;
                int n23 = n21 + n19;
                float f = ((ImageBorder)border).repeatX == Repeat.NO_REPEAT ? (float)n20 : -1.0f;
                float f11 = ((ImageBorder)border).repeatY == Repeat.NO_REPEAT ? (float)n21 : -1.0f;
                this.paintTiles(graphics, image, Repeat.NO_REPEAT, Repeat.NO_REPEAT, n10, n12, n, n8, 0, 0, n14, n16, 0.0f, 0.0f, n, n8);
                this.paintTiles(graphics, image, ((ImageBorder)border).repeatX, Repeat.NO_REPEAT, n18, n12, n20, n8, n14, 0, image.getWidth() - n14 - n15, n16, 0.0f, 0.0f, f, n8);
                this.paintTiles(graphics, image, Repeat.NO_REPEAT, Repeat.NO_REPEAT, n22, n12, n7, n8, image.getWidth() - n15, 0, n15, n16, 0.0f, 0.0f, n7, n8);
                this.paintTiles(graphics, image, Repeat.NO_REPEAT, ((ImageBorder)border).repeatY, n10, n19, n, n21, 0, n16, n14, image.getHeight() - n16 - n17, 0.0f, 0.0f, n, f11);
                this.paintTiles(graphics, image, Repeat.NO_REPEAT, ((ImageBorder)border).repeatY, n22, n19, n7, n21, image.getWidth() - n15, n16, n15, image.getHeight() - n16 - n17, 0.0f, 0.0f, n7, f11);
                this.paintTiles(graphics, image, Repeat.NO_REPEAT, Repeat.NO_REPEAT, n10, n23, n, n9, 0, image.getHeight() - n17, n14, n17, 0.0f, 0.0f, n, n9);
                this.paintTiles(graphics, image, ((ImageBorder)border).repeatX, Repeat.NO_REPEAT, n18, n23, n20, n9, n14, image.getHeight() - n17, image.getWidth() - n14 - n15, n17, 0.0f, 0.0f, f, n9);
                this.paintTiles(graphics, image, Repeat.NO_REPEAT, Repeat.NO_REPEAT, n22, n23, n7, n9, image.getWidth() - n15, image.getHeight() - n17, n15, n17, 0.0f, 0.0f, n7, n9);
            }
        }
        super.renderContent(graphics);
    }

    public BasicStroke createStroke(BorderStyle borderStyle, float f) {
        int n = borderStyle.lineCap == PGShape.StrokeLineCap.BUTT ? 0 : (borderStyle.lineCap == PGShape.StrokeLineCap.SQUARE ? 2 : 1);
        int n2 = borderStyle.lineJoin == PGShape.StrokeLineJoin.BEVEL ? 2 : (borderStyle.lineJoin == PGShape.StrokeLineJoin.MITER ? 0 : 1);
        if (borderStyle.strokeType != PGShape.StrokeType.CENTERED) {
            f *= 2.0f;
        }
        BasicStroke basicStroke = borderStyle.strokeDashArray.length > 0 ? new BasicStroke(f, n, n2, borderStyle.strokeMiterLimit, borderStyle.strokeDashArray, borderStyle.strokeDashOffset) : new BasicStroke(f, n, n2, borderStyle.strokeMiterLimit);
        return basicStroke;
    }

    private void fillShape(Graphics graphics, StrokedBorder strokedBorder, int n) {
        boolean bl;
        float f = strokedBorder.topOffset + strokedBorder.topWidth / 2.0f;
        float f2 = strokedBorder.leftOffset + strokedBorder.leftWidth / 2.0f;
        float f3 = strokedBorder.bottomOffset + strokedBorder.bottomWidth / 2.0f;
        float f4 = strokedBorder.rightOffset + strokedBorder.rightWidth / 2.0f;
        float f5 = strokedBorder.topLeftRadius;
        float f6 = strokedBorder.topRightRadius;
        float f7 = strokedBorder.bottomLeftRadius;
        float f8 = strokedBorder.bottomRightRadius;
        boolean bl2 = f5 == f6 && f5 == f7 && f5 == f8;
        boolean bl3 = strokedBorder.topFill == null && strokedBorder.rightFill == null && strokedBorder.bottomFill == null && strokedBorder.leftFill == null || strokedBorder.leftFill != null && strokedBorder.leftFill.equals(strokedBorder.topFill) && strokedBorder.leftFill.equals(strokedBorder.rightFill) && strokedBorder.leftFill.equals(strokedBorder.bottomFill);
        boolean bl4 = strokedBorder.leftWidth == strokedBorder.topWidth && strokedBorder.leftWidth == strokedBorder.rightWidth && strokedBorder.leftWidth == strokedBorder.bottomWidth;
        boolean bl5 = bl = strokedBorder.topStyle == strokedBorder.bottomStyle && strokedBorder.topStyle == strokedBorder.leftStyle && strokedBorder.topStyle == strokedBorder.rightStyle;
        if (this.shape != null) {
            this.setBorderStyle(graphics, strokedBorder);
            graphics.draw(this.borderShapeCache[n]);
        } else if (bl3 && bl4 && bl) {
            float f9 = this.width - f2 - f4;
            float f10 = this.height - f - f3;
            if (f9 >= 0.0f && f10 >= 0.0f) {
                this.setBorderStyle(graphics, strokedBorder);
                if (bl2 && f5 == 0.0f) {
                    graphics.drawRect(f2, f, f9, f10);
                } else if (bl2) {
                    float f11 = f5 + f5;
                    if (f11 > f9) {
                        f11 = f9;
                    }
                    if (f11 > f10) {
                        f11 = f10;
                    }
                    graphics.drawRoundRect(f2, f, f9, f10, f11, f11);
                } else {
                    graphics.draw(this.createPath(f, f2, f3, f4, f5, f6, f7, f8));
                }
            }
        } else if (bl2 && f5 == 0.0f) {
            if (strokedBorder.topStyle != null && strokedBorder.topFill != null && strokedBorder.topFill != Color.TRANSPARENT) {
                graphics.setPaint((Paint)strokedBorder.topFill);
                if (BorderStyle.SOLID == strokedBorder.topStyle) {
                    graphics.fillRect(strokedBorder.leftOffset, strokedBorder.topOffset, this.width - strokedBorder.leftOffset - strokedBorder.rightOffset, strokedBorder.topWidth);
                } else {
                    graphics.setStroke(this.createStroke(strokedBorder.topStyle, strokedBorder.topWidth));
                    graphics.drawLine(f2, f, this.width - f4, f);
                }
            }
            if (strokedBorder.bottomStyle != null && strokedBorder.bottomFill != null && strokedBorder.bottomFill != Color.TRANSPARENT) {
                graphics.setPaint((Paint)strokedBorder.bottomFill);
                if (BorderStyle.SOLID == strokedBorder.bottomStyle) {
                    graphics.fillRect(strokedBorder.leftOffset, this.height - strokedBorder.bottomOffset - strokedBorder.bottomWidth, this.width - strokedBorder.leftOffset - strokedBorder.rightOffset, strokedBorder.bottomWidth);
                } else {
                    graphics.setStroke(this.createStroke(strokedBorder.bottomStyle, strokedBorder.bottomWidth));
                    graphics.drawLine(f2, this.height - f3, this.width - f4, this.height - f3);
                }
            }
            if (strokedBorder.rightStyle != null && strokedBorder.rightFill != null && strokedBorder.rightFill != Color.TRANSPARENT) {
                graphics.setPaint((Paint)strokedBorder.rightFill);
                if (BorderStyle.SOLID == strokedBorder.rightStyle) {
                    graphics.fillRect(this.width - strokedBorder.rightOffset - strokedBorder.rightWidth, strokedBorder.topOffset, strokedBorder.rightWidth, this.height - strokedBorder.topOffset - strokedBorder.bottomOffset);
                } else {
                    graphics.setStroke(this.createStroke(strokedBorder.rightStyle, strokedBorder.rightWidth));
                    graphics.drawLine(this.width - f4, strokedBorder.topOffset, this.width - f4, this.height - strokedBorder.bottomOffset);
                }
            }
            if (strokedBorder.leftStyle != null && strokedBorder.leftFill != null && strokedBorder.leftFill != Color.TRANSPARENT) {
                graphics.setPaint((Paint)strokedBorder.leftFill);
                if (BorderStyle.SOLID == strokedBorder.leftStyle) {
                    graphics.fillRect(strokedBorder.leftOffset, strokedBorder.topOffset, strokedBorder.leftWidth, this.height - strokedBorder.topOffset - strokedBorder.bottomOffset);
                } else {
                    graphics.setStroke(this.createStroke(strokedBorder.leftStyle, strokedBorder.leftWidth));
                    graphics.drawLine(f2, strokedBorder.topOffset, f2, this.height - strokedBorder.bottomOffset);
                }
            }
        } else {
            Path2D[] path2DArray = this.createPaths(f, f2, f3, f4, f5, f6, f7, f8);
            if (strokedBorder.topStyle != null) {
                graphics.setStroke(this.createStroke(strokedBorder.topStyle, strokedBorder.topWidth));
                graphics.setPaint((Paint)strokedBorder.topFill);
                graphics.draw(path2DArray[0]);
            }
            if (strokedBorder.rightStyle != null) {
                graphics.setStroke(this.createStroke(strokedBorder.rightStyle, strokedBorder.rightWidth));
                graphics.setPaint((Paint)strokedBorder.rightFill);
                graphics.draw(path2DArray[1]);
            }
            if (strokedBorder.bottomStyle != null) {
                graphics.setStroke(this.createStroke(strokedBorder.bottomStyle, strokedBorder.bottomWidth));
                graphics.setPaint((Paint)strokedBorder.bottomFill);
                graphics.draw(path2DArray[2]);
            }
            if (strokedBorder.leftStyle != null) {
                graphics.setStroke(this.createStroke(strokedBorder.leftStyle, strokedBorder.leftWidth));
                graphics.setPaint((Paint)strokedBorder.leftFill);
                graphics.draw(path2DArray[3]);
            }
        }
    }

    private void setBorderStyle(Graphics graphics, StrokedBorder strokedBorder) {
        BorderStyle borderStyle = strokedBorder.topStyle;
        float f = strokedBorder.topWidth;
        Object object = strokedBorder.topFill;
        if (borderStyle == null) {
            borderStyle = strokedBorder.leftStyle;
            f = strokedBorder.leftWidth;
            object = strokedBorder.leftFill;
            if (borderStyle == null) {
                borderStyle = strokedBorder.bottomStyle;
                f = strokedBorder.bottomWidth;
                object = strokedBorder.bottomFill;
                if (borderStyle == null) {
                    borderStyle = strokedBorder.rightStyle;
                    f = strokedBorder.rightWidth;
                    object = strokedBorder.rightFill;
                }
            }
        }
        if (borderStyle == null) {
            return;
        }
        graphics.setStroke(this.createStroke(borderStyle, f));
        graphics.setPaint((Paint)object);
    }

    private void fillShape(Graphics graphics, BackgroundFill backgroundFill, int n) {
        if (this.shape != null) {
            graphics.fill(this.backgroundShapeCache[n]);
        } else {
            float f = backgroundFill.topOffset;
            float f2 = backgroundFill.leftOffset;
            float f3 = backgroundFill.bottomOffset;
            float f4 = backgroundFill.rightOffset;
            float f5 = backgroundFill.topLeftRadius;
            float f6 = backgroundFill.topRightRadius;
            float f7 = backgroundFill.bottomLeftRadius;
            float f8 = backgroundFill.bottomRightRadius;
            float f9 = this.width - f2 - f4;
            float f10 = this.height - f - f3;
            if (f9 > 0.0f && f10 > 0.0f) {
                if (f5 == f6 && f5 == f7 && f5 == f8) {
                    if (f5 == 0.0f) {
                        graphics.fillRect(f2, f, f9, f10);
                    } else {
                        float f11 = f5 + f5;
                        if (f11 > f9) {
                            f11 = f9;
                        }
                        if (f11 > f10) {
                            f11 = f10;
                        }
                        graphics.fillRoundRect(f2, f, f9, f10, f11, f11);
                    }
                } else {
                    graphics.fill(this.createPath(f, f2, f3, f4, f5, f6, f7, f8));
                }
            }
        }
    }

    private void doCorner(Path2D path2D, float f, float f2, float f3, int n) {
        if (f3 > 0.0f) {
            float f4 = f3 * SIN_VALS[n + 1];
            float f5 = f3 * SIN_VALS[n];
            path2D.appendOvalQuadrant(f + f4, f2 + f5, f, f2, f + f5, f2 - f4, 0.0f, 1.0f, n == 0 ? Path2D.CornerPrefix.MOVE_THEN_CORNER : Path2D.CornerPrefix.LINE_THEN_CORNER);
        } else if (n == 0) {
            path2D.moveTo(f, f2);
        } else {
            path2D.lineTo(f, f2);
        }
    }

    private Path2D createPath(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9 = this.width - f4;
        float f10 = this.height - f3;
        float f11 = this.getReducingRatio(f9 - f2, f10 - f, f5, f6, f7, f8);
        if (f11 < 1.0f) {
            f5 *= f11;
            f6 *= f11;
            f7 *= f11;
            f8 *= f11;
        }
        Path2D path2D = new Path2D();
        this.doCorner(path2D, f2, f, f5, 0);
        this.doCorner(path2D, f9, f, f6, 1);
        this.doCorner(path2D, f9, f10, f8, 2);
        this.doCorner(path2D, f2, f10, f7, 3);
        path2D.closePath();
        return path2D;
    }

    private Path2D makeRoundedEdge(float f, float f2, float f3, float f4, float f5, float f6, int n) {
        float f7;
        float f8;
        Path2D path2D = new Path2D();
        if (f5 > 0.0f) {
            f8 = f5 * SIN_VALS[n + 1];
            f7 = f5 * SIN_VALS[n];
            path2D.appendOvalQuadrant(f + f8, f2 + f7, f, f2, f + f7, f2 - f8, 0.5f, 1.0f, Path2D.CornerPrefix.MOVE_THEN_CORNER);
        } else {
            path2D.moveTo(f, f2);
        }
        if (f6 > 0.0f) {
            f8 = f6 * SIN_VALS[n + 2];
            f7 = f6 * SIN_VALS[n + 1];
            path2D.appendOvalQuadrant(f3 + f8, f4 + f7, f3, f4, f3 + f7, f4 - f8, 0.0f, 0.5f, Path2D.CornerPrefix.LINE_THEN_CORNER);
        } else {
            path2D.lineTo(f3, f4);
        }
        return path2D;
    }

    private Path2D[] createPaths(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9 = this.width - f4;
        float f10 = this.height - f3;
        float f11 = this.getReducingRatio(f9 - f2, f10 - f, f5, f6, f7, f8);
        if (f11 < 1.0f) {
            f5 *= f11;
            f6 *= f11;
            f7 *= f11;
            f8 *= f11;
        }
        return new Path2D[]{this.makeRoundedEdge(f2, f, f9, f, f5, f6, 0), this.makeRoundedEdge(f9, f, f9, f10, f6, f8, 1), this.makeRoundedEdge(f9, f10, f2, f10, f8, f7, 2), this.makeRoundedEdge(f2, f10, f2, f, f7, f5, 3)};
    }

    private Shape createShape(Shape shape, float f, float f2, float f3, float f4) {
        float f5 = this.width - f2 - f4;
        float f6 = this.height - f - f3;
        Affine2D affine2D = new Affine2D();
        RectBounds rectBounds = shape.getBounds();
        if (this.resizeShape) {
            affine2D.translate(f2, f);
            affine2D.scale(f5 / rectBounds.getWidth(), f6 / rectBounds.getHeight());
            if (this.positionShape) {
                affine2D.translate(-rectBounds.getMinX(), -rectBounds.getMinY());
            }
        } else if (this.positionShape) {
            if (f != 0.0f || f4 != 0.0f || f3 != 0.0f || f2 != 0.0f) {
                float f7 = rectBounds.getWidth() - f2 - f4;
                float f8 = rectBounds.getHeight() - f - f3;
                affine2D.translate((this.width - f7) / 2.0f, (this.height - f8) / 2.0f);
                affine2D.scale(f7 / rectBounds.getWidth(), f8 / rectBounds.getHeight());
                affine2D.translate(-rectBounds.getMinX(), -rectBounds.getMinY());
            } else {
                affine2D.translate(-rectBounds.getMinX(), -rectBounds.getMinY());
                affine2D.translate((this.width - rectBounds.getWidth()) / 2.0f, (this.height - rectBounds.getHeight()) / 2.0f);
            }
        } else if (f != 0.0f || f4 != 0.0f || f3 != 0.0f || f2 != 0.0f) {
            float f9 = rectBounds.getWidth() - f2 - f4;
            float f10 = rectBounds.getHeight() - f - f3;
            affine2D.scale(f9 / rectBounds.getWidth(), f10 / rectBounds.getHeight());
        }
        return affine2D.isIdentity() ? shape : affine2D.createTransformedShape(shape);
    }

    @Override
    protected boolean hasOverlappingContents() {
        return true;
    }

    private void paintTiles(Graphics graphics, Image image, Repeat repeat, Repeat repeat2, float f, float f2, float f3, float f4, int n, int n2, int n3, int n4, float f5, float f6, float f7, float f8) {
        float f9;
        float f10;
        int n5;
        float f11;
        float f12;
        int n6;
        float f13;
        float f14;
        if (f3 == 0.0f || f4 == 0.0f || n3 == 0 || n4 == 0) {
            return;
        }
        BaseTransform baseTransform = graphics.getTransformNoClone().copy();
        graphics.translate(f, f2);
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = image.getWidth();
        }
        if (n4 < 0) {
            n4 = image.getHeight();
        }
        float f15 = f7 > 0.0f ? f7 : (f14 = n3 > 0 ? (float)n3 : (float)image.getWidth());
        float f16 = f8 > 0.0f ? f8 : (f13 = n4 > 0 ? (float)n4 : (float)image.getHeight());
        if (repeat == Repeat.SPACE && f3 < f14 * 2.0f) {
            repeat = Repeat.NO_REPEAT;
        }
        if (repeat2 == Repeat.SPACE && f4 < f13 * 2.0f) {
            repeat2 = Repeat.NO_REPEAT;
        }
        float f17 = 0.0f;
        float f18 = 0.0f;
        int n7 = 0;
        int n8 = 0;
        if (repeat == Repeat.REPEAT) {
            f14 = Math.round(f14);
            f17 = f5 == 0.0f ? 0.0f : f5 % f14 - f14;
            n6 = (int)Math.max(1.0, Math.ceil((f3 + Math.abs(f17)) / f14));
            f11 = f12 = f14;
        } else if (repeat == Repeat.SPACE) {
            n6 = (int)Math.max(1.0, Math.floor(f3 / f14));
            f11 = n6 == 1 ? 0.0f : (f3 - (float)n6 * f14) / (float)(n6 - 1) + f14;
            f12 = f14;
        } else if (repeat == Repeat.ROUND) {
            n6 = (int)Math.max(1.0, Math.ceil(f3 / f14));
            f11 = f12 = (float)Math.ceil(f3 / (float)n6);
            n7 = (int)Math.abs(Math.floor(f3 - f12 * (float)n6));
        } else {
            n6 = 1;
            f17 = f5;
            f11 = f12 = f14;
        }
        if (repeat2 == Repeat.REPEAT) {
            f13 = Math.round(f13);
            f18 = f6 == 0.0f ? 0.0f : f6 % f13 - f13;
            n5 = (int)Math.max(1.0, Math.ceil((f4 + Math.abs(f18)) / f13));
            f9 = f10 = f13;
        } else if (repeat2 == Repeat.SPACE) {
            n5 = (int)Math.floor(f4 / f13);
            f9 = n5 == 1 ? 0.0f : (f4 - (float)n5 * f13) / (float)(n5 - 1) + f13;
            f10 = f13;
        } else if (repeat2 == Repeat.ROUND) {
            n5 = (int)Math.max(1.0, Math.ceil(f4 / f13));
            f9 = f10 = (float)Math.ceil(f4 / (float)n5);
            n8 = (int)Math.abs(Math.floor(f4 - f10 * (float)n5));
        } else {
            n5 = 1;
            f18 = f6;
            f9 = f10 = f13;
        }
        if (repeat == Repeat.REPEAT && repeat2 == Repeat.REPEAT) {
            if (n != 0 || n2 != 0 || n3 != image.getWidth() || n4 != image.getHeight()) {
                image = image.createSubImage(n, n2, n3, n4);
            }
            graphics.setPaint(new ImagePattern(image, f5, f6, f14, f13, false));
            graphics.fillRect(f, f2, f3, f4);
        } else {
            graphics.translate(f17, f18);
            Texture texture = graphics.getResourceFactory().getCachedTexture(image);
            float f19 = f18;
            float f20 = f10;
            for (int i = 0; i < n5; ++i) {
                int n9;
                int n10 = n9 = i < n8 ? -1 : 0;
                if (f19 + f20 > f4) {
                    f20 = f4 - f19;
                    n4 = (int)((float)n4 * (f20 / f10));
                }
                float f21 = f17;
                float f22 = f12;
                float f23 = n3;
                for (int j = 0; j < n6; ++j) {
                    int n11;
                    int n12 = n11 = j < n7 ? -1 : 0;
                    if (f21 + f22 > f3) {
                        f22 = f3 - f21;
                        f23 *= f22 / f12;
                    }
                    graphics.drawTexture(texture, 0.0f, 0.0f, (int)f22, (int)f20, n, n2, (float)n + f23 + (float)n11, n2 + n4 + n9);
                    graphics.translate(f11 + (float)n11, 0.0f);
                    f21 += f11 + (float)n11;
                }
                graphics.translate(-((float)n6 * f11) + (float)n7, f9 + (float)n9);
                f19 += f9 + (float)n9;
            }
        }
        graphics.setTransform(baseTransform);
    }

    @Override
    protected boolean hasVisuals() {
        return this.borders != null && this.borders.length > 0 || this.backgroundImages != null && this.backgroundImages.length > 0 || this.backgroundFills != null && this.backgroundFills.length > 0;
    }
}

