/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.LenientPlatformResolveMetadata;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.PotentialEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.VirtualPlatformState;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.external.model.DefaultConfigurationMetadata;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.VariantMetadataRules;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.ForcingDependencyMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.LocalComponentDependencyMetadata;

class LenientPlatformDependencyMetadata
implements ModuleDependencyMetadata,
ForcingDependencyMetadata {
    private final ResolveState resolveState;
    private final NodeState from;
    private final ModuleComponentSelector cs;
    private final ModuleComponentIdentifier componentId;
    private final ComponentIdentifier platformId;
    private final boolean force;
    private final boolean transitive;

    LenientPlatformDependencyMetadata(ResolveState resolveState, NodeState from, ModuleComponentSelector cs, ModuleComponentIdentifier componentId, ComponentIdentifier platformId, boolean force, boolean transitive) {
        this.resolveState = resolveState;
        this.from = from;
        this.cs = cs;
        this.componentId = componentId;
        this.platformId = platformId;
        this.force = force;
        this.transitive = transitive;
    }

    @Override
    public ModuleComponentSelector getSelector() {
        return this.cs;
    }

    @Override
    public ModuleDependencyMetadata withRequestedVersion(VersionConstraint requestedVersion) {
        return this;
    }

    @Override
    public ModuleDependencyMetadata withReason(String reason) {
        return this;
    }

    @Override
    public List<ConfigurationMetadata> selectConfigurations(ImmutableAttributes consumerAttributes, ComponentResolveMetadata targetComponent, AttributesSchemaInternal consumerSchema, Collection<? extends Capability> explicitRequestedCapabilities) {
        if (targetComponent instanceof LenientPlatformResolveMetadata) {
            LenientPlatformResolveMetadata platformMetadata = (LenientPlatformResolveMetadata)targetComponent;
            return Collections.singletonList(new LenientPlatformConfigurationMetadata(platformMetadata.getPlatformState(), this.platformId));
        }
        return new LocalComponentDependencyMetadata((ComponentIdentifier)this.componentId, (ComponentSelector)this.cs, null, (AttributeContainer)ImmutableAttributes.EMPTY, (AttributeContainer)ImmutableAttributes.EMPTY, null, Collections.emptyList(), Collections.emptyList(), false, false, true, false, null).selectConfigurations(consumerAttributes, targetComponent, consumerSchema, explicitRequestedCapabilities);
    }

    @Override
    public List<ExcludeMetadata> getExcludes() {
        return Collections.emptyList();
    }

    @Override
    public List<IvyArtifactName> getArtifacts() {
        return Collections.emptyList();
    }

    @Override
    public DependencyMetadata withTarget(ComponentSelector target) {
        return this;
    }

    @Override
    public boolean isChanging() {
        return false;
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public boolean isConstraint() {
        return true;
    }

    @Override
    public String getReason() {
        return "belongs to platform " + this.platformId;
    }

    public String toString() {
        return "virtual metadata for " + this.componentId;
    }

    @Override
    public boolean isForce() {
        return this.force;
    }

    @Override
    public ForcingDependencyMetadata forced() {
        return new LenientPlatformDependencyMetadata(this.resolveState, this.from, this.cs, this.componentId, this.platformId, true, this.transitive);
    }

    private class LenientPlatformConfigurationMetadata
    extends DefaultConfigurationMetadata
    implements ConfigurationMetadata {
        private final VirtualPlatformState platformState;
        private final ComponentIdentifier platformId;

        public LenientPlatformConfigurationMetadata(VirtualPlatformState platform, ComponentIdentifier platformId) {
            super(LenientPlatformDependencyMetadata.this.componentId, "default", true, false, (ImmutableSet<String>)ImmutableSet.of((Object)"default"), (ImmutableList<? extends ModuleComponentArtifactMetadata>)ImmutableList.of(), VariantMetadataRules.noOp(), (ImmutableList<ExcludeMetadata>)ImmutableList.of(), ImmutableAttributes.EMPTY);
            this.platformState = platform;
            this.platformId = platformId;
        }

        @Override
        public List<? extends DependencyMetadata> getDependencies() {
            List<DependencyMetadata> result = null;
            List<String> candidateVersions = this.platformState.getCandidateVersions();
            Set<ModuleResolveState> modules = this.platformState.getParticipatingModules();
            for (ModuleResolveState module : modules) {
                ComponentState selected = module.getSelected();
                if (selected == null) continue;
                String componentVersion = selected.getId().getVersion();
                for (String target : candidateVersions) {
                    ModuleComponentIdentifier leafId = DefaultModuleComponentIdentifier.newId(module.getId(), target);
                    ModuleComponentSelector leafSelector = DefaultModuleComponentSelector.newSelector(module.getId(), target);
                    ComponentIdentifier platformId = this.platformState.getSelectedPlatformId();
                    if (platformId == null) {
                        platformId = this.platformId;
                    }
                    if (!componentVersion.equals(target)) {
                        PotentialEdge potentialEdge = PotentialEdge.of(LenientPlatformDependencyMetadata.this.resolveState, LenientPlatformDependencyMetadata.this.from, leafId, leafSelector, platformId, this.platformState.isForced(), false);
                        if (potentialEdge.metadata == null) continue;
                        result = this.registerPlatformEdge(result, modules, leafId, leafSelector, platformId, this.platformState.isForced());
                        break;
                    }
                    result = this.registerPlatformEdge(result, modules, leafId, leafSelector, platformId, this.platformState.isForced());
                    break;
                }
                this.platformState.attachOrphanEdges();
            }
            return result == null ? Collections.emptyList() : result;
        }

        private List<DependencyMetadata> registerPlatformEdge(List<DependencyMetadata> result, Set<ModuleResolveState> modules, ModuleComponentIdentifier leafId, ModuleComponentSelector leafSelector, ComponentIdentifier platformId, boolean force) {
            if (result == null) {
                result = Lists.newArrayListWithExpectedSize((int)modules.size());
            }
            result.add(new LenientPlatformDependencyMetadata(LenientPlatformDependencyMetadata.this.resolveState, LenientPlatformDependencyMetadata.this.from, leafSelector, leafId, platformId, force, false));
            return result;
        }
    }
}

