/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableContainer;
import org.netbeans.lib.profiler.ui.swing.renderer.LabelRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.ProfilerRenderer;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.ProfilerTopComponent;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.actions.CompareSnapshotsAction;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilerStorage;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.netbeans.modules.profiler.v2.impl.Bundle;
import org.netbeans.modules.profiler.v2.impl.SnapshotsWindowHelper;
import org.netbeans.modules.profiler.v2.ui.ProjectSelector;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class SnapshotsWindowUI
extends ProfilerTopComponent {
    public static final String ID = "SnapshotsWindowUI";
    private static final HelpCtx HELP_CTX = new HelpCtx("SnapshotsWindow.HelpCtx");
    private ProfilerTable snapshotsTable;
    private ProjectSelector selector;
    private ChangeListener openProjectsListener;
    private FileObject currentFolder;
    private final List<Snapshot> snapshots = new ArrayList<Snapshot>();
    private Action openA;
    private Action exportA;
    private Action compareA;
    private Action renameA;
    private Action deleteA;
    private final AbstractTableModel snapshotsTableModel = new AbstractTableModel(){

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Bundle.SnapshotsWindowUI_colType();
            }
            if (n == 1) {
                return Bundle.SnapshotsWindowUI_colName();
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return Integer.class;
            }
            if (n == 1) {
                return Snapshot.class;
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return SnapshotsWindowUI.this.snapshots.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return ((Snapshot)SnapshotsWindowUI.this.snapshots.get(n)).getSnapshotType();
            }
            if (n2 == 1) {
                return SnapshotsWindowUI.this.snapshots.get(n);
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    };

    public SnapshotsWindowUI() {
        this.setName(Bundle.SnapshotsWindowUI_name());
        this.setIcon(Icons.getImage((String)"ProfilerIcons.SnapshotTake"));
        this.getAccessibleContext().setAccessibleDescription(Bundle.SnapshotsWindowUI_accessDescr());
        this.putClientProperty(ID, ID);
        this.initUI();
    }

    public void refreshFolder(FileObject fileObject, boolean bl) {
        File file;
        File file2 = fileObject == null ? null : FileUtil.toFile((FileObject)fileObject);
        File file3 = file = this.currentFolder == null ? null : FileUtil.toFile((FileObject)this.currentFolder);
        if (Objects.equals(file2, file)) {
            if (bl) {
                this.refreshSnapshots();
            } else {
                this.snapshotsTableModel.fireTableDataChanged();
            }
        }
    }

    public void setProject(Lookup.Provider provider) {
        this.selector.setProject(provider);
    }

    public void resetProject(Lookup.Provider provider) {
        this.selector.resetProject(provider);
    }

    void refreshSnapshots() {
        final Lookup.Provider provider = this.selector.getProject();
        SnapshotsWindowHelper.PROCESSOR.post(new Runnable(){

            @Override
            public void run() {
                ResultsManager resultsManager = ResultsManager.getDefault();
                final ArrayList<Snapshot> arrayList = new ArrayList<Snapshot>();
                for (FileObject fileObject : resultsManager.listSavedSnapshots(provider, null)) {
                    arrayList.add(new Snapshot(fileObject){

                        @Override
                        boolean alternativeSorting() {
                            return SnapshotsWindowUI.this.snapshotsTable.getSortColumn() == 0;
                        }
                    });
                }
                for (FileObject fileObject : resultsManager.listSavedHeapdumps(provider, null)) {
                    arrayList.add(new Snapshot(fileObject){

                        @Override
                        boolean alternativeSorting() {
                            return SnapshotsWindowUI.this.snapshotsTable.getSortColumn() == 0;
                        }
                    });
                }
                FileObject fileObject = null;
                try {
                    fileObject = ProfilerStorage.getProjectFolder((Lookup.Provider)provider, (boolean)false);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                final FileObject fileObject2 = fileObject;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SnapshotsWindowUI.this.currentFolder = fileObject2;
                        SnapshotsWindowUI.this.snapshots.clear();
                        SnapshotsWindowUI.this.snapshots.addAll(arrayList);
                        SnapshotsWindowUI.this.snapshotsTableModel.fireTableDataChanged();
                    }
                });
            }
        });
    }

    private void initUI() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(true);
        jPanel.setBackground(UIUtils.getProfilerResultsBackground());
        int n = 0;
        JLabel jLabel = new JLabel(Bundle.SnapshotsWindowUI_lblProject(), 10);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        jPanel.add((Component)jLabel, gridBagConstraints);
        ProjectSelector.Populator populator = new ProjectSelector.Populator(){

            @Override
            protected Lookup.Provider initialProject() {
                ProfilerSession profilerSession = ProfilerSession.currentSession();
                return profilerSession == null ? ProjectUtilities.getMainProject() : profilerSession.getProject();
            }

            @Override
            protected Collection<Lookup.Provider> additionalProjects() {
                Lookup.Provider provider;
                ProfilerSession profilerSession = ProfilerSession.currentSession();
                Lookup.Provider provider2 = provider = profilerSession == null ? null : profilerSession.getProject();
                if (provider != null) {
                    return Collections.singleton(provider);
                }
                return super.additionalProjects();
            }
        };
        this.selector = new ProjectSelector(populator){

            protected void selectionChanged() {
                SnapshotsWindowUI.this.refreshSnapshots();
            }
        };
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 10, 0, 10);
        jPanel.add((Component)((Object)this.selector), gridBagConstraints);
        JLabel jLabel2 = new JLabel(Bundle.SnapshotsWindowUI_lblSnapshots(), 10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 10, 0, 10);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.openA = new AbstractAction(Bundle.SnapshotsWindowUI_actOpenSnapshots()){
            {
                this.putValue("BTN_TOOLTIP", Bundle.SnapshotsWindowUI_descOpenSnapshots());
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotsWindowUI.openSnapshots(SnapshotsWindowUI.this.snapshotsTable.getSelectedValues(1));
            }
        };
        this.exportA = new AbstractAction(Bundle.SnapshotsWindowUI_actExportSnapshot()){
            {
                this.putValue("BTN_TOOLTIP", Bundle.SnapshotsWindowUI_descExportSnapshot());
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotsWindowUI.exportSnapshots(SnapshotsWindowUI.this.snapshotsTable.getSelectedValues(1));
            }
        };
        this.compareA = new AbstractAction(Bundle.SnapshotsWindowUI_actCompareSnapshots()){
            {
                this.putValue("BTN_TOOLTIP", Bundle.SnapshotsWindowUI_descCompareSnapshots());
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                List list = SnapshotsWindowUI.this.snapshotsTable.getSelectedValues(1);
                SnapshotsWindowUI.compareSnapshots((Snapshot)list.get(0), (Snapshot)list.get(1));
            }
        };
        this.renameA = new AbstractAction(Bundle.SnapshotsWindowUI_actRenameSnapshot()){
            {
                this.putValue("BTN_TOOLTIP", Bundle.SnapshotsWindowUI_descRenameSnapshot());
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Snapshot snapshot = (Snapshot)SnapshotsWindowUI.this.snapshotsTable.getSelectedValue(1);
                SnapshotsWindowUI.renameSnapshot(snapshot, SnapshotsWindowUI.this.snapshotsTableModel);
            }
        };
        this.deleteA = new AbstractAction(Bundle.SnapshotsWindowUI_actDeleteSnapshots()){
            {
                this.putValue("BTN_TOOLTIP", Bundle.SnapshotsWindowUI_descDeleteSnapshots());
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotsWindowUI.this.deleteSnapshots(SnapshotsWindowUI.this.snapshotsTable.getSelectedValues(1));
            }
        };
        this.snapshotsTable = new ProfilerTable(this.snapshotsTableModel, true, true, null){

            protected void populatePopup(final JPopupMenu jPopupMenu, Object object, Object object2) {
                jPopupMenu.add(new JMenuItem(SnapshotsWindowUI.this.openA){
                    {
                        super(action);
                        this.setFont(jPopupMenu.getFont().deriveFont(1));
                    }
                });
                jPopupMenu.add(new JMenuItem(SnapshotsWindowUI.this.exportA));
                jPopupMenu.add(new JMenuItem(SnapshotsWindowUI.this.compareA));
                jPopupMenu.add(new JMenuItem(SnapshotsWindowUI.this.renameA));
                jPopupMenu.add(new JMenuItem(SnapshotsWindowUI.this.deleteA));
            }
        };
        this.snapshotsTable.providePopupMenu(true);
        this.snapshotsTable.setMainColumn(1);
        this.snapshotsTable.setDefaultSortOrder(SortOrder.ASCENDING);
        this.snapshotsTable.setSecondarySortColumn(1);
        this.snapshotsTable.setSortColumn(0);
        this.snapshotsTable.setFitWidthColumn(1);
        this.snapshotsTable.setDefaultColumnWidth(0, new JLabel((String)Bundle.SnapshotsWindowUI_colType()).getPreferredSize().width + 30);
        this.snapshotsTable.setColumnRenderer(0, (ProfilerRenderer)new LabelRenderer(){
            {
                this.setHorizontalAlignment(0);
            }

            public void setValue(Object object, int n) {
                if (object == null) {
                    this.setIcon(null);
                } else {
                    this.setIcon(Icons.getIcon((String)Snapshot.getIconName((Integer)object)));
                }
            }
        });
        this.snapshotsTable.setColumnRenderer(1, (ProfilerRenderer)new LabelRenderer(){
            private final Font plain = this.getFont().deriveFont(0);
            private final Font bold = this.plain.deriveFont(1);

            public void setValue(Object object, int n) {
                if (object == null) {
                    this.setText("");
                } else {
                    Snapshot snapshot = (Snapshot)object;
                    this.setText(snapshot.getDisplayName());
                    if (SnapshotsWindowUI.isOpen(snapshot)) {
                        this.setFont(this.bold);
                    } else {
                        this.setFont(this.plain);
                    }
                }
            }
        });
        this.snapshotsTable.setColumnToolTips(new String[]{Bundle.SnapshotsWindowUI_ttpSnapshotType(), Bundle.SnapshotsWindowUI_ttpSnapshotName()});
        this.snapshotsTable.setDefaultAction(this.openA);
        this.snapshotsTable.setSelectionMode(2);
        this.snapshotsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SnapshotsWindowUI.this.updateButtons(SnapshotsWindowUI.this.snapshotsTable.getSelectedValues(1));
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 10, 10, 10);
        jPanel.add((Component)new ProfilerTableContainer(this.snapshotsTable, true, null), gridBagConstraints);
        this.setLayout(new BorderLayout());
        this.add(jPanel, "Center");
        JPanel jPanel2 = new JPanel(new ButtonsLayout());
        jPanel2.setOpaque(true);
        jPanel2.setBackground(UIUtils.getProfilerResultsBackground());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        class ThinButton
        extends JButton {
            public ThinButton(Action action, Icon icon) {
                super(action);
                this.setText(null);
                this.setIcon(icon);
                this.setToolTipText(action.getValue("BTN_TOOLTIP").toString());
                if (!UIUtils.isOracleLookAndFeel()) {
                    this.setOpaque(false);
                }
            }

            @Override
            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                dimension.width = 5;
                return dimension;
            }
        }
        jPanel2.add(new ThinButton(this.openA, Icons.getIcon((String)"ProfilerIcons.SnapshotOpen")));
        jPanel2.add(new ThinButton(this.exportA, Icons.getIcon((String)"GeneralIcons.Export")));
        jPanel2.add(new ThinButton(this.compareA, Icons.getIcon((String)"ProfilerIcons.SnapshotsCompare")));
        jPanel2.add(new ThinButton(this.renameA, Icons.getIcon((String)"GeneralIcons.Rename")));
        jPanel2.add(new ThinButton(this.deleteA, Icons.getIcon((String)"ProfilerIcons.RunGC")));
        this.add(jPanel2, "South");
        this.updateButtons(Collections.EMPTY_LIST);
    }

    private void updateButtons(List<Snapshot> list) {
        int n = list.size();
        this.openA.setEnabled(n > 0);
        this.exportA.setEnabled(n > 0);
        this.compareA.setEnabled(n == 2 && !list.get(0).isHeapDump() && !list.get(1).isHeapDump());
        this.renameA.setEnabled(n == 1);
        this.deleteA.setEnabled(n > 0);
    }

    private static boolean hasSnapshots(ProfilerSession profilerSession) {
        return true;
    }

    private static boolean isOpen(Snapshot snapshot) {
        File file = FileUtil.toFile((FileObject)snapshot.getFile());
        if (file == null) {
            return false;
        }
        if (snapshot.isHeapDump()) {
            Set set = WindowManager.getDefault().getRegistry().getOpened();
            for (TopComponent topComponent : set) {
                if (!file.equals(topComponent.getClientProperty((Object)"nb.recent.file.path"))) continue;
                return true;
            }
        } else {
            LoadedSnapshot loadedSnapshot = ResultsManager.getDefault().findLoadedSnapshot(file);
            if (loadedSnapshot != null) {
                return true;
            }
        }
        return false;
    }

    private static void openSnapshots(final Collection<Snapshot> collection) {
        SnapshotsWindowHelper.PROCESSOR.post(new Runnable(){

            @Override
            public void run() {
                for (Snapshot snapshot : collection) {
                    ResultsManager.getDefault().openSnapshot(snapshot.getFile());
                }
            }
        });
    }

    private static void exportSnapshots(Collection<Snapshot> collection) {
        FileObject[] fileObjectArray = new FileObject[collection.size()];
        int n = 0;
        for (Snapshot snapshot : collection) {
            fileObjectArray[n++] = snapshot.getFile();
        }
        ResultsManager.getDefault().exportSnapshots(fileObjectArray);
    }

    private static void compareSnapshots(final Snapshot snapshot, final Snapshot snapshot2) {
        SnapshotsWindowHelper.PROCESSOR.post(new Runnable(){

            @Override
            public void run() {
                FileObject fileObject;
                final FileObject fileObject2 = snapshot.getFile();
                if (CompareSnapshotsAction.areComparableSnapshots(fileObject2, fileObject = snapshot2.getFile())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ResultsManager.getDefault().compareSnapshots(fileObject2, fileObject);
                        }
                    });
                } else {
                    ProfilerDialogs.displayError((String)Bundle.SnapshotsWindowUI_msgCannotCompareSnapshots());
                }
            }
        });
    }

    private static void renameSnapshot(final Snapshot snapshot, final AbstractTableModel abstractTableModel) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                final FileObject fileObject = snapshot.getFile();
                String string = fileObject.getName();
                RenameSnapshotPanel renameSnapshotPanel = new RenameSnapshotPanel();
                renameSnapshotPanel.setSnapshotName(string);
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)renameSnapshotPanel, Bundle.SnapshotsWindowUI_capRenameSnapshot(), true, new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                dialog.setVisible(true);
                if (dialogDescriptor.getValue() != DialogDescriptor.OK_OPTION) {
                    return;
                }
                final String string2 = renameSnapshotPanel.getSnapshotName();
                if (!string.equals(string2)) {
                    if (string2.length() == 0) {
                        ProfilerDialogs.displayError((String)Bundle.SnapshotsWindowUI_msgNameEmpty());
                        SnapshotsWindowUI.renameSnapshot(snapshot, abstractTableModel);
                    } else {
                        SnapshotsWindowHelper.PROCESSOR.post(new Runnable(){

                            @Override
                            public void run() {
                                FileLock fileLock = null;
                                try {
                                    fileLock = fileObject.lock();
                                    LoadedSnapshot loadedSnapshot = ResultsManager.getDefault().findLoadedSnapshot(FileUtil.toFile((FileObject)fileObject));
                                    fileObject.rename(fileLock, string2, fileObject.getExt());
                                    if (loadedSnapshot != null) {
                                        loadedSnapshot.setFile(FileUtil.toFile((FileObject)fileObject));
                                    }
                                    snapshot.loadDetails();
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            abstractTableModel.fireTableDataChanged();
                                        }
                                    });
                                }
                                catch (IOException iOException) {
                                    ProfilerDialogs.displayError((String)Bundle.SnapshotsWindowUI_msgRenameFailed(snapshot.getDisplayName()));
                                    iOException.printStackTrace();
                                    SnapshotsWindowUI.renameSnapshot(snapshot, abstractTableModel);
                                }
                                finally {
                                    if (fileLock != null) {
                                        fileLock.releaseLock();
                                    }
                                }
                            }
                        });
                    }
                }
            }
        });
    }

    private void deleteSnapshots(final Collection<Snapshot> collection) {
        SnapshotsWindowHelper.PROCESSOR.post(new Runnable(){

            @Override
            public void run() {
                if (ProfilerDialogs.displayConfirmation((String)Bundle.SnapshotsWindowUI_msgDeleteSnapshots(), (String)Bundle.SnapshotsWindowUI_capDeleteSnapshots())) {
                    ResultsManager resultsManager = null;
                    for (Snapshot snapshot : collection) {
                        try {
                            if (!snapshot.isHeapDump()) {
                                LoadedSnapshot loadedSnapshot;
                                if (resultsManager == null) {
                                    resultsManager = ResultsManager.getDefault();
                                }
                                if ((loadedSnapshot = resultsManager.findLoadedSnapshot(FileUtil.toFile((FileObject)snapshot.getFile()))) != null) {
                                    resultsManager.closeSnapshot(loadedSnapshot);
                                }
                            }
                            DataObject.find((FileObject)snapshot.getFile()).delete();
                        }
                        catch (Throwable throwable) {
                            ProfilerDialogs.displayError((String)Bundle.SnapshotsWindowUI_msgDeleteFailed(snapshot.getDisplayName()));
                            throwable.printStackTrace();
                        }
                    }
                    SnapshotsWindowUI.this.refreshSnapshots();
                }
            }
        });
    }

    public void open() {
        Mode mode;
        WindowManager windowManager = WindowManager.getDefault();
        if (windowManager.findMode((TopComponent)this) == null && (mode = windowManager.findMode(Bundle.SnapshotsWindowUI_mode())) != null) {
            mode.dockInto((TopComponent)this);
        }
        super.open();
    }

    protected void componentOpened() {
        super.componentOpened();
        this.refreshSnapshots();
        final boolean[] blArray = new boolean[1];
        this.openProjectsListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                PropertyChangeEvent propertyChangeEvent;
                if (!blArray[0] && SnapshotsWindowUI.this.selector.getProject() == null && changeEvent.getSource() instanceof PropertyChangeEvent && "MainProject".equals((propertyChangeEvent = (PropertyChangeEvent)changeEvent.getSource()).getPropertyName()) && propertyChangeEvent.getOldValue() == null && propertyChangeEvent.getNewValue() instanceof Lookup.Provider) {
                    blArray[0] = true;
                    SnapshotsWindowUI.this.selector.setProject((Lookup.Provider)propertyChangeEvent.getNewValue());
                    return;
                }
                SnapshotsWindowUI.this.selector.resetModel();
                SnapshotsWindowUI.this.selector.repaint();
            }
        };
        ProjectUtilities.addOpenProjectsListener((ChangeListener)this.openProjectsListener);
    }

    protected void componentClosed() {
        ProjectUtilities.removeOpenProjectsListener((ChangeListener)this.openProjectsListener);
        super.componentClosed();
    }

    public int getPersistenceType() {
        return 0;
    }

    protected String preferredID() {
        return ID;
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    @Override
    protected Component defaultFocusOwner() {
        return this.snapshotsTable;
    }

    private static final class ButtonsLayout
    implements LayoutManager {
        private static final int HGAP = 2;
        private static final float MAX_WIDTH_FACTOR = 1.8f;

        private ButtonsLayout() {
        }

        @Override
        public void layoutContainer(Container container) {
            int n = container.getComponentCount();
            Insets insets = container.getInsets();
            Dimension dimension = container.getSize();
            dimension.width = Math.min(dimension.width, this.maximumLayoutSize((Container)container).width);
            int n2 = insets.left;
            int n3 = insets.top;
            int n4 = dimension.width - n2 - insets.right - 2 * (n - 1);
            int n5 = dimension.height - n3 - insets.bottom;
            int n6 = n4 % n;
            n4 /= n;
            for (int i = 0; i < n; ++i) {
                int n7 = i < n6 ? 1 : 0;
                container.getComponent(i).setBounds(n2, n3, n4 + n7, n5);
                n2 += n4 + n7 + 2;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            int n = 0;
            int n2 = 0;
            for (Component component : container.getComponents()) {
                Dimension dimension = component.getPreferredSize();
                n += dimension.width;
                n2 = Math.max(n2, dimension.height);
            }
            n += 2 * (container.getComponentCount() - 1);
            Insets insets = container.getInsets();
            return new Dimension(n += insets.left + insets.right, n2 += insets.top + insets.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            int n = 0;
            int n2 = 0;
            for (Component component : container.getComponents()) {
                Dimension dimension = component.getMinimumSize();
                n += dimension.width;
                n2 = Math.max(n2, dimension.height);
            }
            return new Dimension(n += 2 * (container.getComponentCount() - 1), n2);
        }

        private Dimension maximumLayoutSize(Container container) {
            int n = 0;
            int n2 = 0;
            for (Component component : container.getComponents()) {
                Dimension dimension = component.getPreferredSize();
                n = (int)((float)n + (float)dimension.height * 1.8f);
                n2 = Math.max(n2, dimension.height);
            }
            n += 2 * (container.getComponentCount() - 1);
            Insets insets = container.getInsets();
            return new Dimension(n += insets.left + insets.right, n2 += insets.top + insets.bottom);
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }
    }

    private static final class RenameSnapshotPanel
    extends JPanel {
        private JTextField textField;

        RenameSnapshotPanel() {
            this.initComponents();
        }

        String getSnapshotName() {
            return this.textField.getText().trim();
        }

        void setSnapshotName(String string) {
            this.textField.setText(string);
            this.textField.selectAll();
        }

        private void initComponents() {
            JLabel jLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)Bundle.SnapshotsWindowUI_lblNewFile());
            jLabel.setAlignmentX(0.0f);
            this.textField = new JTextField();
            jLabel.setLabelFor(this.textField);
            this.textField.setPreferredSize(new Dimension(350, this.textField.getPreferredSize().height));
            this.textField.requestFocus();
            this.textField.setAlignmentX(0.0f);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(15, 10, 5, 10);
            gridBagConstraints.anchor = 17;
            this.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 10, 15, 10);
            gridBagConstraints.anchor = 17;
            this.add((Component)this.textField, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)new JPanel(), gridBagConstraints);
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NotifyDescriptor.class, (String)"ACSD_InputPanel"));
            this.textField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NotifyDescriptor.class, (String)"ACSD_InputField"));
        }
    }

    private static abstract class Snapshot
    implements Comparable {
        private final FileObject fo;
        private String displayName;
        private boolean customName;
        private long timestamp;
        private int snapshotType;
        private boolean isHeapDump;

        Snapshot(FileObject fileObject) {
            this.fo = fileObject;
            this.loadDetails();
        }

        abstract boolean alternativeSorting();

        public String getDisplayName() {
            return this.displayName;
        }

        public int getSnapshotType() {
            return this.snapshotType;
        }

        public static String getIconName(int n) {
            switch (n) {
                case 1: {
                    return "ProfilerIcons.Cpu";
                }
                case 2: {
                    return "ProfilerIcons.Memory";
                }
                case 3: {
                    return "ProfilerIcons.SnapshotThreads";
                }
                case 4: {
                    return "ProfilerIcons.HeapDump";
                }
                case 5: {
                    return "ProfilerIcons.WindowSql";
                }
            }
            return null;
        }

        public FileObject getFile() {
            return this.fo;
        }

        public boolean isHeapDump() {
            return this.isHeapDump;
        }

        void loadDetails() {
            String string = this.fo.getName();
            if (this.fo.getExt().equalsIgnoreCase("hprof")) {
                this.snapshotType = 4;
                this.displayName = ResultsManager.getDefault().getHeapDumpDisplayName(string);
                this.isHeapDump = true;
            } else {
                int n = ResultsManager.getDefault().getSnapshotType(this.fo);
                this.snapshotType = n == 1 ? 1 : (n == 32 ? 5 : 2);
                this.displayName = ResultsManager.getDefault().getSnapshotDisplayName(string, n);
                this.isHeapDump = false;
            }
            this.customName = string.equals(this.displayName);
            if (!this.customName) {
                String string2 = string.substring(string.lastIndexOf("-"));
                try {
                    this.timestamp = Long.parseLong(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        public boolean equals(Object object) {
            return this.fo.equals(((Snapshot)object).fo);
        }

        public int hashCode() {
            return this.fo.hashCode();
        }

        public int compareTo(Object object) {
            Snapshot snapshot = (Snapshot)object;
            if (this.alternativeSorting()) {
                if (this.customName) {
                    if (!snapshot.customName) {
                        return -1;
                    }
                    return Collator.getInstance().compare(this.getDisplayName(), snapshot.getDisplayName());
                }
                if (snapshot.customName) {
                    return 1;
                }
                return Long.compare(this.timestamp, snapshot.timestamp);
            }
            return Collator.getInstance().compare(this.getDisplayName(), snapshot.getDisplayName());
        }
    }
}

