#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 9
#define STATE_COUNT 4480
#define SYMBOL_COUNT 156
#define ALIAS_COUNT 2
#define TOKEN_COUNT 97
#define EXTERNAL_TOKEN_COUNT 15
#define MAX_ALIAS_SEQUENCE_LENGTH 8

enum {
  sym_heredoc_start = 1,
  sym__simple_heredoc_body = 2,
  sym__heredoc_body_beginning = 3,
  sym__heredoc_body_middle = 4,
  sym__heredoc_body_end = 5,
  sym_file_descriptor = 6,
  sym__empty_value = 7,
  sym__concat = 8,
  sym_variable_name = 9,
  sym_regex = 10,
  anon_sym_for = 11,
  anon_sym_in = 12,
  anon_sym_LPAREN_LPAREN = 13,
  anon_sym_RPAREN_RPAREN = 14,
  anon_sym_SEMI = 15,
  anon_sym_while = 16,
  anon_sym_do = 17,
  anon_sym_done = 18,
  anon_sym_if = 19,
  anon_sym_then = 20,
  anon_sym_fi = 21,
  anon_sym_elif = 22,
  anon_sym_else = 23,
  anon_sym_case = 24,
  anon_sym_esac = 25,
  anon_sym_PIPE = 26,
  anon_sym_RPAREN = 27,
  anon_sym_SEMI_SEMI = 28,
  anon_sym_function = 29,
  anon_sym_LPAREN = 30,
  anon_sym_LBRACE = 31,
  anon_sym_RBRACE = 32,
  anon_sym_PIPE_AMP = 33,
  anon_sym_AMP_AMP = 34,
  anon_sym_PIPE_PIPE = 35,
  anon_sym_BANG = 36,
  anon_sym_LBRACK = 37,
  anon_sym_RBRACK = 38,
  anon_sym_LBRACK_LBRACK = 39,
  anon_sym_RBRACK_RBRACK = 40,
  anon_sym_declare = 41,
  anon_sym_typeset = 42,
  anon_sym_export = 43,
  anon_sym_readonly = 44,
  anon_sym_local = 45,
  anon_sym_unset = 46,
  anon_sym_unsetenv = 47,
  anon_sym_EQ_TILDE = 48,
  anon_sym_EQ_EQ = 49,
  anon_sym_EQ = 50,
  anon_sym_PLUS_EQ = 51,
  anon_sym_LT = 52,
  anon_sym_GT = 53,
  anon_sym_GT_GT = 54,
  anon_sym_AMP_GT = 55,
  anon_sym_AMP_GT_GT = 56,
  anon_sym_LT_AMP = 57,
  anon_sym_GT_AMP = 58,
  anon_sym_LT_LT = 59,
  anon_sym_LT_LT_DASH = 60,
  anon_sym_LT_LT_LT = 61,
  anon_sym_BANG_EQ = 62,
  anon_sym_PLUS = 63,
  anon_sym_DASH = 64,
  anon_sym_DASH_EQ = 65,
  anon_sym_LT_EQ = 66,
  anon_sym_GT_EQ = 67,
  anon_sym_PLUS_PLUS = 68,
  anon_sym_DASH_DASH = 69,
  anon_sym_DOLLAR = 70,
  sym__special_character = 71,
  anon_sym_DQUOTE = 72,
  sym__string_content = 73,
  sym_raw_string = 74,
  anon_sym_POUND = 75,
  anon_sym_DOLLAR_LBRACE = 76,
  anon_sym_SLASH = 77,
  anon_sym_COLON = 78,
  anon_sym_COLON_QMARK = 79,
  anon_sym_COLON_DASH = 80,
  anon_sym_PERCENT = 81,
  anon_sym_DOLLAR_LPAREN = 82,
  anon_sym_BQUOTE = 83,
  anon_sym_LT_LPAREN = 84,
  anon_sym_GT_LPAREN = 85,
  sym_comment = 86,
  aux_sym_SLASH_BSLASHw_PLUS_SLASH = 87,
  anon_sym_STAR = 88,
  anon_sym_AT = 89,
  anon_sym_QMARK = 90,
  anon_sym_0 = 91,
  anon_sym__ = 92,
  sym_word = 93,
  sym_test_operator = 94,
  anon_sym_LF = 95,
  anon_sym_AMP = 96,
  sym_program = 97,
  sym__statements = 98,
  sym__terminated_statement = 99,
  sym_redirected_statement = 100,
  sym_for_statement = 101,
  sym_c_style_for_statement = 102,
  sym_while_statement = 103,
  sym_do_group = 104,
  sym_if_statement = 105,
  sym_elif_clause = 106,
  sym_else_clause = 107,
  sym_case_statement = 108,
  sym_case_item = 109,
  sym_last_case_item = 110,
  sym_function_definition = 111,
  sym_compound_statement = 112,
  sym_subshell = 113,
  sym_pipeline = 114,
  sym_list = 115,
  sym_negated_command = 116,
  sym_test_command = 117,
  sym_declaration_command = 118,
  sym_unset_command = 119,
  sym_command = 120,
  sym_command_name = 121,
  sym_variable_assignment = 122,
  sym_subscript = 123,
  sym_file_redirect = 124,
  sym_heredoc_redirect = 125,
  sym_heredoc_body = 126,
  sym_herestring_redirect = 127,
  sym__expression = 128,
  sym_binary_expression = 129,
  sym_unary_expression = 130,
  sym_postfix_expression = 131,
  sym_parenthesized_expression = 132,
  sym_concatenation = 133,
  sym_string = 134,
  sym_array = 135,
  sym_simple_expansion = 136,
  sym_string_expansion = 137,
  sym_expansion = 138,
  sym_command_substitution = 139,
  sym_process_substitution = 140,
  aux_sym__statements_repeat1 = 141,
  aux_sym_redirected_statement_repeat1 = 142,
  aux_sym_for_statement_repeat1 = 143,
  aux_sym_if_statement_repeat1 = 144,
  aux_sym_case_statement_repeat1 = 145,
  aux_sym_case_item_repeat1 = 146,
  aux_sym_declaration_command_repeat1 = 147,
  aux_sym_unset_command_repeat1 = 148,
  aux_sym_command_repeat1 = 149,
  aux_sym_command_repeat2 = 150,
  aux_sym_heredoc_body_repeat1 = 151,
  aux_sym__literal_repeat1 = 152,
  aux_sym_concatenation_repeat1 = 153,
  aux_sym_string_repeat1 = 154,
  aux_sym_expansion_repeat1 = 155,
  alias_sym_special_variable_name = 156,
  alias_sym_word = 157,
};

static const char *ts_symbol_names[] = {
  [sym_heredoc_start] = "heredoc_start",
  [sym__simple_heredoc_body] = "_simple_heredoc_body",
  [sym__heredoc_body_beginning] = "_heredoc_body_beginning",
  [sym__heredoc_body_middle] = "_heredoc_body_middle",
  [sym__heredoc_body_end] = "_heredoc_body_end",
  [sym_file_descriptor] = "file_descriptor",
  [sym__empty_value] = "_empty_value",
  [sym__concat] = "_concat",
  [sym_variable_name] = "variable_name",
  [sym_regex] = "regex",
  [ts_builtin_sym_end] = "END",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_LPAREN_LPAREN] = "((",
  [anon_sym_RPAREN_RPAREN] = "))",
  [anon_sym_SEMI] = ";",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_done] = "done",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_fi] = "fi",
  [anon_sym_elif] = "elif",
  [anon_sym_else] = "else",
  [anon_sym_case] = "case",
  [anon_sym_esac] = "esac",
  [anon_sym_PIPE] = "|",
  [anon_sym_RPAREN] = ")",
  [anon_sym_SEMI_SEMI] = ";;",
  [anon_sym_function] = "function",
  [anon_sym_LPAREN] = "(",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_PIPE_AMP] = "|&",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_BANG] = "!",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LBRACK_LBRACK] = "[[",
  [anon_sym_RBRACK_RBRACK] = "]]",
  [anon_sym_declare] = "declare",
  [anon_sym_typeset] = "typeset",
  [anon_sym_export] = "export",
  [anon_sym_readonly] = "readonly",
  [anon_sym_local] = "local",
  [anon_sym_unset] = "unset",
  [anon_sym_unsetenv] = "unsetenv",
  [anon_sym_EQ_TILDE] = "=~",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ] = "=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_AMP_GT] = "&>",
  [anon_sym_AMP_GT_GT] = "&>>",
  [anon_sym_LT_AMP] = "<&",
  [anon_sym_GT_AMP] = ">&",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_LT_LT_DASH] = "<<-",
  [anon_sym_LT_LT_LT] = "<<<",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_DOLLAR] = "$",
  [sym__special_character] = "_special_character",
  [anon_sym_DQUOTE] = "\"",
  [sym__string_content] = "_string_content",
  [sym_raw_string] = "raw_string",
  [anon_sym_POUND] = "#",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_SLASH] = "/",
  [anon_sym_COLON] = ":",
  [anon_sym_COLON_QMARK] = ":?",
  [anon_sym_COLON_DASH] = ":-",
  [anon_sym_PERCENT] = "%",
  [anon_sym_DOLLAR_LPAREN] = "$(",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_LT_LPAREN] = "<(",
  [anon_sym_GT_LPAREN] = ">(",
  [sym_comment] = "comment",
  [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = "variable_name",
  [anon_sym_STAR] = "special_variable_name",
  [anon_sym_AT] = "special_variable_name",
  [anon_sym_QMARK] = "special_variable_name",
  [anon_sym_0] = "special_variable_name",
  [anon_sym__] = "special_variable_name",
  [sym_word] = "word",
  [sym_test_operator] = "test_operator",
  [anon_sym_LF] = "\n",
  [anon_sym_AMP] = "&",
  [sym_program] = "program",
  [sym__statements] = "_statements",
  [sym__terminated_statement] = "_terminated_statement",
  [sym_redirected_statement] = "redirected_statement",
  [sym_for_statement] = "for_statement",
  [sym_c_style_for_statement] = "c_style_for_statement",
  [sym_while_statement] = "while_statement",
  [sym_do_group] = "do_group",
  [sym_if_statement] = "if_statement",
  [sym_elif_clause] = "elif_clause",
  [sym_else_clause] = "else_clause",
  [sym_case_statement] = "case_statement",
  [sym_case_item] = "case_item",
  [sym_last_case_item] = "case_item",
  [sym_function_definition] = "function_definition",
  [sym_compound_statement] = "compound_statement",
  [sym_subshell] = "subshell",
  [sym_pipeline] = "pipeline",
  [sym_list] = "list",
  [sym_negated_command] = "negated_command",
  [sym_test_command] = "test_command",
  [sym_declaration_command] = "declaration_command",
  [sym_unset_command] = "unset_command",
  [sym_command] = "command",
  [sym_command_name] = "command_name",
  [sym_variable_assignment] = "variable_assignment",
  [sym_subscript] = "subscript",
  [sym_file_redirect] = "file_redirect",
  [sym_heredoc_redirect] = "heredoc_redirect",
  [sym_heredoc_body] = "heredoc_body",
  [sym_herestring_redirect] = "herestring_redirect",
  [sym__expression] = "_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_postfix_expression] = "postfix_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_concatenation] = "concatenation",
  [sym_string] = "string",
  [sym_array] = "array",
  [sym_simple_expansion] = "simple_expansion",
  [sym_string_expansion] = "string_expansion",
  [sym_expansion] = "expansion",
  [sym_command_substitution] = "command_substitution",
  [sym_process_substitution] = "process_substitution",
  [aux_sym__statements_repeat1] = "_statements_repeat1",
  [aux_sym_redirected_statement_repeat1] = "redirected_statement_repeat1",
  [aux_sym_for_statement_repeat1] = "for_statement_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_case_statement_repeat1] = "case_statement_repeat1",
  [aux_sym_case_item_repeat1] = "case_item_repeat1",
  [aux_sym_declaration_command_repeat1] = "declaration_command_repeat1",
  [aux_sym_unset_command_repeat1] = "unset_command_repeat1",
  [aux_sym_command_repeat1] = "command_repeat1",
  [aux_sym_command_repeat2] = "command_repeat2",
  [aux_sym_heredoc_body_repeat1] = "heredoc_body_repeat1",
  [aux_sym__literal_repeat1] = "_literal_repeat1",
  [aux_sym_concatenation_repeat1] = "concatenation_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_expansion_repeat1] = "expansion_repeat1",
  [alias_sym_special_variable_name] = "special_variable_name",
  [alias_sym_word] = "word",
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [sym_heredoc_start] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_heredoc_body] = {
    .visible = false,
    .named = true,
  },
  [sym__heredoc_body_beginning] = {
    .visible = false,
    .named = true,
  },
  [sym__heredoc_body_middle] = {
    .visible = false,
    .named = true,
  },
  [sym__heredoc_body_end] = {
    .visible = false,
    .named = true,
  },
  [sym_file_descriptor] = {
    .visible = true,
    .named = true,
  },
  [sym__empty_value] = {
    .visible = false,
    .named = true,
  },
  [sym__concat] = {
    .visible = false,
    .named = true,
  },
  [sym_variable_name] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_done] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fi] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_esac] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_declare] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typeset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_readonly] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_local] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsetenv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [sym__special_character] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym__string_content] = {
    .visible = false,
    .named = true,
  },
  [sym_raw_string] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_0] = {
    .visible = true,
    .named = true,
  },
  [anon_sym__] = {
    .visible = true,
    .named = true,
  },
  [sym_word] = {
    .visible = true,
    .named = true,
  },
  [sym_test_operator] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym__statements] = {
    .visible = false,
    .named = true,
  },
  [sym__terminated_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_redirected_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_c_style_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_group] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elif_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_case_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_case_item] = {
    .visible = true,
    .named = true,
  },
  [sym_last_case_item] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_subshell] = {
    .visible = true,
    .named = true,
  },
  [sym_pipeline] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_negated_command] = {
    .visible = true,
    .named = true,
  },
  [sym_test_command] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration_command] = {
    .visible = true,
    .named = true,
  },
  [sym_unset_command] = {
    .visible = true,
    .named = true,
  },
  [sym_command] = {
    .visible = true,
    .named = true,
  },
  [sym_command_name] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym_file_redirect] = {
    .visible = true,
    .named = true,
  },
  [sym_heredoc_redirect] = {
    .visible = true,
    .named = true,
  },
  [sym_heredoc_body] = {
    .visible = true,
    .named = true,
  },
  [sym_herestring_redirect] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_postfix_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenation] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_simple_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_string_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_command_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_process_substitution] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__statements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_redirected_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_item_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_declaration_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unset_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_command_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_heredoc_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expansion_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_special_variable_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_word] = {
    .visible = true,
    .named = true,
  },
};

static TSSymbol ts_alias_sequences[8][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [1] = {
    [0] = alias_sym_word,
  },
  [2] = {
    [1] = alias_sym_word,
  },
  [3] = {
    [1] = alias_sym_special_variable_name,
  },
  [4] = {
    [2] = alias_sym_word,
  },
  [5] = {
    [2] = alias_sym_special_variable_name,
  },
  [6] = {
    [3] = alias_sym_word,
  },
  [7] = {
    [4] = alias_sym_word,
  },
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  switch (state) {
    case 0:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '!')
        ADVANCE(3);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '%')
        ADVANCE(11);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(18);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == '*')
        ADVANCE(21);
      if (lookahead == '+')
        ADVANCE(22);
      if (lookahead == '-')
        ADVANCE(25);
      if (lookahead == '/')
        ADVANCE(29);
      if (lookahead == '0')
        ADVANCE(30);
      if (lookahead == ':')
        ADVANCE(31);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(36);
      if (lookahead == '=')
        ADVANCE(43);
      if (lookahead == '>')
        ADVANCE(46);
      if (lookahead == '?')
        ADVANCE(51);
      if (lookahead == '@')
        ADVANCE(52);
      if (lookahead == '[')
        ADVANCE(53);
      if (lookahead == '\\')
        ADVANCE(55);
      if (lookahead == ']')
        ADVANCE(56);
      if (lookahead == '_')
        ADVANCE(58);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'e')
        ADVANCE(60);
      if (lookahead == 'f')
        ADVANCE(69);
      if (lookahead == 'i')
        ADVANCE(71);
      if (lookahead == '{')
        ADVANCE(73);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(0);
      ADVANCE(5);
      END_STATE();
    case 1:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 2:
      ACCEPT_TOKEN(anon_sym_LF);
      END_STATE();
    case 3:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 4:
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(5);
      END_STATE();
    case 5:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 6:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 7:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 8:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '(')
        ADVANCE(9);
      if (lookahead == '{')
        ADVANCE(10);
      END_STATE();
    case 9:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LPAREN);
      END_STATE();
    case 10:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 11:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 12:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&')
        ADVANCE(13);
      if (lookahead == '>')
        ADVANCE(14);
      END_STATE();
    case 13:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 14:
      ACCEPT_TOKEN(anon_sym_AMP_GT);
      if (lookahead == '>')
        ADVANCE(15);
      END_STATE();
    case 15:
      ACCEPT_TOKEN(anon_sym_AMP_GT_GT);
      END_STATE();
    case 16:
      if (lookahead == '\'')
        ADVANCE(17);
      if (lookahead != 0)
        ADVANCE(16);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(sym_raw_string);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead == '(')
        ADVANCE(19);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(anon_sym_LPAREN_LPAREN);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+')
        ADVANCE(23);
      if (lookahead == '=')
        ADVANCE(24);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          (lookahead < ';' || lookahead > '>') &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-')
        ADVANCE(26);
      if (lookahead == '=')
        ADVANCE(27);
      if (lookahead == '\\')
        ADVANCE(4);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(28);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          (lookahead < ';' || lookahead > '>') &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '`' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(sym_test_operator);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(28);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_0);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '-')
        ADVANCE(32);
      if (lookahead == '?')
        ADVANCE(33);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '?' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_COLON_DASH);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_COLON_QMARK);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_SEMI);
      if (lookahead == ';')
        ADVANCE(35);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_SEMI_SEMI);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&')
        ADVANCE(37);
      if (lookahead == '(')
        ADVANCE(38);
      if (lookahead == '<')
        ADVANCE(39);
      if (lookahead == '=')
        ADVANCE(42);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_LT_AMP);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_LT_LPAREN);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '-')
        ADVANCE(40);
      if (lookahead == '<')
        ADVANCE(41);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_LT_LT_DASH);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_LT_LT_LT);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=')
        ADVANCE(44);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == '~')
        ADVANCE(45);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          (lookahead < ';' || lookahead > '>') &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '~'))
        ADVANCE(5);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_EQ_TILDE);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '&')
        ADVANCE(47);
      if (lookahead == '(')
        ADVANCE(48);
      if (lookahead == '=')
        ADVANCE(49);
      if (lookahead == '>')
        ADVANCE(50);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_GT_AMP);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_GT_LPAREN);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == '[')
        ADVANCE(54);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_LBRACK_LBRACK);
      END_STATE();
    case 55:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(0);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      if (lookahead == ']')
        ADVANCE(57);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_RBRACK_RBRACK);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym__);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 'l')
        ADVANCE(61);
      if (lookahead == 's')
        ADVANCE(66);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 'i')
        ADVANCE(62);
      if (lookahead == 's')
        ADVANCE(64);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 'f')
        ADVANCE(63);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_elif);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 'e')
        ADVANCE(65);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 'a')
        ADVANCE(67);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          lookahead != 'a' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 'c')
        ADVANCE(68);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_esac);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 'i')
        ADVANCE(70);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_fi);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 'n')
        ADVANCE(72);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '&')
        ADVANCE(75);
      if (lookahead == '|')
        ADVANCE(76);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_PIPE_AMP);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 78:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '!')
        ADVANCE(3);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(80);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(18);
      if (lookahead == '<')
        ADVANCE(81);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(53);
      if (lookahead == '\\')
        ADVANCE(83);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(73);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(78);
      if ((lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n')
        ADVANCE(79);
      END_STATE();
    case 80:
      if (lookahead == '>')
        ADVANCE(14);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&')
        ADVANCE(37);
      if (lookahead == '(')
        ADVANCE(38);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '&')
        ADVANCE(47);
      if (lookahead == '(')
        ADVANCE(48);
      if (lookahead == '>')
        ADVANCE(50);
      END_STATE();
    case 83:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(78);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym__special_character);
      END_STATE();
    case 85:
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == '+')
        ADVANCE(86);
      if (lookahead == ';')
        ADVANCE(88);
      if (lookahead == '=')
        ADVANCE(89);
      if (lookahead == '[')
        ADVANCE(90);
      if (lookahead == '\\')
        SKIP(91);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(85);
      END_STATE();
    case 86:
      if (lookahead == '=')
        ADVANCE(87);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 88:
      if (lookahead == ';')
        ADVANCE(35);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 91:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(85);
      END_STATE();
    case 92:
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '(')
        ADVANCE(93);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        SKIP(94);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(92);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 93:
      if (lookahead == '(')
        ADVANCE(19);
      END_STATE();
    case 94:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(92);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 96:
      if (lookahead == '!')
        ADVANCE(3);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(97);
      if (lookahead == '-')
        ADVANCE(98);
      if (lookahead == '<')
        ADVANCE(99);
      if (lookahead == '>')
        ADVANCE(100);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(101);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(96);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(4);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(28);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '`' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 99:
      if (lookahead == '(')
        ADVANCE(38);
      END_STATE();
    case 100:
      if (lookahead == '(')
        ADVANCE(48);
      END_STATE();
    case 101:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(96);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 102:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(80);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '<')
        ADVANCE(81);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(103);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(102);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 103:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(102);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 104:
      if (lookahead == '!')
        ADVANCE(3);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(80);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(18);
      if (lookahead == '<')
        ADVANCE(81);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(53);
      if (lookahead == '\\')
        ADVANCE(105);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(73);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(104);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 105:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(104);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 106:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(80);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(18);
      if (lookahead == '<')
        ADVANCE(81);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(53);
      if (lookahead == '\\')
        ADVANCE(107);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(106);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 107:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(106);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 108:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(110);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(108);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if ((lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&')
        ADVANCE(37);
      if (lookahead == '(')
        ADVANCE(38);
      if (lookahead == '<')
        ADVANCE(39);
      END_STATE();
    case 110:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(108);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == '\\')
        ADVANCE(4);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 112:
      if (lookahead == '!')
        ADVANCE(113);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(114);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '*')
        ADVANCE(115);
      if (lookahead == '-')
        ADVANCE(116);
      if (lookahead == '0')
        ADVANCE(117);
      if (lookahead == '?')
        ADVANCE(118);
      if (lookahead == '@')
        ADVANCE(119);
      if (lookahead == '\\')
        SKIP(120);
      if (lookahead == '_')
        ADVANCE(121);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(112);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_0);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 120:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(112);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym__);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 122:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '=')
        ADVANCE(123);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(124);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(122);
      if ((lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '=')
        ADVANCE(44);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == '~')
        ADVANCE(45);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          (lookahead < ';' || lookahead > '>') &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '~'))
        ADVANCE(5);
      END_STATE();
    case 124:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(122);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 125:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(126);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '\\')
        ADVANCE(130);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(131);
      if (lookahead != 0)
        ADVANCE(127);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\n')
        ADVANCE(127);
      if (lookahead == '\\')
        ADVANCE(129);
      if (lookahead != 0 &&
          lookahead != '\"' &&
          lookahead != '$' &&
          lookahead != '`')
        ADVANCE(126);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\\')
        ADVANCE(128);
      if (lookahead != 0 &&
          lookahead != '\"' &&
          lookahead != '$' &&
          lookahead != '`')
        ADVANCE(127);
      END_STATE();
    case 128:
      if (lookahead == '\n')
        ADVANCE(127);
      if (lookahead != 0)
        ADVANCE(127);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n')
        ADVANCE(127);
      if (lookahead != 0)
        ADVANCE(126);
      END_STATE();
    case 130:
      if (lookahead == '\n')
        ADVANCE(131);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(131);
      if (lookahead != 0)
        ADVANCE(127);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '#')
        ADVANCE(126);
      if (lookahead == '\\')
        ADVANCE(130);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(131);
      if (lookahead != 0 &&
          (lookahead < '\"' || lookahead > '$') &&
          lookahead != '`')
        ADVANCE(127);
      END_STATE();
    case 132:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(97);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '=')
        ADVANCE(123);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(133);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(132);
      if ((lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 133:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(132);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 134:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '\\')
        SKIP(135);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(134);
      END_STATE();
    case 135:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(134);
      END_STATE();
    case 136:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(137);
      if (lookahead == '>')
        ADVANCE(138);
      if (lookahead == '\\')
        SKIP(139);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(136);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&')
        ADVANCE(37);
      if (lookahead == '<')
        ADVANCE(39);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '&')
        ADVANCE(47);
      if (lookahead == '>')
        ADVANCE(50);
      END_STATE();
    case 139:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(136);
      END_STATE();
    case 140:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(141);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(140);
      if ((lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 141:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(140);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 142:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '=')
        ADVANCE(123);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(143);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(142);
      if ((lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 143:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(142);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 144:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(97);
      if (lookahead == '<')
        ADVANCE(99);
      if (lookahead == '>')
        ADVANCE(100);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(145);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(144);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 145:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(144);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 146:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '!')
        ADVANCE(3);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(147);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(97);
      if (lookahead == '-')
        ADVANCE(98);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(99);
      if (lookahead == '>')
        ADVANCE(100);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(148);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(146);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 148:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(146);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 149:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '&')
        ADVANCE(147);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        SKIP(150);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == 'i')
        ADVANCE(151);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(149);
      END_STATE();
    case 150:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(149);
      END_STATE();
    case 151:
      if (lookahead == 'n')
        ADVANCE(152);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 153:
      if (lookahead == '!')
        ADVANCE(154);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '&')
        ADVANCE(156);
      if (lookahead == ')')
        ADVANCE(157);
      if (lookahead == '+')
        ADVANCE(159);
      if (lookahead == '-')
        ADVANCE(161);
      if (lookahead == '<')
        ADVANCE(165);
      if (lookahead == '=')
        ADVANCE(166);
      if (lookahead == '>')
        ADVANCE(169);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        SKIP(170);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(171);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(153);
      END_STATE();
    case 154:
      if (lookahead == '=')
        ADVANCE(155);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 156:
      if (lookahead == '&')
        ADVANCE(13);
      END_STATE();
    case 157:
      if (lookahead == ')')
        ADVANCE(158);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_RPAREN_RPAREN);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+')
        ADVANCE(160);
      if (lookahead == '=')
        ADVANCE(87);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-')
        ADVANCE(162);
      if (lookahead == '=')
        ADVANCE(163);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(164);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_test_operator);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(164);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=')
        ADVANCE(42);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=')
        ADVANCE(167);
      if (lookahead == '~')
        ADVANCE(168);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_EQ_TILDE);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=')
        ADVANCE(49);
      END_STATE();
    case 170:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(153);
      END_STATE();
    case 171:
      if (lookahead == '|')
        ADVANCE(76);
      END_STATE();
    case 172:
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '(')
        ADVANCE(97);
      if (lookahead == '\\')
        SKIP(173);
      if (lookahead == 'd')
        ADVANCE(174);
      if (lookahead == '{')
        ADVANCE(73);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(172);
      END_STATE();
    case 173:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(172);
      END_STATE();
    case 174:
      if (lookahead == 'o')
        ADVANCE(175);
      END_STATE();
    case 175:
      if (lookahead == 'n')
        ADVANCE(176);
      END_STATE();
    case 176:
      if (lookahead == 'e')
        ADVANCE(177);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_done);
      END_STATE();
    case 178:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(179);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(178);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if ((lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 179:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(178);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 180:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(97);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '=')
        ADVANCE(123);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(181);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(180);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 181:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(180);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 182:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(137);
      if (lookahead == '>')
        ADVANCE(138);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        SKIP(183);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(182);
      END_STATE();
    case 183:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(182);
      END_STATE();
    case 184:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(185);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(184);
      if ((lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 185:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(184);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 186:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(137);
      if (lookahead == '>')
        ADVANCE(138);
      if (lookahead == '\\')
        SKIP(187);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'd')
        ADVANCE(174);
      if (lookahead == 'e')
        ADVANCE(188);
      if (lookahead == 'f')
        ADVANCE(197);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(186);
      END_STATE();
    case 187:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(186);
      END_STATE();
    case 188:
      if (lookahead == 'l')
        ADVANCE(189);
      if (lookahead == 's')
        ADVANCE(194);
      END_STATE();
    case 189:
      if (lookahead == 'i')
        ADVANCE(190);
      if (lookahead == 's')
        ADVANCE(192);
      END_STATE();
    case 190:
      if (lookahead == 'f')
        ADVANCE(191);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_elif);
      END_STATE();
    case 192:
      if (lookahead == 'e')
        ADVANCE(193);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 194:
      if (lookahead == 'a')
        ADVANCE(195);
      END_STATE();
    case 195:
      if (lookahead == 'c')
        ADVANCE(196);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_esac);
      END_STATE();
    case 197:
      if (lookahead == 'i')
        ADVANCE(198);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_fi);
      END_STATE();
    case 199:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(200);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(199);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 200:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(199);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 201:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '=')
        ADVANCE(123);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(202);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(201);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 202:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(201);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 203:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(97);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '=')
        ADVANCE(123);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(204);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(203);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 204:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(203);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 205:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(137);
      if (lookahead == '>')
        ADVANCE(138);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        SKIP(206);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(205);
      END_STATE();
    case 206:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(205);
      END_STATE();
    case 207:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(208);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(207);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 208:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(207);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 209:
      if (lookahead == '!')
        ADVANCE(154);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '&')
        ADVANCE(156);
      if (lookahead == '+')
        ADVANCE(159);
      if (lookahead == '-')
        ADVANCE(161);
      if (lookahead == '<')
        ADVANCE(165);
      if (lookahead == '=')
        ADVANCE(166);
      if (lookahead == '>')
        ADVANCE(169);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        SKIP(210);
      if (lookahead == ']')
        ADVANCE(211);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(171);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(209);
      END_STATE();
    case 210:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(209);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 212:
      if (lookahead == '!')
        ADVANCE(154);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '&')
        ADVANCE(156);
      if (lookahead == '+')
        ADVANCE(159);
      if (lookahead == '-')
        ADVANCE(161);
      if (lookahead == '<')
        ADVANCE(165);
      if (lookahead == '=')
        ADVANCE(166);
      if (lookahead == '>')
        ADVANCE(169);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        SKIP(213);
      if (lookahead == ']')
        ADVANCE(214);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(171);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(212);
      END_STATE();
    case 213:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(212);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(sym__special_character);
      if (lookahead == ']')
        ADVANCE(57);
      END_STATE();
    case 215:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(80);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == '<')
        ADVANCE(81);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(216);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(215);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 216:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(215);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 217:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(114);
      if (lookahead == '*')
        ADVANCE(115);
      if (lookahead == '-')
        ADVANCE(116);
      if (lookahead == '0')
        ADVANCE(218);
      if (lookahead == '?')
        ADVANCE(118);
      if (lookahead == '@')
        ADVANCE(119);
      if (lookahead == '\\')
        ADVANCE(220);
      if (lookahead == '_')
        ADVANCE(222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(221);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(219);
      if (lookahead != 0 &&
          (lookahead < '_' || lookahead > 'z'))
        ADVANCE(127);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_0);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(219);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(219);
      END_STATE();
    case 220:
      if (lookahead == '\n')
        ADVANCE(221);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(221);
      if (lookahead != 0)
        ADVANCE(127);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '*')
        ADVANCE(115);
      if (lookahead == '-')
        ADVANCE(116);
      if (lookahead == '0')
        ADVANCE(218);
      if (lookahead == '?')
        ADVANCE(118);
      if (lookahead == '@')
        ADVANCE(119);
      if (lookahead == '\\')
        ADVANCE(220);
      if (lookahead == '_')
        ADVANCE(222);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(221);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(219);
      if (lookahead != 0 &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '_' || lookahead > 'z'))
        ADVANCE(127);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym__);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(219);
      END_STATE();
    case 223:
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(114);
      if (lookahead == '*')
        ADVANCE(115);
      if (lookahead == '-')
        ADVANCE(116);
      if (lookahead == '0')
        ADVANCE(117);
      if (lookahead == '?')
        ADVANCE(118);
      if (lookahead == '@')
        ADVANCE(119);
      if (lookahead == '\\')
        SKIP(224);
      if (lookahead == '_')
        ADVANCE(121);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(223);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 224:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(223);
      END_STATE();
    case 225:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '%')
        ADVANCE(11);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '-')
        ADVANCE(226);
      if (lookahead == '/')
        ADVANCE(29);
      if (lookahead == ':')
        ADVANCE(31);
      if (lookahead == '<')
        ADVANCE(99);
      if (lookahead == '=')
        ADVANCE(227);
      if (lookahead == '>')
        ADVANCE(100);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(228);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(225);
      if (lookahead != 0 &&
          (lookahead < '\"' || lookahead > ')') &&
          (lookahead < ':' || lookahead > '>') &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 228:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(225);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 229:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(137);
      if (lookahead == '>')
        ADVANCE(138);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        SKIP(230);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(229);
      END_STATE();
    case 230:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(229);
      END_STATE();
    case 231:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '&')
        ADVANCE(147);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '\\')
        SKIP(232);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'd')
        ADVANCE(174);
      if (lookahead == 'e')
        ADVANCE(188);
      if (lookahead == 'f')
        ADVANCE(197);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(231);
      END_STATE();
    case 232:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(231);
      END_STATE();
    case 233:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '!')
        ADVANCE(3);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(80);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(18);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == ';')
        ADVANCE(88);
      if (lookahead == '<')
        ADVANCE(81);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(53);
      if (lookahead == '\\')
        ADVANCE(234);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(73);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(233);
      if ((lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 234:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(233);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 235:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '&')
        ADVANCE(147);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '\\')
        SKIP(236);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(235);
      END_STATE();
    case 236:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(235);
      END_STATE();
    case 237:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '<')
        ADVANCE(99);
      if (lookahead == '>')
        ADVANCE(100);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(238);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(237);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 238:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(237);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 239:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '<')
        ADVANCE(99);
      if (lookahead == '>')
        ADVANCE(100);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(240);
      if (lookahead == ']')
        ADVANCE(211);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(239);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 240:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(239);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 241:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '!')
        ADVANCE(154);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '&')
        ADVANCE(242);
      if (lookahead == '+')
        ADVANCE(159);
      if (lookahead == '-')
        ADVANCE(161);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(165);
      if (lookahead == '=')
        ADVANCE(166);
      if (lookahead == '>')
        ADVANCE(169);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        SKIP(243);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(171);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(241);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&')
        ADVANCE(13);
      END_STATE();
    case 243:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(241);
      END_STATE();
    case 244:
      if (lookahead == '!')
        ADVANCE(154);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '&')
        ADVANCE(156);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == '+')
        ADVANCE(159);
      if (lookahead == '-')
        ADVANCE(161);
      if (lookahead == '<')
        ADVANCE(165);
      if (lookahead == '=')
        ADVANCE(166);
      if (lookahead == '>')
        ADVANCE(169);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        SKIP(245);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(171);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(244);
      END_STATE();
    case 245:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(244);
      END_STATE();
    case 246:
      if (lookahead == '!')
        ADVANCE(154);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '&')
        ADVANCE(156);
      if (lookahead == ')')
        ADVANCE(157);
      if (lookahead == '+')
        ADVANCE(159);
      if (lookahead == '-')
        ADVANCE(161);
      if (lookahead == '<')
        ADVANCE(165);
      if (lookahead == '=')
        ADVANCE(166);
      if (lookahead == '>')
        ADVANCE(169);
      if (lookahead == '\\')
        SKIP(247);
      if (lookahead == ']')
        ADVANCE(248);
      if (lookahead == '|')
        ADVANCE(171);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(246);
      END_STATE();
    case 247:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(246);
      END_STATE();
    case 248:
      if (lookahead == ']')
        ADVANCE(57);
      END_STATE();
    case 249:
      if (lookahead == '!')
        ADVANCE(3);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(80);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(18);
      if (lookahead == '<')
        ADVANCE(81);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(53);
      if (lookahead == '\\')
        ADVANCE(250);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'd')
        ADVANCE(251);
      if (lookahead == '{')
        ADVANCE(73);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(249);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 250:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(249);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 'o')
        ADVANCE(252);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 'n')
        ADVANCE(253);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 'e')
        ADVANCE(254);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_done);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 255:
      if (lookahead == '!')
        ADVANCE(3);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(80);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(18);
      if (lookahead == '<')
        ADVANCE(81);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(53);
      if (lookahead == '\\')
        ADVANCE(256);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'e')
        ADVANCE(257);
      if (lookahead == 'f')
        ADVANCE(69);
      if (lookahead == '{')
        ADVANCE(73);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(255);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 256:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(255);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 'l')
        ADVANCE(61);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 258:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '&')
        ADVANCE(147);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '\\')
        SKIP(259);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(258);
      END_STATE();
    case 259:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(258);
      END_STATE();
    case 260:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '<')
        ADVANCE(99);
      if (lookahead == '>')
        ADVANCE(100);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(261);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(260);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 261:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(260);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 262:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '%')
        ADVANCE(11);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '-')
        ADVANCE(226);
      if (lookahead == ':')
        ADVANCE(31);
      if (lookahead == '<')
        ADVANCE(99);
      if (lookahead == '=')
        ADVANCE(227);
      if (lookahead == '>')
        ADVANCE(100);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(263);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(262);
      if (lookahead != 0 &&
          (lookahead < '\"' || lookahead > ')') &&
          (lookahead < ':' || lookahead > '>') &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 263:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(262);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 264:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(137);
      if (lookahead == '>')
        ADVANCE(138);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        SKIP(265);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(264);
      END_STATE();
    case 265:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(264);
      END_STATE();
    case 266:
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '+')
        ADVANCE(86);
      if (lookahead == '=')
        ADVANCE(89);
      if (lookahead == '\\')
        SKIP(267);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(266);
      END_STATE();
    case 267:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(266);
      END_STATE();
    case 268:
      if (lookahead == '!')
        ADVANCE(3);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(97);
      if (lookahead == ')')
        ADVANCE(157);
      if (lookahead == '-')
        ADVANCE(98);
      if (lookahead == '<')
        ADVANCE(99);
      if (lookahead == '>')
        ADVANCE(100);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(269);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(268);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 269:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(268);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 270:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(147);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(99);
      if (lookahead == '>')
        ADVANCE(100);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(271);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(270);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 271:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(270);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 272:
      if (lookahead == '!')
        ADVANCE(154);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '&')
        ADVANCE(156);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == '+')
        ADVANCE(159);
      if (lookahead == '-')
        ADVANCE(161);
      if (lookahead == '<')
        ADVANCE(165);
      if (lookahead == '=')
        ADVANCE(166);
      if (lookahead == '>')
        ADVANCE(169);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        SKIP(273);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(274);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(272);
      END_STATE();
    case 273:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(272);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|')
        ADVANCE(76);
      END_STATE();
    case 275:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(276);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'd')
        ADVANCE(277);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(275);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 276:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(275);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 'o')
        ADVANCE(278);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 'n')
        ADVANCE(279);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 'e')
        ADVANCE(280);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_done);
      if (lookahead == '\\')
        ADVANCE(4);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 281:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '=')
        ADVANCE(123);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(282);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'd')
        ADVANCE(251);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(281);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 282:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(281);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 283:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(97);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '=')
        ADVANCE(123);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(284);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'd')
        ADVANCE(251);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(283);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 284:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(283);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 285:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(137);
      if (lookahead == '>')
        ADVANCE(138);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        SKIP(286);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == 'd')
        ADVANCE(174);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(285);
      END_STATE();
    case 286:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(285);
      END_STATE();
    case 287:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(288);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'd')
        ADVANCE(251);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(287);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 288:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(287);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 289:
      if (lookahead == '!')
        ADVANCE(3);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(80);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(18);
      if (lookahead == '<')
        ADVANCE(81);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(53);
      if (lookahead == '\\')
        ADVANCE(290);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'f')
        ADVANCE(69);
      if (lookahead == '{')
        ADVANCE(73);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(289);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 290:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(289);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 291:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(292);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'e')
        ADVANCE(293);
      if (lookahead == 'f')
        ADVANCE(299);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(291);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 292:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(291);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 'l')
        ADVANCE(294);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 'i')
        ADVANCE(295);
      if (lookahead == 's')
        ADVANCE(297);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 'f')
        ADVANCE(296);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_elif);
      if (lookahead == '\\')
        ADVANCE(4);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 'e')
        ADVANCE(298);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == '\\')
        ADVANCE(4);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 'i')
        ADVANCE(300);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(anon_sym_fi);
      if (lookahead == '\\')
        ADVANCE(4);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 301:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '=')
        ADVANCE(123);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(302);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'e')
        ADVANCE(257);
      if (lookahead == 'f')
        ADVANCE(69);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(301);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 302:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(301);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 303:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(97);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '=')
        ADVANCE(123);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(304);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'e')
        ADVANCE(257);
      if (lookahead == 'f')
        ADVANCE(69);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(303);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 304:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(303);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 305:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(137);
      if (lookahead == '>')
        ADVANCE(138);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        SKIP(306);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == 'e')
        ADVANCE(307);
      if (lookahead == 'f')
        ADVANCE(197);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(305);
      END_STATE();
    case 306:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(305);
      END_STATE();
    case 307:
      if (lookahead == 'l')
        ADVANCE(189);
      END_STATE();
    case 308:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(309);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'e')
        ADVANCE(257);
      if (lookahead == 'f')
        ADVANCE(69);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(308);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 309:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(308);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 310:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '<')
        ADVANCE(99);
      if (lookahead == '>')
        ADVANCE(100);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(311);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'e')
        ADVANCE(312);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(310);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 311:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(310);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 's')
        ADVANCE(66);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 313:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == '*')
        ADVANCE(21);
      if (lookahead == '-')
        ADVANCE(226);
      if (lookahead == '0')
        ADVANCE(314);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '=')
        ADVANCE(123);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '?')
        ADVANCE(51);
      if (lookahead == '@')
        ADVANCE(52);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(315);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '_')
        ADVANCE(316);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(313);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if ((lookahead < '&' || lookahead > '*'))
        ADVANCE(5);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(anon_sym_0);
      if (lookahead == '\\')
        ADVANCE(4);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 315:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(313);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(anon_sym__);
      if (lookahead == '\\')
        ADVANCE(4);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 317:
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == ';')
        ADVANCE(318);
      if (lookahead == '\\')
        ADVANCE(319);
      if (lookahead == '{')
        ADVANCE(73);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(317);
      if (lookahead != 0 &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 319:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(317);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 320:
      if (lookahead == '!')
        ADVANCE(154);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(114);
      if (lookahead == '&')
        ADVANCE(156);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ')')
        ADVANCE(157);
      if (lookahead == '*')
        ADVANCE(115);
      if (lookahead == '+')
        ADVANCE(159);
      if (lookahead == '-')
        ADVANCE(161);
      if (lookahead == '0')
        ADVANCE(117);
      if (lookahead == '<')
        ADVANCE(165);
      if (lookahead == '=')
        ADVANCE(166);
      if (lookahead == '>')
        ADVANCE(169);
      if (lookahead == '?')
        ADVANCE(118);
      if (lookahead == '@')
        ADVANCE(119);
      if (lookahead == '\\')
        SKIP(321);
      if (lookahead == ']')
        ADVANCE(248);
      if (lookahead == '_')
        ADVANCE(121);
      if (lookahead == '|')
        ADVANCE(171);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(320);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 321:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(320);
      END_STATE();
    case 322:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '&')
        ADVANCE(147);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '\\')
        SKIP(323);
      if (lookahead == 'd')
        ADVANCE(174);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(322);
      END_STATE();
    case 323:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(322);
      END_STATE();
    case 324:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(325);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'f')
        ADVANCE(299);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(324);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 325:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(324);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 326:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '=')
        ADVANCE(123);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(327);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'f')
        ADVANCE(69);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(326);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 327:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(326);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 328:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(97);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '=')
        ADVANCE(123);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(329);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'f')
        ADVANCE(69);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(328);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 329:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(328);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 330:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(137);
      if (lookahead == '>')
        ADVANCE(138);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        SKIP(331);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == 'f')
        ADVANCE(197);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(330);
      END_STATE();
    case 331:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(330);
      END_STATE();
    case 332:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(333);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'f')
        ADVANCE(69);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(332);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 333:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(332);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 334:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '&')
        ADVANCE(147);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '\\')
        SKIP(335);
      if (lookahead == 'e')
        ADVANCE(307);
      if (lookahead == 'f')
        ADVANCE(197);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(334);
      END_STATE();
    case 335:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(334);
      END_STATE();
    case 336:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(114);
      if (lookahead == '&')
        ADVANCE(147);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '*')
        ADVANCE(115);
      if (lookahead == '-')
        ADVANCE(116);
      if (lookahead == '0')
        ADVANCE(117);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '?')
        ADVANCE(118);
      if (lookahead == '@')
        ADVANCE(119);
      if (lookahead == '\\')
        SKIP(337);
      if (lookahead == '_')
        ADVANCE(121);
      if (lookahead == 'i')
        ADVANCE(338);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(336);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 337:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(336);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'n')
        ADVANCE(339);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(anon_sym_in);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 340:
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        SKIP(341);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(342);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(340);
      END_STATE();
    case 341:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(340);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 343:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(137);
      if (lookahead == '>')
        ADVANCE(138);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        SKIP(344);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == 'e')
        ADVANCE(345);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(343);
      END_STATE();
    case 344:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(343);
      END_STATE();
    case 345:
      if (lookahead == 's')
        ADVANCE(194);
      END_STATE();
    case 346:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '*')
        ADVANCE(21);
      if (lookahead == '-')
        ADVANCE(226);
      if (lookahead == '0')
        ADVANCE(314);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '=')
        ADVANCE(123);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '?')
        ADVANCE(51);
      if (lookahead == '@')
        ADVANCE(52);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(347);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '_')
        ADVANCE(316);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(346);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > '*'))
        ADVANCE(5);
      END_STATE();
    case 347:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(346);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 348:
      if (lookahead == '!')
        ADVANCE(154);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(114);
      if (lookahead == '&')
        ADVANCE(156);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '*')
        ADVANCE(115);
      if (lookahead == '+')
        ADVANCE(159);
      if (lookahead == '-')
        ADVANCE(161);
      if (lookahead == '0')
        ADVANCE(117);
      if (lookahead == '<')
        ADVANCE(165);
      if (lookahead == '=')
        ADVANCE(166);
      if (lookahead == '>')
        ADVANCE(169);
      if (lookahead == '?')
        ADVANCE(118);
      if (lookahead == '@')
        ADVANCE(119);
      if (lookahead == '\\')
        SKIP(349);
      if (lookahead == ']')
        ADVANCE(211);
      if (lookahead == '_')
        ADVANCE(121);
      if (lookahead == '|')
        ADVANCE(171);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(348);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 349:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(348);
      END_STATE();
    case 350:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == '*')
        ADVANCE(21);
      if (lookahead == '-')
        ADVANCE(226);
      if (lookahead == '0')
        ADVANCE(314);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '?')
        ADVANCE(51);
      if (lookahead == '@')
        ADVANCE(52);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(351);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '_')
        ADVANCE(316);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(350);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if ((lookahead < '&' || lookahead > '*'))
        ADVANCE(5);
      END_STATE();
    case 351:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(350);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 352:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(80);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == '*')
        ADVANCE(21);
      if (lookahead == '-')
        ADVANCE(226);
      if (lookahead == '0')
        ADVANCE(314);
      if (lookahead == '<')
        ADVANCE(81);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '?')
        ADVANCE(51);
      if (lookahead == '@')
        ADVANCE(52);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(353);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '_')
        ADVANCE(316);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(352);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > '*') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 353:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(352);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 354:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(114);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '*')
        ADVANCE(115);
      if (lookahead == '-')
        ADVANCE(116);
      if (lookahead == '0')
        ADVANCE(117);
      if (lookahead == '?')
        ADVANCE(118);
      if (lookahead == '@')
        ADVANCE(119);
      if (lookahead == '\\')
        SKIP(355);
      if (lookahead == ']')
        ADVANCE(211);
      if (lookahead == '_')
        ADVANCE(121);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(354);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 355:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(354);
      END_STATE();
    case 356:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '!')
        ADVANCE(154);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(114);
      if (lookahead == '&')
        ADVANCE(242);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == '*')
        ADVANCE(115);
      if (lookahead == '+')
        ADVANCE(159);
      if (lookahead == '-')
        ADVANCE(161);
      if (lookahead == '0')
        ADVANCE(117);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(165);
      if (lookahead == '=')
        ADVANCE(166);
      if (lookahead == '>')
        ADVANCE(169);
      if (lookahead == '?')
        ADVANCE(118);
      if (lookahead == '@')
        ADVANCE(119);
      if (lookahead == '\\')
        SKIP(357);
      if (lookahead == '_')
        ADVANCE(121);
      if (lookahead == '|')
        ADVANCE(171);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(356);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 357:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(356);
      END_STATE();
    case 358:
      if (lookahead == '!')
        ADVANCE(3);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(80);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(18);
      if (lookahead == ';')
        ADVANCE(88);
      if (lookahead == '<')
        ADVANCE(81);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(53);
      if (lookahead == '\\')
        ADVANCE(359);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'e')
        ADVANCE(312);
      if (lookahead == '{')
        ADVANCE(73);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(358);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 359:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(358);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 360:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '*')
        ADVANCE(21);
      if (lookahead == '-')
        ADVANCE(226);
      if (lookahead == '0')
        ADVANCE(314);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '?')
        ADVANCE(51);
      if (lookahead == '@')
        ADVANCE(52);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(361);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '_')
        ADVANCE(316);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(360);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > '*'))
        ADVANCE(5);
      END_STATE();
    case 361:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(360);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 362:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '%')
        ADVANCE(11);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '*')
        ADVANCE(21);
      if (lookahead == '-')
        ADVANCE(226);
      if (lookahead == '0')
        ADVANCE(314);
      if (lookahead == ':')
        ADVANCE(31);
      if (lookahead == '<')
        ADVANCE(99);
      if (lookahead == '=')
        ADVANCE(227);
      if (lookahead == '>')
        ADVANCE(100);
      if (lookahead == '?')
        ADVANCE(51);
      if (lookahead == '@')
        ADVANCE(52);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(363);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '_')
        ADVANCE(316);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(362);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          (lookahead < '\"' || lookahead > '*') &&
          (lookahead < '0' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 363:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(362);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 364:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(114);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == '*')
        ADVANCE(115);
      if (lookahead == '-')
        ADVANCE(116);
      if (lookahead == '0')
        ADVANCE(117);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(137);
      if (lookahead == '>')
        ADVANCE(138);
      if (lookahead == '?')
        ADVANCE(118);
      if (lookahead == '@')
        ADVANCE(119);
      if (lookahead == '\\')
        SKIP(365);
      if (lookahead == '_')
        ADVANCE(121);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(364);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 365:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(364);
      END_STATE();
    case 366:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(147);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '*')
        ADVANCE(21);
      if (lookahead == '-')
        ADVANCE(226);
      if (lookahead == '0')
        ADVANCE(314);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(99);
      if (lookahead == '>')
        ADVANCE(100);
      if (lookahead == '?')
        ADVANCE(51);
      if (lookahead == '@')
        ADVANCE(52);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(367);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '_')
        ADVANCE(316);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(366);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > '*') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 367:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(366);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 368:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '*')
        ADVANCE(21);
      if (lookahead == '-')
        ADVANCE(226);
      if (lookahead == '0')
        ADVANCE(314);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '=')
        ADVANCE(123);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '?')
        ADVANCE(51);
      if (lookahead == '@')
        ADVANCE(52);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(369);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '_')
        ADVANCE(316);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'd')
        ADVANCE(277);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(368);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > '*'))
        ADVANCE(5);
      END_STATE();
    case 369:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(368);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 370:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(137);
      if (lookahead == '>')
        ADVANCE(138);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        SKIP(371);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == 'd')
        ADVANCE(174);
      if (lookahead == 'e')
        ADVANCE(188);
      if (lookahead == 'f')
        ADVANCE(197);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(370);
      END_STATE();
    case 371:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(370);
      END_STATE();
    case 372:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '*')
        ADVANCE(21);
      if (lookahead == '-')
        ADVANCE(226);
      if (lookahead == '0')
        ADVANCE(314);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '=')
        ADVANCE(123);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '?')
        ADVANCE(51);
      if (lookahead == '@')
        ADVANCE(52);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(373);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '_')
        ADVANCE(316);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'e')
        ADVANCE(293);
      if (lookahead == 'f')
        ADVANCE(299);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(372);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > '*'))
        ADVANCE(5);
      END_STATE();
    case 373:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(372);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 374:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(375);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'e')
        ADVANCE(376);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(374);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 375:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(374);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 's')
        ADVANCE(377);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 'a')
        ADVANCE(378);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == '\\')
        ADVANCE(4);
      if (lookahead == 'c')
        ADVANCE(379);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(anon_sym_esac);
      if (lookahead == '\\')
        ADVANCE(4);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(5);
      END_STATE();
    case 380:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '=')
        ADVANCE(123);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(381);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'e')
        ADVANCE(312);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(380);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 381:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(380);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 382:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '(')
        ADVANCE(97);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '=')
        ADVANCE(123);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(383);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'e')
        ADVANCE(312);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(382);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 383:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(382);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 384:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(385);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'e')
        ADVANCE(312);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(384);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(5);
      END_STATE();
    case 385:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(384);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 386:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(114);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '*')
        ADVANCE(115);
      if (lookahead == '-')
        ADVANCE(116);
      if (lookahead == '0')
        ADVANCE(117);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(137);
      if (lookahead == '>')
        ADVANCE(138);
      if (lookahead == '?')
        ADVANCE(118);
      if (lookahead == '@')
        ADVANCE(119);
      if (lookahead == '\\')
        SKIP(387);
      if (lookahead == '_')
        ADVANCE(121);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(386);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 387:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(386);
      END_STATE();
    case 388:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '*')
        ADVANCE(21);
      if (lookahead == '-')
        ADVANCE(226);
      if (lookahead == '0')
        ADVANCE(314);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '?')
        ADVANCE(51);
      if (lookahead == '@')
        ADVANCE(52);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(389);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '_')
        ADVANCE(316);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'd')
        ADVANCE(277);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(388);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > '*'))
        ADVANCE(5);
      END_STATE();
    case 389:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(388);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 390:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '*')
        ADVANCE(21);
      if (lookahead == '-')
        ADVANCE(226);
      if (lookahead == '0')
        ADVANCE(314);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '=')
        ADVANCE(123);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '?')
        ADVANCE(51);
      if (lookahead == '@')
        ADVANCE(52);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(391);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '_')
        ADVANCE(316);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'f')
        ADVANCE(299);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(390);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > '*'))
        ADVANCE(5);
      END_STATE();
    case 391:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(390);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 392:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '*')
        ADVANCE(21);
      if (lookahead == '-')
        ADVANCE(226);
      if (lookahead == '0')
        ADVANCE(314);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '?')
        ADVANCE(51);
      if (lookahead == '@')
        ADVANCE(52);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(393);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '_')
        ADVANCE(316);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'e')
        ADVANCE(293);
      if (lookahead == 'f')
        ADVANCE(299);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(392);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > '*'))
        ADVANCE(5);
      END_STATE();
    case 393:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(392);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 394:
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(114);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == ')')
        ADVANCE(20);
      if (lookahead == '*')
        ADVANCE(115);
      if (lookahead == '-')
        ADVANCE(116);
      if (lookahead == '0')
        ADVANCE(117);
      if (lookahead == '?')
        ADVANCE(118);
      if (lookahead == '@')
        ADVANCE(119);
      if (lookahead == '\\')
        SKIP(395);
      if (lookahead == '_')
        ADVANCE(121);
      if (lookahead == '|')
        ADVANCE(342);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(394);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 395:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(394);
      END_STATE();
    case 396:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '#')
        ADVANCE(79);
      if (lookahead == '&')
        ADVANCE(147);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '\\')
        SKIP(397);
      if (lookahead == 'e')
        ADVANCE(345);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(396);
      END_STATE();
    case 397:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(396);
      END_STATE();
    case 398:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(114);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '*')
        ADVANCE(115);
      if (lookahead == '-')
        ADVANCE(116);
      if (lookahead == '0')
        ADVANCE(117);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(137);
      if (lookahead == '>')
        ADVANCE(138);
      if (lookahead == '?')
        ADVANCE(118);
      if (lookahead == '@')
        ADVANCE(119);
      if (lookahead == '\\')
        SKIP(399);
      if (lookahead == '_')
        ADVANCE(121);
      if (lookahead == 'd')
        ADVANCE(400);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(398);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 399:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(398);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'o')
        ADVANCE(401);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'n')
        ADVANCE(402);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'e')
        ADVANCE(403);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(anon_sym_done);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 404:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '*')
        ADVANCE(21);
      if (lookahead == '-')
        ADVANCE(226);
      if (lookahead == '0')
        ADVANCE(314);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '?')
        ADVANCE(51);
      if (lookahead == '@')
        ADVANCE(52);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(405);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '_')
        ADVANCE(316);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'f')
        ADVANCE(299);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(404);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > '*'))
        ADVANCE(5);
      END_STATE();
    case 405:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(404);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 406:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(114);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '*')
        ADVANCE(115);
      if (lookahead == '-')
        ADVANCE(116);
      if (lookahead == '0')
        ADVANCE(117);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(137);
      if (lookahead == '>')
        ADVANCE(138);
      if (lookahead == '?')
        ADVANCE(118);
      if (lookahead == '@')
        ADVANCE(119);
      if (lookahead == '\\')
        SKIP(407);
      if (lookahead == '_')
        ADVANCE(121);
      if (lookahead == 'e')
        ADVANCE(408);
      if (lookahead == 'f')
        ADVANCE(414);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(406);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 407:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(406);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'l')
        ADVANCE(409);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'i')
        ADVANCE(410);
      if (lookahead == 's')
        ADVANCE(412);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'f')
        ADVANCE(411);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(anon_sym_elif);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'e')
        ADVANCE(413);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(anon_sym_else);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'i')
        ADVANCE(415);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(anon_sym_fi);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 416:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(114);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '*')
        ADVANCE(115);
      if (lookahead == '-')
        ADVANCE(116);
      if (lookahead == '0')
        ADVANCE(117);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(137);
      if (lookahead == '>')
        ADVANCE(138);
      if (lookahead == '?')
        ADVANCE(118);
      if (lookahead == '@')
        ADVANCE(119);
      if (lookahead == '\\')
        SKIP(417);
      if (lookahead == '_')
        ADVANCE(121);
      if (lookahead == 'f')
        ADVANCE(414);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(416);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 417:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(416);
      END_STATE();
    case 418:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '*')
        ADVANCE(21);
      if (lookahead == '-')
        ADVANCE(226);
      if (lookahead == '0')
        ADVANCE(314);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '=')
        ADVANCE(123);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '?')
        ADVANCE(51);
      if (lookahead == '@')
        ADVANCE(52);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(419);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '_')
        ADVANCE(316);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'e')
        ADVANCE(376);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(418);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > '*'))
        ADVANCE(5);
      END_STATE();
    case 419:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(418);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 420:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(8);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '*')
        ADVANCE(21);
      if (lookahead == '-')
        ADVANCE(226);
      if (lookahead == '0')
        ADVANCE(314);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(109);
      if (lookahead == '>')
        ADVANCE(82);
      if (lookahead == '?')
        ADVANCE(51);
      if (lookahead == '@')
        ADVANCE(52);
      if (lookahead == '[')
        ADVANCE(84);
      if (lookahead == '\\')
        ADVANCE(421);
      if (lookahead == ']')
        ADVANCE(84);
      if (lookahead == '_')
        ADVANCE(316);
      if (lookahead == '`')
        ADVANCE(59);
      if (lookahead == 'e')
        ADVANCE(376);
      if (lookahead == '{')
        ADVANCE(84);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '}')
        ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(420);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(111);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > '*'))
        ADVANCE(5);
      END_STATE();
    case 421:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(420);
      if (lookahead != 0)
        ADVANCE(5);
      END_STATE();
    case 422:
      if (lookahead == '\n')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(6);
      if (lookahead == '#')
        ADVANCE(7);
      if (lookahead == '$')
        ADVANCE(114);
      if (lookahead == '&')
        ADVANCE(12);
      if (lookahead == '\'')
        ADVANCE(16);
      if (lookahead == '*')
        ADVANCE(115);
      if (lookahead == '-')
        ADVANCE(116);
      if (lookahead == '0')
        ADVANCE(117);
      if (lookahead == ';')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(137);
      if (lookahead == '>')
        ADVANCE(138);
      if (lookahead == '?')
        ADVANCE(118);
      if (lookahead == '@')
        ADVANCE(119);
      if (lookahead == '\\')
        SKIP(423);
      if (lookahead == '_')
        ADVANCE(121);
      if (lookahead == 'e')
        ADVANCE(424);
      if (lookahead == '|')
        ADVANCE(74);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(422);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 423:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(422);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 's')
        ADVANCE(425);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'a')
        ADVANCE(426);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'c')
        ADVANCE(427);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(anon_sym_esac);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(95);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  switch (state) {
    case 0:
      if (lookahead == 'c')
        ADVANCE(1);
      if (lookahead == 'd')
        ADVANCE(5);
      if (lookahead == 'e')
        ADVANCE(13);
      if (lookahead == 'f')
        ADVANCE(19);
      if (lookahead == 'i')
        ADVANCE(29);
      if (lookahead == 'l')
        ADVANCE(31);
      if (lookahead == 'r')
        ADVANCE(36);
      if (lookahead == 't')
        ADVANCE(44);
      if (lookahead == 'u')
        ADVANCE(54);
      if (lookahead == 'w')
        ADVANCE(62);
      END_STATE();
    case 1:
      if (lookahead == 'a')
        ADVANCE(2);
      END_STATE();
    case 2:
      if (lookahead == 's')
        ADVANCE(3);
      END_STATE();
    case 3:
      if (lookahead == 'e')
        ADVANCE(4);
      END_STATE();
    case 4:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 5:
      if (lookahead == 'e')
        ADVANCE(6);
      if (lookahead == 'o')
        ADVANCE(12);
      END_STATE();
    case 6:
      if (lookahead == 'c')
        ADVANCE(7);
      END_STATE();
    case 7:
      if (lookahead == 'l')
        ADVANCE(8);
      END_STATE();
    case 8:
      if (lookahead == 'a')
        ADVANCE(9);
      END_STATE();
    case 9:
      if (lookahead == 'r')
        ADVANCE(10);
      END_STATE();
    case 10:
      if (lookahead == 'e')
        ADVANCE(11);
      END_STATE();
    case 11:
      ACCEPT_TOKEN(anon_sym_declare);
      END_STATE();
    case 12:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 13:
      if (lookahead == 'x')
        ADVANCE(14);
      END_STATE();
    case 14:
      if (lookahead == 'p')
        ADVANCE(15);
      END_STATE();
    case 15:
      if (lookahead == 'o')
        ADVANCE(16);
      END_STATE();
    case 16:
      if (lookahead == 'r')
        ADVANCE(17);
      END_STATE();
    case 17:
      if (lookahead == 't')
        ADVANCE(18);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 19:
      if (lookahead == 'o')
        ADVANCE(20);
      if (lookahead == 'u')
        ADVANCE(22);
      END_STATE();
    case 20:
      if (lookahead == 'r')
        ADVANCE(21);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 22:
      if (lookahead == 'n')
        ADVANCE(23);
      END_STATE();
    case 23:
      if (lookahead == 'c')
        ADVANCE(24);
      END_STATE();
    case 24:
      if (lookahead == 't')
        ADVANCE(25);
      END_STATE();
    case 25:
      if (lookahead == 'i')
        ADVANCE(26);
      END_STATE();
    case 26:
      if (lookahead == 'o')
        ADVANCE(27);
      END_STATE();
    case 27:
      if (lookahead == 'n')
        ADVANCE(28);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 29:
      if (lookahead == 'f')
        ADVANCE(30);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 31:
      if (lookahead == 'o')
        ADVANCE(32);
      END_STATE();
    case 32:
      if (lookahead == 'c')
        ADVANCE(33);
      END_STATE();
    case 33:
      if (lookahead == 'a')
        ADVANCE(34);
      END_STATE();
    case 34:
      if (lookahead == 'l')
        ADVANCE(35);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_local);
      END_STATE();
    case 36:
      if (lookahead == 'e')
        ADVANCE(37);
      END_STATE();
    case 37:
      if (lookahead == 'a')
        ADVANCE(38);
      END_STATE();
    case 38:
      if (lookahead == 'd')
        ADVANCE(39);
      END_STATE();
    case 39:
      if (lookahead == 'o')
        ADVANCE(40);
      END_STATE();
    case 40:
      if (lookahead == 'n')
        ADVANCE(41);
      END_STATE();
    case 41:
      if (lookahead == 'l')
        ADVANCE(42);
      END_STATE();
    case 42:
      if (lookahead == 'y')
        ADVANCE(43);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_readonly);
      END_STATE();
    case 44:
      if (lookahead == 'h')
        ADVANCE(45);
      if (lookahead == 'y')
        ADVANCE(48);
      END_STATE();
    case 45:
      if (lookahead == 'e')
        ADVANCE(46);
      END_STATE();
    case 46:
      if (lookahead == 'n')
        ADVANCE(47);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 48:
      if (lookahead == 'p')
        ADVANCE(49);
      END_STATE();
    case 49:
      if (lookahead == 'e')
        ADVANCE(50);
      END_STATE();
    case 50:
      if (lookahead == 's')
        ADVANCE(51);
      END_STATE();
    case 51:
      if (lookahead == 'e')
        ADVANCE(52);
      END_STATE();
    case 52:
      if (lookahead == 't')
        ADVANCE(53);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_typeset);
      END_STATE();
    case 54:
      if (lookahead == 'n')
        ADVANCE(55);
      END_STATE();
    case 55:
      if (lookahead == 's')
        ADVANCE(56);
      END_STATE();
    case 56:
      if (lookahead == 'e')
        ADVANCE(57);
      END_STATE();
    case 57:
      if (lookahead == 't')
        ADVANCE(58);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_unset);
      if (lookahead == 'e')
        ADVANCE(59);
      END_STATE();
    case 59:
      if (lookahead == 'n')
        ADVANCE(60);
      END_STATE();
    case 60:
      if (lookahead == 'v')
        ADVANCE(61);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_unsetenv);
      END_STATE();
    case 62:
      if (lookahead == 'h')
        ADVANCE(63);
      END_STATE();
    case 63:
      if (lookahead == 'i')
        ADVANCE(64);
      END_STATE();
    case 64:
      if (lookahead == 'l')
        ADVANCE(65);
      END_STATE();
    case 65:
      if (lookahead == 'e')
        ADVANCE(66);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 78, .external_lex_state = 2},
  [2] = {.lex_state = 78},
  [3] = {.lex_state = 85},
  [4] = {.lex_state = 92},
  [5] = {.lex_state = 96},
  [6] = {.lex_state = 78, .external_lex_state = 2},
  [7] = {.lex_state = 78, .external_lex_state = 2},
  [8] = {.lex_state = 102},
  [9] = {.lex_state = 102},
  [10] = {.lex_state = 78, .external_lex_state = 2},
  [11] = {.lex_state = 104, .external_lex_state = 3},
  [12] = {.lex_state = 106, .external_lex_state = 2},
  [13] = {.lex_state = 96},
  [14] = {.lex_state = 96},
  [15] = {.lex_state = 108, .external_lex_state = 4},
  [16] = {.lex_state = 108, .external_lex_state = 5},
  [17] = {.lex_state = 102},
  [18] = {.lex_state = 112},
  [19] = {.lex_state = 122, .external_lex_state = 6},
  [20] = {.lex_state = 125},
  [21] = {.lex_state = 122, .external_lex_state = 6},
  [22] = {.lex_state = 112, .external_lex_state = 7},
  [23] = {.lex_state = 78, .external_lex_state = 2},
  [24] = {.lex_state = 78, .external_lex_state = 2},
  [25] = {.lex_state = 78, .external_lex_state = 2},
  [26] = {.lex_state = 132, .external_lex_state = 6},
  [27] = {.lex_state = 134},
  [28] = {.lex_state = 134},
  [29] = {.lex_state = 136, .external_lex_state = 5},
  [30] = {.lex_state = 122, .external_lex_state = 5},
  [31] = {.lex_state = 140, .external_lex_state = 4},
  [32] = {.lex_state = 85},
  [33] = {.lex_state = 142, .external_lex_state = 5},
  [34] = {.lex_state = 78, .external_lex_state = 2},
  [35] = {.lex_state = 102, .external_lex_state = 2},
  [36] = {.lex_state = 122, .external_lex_state = 5},
  [37] = {.lex_state = 102},
  [38] = {.lex_state = 102},
  [39] = {.lex_state = 144, .external_lex_state = 8},
  [40] = {.lex_state = 146, .external_lex_state = 9},
  [41] = {.lex_state = 149, .external_lex_state = 9},
  [42] = {.lex_state = 96},
  [43] = {.lex_state = 96},
  [44] = {.lex_state = 112},
  [45] = {.lex_state = 153, .external_lex_state = 10},
  [46] = {.lex_state = 125},
  [47] = {.lex_state = 153, .external_lex_state = 10},
  [48] = {.lex_state = 112, .external_lex_state = 7},
  [49] = {.lex_state = 78, .external_lex_state = 2},
  [50] = {.lex_state = 78, .external_lex_state = 2},
  [51] = {.lex_state = 78, .external_lex_state = 2},
  [52] = {.lex_state = 153},
  [53] = {.lex_state = 153},
  [54] = {.lex_state = 85},
  [55] = {.lex_state = 92},
  [56] = {.lex_state = 96},
  [57] = {.lex_state = 78, .external_lex_state = 2},
  [58] = {.lex_state = 78, .external_lex_state = 2},
  [59] = {.lex_state = 102},
  [60] = {.lex_state = 102},
  [61] = {.lex_state = 78, .external_lex_state = 2},
  [62] = {.lex_state = 104, .external_lex_state = 3},
  [63] = {.lex_state = 106, .external_lex_state = 2},
  [64] = {.lex_state = 96},
  [65] = {.lex_state = 96},
  [66] = {.lex_state = 108, .external_lex_state = 11},
  [67] = {.lex_state = 108, .external_lex_state = 12},
  [68] = {.lex_state = 112},
  [69] = {.lex_state = 122, .external_lex_state = 13},
  [70] = {.lex_state = 125},
  [71] = {.lex_state = 122, .external_lex_state = 13},
  [72] = {.lex_state = 112, .external_lex_state = 7},
  [73] = {.lex_state = 78, .external_lex_state = 2},
  [74] = {.lex_state = 78, .external_lex_state = 2},
  [75] = {.lex_state = 78, .external_lex_state = 2},
  [76] = {.lex_state = 132, .external_lex_state = 13},
  [77] = {.lex_state = 102},
  [78] = {.lex_state = 136, .external_lex_state = 12},
  [79] = {.lex_state = 122, .external_lex_state = 12},
  [80] = {.lex_state = 140, .external_lex_state = 11},
  [81] = {.lex_state = 85},
  [82] = {.lex_state = 122, .external_lex_state = 12},
  [83] = {.lex_state = 102, .external_lex_state = 2},
  [84] = {.lex_state = 122, .external_lex_state = 12},
  [85] = {.lex_state = 102},
  [86] = {.lex_state = 112},
  [87] = {.lex_state = 149, .external_lex_state = 14},
  [88] = {.lex_state = 125},
  [89] = {.lex_state = 149, .external_lex_state = 14},
  [90] = {.lex_state = 112, .external_lex_state = 7},
  [91] = {.lex_state = 78, .external_lex_state = 2},
  [92] = {.lex_state = 78, .external_lex_state = 2},
  [93] = {.lex_state = 78, .external_lex_state = 2},
  [94] = {.lex_state = 149, .external_lex_state = 9},
  [95] = {.lex_state = 149, .external_lex_state = 9},
  [96] = {.lex_state = 172},
  [97] = {.lex_state = 85},
  [98] = {.lex_state = 106, .external_lex_state = 2},
  [99] = {.lex_state = 178, .external_lex_state = 4},
  [100] = {.lex_state = 178, .external_lex_state = 5},
  [101] = {.lex_state = 142, .external_lex_state = 6},
  [102] = {.lex_state = 142, .external_lex_state = 6},
  [103] = {.lex_state = 180, .external_lex_state = 6},
  [104] = {.lex_state = 85},
  [105] = {.lex_state = 182, .external_lex_state = 5},
  [106] = {.lex_state = 142, .external_lex_state = 5},
  [107] = {.lex_state = 184, .external_lex_state = 4},
  [108] = {.lex_state = 85},
  [109] = {.lex_state = 78, .external_lex_state = 2},
  [110] = {.lex_state = 102, .external_lex_state = 2},
  [111] = {.lex_state = 142, .external_lex_state = 5},
  [112] = {.lex_state = 85},
  [113] = {.lex_state = 92},
  [114] = {.lex_state = 96},
  [115] = {.lex_state = 78, .external_lex_state = 2},
  [116] = {.lex_state = 78, .external_lex_state = 2},
  [117] = {.lex_state = 102},
  [118] = {.lex_state = 102},
  [119] = {.lex_state = 78, .external_lex_state = 2},
  [120] = {.lex_state = 104, .external_lex_state = 3},
  [121] = {.lex_state = 186, .external_lex_state = 5},
  [122] = {.lex_state = 106, .external_lex_state = 2},
  [123] = {.lex_state = 96},
  [124] = {.lex_state = 96},
  [125] = {.lex_state = 199, .external_lex_state = 15},
  [126] = {.lex_state = 199, .external_lex_state = 16},
  [127] = {.lex_state = 112},
  [128] = {.lex_state = 201, .external_lex_state = 17},
  [129] = {.lex_state = 125},
  [130] = {.lex_state = 201, .external_lex_state = 17},
  [131] = {.lex_state = 112, .external_lex_state = 7},
  [132] = {.lex_state = 78, .external_lex_state = 2},
  [133] = {.lex_state = 78, .external_lex_state = 2},
  [134] = {.lex_state = 78, .external_lex_state = 2},
  [135] = {.lex_state = 203, .external_lex_state = 17},
  [136] = {.lex_state = 92, .external_lex_state = 18},
  [137] = {.lex_state = 205, .external_lex_state = 16},
  [138] = {.lex_state = 201, .external_lex_state = 16},
  [139] = {.lex_state = 207, .external_lex_state = 15},
  [140] = {.lex_state = 85},
  [141] = {.lex_state = 201, .external_lex_state = 16},
  [142] = {.lex_state = 78, .external_lex_state = 2},
  [143] = {.lex_state = 102, .external_lex_state = 2},
  [144] = {.lex_state = 201, .external_lex_state = 16},
  [145] = {.lex_state = 85},
  [146] = {.lex_state = 186, .external_lex_state = 5},
  [147] = {.lex_state = 85},
  [148] = {.lex_state = 96},
  [149] = {.lex_state = 96},
  [150] = {.lex_state = 112},
  [151] = {.lex_state = 209, .external_lex_state = 19},
  [152] = {.lex_state = 125},
  [153] = {.lex_state = 209, .external_lex_state = 19},
  [154] = {.lex_state = 112, .external_lex_state = 7},
  [155] = {.lex_state = 78, .external_lex_state = 2},
  [156] = {.lex_state = 78, .external_lex_state = 2},
  [157] = {.lex_state = 78, .external_lex_state = 2},
  [158] = {.lex_state = 209, .external_lex_state = 20},
  [159] = {.lex_state = 209, .external_lex_state = 20},
  [160] = {.lex_state = 96},
  [161] = {.lex_state = 212, .external_lex_state = 10},
  [162] = {.lex_state = 212, .external_lex_state = 10},
  [163] = {.lex_state = 212},
  [164] = {.lex_state = 212},
  [165] = {.lex_state = 85},
  [166] = {.lex_state = 112},
  [167] = {.lex_state = 108, .external_lex_state = 21},
  [168] = {.lex_state = 125},
  [169] = {.lex_state = 108, .external_lex_state = 21},
  [170] = {.lex_state = 112, .external_lex_state = 7},
  [171] = {.lex_state = 78, .external_lex_state = 2},
  [172] = {.lex_state = 78, .external_lex_state = 2},
  [173] = {.lex_state = 78, .external_lex_state = 2},
  [174] = {.lex_state = 85},
  [175] = {.lex_state = 108, .external_lex_state = 4},
  [176] = {.lex_state = 108, .external_lex_state = 4},
  [177] = {.lex_state = 112},
  [178] = {.lex_state = 108, .external_lex_state = 6},
  [179] = {.lex_state = 125},
  [180] = {.lex_state = 108, .external_lex_state = 6},
  [181] = {.lex_state = 112, .external_lex_state = 7},
  [182] = {.lex_state = 78, .external_lex_state = 2},
  [183] = {.lex_state = 78, .external_lex_state = 2},
  [184] = {.lex_state = 78, .external_lex_state = 2},
  [185] = {.lex_state = 108, .external_lex_state = 5},
  [186] = {.lex_state = 108, .external_lex_state = 5},
  [187] = {.lex_state = 112},
  [188] = {.lex_state = 102, .external_lex_state = 22},
  [189] = {.lex_state = 125},
  [190] = {.lex_state = 102, .external_lex_state = 22},
  [191] = {.lex_state = 112, .external_lex_state = 7},
  [192] = {.lex_state = 78, .external_lex_state = 2},
  [193] = {.lex_state = 78, .external_lex_state = 2},
  [194] = {.lex_state = 78, .external_lex_state = 2},
  [195] = {.lex_state = 215, .external_lex_state = 2},
  [196] = {.lex_state = 102, .external_lex_state = 2},
  [197] = {.lex_state = 142, .external_lex_state = 6},
  [198] = {.lex_state = 142, .external_lex_state = 6},
  [199] = {.lex_state = 142, .external_lex_state = 6},
  [200] = {.lex_state = 102},
  [201] = {.lex_state = 122, .external_lex_state = 6},
  [202] = {.lex_state = 217},
  [203] = {.lex_state = 142, .external_lex_state = 6},
  [204] = {.lex_state = 125, .external_lex_state = 10},
  [205] = {.lex_state = 112, .external_lex_state = 7},
  [206] = {.lex_state = 78, .external_lex_state = 2},
  [207] = {.lex_state = 78, .external_lex_state = 2},
  [208] = {.lex_state = 125},
  [209] = {.lex_state = 85},
  [210] = {.lex_state = 223, .external_lex_state = 7},
  [211] = {.lex_state = 225, .external_lex_state = 18},
  [212] = {.lex_state = 225, .external_lex_state = 18},
  [213] = {.lex_state = 78},
  [214] = {.lex_state = 102},
  [215] = {.lex_state = 85},
  [216] = {.lex_state = 215, .external_lex_state = 2},
  [217] = {.lex_state = 85},
  [218] = {.lex_state = 106, .external_lex_state = 2},
  [219] = {.lex_state = 108, .external_lex_state = 4},
  [220] = {.lex_state = 108, .external_lex_state = 5},
  [221] = {.lex_state = 122, .external_lex_state = 6},
  [222] = {.lex_state = 122, .external_lex_state = 6},
  [223] = {.lex_state = 132, .external_lex_state = 6},
  [224] = {.lex_state = 78},
  [225] = {.lex_state = 229, .external_lex_state = 5},
  [226] = {.lex_state = 122, .external_lex_state = 5},
  [227] = {.lex_state = 140, .external_lex_state = 4},
  [228] = {.lex_state = 85},
  [229] = {.lex_state = 78, .external_lex_state = 2},
  [230] = {.lex_state = 102, .external_lex_state = 2},
  [231] = {.lex_state = 122, .external_lex_state = 5},
  [232] = {.lex_state = 85},
  [233] = {.lex_state = 85},
  [234] = {.lex_state = 231, .external_lex_state = 9},
  [235] = {.lex_state = 96, .external_lex_state = 23},
  [236] = {.lex_state = 78},
  [237] = {.lex_state = 233, .external_lex_state = 2},
  [238] = {.lex_state = 78, .external_lex_state = 2},
  [239] = {.lex_state = 78, .external_lex_state = 2},
  [240] = {.lex_state = 102},
  [241] = {.lex_state = 78, .external_lex_state = 24},
  [242] = {.lex_state = 102},
  [243] = {.lex_state = 235, .external_lex_state = 9},
  [244] = {.lex_state = 136, .external_lex_state = 5},
  [245] = {.lex_state = 237, .external_lex_state = 25},
  [246] = {.lex_state = 122, .external_lex_state = 6},
  [247] = {.lex_state = 122, .external_lex_state = 5},
  [248] = {.lex_state = 122, .external_lex_state = 5},
  [249] = {.lex_state = 136, .external_lex_state = 5},
  [250] = {.lex_state = 140, .external_lex_state = 4},
  [251] = {.lex_state = 78, .external_lex_state = 2},
  [252] = {.lex_state = 122, .external_lex_state = 5},
  [253] = {.lex_state = 102, .external_lex_state = 2},
  [254] = {.lex_state = 142, .external_lex_state = 5},
  [255] = {.lex_state = 122, .external_lex_state = 5},
  [256] = {.lex_state = 102, .external_lex_state = 22},
  [257] = {.lex_state = 215, .external_lex_state = 2},
  [258] = {.lex_state = 102, .external_lex_state = 2},
  [259] = {.lex_state = 239, .external_lex_state = 19},
  [260] = {.lex_state = 239, .external_lex_state = 19},
  [261] = {.lex_state = 239, .external_lex_state = 19},
  [262] = {.lex_state = 239, .external_lex_state = 19},
  [263] = {.lex_state = 184, .external_lex_state = 4},
  [264] = {.lex_state = 215},
  [265] = {.lex_state = 112},
  [266] = {.lex_state = 140, .external_lex_state = 21},
  [267] = {.lex_state = 125},
  [268] = {.lex_state = 140, .external_lex_state = 21},
  [269] = {.lex_state = 112, .external_lex_state = 7},
  [270] = {.lex_state = 78, .external_lex_state = 2},
  [271] = {.lex_state = 78, .external_lex_state = 2},
  [272] = {.lex_state = 78, .external_lex_state = 2},
  [273] = {.lex_state = 140, .external_lex_state = 4},
  [274] = {.lex_state = 146, .external_lex_state = 9},
  [275] = {.lex_state = 96},
  [276] = {.lex_state = 96},
  [277] = {.lex_state = 112},
  [278] = {.lex_state = 241, .external_lex_state = 14},
  [279] = {.lex_state = 125},
  [280] = {.lex_state = 241, .external_lex_state = 14},
  [281] = {.lex_state = 112, .external_lex_state = 7},
  [282] = {.lex_state = 78, .external_lex_state = 2},
  [283] = {.lex_state = 78, .external_lex_state = 2},
  [284] = {.lex_state = 78, .external_lex_state = 2},
  [285] = {.lex_state = 241, .external_lex_state = 9},
  [286] = {.lex_state = 241, .external_lex_state = 9},
  [287] = {.lex_state = 102},
  [288] = {.lex_state = 102},
  [289] = {.lex_state = 96},
  [290] = {.lex_state = 96},
  [291] = {.lex_state = 112},
  [292] = {.lex_state = 244, .external_lex_state = 10},
  [293] = {.lex_state = 125},
  [294] = {.lex_state = 244, .external_lex_state = 10},
  [295] = {.lex_state = 112, .external_lex_state = 7},
  [296] = {.lex_state = 78, .external_lex_state = 2},
  [297] = {.lex_state = 78, .external_lex_state = 2},
  [298] = {.lex_state = 78, .external_lex_state = 2},
  [299] = {.lex_state = 244},
  [300] = {.lex_state = 244},
  [301] = {.lex_state = 153},
  [302] = {.lex_state = 246, .external_lex_state = 10},
  [303] = {.lex_state = 246, .external_lex_state = 10},
  [304] = {.lex_state = 246, .external_lex_state = 10},
  [305] = {.lex_state = 102},
  [306] = {.lex_state = 153, .external_lex_state = 10},
  [307] = {.lex_state = 217},
  [308] = {.lex_state = 246, .external_lex_state = 10},
  [309] = {.lex_state = 125},
  [310] = {.lex_state = 85},
  [311] = {.lex_state = 223, .external_lex_state = 7},
  [312] = {.lex_state = 225, .external_lex_state = 18},
  [313] = {.lex_state = 225, .external_lex_state = 18},
  [314] = {.lex_state = 85},
  [315] = {.lex_state = 215, .external_lex_state = 2},
  [316] = {.lex_state = 78},
  [317] = {.lex_state = 85},
  [318] = {.lex_state = 186, .external_lex_state = 5},
  [319] = {.lex_state = 96},
  [320] = {.lex_state = 96, .external_lex_state = 25},
  [321] = {.lex_state = 246},
  [322] = {.lex_state = 153},
  [323] = {.lex_state = 153},
  [324] = {.lex_state = 144, .external_lex_state = 8},
  [325] = {.lex_state = 146, .external_lex_state = 9},
  [326] = {.lex_state = 149, .external_lex_state = 9},
  [327] = {.lex_state = 153},
  [328] = {.lex_state = 102},
  [329] = {.lex_state = 102},
  [330] = {.lex_state = 149, .external_lex_state = 14},
  [331] = {.lex_state = 149, .external_lex_state = 9},
  [332] = {.lex_state = 149, .external_lex_state = 9},
  [333] = {.lex_state = 172},
  [334] = {.lex_state = 85},
  [335] = {.lex_state = 136, .external_lex_state = 12},
  [336] = {.lex_state = 92, .external_lex_state = 18},
  [337] = {.lex_state = 136, .external_lex_state = 12},
  [338] = {.lex_state = 209, .external_lex_state = 20},
  [339] = {.lex_state = 212},
  [340] = {.lex_state = 85},
  [341] = {.lex_state = 112},
  [342] = {.lex_state = 108, .external_lex_state = 26},
  [343] = {.lex_state = 125},
  [344] = {.lex_state = 108, .external_lex_state = 26},
  [345] = {.lex_state = 112, .external_lex_state = 7},
  [346] = {.lex_state = 78, .external_lex_state = 2},
  [347] = {.lex_state = 78, .external_lex_state = 2},
  [348] = {.lex_state = 78, .external_lex_state = 2},
  [349] = {.lex_state = 85},
  [350] = {.lex_state = 108, .external_lex_state = 11},
  [351] = {.lex_state = 108, .external_lex_state = 11},
  [352] = {.lex_state = 112},
  [353] = {.lex_state = 108, .external_lex_state = 13},
  [354] = {.lex_state = 125},
  [355] = {.lex_state = 108, .external_lex_state = 13},
  [356] = {.lex_state = 112, .external_lex_state = 7},
  [357] = {.lex_state = 78, .external_lex_state = 2},
  [358] = {.lex_state = 78, .external_lex_state = 2},
  [359] = {.lex_state = 78, .external_lex_state = 2},
  [360] = {.lex_state = 108, .external_lex_state = 12},
  [361] = {.lex_state = 108, .external_lex_state = 12},
  [362] = {.lex_state = 122, .external_lex_state = 13},
  [363] = {.lex_state = 122, .external_lex_state = 13},
  [364] = {.lex_state = 122, .external_lex_state = 13},
  [365] = {.lex_state = 102},
  [366] = {.lex_state = 122, .external_lex_state = 13},
  [367] = {.lex_state = 217},
  [368] = {.lex_state = 122, .external_lex_state = 13},
  [369] = {.lex_state = 125},
  [370] = {.lex_state = 85},
  [371] = {.lex_state = 223, .external_lex_state = 7},
  [372] = {.lex_state = 225, .external_lex_state = 18},
  [373] = {.lex_state = 225, .external_lex_state = 18},
  [374] = {.lex_state = 85},
  [375] = {.lex_state = 215, .external_lex_state = 2},
  [376] = {.lex_state = 78},
  [377] = {.lex_state = 85},
  [378] = {.lex_state = 85},
  [379] = {.lex_state = 249, .external_lex_state = 2},
  [380] = {.lex_state = 186, .external_lex_state = 5},
  [381] = {.lex_state = 78},
  [382] = {.lex_state = 102},
  [383] = {.lex_state = 78, .external_lex_state = 2},
  [384] = {.lex_state = 78, .external_lex_state = 2},
  [385] = {.lex_state = 102},
  [386] = {.lex_state = 78, .external_lex_state = 24},
  [387] = {.lex_state = 102},
  [388] = {.lex_state = 136, .external_lex_state = 12},
  [389] = {.lex_state = 237, .external_lex_state = 25},
  [390] = {.lex_state = 122, .external_lex_state = 13},
  [391] = {.lex_state = 122, .external_lex_state = 12},
  [392] = {.lex_state = 122, .external_lex_state = 12},
  [393] = {.lex_state = 122, .external_lex_state = 12},
  [394] = {.lex_state = 122, .external_lex_state = 12},
  [395] = {.lex_state = 122, .external_lex_state = 12},
  [396] = {.lex_state = 255, .external_lex_state = 2},
  [397] = {.lex_state = 149, .external_lex_state = 14},
  [398] = {.lex_state = 149, .external_lex_state = 14},
  [399] = {.lex_state = 149, .external_lex_state = 14},
  [400] = {.lex_state = 102},
  [401] = {.lex_state = 149, .external_lex_state = 14},
  [402] = {.lex_state = 217},
  [403] = {.lex_state = 149, .external_lex_state = 14},
  [404] = {.lex_state = 125},
  [405] = {.lex_state = 146, .external_lex_state = 9},
  [406] = {.lex_state = 149},
  [407] = {.lex_state = 85},
  [408] = {.lex_state = 223, .external_lex_state = 7},
  [409] = {.lex_state = 225, .external_lex_state = 18},
  [410] = {.lex_state = 225, .external_lex_state = 18},
  [411] = {.lex_state = 85},
  [412] = {.lex_state = 215, .external_lex_state = 2},
  [413] = {.lex_state = 78},
  [414] = {.lex_state = 85},
  [415] = {.lex_state = 146, .external_lex_state = 9},
  [416] = {.lex_state = 149},
  [417] = {.lex_state = 149, .external_lex_state = 9},
  [418] = {.lex_state = 149, .external_lex_state = 9},
  [419] = {.lex_state = 85},
  [420] = {.lex_state = 186, .external_lex_state = 5},
  [421] = {.lex_state = 144, .external_lex_state = 8},
  [422] = {.lex_state = 85},
  [423] = {.lex_state = 178, .external_lex_state = 21},
  [424] = {.lex_state = 178, .external_lex_state = 21},
  [425] = {.lex_state = 85},
  [426] = {.lex_state = 178, .external_lex_state = 4},
  [427] = {.lex_state = 178, .external_lex_state = 4},
  [428] = {.lex_state = 178, .external_lex_state = 6},
  [429] = {.lex_state = 178, .external_lex_state = 6},
  [430] = {.lex_state = 178, .external_lex_state = 5},
  [431] = {.lex_state = 178, .external_lex_state = 5},
  [432] = {.lex_state = 142, .external_lex_state = 6},
  [433] = {.lex_state = 186, .external_lex_state = 5},
  [434] = {.lex_state = 78},
  [435] = {.lex_state = 78, .external_lex_state = 2},
  [436] = {.lex_state = 78, .external_lex_state = 2},
  [437] = {.lex_state = 102},
  [438] = {.lex_state = 102},
  [439] = {.lex_state = 182, .external_lex_state = 5},
  [440] = {.lex_state = 237, .external_lex_state = 25},
  [441] = {.lex_state = 142, .external_lex_state = 6},
  [442] = {.lex_state = 142, .external_lex_state = 5},
  [443] = {.lex_state = 142, .external_lex_state = 5},
  [444] = {.lex_state = 182, .external_lex_state = 5},
  [445] = {.lex_state = 184, .external_lex_state = 4},
  [446] = {.lex_state = 142, .external_lex_state = 5},
  [447] = {.lex_state = 142, .external_lex_state = 5},
  [448] = {.lex_state = 144, .external_lex_state = 8},
  [449] = {.lex_state = 146, .external_lex_state = 9},
  [450] = {.lex_state = 149, .external_lex_state = 9},
  [451] = {.lex_state = 153},
  [452] = {.lex_state = 102},
  [453] = {.lex_state = 102},
  [454] = {.lex_state = 149, .external_lex_state = 14},
  [455] = {.lex_state = 149, .external_lex_state = 9},
  [456] = {.lex_state = 149, .external_lex_state = 9},
  [457] = {.lex_state = 172},
  [458] = {.lex_state = 85},
  [459] = {.lex_state = 205, .external_lex_state = 16},
  [460] = {.lex_state = 92, .external_lex_state = 18},
  [461] = {.lex_state = 205, .external_lex_state = 16},
  [462] = {.lex_state = 209, .external_lex_state = 20},
  [463] = {.lex_state = 212},
  [464] = {.lex_state = 85},
  [465] = {.lex_state = 112},
  [466] = {.lex_state = 199, .external_lex_state = 27},
  [467] = {.lex_state = 125},
  [468] = {.lex_state = 199, .external_lex_state = 27},
  [469] = {.lex_state = 112, .external_lex_state = 7},
  [470] = {.lex_state = 78, .external_lex_state = 2},
  [471] = {.lex_state = 78, .external_lex_state = 2},
  [472] = {.lex_state = 78, .external_lex_state = 2},
  [473] = {.lex_state = 85},
  [474] = {.lex_state = 199, .external_lex_state = 15},
  [475] = {.lex_state = 199, .external_lex_state = 15},
  [476] = {.lex_state = 112},
  [477] = {.lex_state = 199, .external_lex_state = 17},
  [478] = {.lex_state = 125},
  [479] = {.lex_state = 199, .external_lex_state = 17},
  [480] = {.lex_state = 112, .external_lex_state = 7},
  [481] = {.lex_state = 78, .external_lex_state = 2},
  [482] = {.lex_state = 78, .external_lex_state = 2},
  [483] = {.lex_state = 78, .external_lex_state = 2},
  [484] = {.lex_state = 199, .external_lex_state = 16},
  [485] = {.lex_state = 199, .external_lex_state = 16},
  [486] = {.lex_state = 201, .external_lex_state = 17},
  [487] = {.lex_state = 201, .external_lex_state = 17},
  [488] = {.lex_state = 201, .external_lex_state = 17},
  [489] = {.lex_state = 102},
  [490] = {.lex_state = 201, .external_lex_state = 17},
  [491] = {.lex_state = 217},
  [492] = {.lex_state = 201, .external_lex_state = 17},
  [493] = {.lex_state = 125},
  [494] = {.lex_state = 85},
  [495] = {.lex_state = 223, .external_lex_state = 7},
  [496] = {.lex_state = 225, .external_lex_state = 18},
  [497] = {.lex_state = 225, .external_lex_state = 18},
  [498] = {.lex_state = 85},
  [499] = {.lex_state = 215, .external_lex_state = 2},
  [500] = {.lex_state = 78},
  [501] = {.lex_state = 85},
  [502] = {.lex_state = 85},
  [503] = {.lex_state = 186, .external_lex_state = 5},
  [504] = {.lex_state = 258, .external_lex_state = 28},
  [505] = {.lex_state = 96, .external_lex_state = 23},
  [506] = {.lex_state = 78},
  [507] = {.lex_state = 104, .external_lex_state = 3},
  [508] = {.lex_state = 78, .external_lex_state = 2},
  [509] = {.lex_state = 78, .external_lex_state = 2},
  [510] = {.lex_state = 102},
  [511] = {.lex_state = 78, .external_lex_state = 24},
  [512] = {.lex_state = 102},
  [513] = {.lex_state = 258, .external_lex_state = 28},
  [514] = {.lex_state = 205, .external_lex_state = 16},
  [515] = {.lex_state = 237, .external_lex_state = 25},
  [516] = {.lex_state = 201, .external_lex_state = 17},
  [517] = {.lex_state = 201, .external_lex_state = 16},
  [518] = {.lex_state = 201, .external_lex_state = 16},
  [519] = {.lex_state = 205, .external_lex_state = 16},
  [520] = {.lex_state = 207, .external_lex_state = 15},
  [521] = {.lex_state = 201, .external_lex_state = 16},
  [522] = {.lex_state = 201, .external_lex_state = 16},
  [523] = {.lex_state = 201, .external_lex_state = 16},
  [524] = {.lex_state = 144, .external_lex_state = 8},
  [525] = {.lex_state = 244},
  [526] = {.lex_state = 209, .external_lex_state = 20},
  [527] = {.lex_state = 209, .external_lex_state = 19},
  [528] = {.lex_state = 209, .external_lex_state = 19},
  [529] = {.lex_state = 209, .external_lex_state = 19},
  [530] = {.lex_state = 102},
  [531] = {.lex_state = 209, .external_lex_state = 19},
  [532] = {.lex_state = 217},
  [533] = {.lex_state = 209, .external_lex_state = 19},
  [534] = {.lex_state = 125},
  [535] = {.lex_state = 85},
  [536] = {.lex_state = 223, .external_lex_state = 7},
  [537] = {.lex_state = 225, .external_lex_state = 18},
  [538] = {.lex_state = 225, .external_lex_state = 18},
  [539] = {.lex_state = 85},
  [540] = {.lex_state = 215, .external_lex_state = 2},
  [541] = {.lex_state = 78},
  [542] = {.lex_state = 85},
  [543] = {.lex_state = 96},
  [544] = {.lex_state = 96, .external_lex_state = 25},
  [545] = {.lex_state = 209, .external_lex_state = 20},
  [546] = {.lex_state = 209, .external_lex_state = 20},
  [547] = {.lex_state = 209, .external_lex_state = 20},
  [548] = {.lex_state = 212},
  [549] = {.lex_state = 212, .external_lex_state = 10},
  [550] = {.lex_state = 96},
  [551] = {.lex_state = 96, .external_lex_state = 25},
  [552] = {.lex_state = 212},
  [553] = {.lex_state = 212},
  [554] = {.lex_state = 144, .external_lex_state = 8},
  [555] = {.lex_state = 178, .external_lex_state = 21},
  [556] = {.lex_state = 178, .external_lex_state = 21},
  [557] = {.lex_state = 178, .external_lex_state = 21},
  [558] = {.lex_state = 102},
  [559] = {.lex_state = 108, .external_lex_state = 21},
  [560] = {.lex_state = 217},
  [561] = {.lex_state = 178, .external_lex_state = 21},
  [562] = {.lex_state = 125},
  [563] = {.lex_state = 85},
  [564] = {.lex_state = 223, .external_lex_state = 7},
  [565] = {.lex_state = 225, .external_lex_state = 18},
  [566] = {.lex_state = 225, .external_lex_state = 18},
  [567] = {.lex_state = 85},
  [568] = {.lex_state = 215, .external_lex_state = 2},
  [569] = {.lex_state = 78},
  [570] = {.lex_state = 85},
  [571] = {.lex_state = 108, .external_lex_state = 4},
  [572] = {.lex_state = 178, .external_lex_state = 4},
  [573] = {.lex_state = 108, .external_lex_state = 4},
  [574] = {.lex_state = 178, .external_lex_state = 6},
  [575] = {.lex_state = 178, .external_lex_state = 6},
  [576] = {.lex_state = 178, .external_lex_state = 6},
  [577] = {.lex_state = 102},
  [578] = {.lex_state = 108, .external_lex_state = 6},
  [579] = {.lex_state = 217},
  [580] = {.lex_state = 178, .external_lex_state = 6},
  [581] = {.lex_state = 125},
  [582] = {.lex_state = 85},
  [583] = {.lex_state = 223, .external_lex_state = 7},
  [584] = {.lex_state = 225, .external_lex_state = 18},
  [585] = {.lex_state = 225, .external_lex_state = 18},
  [586] = {.lex_state = 85},
  [587] = {.lex_state = 215, .external_lex_state = 2},
  [588] = {.lex_state = 78},
  [589] = {.lex_state = 85},
  [590] = {.lex_state = 108, .external_lex_state = 5},
  [591] = {.lex_state = 178, .external_lex_state = 5},
  [592] = {.lex_state = 108, .external_lex_state = 5},
  [593] = {.lex_state = 215, .external_lex_state = 22},
  [594] = {.lex_state = 215, .external_lex_state = 22},
  [595] = {.lex_state = 215, .external_lex_state = 22},
  [596] = {.lex_state = 102},
  [597] = {.lex_state = 102, .external_lex_state = 22},
  [598] = {.lex_state = 217},
  [599] = {.lex_state = 215, .external_lex_state = 22},
  [600] = {.lex_state = 125},
  [601] = {.lex_state = 85},
  [602] = {.lex_state = 223, .external_lex_state = 7},
  [603] = {.lex_state = 225, .external_lex_state = 18},
  [604] = {.lex_state = 225, .external_lex_state = 18},
  [605] = {.lex_state = 85},
  [606] = {.lex_state = 215, .external_lex_state = 2},
  [607] = {.lex_state = 78},
  [608] = {.lex_state = 85},
  [609] = {.lex_state = 215, .external_lex_state = 2},
  [610] = {.lex_state = 102, .external_lex_state = 2},
  [611] = {.lex_state = 142, .external_lex_state = 6},
  [612] = {.lex_state = 102},
  [613] = {.lex_state = 122, .external_lex_state = 6},
  [614] = {.lex_state = 125, .external_lex_state = 10},
  [615] = {.lex_state = 142, .external_lex_state = 6},
  [616] = {.lex_state = 125, .external_lex_state = 10},
  [617] = {.lex_state = 125, .external_lex_state = 10},
  [618] = {.lex_state = 125},
  [619] = {.lex_state = 85},
  [620] = {.lex_state = 223, .external_lex_state = 7},
  [621] = {.lex_state = 225, .external_lex_state = 18},
  [622] = {.lex_state = 225, .external_lex_state = 18},
  [623] = {.lex_state = 85},
  [624] = {.lex_state = 215, .external_lex_state = 2},
  [625] = {.lex_state = 78},
  [626] = {.lex_state = 217},
  [627] = {.lex_state = 125},
  [628] = {.lex_state = 102},
  [629] = {.lex_state = 260, .external_lex_state = 18},
  [630] = {.lex_state = 85},
  [631] = {.lex_state = 225, .external_lex_state = 18},
  [632] = {.lex_state = 225, .external_lex_state = 18},
  [633] = {.lex_state = 142, .external_lex_state = 6},
  [634] = {.lex_state = 112},
  [635] = {.lex_state = 262, .external_lex_state = 29},
  [636] = {.lex_state = 125},
  [637] = {.lex_state = 262, .external_lex_state = 29},
  [638] = {.lex_state = 112, .external_lex_state = 7},
  [639] = {.lex_state = 262, .external_lex_state = 30},
  [640] = {.lex_state = 78, .external_lex_state = 2},
  [641] = {.lex_state = 78, .external_lex_state = 2},
  [642] = {.lex_state = 78, .external_lex_state = 2},
  [643] = {.lex_state = 262, .external_lex_state = 18},
  [644] = {.lex_state = 262, .external_lex_state = 18},
  [645] = {.lex_state = 142, .external_lex_state = 6},
  [646] = {.lex_state = 262, .external_lex_state = 30},
  [647] = {.lex_state = 262, .external_lex_state = 18},
  [648] = {.lex_state = 102},
  [649] = {.lex_state = 215, .external_lex_state = 22},
  [650] = {.lex_state = 215, .external_lex_state = 22},
  [651] = {.lex_state = 215, .external_lex_state = 2},
  [652] = {.lex_state = 142, .external_lex_state = 6},
  [653] = {.lex_state = 144, .external_lex_state = 8},
  [654] = {.lex_state = 85},
  [655] = {.lex_state = 108, .external_lex_state = 21},
  [656] = {.lex_state = 108, .external_lex_state = 21},
  [657] = {.lex_state = 85},
  [658] = {.lex_state = 108, .external_lex_state = 4},
  [659] = {.lex_state = 108, .external_lex_state = 4},
  [660] = {.lex_state = 108, .external_lex_state = 6},
  [661] = {.lex_state = 108, .external_lex_state = 6},
  [662] = {.lex_state = 108, .external_lex_state = 5},
  [663] = {.lex_state = 108, .external_lex_state = 5},
  [664] = {.lex_state = 122, .external_lex_state = 6},
  [665] = {.lex_state = 78},
  [666] = {.lex_state = 78, .external_lex_state = 2},
  [667] = {.lex_state = 78, .external_lex_state = 2},
  [668] = {.lex_state = 78, .external_lex_state = 2},
  [669] = {.lex_state = 102},
  [670] = {.lex_state = 102},
  [671] = {.lex_state = 146, .external_lex_state = 9},
  [672] = {.lex_state = 229, .external_lex_state = 5},
  [673] = {.lex_state = 237, .external_lex_state = 25},
  [674] = {.lex_state = 122, .external_lex_state = 6},
  [675] = {.lex_state = 122, .external_lex_state = 5},
  [676] = {.lex_state = 122, .external_lex_state = 5},
  [677] = {.lex_state = 229, .external_lex_state = 5},
  [678] = {.lex_state = 140, .external_lex_state = 4},
  [679] = {.lex_state = 122, .external_lex_state = 5},
  [680] = {.lex_state = 122, .external_lex_state = 5},
  [681] = {.lex_state = 142, .external_lex_state = 6},
  [682] = {.lex_state = 78},
  [683] = {.lex_state = 231, .external_lex_state = 9},
  [684] = {.lex_state = 112},
  [685] = {.lex_state = 112, .external_lex_state = 7},
  [686] = {.lex_state = 78, .external_lex_state = 2},
  [687] = {.lex_state = 78, .external_lex_state = 2},
  [688] = {.lex_state = 96, .external_lex_state = 23},
  [689] = {.lex_state = 102},
  [690] = {.lex_state = 136, .external_lex_state = 5},
  [691] = {.lex_state = 140, .external_lex_state = 4},
  [692] = {.lex_state = 136, .external_lex_state = 5},
  [693] = {.lex_state = 140, .external_lex_state = 4},
  [694] = {.lex_state = 264, .external_lex_state = 6},
  [695] = {.lex_state = 136, .external_lex_state = 6},
  [696] = {.lex_state = 186, .external_lex_state = 5},
  [697] = {.lex_state = 264, .external_lex_state = 5},
  [698] = {.lex_state = 186, .external_lex_state = 5},
  [699] = {.lex_state = 136, .external_lex_state = 6},
  [700] = {.lex_state = 186, .external_lex_state = 5},
  [701] = {.lex_state = 264, .external_lex_state = 5},
  [702] = {.lex_state = 233, .external_lex_state = 2},
  [703] = {.lex_state = 136, .external_lex_state = 5},
  [704] = {.lex_state = 142, .external_lex_state = 5},
  [705] = {.lex_state = 122, .external_lex_state = 6},
  [706] = {.lex_state = 122, .external_lex_state = 5},
  [707] = {.lex_state = 122, .external_lex_state = 5},
  [708] = {.lex_state = 233, .external_lex_state = 2},
  [709] = {.lex_state = 235, .external_lex_state = 9},
  [710] = {.lex_state = 106, .external_lex_state = 2},
  [711] = {.lex_state = 108, .external_lex_state = 4},
  [712] = {.lex_state = 108, .external_lex_state = 5},
  [713] = {.lex_state = 136, .external_lex_state = 5},
  [714] = {.lex_state = 122, .external_lex_state = 5},
  [715] = {.lex_state = 140, .external_lex_state = 4},
  [716] = {.lex_state = 102, .external_lex_state = 2},
  [717] = {.lex_state = 122, .external_lex_state = 5},
  [718] = {.lex_state = 239, .external_lex_state = 19},
  [719] = {.lex_state = 239, .external_lex_state = 20},
  [720] = {.lex_state = 266, .external_lex_state = 10},
  [721] = {.lex_state = 209, .external_lex_state = 20},
  [722] = {.lex_state = 209, .external_lex_state = 20},
  [723] = {.lex_state = 266, .external_lex_state = 10},
  [724] = {.lex_state = 239, .external_lex_state = 19},
  [725] = {.lex_state = 239, .external_lex_state = 19},
  [726] = {.lex_state = 184, .external_lex_state = 4},
  [727] = {.lex_state = 112},
  [728] = {.lex_state = 215, .external_lex_state = 10},
  [729] = {.lex_state = 125},
  [730] = {.lex_state = 215, .external_lex_state = 10},
  [731] = {.lex_state = 112, .external_lex_state = 7},
  [732] = {.lex_state = 78, .external_lex_state = 2},
  [733] = {.lex_state = 78, .external_lex_state = 2},
  [734] = {.lex_state = 78, .external_lex_state = 2},
  [735] = {.lex_state = 215},
  [736] = {.lex_state = 215},
  [737] = {.lex_state = 184, .external_lex_state = 21},
  [738] = {.lex_state = 184, .external_lex_state = 21},
  [739] = {.lex_state = 184, .external_lex_state = 21},
  [740] = {.lex_state = 102},
  [741] = {.lex_state = 140, .external_lex_state = 21},
  [742] = {.lex_state = 217},
  [743] = {.lex_state = 184, .external_lex_state = 21},
  [744] = {.lex_state = 125},
  [745] = {.lex_state = 85},
  [746] = {.lex_state = 223, .external_lex_state = 7},
  [747] = {.lex_state = 225, .external_lex_state = 18},
  [748] = {.lex_state = 225, .external_lex_state = 18},
  [749] = {.lex_state = 85},
  [750] = {.lex_state = 215, .external_lex_state = 2},
  [751] = {.lex_state = 78},
  [752] = {.lex_state = 85},
  [753] = {.lex_state = 184, .external_lex_state = 4},
  [754] = {.lex_state = 140, .external_lex_state = 4},
  [755] = {.lex_state = 268},
  [756] = {.lex_state = 241, .external_lex_state = 9},
  [757] = {.lex_state = 244},
  [758] = {.lex_state = 241, .external_lex_state = 9},
  [759] = {.lex_state = 241, .external_lex_state = 14},
  [760] = {.lex_state = 241, .external_lex_state = 14},
  [761] = {.lex_state = 241, .external_lex_state = 14},
  [762] = {.lex_state = 102},
  [763] = {.lex_state = 241, .external_lex_state = 14},
  [764] = {.lex_state = 217},
  [765] = {.lex_state = 241, .external_lex_state = 14},
  [766] = {.lex_state = 125},
  [767] = {.lex_state = 85},
  [768] = {.lex_state = 223, .external_lex_state = 7},
  [769] = {.lex_state = 225, .external_lex_state = 18},
  [770] = {.lex_state = 225, .external_lex_state = 18},
  [771] = {.lex_state = 85},
  [772] = {.lex_state = 215, .external_lex_state = 2},
  [773] = {.lex_state = 78},
  [774] = {.lex_state = 85},
  [775] = {.lex_state = 146, .external_lex_state = 9},
  [776] = {.lex_state = 96},
  [777] = {.lex_state = 96, .external_lex_state = 25},
  [778] = {.lex_state = 241, .external_lex_state = 9},
  [779] = {.lex_state = 241, .external_lex_state = 9},
  [780] = {.lex_state = 241, .external_lex_state = 9},
  [781] = {.lex_state = 112},
  [782] = {.lex_state = 270, .external_lex_state = 14},
  [783] = {.lex_state = 125},
  [784] = {.lex_state = 270, .external_lex_state = 14},
  [785] = {.lex_state = 112, .external_lex_state = 7},
  [786] = {.lex_state = 78, .external_lex_state = 2},
  [787] = {.lex_state = 78, .external_lex_state = 2},
  [788] = {.lex_state = 78, .external_lex_state = 2},
  [789] = {.lex_state = 270, .external_lex_state = 9},
  [790] = {.lex_state = 270, .external_lex_state = 9},
  [791] = {.lex_state = 186, .external_lex_state = 5},
  [792] = {.lex_state = 244},
  [793] = {.lex_state = 244},
  [794] = {.lex_state = 272, .external_lex_state = 10},
  [795] = {.lex_state = 272, .external_lex_state = 10},
  [796] = {.lex_state = 272, .external_lex_state = 10},
  [797] = {.lex_state = 102},
  [798] = {.lex_state = 244, .external_lex_state = 10},
  [799] = {.lex_state = 217},
  [800] = {.lex_state = 272, .external_lex_state = 10},
  [801] = {.lex_state = 125},
  [802] = {.lex_state = 85},
  [803] = {.lex_state = 223, .external_lex_state = 7},
  [804] = {.lex_state = 225, .external_lex_state = 18},
  [805] = {.lex_state = 225, .external_lex_state = 18},
  [806] = {.lex_state = 85},
  [807] = {.lex_state = 215, .external_lex_state = 2},
  [808] = {.lex_state = 78},
  [809] = {.lex_state = 85},
  [810] = {.lex_state = 246},
  [811] = {.lex_state = 96},
  [812] = {.lex_state = 96, .external_lex_state = 25},
  [813] = {.lex_state = 244},
  [814] = {.lex_state = 272},
  [815] = {.lex_state = 244},
  [816] = {.lex_state = 246, .external_lex_state = 10},
  [817] = {.lex_state = 102},
  [818] = {.lex_state = 153, .external_lex_state = 10},
  [819] = {.lex_state = 246, .external_lex_state = 10},
  [820] = {.lex_state = 217},
  [821] = {.lex_state = 260, .external_lex_state = 18},
  [822] = {.lex_state = 85},
  [823] = {.lex_state = 225, .external_lex_state = 18},
  [824] = {.lex_state = 225, .external_lex_state = 18},
  [825] = {.lex_state = 246, .external_lex_state = 10},
  [826] = {.lex_state = 262, .external_lex_state = 30},
  [827] = {.lex_state = 262, .external_lex_state = 18},
  [828] = {.lex_state = 246, .external_lex_state = 10},
  [829] = {.lex_state = 262, .external_lex_state = 30},
  [830] = {.lex_state = 262, .external_lex_state = 18},
  [831] = {.lex_state = 246, .external_lex_state = 10},
  [832] = {.lex_state = 246, .external_lex_state = 10},
  [833] = {.lex_state = 246},
  [834] = {.lex_state = 246},
  [835] = {.lex_state = 140, .external_lex_state = 11},
  [836] = {.lex_state = 215},
  [837] = {.lex_state = 112},
  [838] = {.lex_state = 140, .external_lex_state = 26},
  [839] = {.lex_state = 125},
  [840] = {.lex_state = 140, .external_lex_state = 26},
  [841] = {.lex_state = 112, .external_lex_state = 7},
  [842] = {.lex_state = 78, .external_lex_state = 2},
  [843] = {.lex_state = 78, .external_lex_state = 2},
  [844] = {.lex_state = 78, .external_lex_state = 2},
  [845] = {.lex_state = 140, .external_lex_state = 11},
  [846] = {.lex_state = 146, .external_lex_state = 9},
  [847] = {.lex_state = 241, .external_lex_state = 9},
  [848] = {.lex_state = 102},
  [849] = {.lex_state = 102},
  [850] = {.lex_state = 136, .external_lex_state = 12},
  [851] = {.lex_state = 249, .external_lex_state = 2},
  [852] = {.lex_state = 136, .external_lex_state = 12},
  [853] = {.lex_state = 255, .external_lex_state = 2},
  [854] = {.lex_state = 146, .external_lex_state = 9},
  [855] = {.lex_state = 149},
  [856] = {.lex_state = 146, .external_lex_state = 9},
  [857] = {.lex_state = 149},
  [858] = {.lex_state = 85},
  [859] = {.lex_state = 136, .external_lex_state = 12},
  [860] = {.lex_state = 136, .external_lex_state = 12},
  [861] = {.lex_state = 136, .external_lex_state = 12},
  [862] = {.lex_state = 144, .external_lex_state = 8},
  [863] = {.lex_state = 108, .external_lex_state = 26},
  [864] = {.lex_state = 108, .external_lex_state = 26},
  [865] = {.lex_state = 108, .external_lex_state = 26},
  [866] = {.lex_state = 102},
  [867] = {.lex_state = 108, .external_lex_state = 26},
  [868] = {.lex_state = 217},
  [869] = {.lex_state = 108, .external_lex_state = 26},
  [870] = {.lex_state = 125},
  [871] = {.lex_state = 85},
  [872] = {.lex_state = 223, .external_lex_state = 7},
  [873] = {.lex_state = 225, .external_lex_state = 18},
  [874] = {.lex_state = 225, .external_lex_state = 18},
  [875] = {.lex_state = 85},
  [876] = {.lex_state = 215, .external_lex_state = 2},
  [877] = {.lex_state = 78},
  [878] = {.lex_state = 85},
  [879] = {.lex_state = 108, .external_lex_state = 11},
  [880] = {.lex_state = 108, .external_lex_state = 11},
  [881] = {.lex_state = 108, .external_lex_state = 11},
  [882] = {.lex_state = 108, .external_lex_state = 13},
  [883] = {.lex_state = 108, .external_lex_state = 13},
  [884] = {.lex_state = 108, .external_lex_state = 13},
  [885] = {.lex_state = 102},
  [886] = {.lex_state = 108, .external_lex_state = 13},
  [887] = {.lex_state = 217},
  [888] = {.lex_state = 108, .external_lex_state = 13},
  [889] = {.lex_state = 125},
  [890] = {.lex_state = 85},
  [891] = {.lex_state = 223, .external_lex_state = 7},
  [892] = {.lex_state = 225, .external_lex_state = 18},
  [893] = {.lex_state = 225, .external_lex_state = 18},
  [894] = {.lex_state = 85},
  [895] = {.lex_state = 215, .external_lex_state = 2},
  [896] = {.lex_state = 78},
  [897] = {.lex_state = 85},
  [898] = {.lex_state = 108, .external_lex_state = 12},
  [899] = {.lex_state = 108, .external_lex_state = 12},
  [900] = {.lex_state = 108, .external_lex_state = 12},
  [901] = {.lex_state = 122, .external_lex_state = 13},
  [902] = {.lex_state = 102},
  [903] = {.lex_state = 122, .external_lex_state = 13},
  [904] = {.lex_state = 122, .external_lex_state = 13},
  [905] = {.lex_state = 217},
  [906] = {.lex_state = 260, .external_lex_state = 18},
  [907] = {.lex_state = 85},
  [908] = {.lex_state = 225, .external_lex_state = 18},
  [909] = {.lex_state = 225, .external_lex_state = 18},
  [910] = {.lex_state = 122, .external_lex_state = 13},
  [911] = {.lex_state = 262, .external_lex_state = 30},
  [912] = {.lex_state = 262, .external_lex_state = 18},
  [913] = {.lex_state = 122, .external_lex_state = 13},
  [914] = {.lex_state = 262, .external_lex_state = 30},
  [915] = {.lex_state = 262, .external_lex_state = 18},
  [916] = {.lex_state = 122, .external_lex_state = 13},
  [917] = {.lex_state = 122, .external_lex_state = 13},
  [918] = {.lex_state = 78},
  [919] = {.lex_state = 85},
  [920] = {.lex_state = 186, .external_lex_state = 5},
  [921] = {.lex_state = 106, .external_lex_state = 2},
  [922] = {.lex_state = 275, .external_lex_state = 4},
  [923] = {.lex_state = 275, .external_lex_state = 5},
  [924] = {.lex_state = 112},
  [925] = {.lex_state = 281, .external_lex_state = 6},
  [926] = {.lex_state = 125},
  [927] = {.lex_state = 281, .external_lex_state = 6},
  [928] = {.lex_state = 112, .external_lex_state = 7},
  [929] = {.lex_state = 78, .external_lex_state = 2},
  [930] = {.lex_state = 78, .external_lex_state = 2},
  [931] = {.lex_state = 78, .external_lex_state = 2},
  [932] = {.lex_state = 283, .external_lex_state = 6},
  [933] = {.lex_state = 172},
  [934] = {.lex_state = 285, .external_lex_state = 5},
  [935] = {.lex_state = 281, .external_lex_state = 5},
  [936] = {.lex_state = 287, .external_lex_state = 4},
  [937] = {.lex_state = 85},
  [938] = {.lex_state = 281, .external_lex_state = 5},
  [939] = {.lex_state = 78, .external_lex_state = 2},
  [940] = {.lex_state = 102, .external_lex_state = 2},
  [941] = {.lex_state = 281, .external_lex_state = 5},
  [942] = {.lex_state = 102},
  [943] = {.lex_state = 136, .external_lex_state = 12},
  [944] = {.lex_state = 140, .external_lex_state = 11},
  [945] = {.lex_state = 136, .external_lex_state = 12},
  [946] = {.lex_state = 140, .external_lex_state = 11},
  [947] = {.lex_state = 140, .external_lex_state = 13},
  [948] = {.lex_state = 136, .external_lex_state = 13},
  [949] = {.lex_state = 136, .external_lex_state = 12},
  [950] = {.lex_state = 140, .external_lex_state = 12},
  [951] = {.lex_state = 136, .external_lex_state = 12},
  [952] = {.lex_state = 136, .external_lex_state = 13},
  [953] = {.lex_state = 136, .external_lex_state = 12},
  [954] = {.lex_state = 140, .external_lex_state = 12},
  [955] = {.lex_state = 136, .external_lex_state = 12},
  [956] = {.lex_state = 122, .external_lex_state = 12},
  [957] = {.lex_state = 122, .external_lex_state = 13},
  [958] = {.lex_state = 122, .external_lex_state = 12},
  [959] = {.lex_state = 122, .external_lex_state = 12},
  [960] = {.lex_state = 122, .external_lex_state = 12},
  [961] = {.lex_state = 85},
  [962] = {.lex_state = 186, .external_lex_state = 5},
  [963] = {.lex_state = 78, .external_lex_state = 2},
  [964] = {.lex_state = 289, .external_lex_state = 2},
  [965] = {.lex_state = 106, .external_lex_state = 2},
  [966] = {.lex_state = 291, .external_lex_state = 4},
  [967] = {.lex_state = 291, .external_lex_state = 5},
  [968] = {.lex_state = 112},
  [969] = {.lex_state = 301, .external_lex_state = 6},
  [970] = {.lex_state = 125},
  [971] = {.lex_state = 301, .external_lex_state = 6},
  [972] = {.lex_state = 112, .external_lex_state = 7},
  [973] = {.lex_state = 78, .external_lex_state = 2},
  [974] = {.lex_state = 78, .external_lex_state = 2},
  [975] = {.lex_state = 78, .external_lex_state = 2},
  [976] = {.lex_state = 303, .external_lex_state = 6},
  [977] = {.lex_state = 305},
  [978] = {.lex_state = 305, .external_lex_state = 5},
  [979] = {.lex_state = 305},
  [980] = {.lex_state = 301, .external_lex_state = 5},
  [981] = {.lex_state = 308, .external_lex_state = 4},
  [982] = {.lex_state = 85},
  [983] = {.lex_state = 301, .external_lex_state = 5},
  [984] = {.lex_state = 78, .external_lex_state = 2},
  [985] = {.lex_state = 305},
  [986] = {.lex_state = 102, .external_lex_state = 2},
  [987] = {.lex_state = 301, .external_lex_state = 5},
  [988] = {.lex_state = 149, .external_lex_state = 14},
  [989] = {.lex_state = 102},
  [990] = {.lex_state = 149, .external_lex_state = 14},
  [991] = {.lex_state = 149, .external_lex_state = 14},
  [992] = {.lex_state = 217},
  [993] = {.lex_state = 310},
  [994] = {.lex_state = 146, .external_lex_state = 9},
  [995] = {.lex_state = 260, .external_lex_state = 18},
  [996] = {.lex_state = 85},
  [997] = {.lex_state = 225, .external_lex_state = 18},
  [998] = {.lex_state = 225, .external_lex_state = 18},
  [999] = {.lex_state = 149, .external_lex_state = 14},
  [1000] = {.lex_state = 262, .external_lex_state = 30},
  [1001] = {.lex_state = 262, .external_lex_state = 18},
  [1002] = {.lex_state = 149, .external_lex_state = 14},
  [1003] = {.lex_state = 262, .external_lex_state = 30},
  [1004] = {.lex_state = 262, .external_lex_state = 18},
  [1005] = {.lex_state = 149, .external_lex_state = 14},
  [1006] = {.lex_state = 149, .external_lex_state = 14},
  [1007] = {.lex_state = 310},
  [1008] = {.lex_state = 146, .external_lex_state = 9},
  [1009] = {.lex_state = 78},
  [1010] = {.lex_state = 184, .external_lex_state = 21},
  [1011] = {.lex_state = 184, .external_lex_state = 21},
  [1012] = {.lex_state = 184, .external_lex_state = 4},
  [1013] = {.lex_state = 144, .external_lex_state = 8},
  [1014] = {.lex_state = 178, .external_lex_state = 21},
  [1015] = {.lex_state = 178, .external_lex_state = 4},
  [1016] = {.lex_state = 178, .external_lex_state = 4},
  [1017] = {.lex_state = 178, .external_lex_state = 6},
  [1018] = {.lex_state = 178, .external_lex_state = 5},
  [1019] = {.lex_state = 178, .external_lex_state = 5},
  [1020] = {.lex_state = 142, .external_lex_state = 6},
  [1021] = {.lex_state = 102},
  [1022] = {.lex_state = 182, .external_lex_state = 5},
  [1023] = {.lex_state = 184, .external_lex_state = 4},
  [1024] = {.lex_state = 182, .external_lex_state = 5},
  [1025] = {.lex_state = 184, .external_lex_state = 4},
  [1026] = {.lex_state = 182, .external_lex_state = 6},
  [1027] = {.lex_state = 182, .external_lex_state = 6},
  [1028] = {.lex_state = 182, .external_lex_state = 5},
  [1029] = {.lex_state = 182, .external_lex_state = 6},
  [1030] = {.lex_state = 182, .external_lex_state = 5},
  [1031] = {.lex_state = 182, .external_lex_state = 5},
  [1032] = {.lex_state = 142, .external_lex_state = 6},
  [1033] = {.lex_state = 142, .external_lex_state = 5},
  [1034] = {.lex_state = 142, .external_lex_state = 5},
  [1035] = {.lex_state = 142, .external_lex_state = 5},
  [1036] = {.lex_state = 207, .external_lex_state = 15},
  [1037] = {.lex_state = 215},
  [1038] = {.lex_state = 112},
  [1039] = {.lex_state = 207, .external_lex_state = 27},
  [1040] = {.lex_state = 125},
  [1041] = {.lex_state = 207, .external_lex_state = 27},
  [1042] = {.lex_state = 112, .external_lex_state = 7},
  [1043] = {.lex_state = 78, .external_lex_state = 2},
  [1044] = {.lex_state = 78, .external_lex_state = 2},
  [1045] = {.lex_state = 78, .external_lex_state = 2},
  [1046] = {.lex_state = 207, .external_lex_state = 15},
  [1047] = {.lex_state = 146, .external_lex_state = 9},
  [1048] = {.lex_state = 241, .external_lex_state = 9},
  [1049] = {.lex_state = 102},
  [1050] = {.lex_state = 102},
  [1051] = {.lex_state = 205, .external_lex_state = 16},
  [1052] = {.lex_state = 249, .external_lex_state = 2},
  [1053] = {.lex_state = 205, .external_lex_state = 16},
  [1054] = {.lex_state = 255, .external_lex_state = 2},
  [1055] = {.lex_state = 146, .external_lex_state = 9},
  [1056] = {.lex_state = 149},
  [1057] = {.lex_state = 146, .external_lex_state = 9},
  [1058] = {.lex_state = 149},
  [1059] = {.lex_state = 85},
  [1060] = {.lex_state = 205, .external_lex_state = 16},
  [1061] = {.lex_state = 205, .external_lex_state = 16},
  [1062] = {.lex_state = 205, .external_lex_state = 16},
  [1063] = {.lex_state = 144, .external_lex_state = 8},
  [1064] = {.lex_state = 199, .external_lex_state = 27},
  [1065] = {.lex_state = 199, .external_lex_state = 27},
  [1066] = {.lex_state = 199, .external_lex_state = 27},
  [1067] = {.lex_state = 102},
  [1068] = {.lex_state = 199, .external_lex_state = 27},
  [1069] = {.lex_state = 217},
  [1070] = {.lex_state = 199, .external_lex_state = 27},
  [1071] = {.lex_state = 125},
  [1072] = {.lex_state = 85},
  [1073] = {.lex_state = 223, .external_lex_state = 7},
  [1074] = {.lex_state = 225, .external_lex_state = 18},
  [1075] = {.lex_state = 225, .external_lex_state = 18},
  [1076] = {.lex_state = 85},
  [1077] = {.lex_state = 215, .external_lex_state = 2},
  [1078] = {.lex_state = 78},
  [1079] = {.lex_state = 85},
  [1080] = {.lex_state = 199, .external_lex_state = 15},
  [1081] = {.lex_state = 199, .external_lex_state = 15},
  [1082] = {.lex_state = 199, .external_lex_state = 15},
  [1083] = {.lex_state = 199, .external_lex_state = 17},
  [1084] = {.lex_state = 199, .external_lex_state = 17},
  [1085] = {.lex_state = 199, .external_lex_state = 17},
  [1086] = {.lex_state = 102},
  [1087] = {.lex_state = 199, .external_lex_state = 17},
  [1088] = {.lex_state = 217},
  [1089] = {.lex_state = 199, .external_lex_state = 17},
  [1090] = {.lex_state = 125},
  [1091] = {.lex_state = 85},
  [1092] = {.lex_state = 223, .external_lex_state = 7},
  [1093] = {.lex_state = 225, .external_lex_state = 18},
  [1094] = {.lex_state = 225, .external_lex_state = 18},
  [1095] = {.lex_state = 85},
  [1096] = {.lex_state = 215, .external_lex_state = 2},
  [1097] = {.lex_state = 78},
  [1098] = {.lex_state = 85},
  [1099] = {.lex_state = 199, .external_lex_state = 16},
  [1100] = {.lex_state = 199, .external_lex_state = 16},
  [1101] = {.lex_state = 199, .external_lex_state = 16},
  [1102] = {.lex_state = 201, .external_lex_state = 17},
  [1103] = {.lex_state = 102},
  [1104] = {.lex_state = 201, .external_lex_state = 17},
  [1105] = {.lex_state = 201, .external_lex_state = 17},
  [1106] = {.lex_state = 217},
  [1107] = {.lex_state = 260, .external_lex_state = 18},
  [1108] = {.lex_state = 85},
  [1109] = {.lex_state = 225, .external_lex_state = 18},
  [1110] = {.lex_state = 225, .external_lex_state = 18},
  [1111] = {.lex_state = 201, .external_lex_state = 17},
  [1112] = {.lex_state = 262, .external_lex_state = 30},
  [1113] = {.lex_state = 262, .external_lex_state = 18},
  [1114] = {.lex_state = 201, .external_lex_state = 17},
  [1115] = {.lex_state = 262, .external_lex_state = 30},
  [1116] = {.lex_state = 262, .external_lex_state = 18},
  [1117] = {.lex_state = 201, .external_lex_state = 17},
  [1118] = {.lex_state = 201, .external_lex_state = 17},
  [1119] = {.lex_state = 78},
  [1120] = {.lex_state = 258, .external_lex_state = 28},
  [1121] = {.lex_state = 96, .external_lex_state = 23},
  [1122] = {.lex_state = 102},
  [1123] = {.lex_state = 205, .external_lex_state = 16},
  [1124] = {.lex_state = 207, .external_lex_state = 15},
  [1125] = {.lex_state = 205, .external_lex_state = 16},
  [1126] = {.lex_state = 207, .external_lex_state = 15},
  [1127] = {.lex_state = 205, .external_lex_state = 17},
  [1128] = {.lex_state = 205, .external_lex_state = 17},
  [1129] = {.lex_state = 205, .external_lex_state = 16},
  [1130] = {.lex_state = 205, .external_lex_state = 16},
  [1131] = {.lex_state = 205, .external_lex_state = 16},
  [1132] = {.lex_state = 205, .external_lex_state = 17},
  [1133] = {.lex_state = 205, .external_lex_state = 16},
  [1134] = {.lex_state = 205, .external_lex_state = 16},
  [1135] = {.lex_state = 104, .external_lex_state = 3},
  [1136] = {.lex_state = 205, .external_lex_state = 16},
  [1137] = {.lex_state = 201, .external_lex_state = 16},
  [1138] = {.lex_state = 201, .external_lex_state = 17},
  [1139] = {.lex_state = 201, .external_lex_state = 16},
  [1140] = {.lex_state = 201, .external_lex_state = 16},
  [1141] = {.lex_state = 104, .external_lex_state = 3},
  [1142] = {.lex_state = 258, .external_lex_state = 28},
  [1143] = {.lex_state = 201, .external_lex_state = 16},
  [1144] = {.lex_state = 102, .external_lex_state = 2},
  [1145] = {.lex_state = 215},
  [1146] = {.lex_state = 102, .external_lex_state = 22},
  [1147] = {.lex_state = 102, .external_lex_state = 2},
  [1148] = {.lex_state = 209, .external_lex_state = 20},
  [1149] = {.lex_state = 209, .external_lex_state = 19},
  [1150] = {.lex_state = 102},
  [1151] = {.lex_state = 209, .external_lex_state = 19},
  [1152] = {.lex_state = 209, .external_lex_state = 19},
  [1153] = {.lex_state = 217},
  [1154] = {.lex_state = 260, .external_lex_state = 18},
  [1155] = {.lex_state = 85},
  [1156] = {.lex_state = 225, .external_lex_state = 18},
  [1157] = {.lex_state = 225, .external_lex_state = 18},
  [1158] = {.lex_state = 209, .external_lex_state = 19},
  [1159] = {.lex_state = 262, .external_lex_state = 30},
  [1160] = {.lex_state = 262, .external_lex_state = 18},
  [1161] = {.lex_state = 209, .external_lex_state = 19},
  [1162] = {.lex_state = 262, .external_lex_state = 30},
  [1163] = {.lex_state = 262, .external_lex_state = 18},
  [1164] = {.lex_state = 209, .external_lex_state = 19},
  [1165] = {.lex_state = 209, .external_lex_state = 19},
  [1166] = {.lex_state = 209, .external_lex_state = 20},
  [1167] = {.lex_state = 209, .external_lex_state = 20},
  [1168] = {.lex_state = 212, .external_lex_state = 10},
  [1169] = {.lex_state = 178, .external_lex_state = 4},
  [1170] = {.lex_state = 215},
  [1171] = {.lex_state = 108, .external_lex_state = 21},
  [1172] = {.lex_state = 108, .external_lex_state = 4},
  [1173] = {.lex_state = 178, .external_lex_state = 21},
  [1174] = {.lex_state = 102},
  [1175] = {.lex_state = 108, .external_lex_state = 21},
  [1176] = {.lex_state = 178, .external_lex_state = 21},
  [1177] = {.lex_state = 217},
  [1178] = {.lex_state = 260, .external_lex_state = 18},
  [1179] = {.lex_state = 85},
  [1180] = {.lex_state = 225, .external_lex_state = 18},
  [1181] = {.lex_state = 225, .external_lex_state = 18},
  [1182] = {.lex_state = 178, .external_lex_state = 21},
  [1183] = {.lex_state = 262, .external_lex_state = 30},
  [1184] = {.lex_state = 262, .external_lex_state = 18},
  [1185] = {.lex_state = 178, .external_lex_state = 21},
  [1186] = {.lex_state = 262, .external_lex_state = 30},
  [1187] = {.lex_state = 262, .external_lex_state = 18},
  [1188] = {.lex_state = 178, .external_lex_state = 21},
  [1189] = {.lex_state = 178, .external_lex_state = 21},
  [1190] = {.lex_state = 178, .external_lex_state = 6},
  [1191] = {.lex_state = 102},
  [1192] = {.lex_state = 108, .external_lex_state = 6},
  [1193] = {.lex_state = 178, .external_lex_state = 6},
  [1194] = {.lex_state = 217},
  [1195] = {.lex_state = 260, .external_lex_state = 18},
  [1196] = {.lex_state = 85},
  [1197] = {.lex_state = 225, .external_lex_state = 18},
  [1198] = {.lex_state = 225, .external_lex_state = 18},
  [1199] = {.lex_state = 178, .external_lex_state = 6},
  [1200] = {.lex_state = 262, .external_lex_state = 30},
  [1201] = {.lex_state = 262, .external_lex_state = 18},
  [1202] = {.lex_state = 178, .external_lex_state = 6},
  [1203] = {.lex_state = 262, .external_lex_state = 30},
  [1204] = {.lex_state = 262, .external_lex_state = 18},
  [1205] = {.lex_state = 178, .external_lex_state = 6},
  [1206] = {.lex_state = 178, .external_lex_state = 6},
  [1207] = {.lex_state = 215, .external_lex_state = 22},
  [1208] = {.lex_state = 102},
  [1209] = {.lex_state = 102, .external_lex_state = 22},
  [1210] = {.lex_state = 215, .external_lex_state = 22},
  [1211] = {.lex_state = 217},
  [1212] = {.lex_state = 260, .external_lex_state = 18},
  [1213] = {.lex_state = 85},
  [1214] = {.lex_state = 225, .external_lex_state = 18},
  [1215] = {.lex_state = 225, .external_lex_state = 18},
  [1216] = {.lex_state = 215, .external_lex_state = 22},
  [1217] = {.lex_state = 262, .external_lex_state = 30},
  [1218] = {.lex_state = 262, .external_lex_state = 18},
  [1219] = {.lex_state = 215, .external_lex_state = 22},
  [1220] = {.lex_state = 262, .external_lex_state = 30},
  [1221] = {.lex_state = 262, .external_lex_state = 18},
  [1222] = {.lex_state = 215, .external_lex_state = 22},
  [1223] = {.lex_state = 215, .external_lex_state = 22},
  [1224] = {.lex_state = 313, .external_lex_state = 5},
  [1225] = {.lex_state = 125},
  [1226] = {.lex_state = 260, .external_lex_state = 18},
  [1227] = {.lex_state = 85},
  [1228] = {.lex_state = 225, .external_lex_state = 18},
  [1229] = {.lex_state = 225, .external_lex_state = 18},
  [1230] = {.lex_state = 125, .external_lex_state = 10},
  [1231] = {.lex_state = 262, .external_lex_state = 30},
  [1232] = {.lex_state = 262, .external_lex_state = 18},
  [1233] = {.lex_state = 125, .external_lex_state = 10},
  [1234] = {.lex_state = 262, .external_lex_state = 30},
  [1235] = {.lex_state = 262, .external_lex_state = 18},
  [1236] = {.lex_state = 125, .external_lex_state = 10},
  [1237] = {.lex_state = 142, .external_lex_state = 6},
  [1238] = {.lex_state = 217},
  [1239] = {.lex_state = 239, .external_lex_state = 19},
  [1240] = {.lex_state = 239, .external_lex_state = 19},
  [1241] = {.lex_state = 239, .external_lex_state = 19},
  [1242] = {.lex_state = 142, .external_lex_state = 6},
  [1243] = {.lex_state = 112},
  [1244] = {.lex_state = 92, .external_lex_state = 29},
  [1245] = {.lex_state = 125},
  [1246] = {.lex_state = 92, .external_lex_state = 29},
  [1247] = {.lex_state = 112, .external_lex_state = 7},
  [1248] = {.lex_state = 78, .external_lex_state = 2},
  [1249] = {.lex_state = 78, .external_lex_state = 2},
  [1250] = {.lex_state = 78, .external_lex_state = 2},
  [1251] = {.lex_state = 92, .external_lex_state = 18},
  [1252] = {.lex_state = 92, .external_lex_state = 18},
  [1253] = {.lex_state = 260, .external_lex_state = 18},
  [1254] = {.lex_state = 142, .external_lex_state = 6},
  [1255] = {.lex_state = 262, .external_lex_state = 30},
  [1256] = {.lex_state = 262, .external_lex_state = 18},
  [1257] = {.lex_state = 262, .external_lex_state = 30},
  [1258] = {.lex_state = 262, .external_lex_state = 18},
  [1259] = {.lex_state = 262, .external_lex_state = 29},
  [1260] = {.lex_state = 262, .external_lex_state = 29},
  [1261] = {.lex_state = 262, .external_lex_state = 29},
  [1262] = {.lex_state = 102},
  [1263] = {.lex_state = 262, .external_lex_state = 29},
  [1264] = {.lex_state = 217},
  [1265] = {.lex_state = 262, .external_lex_state = 29},
  [1266] = {.lex_state = 125},
  [1267] = {.lex_state = 85},
  [1268] = {.lex_state = 223, .external_lex_state = 7},
  [1269] = {.lex_state = 225, .external_lex_state = 18},
  [1270] = {.lex_state = 225, .external_lex_state = 18},
  [1271] = {.lex_state = 262, .external_lex_state = 18},
  [1272] = {.lex_state = 142, .external_lex_state = 6},
  [1273] = {.lex_state = 262, .external_lex_state = 18},
  [1274] = {.lex_state = 85},
  [1275] = {.lex_state = 215, .external_lex_state = 2},
  [1276] = {.lex_state = 78},
  [1277] = {.lex_state = 85},
  [1278] = {.lex_state = 262, .external_lex_state = 18},
  [1279] = {.lex_state = 262, .external_lex_state = 18},
  [1280] = {.lex_state = 262, .external_lex_state = 18},
  [1281] = {.lex_state = 262, .external_lex_state = 18},
  [1282] = {.lex_state = 215, .external_lex_state = 22},
  [1283] = {.lex_state = 215, .external_lex_state = 2},
  [1284] = {.lex_state = 215, .external_lex_state = 22},
  [1285] = {.lex_state = 215, .external_lex_state = 2},
  [1286] = {.lex_state = 140, .external_lex_state = 21},
  [1287] = {.lex_state = 140, .external_lex_state = 21},
  [1288] = {.lex_state = 140, .external_lex_state = 4},
  [1289] = {.lex_state = 144, .external_lex_state = 8},
  [1290] = {.lex_state = 108, .external_lex_state = 21},
  [1291] = {.lex_state = 108, .external_lex_state = 4},
  [1292] = {.lex_state = 108, .external_lex_state = 4},
  [1293] = {.lex_state = 108, .external_lex_state = 6},
  [1294] = {.lex_state = 108, .external_lex_state = 5},
  [1295] = {.lex_state = 108, .external_lex_state = 5},
  [1296] = {.lex_state = 122, .external_lex_state = 6},
  [1297] = {.lex_state = 102},
  [1298] = {.lex_state = 229, .external_lex_state = 5},
  [1299] = {.lex_state = 140, .external_lex_state = 4},
  [1300] = {.lex_state = 229, .external_lex_state = 5},
  [1301] = {.lex_state = 140, .external_lex_state = 4},
  [1302] = {.lex_state = 229, .external_lex_state = 6},
  [1303] = {.lex_state = 229, .external_lex_state = 6},
  [1304] = {.lex_state = 229, .external_lex_state = 5},
  [1305] = {.lex_state = 229, .external_lex_state = 6},
  [1306] = {.lex_state = 229, .external_lex_state = 5},
  [1307] = {.lex_state = 78, .external_lex_state = 2},
  [1308] = {.lex_state = 229, .external_lex_state = 5},
  [1309] = {.lex_state = 122, .external_lex_state = 6},
  [1310] = {.lex_state = 122, .external_lex_state = 5},
  [1311] = {.lex_state = 122, .external_lex_state = 5},
  [1312] = {.lex_state = 78, .external_lex_state = 2},
  [1313] = {.lex_state = 146, .external_lex_state = 9},
  [1314] = {.lex_state = 122, .external_lex_state = 5},
  [1315] = {.lex_state = 186, .external_lex_state = 5},
  [1316] = {.lex_state = 96, .external_lex_state = 23},
  [1317] = {.lex_state = 96, .external_lex_state = 23},
  [1318] = {.lex_state = 85},
  [1319] = {.lex_state = 223, .external_lex_state = 7},
  [1320] = {.lex_state = 225, .external_lex_state = 18},
  [1321] = {.lex_state = 225, .external_lex_state = 18},
  [1322] = {.lex_state = 85},
  [1323] = {.lex_state = 215, .external_lex_state = 2},
  [1324] = {.lex_state = 78},
  [1325] = {.lex_state = 231, .external_lex_state = 9},
  [1326] = {.lex_state = 96, .external_lex_state = 23},
  [1327] = {.lex_state = 136, .external_lex_state = 6},
  [1328] = {.lex_state = 186, .external_lex_state = 5},
  [1329] = {.lex_state = 264, .external_lex_state = 5},
  [1330] = {.lex_state = 136, .external_lex_state = 6},
  [1331] = {.lex_state = 264, .external_lex_state = 5},
  [1332] = {.lex_state = 233, .external_lex_state = 2},
  [1333] = {.lex_state = 108, .external_lex_state = 4},
  [1334] = {.lex_state = 108, .external_lex_state = 5},
  [1335] = {.lex_state = 78},
  [1336] = {.lex_state = 78, .external_lex_state = 2},
  [1337] = {.lex_state = 78, .external_lex_state = 2},
  [1338] = {.lex_state = 78, .external_lex_state = 2},
  [1339] = {.lex_state = 102},
  [1340] = {.lex_state = 102},
  [1341] = {.lex_state = 146, .external_lex_state = 9},
  [1342] = {.lex_state = 136, .external_lex_state = 5},
  [1343] = {.lex_state = 122, .external_lex_state = 5},
  [1344] = {.lex_state = 122, .external_lex_state = 5},
  [1345] = {.lex_state = 102},
  [1346] = {.lex_state = 239, .external_lex_state = 19},
  [1347] = {.lex_state = 266, .external_lex_state = 10},
  [1348] = {.lex_state = 85},
  [1349] = {.lex_state = 266, .external_lex_state = 10},
  [1350] = {.lex_state = 85},
  [1351] = {.lex_state = 215, .external_lex_state = 10},
  [1352] = {.lex_state = 215, .external_lex_state = 10},
  [1353] = {.lex_state = 215, .external_lex_state = 10},
  [1354] = {.lex_state = 102},
  [1355] = {.lex_state = 215, .external_lex_state = 10},
  [1356] = {.lex_state = 217},
  [1357] = {.lex_state = 215, .external_lex_state = 10},
  [1358] = {.lex_state = 125},
  [1359] = {.lex_state = 85},
  [1360] = {.lex_state = 223, .external_lex_state = 7},
  [1361] = {.lex_state = 225, .external_lex_state = 18},
  [1362] = {.lex_state = 225, .external_lex_state = 18},
  [1363] = {.lex_state = 85},
  [1364] = {.lex_state = 215, .external_lex_state = 2},
  [1365] = {.lex_state = 78},
  [1366] = {.lex_state = 85},
  [1367] = {.lex_state = 184, .external_lex_state = 4},
  [1368] = {.lex_state = 215},
  [1369] = {.lex_state = 215},
  [1370] = {.lex_state = 215},
  [1371] = {.lex_state = 184, .external_lex_state = 21},
  [1372] = {.lex_state = 102},
  [1373] = {.lex_state = 140, .external_lex_state = 21},
  [1374] = {.lex_state = 184, .external_lex_state = 21},
  [1375] = {.lex_state = 217},
  [1376] = {.lex_state = 260, .external_lex_state = 18},
  [1377] = {.lex_state = 85},
  [1378] = {.lex_state = 225, .external_lex_state = 18},
  [1379] = {.lex_state = 225, .external_lex_state = 18},
  [1380] = {.lex_state = 184, .external_lex_state = 21},
  [1381] = {.lex_state = 262, .external_lex_state = 30},
  [1382] = {.lex_state = 262, .external_lex_state = 18},
  [1383] = {.lex_state = 184, .external_lex_state = 21},
  [1384] = {.lex_state = 262, .external_lex_state = 30},
  [1385] = {.lex_state = 262, .external_lex_state = 18},
  [1386] = {.lex_state = 184, .external_lex_state = 21},
  [1387] = {.lex_state = 184, .external_lex_state = 21},
  [1388] = {.lex_state = 317},
  [1389] = {.lex_state = 153},
  [1390] = {.lex_state = 268},
  [1391] = {.lex_state = 241, .external_lex_state = 9},
  [1392] = {.lex_state = 241, .external_lex_state = 14},
  [1393] = {.lex_state = 102},
  [1394] = {.lex_state = 241, .external_lex_state = 14},
  [1395] = {.lex_state = 241, .external_lex_state = 14},
  [1396] = {.lex_state = 217},
  [1397] = {.lex_state = 260, .external_lex_state = 18},
  [1398] = {.lex_state = 85},
  [1399] = {.lex_state = 225, .external_lex_state = 18},
  [1400] = {.lex_state = 225, .external_lex_state = 18},
  [1401] = {.lex_state = 241, .external_lex_state = 14},
  [1402] = {.lex_state = 262, .external_lex_state = 30},
  [1403] = {.lex_state = 262, .external_lex_state = 18},
  [1404] = {.lex_state = 241, .external_lex_state = 14},
  [1405] = {.lex_state = 262, .external_lex_state = 30},
  [1406] = {.lex_state = 262, .external_lex_state = 18},
  [1407] = {.lex_state = 241, .external_lex_state = 14},
  [1408] = {.lex_state = 241, .external_lex_state = 14},
  [1409] = {.lex_state = 241, .external_lex_state = 9},
  [1410] = {.lex_state = 241, .external_lex_state = 9},
  [1411] = {.lex_state = 241, .external_lex_state = 9},
  [1412] = {.lex_state = 270, .external_lex_state = 14},
  [1413] = {.lex_state = 270, .external_lex_state = 14},
  [1414] = {.lex_state = 270, .external_lex_state = 14},
  [1415] = {.lex_state = 102},
  [1416] = {.lex_state = 270, .external_lex_state = 14},
  [1417] = {.lex_state = 217},
  [1418] = {.lex_state = 270, .external_lex_state = 14},
  [1419] = {.lex_state = 125},
  [1420] = {.lex_state = 85},
  [1421] = {.lex_state = 223, .external_lex_state = 7},
  [1422] = {.lex_state = 225, .external_lex_state = 18},
  [1423] = {.lex_state = 225, .external_lex_state = 18},
  [1424] = {.lex_state = 85},
  [1425] = {.lex_state = 215, .external_lex_state = 2},
  [1426] = {.lex_state = 78},
  [1427] = {.lex_state = 85},
  [1428] = {.lex_state = 102},
  [1429] = {.lex_state = 270, .external_lex_state = 9},
  [1430] = {.lex_state = 270, .external_lex_state = 9},
  [1431] = {.lex_state = 270, .external_lex_state = 9},
  [1432] = {.lex_state = 244},
  [1433] = {.lex_state = 272, .external_lex_state = 10},
  [1434] = {.lex_state = 102},
  [1435] = {.lex_state = 244, .external_lex_state = 10},
  [1436] = {.lex_state = 272, .external_lex_state = 10},
  [1437] = {.lex_state = 217},
  [1438] = {.lex_state = 260, .external_lex_state = 18},
  [1439] = {.lex_state = 85},
  [1440] = {.lex_state = 225, .external_lex_state = 18},
  [1441] = {.lex_state = 225, .external_lex_state = 18},
  [1442] = {.lex_state = 272, .external_lex_state = 10},
  [1443] = {.lex_state = 262, .external_lex_state = 30},
  [1444] = {.lex_state = 262, .external_lex_state = 18},
  [1445] = {.lex_state = 272, .external_lex_state = 10},
  [1446] = {.lex_state = 262, .external_lex_state = 30},
  [1447] = {.lex_state = 262, .external_lex_state = 18},
  [1448] = {.lex_state = 272, .external_lex_state = 10},
  [1449] = {.lex_state = 272, .external_lex_state = 10},
  [1450] = {.lex_state = 244},
  [1451] = {.lex_state = 244},
  [1452] = {.lex_state = 320},
  [1453] = {.lex_state = 246, .external_lex_state = 10},
  [1454] = {.lex_state = 246, .external_lex_state = 10},
  [1455] = {.lex_state = 92, .external_lex_state = 29},
  [1456] = {.lex_state = 92, .external_lex_state = 18},
  [1457] = {.lex_state = 92, .external_lex_state = 18},
  [1458] = {.lex_state = 260, .external_lex_state = 18},
  [1459] = {.lex_state = 246, .external_lex_state = 10},
  [1460] = {.lex_state = 262, .external_lex_state = 30},
  [1461] = {.lex_state = 262, .external_lex_state = 18},
  [1462] = {.lex_state = 262, .external_lex_state = 30},
  [1463] = {.lex_state = 262, .external_lex_state = 18},
  [1464] = {.lex_state = 262, .external_lex_state = 18},
  [1465] = {.lex_state = 246, .external_lex_state = 10},
  [1466] = {.lex_state = 262, .external_lex_state = 18},
  [1467] = {.lex_state = 262, .external_lex_state = 18},
  [1468] = {.lex_state = 140, .external_lex_state = 11},
  [1469] = {.lex_state = 215},
  [1470] = {.lex_state = 140, .external_lex_state = 26},
  [1471] = {.lex_state = 140, .external_lex_state = 26},
  [1472] = {.lex_state = 140, .external_lex_state = 26},
  [1473] = {.lex_state = 102},
  [1474] = {.lex_state = 140, .external_lex_state = 26},
  [1475] = {.lex_state = 217},
  [1476] = {.lex_state = 140, .external_lex_state = 26},
  [1477] = {.lex_state = 125},
  [1478] = {.lex_state = 85},
  [1479] = {.lex_state = 223, .external_lex_state = 7},
  [1480] = {.lex_state = 225, .external_lex_state = 18},
  [1481] = {.lex_state = 225, .external_lex_state = 18},
  [1482] = {.lex_state = 85},
  [1483] = {.lex_state = 215, .external_lex_state = 2},
  [1484] = {.lex_state = 78},
  [1485] = {.lex_state = 85},
  [1486] = {.lex_state = 140, .external_lex_state = 11},
  [1487] = {.lex_state = 140, .external_lex_state = 11},
  [1488] = {.lex_state = 268},
  [1489] = {.lex_state = 241, .external_lex_state = 9},
  [1490] = {.lex_state = 146, .external_lex_state = 9},
  [1491] = {.lex_state = 270, .external_lex_state = 9},
  [1492] = {.lex_state = 136, .external_lex_state = 12},
  [1493] = {.lex_state = 136, .external_lex_state = 12},
  [1494] = {.lex_state = 172},
  [1495] = {.lex_state = 136, .external_lex_state = 12},
  [1496] = {.lex_state = 305},
  [1497] = {.lex_state = 305},
  [1498] = {.lex_state = 305},
  [1499] = {.lex_state = 310},
  [1500] = {.lex_state = 146, .external_lex_state = 9},
  [1501] = {.lex_state = 310},
  [1502] = {.lex_state = 146, .external_lex_state = 9},
  [1503] = {.lex_state = 78},
  [1504] = {.lex_state = 108, .external_lex_state = 11},
  [1505] = {.lex_state = 215},
  [1506] = {.lex_state = 108, .external_lex_state = 26},
  [1507] = {.lex_state = 108, .external_lex_state = 11},
  [1508] = {.lex_state = 108, .external_lex_state = 26},
  [1509] = {.lex_state = 102},
  [1510] = {.lex_state = 108, .external_lex_state = 26},
  [1511] = {.lex_state = 108, .external_lex_state = 26},
  [1512] = {.lex_state = 217},
  [1513] = {.lex_state = 260, .external_lex_state = 18},
  [1514] = {.lex_state = 85},
  [1515] = {.lex_state = 225, .external_lex_state = 18},
  [1516] = {.lex_state = 225, .external_lex_state = 18},
  [1517] = {.lex_state = 108, .external_lex_state = 26},
  [1518] = {.lex_state = 262, .external_lex_state = 30},
  [1519] = {.lex_state = 262, .external_lex_state = 18},
  [1520] = {.lex_state = 108, .external_lex_state = 26},
  [1521] = {.lex_state = 262, .external_lex_state = 30},
  [1522] = {.lex_state = 262, .external_lex_state = 18},
  [1523] = {.lex_state = 108, .external_lex_state = 26},
  [1524] = {.lex_state = 108, .external_lex_state = 26},
  [1525] = {.lex_state = 108, .external_lex_state = 13},
  [1526] = {.lex_state = 102},
  [1527] = {.lex_state = 108, .external_lex_state = 13},
  [1528] = {.lex_state = 108, .external_lex_state = 13},
  [1529] = {.lex_state = 217},
  [1530] = {.lex_state = 260, .external_lex_state = 18},
  [1531] = {.lex_state = 85},
  [1532] = {.lex_state = 225, .external_lex_state = 18},
  [1533] = {.lex_state = 225, .external_lex_state = 18},
  [1534] = {.lex_state = 108, .external_lex_state = 13},
  [1535] = {.lex_state = 262, .external_lex_state = 30},
  [1536] = {.lex_state = 262, .external_lex_state = 18},
  [1537] = {.lex_state = 108, .external_lex_state = 13},
  [1538] = {.lex_state = 262, .external_lex_state = 30},
  [1539] = {.lex_state = 262, .external_lex_state = 18},
  [1540] = {.lex_state = 108, .external_lex_state = 13},
  [1541] = {.lex_state = 108, .external_lex_state = 13},
  [1542] = {.lex_state = 313, .external_lex_state = 12},
  [1543] = {.lex_state = 122, .external_lex_state = 13},
  [1544] = {.lex_state = 122, .external_lex_state = 13},
  [1545] = {.lex_state = 92, .external_lex_state = 29},
  [1546] = {.lex_state = 92, .external_lex_state = 18},
  [1547] = {.lex_state = 92, .external_lex_state = 18},
  [1548] = {.lex_state = 260, .external_lex_state = 18},
  [1549] = {.lex_state = 122, .external_lex_state = 13},
  [1550] = {.lex_state = 262, .external_lex_state = 30},
  [1551] = {.lex_state = 262, .external_lex_state = 18},
  [1552] = {.lex_state = 262, .external_lex_state = 30},
  [1553] = {.lex_state = 262, .external_lex_state = 18},
  [1554] = {.lex_state = 262, .external_lex_state = 18},
  [1555] = {.lex_state = 122, .external_lex_state = 13},
  [1556] = {.lex_state = 262, .external_lex_state = 18},
  [1557] = {.lex_state = 262, .external_lex_state = 18},
  [1558] = {.lex_state = 136, .external_lex_state = 12},
  [1559] = {.lex_state = 144, .external_lex_state = 8},
  [1560] = {.lex_state = 85},
  [1561] = {.lex_state = 112},
  [1562] = {.lex_state = 275, .external_lex_state = 21},
  [1563] = {.lex_state = 125},
  [1564] = {.lex_state = 275, .external_lex_state = 21},
  [1565] = {.lex_state = 112, .external_lex_state = 7},
  [1566] = {.lex_state = 78, .external_lex_state = 2},
  [1567] = {.lex_state = 78, .external_lex_state = 2},
  [1568] = {.lex_state = 78, .external_lex_state = 2},
  [1569] = {.lex_state = 85},
  [1570] = {.lex_state = 275, .external_lex_state = 4},
  [1571] = {.lex_state = 275, .external_lex_state = 4},
  [1572] = {.lex_state = 112},
  [1573] = {.lex_state = 275, .external_lex_state = 6},
  [1574] = {.lex_state = 125},
  [1575] = {.lex_state = 275, .external_lex_state = 6},
  [1576] = {.lex_state = 112, .external_lex_state = 7},
  [1577] = {.lex_state = 78, .external_lex_state = 2},
  [1578] = {.lex_state = 78, .external_lex_state = 2},
  [1579] = {.lex_state = 78, .external_lex_state = 2},
  [1580] = {.lex_state = 275, .external_lex_state = 5},
  [1581] = {.lex_state = 275, .external_lex_state = 5},
  [1582] = {.lex_state = 281, .external_lex_state = 6},
  [1583] = {.lex_state = 281, .external_lex_state = 6},
  [1584] = {.lex_state = 281, .external_lex_state = 6},
  [1585] = {.lex_state = 102},
  [1586] = {.lex_state = 281, .external_lex_state = 6},
  [1587] = {.lex_state = 217},
  [1588] = {.lex_state = 281, .external_lex_state = 6},
  [1589] = {.lex_state = 125},
  [1590] = {.lex_state = 85},
  [1591] = {.lex_state = 223, .external_lex_state = 7},
  [1592] = {.lex_state = 225, .external_lex_state = 18},
  [1593] = {.lex_state = 225, .external_lex_state = 18},
  [1594] = {.lex_state = 85},
  [1595] = {.lex_state = 215, .external_lex_state = 2},
  [1596] = {.lex_state = 78},
  [1597] = {.lex_state = 85},
  [1598] = {.lex_state = 186, .external_lex_state = 5},
  [1599] = {.lex_state = 78},
  [1600] = {.lex_state = 249, .external_lex_state = 2},
  [1601] = {.lex_state = 78, .external_lex_state = 2},
  [1602] = {.lex_state = 78, .external_lex_state = 2},
  [1603] = {.lex_state = 102},
  [1604] = {.lex_state = 102},
  [1605] = {.lex_state = 322, .external_lex_state = 9},
  [1606] = {.lex_state = 285, .external_lex_state = 5},
  [1607] = {.lex_state = 237, .external_lex_state = 25},
  [1608] = {.lex_state = 281, .external_lex_state = 6},
  [1609] = {.lex_state = 281, .external_lex_state = 5},
  [1610] = {.lex_state = 281, .external_lex_state = 5},
  [1611] = {.lex_state = 285, .external_lex_state = 5},
  [1612] = {.lex_state = 287, .external_lex_state = 4},
  [1613] = {.lex_state = 281, .external_lex_state = 5},
  [1614] = {.lex_state = 281, .external_lex_state = 5},
  [1615] = {.lex_state = 281, .external_lex_state = 5},
  [1616] = {.lex_state = 136, .external_lex_state = 13},
  [1617] = {.lex_state = 136, .external_lex_state = 12},
  [1618] = {.lex_state = 140, .external_lex_state = 12},
  [1619] = {.lex_state = 136, .external_lex_state = 13},
  [1620] = {.lex_state = 140, .external_lex_state = 12},
  [1621] = {.lex_state = 144, .external_lex_state = 8},
  [1622] = {.lex_state = 102},
  [1623] = {.lex_state = 85},
  [1624] = {.lex_state = 106, .external_lex_state = 2},
  [1625] = {.lex_state = 324, .external_lex_state = 4},
  [1626] = {.lex_state = 324, .external_lex_state = 5},
  [1627] = {.lex_state = 112},
  [1628] = {.lex_state = 326, .external_lex_state = 6},
  [1629] = {.lex_state = 125},
  [1630] = {.lex_state = 326, .external_lex_state = 6},
  [1631] = {.lex_state = 112, .external_lex_state = 7},
  [1632] = {.lex_state = 78, .external_lex_state = 2},
  [1633] = {.lex_state = 78, .external_lex_state = 2},
  [1634] = {.lex_state = 78, .external_lex_state = 2},
  [1635] = {.lex_state = 328, .external_lex_state = 6},
  [1636] = {.lex_state = 305},
  [1637] = {.lex_state = 330, .external_lex_state = 5},
  [1638] = {.lex_state = 326, .external_lex_state = 5},
  [1639] = {.lex_state = 332, .external_lex_state = 4},
  [1640] = {.lex_state = 85},
  [1641] = {.lex_state = 326, .external_lex_state = 5},
  [1642] = {.lex_state = 78, .external_lex_state = 2},
  [1643] = {.lex_state = 102, .external_lex_state = 2},
  [1644] = {.lex_state = 326, .external_lex_state = 5},
  [1645] = {.lex_state = 85},
  [1646] = {.lex_state = 112},
  [1647] = {.lex_state = 291, .external_lex_state = 21},
  [1648] = {.lex_state = 125},
  [1649] = {.lex_state = 291, .external_lex_state = 21},
  [1650] = {.lex_state = 112, .external_lex_state = 7},
  [1651] = {.lex_state = 78, .external_lex_state = 2},
  [1652] = {.lex_state = 78, .external_lex_state = 2},
  [1653] = {.lex_state = 78, .external_lex_state = 2},
  [1654] = {.lex_state = 85},
  [1655] = {.lex_state = 291, .external_lex_state = 4},
  [1656] = {.lex_state = 291, .external_lex_state = 4},
  [1657] = {.lex_state = 112},
  [1658] = {.lex_state = 291, .external_lex_state = 6},
  [1659] = {.lex_state = 125},
  [1660] = {.lex_state = 291, .external_lex_state = 6},
  [1661] = {.lex_state = 112, .external_lex_state = 7},
  [1662] = {.lex_state = 78, .external_lex_state = 2},
  [1663] = {.lex_state = 78, .external_lex_state = 2},
  [1664] = {.lex_state = 78, .external_lex_state = 2},
  [1665] = {.lex_state = 291, .external_lex_state = 5},
  [1666] = {.lex_state = 291, .external_lex_state = 5},
  [1667] = {.lex_state = 301, .external_lex_state = 6},
  [1668] = {.lex_state = 301, .external_lex_state = 6},
  [1669] = {.lex_state = 301, .external_lex_state = 6},
  [1670] = {.lex_state = 102},
  [1671] = {.lex_state = 301, .external_lex_state = 6},
  [1672] = {.lex_state = 217},
  [1673] = {.lex_state = 301, .external_lex_state = 6},
  [1674] = {.lex_state = 125},
  [1675] = {.lex_state = 85},
  [1676] = {.lex_state = 223, .external_lex_state = 7},
  [1677] = {.lex_state = 225, .external_lex_state = 18},
  [1678] = {.lex_state = 225, .external_lex_state = 18},
  [1679] = {.lex_state = 85},
  [1680] = {.lex_state = 215, .external_lex_state = 2},
  [1681] = {.lex_state = 78},
  [1682] = {.lex_state = 85},
  [1683] = {.lex_state = 186, .external_lex_state = 5},
  [1684] = {.lex_state = 305},
  [1685] = {.lex_state = 305},
  [1686] = {.lex_state = 78},
  [1687] = {.lex_state = 255, .external_lex_state = 2},
  [1688] = {.lex_state = 78, .external_lex_state = 2},
  [1689] = {.lex_state = 78, .external_lex_state = 2},
  [1690] = {.lex_state = 102},
  [1691] = {.lex_state = 102},
  [1692] = {.lex_state = 334, .external_lex_state = 9},
  [1693] = {.lex_state = 305, .external_lex_state = 5},
  [1694] = {.lex_state = 237, .external_lex_state = 25},
  [1695] = {.lex_state = 301, .external_lex_state = 6},
  [1696] = {.lex_state = 301, .external_lex_state = 5},
  [1697] = {.lex_state = 301, .external_lex_state = 5},
  [1698] = {.lex_state = 305, .external_lex_state = 5},
  [1699] = {.lex_state = 308, .external_lex_state = 4},
  [1700] = {.lex_state = 305},
  [1701] = {.lex_state = 301, .external_lex_state = 5},
  [1702] = {.lex_state = 301, .external_lex_state = 5},
  [1703] = {.lex_state = 301, .external_lex_state = 5},
  [1704] = {.lex_state = 336, .external_lex_state = 9},
  [1705] = {.lex_state = 149, .external_lex_state = 14},
  [1706] = {.lex_state = 186, .external_lex_state = 5},
  [1707] = {.lex_state = 340, .external_lex_state = 10},
  [1708] = {.lex_state = 340, .external_lex_state = 10},
  [1709] = {.lex_state = 343},
  [1710] = {.lex_state = 340},
  [1711] = {.lex_state = 102},
  [1712] = {.lex_state = 340},
  [1713] = {.lex_state = 310},
  [1714] = {.lex_state = 149, .external_lex_state = 14},
  [1715] = {.lex_state = 92, .external_lex_state = 29},
  [1716] = {.lex_state = 92, .external_lex_state = 18},
  [1717] = {.lex_state = 92, .external_lex_state = 18},
  [1718] = {.lex_state = 260, .external_lex_state = 18},
  [1719] = {.lex_state = 149, .external_lex_state = 14},
  [1720] = {.lex_state = 262, .external_lex_state = 30},
  [1721] = {.lex_state = 262, .external_lex_state = 18},
  [1722] = {.lex_state = 262, .external_lex_state = 30},
  [1723] = {.lex_state = 262, .external_lex_state = 18},
  [1724] = {.lex_state = 262, .external_lex_state = 18},
  [1725] = {.lex_state = 149, .external_lex_state = 14},
  [1726] = {.lex_state = 262, .external_lex_state = 18},
  [1727] = {.lex_state = 262, .external_lex_state = 18},
  [1728] = {.lex_state = 186, .external_lex_state = 5},
  [1729] = {.lex_state = 343},
  [1730] = {.lex_state = 102},
  [1731] = {.lex_state = 310},
  [1732] = {.lex_state = 186, .external_lex_state = 5},
  [1733] = {.lex_state = 184, .external_lex_state = 21},
  [1734] = {.lex_state = 184, .external_lex_state = 4},
  [1735] = {.lex_state = 178, .external_lex_state = 21},
  [1736] = {.lex_state = 178, .external_lex_state = 4},
  [1737] = {.lex_state = 178, .external_lex_state = 21},
  [1738] = {.lex_state = 178, .external_lex_state = 6},
  [1739] = {.lex_state = 182, .external_lex_state = 6},
  [1740] = {.lex_state = 182, .external_lex_state = 5},
  [1741] = {.lex_state = 182, .external_lex_state = 6},
  [1742] = {.lex_state = 182, .external_lex_state = 5},
  [1743] = {.lex_state = 207, .external_lex_state = 15},
  [1744] = {.lex_state = 215},
  [1745] = {.lex_state = 207, .external_lex_state = 27},
  [1746] = {.lex_state = 207, .external_lex_state = 27},
  [1747] = {.lex_state = 207, .external_lex_state = 27},
  [1748] = {.lex_state = 102},
  [1749] = {.lex_state = 207, .external_lex_state = 27},
  [1750] = {.lex_state = 217},
  [1751] = {.lex_state = 207, .external_lex_state = 27},
  [1752] = {.lex_state = 125},
  [1753] = {.lex_state = 85},
  [1754] = {.lex_state = 223, .external_lex_state = 7},
  [1755] = {.lex_state = 225, .external_lex_state = 18},
  [1756] = {.lex_state = 225, .external_lex_state = 18},
  [1757] = {.lex_state = 85},
  [1758] = {.lex_state = 215, .external_lex_state = 2},
  [1759] = {.lex_state = 78},
  [1760] = {.lex_state = 85},
  [1761] = {.lex_state = 207, .external_lex_state = 15},
  [1762] = {.lex_state = 207, .external_lex_state = 15},
  [1763] = {.lex_state = 268},
  [1764] = {.lex_state = 241, .external_lex_state = 9},
  [1765] = {.lex_state = 146, .external_lex_state = 9},
  [1766] = {.lex_state = 270, .external_lex_state = 9},
  [1767] = {.lex_state = 205, .external_lex_state = 16},
  [1768] = {.lex_state = 205, .external_lex_state = 16},
  [1769] = {.lex_state = 172},
  [1770] = {.lex_state = 205, .external_lex_state = 16},
  [1771] = {.lex_state = 305},
  [1772] = {.lex_state = 305},
  [1773] = {.lex_state = 305},
  [1774] = {.lex_state = 310},
  [1775] = {.lex_state = 146, .external_lex_state = 9},
  [1776] = {.lex_state = 310},
  [1777] = {.lex_state = 146, .external_lex_state = 9},
  [1778] = {.lex_state = 78},
  [1779] = {.lex_state = 199, .external_lex_state = 15},
  [1780] = {.lex_state = 215},
  [1781] = {.lex_state = 199, .external_lex_state = 27},
  [1782] = {.lex_state = 199, .external_lex_state = 15},
  [1783] = {.lex_state = 199, .external_lex_state = 27},
  [1784] = {.lex_state = 102},
  [1785] = {.lex_state = 199, .external_lex_state = 27},
  [1786] = {.lex_state = 199, .external_lex_state = 27},
  [1787] = {.lex_state = 217},
  [1788] = {.lex_state = 260, .external_lex_state = 18},
  [1789] = {.lex_state = 85},
  [1790] = {.lex_state = 225, .external_lex_state = 18},
  [1791] = {.lex_state = 225, .external_lex_state = 18},
  [1792] = {.lex_state = 199, .external_lex_state = 27},
  [1793] = {.lex_state = 262, .external_lex_state = 30},
  [1794] = {.lex_state = 262, .external_lex_state = 18},
  [1795] = {.lex_state = 199, .external_lex_state = 27},
  [1796] = {.lex_state = 262, .external_lex_state = 30},
  [1797] = {.lex_state = 262, .external_lex_state = 18},
  [1798] = {.lex_state = 199, .external_lex_state = 27},
  [1799] = {.lex_state = 199, .external_lex_state = 27},
  [1800] = {.lex_state = 199, .external_lex_state = 17},
  [1801] = {.lex_state = 102},
  [1802] = {.lex_state = 199, .external_lex_state = 17},
  [1803] = {.lex_state = 199, .external_lex_state = 17},
  [1804] = {.lex_state = 217},
  [1805] = {.lex_state = 260, .external_lex_state = 18},
  [1806] = {.lex_state = 85},
  [1807] = {.lex_state = 225, .external_lex_state = 18},
  [1808] = {.lex_state = 225, .external_lex_state = 18},
  [1809] = {.lex_state = 199, .external_lex_state = 17},
  [1810] = {.lex_state = 262, .external_lex_state = 30},
  [1811] = {.lex_state = 262, .external_lex_state = 18},
  [1812] = {.lex_state = 199, .external_lex_state = 17},
  [1813] = {.lex_state = 262, .external_lex_state = 30},
  [1814] = {.lex_state = 262, .external_lex_state = 18},
  [1815] = {.lex_state = 199, .external_lex_state = 17},
  [1816] = {.lex_state = 199, .external_lex_state = 17},
  [1817] = {.lex_state = 346, .external_lex_state = 16},
  [1818] = {.lex_state = 201, .external_lex_state = 17},
  [1819] = {.lex_state = 201, .external_lex_state = 17},
  [1820] = {.lex_state = 92, .external_lex_state = 29},
  [1821] = {.lex_state = 92, .external_lex_state = 18},
  [1822] = {.lex_state = 92, .external_lex_state = 18},
  [1823] = {.lex_state = 260, .external_lex_state = 18},
  [1824] = {.lex_state = 201, .external_lex_state = 17},
  [1825] = {.lex_state = 262, .external_lex_state = 30},
  [1826] = {.lex_state = 262, .external_lex_state = 18},
  [1827] = {.lex_state = 262, .external_lex_state = 30},
  [1828] = {.lex_state = 262, .external_lex_state = 18},
  [1829] = {.lex_state = 262, .external_lex_state = 18},
  [1830] = {.lex_state = 201, .external_lex_state = 17},
  [1831] = {.lex_state = 262, .external_lex_state = 18},
  [1832] = {.lex_state = 262, .external_lex_state = 18},
  [1833] = {.lex_state = 205, .external_lex_state = 16},
  [1834] = {.lex_state = 258, .external_lex_state = 28},
  [1835] = {.lex_state = 205, .external_lex_state = 17},
  [1836] = {.lex_state = 205, .external_lex_state = 16},
  [1837] = {.lex_state = 205, .external_lex_state = 16},
  [1838] = {.lex_state = 205, .external_lex_state = 17},
  [1839] = {.lex_state = 205, .external_lex_state = 16},
  [1840] = {.lex_state = 104, .external_lex_state = 3},
  [1841] = {.lex_state = 102, .external_lex_state = 2},
  [1842] = {.lex_state = 215},
  [1843] = {.lex_state = 348, .external_lex_state = 20},
  [1844] = {.lex_state = 209, .external_lex_state = 19},
  [1845] = {.lex_state = 209, .external_lex_state = 19},
  [1846] = {.lex_state = 92, .external_lex_state = 29},
  [1847] = {.lex_state = 92, .external_lex_state = 18},
  [1848] = {.lex_state = 92, .external_lex_state = 18},
  [1849] = {.lex_state = 260, .external_lex_state = 18},
  [1850] = {.lex_state = 209, .external_lex_state = 19},
  [1851] = {.lex_state = 262, .external_lex_state = 30},
  [1852] = {.lex_state = 262, .external_lex_state = 18},
  [1853] = {.lex_state = 262, .external_lex_state = 30},
  [1854] = {.lex_state = 262, .external_lex_state = 18},
  [1855] = {.lex_state = 262, .external_lex_state = 18},
  [1856] = {.lex_state = 209, .external_lex_state = 19},
  [1857] = {.lex_state = 262, .external_lex_state = 18},
  [1858] = {.lex_state = 262, .external_lex_state = 18},
  [1859] = {.lex_state = 178, .external_lex_state = 4},
  [1860] = {.lex_state = 215},
  [1861] = {.lex_state = 350, .external_lex_state = 4},
  [1862] = {.lex_state = 178, .external_lex_state = 21},
  [1863] = {.lex_state = 178, .external_lex_state = 21},
  [1864] = {.lex_state = 92, .external_lex_state = 29},
  [1865] = {.lex_state = 92, .external_lex_state = 18},
  [1866] = {.lex_state = 92, .external_lex_state = 18},
  [1867] = {.lex_state = 260, .external_lex_state = 18},
  [1868] = {.lex_state = 178, .external_lex_state = 21},
  [1869] = {.lex_state = 262, .external_lex_state = 30},
  [1870] = {.lex_state = 262, .external_lex_state = 18},
  [1871] = {.lex_state = 262, .external_lex_state = 30},
  [1872] = {.lex_state = 262, .external_lex_state = 18},
  [1873] = {.lex_state = 262, .external_lex_state = 18},
  [1874] = {.lex_state = 178, .external_lex_state = 21},
  [1875] = {.lex_state = 262, .external_lex_state = 18},
  [1876] = {.lex_state = 262, .external_lex_state = 18},
  [1877] = {.lex_state = 350, .external_lex_state = 5},
  [1878] = {.lex_state = 178, .external_lex_state = 6},
  [1879] = {.lex_state = 178, .external_lex_state = 6},
  [1880] = {.lex_state = 92, .external_lex_state = 29},
  [1881] = {.lex_state = 92, .external_lex_state = 18},
  [1882] = {.lex_state = 92, .external_lex_state = 18},
  [1883] = {.lex_state = 260, .external_lex_state = 18},
  [1884] = {.lex_state = 178, .external_lex_state = 6},
  [1885] = {.lex_state = 262, .external_lex_state = 30},
  [1886] = {.lex_state = 262, .external_lex_state = 18},
  [1887] = {.lex_state = 262, .external_lex_state = 30},
  [1888] = {.lex_state = 262, .external_lex_state = 18},
  [1889] = {.lex_state = 262, .external_lex_state = 18},
  [1890] = {.lex_state = 178, .external_lex_state = 6},
  [1891] = {.lex_state = 262, .external_lex_state = 18},
  [1892] = {.lex_state = 262, .external_lex_state = 18},
  [1893] = {.lex_state = 352, .external_lex_state = 2},
  [1894] = {.lex_state = 215, .external_lex_state = 22},
  [1895] = {.lex_state = 215, .external_lex_state = 22},
  [1896] = {.lex_state = 92, .external_lex_state = 29},
  [1897] = {.lex_state = 92, .external_lex_state = 18},
  [1898] = {.lex_state = 92, .external_lex_state = 18},
  [1899] = {.lex_state = 260, .external_lex_state = 18},
  [1900] = {.lex_state = 215, .external_lex_state = 22},
  [1901] = {.lex_state = 262, .external_lex_state = 30},
  [1902] = {.lex_state = 262, .external_lex_state = 18},
  [1903] = {.lex_state = 262, .external_lex_state = 30},
  [1904] = {.lex_state = 262, .external_lex_state = 18},
  [1905] = {.lex_state = 262, .external_lex_state = 18},
  [1906] = {.lex_state = 215, .external_lex_state = 22},
  [1907] = {.lex_state = 262, .external_lex_state = 18},
  [1908] = {.lex_state = 262, .external_lex_state = 18},
  [1909] = {.lex_state = 125, .external_lex_state = 10},
  [1910] = {.lex_state = 92, .external_lex_state = 29},
  [1911] = {.lex_state = 92, .external_lex_state = 18},
  [1912] = {.lex_state = 92, .external_lex_state = 18},
  [1913] = {.lex_state = 260, .external_lex_state = 18},
  [1914] = {.lex_state = 125, .external_lex_state = 10},
  [1915] = {.lex_state = 262, .external_lex_state = 30},
  [1916] = {.lex_state = 262, .external_lex_state = 18},
  [1917] = {.lex_state = 262, .external_lex_state = 30},
  [1918] = {.lex_state = 262, .external_lex_state = 18},
  [1919] = {.lex_state = 262, .external_lex_state = 18},
  [1920] = {.lex_state = 125, .external_lex_state = 10},
  [1921] = {.lex_state = 262, .external_lex_state = 18},
  [1922] = {.lex_state = 262, .external_lex_state = 18},
  [1923] = {.lex_state = 239, .external_lex_state = 20},
  [1924] = {.lex_state = 225, .external_lex_state = 29},
  [1925] = {.lex_state = 209, .external_lex_state = 20},
  [1926] = {.lex_state = 209, .external_lex_state = 20},
  [1927] = {.lex_state = 225, .external_lex_state = 29},
  [1928] = {.lex_state = 92, .external_lex_state = 29},
  [1929] = {.lex_state = 92, .external_lex_state = 29},
  [1930] = {.lex_state = 92, .external_lex_state = 29},
  [1931] = {.lex_state = 102},
  [1932] = {.lex_state = 92, .external_lex_state = 29},
  [1933] = {.lex_state = 217},
  [1934] = {.lex_state = 92, .external_lex_state = 29},
  [1935] = {.lex_state = 125},
  [1936] = {.lex_state = 142, .external_lex_state = 6},
  [1937] = {.lex_state = 85},
  [1938] = {.lex_state = 223, .external_lex_state = 7},
  [1939] = {.lex_state = 225, .external_lex_state = 18},
  [1940] = {.lex_state = 225, .external_lex_state = 18},
  [1941] = {.lex_state = 85},
  [1942] = {.lex_state = 215, .external_lex_state = 2},
  [1943] = {.lex_state = 78},
  [1944] = {.lex_state = 85},
  [1945] = {.lex_state = 142, .external_lex_state = 6},
  [1946] = {.lex_state = 92, .external_lex_state = 18},
  [1947] = {.lex_state = 92, .external_lex_state = 18},
  [1948] = {.lex_state = 92, .external_lex_state = 29},
  [1949] = {.lex_state = 92, .external_lex_state = 18},
  [1950] = {.lex_state = 92, .external_lex_state = 18},
  [1951] = {.lex_state = 262, .external_lex_state = 18},
  [1952] = {.lex_state = 142, .external_lex_state = 6},
  [1953] = {.lex_state = 262, .external_lex_state = 18},
  [1954] = {.lex_state = 262, .external_lex_state = 18},
  [1955] = {.lex_state = 262, .external_lex_state = 18},
  [1956] = {.lex_state = 262, .external_lex_state = 29},
  [1957] = {.lex_state = 102},
  [1958] = {.lex_state = 262, .external_lex_state = 29},
  [1959] = {.lex_state = 262, .external_lex_state = 29},
  [1960] = {.lex_state = 217},
  [1961] = {.lex_state = 260, .external_lex_state = 18},
  [1962] = {.lex_state = 85},
  [1963] = {.lex_state = 225, .external_lex_state = 18},
  [1964] = {.lex_state = 225, .external_lex_state = 18},
  [1965] = {.lex_state = 262, .external_lex_state = 29},
  [1966] = {.lex_state = 262, .external_lex_state = 30},
  [1967] = {.lex_state = 262, .external_lex_state = 18},
  [1968] = {.lex_state = 262, .external_lex_state = 29},
  [1969] = {.lex_state = 262, .external_lex_state = 30},
  [1970] = {.lex_state = 262, .external_lex_state = 18},
  [1971] = {.lex_state = 142, .external_lex_state = 6},
  [1972] = {.lex_state = 262, .external_lex_state = 18},
  [1973] = {.lex_state = 262, .external_lex_state = 29},
  [1974] = {.lex_state = 262, .external_lex_state = 29},
  [1975] = {.lex_state = 215, .external_lex_state = 22},
  [1976] = {.lex_state = 140, .external_lex_state = 21},
  [1977] = {.lex_state = 140, .external_lex_state = 4},
  [1978] = {.lex_state = 108, .external_lex_state = 21},
  [1979] = {.lex_state = 108, .external_lex_state = 4},
  [1980] = {.lex_state = 108, .external_lex_state = 21},
  [1981] = {.lex_state = 108, .external_lex_state = 6},
  [1982] = {.lex_state = 229, .external_lex_state = 6},
  [1983] = {.lex_state = 229, .external_lex_state = 5},
  [1984] = {.lex_state = 229, .external_lex_state = 6},
  [1985] = {.lex_state = 229, .external_lex_state = 5},
  [1986] = {.lex_state = 78, .external_lex_state = 2},
  [1987] = {.lex_state = 260, .external_lex_state = 18},
  [1988] = {.lex_state = 85},
  [1989] = {.lex_state = 225, .external_lex_state = 18},
  [1990] = {.lex_state = 225, .external_lex_state = 18},
  [1991] = {.lex_state = 96, .external_lex_state = 23},
  [1992] = {.lex_state = 262, .external_lex_state = 30},
  [1993] = {.lex_state = 262, .external_lex_state = 18},
  [1994] = {.lex_state = 96, .external_lex_state = 23},
  [1995] = {.lex_state = 262, .external_lex_state = 30},
  [1996] = {.lex_state = 262, .external_lex_state = 18},
  [1997] = {.lex_state = 96, .external_lex_state = 23},
  [1998] = {.lex_state = 102},
  [1999] = {.lex_state = 136, .external_lex_state = 6},
  [2000] = {.lex_state = 102},
  [2001] = {.lex_state = 136, .external_lex_state = 5},
  [2002] = {.lex_state = 140, .external_lex_state = 4},
  [2003] = {.lex_state = 136, .external_lex_state = 5},
  [2004] = {.lex_state = 140, .external_lex_state = 4},
  [2005] = {.lex_state = 264, .external_lex_state = 6},
  [2006] = {.lex_state = 136, .external_lex_state = 6},
  [2007] = {.lex_state = 264, .external_lex_state = 5},
  [2008] = {.lex_state = 136, .external_lex_state = 6},
  [2009] = {.lex_state = 264, .external_lex_state = 5},
  [2010] = {.lex_state = 78, .external_lex_state = 2},
  [2011] = {.lex_state = 136, .external_lex_state = 5},
  [2012] = {.lex_state = 122, .external_lex_state = 5},
  [2013] = {.lex_state = 354, .external_lex_state = 19},
  [2014] = {.lex_state = 85},
  [2015] = {.lex_state = 85},
  [2016] = {.lex_state = 215, .external_lex_state = 10},
  [2017] = {.lex_state = 102},
  [2018] = {.lex_state = 215, .external_lex_state = 10},
  [2019] = {.lex_state = 215, .external_lex_state = 10},
  [2020] = {.lex_state = 217},
  [2021] = {.lex_state = 260, .external_lex_state = 18},
  [2022] = {.lex_state = 85},
  [2023] = {.lex_state = 225, .external_lex_state = 18},
  [2024] = {.lex_state = 225, .external_lex_state = 18},
  [2025] = {.lex_state = 215, .external_lex_state = 10},
  [2026] = {.lex_state = 262, .external_lex_state = 30},
  [2027] = {.lex_state = 262, .external_lex_state = 18},
  [2028] = {.lex_state = 215, .external_lex_state = 10},
  [2029] = {.lex_state = 262, .external_lex_state = 30},
  [2030] = {.lex_state = 262, .external_lex_state = 18},
  [2031] = {.lex_state = 215, .external_lex_state = 10},
  [2032] = {.lex_state = 215, .external_lex_state = 10},
  [2033] = {.lex_state = 350, .external_lex_state = 4},
  [2034] = {.lex_state = 184, .external_lex_state = 21},
  [2035] = {.lex_state = 184, .external_lex_state = 21},
  [2036] = {.lex_state = 92, .external_lex_state = 29},
  [2037] = {.lex_state = 92, .external_lex_state = 18},
  [2038] = {.lex_state = 92, .external_lex_state = 18},
  [2039] = {.lex_state = 260, .external_lex_state = 18},
  [2040] = {.lex_state = 184, .external_lex_state = 21},
  [2041] = {.lex_state = 262, .external_lex_state = 30},
  [2042] = {.lex_state = 262, .external_lex_state = 18},
  [2043] = {.lex_state = 262, .external_lex_state = 30},
  [2044] = {.lex_state = 262, .external_lex_state = 18},
  [2045] = {.lex_state = 262, .external_lex_state = 18},
  [2046] = {.lex_state = 184, .external_lex_state = 21},
  [2047] = {.lex_state = 262, .external_lex_state = 18},
  [2048] = {.lex_state = 262, .external_lex_state = 18},
  [2049] = {.lex_state = 317},
  [2050] = {.lex_state = 186, .external_lex_state = 5},
  [2051] = {.lex_state = 317},
  [2052] = {.lex_state = 153},
  [2053] = {.lex_state = 356, .external_lex_state = 9},
  [2054] = {.lex_state = 241, .external_lex_state = 14},
  [2055] = {.lex_state = 241, .external_lex_state = 14},
  [2056] = {.lex_state = 92, .external_lex_state = 29},
  [2057] = {.lex_state = 92, .external_lex_state = 18},
  [2058] = {.lex_state = 92, .external_lex_state = 18},
  [2059] = {.lex_state = 260, .external_lex_state = 18},
  [2060] = {.lex_state = 241, .external_lex_state = 14},
  [2061] = {.lex_state = 262, .external_lex_state = 30},
  [2062] = {.lex_state = 262, .external_lex_state = 18},
  [2063] = {.lex_state = 262, .external_lex_state = 30},
  [2064] = {.lex_state = 262, .external_lex_state = 18},
  [2065] = {.lex_state = 262, .external_lex_state = 18},
  [2066] = {.lex_state = 241, .external_lex_state = 14},
  [2067] = {.lex_state = 262, .external_lex_state = 18},
  [2068] = {.lex_state = 262, .external_lex_state = 18},
  [2069] = {.lex_state = 268},
  [2070] = {.lex_state = 270, .external_lex_state = 14},
  [2071] = {.lex_state = 102},
  [2072] = {.lex_state = 270, .external_lex_state = 14},
  [2073] = {.lex_state = 270, .external_lex_state = 14},
  [2074] = {.lex_state = 217},
  [2075] = {.lex_state = 260, .external_lex_state = 18},
  [2076] = {.lex_state = 85},
  [2077] = {.lex_state = 225, .external_lex_state = 18},
  [2078] = {.lex_state = 225, .external_lex_state = 18},
  [2079] = {.lex_state = 270, .external_lex_state = 14},
  [2080] = {.lex_state = 262, .external_lex_state = 30},
  [2081] = {.lex_state = 262, .external_lex_state = 18},
  [2082] = {.lex_state = 270, .external_lex_state = 14},
  [2083] = {.lex_state = 262, .external_lex_state = 30},
  [2084] = {.lex_state = 262, .external_lex_state = 18},
  [2085] = {.lex_state = 270, .external_lex_state = 14},
  [2086] = {.lex_state = 270, .external_lex_state = 14},
  [2087] = {.lex_state = 186, .external_lex_state = 5},
  [2088] = {.lex_state = 356},
  [2089] = {.lex_state = 272, .external_lex_state = 10},
  [2090] = {.lex_state = 272, .external_lex_state = 10},
  [2091] = {.lex_state = 92, .external_lex_state = 29},
  [2092] = {.lex_state = 92, .external_lex_state = 18},
  [2093] = {.lex_state = 92, .external_lex_state = 18},
  [2094] = {.lex_state = 260, .external_lex_state = 18},
  [2095] = {.lex_state = 272, .external_lex_state = 10},
  [2096] = {.lex_state = 262, .external_lex_state = 30},
  [2097] = {.lex_state = 262, .external_lex_state = 18},
  [2098] = {.lex_state = 262, .external_lex_state = 30},
  [2099] = {.lex_state = 262, .external_lex_state = 18},
  [2100] = {.lex_state = 262, .external_lex_state = 18},
  [2101] = {.lex_state = 272, .external_lex_state = 10},
  [2102] = {.lex_state = 262, .external_lex_state = 18},
  [2103] = {.lex_state = 262, .external_lex_state = 18},
  [2104] = {.lex_state = 246, .external_lex_state = 10},
  [2105] = {.lex_state = 246, .external_lex_state = 10},
  [2106] = {.lex_state = 92, .external_lex_state = 29},
  [2107] = {.lex_state = 92, .external_lex_state = 18},
  [2108] = {.lex_state = 92, .external_lex_state = 18},
  [2109] = {.lex_state = 262, .external_lex_state = 18},
  [2110] = {.lex_state = 246, .external_lex_state = 10},
  [2111] = {.lex_state = 262, .external_lex_state = 18},
  [2112] = {.lex_state = 262, .external_lex_state = 18},
  [2113] = {.lex_state = 262, .external_lex_state = 18},
  [2114] = {.lex_state = 246, .external_lex_state = 10},
  [2115] = {.lex_state = 262, .external_lex_state = 18},
  [2116] = {.lex_state = 140, .external_lex_state = 11},
  [2117] = {.lex_state = 140, .external_lex_state = 26},
  [2118] = {.lex_state = 102},
  [2119] = {.lex_state = 140, .external_lex_state = 26},
  [2120] = {.lex_state = 140, .external_lex_state = 26},
  [2121] = {.lex_state = 217},
  [2122] = {.lex_state = 260, .external_lex_state = 18},
  [2123] = {.lex_state = 85},
  [2124] = {.lex_state = 225, .external_lex_state = 18},
  [2125] = {.lex_state = 225, .external_lex_state = 18},
  [2126] = {.lex_state = 140, .external_lex_state = 26},
  [2127] = {.lex_state = 262, .external_lex_state = 30},
  [2128] = {.lex_state = 262, .external_lex_state = 18},
  [2129] = {.lex_state = 140, .external_lex_state = 26},
  [2130] = {.lex_state = 262, .external_lex_state = 30},
  [2131] = {.lex_state = 262, .external_lex_state = 18},
  [2132] = {.lex_state = 140, .external_lex_state = 26},
  [2133] = {.lex_state = 140, .external_lex_state = 26},
  [2134] = {.lex_state = 317},
  [2135] = {.lex_state = 153},
  [2136] = {.lex_state = 268},
  [2137] = {.lex_state = 241, .external_lex_state = 9},
  [2138] = {.lex_state = 102},
  [2139] = {.lex_state = 136, .external_lex_state = 12},
  [2140] = {.lex_state = 136, .external_lex_state = 12},
  [2141] = {.lex_state = 305},
  [2142] = {.lex_state = 305},
  [2143] = {.lex_state = 136, .external_lex_state = 12},
  [2144] = {.lex_state = 343},
  [2145] = {.lex_state = 102},
  [2146] = {.lex_state = 310},
  [2147] = {.lex_state = 136, .external_lex_state = 12},
  [2148] = {.lex_state = 343},
  [2149] = {.lex_state = 102},
  [2150] = {.lex_state = 310},
  [2151] = {.lex_state = 136, .external_lex_state = 12},
  [2152] = {.lex_state = 108, .external_lex_state = 11},
  [2153] = {.lex_state = 215},
  [2154] = {.lex_state = 350, .external_lex_state = 11},
  [2155] = {.lex_state = 108, .external_lex_state = 26},
  [2156] = {.lex_state = 108, .external_lex_state = 26},
  [2157] = {.lex_state = 92, .external_lex_state = 29},
  [2158] = {.lex_state = 92, .external_lex_state = 18},
  [2159] = {.lex_state = 92, .external_lex_state = 18},
  [2160] = {.lex_state = 260, .external_lex_state = 18},
  [2161] = {.lex_state = 108, .external_lex_state = 26},
  [2162] = {.lex_state = 262, .external_lex_state = 30},
  [2163] = {.lex_state = 262, .external_lex_state = 18},
  [2164] = {.lex_state = 262, .external_lex_state = 30},
  [2165] = {.lex_state = 262, .external_lex_state = 18},
  [2166] = {.lex_state = 262, .external_lex_state = 18},
  [2167] = {.lex_state = 108, .external_lex_state = 26},
  [2168] = {.lex_state = 262, .external_lex_state = 18},
  [2169] = {.lex_state = 262, .external_lex_state = 18},
  [2170] = {.lex_state = 350, .external_lex_state = 12},
  [2171] = {.lex_state = 108, .external_lex_state = 13},
  [2172] = {.lex_state = 108, .external_lex_state = 13},
  [2173] = {.lex_state = 92, .external_lex_state = 29},
  [2174] = {.lex_state = 92, .external_lex_state = 18},
  [2175] = {.lex_state = 92, .external_lex_state = 18},
  [2176] = {.lex_state = 260, .external_lex_state = 18},
  [2177] = {.lex_state = 108, .external_lex_state = 13},
  [2178] = {.lex_state = 262, .external_lex_state = 30},
  [2179] = {.lex_state = 262, .external_lex_state = 18},
  [2180] = {.lex_state = 262, .external_lex_state = 30},
  [2181] = {.lex_state = 262, .external_lex_state = 18},
  [2182] = {.lex_state = 262, .external_lex_state = 18},
  [2183] = {.lex_state = 108, .external_lex_state = 13},
  [2184] = {.lex_state = 262, .external_lex_state = 18},
  [2185] = {.lex_state = 262, .external_lex_state = 18},
  [2186] = {.lex_state = 122, .external_lex_state = 13},
  [2187] = {.lex_state = 122, .external_lex_state = 13},
  [2188] = {.lex_state = 92, .external_lex_state = 29},
  [2189] = {.lex_state = 92, .external_lex_state = 18},
  [2190] = {.lex_state = 92, .external_lex_state = 18},
  [2191] = {.lex_state = 262, .external_lex_state = 18},
  [2192] = {.lex_state = 122, .external_lex_state = 13},
  [2193] = {.lex_state = 262, .external_lex_state = 18},
  [2194] = {.lex_state = 262, .external_lex_state = 18},
  [2195] = {.lex_state = 262, .external_lex_state = 18},
  [2196] = {.lex_state = 122, .external_lex_state = 13},
  [2197] = {.lex_state = 262, .external_lex_state = 18},
  [2198] = {.lex_state = 287, .external_lex_state = 4},
  [2199] = {.lex_state = 215},
  [2200] = {.lex_state = 112},
  [2201] = {.lex_state = 287, .external_lex_state = 21},
  [2202] = {.lex_state = 125},
  [2203] = {.lex_state = 287, .external_lex_state = 21},
  [2204] = {.lex_state = 112, .external_lex_state = 7},
  [2205] = {.lex_state = 78, .external_lex_state = 2},
  [2206] = {.lex_state = 78, .external_lex_state = 2},
  [2207] = {.lex_state = 78, .external_lex_state = 2},
  [2208] = {.lex_state = 287, .external_lex_state = 4},
  [2209] = {.lex_state = 144, .external_lex_state = 8},
  [2210] = {.lex_state = 275, .external_lex_state = 21},
  [2211] = {.lex_state = 275, .external_lex_state = 21},
  [2212] = {.lex_state = 275, .external_lex_state = 21},
  [2213] = {.lex_state = 102},
  [2214] = {.lex_state = 275, .external_lex_state = 21},
  [2215] = {.lex_state = 217},
  [2216] = {.lex_state = 275, .external_lex_state = 21},
  [2217] = {.lex_state = 125},
  [2218] = {.lex_state = 85},
  [2219] = {.lex_state = 223, .external_lex_state = 7},
  [2220] = {.lex_state = 225, .external_lex_state = 18},
  [2221] = {.lex_state = 225, .external_lex_state = 18},
  [2222] = {.lex_state = 85},
  [2223] = {.lex_state = 215, .external_lex_state = 2},
  [2224] = {.lex_state = 78},
  [2225] = {.lex_state = 85},
  [2226] = {.lex_state = 275, .external_lex_state = 4},
  [2227] = {.lex_state = 275, .external_lex_state = 4},
  [2228] = {.lex_state = 275, .external_lex_state = 4},
  [2229] = {.lex_state = 275, .external_lex_state = 6},
  [2230] = {.lex_state = 275, .external_lex_state = 6},
  [2231] = {.lex_state = 275, .external_lex_state = 6},
  [2232] = {.lex_state = 102},
  [2233] = {.lex_state = 275, .external_lex_state = 6},
  [2234] = {.lex_state = 217},
  [2235] = {.lex_state = 275, .external_lex_state = 6},
  [2236] = {.lex_state = 125},
  [2237] = {.lex_state = 85},
  [2238] = {.lex_state = 223, .external_lex_state = 7},
  [2239] = {.lex_state = 225, .external_lex_state = 18},
  [2240] = {.lex_state = 225, .external_lex_state = 18},
  [2241] = {.lex_state = 85},
  [2242] = {.lex_state = 215, .external_lex_state = 2},
  [2243] = {.lex_state = 78},
  [2244] = {.lex_state = 85},
  [2245] = {.lex_state = 275, .external_lex_state = 5},
  [2246] = {.lex_state = 275, .external_lex_state = 5},
  [2247] = {.lex_state = 275, .external_lex_state = 5},
  [2248] = {.lex_state = 281, .external_lex_state = 6},
  [2249] = {.lex_state = 102},
  [2250] = {.lex_state = 281, .external_lex_state = 6},
  [2251] = {.lex_state = 281, .external_lex_state = 6},
  [2252] = {.lex_state = 217},
  [2253] = {.lex_state = 260, .external_lex_state = 18},
  [2254] = {.lex_state = 85},
  [2255] = {.lex_state = 225, .external_lex_state = 18},
  [2256] = {.lex_state = 225, .external_lex_state = 18},
  [2257] = {.lex_state = 281, .external_lex_state = 6},
  [2258] = {.lex_state = 262, .external_lex_state = 30},
  [2259] = {.lex_state = 262, .external_lex_state = 18},
  [2260] = {.lex_state = 281, .external_lex_state = 6},
  [2261] = {.lex_state = 262, .external_lex_state = 30},
  [2262] = {.lex_state = 262, .external_lex_state = 18},
  [2263] = {.lex_state = 281, .external_lex_state = 6},
  [2264] = {.lex_state = 281, .external_lex_state = 6},
  [2265] = {.lex_state = 102},
  [2266] = {.lex_state = 285, .external_lex_state = 5},
  [2267] = {.lex_state = 287, .external_lex_state = 4},
  [2268] = {.lex_state = 285, .external_lex_state = 5},
  [2269] = {.lex_state = 287, .external_lex_state = 4},
  [2270] = {.lex_state = 112},
  [2271] = {.lex_state = 285, .external_lex_state = 6},
  [2272] = {.lex_state = 125},
  [2273] = {.lex_state = 285, .external_lex_state = 6},
  [2274] = {.lex_state = 112, .external_lex_state = 7},
  [2275] = {.lex_state = 78, .external_lex_state = 2},
  [2276] = {.lex_state = 78, .external_lex_state = 2},
  [2277] = {.lex_state = 78, .external_lex_state = 2},
  [2278] = {.lex_state = 285, .external_lex_state = 5},
  [2279] = {.lex_state = 285, .external_lex_state = 6},
  [2280] = {.lex_state = 285, .external_lex_state = 5},
  [2281] = {.lex_state = 249, .external_lex_state = 2},
  [2282] = {.lex_state = 285, .external_lex_state = 5},
  [2283] = {.lex_state = 281, .external_lex_state = 5},
  [2284] = {.lex_state = 281, .external_lex_state = 6},
  [2285] = {.lex_state = 281, .external_lex_state = 5},
  [2286] = {.lex_state = 281, .external_lex_state = 5},
  [2287] = {.lex_state = 249, .external_lex_state = 2},
  [2288] = {.lex_state = 322, .external_lex_state = 9},
  [2289] = {.lex_state = 281, .external_lex_state = 5},
  [2290] = {.lex_state = 102},
  [2291] = {.lex_state = 136, .external_lex_state = 13},
  [2292] = {.lex_state = 308, .external_lex_state = 4},
  [2293] = {.lex_state = 215},
  [2294] = {.lex_state = 112},
  [2295] = {.lex_state = 308, .external_lex_state = 21},
  [2296] = {.lex_state = 125},
  [2297] = {.lex_state = 308, .external_lex_state = 21},
  [2298] = {.lex_state = 112, .external_lex_state = 7},
  [2299] = {.lex_state = 78, .external_lex_state = 2},
  [2300] = {.lex_state = 78, .external_lex_state = 2},
  [2301] = {.lex_state = 78, .external_lex_state = 2},
  [2302] = {.lex_state = 308, .external_lex_state = 4},
  [2303] = {.lex_state = 255, .external_lex_state = 2},
  [2304] = {.lex_state = 144, .external_lex_state = 8},
  [2305] = {.lex_state = 85},
  [2306] = {.lex_state = 112},
  [2307] = {.lex_state = 324, .external_lex_state = 21},
  [2308] = {.lex_state = 125},
  [2309] = {.lex_state = 324, .external_lex_state = 21},
  [2310] = {.lex_state = 112, .external_lex_state = 7},
  [2311] = {.lex_state = 78, .external_lex_state = 2},
  [2312] = {.lex_state = 78, .external_lex_state = 2},
  [2313] = {.lex_state = 78, .external_lex_state = 2},
  [2314] = {.lex_state = 85},
  [2315] = {.lex_state = 324, .external_lex_state = 4},
  [2316] = {.lex_state = 324, .external_lex_state = 4},
  [2317] = {.lex_state = 112},
  [2318] = {.lex_state = 324, .external_lex_state = 6},
  [2319] = {.lex_state = 125},
  [2320] = {.lex_state = 324, .external_lex_state = 6},
  [2321] = {.lex_state = 112, .external_lex_state = 7},
  [2322] = {.lex_state = 78, .external_lex_state = 2},
  [2323] = {.lex_state = 78, .external_lex_state = 2},
  [2324] = {.lex_state = 78, .external_lex_state = 2},
  [2325] = {.lex_state = 324, .external_lex_state = 5},
  [2326] = {.lex_state = 324, .external_lex_state = 5},
  [2327] = {.lex_state = 326, .external_lex_state = 6},
  [2328] = {.lex_state = 326, .external_lex_state = 6},
  [2329] = {.lex_state = 326, .external_lex_state = 6},
  [2330] = {.lex_state = 102},
  [2331] = {.lex_state = 326, .external_lex_state = 6},
  [2332] = {.lex_state = 217},
  [2333] = {.lex_state = 326, .external_lex_state = 6},
  [2334] = {.lex_state = 125},
  [2335] = {.lex_state = 85},
  [2336] = {.lex_state = 223, .external_lex_state = 7},
  [2337] = {.lex_state = 225, .external_lex_state = 18},
  [2338] = {.lex_state = 225, .external_lex_state = 18},
  [2339] = {.lex_state = 85},
  [2340] = {.lex_state = 215, .external_lex_state = 2},
  [2341] = {.lex_state = 78},
  [2342] = {.lex_state = 85},
  [2343] = {.lex_state = 78},
  [2344] = {.lex_state = 289, .external_lex_state = 2},
  [2345] = {.lex_state = 78, .external_lex_state = 2},
  [2346] = {.lex_state = 78, .external_lex_state = 2},
  [2347] = {.lex_state = 102},
  [2348] = {.lex_state = 102},
  [2349] = {.lex_state = 334, .external_lex_state = 9},
  [2350] = {.lex_state = 330, .external_lex_state = 5},
  [2351] = {.lex_state = 237, .external_lex_state = 25},
  [2352] = {.lex_state = 326, .external_lex_state = 6},
  [2353] = {.lex_state = 326, .external_lex_state = 5},
  [2354] = {.lex_state = 326, .external_lex_state = 5},
  [2355] = {.lex_state = 330, .external_lex_state = 5},
  [2356] = {.lex_state = 332, .external_lex_state = 4},
  [2357] = {.lex_state = 326, .external_lex_state = 5},
  [2358] = {.lex_state = 326, .external_lex_state = 5},
  [2359] = {.lex_state = 326, .external_lex_state = 5},
  [2360] = {.lex_state = 144, .external_lex_state = 8},
  [2361] = {.lex_state = 291, .external_lex_state = 21},
  [2362] = {.lex_state = 291, .external_lex_state = 21},
  [2363] = {.lex_state = 291, .external_lex_state = 21},
  [2364] = {.lex_state = 102},
  [2365] = {.lex_state = 291, .external_lex_state = 21},
  [2366] = {.lex_state = 217},
  [2367] = {.lex_state = 291, .external_lex_state = 21},
  [2368] = {.lex_state = 125},
  [2369] = {.lex_state = 85},
  [2370] = {.lex_state = 223, .external_lex_state = 7},
  [2371] = {.lex_state = 225, .external_lex_state = 18},
  [2372] = {.lex_state = 225, .external_lex_state = 18},
  [2373] = {.lex_state = 85},
  [2374] = {.lex_state = 215, .external_lex_state = 2},
  [2375] = {.lex_state = 78},
  [2376] = {.lex_state = 85},
  [2377] = {.lex_state = 291, .external_lex_state = 4},
  [2378] = {.lex_state = 291, .external_lex_state = 4},
  [2379] = {.lex_state = 291, .external_lex_state = 4},
  [2380] = {.lex_state = 291, .external_lex_state = 6},
  [2381] = {.lex_state = 291, .external_lex_state = 6},
  [2382] = {.lex_state = 291, .external_lex_state = 6},
  [2383] = {.lex_state = 102},
  [2384] = {.lex_state = 291, .external_lex_state = 6},
  [2385] = {.lex_state = 217},
  [2386] = {.lex_state = 291, .external_lex_state = 6},
  [2387] = {.lex_state = 125},
  [2388] = {.lex_state = 85},
  [2389] = {.lex_state = 223, .external_lex_state = 7},
  [2390] = {.lex_state = 225, .external_lex_state = 18},
  [2391] = {.lex_state = 225, .external_lex_state = 18},
  [2392] = {.lex_state = 85},
  [2393] = {.lex_state = 215, .external_lex_state = 2},
  [2394] = {.lex_state = 78},
  [2395] = {.lex_state = 85},
  [2396] = {.lex_state = 291, .external_lex_state = 5},
  [2397] = {.lex_state = 291, .external_lex_state = 5},
  [2398] = {.lex_state = 291, .external_lex_state = 5},
  [2399] = {.lex_state = 301, .external_lex_state = 6},
  [2400] = {.lex_state = 102},
  [2401] = {.lex_state = 301, .external_lex_state = 6},
  [2402] = {.lex_state = 301, .external_lex_state = 6},
  [2403] = {.lex_state = 217},
  [2404] = {.lex_state = 260, .external_lex_state = 18},
  [2405] = {.lex_state = 85},
  [2406] = {.lex_state = 225, .external_lex_state = 18},
  [2407] = {.lex_state = 225, .external_lex_state = 18},
  [2408] = {.lex_state = 301, .external_lex_state = 6},
  [2409] = {.lex_state = 262, .external_lex_state = 30},
  [2410] = {.lex_state = 262, .external_lex_state = 18},
  [2411] = {.lex_state = 301, .external_lex_state = 6},
  [2412] = {.lex_state = 262, .external_lex_state = 30},
  [2413] = {.lex_state = 262, .external_lex_state = 18},
  [2414] = {.lex_state = 301, .external_lex_state = 6},
  [2415] = {.lex_state = 301, .external_lex_state = 6},
  [2416] = {.lex_state = 186, .external_lex_state = 5},
  [2417] = {.lex_state = 305},
  [2418] = {.lex_state = 102},
  [2419] = {.lex_state = 305, .external_lex_state = 5},
  [2420] = {.lex_state = 308, .external_lex_state = 4},
  [2421] = {.lex_state = 305, .external_lex_state = 5},
  [2422] = {.lex_state = 308, .external_lex_state = 4},
  [2423] = {.lex_state = 305, .external_lex_state = 6},
  [2424] = {.lex_state = 305, .external_lex_state = 6},
  [2425] = {.lex_state = 305, .external_lex_state = 5},
  [2426] = {.lex_state = 305, .external_lex_state = 6},
  [2427] = {.lex_state = 305, .external_lex_state = 5},
  [2428] = {.lex_state = 255, .external_lex_state = 2},
  [2429] = {.lex_state = 305, .external_lex_state = 5},
  [2430] = {.lex_state = 301, .external_lex_state = 5},
  [2431] = {.lex_state = 301, .external_lex_state = 6},
  [2432] = {.lex_state = 301, .external_lex_state = 5},
  [2433] = {.lex_state = 301, .external_lex_state = 5},
  [2434] = {.lex_state = 255, .external_lex_state = 2},
  [2435] = {.lex_state = 334, .external_lex_state = 9},
  [2436] = {.lex_state = 301, .external_lex_state = 5},
  [2437] = {.lex_state = 340, .external_lex_state = 10},
  [2438] = {.lex_state = 102},
  [2439] = {.lex_state = 358, .external_lex_state = 2},
  [2440] = {.lex_state = 340},
  [2441] = {.lex_state = 186, .external_lex_state = 5},
  [2442] = {.lex_state = 343},
  [2443] = {.lex_state = 102},
  [2444] = {.lex_state = 358, .external_lex_state = 2},
  [2445] = {.lex_state = 340},
  [2446] = {.lex_state = 340},
  [2447] = {.lex_state = 102},
  [2448] = {.lex_state = 149, .external_lex_state = 14},
  [2449] = {.lex_state = 149, .external_lex_state = 14},
  [2450] = {.lex_state = 92, .external_lex_state = 29},
  [2451] = {.lex_state = 92, .external_lex_state = 18},
  [2452] = {.lex_state = 92, .external_lex_state = 18},
  [2453] = {.lex_state = 262, .external_lex_state = 18},
  [2454] = {.lex_state = 149, .external_lex_state = 14},
  [2455] = {.lex_state = 262, .external_lex_state = 18},
  [2456] = {.lex_state = 262, .external_lex_state = 18},
  [2457] = {.lex_state = 262, .external_lex_state = 18},
  [2458] = {.lex_state = 149, .external_lex_state = 14},
  [2459] = {.lex_state = 262, .external_lex_state = 18},
  [2460] = {.lex_state = 186, .external_lex_state = 5},
  [2461] = {.lex_state = 343},
  [2462] = {.lex_state = 102},
  [2463] = {.lex_state = 184, .external_lex_state = 21},
  [2464] = {.lex_state = 182, .external_lex_state = 6},
  [2465] = {.lex_state = 207, .external_lex_state = 15},
  [2466] = {.lex_state = 207, .external_lex_state = 27},
  [2467] = {.lex_state = 102},
  [2468] = {.lex_state = 207, .external_lex_state = 27},
  [2469] = {.lex_state = 207, .external_lex_state = 27},
  [2470] = {.lex_state = 217},
  [2471] = {.lex_state = 260, .external_lex_state = 18},
  [2472] = {.lex_state = 85},
  [2473] = {.lex_state = 225, .external_lex_state = 18},
  [2474] = {.lex_state = 225, .external_lex_state = 18},
  [2475] = {.lex_state = 207, .external_lex_state = 27},
  [2476] = {.lex_state = 262, .external_lex_state = 30},
  [2477] = {.lex_state = 262, .external_lex_state = 18},
  [2478] = {.lex_state = 207, .external_lex_state = 27},
  [2479] = {.lex_state = 262, .external_lex_state = 30},
  [2480] = {.lex_state = 262, .external_lex_state = 18},
  [2481] = {.lex_state = 207, .external_lex_state = 27},
  [2482] = {.lex_state = 207, .external_lex_state = 27},
  [2483] = {.lex_state = 317},
  [2484] = {.lex_state = 153},
  [2485] = {.lex_state = 268},
  [2486] = {.lex_state = 241, .external_lex_state = 9},
  [2487] = {.lex_state = 102},
  [2488] = {.lex_state = 205, .external_lex_state = 16},
  [2489] = {.lex_state = 205, .external_lex_state = 16},
  [2490] = {.lex_state = 305},
  [2491] = {.lex_state = 305},
  [2492] = {.lex_state = 205, .external_lex_state = 16},
  [2493] = {.lex_state = 343},
  [2494] = {.lex_state = 102},
  [2495] = {.lex_state = 310},
  [2496] = {.lex_state = 205, .external_lex_state = 16},
  [2497] = {.lex_state = 343},
  [2498] = {.lex_state = 102},
  [2499] = {.lex_state = 310},
  [2500] = {.lex_state = 205, .external_lex_state = 16},
  [2501] = {.lex_state = 199, .external_lex_state = 15},
  [2502] = {.lex_state = 215},
  [2503] = {.lex_state = 360, .external_lex_state = 15},
  [2504] = {.lex_state = 199, .external_lex_state = 27},
  [2505] = {.lex_state = 199, .external_lex_state = 27},
  [2506] = {.lex_state = 92, .external_lex_state = 29},
  [2507] = {.lex_state = 92, .external_lex_state = 18},
  [2508] = {.lex_state = 92, .external_lex_state = 18},
  [2509] = {.lex_state = 260, .external_lex_state = 18},
  [2510] = {.lex_state = 199, .external_lex_state = 27},
  [2511] = {.lex_state = 262, .external_lex_state = 30},
  [2512] = {.lex_state = 262, .external_lex_state = 18},
  [2513] = {.lex_state = 262, .external_lex_state = 30},
  [2514] = {.lex_state = 262, .external_lex_state = 18},
  [2515] = {.lex_state = 262, .external_lex_state = 18},
  [2516] = {.lex_state = 199, .external_lex_state = 27},
  [2517] = {.lex_state = 262, .external_lex_state = 18},
  [2518] = {.lex_state = 262, .external_lex_state = 18},
  [2519] = {.lex_state = 360, .external_lex_state = 16},
  [2520] = {.lex_state = 199, .external_lex_state = 17},
  [2521] = {.lex_state = 199, .external_lex_state = 17},
  [2522] = {.lex_state = 92, .external_lex_state = 29},
  [2523] = {.lex_state = 92, .external_lex_state = 18},
  [2524] = {.lex_state = 92, .external_lex_state = 18},
  [2525] = {.lex_state = 260, .external_lex_state = 18},
  [2526] = {.lex_state = 199, .external_lex_state = 17},
  [2527] = {.lex_state = 262, .external_lex_state = 30},
  [2528] = {.lex_state = 262, .external_lex_state = 18},
  [2529] = {.lex_state = 262, .external_lex_state = 30},
  [2530] = {.lex_state = 262, .external_lex_state = 18},
  [2531] = {.lex_state = 262, .external_lex_state = 18},
  [2532] = {.lex_state = 199, .external_lex_state = 17},
  [2533] = {.lex_state = 262, .external_lex_state = 18},
  [2534] = {.lex_state = 262, .external_lex_state = 18},
  [2535] = {.lex_state = 201, .external_lex_state = 17},
  [2536] = {.lex_state = 201, .external_lex_state = 17},
  [2537] = {.lex_state = 92, .external_lex_state = 29},
  [2538] = {.lex_state = 92, .external_lex_state = 18},
  [2539] = {.lex_state = 92, .external_lex_state = 18},
  [2540] = {.lex_state = 262, .external_lex_state = 18},
  [2541] = {.lex_state = 201, .external_lex_state = 17},
  [2542] = {.lex_state = 262, .external_lex_state = 18},
  [2543] = {.lex_state = 262, .external_lex_state = 18},
  [2544] = {.lex_state = 262, .external_lex_state = 18},
  [2545] = {.lex_state = 201, .external_lex_state = 17},
  [2546] = {.lex_state = 262, .external_lex_state = 18},
  [2547] = {.lex_state = 102},
  [2548] = {.lex_state = 205, .external_lex_state = 17},
  [2549] = {.lex_state = 102, .external_lex_state = 2},
  [2550] = {.lex_state = 209, .external_lex_state = 19},
  [2551] = {.lex_state = 209, .external_lex_state = 19},
  [2552] = {.lex_state = 92, .external_lex_state = 29},
  [2553] = {.lex_state = 92, .external_lex_state = 18},
  [2554] = {.lex_state = 92, .external_lex_state = 18},
  [2555] = {.lex_state = 262, .external_lex_state = 18},
  [2556] = {.lex_state = 209, .external_lex_state = 19},
  [2557] = {.lex_state = 262, .external_lex_state = 18},
  [2558] = {.lex_state = 262, .external_lex_state = 18},
  [2559] = {.lex_state = 262, .external_lex_state = 18},
  [2560] = {.lex_state = 209, .external_lex_state = 19},
  [2561] = {.lex_state = 262, .external_lex_state = 18},
  [2562] = {.lex_state = 178, .external_lex_state = 4},
  [2563] = {.lex_state = 178, .external_lex_state = 21},
  [2564] = {.lex_state = 178, .external_lex_state = 21},
  [2565] = {.lex_state = 92, .external_lex_state = 29},
  [2566] = {.lex_state = 92, .external_lex_state = 18},
  [2567] = {.lex_state = 92, .external_lex_state = 18},
  [2568] = {.lex_state = 262, .external_lex_state = 18},
  [2569] = {.lex_state = 178, .external_lex_state = 21},
  [2570] = {.lex_state = 262, .external_lex_state = 18},
  [2571] = {.lex_state = 262, .external_lex_state = 18},
  [2572] = {.lex_state = 262, .external_lex_state = 18},
  [2573] = {.lex_state = 178, .external_lex_state = 21},
  [2574] = {.lex_state = 262, .external_lex_state = 18},
  [2575] = {.lex_state = 178, .external_lex_state = 6},
  [2576] = {.lex_state = 178, .external_lex_state = 6},
  [2577] = {.lex_state = 92, .external_lex_state = 29},
  [2578] = {.lex_state = 92, .external_lex_state = 18},
  [2579] = {.lex_state = 92, .external_lex_state = 18},
  [2580] = {.lex_state = 262, .external_lex_state = 18},
  [2581] = {.lex_state = 178, .external_lex_state = 6},
  [2582] = {.lex_state = 262, .external_lex_state = 18},
  [2583] = {.lex_state = 262, .external_lex_state = 18},
  [2584] = {.lex_state = 262, .external_lex_state = 18},
  [2585] = {.lex_state = 178, .external_lex_state = 6},
  [2586] = {.lex_state = 262, .external_lex_state = 18},
  [2587] = {.lex_state = 215, .external_lex_state = 22},
  [2588] = {.lex_state = 215, .external_lex_state = 22},
  [2589] = {.lex_state = 92, .external_lex_state = 29},
  [2590] = {.lex_state = 92, .external_lex_state = 18},
  [2591] = {.lex_state = 92, .external_lex_state = 18},
  [2592] = {.lex_state = 262, .external_lex_state = 18},
  [2593] = {.lex_state = 215, .external_lex_state = 22},
  [2594] = {.lex_state = 262, .external_lex_state = 18},
  [2595] = {.lex_state = 262, .external_lex_state = 18},
  [2596] = {.lex_state = 262, .external_lex_state = 18},
  [2597] = {.lex_state = 215, .external_lex_state = 22},
  [2598] = {.lex_state = 262, .external_lex_state = 18},
  [2599] = {.lex_state = 125, .external_lex_state = 10},
  [2600] = {.lex_state = 125, .external_lex_state = 10},
  [2601] = {.lex_state = 92, .external_lex_state = 29},
  [2602] = {.lex_state = 92, .external_lex_state = 18},
  [2603] = {.lex_state = 92, .external_lex_state = 18},
  [2604] = {.lex_state = 262, .external_lex_state = 18},
  [2605] = {.lex_state = 125, .external_lex_state = 10},
  [2606] = {.lex_state = 262, .external_lex_state = 18},
  [2607] = {.lex_state = 262, .external_lex_state = 18},
  [2608] = {.lex_state = 262, .external_lex_state = 18},
  [2609] = {.lex_state = 125, .external_lex_state = 10},
  [2610] = {.lex_state = 262, .external_lex_state = 18},
  [2611] = {.lex_state = 225, .external_lex_state = 29},
  [2612] = {.lex_state = 225, .external_lex_state = 18},
  [2613] = {.lex_state = 225, .external_lex_state = 29},
  [2614] = {.lex_state = 225, .external_lex_state = 18},
  [2615] = {.lex_state = 92, .external_lex_state = 29},
  [2616] = {.lex_state = 102},
  [2617] = {.lex_state = 92, .external_lex_state = 29},
  [2618] = {.lex_state = 92, .external_lex_state = 29},
  [2619] = {.lex_state = 217},
  [2620] = {.lex_state = 260, .external_lex_state = 18},
  [2621] = {.lex_state = 85},
  [2622] = {.lex_state = 225, .external_lex_state = 18},
  [2623] = {.lex_state = 225, .external_lex_state = 18},
  [2624] = {.lex_state = 92, .external_lex_state = 29},
  [2625] = {.lex_state = 262, .external_lex_state = 30},
  [2626] = {.lex_state = 262, .external_lex_state = 18},
  [2627] = {.lex_state = 92, .external_lex_state = 29},
  [2628] = {.lex_state = 262, .external_lex_state = 30},
  [2629] = {.lex_state = 262, .external_lex_state = 18},
  [2630] = {.lex_state = 92, .external_lex_state = 29},
  [2631] = {.lex_state = 92, .external_lex_state = 29},
  [2632] = {.lex_state = 142, .external_lex_state = 6},
  [2633] = {.lex_state = 142, .external_lex_state = 6},
  [2634] = {.lex_state = 142, .external_lex_state = 6},
  [2635] = {.lex_state = 262, .external_lex_state = 18},
  [2636] = {.lex_state = 262, .external_lex_state = 18},
  [2637] = {.lex_state = 362, .external_lex_state = 18},
  [2638] = {.lex_state = 262, .external_lex_state = 29},
  [2639] = {.lex_state = 262, .external_lex_state = 29},
  [2640] = {.lex_state = 92, .external_lex_state = 29},
  [2641] = {.lex_state = 92, .external_lex_state = 18},
  [2642] = {.lex_state = 92, .external_lex_state = 18},
  [2643] = {.lex_state = 260, .external_lex_state = 18},
  [2644] = {.lex_state = 262, .external_lex_state = 29},
  [2645] = {.lex_state = 262, .external_lex_state = 30},
  [2646] = {.lex_state = 262, .external_lex_state = 18},
  [2647] = {.lex_state = 262, .external_lex_state = 30},
  [2648] = {.lex_state = 262, .external_lex_state = 18},
  [2649] = {.lex_state = 262, .external_lex_state = 18},
  [2650] = {.lex_state = 262, .external_lex_state = 29},
  [2651] = {.lex_state = 262, .external_lex_state = 18},
  [2652] = {.lex_state = 262, .external_lex_state = 18},
  [2653] = {.lex_state = 142, .external_lex_state = 6},
  [2654] = {.lex_state = 140, .external_lex_state = 21},
  [2655] = {.lex_state = 229, .external_lex_state = 6},
  [2656] = {.lex_state = 96, .external_lex_state = 23},
  [2657] = {.lex_state = 92, .external_lex_state = 29},
  [2658] = {.lex_state = 92, .external_lex_state = 18},
  [2659] = {.lex_state = 92, .external_lex_state = 18},
  [2660] = {.lex_state = 260, .external_lex_state = 18},
  [2661] = {.lex_state = 96, .external_lex_state = 23},
  [2662] = {.lex_state = 262, .external_lex_state = 30},
  [2663] = {.lex_state = 262, .external_lex_state = 18},
  [2664] = {.lex_state = 262, .external_lex_state = 30},
  [2665] = {.lex_state = 262, .external_lex_state = 18},
  [2666] = {.lex_state = 262, .external_lex_state = 18},
  [2667] = {.lex_state = 96, .external_lex_state = 23},
  [2668] = {.lex_state = 262, .external_lex_state = 18},
  [2669] = {.lex_state = 262, .external_lex_state = 18},
  [2670] = {.lex_state = 364, .external_lex_state = 5},
  [2671] = {.lex_state = 136, .external_lex_state = 6},
  [2672] = {.lex_state = 264, .external_lex_state = 5},
  [2673] = {.lex_state = 136, .external_lex_state = 6},
  [2674] = {.lex_state = 264, .external_lex_state = 5},
  [2675] = {.lex_state = 352},
  [2676] = {.lex_state = 215, .external_lex_state = 10},
  [2677] = {.lex_state = 215, .external_lex_state = 10},
  [2678] = {.lex_state = 92, .external_lex_state = 29},
  [2679] = {.lex_state = 92, .external_lex_state = 18},
  [2680] = {.lex_state = 92, .external_lex_state = 18},
  [2681] = {.lex_state = 260, .external_lex_state = 18},
  [2682] = {.lex_state = 215, .external_lex_state = 10},
  [2683] = {.lex_state = 262, .external_lex_state = 30},
  [2684] = {.lex_state = 262, .external_lex_state = 18},
  [2685] = {.lex_state = 262, .external_lex_state = 30},
  [2686] = {.lex_state = 262, .external_lex_state = 18},
  [2687] = {.lex_state = 262, .external_lex_state = 18},
  [2688] = {.lex_state = 215, .external_lex_state = 10},
  [2689] = {.lex_state = 262, .external_lex_state = 18},
  [2690] = {.lex_state = 262, .external_lex_state = 18},
  [2691] = {.lex_state = 184, .external_lex_state = 21},
  [2692] = {.lex_state = 184, .external_lex_state = 21},
  [2693] = {.lex_state = 92, .external_lex_state = 29},
  [2694] = {.lex_state = 92, .external_lex_state = 18},
  [2695] = {.lex_state = 92, .external_lex_state = 18},
  [2696] = {.lex_state = 262, .external_lex_state = 18},
  [2697] = {.lex_state = 184, .external_lex_state = 21},
  [2698] = {.lex_state = 262, .external_lex_state = 18},
  [2699] = {.lex_state = 262, .external_lex_state = 18},
  [2700] = {.lex_state = 262, .external_lex_state = 18},
  [2701] = {.lex_state = 184, .external_lex_state = 21},
  [2702] = {.lex_state = 262, .external_lex_state = 18},
  [2703] = {.lex_state = 186, .external_lex_state = 5},
  [2704] = {.lex_state = 317},
  [2705] = {.lex_state = 317},
  [2706] = {.lex_state = 241, .external_lex_state = 14},
  [2707] = {.lex_state = 241, .external_lex_state = 14},
  [2708] = {.lex_state = 92, .external_lex_state = 29},
  [2709] = {.lex_state = 92, .external_lex_state = 18},
  [2710] = {.lex_state = 92, .external_lex_state = 18},
  [2711] = {.lex_state = 262, .external_lex_state = 18},
  [2712] = {.lex_state = 241, .external_lex_state = 14},
  [2713] = {.lex_state = 262, .external_lex_state = 18},
  [2714] = {.lex_state = 262, .external_lex_state = 18},
  [2715] = {.lex_state = 262, .external_lex_state = 18},
  [2716] = {.lex_state = 241, .external_lex_state = 14},
  [2717] = {.lex_state = 262, .external_lex_state = 18},
  [2718] = {.lex_state = 153},
  [2719] = {.lex_state = 366, .external_lex_state = 9},
  [2720] = {.lex_state = 270, .external_lex_state = 14},
  [2721] = {.lex_state = 270, .external_lex_state = 14},
  [2722] = {.lex_state = 92, .external_lex_state = 29},
  [2723] = {.lex_state = 92, .external_lex_state = 18},
  [2724] = {.lex_state = 92, .external_lex_state = 18},
  [2725] = {.lex_state = 260, .external_lex_state = 18},
  [2726] = {.lex_state = 270, .external_lex_state = 14},
  [2727] = {.lex_state = 262, .external_lex_state = 30},
  [2728] = {.lex_state = 262, .external_lex_state = 18},
  [2729] = {.lex_state = 262, .external_lex_state = 30},
  [2730] = {.lex_state = 262, .external_lex_state = 18},
  [2731] = {.lex_state = 262, .external_lex_state = 18},
  [2732] = {.lex_state = 270, .external_lex_state = 14},
  [2733] = {.lex_state = 262, .external_lex_state = 18},
  [2734] = {.lex_state = 262, .external_lex_state = 18},
  [2735] = {.lex_state = 272, .external_lex_state = 10},
  [2736] = {.lex_state = 272, .external_lex_state = 10},
  [2737] = {.lex_state = 92, .external_lex_state = 29},
  [2738] = {.lex_state = 92, .external_lex_state = 18},
  [2739] = {.lex_state = 92, .external_lex_state = 18},
  [2740] = {.lex_state = 262, .external_lex_state = 18},
  [2741] = {.lex_state = 272, .external_lex_state = 10},
  [2742] = {.lex_state = 262, .external_lex_state = 18},
  [2743] = {.lex_state = 262, .external_lex_state = 18},
  [2744] = {.lex_state = 262, .external_lex_state = 18},
  [2745] = {.lex_state = 272, .external_lex_state = 10},
  [2746] = {.lex_state = 262, .external_lex_state = 18},
  [2747] = {.lex_state = 246, .external_lex_state = 10},
  [2748] = {.lex_state = 246, .external_lex_state = 10},
  [2749] = {.lex_state = 246, .external_lex_state = 10},
  [2750] = {.lex_state = 262, .external_lex_state = 18},
  [2751] = {.lex_state = 262, .external_lex_state = 18},
  [2752] = {.lex_state = 246, .external_lex_state = 10},
  [2753] = {.lex_state = 350, .external_lex_state = 11},
  [2754] = {.lex_state = 140, .external_lex_state = 26},
  [2755] = {.lex_state = 140, .external_lex_state = 26},
  [2756] = {.lex_state = 92, .external_lex_state = 29},
  [2757] = {.lex_state = 92, .external_lex_state = 18},
  [2758] = {.lex_state = 92, .external_lex_state = 18},
  [2759] = {.lex_state = 260, .external_lex_state = 18},
  [2760] = {.lex_state = 140, .external_lex_state = 26},
  [2761] = {.lex_state = 262, .external_lex_state = 30},
  [2762] = {.lex_state = 262, .external_lex_state = 18},
  [2763] = {.lex_state = 262, .external_lex_state = 30},
  [2764] = {.lex_state = 262, .external_lex_state = 18},
  [2765] = {.lex_state = 262, .external_lex_state = 18},
  [2766] = {.lex_state = 140, .external_lex_state = 26},
  [2767] = {.lex_state = 262, .external_lex_state = 18},
  [2768] = {.lex_state = 262, .external_lex_state = 18},
  [2769] = {.lex_state = 317},
  [2770] = {.lex_state = 136, .external_lex_state = 12},
  [2771] = {.lex_state = 317},
  [2772] = {.lex_state = 153},
  [2773] = {.lex_state = 268},
  [2774] = {.lex_state = 136, .external_lex_state = 12},
  [2775] = {.lex_state = 136, .external_lex_state = 12},
  [2776] = {.lex_state = 305},
  [2777] = {.lex_state = 136, .external_lex_state = 12},
  [2778] = {.lex_state = 343},
  [2779] = {.lex_state = 102},
  [2780] = {.lex_state = 136, .external_lex_state = 12},
  [2781] = {.lex_state = 343},
  [2782] = {.lex_state = 102},
  [2783] = {.lex_state = 108, .external_lex_state = 11},
  [2784] = {.lex_state = 108, .external_lex_state = 26},
  [2785] = {.lex_state = 108, .external_lex_state = 26},
  [2786] = {.lex_state = 92, .external_lex_state = 29},
  [2787] = {.lex_state = 92, .external_lex_state = 18},
  [2788] = {.lex_state = 92, .external_lex_state = 18},
  [2789] = {.lex_state = 262, .external_lex_state = 18},
  [2790] = {.lex_state = 108, .external_lex_state = 26},
  [2791] = {.lex_state = 262, .external_lex_state = 18},
  [2792] = {.lex_state = 262, .external_lex_state = 18},
  [2793] = {.lex_state = 262, .external_lex_state = 18},
  [2794] = {.lex_state = 108, .external_lex_state = 26},
  [2795] = {.lex_state = 262, .external_lex_state = 18},
  [2796] = {.lex_state = 108, .external_lex_state = 13},
  [2797] = {.lex_state = 108, .external_lex_state = 13},
  [2798] = {.lex_state = 92, .external_lex_state = 29},
  [2799] = {.lex_state = 92, .external_lex_state = 18},
  [2800] = {.lex_state = 92, .external_lex_state = 18},
  [2801] = {.lex_state = 262, .external_lex_state = 18},
  [2802] = {.lex_state = 108, .external_lex_state = 13},
  [2803] = {.lex_state = 262, .external_lex_state = 18},
  [2804] = {.lex_state = 262, .external_lex_state = 18},
  [2805] = {.lex_state = 262, .external_lex_state = 18},
  [2806] = {.lex_state = 108, .external_lex_state = 13},
  [2807] = {.lex_state = 262, .external_lex_state = 18},
  [2808] = {.lex_state = 122, .external_lex_state = 13},
  [2809] = {.lex_state = 122, .external_lex_state = 13},
  [2810] = {.lex_state = 122, .external_lex_state = 13},
  [2811] = {.lex_state = 262, .external_lex_state = 18},
  [2812] = {.lex_state = 262, .external_lex_state = 18},
  [2813] = {.lex_state = 122, .external_lex_state = 13},
  [2814] = {.lex_state = 287, .external_lex_state = 4},
  [2815] = {.lex_state = 215},
  [2816] = {.lex_state = 287, .external_lex_state = 21},
  [2817] = {.lex_state = 287, .external_lex_state = 21},
  [2818] = {.lex_state = 287, .external_lex_state = 21},
  [2819] = {.lex_state = 102},
  [2820] = {.lex_state = 287, .external_lex_state = 21},
  [2821] = {.lex_state = 217},
  [2822] = {.lex_state = 287, .external_lex_state = 21},
  [2823] = {.lex_state = 125},
  [2824] = {.lex_state = 85},
  [2825] = {.lex_state = 223, .external_lex_state = 7},
  [2826] = {.lex_state = 225, .external_lex_state = 18},
  [2827] = {.lex_state = 225, .external_lex_state = 18},
  [2828] = {.lex_state = 85},
  [2829] = {.lex_state = 215, .external_lex_state = 2},
  [2830] = {.lex_state = 78},
  [2831] = {.lex_state = 85},
  [2832] = {.lex_state = 287, .external_lex_state = 4},
  [2833] = {.lex_state = 287, .external_lex_state = 4},
  [2834] = {.lex_state = 275, .external_lex_state = 4},
  [2835] = {.lex_state = 215},
  [2836] = {.lex_state = 275, .external_lex_state = 21},
  [2837] = {.lex_state = 275, .external_lex_state = 4},
  [2838] = {.lex_state = 275, .external_lex_state = 21},
  [2839] = {.lex_state = 102},
  [2840] = {.lex_state = 275, .external_lex_state = 21},
  [2841] = {.lex_state = 275, .external_lex_state = 21},
  [2842] = {.lex_state = 217},
  [2843] = {.lex_state = 260, .external_lex_state = 18},
  [2844] = {.lex_state = 85},
  [2845] = {.lex_state = 225, .external_lex_state = 18},
  [2846] = {.lex_state = 225, .external_lex_state = 18},
  [2847] = {.lex_state = 275, .external_lex_state = 21},
  [2848] = {.lex_state = 262, .external_lex_state = 30},
  [2849] = {.lex_state = 262, .external_lex_state = 18},
  [2850] = {.lex_state = 275, .external_lex_state = 21},
  [2851] = {.lex_state = 262, .external_lex_state = 30},
  [2852] = {.lex_state = 262, .external_lex_state = 18},
  [2853] = {.lex_state = 275, .external_lex_state = 21},
  [2854] = {.lex_state = 275, .external_lex_state = 21},
  [2855] = {.lex_state = 275, .external_lex_state = 6},
  [2856] = {.lex_state = 102},
  [2857] = {.lex_state = 275, .external_lex_state = 6},
  [2858] = {.lex_state = 275, .external_lex_state = 6},
  [2859] = {.lex_state = 217},
  [2860] = {.lex_state = 260, .external_lex_state = 18},
  [2861] = {.lex_state = 85},
  [2862] = {.lex_state = 225, .external_lex_state = 18},
  [2863] = {.lex_state = 225, .external_lex_state = 18},
  [2864] = {.lex_state = 275, .external_lex_state = 6},
  [2865] = {.lex_state = 262, .external_lex_state = 30},
  [2866] = {.lex_state = 262, .external_lex_state = 18},
  [2867] = {.lex_state = 275, .external_lex_state = 6},
  [2868] = {.lex_state = 262, .external_lex_state = 30},
  [2869] = {.lex_state = 262, .external_lex_state = 18},
  [2870] = {.lex_state = 275, .external_lex_state = 6},
  [2871] = {.lex_state = 275, .external_lex_state = 6},
  [2872] = {.lex_state = 368, .external_lex_state = 5},
  [2873] = {.lex_state = 281, .external_lex_state = 6},
  [2874] = {.lex_state = 281, .external_lex_state = 6},
  [2875] = {.lex_state = 92, .external_lex_state = 29},
  [2876] = {.lex_state = 92, .external_lex_state = 18},
  [2877] = {.lex_state = 92, .external_lex_state = 18},
  [2878] = {.lex_state = 260, .external_lex_state = 18},
  [2879] = {.lex_state = 281, .external_lex_state = 6},
  [2880] = {.lex_state = 262, .external_lex_state = 30},
  [2881] = {.lex_state = 262, .external_lex_state = 18},
  [2882] = {.lex_state = 262, .external_lex_state = 30},
  [2883] = {.lex_state = 262, .external_lex_state = 18},
  [2884] = {.lex_state = 262, .external_lex_state = 18},
  [2885] = {.lex_state = 281, .external_lex_state = 6},
  [2886] = {.lex_state = 262, .external_lex_state = 18},
  [2887] = {.lex_state = 262, .external_lex_state = 18},
  [2888] = {.lex_state = 285, .external_lex_state = 6},
  [2889] = {.lex_state = 285, .external_lex_state = 5},
  [2890] = {.lex_state = 370, .external_lex_state = 6},
  [2891] = {.lex_state = 370, .external_lex_state = 6},
  [2892] = {.lex_state = 370, .external_lex_state = 6},
  [2893] = {.lex_state = 102},
  [2894] = {.lex_state = 285, .external_lex_state = 6},
  [2895] = {.lex_state = 217},
  [2896] = {.lex_state = 370, .external_lex_state = 6},
  [2897] = {.lex_state = 125},
  [2898] = {.lex_state = 85},
  [2899] = {.lex_state = 223, .external_lex_state = 7},
  [2900] = {.lex_state = 225, .external_lex_state = 18},
  [2901] = {.lex_state = 225, .external_lex_state = 18},
  [2902] = {.lex_state = 85},
  [2903] = {.lex_state = 215, .external_lex_state = 2},
  [2904] = {.lex_state = 78},
  [2905] = {.lex_state = 85},
  [2906] = {.lex_state = 370, .external_lex_state = 5},
  [2907] = {.lex_state = 285, .external_lex_state = 5},
  [2908] = {.lex_state = 249, .external_lex_state = 2},
  [2909] = {.lex_state = 364, .external_lex_state = 12},
  [2910] = {.lex_state = 308, .external_lex_state = 4},
  [2911] = {.lex_state = 215},
  [2912] = {.lex_state = 308, .external_lex_state = 21},
  [2913] = {.lex_state = 308, .external_lex_state = 21},
  [2914] = {.lex_state = 308, .external_lex_state = 21},
  [2915] = {.lex_state = 102},
  [2916] = {.lex_state = 308, .external_lex_state = 21},
  [2917] = {.lex_state = 217},
  [2918] = {.lex_state = 308, .external_lex_state = 21},
  [2919] = {.lex_state = 125},
  [2920] = {.lex_state = 85},
  [2921] = {.lex_state = 223, .external_lex_state = 7},
  [2922] = {.lex_state = 225, .external_lex_state = 18},
  [2923] = {.lex_state = 225, .external_lex_state = 18},
  [2924] = {.lex_state = 85},
  [2925] = {.lex_state = 215, .external_lex_state = 2},
  [2926] = {.lex_state = 78},
  [2927] = {.lex_state = 85},
  [2928] = {.lex_state = 308, .external_lex_state = 4},
  [2929] = {.lex_state = 308, .external_lex_state = 4},
  [2930] = {.lex_state = 305},
  [2931] = {.lex_state = 332, .external_lex_state = 4},
  [2932] = {.lex_state = 215},
  [2933] = {.lex_state = 112},
  [2934] = {.lex_state = 332, .external_lex_state = 21},
  [2935] = {.lex_state = 125},
  [2936] = {.lex_state = 332, .external_lex_state = 21},
  [2937] = {.lex_state = 112, .external_lex_state = 7},
  [2938] = {.lex_state = 78, .external_lex_state = 2},
  [2939] = {.lex_state = 78, .external_lex_state = 2},
  [2940] = {.lex_state = 78, .external_lex_state = 2},
  [2941] = {.lex_state = 332, .external_lex_state = 4},
  [2942] = {.lex_state = 144, .external_lex_state = 8},
  [2943] = {.lex_state = 324, .external_lex_state = 21},
  [2944] = {.lex_state = 324, .external_lex_state = 21},
  [2945] = {.lex_state = 324, .external_lex_state = 21},
  [2946] = {.lex_state = 102},
  [2947] = {.lex_state = 324, .external_lex_state = 21},
  [2948] = {.lex_state = 217},
  [2949] = {.lex_state = 324, .external_lex_state = 21},
  [2950] = {.lex_state = 125},
  [2951] = {.lex_state = 85},
  [2952] = {.lex_state = 223, .external_lex_state = 7},
  [2953] = {.lex_state = 225, .external_lex_state = 18},
  [2954] = {.lex_state = 225, .external_lex_state = 18},
  [2955] = {.lex_state = 85},
  [2956] = {.lex_state = 215, .external_lex_state = 2},
  [2957] = {.lex_state = 78},
  [2958] = {.lex_state = 85},
  [2959] = {.lex_state = 324, .external_lex_state = 4},
  [2960] = {.lex_state = 324, .external_lex_state = 4},
  [2961] = {.lex_state = 324, .external_lex_state = 4},
  [2962] = {.lex_state = 324, .external_lex_state = 6},
  [2963] = {.lex_state = 324, .external_lex_state = 6},
  [2964] = {.lex_state = 324, .external_lex_state = 6},
  [2965] = {.lex_state = 102},
  [2966] = {.lex_state = 324, .external_lex_state = 6},
  [2967] = {.lex_state = 217},
  [2968] = {.lex_state = 324, .external_lex_state = 6},
  [2969] = {.lex_state = 125},
  [2970] = {.lex_state = 85},
  [2971] = {.lex_state = 223, .external_lex_state = 7},
  [2972] = {.lex_state = 225, .external_lex_state = 18},
  [2973] = {.lex_state = 225, .external_lex_state = 18},
  [2974] = {.lex_state = 85},
  [2975] = {.lex_state = 215, .external_lex_state = 2},
  [2976] = {.lex_state = 78},
  [2977] = {.lex_state = 85},
  [2978] = {.lex_state = 324, .external_lex_state = 5},
  [2979] = {.lex_state = 324, .external_lex_state = 5},
  [2980] = {.lex_state = 324, .external_lex_state = 5},
  [2981] = {.lex_state = 326, .external_lex_state = 6},
  [2982] = {.lex_state = 102},
  [2983] = {.lex_state = 326, .external_lex_state = 6},
  [2984] = {.lex_state = 326, .external_lex_state = 6},
  [2985] = {.lex_state = 217},
  [2986] = {.lex_state = 260, .external_lex_state = 18},
  [2987] = {.lex_state = 85},
  [2988] = {.lex_state = 225, .external_lex_state = 18},
  [2989] = {.lex_state = 225, .external_lex_state = 18},
  [2990] = {.lex_state = 326, .external_lex_state = 6},
  [2991] = {.lex_state = 262, .external_lex_state = 30},
  [2992] = {.lex_state = 262, .external_lex_state = 18},
  [2993] = {.lex_state = 326, .external_lex_state = 6},
  [2994] = {.lex_state = 262, .external_lex_state = 30},
  [2995] = {.lex_state = 262, .external_lex_state = 18},
  [2996] = {.lex_state = 326, .external_lex_state = 6},
  [2997] = {.lex_state = 326, .external_lex_state = 6},
  [2998] = {.lex_state = 102},
  [2999] = {.lex_state = 330, .external_lex_state = 5},
  [3000] = {.lex_state = 332, .external_lex_state = 4},
  [3001] = {.lex_state = 330, .external_lex_state = 5},
  [3002] = {.lex_state = 332, .external_lex_state = 4},
  [3003] = {.lex_state = 330, .external_lex_state = 6},
  [3004] = {.lex_state = 330, .external_lex_state = 6},
  [3005] = {.lex_state = 330, .external_lex_state = 5},
  [3006] = {.lex_state = 330, .external_lex_state = 6},
  [3007] = {.lex_state = 330, .external_lex_state = 5},
  [3008] = {.lex_state = 289, .external_lex_state = 2},
  [3009] = {.lex_state = 330, .external_lex_state = 5},
  [3010] = {.lex_state = 326, .external_lex_state = 5},
  [3011] = {.lex_state = 326, .external_lex_state = 6},
  [3012] = {.lex_state = 326, .external_lex_state = 5},
  [3013] = {.lex_state = 326, .external_lex_state = 5},
  [3014] = {.lex_state = 289, .external_lex_state = 2},
  [3015] = {.lex_state = 334, .external_lex_state = 9},
  [3016] = {.lex_state = 326, .external_lex_state = 5},
  [3017] = {.lex_state = 291, .external_lex_state = 4},
  [3018] = {.lex_state = 215},
  [3019] = {.lex_state = 291, .external_lex_state = 21},
  [3020] = {.lex_state = 291, .external_lex_state = 4},
  [3021] = {.lex_state = 291, .external_lex_state = 21},
  [3022] = {.lex_state = 102},
  [3023] = {.lex_state = 291, .external_lex_state = 21},
  [3024] = {.lex_state = 291, .external_lex_state = 21},
  [3025] = {.lex_state = 217},
  [3026] = {.lex_state = 260, .external_lex_state = 18},
  [3027] = {.lex_state = 85},
  [3028] = {.lex_state = 225, .external_lex_state = 18},
  [3029] = {.lex_state = 225, .external_lex_state = 18},
  [3030] = {.lex_state = 291, .external_lex_state = 21},
  [3031] = {.lex_state = 262, .external_lex_state = 30},
  [3032] = {.lex_state = 262, .external_lex_state = 18},
  [3033] = {.lex_state = 291, .external_lex_state = 21},
  [3034] = {.lex_state = 262, .external_lex_state = 30},
  [3035] = {.lex_state = 262, .external_lex_state = 18},
  [3036] = {.lex_state = 291, .external_lex_state = 21},
  [3037] = {.lex_state = 291, .external_lex_state = 21},
  [3038] = {.lex_state = 291, .external_lex_state = 6},
  [3039] = {.lex_state = 102},
  [3040] = {.lex_state = 291, .external_lex_state = 6},
  [3041] = {.lex_state = 291, .external_lex_state = 6},
  [3042] = {.lex_state = 217},
  [3043] = {.lex_state = 260, .external_lex_state = 18},
  [3044] = {.lex_state = 85},
  [3045] = {.lex_state = 225, .external_lex_state = 18},
  [3046] = {.lex_state = 225, .external_lex_state = 18},
  [3047] = {.lex_state = 291, .external_lex_state = 6},
  [3048] = {.lex_state = 262, .external_lex_state = 30},
  [3049] = {.lex_state = 262, .external_lex_state = 18},
  [3050] = {.lex_state = 291, .external_lex_state = 6},
  [3051] = {.lex_state = 262, .external_lex_state = 30},
  [3052] = {.lex_state = 262, .external_lex_state = 18},
  [3053] = {.lex_state = 291, .external_lex_state = 6},
  [3054] = {.lex_state = 291, .external_lex_state = 6},
  [3055] = {.lex_state = 372, .external_lex_state = 5},
  [3056] = {.lex_state = 301, .external_lex_state = 6},
  [3057] = {.lex_state = 301, .external_lex_state = 6},
  [3058] = {.lex_state = 92, .external_lex_state = 29},
  [3059] = {.lex_state = 92, .external_lex_state = 18},
  [3060] = {.lex_state = 92, .external_lex_state = 18},
  [3061] = {.lex_state = 260, .external_lex_state = 18},
  [3062] = {.lex_state = 301, .external_lex_state = 6},
  [3063] = {.lex_state = 262, .external_lex_state = 30},
  [3064] = {.lex_state = 262, .external_lex_state = 18},
  [3065] = {.lex_state = 262, .external_lex_state = 30},
  [3066] = {.lex_state = 262, .external_lex_state = 18},
  [3067] = {.lex_state = 262, .external_lex_state = 18},
  [3068] = {.lex_state = 301, .external_lex_state = 6},
  [3069] = {.lex_state = 262, .external_lex_state = 18},
  [3070] = {.lex_state = 262, .external_lex_state = 18},
  [3071] = {.lex_state = 186, .external_lex_state = 5},
  [3072] = {.lex_state = 305, .external_lex_state = 6},
  [3073] = {.lex_state = 305, .external_lex_state = 5},
  [3074] = {.lex_state = 305, .external_lex_state = 6},
  [3075] = {.lex_state = 305, .external_lex_state = 5},
  [3076] = {.lex_state = 255, .external_lex_state = 2},
  [3077] = {.lex_state = 102},
  [3078] = {.lex_state = 340, .external_lex_state = 10},
  [3079] = {.lex_state = 340, .external_lex_state = 10},
  [3080] = {.lex_state = 340},
  [3081] = {.lex_state = 340},
  [3082] = {.lex_state = 85},
  [3083] = {.lex_state = 310},
  [3084] = {.lex_state = 106, .external_lex_state = 2},
  [3085] = {.lex_state = 374, .external_lex_state = 4},
  [3086] = {.lex_state = 374, .external_lex_state = 5},
  [3087] = {.lex_state = 112},
  [3088] = {.lex_state = 380, .external_lex_state = 6},
  [3089] = {.lex_state = 125},
  [3090] = {.lex_state = 380, .external_lex_state = 6},
  [3091] = {.lex_state = 112, .external_lex_state = 7},
  [3092] = {.lex_state = 78, .external_lex_state = 2},
  [3093] = {.lex_state = 78, .external_lex_state = 2},
  [3094] = {.lex_state = 78, .external_lex_state = 2},
  [3095] = {.lex_state = 382, .external_lex_state = 6},
  [3096] = {.lex_state = 343},
  [3097] = {.lex_state = 343, .external_lex_state = 5},
  [3098] = {.lex_state = 380, .external_lex_state = 5},
  [3099] = {.lex_state = 384, .external_lex_state = 4},
  [3100] = {.lex_state = 85},
  [3101] = {.lex_state = 380, .external_lex_state = 5},
  [3102] = {.lex_state = 78, .external_lex_state = 2},
  [3103] = {.lex_state = 102, .external_lex_state = 2},
  [3104] = {.lex_state = 380, .external_lex_state = 5},
  [3105] = {.lex_state = 358, .external_lex_state = 2},
  [3106] = {.lex_state = 340},
  [3107] = {.lex_state = 186, .external_lex_state = 5},
  [3108] = {.lex_state = 340, .external_lex_state = 10},
  [3109] = {.lex_state = 340},
  [3110] = {.lex_state = 340},
  [3111] = {.lex_state = 310},
  [3112] = {.lex_state = 343},
  [3113] = {.lex_state = 358, .external_lex_state = 2},
  [3114] = {.lex_state = 343},
  [3115] = {.lex_state = 149, .external_lex_state = 14},
  [3116] = {.lex_state = 149, .external_lex_state = 14},
  [3117] = {.lex_state = 149, .external_lex_state = 14},
  [3118] = {.lex_state = 262, .external_lex_state = 18},
  [3119] = {.lex_state = 262, .external_lex_state = 18},
  [3120] = {.lex_state = 149, .external_lex_state = 14},
  [3121] = {.lex_state = 186, .external_lex_state = 5},
  [3122] = {.lex_state = 343},
  [3123] = {.lex_state = 360, .external_lex_state = 15},
  [3124] = {.lex_state = 207, .external_lex_state = 27},
  [3125] = {.lex_state = 207, .external_lex_state = 27},
  [3126] = {.lex_state = 92, .external_lex_state = 29},
  [3127] = {.lex_state = 92, .external_lex_state = 18},
  [3128] = {.lex_state = 92, .external_lex_state = 18},
  [3129] = {.lex_state = 260, .external_lex_state = 18},
  [3130] = {.lex_state = 207, .external_lex_state = 27},
  [3131] = {.lex_state = 262, .external_lex_state = 30},
  [3132] = {.lex_state = 262, .external_lex_state = 18},
  [3133] = {.lex_state = 262, .external_lex_state = 30},
  [3134] = {.lex_state = 262, .external_lex_state = 18},
  [3135] = {.lex_state = 262, .external_lex_state = 18},
  [3136] = {.lex_state = 207, .external_lex_state = 27},
  [3137] = {.lex_state = 262, .external_lex_state = 18},
  [3138] = {.lex_state = 262, .external_lex_state = 18},
  [3139] = {.lex_state = 317},
  [3140] = {.lex_state = 205, .external_lex_state = 16},
  [3141] = {.lex_state = 317},
  [3142] = {.lex_state = 153},
  [3143] = {.lex_state = 268},
  [3144] = {.lex_state = 205, .external_lex_state = 16},
  [3145] = {.lex_state = 205, .external_lex_state = 16},
  [3146] = {.lex_state = 305},
  [3147] = {.lex_state = 205, .external_lex_state = 16},
  [3148] = {.lex_state = 343},
  [3149] = {.lex_state = 102},
  [3150] = {.lex_state = 205, .external_lex_state = 16},
  [3151] = {.lex_state = 343},
  [3152] = {.lex_state = 102},
  [3153] = {.lex_state = 199, .external_lex_state = 15},
  [3154] = {.lex_state = 199, .external_lex_state = 27},
  [3155] = {.lex_state = 199, .external_lex_state = 27},
  [3156] = {.lex_state = 92, .external_lex_state = 29},
  [3157] = {.lex_state = 92, .external_lex_state = 18},
  [3158] = {.lex_state = 92, .external_lex_state = 18},
  [3159] = {.lex_state = 262, .external_lex_state = 18},
  [3160] = {.lex_state = 199, .external_lex_state = 27},
  [3161] = {.lex_state = 262, .external_lex_state = 18},
  [3162] = {.lex_state = 262, .external_lex_state = 18},
  [3163] = {.lex_state = 262, .external_lex_state = 18},
  [3164] = {.lex_state = 199, .external_lex_state = 27},
  [3165] = {.lex_state = 262, .external_lex_state = 18},
  [3166] = {.lex_state = 199, .external_lex_state = 17},
  [3167] = {.lex_state = 199, .external_lex_state = 17},
  [3168] = {.lex_state = 92, .external_lex_state = 29},
  [3169] = {.lex_state = 92, .external_lex_state = 18},
  [3170] = {.lex_state = 92, .external_lex_state = 18},
  [3171] = {.lex_state = 262, .external_lex_state = 18},
  [3172] = {.lex_state = 199, .external_lex_state = 17},
  [3173] = {.lex_state = 262, .external_lex_state = 18},
  [3174] = {.lex_state = 262, .external_lex_state = 18},
  [3175] = {.lex_state = 262, .external_lex_state = 18},
  [3176] = {.lex_state = 199, .external_lex_state = 17},
  [3177] = {.lex_state = 262, .external_lex_state = 18},
  [3178] = {.lex_state = 201, .external_lex_state = 17},
  [3179] = {.lex_state = 201, .external_lex_state = 17},
  [3180] = {.lex_state = 201, .external_lex_state = 17},
  [3181] = {.lex_state = 262, .external_lex_state = 18},
  [3182] = {.lex_state = 262, .external_lex_state = 18},
  [3183] = {.lex_state = 201, .external_lex_state = 17},
  [3184] = {.lex_state = 386, .external_lex_state = 16},
  [3185] = {.lex_state = 209, .external_lex_state = 19},
  [3186] = {.lex_state = 209, .external_lex_state = 19},
  [3187] = {.lex_state = 209, .external_lex_state = 19},
  [3188] = {.lex_state = 262, .external_lex_state = 18},
  [3189] = {.lex_state = 262, .external_lex_state = 18},
  [3190] = {.lex_state = 209, .external_lex_state = 19},
  [3191] = {.lex_state = 178, .external_lex_state = 21},
  [3192] = {.lex_state = 178, .external_lex_state = 21},
  [3193] = {.lex_state = 178, .external_lex_state = 21},
  [3194] = {.lex_state = 262, .external_lex_state = 18},
  [3195] = {.lex_state = 262, .external_lex_state = 18},
  [3196] = {.lex_state = 178, .external_lex_state = 21},
  [3197] = {.lex_state = 178, .external_lex_state = 6},
  [3198] = {.lex_state = 178, .external_lex_state = 6},
  [3199] = {.lex_state = 178, .external_lex_state = 6},
  [3200] = {.lex_state = 262, .external_lex_state = 18},
  [3201] = {.lex_state = 262, .external_lex_state = 18},
  [3202] = {.lex_state = 178, .external_lex_state = 6},
  [3203] = {.lex_state = 215, .external_lex_state = 22},
  [3204] = {.lex_state = 215, .external_lex_state = 22},
  [3205] = {.lex_state = 215, .external_lex_state = 22},
  [3206] = {.lex_state = 262, .external_lex_state = 18},
  [3207] = {.lex_state = 262, .external_lex_state = 18},
  [3208] = {.lex_state = 215, .external_lex_state = 22},
  [3209] = {.lex_state = 125, .external_lex_state = 10},
  [3210] = {.lex_state = 125, .external_lex_state = 10},
  [3211] = {.lex_state = 125, .external_lex_state = 10},
  [3212] = {.lex_state = 262, .external_lex_state = 18},
  [3213] = {.lex_state = 262, .external_lex_state = 18},
  [3214] = {.lex_state = 125, .external_lex_state = 10},
  [3215] = {.lex_state = 225, .external_lex_state = 18},
  [3216] = {.lex_state = 225, .external_lex_state = 18},
  [3217] = {.lex_state = 112, .external_lex_state = 18},
  [3218] = {.lex_state = 92, .external_lex_state = 29},
  [3219] = {.lex_state = 92, .external_lex_state = 29},
  [3220] = {.lex_state = 92, .external_lex_state = 29},
  [3221] = {.lex_state = 92, .external_lex_state = 18},
  [3222] = {.lex_state = 92, .external_lex_state = 18},
  [3223] = {.lex_state = 260, .external_lex_state = 18},
  [3224] = {.lex_state = 92, .external_lex_state = 29},
  [3225] = {.lex_state = 262, .external_lex_state = 30},
  [3226] = {.lex_state = 262, .external_lex_state = 18},
  [3227] = {.lex_state = 262, .external_lex_state = 30},
  [3228] = {.lex_state = 262, .external_lex_state = 18},
  [3229] = {.lex_state = 262, .external_lex_state = 18},
  [3230] = {.lex_state = 92, .external_lex_state = 29},
  [3231] = {.lex_state = 262, .external_lex_state = 18},
  [3232] = {.lex_state = 262, .external_lex_state = 18},
  [3233] = {.lex_state = 142, .external_lex_state = 6},
  [3234] = {.lex_state = 142, .external_lex_state = 6},
  [3235] = {.lex_state = 262, .external_lex_state = 29},
  [3236] = {.lex_state = 262, .external_lex_state = 29},
  [3237] = {.lex_state = 92, .external_lex_state = 29},
  [3238] = {.lex_state = 92, .external_lex_state = 18},
  [3239] = {.lex_state = 92, .external_lex_state = 18},
  [3240] = {.lex_state = 262, .external_lex_state = 18},
  [3241] = {.lex_state = 262, .external_lex_state = 29},
  [3242] = {.lex_state = 262, .external_lex_state = 18},
  [3243] = {.lex_state = 262, .external_lex_state = 18},
  [3244] = {.lex_state = 262, .external_lex_state = 18},
  [3245] = {.lex_state = 262, .external_lex_state = 29},
  [3246] = {.lex_state = 262, .external_lex_state = 18},
  [3247] = {.lex_state = 96, .external_lex_state = 23},
  [3248] = {.lex_state = 96, .external_lex_state = 23},
  [3249] = {.lex_state = 92, .external_lex_state = 29},
  [3250] = {.lex_state = 92, .external_lex_state = 18},
  [3251] = {.lex_state = 92, .external_lex_state = 18},
  [3252] = {.lex_state = 262, .external_lex_state = 18},
  [3253] = {.lex_state = 96, .external_lex_state = 23},
  [3254] = {.lex_state = 262, .external_lex_state = 18},
  [3255] = {.lex_state = 262, .external_lex_state = 18},
  [3256] = {.lex_state = 262, .external_lex_state = 18},
  [3257] = {.lex_state = 96, .external_lex_state = 23},
  [3258] = {.lex_state = 262, .external_lex_state = 18},
  [3259] = {.lex_state = 136, .external_lex_state = 6},
  [3260] = {.lex_state = 215, .external_lex_state = 10},
  [3261] = {.lex_state = 215, .external_lex_state = 10},
  [3262] = {.lex_state = 92, .external_lex_state = 29},
  [3263] = {.lex_state = 92, .external_lex_state = 18},
  [3264] = {.lex_state = 92, .external_lex_state = 18},
  [3265] = {.lex_state = 262, .external_lex_state = 18},
  [3266] = {.lex_state = 215, .external_lex_state = 10},
  [3267] = {.lex_state = 262, .external_lex_state = 18},
  [3268] = {.lex_state = 262, .external_lex_state = 18},
  [3269] = {.lex_state = 262, .external_lex_state = 18},
  [3270] = {.lex_state = 215, .external_lex_state = 10},
  [3271] = {.lex_state = 262, .external_lex_state = 18},
  [3272] = {.lex_state = 184, .external_lex_state = 21},
  [3273] = {.lex_state = 184, .external_lex_state = 21},
  [3274] = {.lex_state = 184, .external_lex_state = 21},
  [3275] = {.lex_state = 262, .external_lex_state = 18},
  [3276] = {.lex_state = 262, .external_lex_state = 18},
  [3277] = {.lex_state = 184, .external_lex_state = 21},
  [3278] = {.lex_state = 186, .external_lex_state = 5},
  [3279] = {.lex_state = 317},
  [3280] = {.lex_state = 241, .external_lex_state = 14},
  [3281] = {.lex_state = 241, .external_lex_state = 14},
  [3282] = {.lex_state = 241, .external_lex_state = 14},
  [3283] = {.lex_state = 262, .external_lex_state = 18},
  [3284] = {.lex_state = 262, .external_lex_state = 18},
  [3285] = {.lex_state = 241, .external_lex_state = 14},
  [3286] = {.lex_state = 317},
  [3287] = {.lex_state = 270, .external_lex_state = 14},
  [3288] = {.lex_state = 270, .external_lex_state = 14},
  [3289] = {.lex_state = 92, .external_lex_state = 29},
  [3290] = {.lex_state = 92, .external_lex_state = 18},
  [3291] = {.lex_state = 92, .external_lex_state = 18},
  [3292] = {.lex_state = 262, .external_lex_state = 18},
  [3293] = {.lex_state = 270, .external_lex_state = 14},
  [3294] = {.lex_state = 262, .external_lex_state = 18},
  [3295] = {.lex_state = 262, .external_lex_state = 18},
  [3296] = {.lex_state = 262, .external_lex_state = 18},
  [3297] = {.lex_state = 270, .external_lex_state = 14},
  [3298] = {.lex_state = 262, .external_lex_state = 18},
  [3299] = {.lex_state = 272, .external_lex_state = 10},
  [3300] = {.lex_state = 272, .external_lex_state = 10},
  [3301] = {.lex_state = 272, .external_lex_state = 10},
  [3302] = {.lex_state = 262, .external_lex_state = 18},
  [3303] = {.lex_state = 262, .external_lex_state = 18},
  [3304] = {.lex_state = 272, .external_lex_state = 10},
  [3305] = {.lex_state = 246, .external_lex_state = 10},
  [3306] = {.lex_state = 246, .external_lex_state = 10},
  [3307] = {.lex_state = 140, .external_lex_state = 26},
  [3308] = {.lex_state = 140, .external_lex_state = 26},
  [3309] = {.lex_state = 92, .external_lex_state = 29},
  [3310] = {.lex_state = 92, .external_lex_state = 18},
  [3311] = {.lex_state = 92, .external_lex_state = 18},
  [3312] = {.lex_state = 262, .external_lex_state = 18},
  [3313] = {.lex_state = 140, .external_lex_state = 26},
  [3314] = {.lex_state = 262, .external_lex_state = 18},
  [3315] = {.lex_state = 262, .external_lex_state = 18},
  [3316] = {.lex_state = 262, .external_lex_state = 18},
  [3317] = {.lex_state = 140, .external_lex_state = 26},
  [3318] = {.lex_state = 262, .external_lex_state = 18},
  [3319] = {.lex_state = 136, .external_lex_state = 12},
  [3320] = {.lex_state = 317},
  [3321] = {.lex_state = 317},
  [3322] = {.lex_state = 153},
  [3323] = {.lex_state = 136, .external_lex_state = 12},
  [3324] = {.lex_state = 136, .external_lex_state = 12},
  [3325] = {.lex_state = 343},
  [3326] = {.lex_state = 136, .external_lex_state = 12},
  [3327] = {.lex_state = 343},
  [3328] = {.lex_state = 108, .external_lex_state = 26},
  [3329] = {.lex_state = 108, .external_lex_state = 26},
  [3330] = {.lex_state = 108, .external_lex_state = 26},
  [3331] = {.lex_state = 262, .external_lex_state = 18},
  [3332] = {.lex_state = 262, .external_lex_state = 18},
  [3333] = {.lex_state = 108, .external_lex_state = 26},
  [3334] = {.lex_state = 108, .external_lex_state = 13},
  [3335] = {.lex_state = 108, .external_lex_state = 13},
  [3336] = {.lex_state = 108, .external_lex_state = 13},
  [3337] = {.lex_state = 262, .external_lex_state = 18},
  [3338] = {.lex_state = 262, .external_lex_state = 18},
  [3339] = {.lex_state = 108, .external_lex_state = 13},
  [3340] = {.lex_state = 122, .external_lex_state = 13},
  [3341] = {.lex_state = 122, .external_lex_state = 13},
  [3342] = {.lex_state = 287, .external_lex_state = 4},
  [3343] = {.lex_state = 287, .external_lex_state = 21},
  [3344] = {.lex_state = 102},
  [3345] = {.lex_state = 287, .external_lex_state = 21},
  [3346] = {.lex_state = 287, .external_lex_state = 21},
  [3347] = {.lex_state = 217},
  [3348] = {.lex_state = 260, .external_lex_state = 18},
  [3349] = {.lex_state = 85},
  [3350] = {.lex_state = 225, .external_lex_state = 18},
  [3351] = {.lex_state = 225, .external_lex_state = 18},
  [3352] = {.lex_state = 287, .external_lex_state = 21},
  [3353] = {.lex_state = 262, .external_lex_state = 30},
  [3354] = {.lex_state = 262, .external_lex_state = 18},
  [3355] = {.lex_state = 287, .external_lex_state = 21},
  [3356] = {.lex_state = 262, .external_lex_state = 30},
  [3357] = {.lex_state = 262, .external_lex_state = 18},
  [3358] = {.lex_state = 287, .external_lex_state = 21},
  [3359] = {.lex_state = 287, .external_lex_state = 21},
  [3360] = {.lex_state = 275, .external_lex_state = 4},
  [3361] = {.lex_state = 215},
  [3362] = {.lex_state = 388, .external_lex_state = 4},
  [3363] = {.lex_state = 275, .external_lex_state = 21},
  [3364] = {.lex_state = 275, .external_lex_state = 21},
  [3365] = {.lex_state = 92, .external_lex_state = 29},
  [3366] = {.lex_state = 92, .external_lex_state = 18},
  [3367] = {.lex_state = 92, .external_lex_state = 18},
  [3368] = {.lex_state = 260, .external_lex_state = 18},
  [3369] = {.lex_state = 275, .external_lex_state = 21},
  [3370] = {.lex_state = 262, .external_lex_state = 30},
  [3371] = {.lex_state = 262, .external_lex_state = 18},
  [3372] = {.lex_state = 262, .external_lex_state = 30},
  [3373] = {.lex_state = 262, .external_lex_state = 18},
  [3374] = {.lex_state = 262, .external_lex_state = 18},
  [3375] = {.lex_state = 275, .external_lex_state = 21},
  [3376] = {.lex_state = 262, .external_lex_state = 18},
  [3377] = {.lex_state = 262, .external_lex_state = 18},
  [3378] = {.lex_state = 388, .external_lex_state = 5},
  [3379] = {.lex_state = 275, .external_lex_state = 6},
  [3380] = {.lex_state = 275, .external_lex_state = 6},
  [3381] = {.lex_state = 92, .external_lex_state = 29},
  [3382] = {.lex_state = 92, .external_lex_state = 18},
  [3383] = {.lex_state = 92, .external_lex_state = 18},
  [3384] = {.lex_state = 260, .external_lex_state = 18},
  [3385] = {.lex_state = 275, .external_lex_state = 6},
  [3386] = {.lex_state = 262, .external_lex_state = 30},
  [3387] = {.lex_state = 262, .external_lex_state = 18},
  [3388] = {.lex_state = 262, .external_lex_state = 30},
  [3389] = {.lex_state = 262, .external_lex_state = 18},
  [3390] = {.lex_state = 262, .external_lex_state = 18},
  [3391] = {.lex_state = 275, .external_lex_state = 6},
  [3392] = {.lex_state = 262, .external_lex_state = 18},
  [3393] = {.lex_state = 262, .external_lex_state = 18},
  [3394] = {.lex_state = 281, .external_lex_state = 6},
  [3395] = {.lex_state = 281, .external_lex_state = 6},
  [3396] = {.lex_state = 92, .external_lex_state = 29},
  [3397] = {.lex_state = 92, .external_lex_state = 18},
  [3398] = {.lex_state = 92, .external_lex_state = 18},
  [3399] = {.lex_state = 262, .external_lex_state = 18},
  [3400] = {.lex_state = 281, .external_lex_state = 6},
  [3401] = {.lex_state = 262, .external_lex_state = 18},
  [3402] = {.lex_state = 262, .external_lex_state = 18},
  [3403] = {.lex_state = 262, .external_lex_state = 18},
  [3404] = {.lex_state = 281, .external_lex_state = 6},
  [3405] = {.lex_state = 262, .external_lex_state = 18},
  [3406] = {.lex_state = 370, .external_lex_state = 6},
  [3407] = {.lex_state = 102},
  [3408] = {.lex_state = 285, .external_lex_state = 6},
  [3409] = {.lex_state = 370, .external_lex_state = 6},
  [3410] = {.lex_state = 217},
  [3411] = {.lex_state = 260, .external_lex_state = 18},
  [3412] = {.lex_state = 85},
  [3413] = {.lex_state = 225, .external_lex_state = 18},
  [3414] = {.lex_state = 225, .external_lex_state = 18},
  [3415] = {.lex_state = 370, .external_lex_state = 6},
  [3416] = {.lex_state = 262, .external_lex_state = 30},
  [3417] = {.lex_state = 262, .external_lex_state = 18},
  [3418] = {.lex_state = 370, .external_lex_state = 6},
  [3419] = {.lex_state = 262, .external_lex_state = 30},
  [3420] = {.lex_state = 262, .external_lex_state = 18},
  [3421] = {.lex_state = 370, .external_lex_state = 6},
  [3422] = {.lex_state = 370, .external_lex_state = 6},
  [3423] = {.lex_state = 308, .external_lex_state = 4},
  [3424] = {.lex_state = 308, .external_lex_state = 21},
  [3425] = {.lex_state = 102},
  [3426] = {.lex_state = 308, .external_lex_state = 21},
  [3427] = {.lex_state = 308, .external_lex_state = 21},
  [3428] = {.lex_state = 217},
  [3429] = {.lex_state = 260, .external_lex_state = 18},
  [3430] = {.lex_state = 85},
  [3431] = {.lex_state = 225, .external_lex_state = 18},
  [3432] = {.lex_state = 225, .external_lex_state = 18},
  [3433] = {.lex_state = 308, .external_lex_state = 21},
  [3434] = {.lex_state = 262, .external_lex_state = 30},
  [3435] = {.lex_state = 262, .external_lex_state = 18},
  [3436] = {.lex_state = 308, .external_lex_state = 21},
  [3437] = {.lex_state = 262, .external_lex_state = 30},
  [3438] = {.lex_state = 262, .external_lex_state = 18},
  [3439] = {.lex_state = 308, .external_lex_state = 21},
  [3440] = {.lex_state = 308, .external_lex_state = 21},
  [3441] = {.lex_state = 332, .external_lex_state = 4},
  [3442] = {.lex_state = 215},
  [3443] = {.lex_state = 332, .external_lex_state = 21},
  [3444] = {.lex_state = 332, .external_lex_state = 21},
  [3445] = {.lex_state = 332, .external_lex_state = 21},
  [3446] = {.lex_state = 102},
  [3447] = {.lex_state = 332, .external_lex_state = 21},
  [3448] = {.lex_state = 217},
  [3449] = {.lex_state = 332, .external_lex_state = 21},
  [3450] = {.lex_state = 125},
  [3451] = {.lex_state = 85},
  [3452] = {.lex_state = 223, .external_lex_state = 7},
  [3453] = {.lex_state = 225, .external_lex_state = 18},
  [3454] = {.lex_state = 225, .external_lex_state = 18},
  [3455] = {.lex_state = 85},
  [3456] = {.lex_state = 215, .external_lex_state = 2},
  [3457] = {.lex_state = 78},
  [3458] = {.lex_state = 85},
  [3459] = {.lex_state = 332, .external_lex_state = 4},
  [3460] = {.lex_state = 332, .external_lex_state = 4},
  [3461] = {.lex_state = 324, .external_lex_state = 4},
  [3462] = {.lex_state = 215},
  [3463] = {.lex_state = 324, .external_lex_state = 21},
  [3464] = {.lex_state = 324, .external_lex_state = 4},
  [3465] = {.lex_state = 324, .external_lex_state = 21},
  [3466] = {.lex_state = 102},
  [3467] = {.lex_state = 324, .external_lex_state = 21},
  [3468] = {.lex_state = 324, .external_lex_state = 21},
  [3469] = {.lex_state = 217},
  [3470] = {.lex_state = 260, .external_lex_state = 18},
  [3471] = {.lex_state = 85},
  [3472] = {.lex_state = 225, .external_lex_state = 18},
  [3473] = {.lex_state = 225, .external_lex_state = 18},
  [3474] = {.lex_state = 324, .external_lex_state = 21},
  [3475] = {.lex_state = 262, .external_lex_state = 30},
  [3476] = {.lex_state = 262, .external_lex_state = 18},
  [3477] = {.lex_state = 324, .external_lex_state = 21},
  [3478] = {.lex_state = 262, .external_lex_state = 30},
  [3479] = {.lex_state = 262, .external_lex_state = 18},
  [3480] = {.lex_state = 324, .external_lex_state = 21},
  [3481] = {.lex_state = 324, .external_lex_state = 21},
  [3482] = {.lex_state = 324, .external_lex_state = 6},
  [3483] = {.lex_state = 102},
  [3484] = {.lex_state = 324, .external_lex_state = 6},
  [3485] = {.lex_state = 324, .external_lex_state = 6},
  [3486] = {.lex_state = 217},
  [3487] = {.lex_state = 260, .external_lex_state = 18},
  [3488] = {.lex_state = 85},
  [3489] = {.lex_state = 225, .external_lex_state = 18},
  [3490] = {.lex_state = 225, .external_lex_state = 18},
  [3491] = {.lex_state = 324, .external_lex_state = 6},
  [3492] = {.lex_state = 262, .external_lex_state = 30},
  [3493] = {.lex_state = 262, .external_lex_state = 18},
  [3494] = {.lex_state = 324, .external_lex_state = 6},
  [3495] = {.lex_state = 262, .external_lex_state = 30},
  [3496] = {.lex_state = 262, .external_lex_state = 18},
  [3497] = {.lex_state = 324, .external_lex_state = 6},
  [3498] = {.lex_state = 324, .external_lex_state = 6},
  [3499] = {.lex_state = 390, .external_lex_state = 5},
  [3500] = {.lex_state = 326, .external_lex_state = 6},
  [3501] = {.lex_state = 326, .external_lex_state = 6},
  [3502] = {.lex_state = 92, .external_lex_state = 29},
  [3503] = {.lex_state = 92, .external_lex_state = 18},
  [3504] = {.lex_state = 92, .external_lex_state = 18},
  [3505] = {.lex_state = 260, .external_lex_state = 18},
  [3506] = {.lex_state = 326, .external_lex_state = 6},
  [3507] = {.lex_state = 262, .external_lex_state = 30},
  [3508] = {.lex_state = 262, .external_lex_state = 18},
  [3509] = {.lex_state = 262, .external_lex_state = 30},
  [3510] = {.lex_state = 262, .external_lex_state = 18},
  [3511] = {.lex_state = 262, .external_lex_state = 18},
  [3512] = {.lex_state = 326, .external_lex_state = 6},
  [3513] = {.lex_state = 262, .external_lex_state = 18},
  [3514] = {.lex_state = 262, .external_lex_state = 18},
  [3515] = {.lex_state = 330, .external_lex_state = 6},
  [3516] = {.lex_state = 330, .external_lex_state = 5},
  [3517] = {.lex_state = 330, .external_lex_state = 6},
  [3518] = {.lex_state = 330, .external_lex_state = 5},
  [3519] = {.lex_state = 289, .external_lex_state = 2},
  [3520] = {.lex_state = 291, .external_lex_state = 4},
  [3521] = {.lex_state = 215},
  [3522] = {.lex_state = 392, .external_lex_state = 4},
  [3523] = {.lex_state = 291, .external_lex_state = 21},
  [3524] = {.lex_state = 291, .external_lex_state = 21},
  [3525] = {.lex_state = 92, .external_lex_state = 29},
  [3526] = {.lex_state = 92, .external_lex_state = 18},
  [3527] = {.lex_state = 92, .external_lex_state = 18},
  [3528] = {.lex_state = 260, .external_lex_state = 18},
  [3529] = {.lex_state = 291, .external_lex_state = 21},
  [3530] = {.lex_state = 262, .external_lex_state = 30},
  [3531] = {.lex_state = 262, .external_lex_state = 18},
  [3532] = {.lex_state = 262, .external_lex_state = 30},
  [3533] = {.lex_state = 262, .external_lex_state = 18},
  [3534] = {.lex_state = 262, .external_lex_state = 18},
  [3535] = {.lex_state = 291, .external_lex_state = 21},
  [3536] = {.lex_state = 262, .external_lex_state = 18},
  [3537] = {.lex_state = 262, .external_lex_state = 18},
  [3538] = {.lex_state = 392, .external_lex_state = 5},
  [3539] = {.lex_state = 291, .external_lex_state = 6},
  [3540] = {.lex_state = 291, .external_lex_state = 6},
  [3541] = {.lex_state = 92, .external_lex_state = 29},
  [3542] = {.lex_state = 92, .external_lex_state = 18},
  [3543] = {.lex_state = 92, .external_lex_state = 18},
  [3544] = {.lex_state = 260, .external_lex_state = 18},
  [3545] = {.lex_state = 291, .external_lex_state = 6},
  [3546] = {.lex_state = 262, .external_lex_state = 30},
  [3547] = {.lex_state = 262, .external_lex_state = 18},
  [3548] = {.lex_state = 262, .external_lex_state = 30},
  [3549] = {.lex_state = 262, .external_lex_state = 18},
  [3550] = {.lex_state = 262, .external_lex_state = 18},
  [3551] = {.lex_state = 291, .external_lex_state = 6},
  [3552] = {.lex_state = 262, .external_lex_state = 18},
  [3553] = {.lex_state = 262, .external_lex_state = 18},
  [3554] = {.lex_state = 301, .external_lex_state = 6},
  [3555] = {.lex_state = 301, .external_lex_state = 6},
  [3556] = {.lex_state = 92, .external_lex_state = 29},
  [3557] = {.lex_state = 92, .external_lex_state = 18},
  [3558] = {.lex_state = 92, .external_lex_state = 18},
  [3559] = {.lex_state = 262, .external_lex_state = 18},
  [3560] = {.lex_state = 301, .external_lex_state = 6},
  [3561] = {.lex_state = 262, .external_lex_state = 18},
  [3562] = {.lex_state = 262, .external_lex_state = 18},
  [3563] = {.lex_state = 262, .external_lex_state = 18},
  [3564] = {.lex_state = 301, .external_lex_state = 6},
  [3565] = {.lex_state = 262, .external_lex_state = 18},
  [3566] = {.lex_state = 102},
  [3567] = {.lex_state = 305, .external_lex_state = 6},
  [3568] = {.lex_state = 394},
  [3569] = {.lex_state = 144, .external_lex_state = 8},
  [3570] = {.lex_state = 85},
  [3571] = {.lex_state = 112},
  [3572] = {.lex_state = 374, .external_lex_state = 21},
  [3573] = {.lex_state = 125},
  [3574] = {.lex_state = 374, .external_lex_state = 21},
  [3575] = {.lex_state = 112, .external_lex_state = 7},
  [3576] = {.lex_state = 78, .external_lex_state = 2},
  [3577] = {.lex_state = 78, .external_lex_state = 2},
  [3578] = {.lex_state = 78, .external_lex_state = 2},
  [3579] = {.lex_state = 85},
  [3580] = {.lex_state = 374, .external_lex_state = 4},
  [3581] = {.lex_state = 374, .external_lex_state = 4},
  [3582] = {.lex_state = 112},
  [3583] = {.lex_state = 374, .external_lex_state = 6},
  [3584] = {.lex_state = 125},
  [3585] = {.lex_state = 374, .external_lex_state = 6},
  [3586] = {.lex_state = 112, .external_lex_state = 7},
  [3587] = {.lex_state = 78, .external_lex_state = 2},
  [3588] = {.lex_state = 78, .external_lex_state = 2},
  [3589] = {.lex_state = 78, .external_lex_state = 2},
  [3590] = {.lex_state = 374, .external_lex_state = 5},
  [3591] = {.lex_state = 374, .external_lex_state = 5},
  [3592] = {.lex_state = 380, .external_lex_state = 6},
  [3593] = {.lex_state = 380, .external_lex_state = 6},
  [3594] = {.lex_state = 380, .external_lex_state = 6},
  [3595] = {.lex_state = 102},
  [3596] = {.lex_state = 380, .external_lex_state = 6},
  [3597] = {.lex_state = 217},
  [3598] = {.lex_state = 380, .external_lex_state = 6},
  [3599] = {.lex_state = 125},
  [3600] = {.lex_state = 85},
  [3601] = {.lex_state = 223, .external_lex_state = 7},
  [3602] = {.lex_state = 225, .external_lex_state = 18},
  [3603] = {.lex_state = 225, .external_lex_state = 18},
  [3604] = {.lex_state = 85},
  [3605] = {.lex_state = 215, .external_lex_state = 2},
  [3606] = {.lex_state = 78},
  [3607] = {.lex_state = 85},
  [3608] = {.lex_state = 310},
  [3609] = {.lex_state = 78},
  [3610] = {.lex_state = 358, .external_lex_state = 2},
  [3611] = {.lex_state = 78, .external_lex_state = 2},
  [3612] = {.lex_state = 78, .external_lex_state = 2},
  [3613] = {.lex_state = 102},
  [3614] = {.lex_state = 102},
  [3615] = {.lex_state = 396, .external_lex_state = 9},
  [3616] = {.lex_state = 343, .external_lex_state = 5},
  [3617] = {.lex_state = 237, .external_lex_state = 25},
  [3618] = {.lex_state = 380, .external_lex_state = 6},
  [3619] = {.lex_state = 380, .external_lex_state = 5},
  [3620] = {.lex_state = 380, .external_lex_state = 5},
  [3621] = {.lex_state = 343, .external_lex_state = 5},
  [3622] = {.lex_state = 384, .external_lex_state = 4},
  [3623] = {.lex_state = 380, .external_lex_state = 5},
  [3624] = {.lex_state = 380, .external_lex_state = 5},
  [3625] = {.lex_state = 380, .external_lex_state = 5},
  [3626] = {.lex_state = 343},
  [3627] = {.lex_state = 233, .external_lex_state = 2},
  [3628] = {.lex_state = 340},
  [3629] = {.lex_state = 233, .external_lex_state = 2},
  [3630] = {.lex_state = 340},
  [3631] = {.lex_state = 310},
  [3632] = {.lex_state = 343},
  [3633] = {.lex_state = 186, .external_lex_state = 5},
  [3634] = {.lex_state = 149, .external_lex_state = 14},
  [3635] = {.lex_state = 149, .external_lex_state = 14},
  [3636] = {.lex_state = 186, .external_lex_state = 5},
  [3637] = {.lex_state = 207, .external_lex_state = 27},
  [3638] = {.lex_state = 207, .external_lex_state = 27},
  [3639] = {.lex_state = 92, .external_lex_state = 29},
  [3640] = {.lex_state = 92, .external_lex_state = 18},
  [3641] = {.lex_state = 92, .external_lex_state = 18},
  [3642] = {.lex_state = 262, .external_lex_state = 18},
  [3643] = {.lex_state = 207, .external_lex_state = 27},
  [3644] = {.lex_state = 262, .external_lex_state = 18},
  [3645] = {.lex_state = 262, .external_lex_state = 18},
  [3646] = {.lex_state = 262, .external_lex_state = 18},
  [3647] = {.lex_state = 207, .external_lex_state = 27},
  [3648] = {.lex_state = 262, .external_lex_state = 18},
  [3649] = {.lex_state = 205, .external_lex_state = 16},
  [3650] = {.lex_state = 317},
  [3651] = {.lex_state = 317},
  [3652] = {.lex_state = 153},
  [3653] = {.lex_state = 205, .external_lex_state = 16},
  [3654] = {.lex_state = 205, .external_lex_state = 16},
  [3655] = {.lex_state = 343},
  [3656] = {.lex_state = 205, .external_lex_state = 16},
  [3657] = {.lex_state = 343},
  [3658] = {.lex_state = 199, .external_lex_state = 27},
  [3659] = {.lex_state = 199, .external_lex_state = 27},
  [3660] = {.lex_state = 199, .external_lex_state = 27},
  [3661] = {.lex_state = 262, .external_lex_state = 18},
  [3662] = {.lex_state = 262, .external_lex_state = 18},
  [3663] = {.lex_state = 199, .external_lex_state = 27},
  [3664] = {.lex_state = 199, .external_lex_state = 17},
  [3665] = {.lex_state = 199, .external_lex_state = 17},
  [3666] = {.lex_state = 199, .external_lex_state = 17},
  [3667] = {.lex_state = 262, .external_lex_state = 18},
  [3668] = {.lex_state = 262, .external_lex_state = 18},
  [3669] = {.lex_state = 199, .external_lex_state = 17},
  [3670] = {.lex_state = 201, .external_lex_state = 17},
  [3671] = {.lex_state = 201, .external_lex_state = 17},
  [3672] = {.lex_state = 209, .external_lex_state = 19},
  [3673] = {.lex_state = 209, .external_lex_state = 19},
  [3674] = {.lex_state = 178, .external_lex_state = 21},
  [3675] = {.lex_state = 178, .external_lex_state = 21},
  [3676] = {.lex_state = 178, .external_lex_state = 6},
  [3677] = {.lex_state = 178, .external_lex_state = 6},
  [3678] = {.lex_state = 215, .external_lex_state = 22},
  [3679] = {.lex_state = 215, .external_lex_state = 22},
  [3680] = {.lex_state = 125, .external_lex_state = 10},
  [3681] = {.lex_state = 125, .external_lex_state = 10},
  [3682] = {.lex_state = 92, .external_lex_state = 29},
  [3683] = {.lex_state = 92, .external_lex_state = 29},
  [3684] = {.lex_state = 92, .external_lex_state = 29},
  [3685] = {.lex_state = 92, .external_lex_state = 18},
  [3686] = {.lex_state = 92, .external_lex_state = 18},
  [3687] = {.lex_state = 262, .external_lex_state = 18},
  [3688] = {.lex_state = 92, .external_lex_state = 29},
  [3689] = {.lex_state = 262, .external_lex_state = 18},
  [3690] = {.lex_state = 262, .external_lex_state = 18},
  [3691] = {.lex_state = 262, .external_lex_state = 18},
  [3692] = {.lex_state = 92, .external_lex_state = 29},
  [3693] = {.lex_state = 262, .external_lex_state = 18},
  [3694] = {.lex_state = 262, .external_lex_state = 29},
  [3695] = {.lex_state = 262, .external_lex_state = 29},
  [3696] = {.lex_state = 262, .external_lex_state = 29},
  [3697] = {.lex_state = 262, .external_lex_state = 18},
  [3698] = {.lex_state = 262, .external_lex_state = 18},
  [3699] = {.lex_state = 262, .external_lex_state = 29},
  [3700] = {.lex_state = 96, .external_lex_state = 23},
  [3701] = {.lex_state = 96, .external_lex_state = 23},
  [3702] = {.lex_state = 96, .external_lex_state = 23},
  [3703] = {.lex_state = 262, .external_lex_state = 18},
  [3704] = {.lex_state = 262, .external_lex_state = 18},
  [3705] = {.lex_state = 96, .external_lex_state = 23},
  [3706] = {.lex_state = 215, .external_lex_state = 10},
  [3707] = {.lex_state = 215, .external_lex_state = 10},
  [3708] = {.lex_state = 215, .external_lex_state = 10},
  [3709] = {.lex_state = 262, .external_lex_state = 18},
  [3710] = {.lex_state = 262, .external_lex_state = 18},
  [3711] = {.lex_state = 215, .external_lex_state = 10},
  [3712] = {.lex_state = 184, .external_lex_state = 21},
  [3713] = {.lex_state = 184, .external_lex_state = 21},
  [3714] = {.lex_state = 186, .external_lex_state = 5},
  [3715] = {.lex_state = 241, .external_lex_state = 14},
  [3716] = {.lex_state = 241, .external_lex_state = 14},
  [3717] = {.lex_state = 317},
  [3718] = {.lex_state = 270, .external_lex_state = 14},
  [3719] = {.lex_state = 270, .external_lex_state = 14},
  [3720] = {.lex_state = 270, .external_lex_state = 14},
  [3721] = {.lex_state = 262, .external_lex_state = 18},
  [3722] = {.lex_state = 262, .external_lex_state = 18},
  [3723] = {.lex_state = 270, .external_lex_state = 14},
  [3724] = {.lex_state = 272, .external_lex_state = 10},
  [3725] = {.lex_state = 272, .external_lex_state = 10},
  [3726] = {.lex_state = 140, .external_lex_state = 26},
  [3727] = {.lex_state = 140, .external_lex_state = 26},
  [3728] = {.lex_state = 140, .external_lex_state = 26},
  [3729] = {.lex_state = 262, .external_lex_state = 18},
  [3730] = {.lex_state = 262, .external_lex_state = 18},
  [3731] = {.lex_state = 140, .external_lex_state = 26},
  [3732] = {.lex_state = 136, .external_lex_state = 12},
  [3733] = {.lex_state = 317},
  [3734] = {.lex_state = 317},
  [3735] = {.lex_state = 136, .external_lex_state = 12},
  [3736] = {.lex_state = 136, .external_lex_state = 12},
  [3737] = {.lex_state = 108, .external_lex_state = 26},
  [3738] = {.lex_state = 108, .external_lex_state = 26},
  [3739] = {.lex_state = 108, .external_lex_state = 13},
  [3740] = {.lex_state = 108, .external_lex_state = 13},
  [3741] = {.lex_state = 388, .external_lex_state = 4},
  [3742] = {.lex_state = 287, .external_lex_state = 21},
  [3743] = {.lex_state = 287, .external_lex_state = 21},
  [3744] = {.lex_state = 92, .external_lex_state = 29},
  [3745] = {.lex_state = 92, .external_lex_state = 18},
  [3746] = {.lex_state = 92, .external_lex_state = 18},
  [3747] = {.lex_state = 260, .external_lex_state = 18},
  [3748] = {.lex_state = 287, .external_lex_state = 21},
  [3749] = {.lex_state = 262, .external_lex_state = 30},
  [3750] = {.lex_state = 262, .external_lex_state = 18},
  [3751] = {.lex_state = 262, .external_lex_state = 30},
  [3752] = {.lex_state = 262, .external_lex_state = 18},
  [3753] = {.lex_state = 262, .external_lex_state = 18},
  [3754] = {.lex_state = 287, .external_lex_state = 21},
  [3755] = {.lex_state = 262, .external_lex_state = 18},
  [3756] = {.lex_state = 262, .external_lex_state = 18},
  [3757] = {.lex_state = 275, .external_lex_state = 4},
  [3758] = {.lex_state = 275, .external_lex_state = 21},
  [3759] = {.lex_state = 275, .external_lex_state = 21},
  [3760] = {.lex_state = 92, .external_lex_state = 29},
  [3761] = {.lex_state = 92, .external_lex_state = 18},
  [3762] = {.lex_state = 92, .external_lex_state = 18},
  [3763] = {.lex_state = 262, .external_lex_state = 18},
  [3764] = {.lex_state = 275, .external_lex_state = 21},
  [3765] = {.lex_state = 262, .external_lex_state = 18},
  [3766] = {.lex_state = 262, .external_lex_state = 18},
  [3767] = {.lex_state = 262, .external_lex_state = 18},
  [3768] = {.lex_state = 275, .external_lex_state = 21},
  [3769] = {.lex_state = 262, .external_lex_state = 18},
  [3770] = {.lex_state = 275, .external_lex_state = 6},
  [3771] = {.lex_state = 275, .external_lex_state = 6},
  [3772] = {.lex_state = 92, .external_lex_state = 29},
  [3773] = {.lex_state = 92, .external_lex_state = 18},
  [3774] = {.lex_state = 92, .external_lex_state = 18},
  [3775] = {.lex_state = 262, .external_lex_state = 18},
  [3776] = {.lex_state = 275, .external_lex_state = 6},
  [3777] = {.lex_state = 262, .external_lex_state = 18},
  [3778] = {.lex_state = 262, .external_lex_state = 18},
  [3779] = {.lex_state = 262, .external_lex_state = 18},
  [3780] = {.lex_state = 275, .external_lex_state = 6},
  [3781] = {.lex_state = 262, .external_lex_state = 18},
  [3782] = {.lex_state = 281, .external_lex_state = 6},
  [3783] = {.lex_state = 281, .external_lex_state = 6},
  [3784] = {.lex_state = 281, .external_lex_state = 6},
  [3785] = {.lex_state = 262, .external_lex_state = 18},
  [3786] = {.lex_state = 262, .external_lex_state = 18},
  [3787] = {.lex_state = 281, .external_lex_state = 6},
  [3788] = {.lex_state = 398, .external_lex_state = 5},
  [3789] = {.lex_state = 370, .external_lex_state = 6},
  [3790] = {.lex_state = 370, .external_lex_state = 6},
  [3791] = {.lex_state = 92, .external_lex_state = 29},
  [3792] = {.lex_state = 92, .external_lex_state = 18},
  [3793] = {.lex_state = 92, .external_lex_state = 18},
  [3794] = {.lex_state = 260, .external_lex_state = 18},
  [3795] = {.lex_state = 370, .external_lex_state = 6},
  [3796] = {.lex_state = 262, .external_lex_state = 30},
  [3797] = {.lex_state = 262, .external_lex_state = 18},
  [3798] = {.lex_state = 262, .external_lex_state = 30},
  [3799] = {.lex_state = 262, .external_lex_state = 18},
  [3800] = {.lex_state = 262, .external_lex_state = 18},
  [3801] = {.lex_state = 370, .external_lex_state = 6},
  [3802] = {.lex_state = 262, .external_lex_state = 18},
  [3803] = {.lex_state = 262, .external_lex_state = 18},
  [3804] = {.lex_state = 392, .external_lex_state = 4},
  [3805] = {.lex_state = 308, .external_lex_state = 21},
  [3806] = {.lex_state = 308, .external_lex_state = 21},
  [3807] = {.lex_state = 92, .external_lex_state = 29},
  [3808] = {.lex_state = 92, .external_lex_state = 18},
  [3809] = {.lex_state = 92, .external_lex_state = 18},
  [3810] = {.lex_state = 260, .external_lex_state = 18},
  [3811] = {.lex_state = 308, .external_lex_state = 21},
  [3812] = {.lex_state = 262, .external_lex_state = 30},
  [3813] = {.lex_state = 262, .external_lex_state = 18},
  [3814] = {.lex_state = 262, .external_lex_state = 30},
  [3815] = {.lex_state = 262, .external_lex_state = 18},
  [3816] = {.lex_state = 262, .external_lex_state = 18},
  [3817] = {.lex_state = 308, .external_lex_state = 21},
  [3818] = {.lex_state = 262, .external_lex_state = 18},
  [3819] = {.lex_state = 262, .external_lex_state = 18},
  [3820] = {.lex_state = 332, .external_lex_state = 4},
  [3821] = {.lex_state = 332, .external_lex_state = 21},
  [3822] = {.lex_state = 102},
  [3823] = {.lex_state = 332, .external_lex_state = 21},
  [3824] = {.lex_state = 332, .external_lex_state = 21},
  [3825] = {.lex_state = 217},
  [3826] = {.lex_state = 260, .external_lex_state = 18},
  [3827] = {.lex_state = 85},
  [3828] = {.lex_state = 225, .external_lex_state = 18},
  [3829] = {.lex_state = 225, .external_lex_state = 18},
  [3830] = {.lex_state = 332, .external_lex_state = 21},
  [3831] = {.lex_state = 262, .external_lex_state = 30},
  [3832] = {.lex_state = 262, .external_lex_state = 18},
  [3833] = {.lex_state = 332, .external_lex_state = 21},
  [3834] = {.lex_state = 262, .external_lex_state = 30},
  [3835] = {.lex_state = 262, .external_lex_state = 18},
  [3836] = {.lex_state = 332, .external_lex_state = 21},
  [3837] = {.lex_state = 332, .external_lex_state = 21},
  [3838] = {.lex_state = 324, .external_lex_state = 4},
  [3839] = {.lex_state = 215},
  [3840] = {.lex_state = 404, .external_lex_state = 4},
  [3841] = {.lex_state = 324, .external_lex_state = 21},
  [3842] = {.lex_state = 324, .external_lex_state = 21},
  [3843] = {.lex_state = 92, .external_lex_state = 29},
  [3844] = {.lex_state = 92, .external_lex_state = 18},
  [3845] = {.lex_state = 92, .external_lex_state = 18},
  [3846] = {.lex_state = 260, .external_lex_state = 18},
  [3847] = {.lex_state = 324, .external_lex_state = 21},
  [3848] = {.lex_state = 262, .external_lex_state = 30},
  [3849] = {.lex_state = 262, .external_lex_state = 18},
  [3850] = {.lex_state = 262, .external_lex_state = 30},
  [3851] = {.lex_state = 262, .external_lex_state = 18},
  [3852] = {.lex_state = 262, .external_lex_state = 18},
  [3853] = {.lex_state = 324, .external_lex_state = 21},
  [3854] = {.lex_state = 262, .external_lex_state = 18},
  [3855] = {.lex_state = 262, .external_lex_state = 18},
  [3856] = {.lex_state = 404, .external_lex_state = 5},
  [3857] = {.lex_state = 324, .external_lex_state = 6},
  [3858] = {.lex_state = 324, .external_lex_state = 6},
  [3859] = {.lex_state = 92, .external_lex_state = 29},
  [3860] = {.lex_state = 92, .external_lex_state = 18},
  [3861] = {.lex_state = 92, .external_lex_state = 18},
  [3862] = {.lex_state = 260, .external_lex_state = 18},
  [3863] = {.lex_state = 324, .external_lex_state = 6},
  [3864] = {.lex_state = 262, .external_lex_state = 30},
  [3865] = {.lex_state = 262, .external_lex_state = 18},
  [3866] = {.lex_state = 262, .external_lex_state = 30},
  [3867] = {.lex_state = 262, .external_lex_state = 18},
  [3868] = {.lex_state = 262, .external_lex_state = 18},
  [3869] = {.lex_state = 324, .external_lex_state = 6},
  [3870] = {.lex_state = 262, .external_lex_state = 18},
  [3871] = {.lex_state = 262, .external_lex_state = 18},
  [3872] = {.lex_state = 326, .external_lex_state = 6},
  [3873] = {.lex_state = 326, .external_lex_state = 6},
  [3874] = {.lex_state = 92, .external_lex_state = 29},
  [3875] = {.lex_state = 92, .external_lex_state = 18},
  [3876] = {.lex_state = 92, .external_lex_state = 18},
  [3877] = {.lex_state = 262, .external_lex_state = 18},
  [3878] = {.lex_state = 326, .external_lex_state = 6},
  [3879] = {.lex_state = 262, .external_lex_state = 18},
  [3880] = {.lex_state = 262, .external_lex_state = 18},
  [3881] = {.lex_state = 262, .external_lex_state = 18},
  [3882] = {.lex_state = 326, .external_lex_state = 6},
  [3883] = {.lex_state = 262, .external_lex_state = 18},
  [3884] = {.lex_state = 102},
  [3885] = {.lex_state = 330, .external_lex_state = 6},
  [3886] = {.lex_state = 291, .external_lex_state = 4},
  [3887] = {.lex_state = 291, .external_lex_state = 21},
  [3888] = {.lex_state = 291, .external_lex_state = 21},
  [3889] = {.lex_state = 92, .external_lex_state = 29},
  [3890] = {.lex_state = 92, .external_lex_state = 18},
  [3891] = {.lex_state = 92, .external_lex_state = 18},
  [3892] = {.lex_state = 262, .external_lex_state = 18},
  [3893] = {.lex_state = 291, .external_lex_state = 21},
  [3894] = {.lex_state = 262, .external_lex_state = 18},
  [3895] = {.lex_state = 262, .external_lex_state = 18},
  [3896] = {.lex_state = 262, .external_lex_state = 18},
  [3897] = {.lex_state = 291, .external_lex_state = 21},
  [3898] = {.lex_state = 262, .external_lex_state = 18},
  [3899] = {.lex_state = 291, .external_lex_state = 6},
  [3900] = {.lex_state = 291, .external_lex_state = 6},
  [3901] = {.lex_state = 92, .external_lex_state = 29},
  [3902] = {.lex_state = 92, .external_lex_state = 18},
  [3903] = {.lex_state = 92, .external_lex_state = 18},
  [3904] = {.lex_state = 262, .external_lex_state = 18},
  [3905] = {.lex_state = 291, .external_lex_state = 6},
  [3906] = {.lex_state = 262, .external_lex_state = 18},
  [3907] = {.lex_state = 262, .external_lex_state = 18},
  [3908] = {.lex_state = 262, .external_lex_state = 18},
  [3909] = {.lex_state = 291, .external_lex_state = 6},
  [3910] = {.lex_state = 262, .external_lex_state = 18},
  [3911] = {.lex_state = 301, .external_lex_state = 6},
  [3912] = {.lex_state = 301, .external_lex_state = 6},
  [3913] = {.lex_state = 301, .external_lex_state = 6},
  [3914] = {.lex_state = 262, .external_lex_state = 18},
  [3915] = {.lex_state = 262, .external_lex_state = 18},
  [3916] = {.lex_state = 301, .external_lex_state = 6},
  [3917] = {.lex_state = 406, .external_lex_state = 5},
  [3918] = {.lex_state = 384, .external_lex_state = 4},
  [3919] = {.lex_state = 215},
  [3920] = {.lex_state = 112},
  [3921] = {.lex_state = 384, .external_lex_state = 21},
  [3922] = {.lex_state = 125},
  [3923] = {.lex_state = 384, .external_lex_state = 21},
  [3924] = {.lex_state = 112, .external_lex_state = 7},
  [3925] = {.lex_state = 78, .external_lex_state = 2},
  [3926] = {.lex_state = 78, .external_lex_state = 2},
  [3927] = {.lex_state = 78, .external_lex_state = 2},
  [3928] = {.lex_state = 384, .external_lex_state = 4},
  [3929] = {.lex_state = 144, .external_lex_state = 8},
  [3930] = {.lex_state = 374, .external_lex_state = 21},
  [3931] = {.lex_state = 374, .external_lex_state = 21},
  [3932] = {.lex_state = 374, .external_lex_state = 21},
  [3933] = {.lex_state = 102},
  [3934] = {.lex_state = 374, .external_lex_state = 21},
  [3935] = {.lex_state = 217},
  [3936] = {.lex_state = 374, .external_lex_state = 21},
  [3937] = {.lex_state = 125},
  [3938] = {.lex_state = 85},
  [3939] = {.lex_state = 223, .external_lex_state = 7},
  [3940] = {.lex_state = 225, .external_lex_state = 18},
  [3941] = {.lex_state = 225, .external_lex_state = 18},
  [3942] = {.lex_state = 85},
  [3943] = {.lex_state = 215, .external_lex_state = 2},
  [3944] = {.lex_state = 78},
  [3945] = {.lex_state = 85},
  [3946] = {.lex_state = 374, .external_lex_state = 4},
  [3947] = {.lex_state = 374, .external_lex_state = 4},
  [3948] = {.lex_state = 374, .external_lex_state = 4},
  [3949] = {.lex_state = 374, .external_lex_state = 6},
  [3950] = {.lex_state = 374, .external_lex_state = 6},
  [3951] = {.lex_state = 374, .external_lex_state = 6},
  [3952] = {.lex_state = 102},
  [3953] = {.lex_state = 374, .external_lex_state = 6},
  [3954] = {.lex_state = 217},
  [3955] = {.lex_state = 374, .external_lex_state = 6},
  [3956] = {.lex_state = 125},
  [3957] = {.lex_state = 85},
  [3958] = {.lex_state = 223, .external_lex_state = 7},
  [3959] = {.lex_state = 225, .external_lex_state = 18},
  [3960] = {.lex_state = 225, .external_lex_state = 18},
  [3961] = {.lex_state = 85},
  [3962] = {.lex_state = 215, .external_lex_state = 2},
  [3963] = {.lex_state = 78},
  [3964] = {.lex_state = 85},
  [3965] = {.lex_state = 374, .external_lex_state = 5},
  [3966] = {.lex_state = 374, .external_lex_state = 5},
  [3967] = {.lex_state = 374, .external_lex_state = 5},
  [3968] = {.lex_state = 380, .external_lex_state = 6},
  [3969] = {.lex_state = 102},
  [3970] = {.lex_state = 380, .external_lex_state = 6},
  [3971] = {.lex_state = 380, .external_lex_state = 6},
  [3972] = {.lex_state = 217},
  [3973] = {.lex_state = 260, .external_lex_state = 18},
  [3974] = {.lex_state = 85},
  [3975] = {.lex_state = 225, .external_lex_state = 18},
  [3976] = {.lex_state = 225, .external_lex_state = 18},
  [3977] = {.lex_state = 380, .external_lex_state = 6},
  [3978] = {.lex_state = 262, .external_lex_state = 30},
  [3979] = {.lex_state = 262, .external_lex_state = 18},
  [3980] = {.lex_state = 380, .external_lex_state = 6},
  [3981] = {.lex_state = 262, .external_lex_state = 30},
  [3982] = {.lex_state = 262, .external_lex_state = 18},
  [3983] = {.lex_state = 380, .external_lex_state = 6},
  [3984] = {.lex_state = 380, .external_lex_state = 6},
  [3985] = {.lex_state = 102},
  [3986] = {.lex_state = 343, .external_lex_state = 5},
  [3987] = {.lex_state = 384, .external_lex_state = 4},
  [3988] = {.lex_state = 343, .external_lex_state = 5},
  [3989] = {.lex_state = 384, .external_lex_state = 4},
  [3990] = {.lex_state = 343, .external_lex_state = 6},
  [3991] = {.lex_state = 343, .external_lex_state = 6},
  [3992] = {.lex_state = 343, .external_lex_state = 5},
  [3993] = {.lex_state = 343, .external_lex_state = 6},
  [3994] = {.lex_state = 343, .external_lex_state = 5},
  [3995] = {.lex_state = 358, .external_lex_state = 2},
  [3996] = {.lex_state = 343, .external_lex_state = 5},
  [3997] = {.lex_state = 380, .external_lex_state = 5},
  [3998] = {.lex_state = 380, .external_lex_state = 6},
  [3999] = {.lex_state = 380, .external_lex_state = 5},
  [4000] = {.lex_state = 380, .external_lex_state = 5},
  [4001] = {.lex_state = 358, .external_lex_state = 2},
  [4002] = {.lex_state = 396, .external_lex_state = 9},
  [4003] = {.lex_state = 380, .external_lex_state = 5},
  [4004] = {.lex_state = 310},
  [4005] = {.lex_state = 102},
  [4006] = {.lex_state = 85},
  [4007] = {.lex_state = 136, .external_lex_state = 5},
  [4008] = {.lex_state = 140, .external_lex_state = 4},
  [4009] = {.lex_state = 78, .external_lex_state = 2},
  [4010] = {.lex_state = 233, .external_lex_state = 2},
  [4011] = {.lex_state = 102},
  [4012] = {.lex_state = 85},
  [4013] = {.lex_state = 233, .external_lex_state = 2},
  [4014] = {.lex_state = 310},
  [4015] = {.lex_state = 207, .external_lex_state = 27},
  [4016] = {.lex_state = 207, .external_lex_state = 27},
  [4017] = {.lex_state = 207, .external_lex_state = 27},
  [4018] = {.lex_state = 262, .external_lex_state = 18},
  [4019] = {.lex_state = 262, .external_lex_state = 18},
  [4020] = {.lex_state = 207, .external_lex_state = 27},
  [4021] = {.lex_state = 205, .external_lex_state = 16},
  [4022] = {.lex_state = 317},
  [4023] = {.lex_state = 317},
  [4024] = {.lex_state = 205, .external_lex_state = 16},
  [4025] = {.lex_state = 205, .external_lex_state = 16},
  [4026] = {.lex_state = 199, .external_lex_state = 27},
  [4027] = {.lex_state = 199, .external_lex_state = 27},
  [4028] = {.lex_state = 199, .external_lex_state = 17},
  [4029] = {.lex_state = 199, .external_lex_state = 17},
  [4030] = {.lex_state = 92, .external_lex_state = 29},
  [4031] = {.lex_state = 92, .external_lex_state = 29},
  [4032] = {.lex_state = 92, .external_lex_state = 29},
  [4033] = {.lex_state = 262, .external_lex_state = 18},
  [4034] = {.lex_state = 262, .external_lex_state = 18},
  [4035] = {.lex_state = 92, .external_lex_state = 29},
  [4036] = {.lex_state = 262, .external_lex_state = 29},
  [4037] = {.lex_state = 262, .external_lex_state = 29},
  [4038] = {.lex_state = 96, .external_lex_state = 23},
  [4039] = {.lex_state = 96, .external_lex_state = 23},
  [4040] = {.lex_state = 215, .external_lex_state = 10},
  [4041] = {.lex_state = 215, .external_lex_state = 10},
  [4042] = {.lex_state = 186, .external_lex_state = 5},
  [4043] = {.lex_state = 270, .external_lex_state = 14},
  [4044] = {.lex_state = 270, .external_lex_state = 14},
  [4045] = {.lex_state = 140, .external_lex_state = 26},
  [4046] = {.lex_state = 140, .external_lex_state = 26},
  [4047] = {.lex_state = 136, .external_lex_state = 12},
  [4048] = {.lex_state = 317},
  [4049] = {.lex_state = 287, .external_lex_state = 21},
  [4050] = {.lex_state = 287, .external_lex_state = 21},
  [4051] = {.lex_state = 92, .external_lex_state = 29},
  [4052] = {.lex_state = 92, .external_lex_state = 18},
  [4053] = {.lex_state = 92, .external_lex_state = 18},
  [4054] = {.lex_state = 262, .external_lex_state = 18},
  [4055] = {.lex_state = 287, .external_lex_state = 21},
  [4056] = {.lex_state = 262, .external_lex_state = 18},
  [4057] = {.lex_state = 262, .external_lex_state = 18},
  [4058] = {.lex_state = 262, .external_lex_state = 18},
  [4059] = {.lex_state = 287, .external_lex_state = 21},
  [4060] = {.lex_state = 262, .external_lex_state = 18},
  [4061] = {.lex_state = 275, .external_lex_state = 21},
  [4062] = {.lex_state = 275, .external_lex_state = 21},
  [4063] = {.lex_state = 275, .external_lex_state = 21},
  [4064] = {.lex_state = 262, .external_lex_state = 18},
  [4065] = {.lex_state = 262, .external_lex_state = 18},
  [4066] = {.lex_state = 275, .external_lex_state = 21},
  [4067] = {.lex_state = 275, .external_lex_state = 6},
  [4068] = {.lex_state = 275, .external_lex_state = 6},
  [4069] = {.lex_state = 275, .external_lex_state = 6},
  [4070] = {.lex_state = 262, .external_lex_state = 18},
  [4071] = {.lex_state = 262, .external_lex_state = 18},
  [4072] = {.lex_state = 275, .external_lex_state = 6},
  [4073] = {.lex_state = 281, .external_lex_state = 6},
  [4074] = {.lex_state = 281, .external_lex_state = 6},
  [4075] = {.lex_state = 370, .external_lex_state = 6},
  [4076] = {.lex_state = 370, .external_lex_state = 6},
  [4077] = {.lex_state = 92, .external_lex_state = 29},
  [4078] = {.lex_state = 92, .external_lex_state = 18},
  [4079] = {.lex_state = 92, .external_lex_state = 18},
  [4080] = {.lex_state = 262, .external_lex_state = 18},
  [4081] = {.lex_state = 370, .external_lex_state = 6},
  [4082] = {.lex_state = 262, .external_lex_state = 18},
  [4083] = {.lex_state = 262, .external_lex_state = 18},
  [4084] = {.lex_state = 262, .external_lex_state = 18},
  [4085] = {.lex_state = 370, .external_lex_state = 6},
  [4086] = {.lex_state = 262, .external_lex_state = 18},
  [4087] = {.lex_state = 308, .external_lex_state = 21},
  [4088] = {.lex_state = 308, .external_lex_state = 21},
  [4089] = {.lex_state = 92, .external_lex_state = 29},
  [4090] = {.lex_state = 92, .external_lex_state = 18},
  [4091] = {.lex_state = 92, .external_lex_state = 18},
  [4092] = {.lex_state = 262, .external_lex_state = 18},
  [4093] = {.lex_state = 308, .external_lex_state = 21},
  [4094] = {.lex_state = 262, .external_lex_state = 18},
  [4095] = {.lex_state = 262, .external_lex_state = 18},
  [4096] = {.lex_state = 262, .external_lex_state = 18},
  [4097] = {.lex_state = 308, .external_lex_state = 21},
  [4098] = {.lex_state = 262, .external_lex_state = 18},
  [4099] = {.lex_state = 404, .external_lex_state = 4},
  [4100] = {.lex_state = 332, .external_lex_state = 21},
  [4101] = {.lex_state = 332, .external_lex_state = 21},
  [4102] = {.lex_state = 92, .external_lex_state = 29},
  [4103] = {.lex_state = 92, .external_lex_state = 18},
  [4104] = {.lex_state = 92, .external_lex_state = 18},
  [4105] = {.lex_state = 260, .external_lex_state = 18},
  [4106] = {.lex_state = 332, .external_lex_state = 21},
  [4107] = {.lex_state = 262, .external_lex_state = 30},
  [4108] = {.lex_state = 262, .external_lex_state = 18},
  [4109] = {.lex_state = 262, .external_lex_state = 30},
  [4110] = {.lex_state = 262, .external_lex_state = 18},
  [4111] = {.lex_state = 262, .external_lex_state = 18},
  [4112] = {.lex_state = 332, .external_lex_state = 21},
  [4113] = {.lex_state = 262, .external_lex_state = 18},
  [4114] = {.lex_state = 262, .external_lex_state = 18},
  [4115] = {.lex_state = 324, .external_lex_state = 4},
  [4116] = {.lex_state = 324, .external_lex_state = 21},
  [4117] = {.lex_state = 324, .external_lex_state = 21},
  [4118] = {.lex_state = 92, .external_lex_state = 29},
  [4119] = {.lex_state = 92, .external_lex_state = 18},
  [4120] = {.lex_state = 92, .external_lex_state = 18},
  [4121] = {.lex_state = 262, .external_lex_state = 18},
  [4122] = {.lex_state = 324, .external_lex_state = 21},
  [4123] = {.lex_state = 262, .external_lex_state = 18},
  [4124] = {.lex_state = 262, .external_lex_state = 18},
  [4125] = {.lex_state = 262, .external_lex_state = 18},
  [4126] = {.lex_state = 324, .external_lex_state = 21},
  [4127] = {.lex_state = 262, .external_lex_state = 18},
  [4128] = {.lex_state = 324, .external_lex_state = 6},
  [4129] = {.lex_state = 324, .external_lex_state = 6},
  [4130] = {.lex_state = 92, .external_lex_state = 29},
  [4131] = {.lex_state = 92, .external_lex_state = 18},
  [4132] = {.lex_state = 92, .external_lex_state = 18},
  [4133] = {.lex_state = 262, .external_lex_state = 18},
  [4134] = {.lex_state = 324, .external_lex_state = 6},
  [4135] = {.lex_state = 262, .external_lex_state = 18},
  [4136] = {.lex_state = 262, .external_lex_state = 18},
  [4137] = {.lex_state = 262, .external_lex_state = 18},
  [4138] = {.lex_state = 324, .external_lex_state = 6},
  [4139] = {.lex_state = 262, .external_lex_state = 18},
  [4140] = {.lex_state = 326, .external_lex_state = 6},
  [4141] = {.lex_state = 326, .external_lex_state = 6},
  [4142] = {.lex_state = 326, .external_lex_state = 6},
  [4143] = {.lex_state = 262, .external_lex_state = 18},
  [4144] = {.lex_state = 262, .external_lex_state = 18},
  [4145] = {.lex_state = 326, .external_lex_state = 6},
  [4146] = {.lex_state = 416, .external_lex_state = 5},
  [4147] = {.lex_state = 291, .external_lex_state = 21},
  [4148] = {.lex_state = 291, .external_lex_state = 21},
  [4149] = {.lex_state = 291, .external_lex_state = 21},
  [4150] = {.lex_state = 262, .external_lex_state = 18},
  [4151] = {.lex_state = 262, .external_lex_state = 18},
  [4152] = {.lex_state = 291, .external_lex_state = 21},
  [4153] = {.lex_state = 291, .external_lex_state = 6},
  [4154] = {.lex_state = 291, .external_lex_state = 6},
  [4155] = {.lex_state = 291, .external_lex_state = 6},
  [4156] = {.lex_state = 262, .external_lex_state = 18},
  [4157] = {.lex_state = 262, .external_lex_state = 18},
  [4158] = {.lex_state = 291, .external_lex_state = 6},
  [4159] = {.lex_state = 301, .external_lex_state = 6},
  [4160] = {.lex_state = 301, .external_lex_state = 6},
  [4161] = {.lex_state = 384, .external_lex_state = 4},
  [4162] = {.lex_state = 215},
  [4163] = {.lex_state = 384, .external_lex_state = 21},
  [4164] = {.lex_state = 384, .external_lex_state = 21},
  [4165] = {.lex_state = 384, .external_lex_state = 21},
  [4166] = {.lex_state = 102},
  [4167] = {.lex_state = 384, .external_lex_state = 21},
  [4168] = {.lex_state = 217},
  [4169] = {.lex_state = 384, .external_lex_state = 21},
  [4170] = {.lex_state = 125},
  [4171] = {.lex_state = 85},
  [4172] = {.lex_state = 223, .external_lex_state = 7},
  [4173] = {.lex_state = 225, .external_lex_state = 18},
  [4174] = {.lex_state = 225, .external_lex_state = 18},
  [4175] = {.lex_state = 85},
  [4176] = {.lex_state = 215, .external_lex_state = 2},
  [4177] = {.lex_state = 78},
  [4178] = {.lex_state = 85},
  [4179] = {.lex_state = 384, .external_lex_state = 4},
  [4180] = {.lex_state = 384, .external_lex_state = 4},
  [4181] = {.lex_state = 374, .external_lex_state = 4},
  [4182] = {.lex_state = 215},
  [4183] = {.lex_state = 374, .external_lex_state = 21},
  [4184] = {.lex_state = 374, .external_lex_state = 4},
  [4185] = {.lex_state = 374, .external_lex_state = 21},
  [4186] = {.lex_state = 102},
  [4187] = {.lex_state = 374, .external_lex_state = 21},
  [4188] = {.lex_state = 374, .external_lex_state = 21},
  [4189] = {.lex_state = 217},
  [4190] = {.lex_state = 260, .external_lex_state = 18},
  [4191] = {.lex_state = 85},
  [4192] = {.lex_state = 225, .external_lex_state = 18},
  [4193] = {.lex_state = 225, .external_lex_state = 18},
  [4194] = {.lex_state = 374, .external_lex_state = 21},
  [4195] = {.lex_state = 262, .external_lex_state = 30},
  [4196] = {.lex_state = 262, .external_lex_state = 18},
  [4197] = {.lex_state = 374, .external_lex_state = 21},
  [4198] = {.lex_state = 262, .external_lex_state = 30},
  [4199] = {.lex_state = 262, .external_lex_state = 18},
  [4200] = {.lex_state = 374, .external_lex_state = 21},
  [4201] = {.lex_state = 374, .external_lex_state = 21},
  [4202] = {.lex_state = 374, .external_lex_state = 6},
  [4203] = {.lex_state = 102},
  [4204] = {.lex_state = 374, .external_lex_state = 6},
  [4205] = {.lex_state = 374, .external_lex_state = 6},
  [4206] = {.lex_state = 217},
  [4207] = {.lex_state = 260, .external_lex_state = 18},
  [4208] = {.lex_state = 85},
  [4209] = {.lex_state = 225, .external_lex_state = 18},
  [4210] = {.lex_state = 225, .external_lex_state = 18},
  [4211] = {.lex_state = 374, .external_lex_state = 6},
  [4212] = {.lex_state = 262, .external_lex_state = 30},
  [4213] = {.lex_state = 262, .external_lex_state = 18},
  [4214] = {.lex_state = 374, .external_lex_state = 6},
  [4215] = {.lex_state = 262, .external_lex_state = 30},
  [4216] = {.lex_state = 262, .external_lex_state = 18},
  [4217] = {.lex_state = 374, .external_lex_state = 6},
  [4218] = {.lex_state = 374, .external_lex_state = 6},
  [4219] = {.lex_state = 418, .external_lex_state = 5},
  [4220] = {.lex_state = 380, .external_lex_state = 6},
  [4221] = {.lex_state = 380, .external_lex_state = 6},
  [4222] = {.lex_state = 92, .external_lex_state = 29},
  [4223] = {.lex_state = 92, .external_lex_state = 18},
  [4224] = {.lex_state = 92, .external_lex_state = 18},
  [4225] = {.lex_state = 260, .external_lex_state = 18},
  [4226] = {.lex_state = 380, .external_lex_state = 6},
  [4227] = {.lex_state = 262, .external_lex_state = 30},
  [4228] = {.lex_state = 262, .external_lex_state = 18},
  [4229] = {.lex_state = 262, .external_lex_state = 30},
  [4230] = {.lex_state = 262, .external_lex_state = 18},
  [4231] = {.lex_state = 262, .external_lex_state = 18},
  [4232] = {.lex_state = 380, .external_lex_state = 6},
  [4233] = {.lex_state = 262, .external_lex_state = 18},
  [4234] = {.lex_state = 262, .external_lex_state = 18},
  [4235] = {.lex_state = 343, .external_lex_state = 6},
  [4236] = {.lex_state = 343, .external_lex_state = 5},
  [4237] = {.lex_state = 343, .external_lex_state = 6},
  [4238] = {.lex_state = 343, .external_lex_state = 5},
  [4239] = {.lex_state = 358, .external_lex_state = 2},
  [4240] = {.lex_state = 102},
  [4241] = {.lex_state = 146, .external_lex_state = 9},
  [4242] = {.lex_state = 136, .external_lex_state = 5},
  [4243] = {.lex_state = 140, .external_lex_state = 4},
  [4244] = {.lex_state = 85},
  [4245] = {.lex_state = 102},
  [4246] = {.lex_state = 85},
  [4247] = {.lex_state = 207, .external_lex_state = 27},
  [4248] = {.lex_state = 207, .external_lex_state = 27},
  [4249] = {.lex_state = 205, .external_lex_state = 16},
  [4250] = {.lex_state = 317},
  [4251] = {.lex_state = 92, .external_lex_state = 29},
  [4252] = {.lex_state = 92, .external_lex_state = 29},
  [4253] = {.lex_state = 136, .external_lex_state = 12},
  [4254] = {.lex_state = 287, .external_lex_state = 21},
  [4255] = {.lex_state = 287, .external_lex_state = 21},
  [4256] = {.lex_state = 287, .external_lex_state = 21},
  [4257] = {.lex_state = 262, .external_lex_state = 18},
  [4258] = {.lex_state = 262, .external_lex_state = 18},
  [4259] = {.lex_state = 287, .external_lex_state = 21},
  [4260] = {.lex_state = 275, .external_lex_state = 21},
  [4261] = {.lex_state = 275, .external_lex_state = 21},
  [4262] = {.lex_state = 275, .external_lex_state = 6},
  [4263] = {.lex_state = 275, .external_lex_state = 6},
  [4264] = {.lex_state = 370, .external_lex_state = 6},
  [4265] = {.lex_state = 370, .external_lex_state = 6},
  [4266] = {.lex_state = 370, .external_lex_state = 6},
  [4267] = {.lex_state = 262, .external_lex_state = 18},
  [4268] = {.lex_state = 262, .external_lex_state = 18},
  [4269] = {.lex_state = 370, .external_lex_state = 6},
  [4270] = {.lex_state = 308, .external_lex_state = 21},
  [4271] = {.lex_state = 308, .external_lex_state = 21},
  [4272] = {.lex_state = 308, .external_lex_state = 21},
  [4273] = {.lex_state = 262, .external_lex_state = 18},
  [4274] = {.lex_state = 262, .external_lex_state = 18},
  [4275] = {.lex_state = 308, .external_lex_state = 21},
  [4276] = {.lex_state = 332, .external_lex_state = 21},
  [4277] = {.lex_state = 332, .external_lex_state = 21},
  [4278] = {.lex_state = 92, .external_lex_state = 29},
  [4279] = {.lex_state = 92, .external_lex_state = 18},
  [4280] = {.lex_state = 92, .external_lex_state = 18},
  [4281] = {.lex_state = 262, .external_lex_state = 18},
  [4282] = {.lex_state = 332, .external_lex_state = 21},
  [4283] = {.lex_state = 262, .external_lex_state = 18},
  [4284] = {.lex_state = 262, .external_lex_state = 18},
  [4285] = {.lex_state = 262, .external_lex_state = 18},
  [4286] = {.lex_state = 332, .external_lex_state = 21},
  [4287] = {.lex_state = 262, .external_lex_state = 18},
  [4288] = {.lex_state = 324, .external_lex_state = 21},
  [4289] = {.lex_state = 324, .external_lex_state = 21},
  [4290] = {.lex_state = 324, .external_lex_state = 21},
  [4291] = {.lex_state = 262, .external_lex_state = 18},
  [4292] = {.lex_state = 262, .external_lex_state = 18},
  [4293] = {.lex_state = 324, .external_lex_state = 21},
  [4294] = {.lex_state = 324, .external_lex_state = 6},
  [4295] = {.lex_state = 324, .external_lex_state = 6},
  [4296] = {.lex_state = 324, .external_lex_state = 6},
  [4297] = {.lex_state = 262, .external_lex_state = 18},
  [4298] = {.lex_state = 262, .external_lex_state = 18},
  [4299] = {.lex_state = 324, .external_lex_state = 6},
  [4300] = {.lex_state = 326, .external_lex_state = 6},
  [4301] = {.lex_state = 326, .external_lex_state = 6},
  [4302] = {.lex_state = 291, .external_lex_state = 21},
  [4303] = {.lex_state = 291, .external_lex_state = 21},
  [4304] = {.lex_state = 291, .external_lex_state = 6},
  [4305] = {.lex_state = 291, .external_lex_state = 6},
  [4306] = {.lex_state = 384, .external_lex_state = 4},
  [4307] = {.lex_state = 384, .external_lex_state = 21},
  [4308] = {.lex_state = 102},
  [4309] = {.lex_state = 384, .external_lex_state = 21},
  [4310] = {.lex_state = 384, .external_lex_state = 21},
  [4311] = {.lex_state = 217},
  [4312] = {.lex_state = 260, .external_lex_state = 18},
  [4313] = {.lex_state = 85},
  [4314] = {.lex_state = 225, .external_lex_state = 18},
  [4315] = {.lex_state = 225, .external_lex_state = 18},
  [4316] = {.lex_state = 384, .external_lex_state = 21},
  [4317] = {.lex_state = 262, .external_lex_state = 30},
  [4318] = {.lex_state = 262, .external_lex_state = 18},
  [4319] = {.lex_state = 384, .external_lex_state = 21},
  [4320] = {.lex_state = 262, .external_lex_state = 30},
  [4321] = {.lex_state = 262, .external_lex_state = 18},
  [4322] = {.lex_state = 384, .external_lex_state = 21},
  [4323] = {.lex_state = 384, .external_lex_state = 21},
  [4324] = {.lex_state = 374, .external_lex_state = 4},
  [4325] = {.lex_state = 215},
  [4326] = {.lex_state = 420, .external_lex_state = 4},
  [4327] = {.lex_state = 374, .external_lex_state = 21},
  [4328] = {.lex_state = 374, .external_lex_state = 21},
  [4329] = {.lex_state = 92, .external_lex_state = 29},
  [4330] = {.lex_state = 92, .external_lex_state = 18},
  [4331] = {.lex_state = 92, .external_lex_state = 18},
  [4332] = {.lex_state = 260, .external_lex_state = 18},
  [4333] = {.lex_state = 374, .external_lex_state = 21},
  [4334] = {.lex_state = 262, .external_lex_state = 30},
  [4335] = {.lex_state = 262, .external_lex_state = 18},
  [4336] = {.lex_state = 262, .external_lex_state = 30},
  [4337] = {.lex_state = 262, .external_lex_state = 18},
  [4338] = {.lex_state = 262, .external_lex_state = 18},
  [4339] = {.lex_state = 374, .external_lex_state = 21},
  [4340] = {.lex_state = 262, .external_lex_state = 18},
  [4341] = {.lex_state = 262, .external_lex_state = 18},
  [4342] = {.lex_state = 420, .external_lex_state = 5},
  [4343] = {.lex_state = 374, .external_lex_state = 6},
  [4344] = {.lex_state = 374, .external_lex_state = 6},
  [4345] = {.lex_state = 92, .external_lex_state = 29},
  [4346] = {.lex_state = 92, .external_lex_state = 18},
  [4347] = {.lex_state = 92, .external_lex_state = 18},
  [4348] = {.lex_state = 260, .external_lex_state = 18},
  [4349] = {.lex_state = 374, .external_lex_state = 6},
  [4350] = {.lex_state = 262, .external_lex_state = 30},
  [4351] = {.lex_state = 262, .external_lex_state = 18},
  [4352] = {.lex_state = 262, .external_lex_state = 30},
  [4353] = {.lex_state = 262, .external_lex_state = 18},
  [4354] = {.lex_state = 262, .external_lex_state = 18},
  [4355] = {.lex_state = 374, .external_lex_state = 6},
  [4356] = {.lex_state = 262, .external_lex_state = 18},
  [4357] = {.lex_state = 262, .external_lex_state = 18},
  [4358] = {.lex_state = 380, .external_lex_state = 6},
  [4359] = {.lex_state = 380, .external_lex_state = 6},
  [4360] = {.lex_state = 92, .external_lex_state = 29},
  [4361] = {.lex_state = 92, .external_lex_state = 18},
  [4362] = {.lex_state = 92, .external_lex_state = 18},
  [4363] = {.lex_state = 262, .external_lex_state = 18},
  [4364] = {.lex_state = 380, .external_lex_state = 6},
  [4365] = {.lex_state = 262, .external_lex_state = 18},
  [4366] = {.lex_state = 262, .external_lex_state = 18},
  [4367] = {.lex_state = 262, .external_lex_state = 18},
  [4368] = {.lex_state = 380, .external_lex_state = 6},
  [4369] = {.lex_state = 262, .external_lex_state = 18},
  [4370] = {.lex_state = 102},
  [4371] = {.lex_state = 343, .external_lex_state = 6},
  [4372] = {.lex_state = 146, .external_lex_state = 9},
  [4373] = {.lex_state = 102},
  [4374] = {.lex_state = 102},
  [4375] = {.lex_state = 205, .external_lex_state = 16},
  [4376] = {.lex_state = 287, .external_lex_state = 21},
  [4377] = {.lex_state = 287, .external_lex_state = 21},
  [4378] = {.lex_state = 370, .external_lex_state = 6},
  [4379] = {.lex_state = 370, .external_lex_state = 6},
  [4380] = {.lex_state = 308, .external_lex_state = 21},
  [4381] = {.lex_state = 308, .external_lex_state = 21},
  [4382] = {.lex_state = 332, .external_lex_state = 21},
  [4383] = {.lex_state = 332, .external_lex_state = 21},
  [4384] = {.lex_state = 332, .external_lex_state = 21},
  [4385] = {.lex_state = 262, .external_lex_state = 18},
  [4386] = {.lex_state = 262, .external_lex_state = 18},
  [4387] = {.lex_state = 332, .external_lex_state = 21},
  [4388] = {.lex_state = 324, .external_lex_state = 21},
  [4389] = {.lex_state = 324, .external_lex_state = 21},
  [4390] = {.lex_state = 324, .external_lex_state = 6},
  [4391] = {.lex_state = 324, .external_lex_state = 6},
  [4392] = {.lex_state = 420, .external_lex_state = 4},
  [4393] = {.lex_state = 384, .external_lex_state = 21},
  [4394] = {.lex_state = 384, .external_lex_state = 21},
  [4395] = {.lex_state = 92, .external_lex_state = 29},
  [4396] = {.lex_state = 92, .external_lex_state = 18},
  [4397] = {.lex_state = 92, .external_lex_state = 18},
  [4398] = {.lex_state = 260, .external_lex_state = 18},
  [4399] = {.lex_state = 384, .external_lex_state = 21},
  [4400] = {.lex_state = 262, .external_lex_state = 30},
  [4401] = {.lex_state = 262, .external_lex_state = 18},
  [4402] = {.lex_state = 262, .external_lex_state = 30},
  [4403] = {.lex_state = 262, .external_lex_state = 18},
  [4404] = {.lex_state = 262, .external_lex_state = 18},
  [4405] = {.lex_state = 384, .external_lex_state = 21},
  [4406] = {.lex_state = 262, .external_lex_state = 18},
  [4407] = {.lex_state = 262, .external_lex_state = 18},
  [4408] = {.lex_state = 374, .external_lex_state = 4},
  [4409] = {.lex_state = 374, .external_lex_state = 21},
  [4410] = {.lex_state = 374, .external_lex_state = 21},
  [4411] = {.lex_state = 92, .external_lex_state = 29},
  [4412] = {.lex_state = 92, .external_lex_state = 18},
  [4413] = {.lex_state = 92, .external_lex_state = 18},
  [4414] = {.lex_state = 262, .external_lex_state = 18},
  [4415] = {.lex_state = 374, .external_lex_state = 21},
  [4416] = {.lex_state = 262, .external_lex_state = 18},
  [4417] = {.lex_state = 262, .external_lex_state = 18},
  [4418] = {.lex_state = 262, .external_lex_state = 18},
  [4419] = {.lex_state = 374, .external_lex_state = 21},
  [4420] = {.lex_state = 262, .external_lex_state = 18},
  [4421] = {.lex_state = 374, .external_lex_state = 6},
  [4422] = {.lex_state = 374, .external_lex_state = 6},
  [4423] = {.lex_state = 92, .external_lex_state = 29},
  [4424] = {.lex_state = 92, .external_lex_state = 18},
  [4425] = {.lex_state = 92, .external_lex_state = 18},
  [4426] = {.lex_state = 262, .external_lex_state = 18},
  [4427] = {.lex_state = 374, .external_lex_state = 6},
  [4428] = {.lex_state = 262, .external_lex_state = 18},
  [4429] = {.lex_state = 262, .external_lex_state = 18},
  [4430] = {.lex_state = 262, .external_lex_state = 18},
  [4431] = {.lex_state = 374, .external_lex_state = 6},
  [4432] = {.lex_state = 262, .external_lex_state = 18},
  [4433] = {.lex_state = 380, .external_lex_state = 6},
  [4434] = {.lex_state = 380, .external_lex_state = 6},
  [4435] = {.lex_state = 380, .external_lex_state = 6},
  [4436] = {.lex_state = 262, .external_lex_state = 18},
  [4437] = {.lex_state = 262, .external_lex_state = 18},
  [4438] = {.lex_state = 380, .external_lex_state = 6},
  [4439] = {.lex_state = 422, .external_lex_state = 5},
  [4440] = {.lex_state = 332, .external_lex_state = 21},
  [4441] = {.lex_state = 332, .external_lex_state = 21},
  [4442] = {.lex_state = 384, .external_lex_state = 21},
  [4443] = {.lex_state = 384, .external_lex_state = 21},
  [4444] = {.lex_state = 92, .external_lex_state = 29},
  [4445] = {.lex_state = 92, .external_lex_state = 18},
  [4446] = {.lex_state = 92, .external_lex_state = 18},
  [4447] = {.lex_state = 262, .external_lex_state = 18},
  [4448] = {.lex_state = 384, .external_lex_state = 21},
  [4449] = {.lex_state = 262, .external_lex_state = 18},
  [4450] = {.lex_state = 262, .external_lex_state = 18},
  [4451] = {.lex_state = 262, .external_lex_state = 18},
  [4452] = {.lex_state = 384, .external_lex_state = 21},
  [4453] = {.lex_state = 262, .external_lex_state = 18},
  [4454] = {.lex_state = 374, .external_lex_state = 21},
  [4455] = {.lex_state = 374, .external_lex_state = 21},
  [4456] = {.lex_state = 374, .external_lex_state = 21},
  [4457] = {.lex_state = 262, .external_lex_state = 18},
  [4458] = {.lex_state = 262, .external_lex_state = 18},
  [4459] = {.lex_state = 374, .external_lex_state = 21},
  [4460] = {.lex_state = 374, .external_lex_state = 6},
  [4461] = {.lex_state = 374, .external_lex_state = 6},
  [4462] = {.lex_state = 374, .external_lex_state = 6},
  [4463] = {.lex_state = 262, .external_lex_state = 18},
  [4464] = {.lex_state = 262, .external_lex_state = 18},
  [4465] = {.lex_state = 374, .external_lex_state = 6},
  [4466] = {.lex_state = 380, .external_lex_state = 6},
  [4467] = {.lex_state = 380, .external_lex_state = 6},
  [4468] = {.lex_state = 384, .external_lex_state = 21},
  [4469] = {.lex_state = 384, .external_lex_state = 21},
  [4470] = {.lex_state = 384, .external_lex_state = 21},
  [4471] = {.lex_state = 262, .external_lex_state = 18},
  [4472] = {.lex_state = 262, .external_lex_state = 18},
  [4473] = {.lex_state = 384, .external_lex_state = 21},
  [4474] = {.lex_state = 374, .external_lex_state = 21},
  [4475] = {.lex_state = 374, .external_lex_state = 21},
  [4476] = {.lex_state = 374, .external_lex_state = 6},
  [4477] = {.lex_state = 374, .external_lex_state = 6},
  [4478] = {.lex_state = 384, .external_lex_state = 21},
  [4479] = {.lex_state = 384, .external_lex_state = 21},
};

enum {
  ts_external_token_heredoc_start,
  ts_external_token__simple_heredoc_body,
  ts_external_token__heredoc_body_beginning,
  ts_external_token__heredoc_body_middle,
  ts_external_token__heredoc_body_end,
  ts_external_token_file_descriptor,
  ts_external_token__empty_value,
  ts_external_token__concat,
  ts_external_token_variable_name,
  ts_external_token_regex,
  ts_external_token_RBRACE,
  ts_external_token_RBRACK,
  ts_external_token_LT_LT,
  ts_external_token_LT_LT_DASH,
  ts_external_token_LF,
};

static TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_heredoc_start] = sym_heredoc_start,
  [ts_external_token__simple_heredoc_body] = sym__simple_heredoc_body,
  [ts_external_token__heredoc_body_beginning] = sym__heredoc_body_beginning,
  [ts_external_token__heredoc_body_middle] = sym__heredoc_body_middle,
  [ts_external_token__heredoc_body_end] = sym__heredoc_body_end,
  [ts_external_token_file_descriptor] = sym_file_descriptor,
  [ts_external_token__empty_value] = sym__empty_value,
  [ts_external_token__concat] = sym__concat,
  [ts_external_token_variable_name] = sym_variable_name,
  [ts_external_token_regex] = sym_regex,
  [ts_external_token_RBRACE] = anon_sym_RBRACE,
  [ts_external_token_RBRACK] = anon_sym_RBRACK,
  [ts_external_token_LT_LT] = anon_sym_LT_LT,
  [ts_external_token_LT_LT_DASH] = anon_sym_LT_LT_DASH,
  [ts_external_token_LF] = anon_sym_LF,
};

static bool ts_external_scanner_states[31][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_heredoc_start] = true,
    [ts_external_token__simple_heredoc_body] = true,
    [ts_external_token__heredoc_body_beginning] = true,
    [ts_external_token__heredoc_body_middle] = true,
    [ts_external_token__heredoc_body_end] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__empty_value] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_regex] = true,
    [ts_external_token_RBRACE] = true,
    [ts_external_token_RBRACK] = true,
    [ts_external_token_LT_LT] = true,
    [ts_external_token_LT_LT_DASH] = true,
    [ts_external_token_LF] = true,
  },
  [2] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_variable_name] = true,
  },
  [3] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_RBRACE] = true,
  },
  [4] = {
    [ts_external_token__simple_heredoc_body] = true,
    [ts_external_token__heredoc_body_beginning] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_LT_LT] = true,
    [ts_external_token_LT_LT_DASH] = true,
    [ts_external_token_LF] = true,
  },
  [5] = {
    [ts_external_token__simple_heredoc_body] = true,
    [ts_external_token__heredoc_body_beginning] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_LT_LT] = true,
    [ts_external_token_LT_LT_DASH] = true,
    [ts_external_token_LF] = true,
  },
  [6] = {
    [ts_external_token__simple_heredoc_body] = true,
    [ts_external_token__heredoc_body_beginning] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_LT_LT] = true,
    [ts_external_token_LT_LT_DASH] = true,
    [ts_external_token_LF] = true,
  },
  [7] = {
    [ts_external_token_variable_name] = true,
  },
  [8] = {
    [ts_external_token__empty_value] = true,
  },
  [9] = {
    [ts_external_token_LF] = true,
  },
  [10] = {
    [ts_external_token__concat] = true,
  },
  [11] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_LT_LT] = true,
    [ts_external_token_LT_LT_DASH] = true,
    [ts_external_token_LF] = true,
  },
  [12] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_LT_LT] = true,
    [ts_external_token_LT_LT_DASH] = true,
    [ts_external_token_LF] = true,
  },
  [13] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_LT_LT] = true,
    [ts_external_token_LT_LT_DASH] = true,
    [ts_external_token_LF] = true,
  },
  [14] = {
    [ts_external_token__concat] = true,
    [ts_external_token_LF] = true,
  },
  [15] = {
    [ts_external_token__simple_heredoc_body] = true,
    [ts_external_token__heredoc_body_beginning] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_RBRACE] = true,
    [ts_external_token_LT_LT] = true,
    [ts_external_token_LT_LT_DASH] = true,
    [ts_external_token_LF] = true,
  },
  [16] = {
    [ts_external_token__simple_heredoc_body] = true,
    [ts_external_token__heredoc_body_beginning] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_RBRACE] = true,
    [ts_external_token_LT_LT] = true,
    [ts_external_token_LT_LT_DASH] = true,
    [ts_external_token_LF] = true,
  },
  [17] = {
    [ts_external_token__simple_heredoc_body] = true,
    [ts_external_token__heredoc_body_beginning] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_RBRACE] = true,
    [ts_external_token_LT_LT] = true,
    [ts_external_token_LT_LT_DASH] = true,
    [ts_external_token_LF] = true,
  },
  [18] = {
    [ts_external_token_RBRACE] = true,
  },
  [19] = {
    [ts_external_token__concat] = true,
    [ts_external_token_RBRACK] = true,
  },
  [20] = {
    [ts_external_token_RBRACK] = true,
  },
  [21] = {
    [ts_external_token__simple_heredoc_body] = true,
    [ts_external_token__heredoc_body_beginning] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_LT_LT] = true,
    [ts_external_token_LT_LT_DASH] = true,
    [ts_external_token_LF] = true,
  },
  [22] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_variable_name] = true,
  },
  [23] = {
    [ts_external_token__heredoc_body_middle] = true,
    [ts_external_token__heredoc_body_end] = true,
  },
  [24] = {
    [ts_external_token_heredoc_start] = true,
  },
  [25] = {
    [ts_external_token_regex] = true,
  },
  [26] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_LT_LT] = true,
    [ts_external_token_LT_LT_DASH] = true,
    [ts_external_token_LF] = true,
  },
  [27] = {
    [ts_external_token__simple_heredoc_body] = true,
    [ts_external_token__heredoc_body_beginning] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_RBRACE] = true,
    [ts_external_token_LT_LT] = true,
    [ts_external_token_LT_LT_DASH] = true,
    [ts_external_token_LF] = true,
  },
  [28] = {
    [ts_external_token_RBRACE] = true,
    [ts_external_token_LF] = true,
  },
  [29] = {
    [ts_external_token__concat] = true,
    [ts_external_token_RBRACE] = true,
  },
  [30] = {
    [ts_external_token_regex] = true,
    [ts_external_token_RBRACE] = true,
  },
};

static uint16_t ts_parse_table[STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_heredoc_start] = ACTIONS(1),
    [sym__simple_heredoc_body] = ACTIONS(1),
    [sym__heredoc_body_beginning] = ACTIONS(1),
    [sym__heredoc_body_middle] = ACTIONS(1),
    [sym__heredoc_body_end] = ACTIONS(1),
    [sym_file_descriptor] = ACTIONS(1),
    [sym__empty_value] = ACTIONS(1),
    [sym__concat] = ACTIONS(1),
    [sym_variable_name] = ACTIONS(1),
    [sym_regex] = ACTIONS(1),
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(3),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_fi] = ACTIONS(1),
    [anon_sym_elif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_esac] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(3),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_SEMI_SEMI] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(3),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_PIPE_AMP] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(3),
    [anon_sym_RBRACK] = ACTIONS(3),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(1),
    [anon_sym_declare] = ACTIONS(1),
    [anon_sym_typeset] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_readonly] = ACTIONS(1),
    [anon_sym_local] = ACTIONS(1),
    [anon_sym_unset] = ACTIONS(3),
    [anon_sym_unsetenv] = ACTIONS(1),
    [anon_sym_EQ_TILDE] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(3),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(3),
    [anon_sym_GT] = ACTIONS(3),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_AMP_GT] = ACTIONS(3),
    [anon_sym_AMP_GT_GT] = ACTIONS(1),
    [anon_sym_LT_AMP] = ACTIONS(1),
    [anon_sym_GT_AMP] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(3),
    [anon_sym_LT_LT_DASH] = ACTIONS(1),
    [anon_sym_LT_LT_LT] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(3),
    [anon_sym_DASH] = ACTIONS(3),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(3),
    [sym__special_character] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_raw_string] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(3),
    [anon_sym_COLON_QMARK] = ACTIONS(1),
    [anon_sym_COLON_DASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_LT_LPAREN] = ACTIONS(1),
    [anon_sym_GT_LPAREN] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_0] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [sym_test_operator] = ACTIONS(1),
    [anon_sym_LF] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(3),
  },
  [1] = {
    [sym_program] = STATE(27),
    [sym__statements] = STATE(28),
    [sym_redirected_statement] = STATE(29),
    [sym_for_statement] = STATE(29),
    [sym_c_style_for_statement] = STATE(29),
    [sym_while_statement] = STATE(29),
    [sym_if_statement] = STATE(29),
    [sym_case_statement] = STATE(29),
    [sym_function_definition] = STATE(29),
    [sym_compound_statement] = STATE(29),
    [sym_subshell] = STATE(29),
    [sym_pipeline] = STATE(29),
    [sym_list] = STATE(29),
    [sym_negated_command] = STATE(29),
    [sym_test_command] = STATE(29),
    [sym_declaration_command] = STATE(29),
    [sym_unset_command] = STATE(29),
    [sym_command] = STATE(29),
    [sym_command_name] = STATE(30),
    [sym_variable_assignment] = STATE(31),
    [sym_subscript] = STATE(32),
    [sym_file_redirect] = STATE(35),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(21),
    [sym_simple_expansion] = STATE(21),
    [sym_string_expansion] = STATE(21),
    [sym_expansion] = STATE(21),
    [sym_command_substitution] = STATE(21),
    [sym_process_substitution] = STATE(21),
    [aux_sym__statements_repeat1] = STATE(34),
    [aux_sym_command_repeat1] = STATE(35),
    [aux_sym__literal_repeat1] = STATE(36),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(7),
    [ts_builtin_sym_end] = ACTIONS(9),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(33),
    [anon_sym_typeset] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(33),
    [anon_sym_readonly] = ACTIONS(33),
    [anon_sym_local] = ACTIONS(33),
    [anon_sym_unset] = ACTIONS(35),
    [anon_sym_unsetenv] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(43),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(47),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(59),
  },
  [2] = {
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(61),
    [anon_sym_GT_GT] = ACTIONS(63),
    [anon_sym_AMP_GT] = ACTIONS(61),
    [anon_sym_AMP_GT_GT] = ACTIONS(63),
    [anon_sym_LT_AMP] = ACTIONS(63),
    [anon_sym_GT_AMP] = ACTIONS(63),
    [sym_comment] = ACTIONS(57),
  },
  [3] = {
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_EQ] = ACTIONS(67),
    [anon_sym_PLUS_EQ] = ACTIONS(67),
    [sym_comment] = ACTIONS(57),
  },
  [4] = {
    [anon_sym_LPAREN_LPAREN] = ACTIONS(69),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(71),
  },
  [5] = {
    [sym__expression] = STATE(52),
    [sym_binary_expression] = STATE(52),
    [sym_unary_expression] = STATE(52),
    [sym_postfix_expression] = STATE(52),
    [sym_parenthesized_expression] = STATE(52),
    [sym_concatenation] = STATE(52),
    [sym_string] = STATE(47),
    [sym_simple_expansion] = STATE(47),
    [sym_string_expansion] = STATE(47),
    [sym_expansion] = STATE(47),
    [sym_command_substitution] = STATE(47),
    [sym_process_substitution] = STATE(47),
    [aux_sym__literal_repeat1] = STATE(53),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [sym__special_character] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [sym_raw_string] = ACTIONS(83),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(85),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [anon_sym_LT_LPAREN] = ACTIONS(91),
    [anon_sym_GT_LPAREN] = ACTIONS(91),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(93),
    [sym_test_operator] = ACTIONS(95),
  },
  [6] = {
    [sym__terminated_statement] = STATE(77),
    [sym_redirected_statement] = STATE(78),
    [sym_for_statement] = STATE(78),
    [sym_c_style_for_statement] = STATE(78),
    [sym_while_statement] = STATE(78),
    [sym_if_statement] = STATE(78),
    [sym_case_statement] = STATE(78),
    [sym_function_definition] = STATE(78),
    [sym_compound_statement] = STATE(78),
    [sym_subshell] = STATE(78),
    [sym_pipeline] = STATE(78),
    [sym_list] = STATE(78),
    [sym_negated_command] = STATE(78),
    [sym_test_command] = STATE(78),
    [sym_declaration_command] = STATE(78),
    [sym_unset_command] = STATE(78),
    [sym_command] = STATE(78),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(80),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(83),
    [sym_concatenation] = STATE(82),
    [sym_string] = STATE(71),
    [sym_simple_expansion] = STATE(71),
    [sym_string_expansion] = STATE(71),
    [sym_expansion] = STATE(71),
    [sym_command_substitution] = STATE(71),
    [sym_process_substitution] = STATE(71),
    [aux_sym_command_repeat1] = STATE(83),
    [aux_sym__literal_repeat1] = STATE(84),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(103),
    [anon_sym_if] = ACTIONS(105),
    [anon_sym_case] = ACTIONS(107),
    [anon_sym_function] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [sym__special_character] = ACTIONS(127),
    [anon_sym_DQUOTE] = ACTIONS(129),
    [sym_raw_string] = ACTIONS(131),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(133),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(135),
    [anon_sym_BQUOTE] = ACTIONS(137),
    [anon_sym_LT_LPAREN] = ACTIONS(139),
    [anon_sym_GT_LPAREN] = ACTIONS(139),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(141),
  },
  [7] = {
    [sym__terminated_statement] = STATE(85),
    [sym_redirected_statement] = STATE(78),
    [sym_for_statement] = STATE(78),
    [sym_c_style_for_statement] = STATE(78),
    [sym_while_statement] = STATE(78),
    [sym_if_statement] = STATE(78),
    [sym_case_statement] = STATE(78),
    [sym_function_definition] = STATE(78),
    [sym_compound_statement] = STATE(78),
    [sym_subshell] = STATE(78),
    [sym_pipeline] = STATE(78),
    [sym_list] = STATE(78),
    [sym_negated_command] = STATE(78),
    [sym_test_command] = STATE(78),
    [sym_declaration_command] = STATE(78),
    [sym_unset_command] = STATE(78),
    [sym_command] = STATE(78),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(80),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(83),
    [sym_concatenation] = STATE(82),
    [sym_string] = STATE(71),
    [sym_simple_expansion] = STATE(71),
    [sym_string_expansion] = STATE(71),
    [sym_expansion] = STATE(71),
    [sym_command_substitution] = STATE(71),
    [sym_process_substitution] = STATE(71),
    [aux_sym_command_repeat1] = STATE(83),
    [aux_sym__literal_repeat1] = STATE(84),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(103),
    [anon_sym_if] = ACTIONS(105),
    [anon_sym_case] = ACTIONS(107),
    [anon_sym_function] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [sym__special_character] = ACTIONS(127),
    [anon_sym_DQUOTE] = ACTIONS(129),
    [sym_raw_string] = ACTIONS(131),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(133),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(135),
    [anon_sym_BQUOTE] = ACTIONS(137),
    [anon_sym_LT_LPAREN] = ACTIONS(139),
    [anon_sym_GT_LPAREN] = ACTIONS(139),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(141),
  },
  [8] = {
    [sym_concatenation] = STATE(94),
    [sym_string] = STATE(89),
    [sym_simple_expansion] = STATE(89),
    [sym_string_expansion] = STATE(89),
    [sym_expansion] = STATE(89),
    [sym_command_substitution] = STATE(89),
    [sym_process_substitution] = STATE(89),
    [aux_sym__literal_repeat1] = STATE(95),
    [anon_sym_DOLLAR] = ACTIONS(143),
    [sym__special_character] = ACTIONS(145),
    [anon_sym_DQUOTE] = ACTIONS(147),
    [sym_raw_string] = ACTIONS(149),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(151),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(153),
    [anon_sym_BQUOTE] = ACTIONS(155),
    [anon_sym_LT_LPAREN] = ACTIONS(157),
    [anon_sym_GT_LPAREN] = ACTIONS(157),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(149),
  },
  [9] = {
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(159),
  },
  [10] = {
    [sym__statements] = STATE(104),
    [sym_redirected_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_c_style_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_case_statement] = STATE(105),
    [sym_function_definition] = STATE(105),
    [sym_compound_statement] = STATE(105),
    [sym_subshell] = STATE(105),
    [sym_pipeline] = STATE(105),
    [sym_list] = STATE(105),
    [sym_negated_command] = STATE(105),
    [sym_test_command] = STATE(105),
    [sym_declaration_command] = STATE(105),
    [sym_unset_command] = STATE(105),
    [sym_command] = STATE(105),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(107),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(110),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(109),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [11] = {
    [sym__statements] = STATE(136),
    [sym_redirected_statement] = STATE(137),
    [sym_for_statement] = STATE(137),
    [sym_c_style_for_statement] = STATE(137),
    [sym_while_statement] = STATE(137),
    [sym_if_statement] = STATE(137),
    [sym_case_statement] = STATE(137),
    [sym_function_definition] = STATE(137),
    [sym_compound_statement] = STATE(137),
    [sym_subshell] = STATE(137),
    [sym_pipeline] = STATE(137),
    [sym_list] = STATE(137),
    [sym_negated_command] = STATE(137),
    [sym_test_command] = STATE(137),
    [sym_declaration_command] = STATE(137),
    [sym_unset_command] = STATE(137),
    [sym_command] = STATE(137),
    [sym_command_name] = STATE(138),
    [sym_variable_assignment] = STATE(139),
    [sym_subscript] = STATE(140),
    [sym_file_redirect] = STATE(143),
    [sym_concatenation] = STATE(141),
    [sym_string] = STATE(130),
    [sym_simple_expansion] = STATE(130),
    [sym_string_expansion] = STATE(130),
    [sym_expansion] = STATE(130),
    [sym_command_substitution] = STATE(130),
    [sym_process_substitution] = STATE(130),
    [aux_sym__statements_repeat1] = STATE(142),
    [aux_sym_command_repeat1] = STATE(143),
    [aux_sym__literal_repeat1] = STATE(144),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(175),
    [anon_sym_for] = ACTIONS(177),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(179),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_case] = ACTIONS(185),
    [anon_sym_function] = ACTIONS(187),
    [anon_sym_LPAREN] = ACTIONS(189),
    [anon_sym_LBRACE] = ACTIONS(191),
    [anon_sym_RBRACE] = ACTIONS(193),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LBRACK] = ACTIONS(197),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(199),
    [anon_sym_declare] = ACTIONS(201),
    [anon_sym_typeset] = ACTIONS(201),
    [anon_sym_export] = ACTIONS(201),
    [anon_sym_readonly] = ACTIONS(201),
    [anon_sym_local] = ACTIONS(201),
    [anon_sym_unset] = ACTIONS(203),
    [anon_sym_unsetenv] = ACTIONS(203),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(205),
    [sym__special_character] = ACTIONS(207),
    [anon_sym_DQUOTE] = ACTIONS(209),
    [sym_raw_string] = ACTIONS(211),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(213),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(215),
    [anon_sym_BQUOTE] = ACTIONS(217),
    [anon_sym_LT_LPAREN] = ACTIONS(219),
    [anon_sym_GT_LPAREN] = ACTIONS(219),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(221),
  },
  [12] = {
    [sym_subshell] = STATE(146),
    [sym_test_command] = STATE(146),
    [sym_command] = STATE(146),
    [sym_command_name] = STATE(30),
    [sym_variable_assignment] = STATE(35),
    [sym_subscript] = STATE(147),
    [sym_file_redirect] = STATE(35),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(21),
    [sym_simple_expansion] = STATE(21),
    [sym_string_expansion] = STATE(21),
    [sym_expansion] = STATE(21),
    [sym_command_substitution] = STATE(21),
    [sym_process_substitution] = STATE(21),
    [aux_sym_command_repeat1] = STATE(35),
    [aux_sym__literal_repeat1] = STATE(36),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(223),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(43),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(47),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(47),
  },
  [13] = {
    [sym__expression] = STATE(158),
    [sym_binary_expression] = STATE(158),
    [sym_unary_expression] = STATE(158),
    [sym_postfix_expression] = STATE(158),
    [sym_parenthesized_expression] = STATE(158),
    [sym_concatenation] = STATE(158),
    [sym_string] = STATE(153),
    [sym_simple_expansion] = STATE(153),
    [sym_string_expansion] = STATE(153),
    [sym_expansion] = STATE(153),
    [sym_command_substitution] = STATE(153),
    [sym_process_substitution] = STATE(153),
    [aux_sym__literal_repeat1] = STATE(159),
    [anon_sym_LPAREN] = ACTIONS(225),
    [anon_sym_BANG] = ACTIONS(227),
    [anon_sym_DOLLAR] = ACTIONS(229),
    [sym__special_character] = ACTIONS(231),
    [anon_sym_DQUOTE] = ACTIONS(233),
    [sym_raw_string] = ACTIONS(235),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(237),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(239),
    [anon_sym_BQUOTE] = ACTIONS(241),
    [anon_sym_LT_LPAREN] = ACTIONS(243),
    [anon_sym_GT_LPAREN] = ACTIONS(243),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(245),
    [sym_test_operator] = ACTIONS(247),
  },
  [14] = {
    [sym__expression] = STATE(163),
    [sym_binary_expression] = STATE(163),
    [sym_unary_expression] = STATE(163),
    [sym_postfix_expression] = STATE(163),
    [sym_parenthesized_expression] = STATE(163),
    [sym_concatenation] = STATE(163),
    [sym_string] = STATE(162),
    [sym_simple_expansion] = STATE(162),
    [sym_string_expansion] = STATE(162),
    [sym_expansion] = STATE(162),
    [sym_command_substitution] = STATE(162),
    [sym_process_substitution] = STATE(162),
    [aux_sym__literal_repeat1] = STATE(164),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(249),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [sym__special_character] = ACTIONS(251),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [sym_raw_string] = ACTIONS(253),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(85),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [anon_sym_LT_LPAREN] = ACTIONS(91),
    [anon_sym_GT_LPAREN] = ACTIONS(91),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(255),
    [sym_test_operator] = ACTIONS(257),
  },
  [15] = {
    [sym_variable_assignment] = STATE(175),
    [sym_subscript] = STATE(174),
    [sym_concatenation] = STATE(175),
    [sym_string] = STATE(169),
    [sym_simple_expansion] = STATE(169),
    [sym_string_expansion] = STATE(169),
    [sym_expansion] = STATE(169),
    [sym_command_substitution] = STATE(169),
    [sym_process_substitution] = STATE(169),
    [aux_sym_declaration_command_repeat1] = STATE(175),
    [aux_sym__literal_repeat1] = STATE(176),
    [sym__simple_heredoc_body] = ACTIONS(259),
    [sym__heredoc_body_beginning] = ACTIONS(259),
    [sym_file_descriptor] = ACTIONS(259),
    [sym_variable_name] = ACTIONS(261),
    [ts_builtin_sym_end] = ACTIONS(259),
    [anon_sym_SEMI] = ACTIONS(263),
    [anon_sym_PIPE] = ACTIONS(263),
    [anon_sym_SEMI_SEMI] = ACTIONS(259),
    [anon_sym_PIPE_AMP] = ACTIONS(259),
    [anon_sym_AMP_AMP] = ACTIONS(259),
    [anon_sym_PIPE_PIPE] = ACTIONS(259),
    [anon_sym_LT] = ACTIONS(263),
    [anon_sym_GT] = ACTIONS(263),
    [anon_sym_GT_GT] = ACTIONS(259),
    [anon_sym_AMP_GT] = ACTIONS(263),
    [anon_sym_AMP_GT_GT] = ACTIONS(259),
    [anon_sym_LT_AMP] = ACTIONS(259),
    [anon_sym_GT_AMP] = ACTIONS(259),
    [anon_sym_LT_LT] = ACTIONS(263),
    [anon_sym_LT_LT_DASH] = ACTIONS(259),
    [anon_sym_LT_LT_LT] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(265),
    [sym__special_character] = ACTIONS(267),
    [anon_sym_DQUOTE] = ACTIONS(269),
    [sym_raw_string] = ACTIONS(271),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(273),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(275),
    [anon_sym_BQUOTE] = ACTIONS(277),
    [anon_sym_LT_LPAREN] = ACTIONS(279),
    [anon_sym_GT_LPAREN] = ACTIONS(279),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(281),
    [sym_word] = ACTIONS(283),
    [anon_sym_LF] = ACTIONS(259),
    [anon_sym_AMP] = ACTIONS(263),
  },
  [16] = {
    [sym_concatenation] = STATE(185),
    [sym_string] = STATE(180),
    [sym_simple_expansion] = STATE(180),
    [sym_string_expansion] = STATE(180),
    [sym_expansion] = STATE(180),
    [sym_command_substitution] = STATE(180),
    [sym_process_substitution] = STATE(180),
    [aux_sym_unset_command_repeat1] = STATE(185),
    [aux_sym__literal_repeat1] = STATE(186),
    [sym__simple_heredoc_body] = ACTIONS(285),
    [sym__heredoc_body_beginning] = ACTIONS(285),
    [sym_file_descriptor] = ACTIONS(285),
    [ts_builtin_sym_end] = ACTIONS(285),
    [anon_sym_SEMI] = ACTIONS(287),
    [anon_sym_PIPE] = ACTIONS(287),
    [anon_sym_SEMI_SEMI] = ACTIONS(285),
    [anon_sym_PIPE_AMP] = ACTIONS(285),
    [anon_sym_AMP_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(285),
    [anon_sym_LT] = ACTIONS(287),
    [anon_sym_GT] = ACTIONS(287),
    [anon_sym_GT_GT] = ACTIONS(285),
    [anon_sym_AMP_GT] = ACTIONS(287),
    [anon_sym_AMP_GT_GT] = ACTIONS(285),
    [anon_sym_LT_AMP] = ACTIONS(285),
    [anon_sym_GT_AMP] = ACTIONS(285),
    [anon_sym_LT_LT] = ACTIONS(287),
    [anon_sym_LT_LT_DASH] = ACTIONS(285),
    [anon_sym_LT_LT_LT] = ACTIONS(285),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym__special_character] = ACTIONS(291),
    [anon_sym_DQUOTE] = ACTIONS(293),
    [sym_raw_string] = ACTIONS(295),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(297),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(299),
    [anon_sym_BQUOTE] = ACTIONS(301),
    [anon_sym_LT_LPAREN] = ACTIONS(303),
    [anon_sym_GT_LPAREN] = ACTIONS(303),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(305),
    [sym_word] = ACTIONS(307),
    [anon_sym_LF] = ACTIONS(285),
    [anon_sym_AMP] = ACTIONS(287),
  },
  [17] = {
    [sym_concatenation] = STATE(195),
    [sym_string] = STATE(190),
    [sym_simple_expansion] = STATE(190),
    [sym_string_expansion] = STATE(190),
    [sym_expansion] = STATE(190),
    [sym_command_substitution] = STATE(190),
    [sym_process_substitution] = STATE(190),
    [aux_sym__literal_repeat1] = STATE(196),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [sym__special_character] = ACTIONS(311),
    [anon_sym_DQUOTE] = ACTIONS(313),
    [sym_raw_string] = ACTIONS(315),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(317),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(319),
    [anon_sym_BQUOTE] = ACTIONS(321),
    [anon_sym_LT_LPAREN] = ACTIONS(323),
    [anon_sym_GT_LPAREN] = ACTIONS(323),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(315),
  },
  [18] = {
    [sym_string] = STATE(198),
    [anon_sym_DASH] = ACTIONS(325),
    [anon_sym_DOLLAR] = ACTIONS(325),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(327),
    [anon_sym_POUND] = ACTIONS(325),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(331),
    [anon_sym_STAR] = ACTIONS(333),
    [anon_sym_AT] = ACTIONS(333),
    [anon_sym_QMARK] = ACTIONS(333),
    [anon_sym_0] = ACTIONS(331),
    [anon_sym__] = ACTIONS(331),
  },
  [19] = {
    [aux_sym_concatenation_repeat1] = STATE(201),
    [sym__simple_heredoc_body] = ACTIONS(335),
    [sym__heredoc_body_beginning] = ACTIONS(335),
    [sym_file_descriptor] = ACTIONS(335),
    [sym__concat] = ACTIONS(337),
    [ts_builtin_sym_end] = ACTIONS(335),
    [anon_sym_SEMI] = ACTIONS(339),
    [anon_sym_PIPE] = ACTIONS(339),
    [anon_sym_SEMI_SEMI] = ACTIONS(335),
    [anon_sym_PIPE_AMP] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_PIPE_PIPE] = ACTIONS(335),
    [anon_sym_EQ_TILDE] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_LT] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(339),
    [anon_sym_GT_GT] = ACTIONS(335),
    [anon_sym_AMP_GT] = ACTIONS(339),
    [anon_sym_AMP_GT_GT] = ACTIONS(335),
    [anon_sym_LT_AMP] = ACTIONS(335),
    [anon_sym_GT_AMP] = ACTIONS(335),
    [anon_sym_LT_LT] = ACTIONS(339),
    [anon_sym_LT_LT_DASH] = ACTIONS(335),
    [anon_sym_LT_LT_LT] = ACTIONS(335),
    [anon_sym_DOLLAR] = ACTIONS(339),
    [sym__special_character] = ACTIONS(335),
    [anon_sym_DQUOTE] = ACTIONS(335),
    [sym_raw_string] = ACTIONS(335),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(335),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(335),
    [anon_sym_LT_LPAREN] = ACTIONS(335),
    [anon_sym_GT_LPAREN] = ACTIONS(335),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(339),
    [anon_sym_LF] = ACTIONS(335),
    [anon_sym_AMP] = ACTIONS(339),
  },
  [20] = {
    [sym_simple_expansion] = STATE(204),
    [sym_expansion] = STATE(204),
    [sym_command_substitution] = STATE(204),
    [aux_sym_string_repeat1] = STATE(208),
    [anon_sym_DOLLAR] = ACTIONS(341),
    [anon_sym_DQUOTE] = ACTIONS(343),
    [sym__string_content] = ACTIONS(345),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(347),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(329),
  },
  [21] = {
    [aux_sym_concatenation_repeat1] = STATE(201),
    [sym__simple_heredoc_body] = ACTIONS(353),
    [sym__heredoc_body_beginning] = ACTIONS(353),
    [sym_file_descriptor] = ACTIONS(353),
    [sym__concat] = ACTIONS(337),
    [ts_builtin_sym_end] = ACTIONS(353),
    [anon_sym_SEMI] = ACTIONS(355),
    [anon_sym_PIPE] = ACTIONS(355),
    [anon_sym_SEMI_SEMI] = ACTIONS(353),
    [anon_sym_PIPE_AMP] = ACTIONS(353),
    [anon_sym_AMP_AMP] = ACTIONS(353),
    [anon_sym_PIPE_PIPE] = ACTIONS(353),
    [anon_sym_EQ_TILDE] = ACTIONS(355),
    [anon_sym_EQ_EQ] = ACTIONS(355),
    [anon_sym_LT] = ACTIONS(355),
    [anon_sym_GT] = ACTIONS(355),
    [anon_sym_GT_GT] = ACTIONS(353),
    [anon_sym_AMP_GT] = ACTIONS(355),
    [anon_sym_AMP_GT_GT] = ACTIONS(353),
    [anon_sym_LT_AMP] = ACTIONS(353),
    [anon_sym_GT_AMP] = ACTIONS(353),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(353),
    [anon_sym_LT_LT_LT] = ACTIONS(353),
    [anon_sym_DOLLAR] = ACTIONS(355),
    [sym__special_character] = ACTIONS(353),
    [anon_sym_DQUOTE] = ACTIONS(353),
    [sym_raw_string] = ACTIONS(353),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(353),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [anon_sym_LT_LPAREN] = ACTIONS(353),
    [anon_sym_GT_LPAREN] = ACTIONS(353),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(355),
    [anon_sym_LF] = ACTIONS(353),
    [anon_sym_AMP] = ACTIONS(355),
  },
  [22] = {
    [sym_subscript] = STATE(212),
    [sym_variable_name] = ACTIONS(357),
    [anon_sym_BANG] = ACTIONS(359),
    [anon_sym_DASH] = ACTIONS(361),
    [anon_sym_DOLLAR] = ACTIONS(361),
    [anon_sym_POUND] = ACTIONS(359),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(363),
    [anon_sym_STAR] = ACTIONS(365),
    [anon_sym_AT] = ACTIONS(365),
    [anon_sym_QMARK] = ACTIONS(365),
    [anon_sym_0] = ACTIONS(363),
    [anon_sym__] = ACTIONS(363),
  },
  [23] = {
    [sym__statements] = STATE(215),
    [sym_redirected_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_c_style_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_case_statement] = STATE(105),
    [sym_function_definition] = STATE(105),
    [sym_compound_statement] = STATE(105),
    [sym_subshell] = STATE(105),
    [sym_pipeline] = STATE(105),
    [sym_list] = STATE(105),
    [sym_negated_command] = STATE(105),
    [sym_test_command] = STATE(105),
    [sym_declaration_command] = STATE(105),
    [sym_unset_command] = STATE(105),
    [sym_command] = STATE(105),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(107),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(216),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(109),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(371),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(371),
    [anon_sym_LT_AMP] = ACTIONS(371),
    [anon_sym_GT_AMP] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [24] = {
    [sym__statements] = STATE(224),
    [sym_redirected_statement] = STATE(225),
    [sym_for_statement] = STATE(225),
    [sym_c_style_for_statement] = STATE(225),
    [sym_while_statement] = STATE(225),
    [sym_if_statement] = STATE(225),
    [sym_case_statement] = STATE(225),
    [sym_function_definition] = STATE(225),
    [sym_compound_statement] = STATE(225),
    [sym_subshell] = STATE(225),
    [sym_pipeline] = STATE(225),
    [sym_list] = STATE(225),
    [sym_negated_command] = STATE(225),
    [sym_test_command] = STATE(225),
    [sym_declaration_command] = STATE(225),
    [sym_unset_command] = STATE(225),
    [sym_command] = STATE(225),
    [sym_command_name] = STATE(226),
    [sym_variable_assignment] = STATE(227),
    [sym_subscript] = STATE(228),
    [sym_file_redirect] = STATE(230),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(222),
    [sym_simple_expansion] = STATE(222),
    [sym_string_expansion] = STATE(222),
    [sym_expansion] = STATE(222),
    [sym_command_substitution] = STATE(222),
    [sym_process_substitution] = STATE(222),
    [aux_sym__statements_repeat1] = STATE(229),
    [aux_sym_command_repeat1] = STATE(230),
    [aux_sym__literal_repeat1] = STATE(231),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(375),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_typeset] = ACTIONS(377),
    [anon_sym_export] = ACTIONS(377),
    [anon_sym_readonly] = ACTIONS(377),
    [anon_sym_local] = ACTIONS(377),
    [anon_sym_unset] = ACTIONS(379),
    [anon_sym_unsetenv] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(381),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(383),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(385),
  },
  [25] = {
    [sym__statements] = STATE(232),
    [sym_redirected_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_c_style_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_case_statement] = STATE(105),
    [sym_function_definition] = STATE(105),
    [sym_compound_statement] = STATE(105),
    [sym_subshell] = STATE(105),
    [sym_pipeline] = STATE(105),
    [sym_list] = STATE(105),
    [sym_negated_command] = STATE(105),
    [sym_test_command] = STATE(105),
    [sym_declaration_command] = STATE(105),
    [sym_unset_command] = STATE(105),
    [sym_command] = STATE(105),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(107),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(110),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(109),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [26] = {
    [aux_sym_concatenation_repeat1] = STATE(201),
    [sym__simple_heredoc_body] = ACTIONS(353),
    [sym__heredoc_body_beginning] = ACTIONS(353),
    [sym_file_descriptor] = ACTIONS(353),
    [sym__concat] = ACTIONS(337),
    [ts_builtin_sym_end] = ACTIONS(353),
    [anon_sym_SEMI] = ACTIONS(355),
    [anon_sym_PIPE] = ACTIONS(355),
    [anon_sym_SEMI_SEMI] = ACTIONS(353),
    [anon_sym_LPAREN] = ACTIONS(387),
    [anon_sym_PIPE_AMP] = ACTIONS(353),
    [anon_sym_AMP_AMP] = ACTIONS(353),
    [anon_sym_PIPE_PIPE] = ACTIONS(353),
    [anon_sym_EQ_TILDE] = ACTIONS(355),
    [anon_sym_EQ_EQ] = ACTIONS(355),
    [anon_sym_LT] = ACTIONS(355),
    [anon_sym_GT] = ACTIONS(355),
    [anon_sym_GT_GT] = ACTIONS(353),
    [anon_sym_AMP_GT] = ACTIONS(355),
    [anon_sym_AMP_GT_GT] = ACTIONS(353),
    [anon_sym_LT_AMP] = ACTIONS(353),
    [anon_sym_GT_AMP] = ACTIONS(353),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(353),
    [anon_sym_LT_LT_LT] = ACTIONS(353),
    [anon_sym_DOLLAR] = ACTIONS(355),
    [sym__special_character] = ACTIONS(353),
    [anon_sym_DQUOTE] = ACTIONS(353),
    [sym_raw_string] = ACTIONS(353),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(353),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [anon_sym_LT_LPAREN] = ACTIONS(353),
    [anon_sym_GT_LPAREN] = ACTIONS(353),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(355),
    [anon_sym_LF] = ACTIONS(353),
    [anon_sym_AMP] = ACTIONS(355),
  },
  [27] = {
    [ts_builtin_sym_end] = ACTIONS(389),
    [sym_comment] = ACTIONS(57),
  },
  [28] = {
    [ts_builtin_sym_end] = ACTIONS(391),
    [sym_comment] = ACTIONS(57),
  },
  [29] = {
    [sym_file_redirect] = STATE(244),
    [sym_heredoc_redirect] = STATE(244),
    [sym_heredoc_body] = STATE(243),
    [sym_herestring_redirect] = STATE(244),
    [aux_sym_redirected_statement_repeat1] = STATE(244),
    [sym__simple_heredoc_body] = ACTIONS(393),
    [sym__heredoc_body_beginning] = ACTIONS(395),
    [sym_file_descriptor] = ACTIONS(397),
    [ts_builtin_sym_end] = ACTIONS(399),
    [anon_sym_SEMI] = ACTIONS(401),
    [anon_sym_PIPE] = ACTIONS(403),
    [anon_sym_SEMI_SEMI] = ACTIONS(405),
    [anon_sym_PIPE_AMP] = ACTIONS(407),
    [anon_sym_AMP_AMP] = ACTIONS(409),
    [anon_sym_PIPE_PIPE] = ACTIONS(409),
    [anon_sym_LT] = ACTIONS(411),
    [anon_sym_GT] = ACTIONS(411),
    [anon_sym_GT_GT] = ACTIONS(413),
    [anon_sym_AMP_GT] = ACTIONS(411),
    [anon_sym_AMP_GT_GT] = ACTIONS(413),
    [anon_sym_LT_AMP] = ACTIONS(413),
    [anon_sym_GT_AMP] = ACTIONS(413),
    [anon_sym_LT_LT] = ACTIONS(415),
    [anon_sym_LT_LT_DASH] = ACTIONS(417),
    [anon_sym_LT_LT_LT] = ACTIONS(419),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(405),
    [anon_sym_AMP] = ACTIONS(401),
  },
  [30] = {
    [sym_concatenation] = STATE(247),
    [sym_string] = STATE(246),
    [sym_simple_expansion] = STATE(246),
    [sym_string_expansion] = STATE(246),
    [sym_expansion] = STATE(246),
    [sym_command_substitution] = STATE(246),
    [sym_process_substitution] = STATE(246),
    [aux_sym_command_repeat2] = STATE(247),
    [aux_sym__literal_repeat1] = STATE(248),
    [sym__simple_heredoc_body] = ACTIONS(421),
    [sym__heredoc_body_beginning] = ACTIONS(421),
    [sym_file_descriptor] = ACTIONS(421),
    [ts_builtin_sym_end] = ACTIONS(421),
    [anon_sym_SEMI] = ACTIONS(423),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_SEMI_SEMI] = ACTIONS(421),
    [anon_sym_PIPE_AMP] = ACTIONS(421),
    [anon_sym_AMP_AMP] = ACTIONS(421),
    [anon_sym_PIPE_PIPE] = ACTIONS(421),
    [anon_sym_EQ_TILDE] = ACTIONS(425),
    [anon_sym_EQ_EQ] = ACTIONS(425),
    [anon_sym_LT] = ACTIONS(423),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(421),
    [anon_sym_AMP_GT] = ACTIONS(423),
    [anon_sym_AMP_GT_GT] = ACTIONS(421),
    [anon_sym_LT_AMP] = ACTIONS(421),
    [anon_sym_GT_AMP] = ACTIONS(421),
    [anon_sym_LT_LT] = ACTIONS(423),
    [anon_sym_LT_LT_DASH] = ACTIONS(421),
    [anon_sym_LT_LT_LT] = ACTIONS(421),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(427),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(429),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(431),
    [anon_sym_LF] = ACTIONS(421),
    [anon_sym_AMP] = ACTIONS(423),
  },
  [31] = {
    [sym_file_redirect] = STATE(244),
    [sym_heredoc_redirect] = STATE(244),
    [sym_heredoc_body] = STATE(243),
    [sym_herestring_redirect] = STATE(244),
    [aux_sym_redirected_statement_repeat1] = STATE(244),
    [sym__simple_heredoc_body] = ACTIONS(393),
    [sym__heredoc_body_beginning] = ACTIONS(395),
    [sym_file_descriptor] = ACTIONS(433),
    [sym_variable_name] = ACTIONS(433),
    [ts_builtin_sym_end] = ACTIONS(399),
    [anon_sym_SEMI] = ACTIONS(401),
    [anon_sym_PIPE] = ACTIONS(403),
    [anon_sym_SEMI_SEMI] = ACTIONS(405),
    [anon_sym_PIPE_AMP] = ACTIONS(407),
    [anon_sym_AMP_AMP] = ACTIONS(409),
    [anon_sym_PIPE_PIPE] = ACTIONS(409),
    [anon_sym_LT] = ACTIONS(435),
    [anon_sym_GT] = ACTIONS(435),
    [anon_sym_GT_GT] = ACTIONS(433),
    [anon_sym_AMP_GT] = ACTIONS(435),
    [anon_sym_AMP_GT_GT] = ACTIONS(433),
    [anon_sym_LT_AMP] = ACTIONS(433),
    [anon_sym_GT_AMP] = ACTIONS(433),
    [anon_sym_LT_LT] = ACTIONS(415),
    [anon_sym_LT_LT_DASH] = ACTIONS(417),
    [anon_sym_LT_LT_LT] = ACTIONS(419),
    [anon_sym_DOLLAR] = ACTIONS(435),
    [sym__special_character] = ACTIONS(433),
    [anon_sym_DQUOTE] = ACTIONS(433),
    [sym_raw_string] = ACTIONS(433),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(433),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(433),
    [anon_sym_BQUOTE] = ACTIONS(433),
    [anon_sym_LT_LPAREN] = ACTIONS(433),
    [anon_sym_GT_LPAREN] = ACTIONS(433),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(435),
    [anon_sym_LF] = ACTIONS(405),
    [anon_sym_AMP] = ACTIONS(401),
  },
  [32] = {
    [anon_sym_EQ] = ACTIONS(67),
    [anon_sym_PLUS_EQ] = ACTIONS(67),
    [sym_comment] = ACTIONS(57),
  },
  [33] = {
    [sym__simple_heredoc_body] = ACTIONS(353),
    [sym__heredoc_body_beginning] = ACTIONS(353),
    [sym_file_descriptor] = ACTIONS(353),
    [ts_builtin_sym_end] = ACTIONS(353),
    [anon_sym_SEMI] = ACTIONS(355),
    [anon_sym_PIPE] = ACTIONS(355),
    [anon_sym_RPAREN] = ACTIONS(353),
    [anon_sym_SEMI_SEMI] = ACTIONS(353),
    [anon_sym_PIPE_AMP] = ACTIONS(353),
    [anon_sym_AMP_AMP] = ACTIONS(353),
    [anon_sym_PIPE_PIPE] = ACTIONS(353),
    [anon_sym_EQ_TILDE] = ACTIONS(355),
    [anon_sym_EQ_EQ] = ACTIONS(355),
    [anon_sym_LT] = ACTIONS(355),
    [anon_sym_GT] = ACTIONS(355),
    [anon_sym_GT_GT] = ACTIONS(353),
    [anon_sym_AMP_GT] = ACTIONS(355),
    [anon_sym_AMP_GT_GT] = ACTIONS(353),
    [anon_sym_LT_AMP] = ACTIONS(353),
    [anon_sym_GT_AMP] = ACTIONS(353),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(353),
    [anon_sym_LT_LT_LT] = ACTIONS(353),
    [anon_sym_DOLLAR] = ACTIONS(355),
    [sym__special_character] = ACTIONS(353),
    [anon_sym_DQUOTE] = ACTIONS(353),
    [sym_raw_string] = ACTIONS(353),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(353),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [anon_sym_LT_LPAREN] = ACTIONS(353),
    [anon_sym_GT_LPAREN] = ACTIONS(353),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(355),
    [anon_sym_LF] = ACTIONS(353),
    [anon_sym_AMP] = ACTIONS(355),
  },
  [34] = {
    [sym_redirected_statement] = STATE(249),
    [sym_for_statement] = STATE(249),
    [sym_c_style_for_statement] = STATE(249),
    [sym_while_statement] = STATE(249),
    [sym_if_statement] = STATE(249),
    [sym_case_statement] = STATE(249),
    [sym_function_definition] = STATE(249),
    [sym_compound_statement] = STATE(249),
    [sym_subshell] = STATE(249),
    [sym_pipeline] = STATE(249),
    [sym_list] = STATE(249),
    [sym_negated_command] = STATE(249),
    [sym_test_command] = STATE(249),
    [sym_declaration_command] = STATE(249),
    [sym_unset_command] = STATE(249),
    [sym_command] = STATE(249),
    [sym_command_name] = STATE(30),
    [sym_variable_assignment] = STATE(250),
    [sym_subscript] = STATE(32),
    [sym_file_redirect] = STATE(35),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(21),
    [sym_simple_expansion] = STATE(21),
    [sym_string_expansion] = STATE(21),
    [sym_expansion] = STATE(21),
    [sym_command_substitution] = STATE(21),
    [sym_process_substitution] = STATE(21),
    [aux_sym__statements_repeat1] = STATE(251),
    [aux_sym_command_repeat1] = STATE(35),
    [aux_sym__literal_repeat1] = STATE(36),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(33),
    [anon_sym_typeset] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(33),
    [anon_sym_readonly] = ACTIONS(33),
    [anon_sym_local] = ACTIONS(33),
    [anon_sym_unset] = ACTIONS(35),
    [anon_sym_unsetenv] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(43),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(47),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(59),
  },
  [35] = {
    [sym_command_name] = STATE(252),
    [sym_variable_assignment] = STATE(253),
    [sym_subscript] = STATE(147),
    [sym_file_redirect] = STATE(253),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(21),
    [sym_simple_expansion] = STATE(21),
    [sym_string_expansion] = STATE(21),
    [sym_expansion] = STATE(21),
    [sym_command_substitution] = STATE(21),
    [sym_process_substitution] = STATE(21),
    [aux_sym_command_repeat1] = STATE(253),
    [aux_sym__literal_repeat1] = STATE(36),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(223),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(427),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(47),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(47),
  },
  [36] = {
    [aux_sym__literal_repeat1] = STATE(255),
    [sym__simple_heredoc_body] = ACTIONS(437),
    [sym__heredoc_body_beginning] = ACTIONS(437),
    [sym_file_descriptor] = ACTIONS(437),
    [ts_builtin_sym_end] = ACTIONS(437),
    [anon_sym_SEMI] = ACTIONS(439),
    [anon_sym_PIPE] = ACTIONS(439),
    [anon_sym_SEMI_SEMI] = ACTIONS(437),
    [anon_sym_PIPE_AMP] = ACTIONS(437),
    [anon_sym_AMP_AMP] = ACTIONS(437),
    [anon_sym_PIPE_PIPE] = ACTIONS(437),
    [anon_sym_EQ_TILDE] = ACTIONS(439),
    [anon_sym_EQ_EQ] = ACTIONS(439),
    [anon_sym_LT] = ACTIONS(439),
    [anon_sym_GT] = ACTIONS(439),
    [anon_sym_GT_GT] = ACTIONS(437),
    [anon_sym_AMP_GT] = ACTIONS(439),
    [anon_sym_AMP_GT_GT] = ACTIONS(437),
    [anon_sym_LT_AMP] = ACTIONS(437),
    [anon_sym_GT_AMP] = ACTIONS(437),
    [anon_sym_LT_LT] = ACTIONS(439),
    [anon_sym_LT_LT_DASH] = ACTIONS(437),
    [anon_sym_LT_LT_LT] = ACTIONS(437),
    [anon_sym_DOLLAR] = ACTIONS(439),
    [sym__special_character] = ACTIONS(441),
    [anon_sym_DQUOTE] = ACTIONS(437),
    [sym_raw_string] = ACTIONS(437),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(437),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(437),
    [anon_sym_BQUOTE] = ACTIONS(437),
    [anon_sym_LT_LPAREN] = ACTIONS(437),
    [anon_sym_GT_LPAREN] = ACTIONS(437),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(439),
    [anon_sym_LF] = ACTIONS(437),
    [anon_sym_AMP] = ACTIONS(439),
  },
  [37] = {
    [sym_concatenation] = STATE(257),
    [sym_string] = STATE(256),
    [sym_simple_expansion] = STATE(256),
    [sym_string_expansion] = STATE(256),
    [sym_expansion] = STATE(256),
    [sym_command_substitution] = STATE(256),
    [sym_process_substitution] = STATE(256),
    [aux_sym__literal_repeat1] = STATE(258),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [sym__special_character] = ACTIONS(311),
    [anon_sym_DQUOTE] = ACTIONS(313),
    [sym_raw_string] = ACTIONS(443),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(317),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(319),
    [anon_sym_BQUOTE] = ACTIONS(321),
    [anon_sym_LT_LPAREN] = ACTIONS(323),
    [anon_sym_GT_LPAREN] = ACTIONS(323),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(443),
  },
  [38] = {
    [sym_concatenation] = STATE(261),
    [sym_string] = STATE(260),
    [sym_simple_expansion] = STATE(260),
    [sym_string_expansion] = STATE(260),
    [sym_expansion] = STATE(260),
    [sym_command_substitution] = STATE(260),
    [sym_process_substitution] = STATE(260),
    [aux_sym__literal_repeat1] = STATE(262),
    [anon_sym_DOLLAR] = ACTIONS(229),
    [sym__special_character] = ACTIONS(445),
    [anon_sym_DQUOTE] = ACTIONS(233),
    [sym_raw_string] = ACTIONS(447),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(237),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(239),
    [anon_sym_BQUOTE] = ACTIONS(241),
    [anon_sym_LT_LPAREN] = ACTIONS(243),
    [anon_sym_GT_LPAREN] = ACTIONS(243),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(447),
  },
  [39] = {
    [sym_concatenation] = STATE(263),
    [sym_string] = STATE(268),
    [sym_array] = STATE(263),
    [sym_simple_expansion] = STATE(268),
    [sym_string_expansion] = STATE(268),
    [sym_expansion] = STATE(268),
    [sym_command_substitution] = STATE(268),
    [sym_process_substitution] = STATE(268),
    [aux_sym__literal_repeat1] = STATE(273),
    [sym__empty_value] = ACTIONS(449),
    [anon_sym_LPAREN] = ACTIONS(451),
    [anon_sym_DOLLAR] = ACTIONS(453),
    [sym__special_character] = ACTIONS(455),
    [anon_sym_DQUOTE] = ACTIONS(457),
    [sym_raw_string] = ACTIONS(459),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(461),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(463),
    [anon_sym_BQUOTE] = ACTIONS(465),
    [anon_sym_LT_LPAREN] = ACTIONS(467),
    [anon_sym_GT_LPAREN] = ACTIONS(467),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(459),
  },
  [40] = {
    [sym__expression] = STATE(285),
    [sym_binary_expression] = STATE(285),
    [sym_unary_expression] = STATE(285),
    [sym_postfix_expression] = STATE(285),
    [sym_parenthesized_expression] = STATE(285),
    [sym_concatenation] = STATE(285),
    [sym_string] = STATE(280),
    [sym_simple_expansion] = STATE(280),
    [sym_string_expansion] = STATE(280),
    [sym_expansion] = STATE(280),
    [sym_command_substitution] = STATE(280),
    [sym_process_substitution] = STATE(280),
    [aux_sym__literal_repeat1] = STATE(286),
    [anon_sym_SEMI] = ACTIONS(469),
    [anon_sym_SEMI_SEMI] = ACTIONS(471),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_BANG] = ACTIONS(475),
    [anon_sym_DOLLAR] = ACTIONS(477),
    [sym__special_character] = ACTIONS(479),
    [anon_sym_DQUOTE] = ACTIONS(481),
    [sym_raw_string] = ACTIONS(483),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(485),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(487),
    [anon_sym_BQUOTE] = ACTIONS(489),
    [anon_sym_LT_LPAREN] = ACTIONS(491),
    [anon_sym_GT_LPAREN] = ACTIONS(491),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(493),
    [sym_test_operator] = ACTIONS(495),
    [anon_sym_LF] = ACTIONS(471),
    [anon_sym_AMP] = ACTIONS(471),
  },
  [41] = {
    [anon_sym_in] = ACTIONS(497),
    [anon_sym_SEMI] = ACTIONS(499),
    [anon_sym_SEMI_SEMI] = ACTIONS(501),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(501),
    [anon_sym_AMP] = ACTIONS(501),
  },
  [42] = {
    [sym__expression] = STATE(299),
    [sym_binary_expression] = STATE(299),
    [sym_unary_expression] = STATE(299),
    [sym_postfix_expression] = STATE(299),
    [sym_parenthesized_expression] = STATE(299),
    [sym_concatenation] = STATE(299),
    [sym_string] = STATE(294),
    [sym_simple_expansion] = STATE(294),
    [sym_string_expansion] = STATE(294),
    [sym_expansion] = STATE(294),
    [sym_command_substitution] = STATE(294),
    [sym_process_substitution] = STATE(294),
    [aux_sym__literal_repeat1] = STATE(300),
    [anon_sym_LPAREN] = ACTIONS(503),
    [anon_sym_BANG] = ACTIONS(505),
    [anon_sym_DOLLAR] = ACTIONS(507),
    [sym__special_character] = ACTIONS(509),
    [anon_sym_DQUOTE] = ACTIONS(511),
    [sym_raw_string] = ACTIONS(513),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(515),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(517),
    [anon_sym_BQUOTE] = ACTIONS(519),
    [anon_sym_LT_LPAREN] = ACTIONS(521),
    [anon_sym_GT_LPAREN] = ACTIONS(521),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(523),
    [sym_test_operator] = ACTIONS(525),
  },
  [43] = {
    [sym__expression] = STATE(301),
    [sym_binary_expression] = STATE(301),
    [sym_unary_expression] = STATE(301),
    [sym_postfix_expression] = STATE(301),
    [sym_parenthesized_expression] = STATE(301),
    [sym_concatenation] = STATE(301),
    [sym_string] = STATE(47),
    [sym_simple_expansion] = STATE(47),
    [sym_string_expansion] = STATE(47),
    [sym_expansion] = STATE(47),
    [sym_command_substitution] = STATE(47),
    [sym_process_substitution] = STATE(47),
    [aux_sym__literal_repeat1] = STATE(53),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [sym__special_character] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [sym_raw_string] = ACTIONS(83),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(85),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [anon_sym_LT_LPAREN] = ACTIONS(91),
    [anon_sym_GT_LPAREN] = ACTIONS(91),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(93),
    [sym_test_operator] = ACTIONS(95),
  },
  [44] = {
    [sym_string] = STATE(303),
    [anon_sym_DASH] = ACTIONS(527),
    [anon_sym_DOLLAR] = ACTIONS(527),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [sym_raw_string] = ACTIONS(529),
    [anon_sym_POUND] = ACTIONS(527),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(531),
    [anon_sym_STAR] = ACTIONS(533),
    [anon_sym_AT] = ACTIONS(533),
    [anon_sym_QMARK] = ACTIONS(533),
    [anon_sym_0] = ACTIONS(531),
    [anon_sym__] = ACTIONS(531),
  },
  [45] = {
    [aux_sym_concatenation_repeat1] = STATE(306),
    [sym__concat] = ACTIONS(535),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_PIPE_PIPE] = ACTIONS(335),
    [anon_sym_EQ_TILDE] = ACTIONS(335),
    [anon_sym_EQ_EQ] = ACTIONS(335),
    [anon_sym_EQ] = ACTIONS(339),
    [anon_sym_PLUS_EQ] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(335),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_DASH_EQ] = ACTIONS(335),
    [anon_sym_LT_EQ] = ACTIONS(335),
    [anon_sym_GT_EQ] = ACTIONS(335),
    [anon_sym_PLUS_PLUS] = ACTIONS(335),
    [anon_sym_DASH_DASH] = ACTIONS(335),
    [sym__special_character] = ACTIONS(335),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(335),
  },
  [46] = {
    [sym_simple_expansion] = STATE(204),
    [sym_expansion] = STATE(204),
    [sym_command_substitution] = STATE(204),
    [aux_sym_string_repeat1] = STATE(309),
    [anon_sym_DOLLAR] = ACTIONS(537),
    [anon_sym_DQUOTE] = ACTIONS(539),
    [sym__string_content] = ACTIONS(345),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(347),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(329),
  },
  [47] = {
    [aux_sym_concatenation_repeat1] = STATE(306),
    [sym__concat] = ACTIONS(535),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(541),
    [anon_sym_AMP_AMP] = ACTIONS(541),
    [anon_sym_PIPE_PIPE] = ACTIONS(541),
    [anon_sym_EQ_TILDE] = ACTIONS(541),
    [anon_sym_EQ_EQ] = ACTIONS(541),
    [anon_sym_EQ] = ACTIONS(543),
    [anon_sym_PLUS_EQ] = ACTIONS(541),
    [anon_sym_LT] = ACTIONS(543),
    [anon_sym_GT] = ACTIONS(543),
    [anon_sym_BANG_EQ] = ACTIONS(541),
    [anon_sym_PLUS] = ACTIONS(543),
    [anon_sym_DASH] = ACTIONS(543),
    [anon_sym_DASH_EQ] = ACTIONS(541),
    [anon_sym_LT_EQ] = ACTIONS(541),
    [anon_sym_GT_EQ] = ACTIONS(541),
    [anon_sym_PLUS_PLUS] = ACTIONS(541),
    [anon_sym_DASH_DASH] = ACTIONS(541),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(541),
  },
  [48] = {
    [sym_subscript] = STATE(313),
    [sym_variable_name] = ACTIONS(545),
    [anon_sym_BANG] = ACTIONS(547),
    [anon_sym_DASH] = ACTIONS(549),
    [anon_sym_DOLLAR] = ACTIONS(549),
    [anon_sym_POUND] = ACTIONS(547),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(551),
    [anon_sym_STAR] = ACTIONS(553),
    [anon_sym_AT] = ACTIONS(553),
    [anon_sym_QMARK] = ACTIONS(553),
    [anon_sym_0] = ACTIONS(551),
    [anon_sym__] = ACTIONS(551),
  },
  [49] = {
    [sym__statements] = STATE(314),
    [sym_redirected_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_c_style_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_case_statement] = STATE(105),
    [sym_function_definition] = STATE(105),
    [sym_compound_statement] = STATE(105),
    [sym_subshell] = STATE(105),
    [sym_pipeline] = STATE(105),
    [sym_list] = STATE(105),
    [sym_negated_command] = STATE(105),
    [sym_test_command] = STATE(105),
    [sym_declaration_command] = STATE(105),
    [sym_unset_command] = STATE(105),
    [sym_command] = STATE(105),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(107),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(315),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(109),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(371),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(371),
    [anon_sym_LT_AMP] = ACTIONS(371),
    [anon_sym_GT_AMP] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [50] = {
    [sym__statements] = STATE(316),
    [sym_redirected_statement] = STATE(225),
    [sym_for_statement] = STATE(225),
    [sym_c_style_for_statement] = STATE(225),
    [sym_while_statement] = STATE(225),
    [sym_if_statement] = STATE(225),
    [sym_case_statement] = STATE(225),
    [sym_function_definition] = STATE(225),
    [sym_compound_statement] = STATE(225),
    [sym_subshell] = STATE(225),
    [sym_pipeline] = STATE(225),
    [sym_list] = STATE(225),
    [sym_negated_command] = STATE(225),
    [sym_test_command] = STATE(225),
    [sym_declaration_command] = STATE(225),
    [sym_unset_command] = STATE(225),
    [sym_command] = STATE(225),
    [sym_command_name] = STATE(226),
    [sym_variable_assignment] = STATE(227),
    [sym_subscript] = STATE(228),
    [sym_file_redirect] = STATE(230),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(222),
    [sym_simple_expansion] = STATE(222),
    [sym_string_expansion] = STATE(222),
    [sym_expansion] = STATE(222),
    [sym_command_substitution] = STATE(222),
    [sym_process_substitution] = STATE(222),
    [aux_sym__statements_repeat1] = STATE(229),
    [aux_sym_command_repeat1] = STATE(230),
    [aux_sym__literal_repeat1] = STATE(231),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(375),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_typeset] = ACTIONS(377),
    [anon_sym_export] = ACTIONS(377),
    [anon_sym_readonly] = ACTIONS(377),
    [anon_sym_local] = ACTIONS(377),
    [anon_sym_unset] = ACTIONS(379),
    [anon_sym_unsetenv] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(381),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(383),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(385),
  },
  [51] = {
    [sym__statements] = STATE(317),
    [sym_redirected_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_c_style_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_case_statement] = STATE(105),
    [sym_function_definition] = STATE(105),
    [sym_compound_statement] = STATE(105),
    [sym_subshell] = STATE(105),
    [sym_pipeline] = STATE(105),
    [sym_list] = STATE(105),
    [sym_negated_command] = STATE(105),
    [sym_test_command] = STATE(105),
    [sym_declaration_command] = STATE(105),
    [sym_unset_command] = STATE(105),
    [sym_command] = STATE(105),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(107),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(110),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(109),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [52] = {
    [anon_sym_RPAREN_RPAREN] = ACTIONS(555),
    [anon_sym_AMP_AMP] = ACTIONS(557),
    [anon_sym_PIPE_PIPE] = ACTIONS(557),
    [anon_sym_EQ_TILDE] = ACTIONS(559),
    [anon_sym_EQ_EQ] = ACTIONS(559),
    [anon_sym_EQ] = ACTIONS(561),
    [anon_sym_PLUS_EQ] = ACTIONS(557),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_GT] = ACTIONS(561),
    [anon_sym_BANG_EQ] = ACTIONS(557),
    [anon_sym_PLUS] = ACTIONS(561),
    [anon_sym_DASH] = ACTIONS(561),
    [anon_sym_DASH_EQ] = ACTIONS(557),
    [anon_sym_LT_EQ] = ACTIONS(557),
    [anon_sym_GT_EQ] = ACTIONS(557),
    [anon_sym_PLUS_PLUS] = ACTIONS(563),
    [anon_sym_DASH_DASH] = ACTIONS(563),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(557),
  },
  [53] = {
    [aux_sym__literal_repeat1] = STATE(323),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(565),
    [anon_sym_AMP_AMP] = ACTIONS(565),
    [anon_sym_PIPE_PIPE] = ACTIONS(565),
    [anon_sym_EQ_TILDE] = ACTIONS(565),
    [anon_sym_EQ_EQ] = ACTIONS(565),
    [anon_sym_EQ] = ACTIONS(567),
    [anon_sym_PLUS_EQ] = ACTIONS(565),
    [anon_sym_LT] = ACTIONS(567),
    [anon_sym_GT] = ACTIONS(567),
    [anon_sym_BANG_EQ] = ACTIONS(565),
    [anon_sym_PLUS] = ACTIONS(567),
    [anon_sym_DASH] = ACTIONS(567),
    [anon_sym_DASH_EQ] = ACTIONS(565),
    [anon_sym_LT_EQ] = ACTIONS(565),
    [anon_sym_GT_EQ] = ACTIONS(565),
    [anon_sym_PLUS_PLUS] = ACTIONS(565),
    [anon_sym_DASH_DASH] = ACTIONS(565),
    [sym__special_character] = ACTIONS(569),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(565),
  },
  [54] = {
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_EQ] = ACTIONS(571),
    [anon_sym_PLUS_EQ] = ACTIONS(571),
    [sym_comment] = ACTIONS(57),
  },
  [55] = {
    [anon_sym_LPAREN_LPAREN] = ACTIONS(573),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(575),
  },
  [56] = {
    [sym__expression] = STATE(327),
    [sym_binary_expression] = STATE(327),
    [sym_unary_expression] = STATE(327),
    [sym_postfix_expression] = STATE(327),
    [sym_parenthesized_expression] = STATE(327),
    [sym_concatenation] = STATE(327),
    [sym_string] = STATE(47),
    [sym_simple_expansion] = STATE(47),
    [sym_string_expansion] = STATE(47),
    [sym_expansion] = STATE(47),
    [sym_command_substitution] = STATE(47),
    [sym_process_substitution] = STATE(47),
    [aux_sym__literal_repeat1] = STATE(53),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [sym__special_character] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [sym_raw_string] = ACTIONS(83),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(85),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [anon_sym_LT_LPAREN] = ACTIONS(91),
    [anon_sym_GT_LPAREN] = ACTIONS(91),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(93),
    [sym_test_operator] = ACTIONS(95),
  },
  [57] = {
    [sym__terminated_statement] = STATE(328),
    [sym_redirected_statement] = STATE(78),
    [sym_for_statement] = STATE(78),
    [sym_c_style_for_statement] = STATE(78),
    [sym_while_statement] = STATE(78),
    [sym_if_statement] = STATE(78),
    [sym_case_statement] = STATE(78),
    [sym_function_definition] = STATE(78),
    [sym_compound_statement] = STATE(78),
    [sym_subshell] = STATE(78),
    [sym_pipeline] = STATE(78),
    [sym_list] = STATE(78),
    [sym_negated_command] = STATE(78),
    [sym_test_command] = STATE(78),
    [sym_declaration_command] = STATE(78),
    [sym_unset_command] = STATE(78),
    [sym_command] = STATE(78),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(80),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(83),
    [sym_concatenation] = STATE(82),
    [sym_string] = STATE(71),
    [sym_simple_expansion] = STATE(71),
    [sym_string_expansion] = STATE(71),
    [sym_expansion] = STATE(71),
    [sym_command_substitution] = STATE(71),
    [sym_process_substitution] = STATE(71),
    [aux_sym_command_repeat1] = STATE(83),
    [aux_sym__literal_repeat1] = STATE(84),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(103),
    [anon_sym_if] = ACTIONS(105),
    [anon_sym_case] = ACTIONS(107),
    [anon_sym_function] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [sym__special_character] = ACTIONS(127),
    [anon_sym_DQUOTE] = ACTIONS(129),
    [sym_raw_string] = ACTIONS(131),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(133),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(135),
    [anon_sym_BQUOTE] = ACTIONS(137),
    [anon_sym_LT_LPAREN] = ACTIONS(139),
    [anon_sym_GT_LPAREN] = ACTIONS(139),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(141),
  },
  [58] = {
    [sym__terminated_statement] = STATE(329),
    [sym_redirected_statement] = STATE(78),
    [sym_for_statement] = STATE(78),
    [sym_c_style_for_statement] = STATE(78),
    [sym_while_statement] = STATE(78),
    [sym_if_statement] = STATE(78),
    [sym_case_statement] = STATE(78),
    [sym_function_definition] = STATE(78),
    [sym_compound_statement] = STATE(78),
    [sym_subshell] = STATE(78),
    [sym_pipeline] = STATE(78),
    [sym_list] = STATE(78),
    [sym_negated_command] = STATE(78),
    [sym_test_command] = STATE(78),
    [sym_declaration_command] = STATE(78),
    [sym_unset_command] = STATE(78),
    [sym_command] = STATE(78),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(80),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(83),
    [sym_concatenation] = STATE(82),
    [sym_string] = STATE(71),
    [sym_simple_expansion] = STATE(71),
    [sym_string_expansion] = STATE(71),
    [sym_expansion] = STATE(71),
    [sym_command_substitution] = STATE(71),
    [sym_process_substitution] = STATE(71),
    [aux_sym_command_repeat1] = STATE(83),
    [aux_sym__literal_repeat1] = STATE(84),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(103),
    [anon_sym_if] = ACTIONS(105),
    [anon_sym_case] = ACTIONS(107),
    [anon_sym_function] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [sym__special_character] = ACTIONS(127),
    [anon_sym_DQUOTE] = ACTIONS(129),
    [sym_raw_string] = ACTIONS(131),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(133),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(135),
    [anon_sym_BQUOTE] = ACTIONS(137),
    [anon_sym_LT_LPAREN] = ACTIONS(139),
    [anon_sym_GT_LPAREN] = ACTIONS(139),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(141),
  },
  [59] = {
    [sym_concatenation] = STATE(331),
    [sym_string] = STATE(330),
    [sym_simple_expansion] = STATE(330),
    [sym_string_expansion] = STATE(330),
    [sym_expansion] = STATE(330),
    [sym_command_substitution] = STATE(330),
    [sym_process_substitution] = STATE(330),
    [aux_sym__literal_repeat1] = STATE(332),
    [anon_sym_DOLLAR] = ACTIONS(143),
    [sym__special_character] = ACTIONS(145),
    [anon_sym_DQUOTE] = ACTIONS(147),
    [sym_raw_string] = ACTIONS(577),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(151),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(153),
    [anon_sym_BQUOTE] = ACTIONS(155),
    [anon_sym_LT_LPAREN] = ACTIONS(157),
    [anon_sym_GT_LPAREN] = ACTIONS(157),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(577),
  },
  [60] = {
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(579),
  },
  [61] = {
    [sym__statements] = STATE(334),
    [sym_redirected_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_c_style_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_case_statement] = STATE(105),
    [sym_function_definition] = STATE(105),
    [sym_compound_statement] = STATE(105),
    [sym_subshell] = STATE(105),
    [sym_pipeline] = STATE(105),
    [sym_list] = STATE(105),
    [sym_negated_command] = STATE(105),
    [sym_test_command] = STATE(105),
    [sym_declaration_command] = STATE(105),
    [sym_unset_command] = STATE(105),
    [sym_command] = STATE(105),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(107),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(110),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(109),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [62] = {
    [sym__statements] = STATE(336),
    [sym_redirected_statement] = STATE(137),
    [sym_for_statement] = STATE(137),
    [sym_c_style_for_statement] = STATE(137),
    [sym_while_statement] = STATE(137),
    [sym_if_statement] = STATE(137),
    [sym_case_statement] = STATE(137),
    [sym_function_definition] = STATE(137),
    [sym_compound_statement] = STATE(137),
    [sym_subshell] = STATE(137),
    [sym_pipeline] = STATE(137),
    [sym_list] = STATE(137),
    [sym_negated_command] = STATE(137),
    [sym_test_command] = STATE(137),
    [sym_declaration_command] = STATE(137),
    [sym_unset_command] = STATE(137),
    [sym_command] = STATE(137),
    [sym_command_name] = STATE(138),
    [sym_variable_assignment] = STATE(139),
    [sym_subscript] = STATE(140),
    [sym_file_redirect] = STATE(143),
    [sym_concatenation] = STATE(141),
    [sym_string] = STATE(130),
    [sym_simple_expansion] = STATE(130),
    [sym_string_expansion] = STATE(130),
    [sym_expansion] = STATE(130),
    [sym_command_substitution] = STATE(130),
    [sym_process_substitution] = STATE(130),
    [aux_sym__statements_repeat1] = STATE(142),
    [aux_sym_command_repeat1] = STATE(143),
    [aux_sym__literal_repeat1] = STATE(144),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(175),
    [anon_sym_for] = ACTIONS(177),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(179),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_case] = ACTIONS(185),
    [anon_sym_function] = ACTIONS(187),
    [anon_sym_LPAREN] = ACTIONS(189),
    [anon_sym_LBRACE] = ACTIONS(191),
    [anon_sym_RBRACE] = ACTIONS(581),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LBRACK] = ACTIONS(197),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(199),
    [anon_sym_declare] = ACTIONS(201),
    [anon_sym_typeset] = ACTIONS(201),
    [anon_sym_export] = ACTIONS(201),
    [anon_sym_readonly] = ACTIONS(201),
    [anon_sym_local] = ACTIONS(201),
    [anon_sym_unset] = ACTIONS(203),
    [anon_sym_unsetenv] = ACTIONS(203),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(205),
    [sym__special_character] = ACTIONS(207),
    [anon_sym_DQUOTE] = ACTIONS(209),
    [sym_raw_string] = ACTIONS(211),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(213),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(215),
    [anon_sym_BQUOTE] = ACTIONS(217),
    [anon_sym_LT_LPAREN] = ACTIONS(219),
    [anon_sym_GT_LPAREN] = ACTIONS(219),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(221),
  },
  [63] = {
    [sym_subshell] = STATE(337),
    [sym_test_command] = STATE(337),
    [sym_command] = STATE(337),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(83),
    [sym_subscript] = STATE(147),
    [sym_file_redirect] = STATE(83),
    [sym_concatenation] = STATE(82),
    [sym_string] = STATE(71),
    [sym_simple_expansion] = STATE(71),
    [sym_string_expansion] = STATE(71),
    [sym_expansion] = STATE(71),
    [sym_command_substitution] = STATE(71),
    [sym_process_substitution] = STATE(71),
    [aux_sym_command_repeat1] = STATE(83),
    [aux_sym__literal_repeat1] = STATE(84),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(223),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(101),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [sym__special_character] = ACTIONS(127),
    [anon_sym_DQUOTE] = ACTIONS(129),
    [sym_raw_string] = ACTIONS(131),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(133),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(135),
    [anon_sym_BQUOTE] = ACTIONS(137),
    [anon_sym_LT_LPAREN] = ACTIONS(139),
    [anon_sym_GT_LPAREN] = ACTIONS(139),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(131),
  },
  [64] = {
    [sym__expression] = STATE(338),
    [sym_binary_expression] = STATE(338),
    [sym_unary_expression] = STATE(338),
    [sym_postfix_expression] = STATE(338),
    [sym_parenthesized_expression] = STATE(338),
    [sym_concatenation] = STATE(338),
    [sym_string] = STATE(153),
    [sym_simple_expansion] = STATE(153),
    [sym_string_expansion] = STATE(153),
    [sym_expansion] = STATE(153),
    [sym_command_substitution] = STATE(153),
    [sym_process_substitution] = STATE(153),
    [aux_sym__literal_repeat1] = STATE(159),
    [anon_sym_LPAREN] = ACTIONS(225),
    [anon_sym_BANG] = ACTIONS(227),
    [anon_sym_DOLLAR] = ACTIONS(229),
    [sym__special_character] = ACTIONS(231),
    [anon_sym_DQUOTE] = ACTIONS(233),
    [sym_raw_string] = ACTIONS(235),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(237),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(239),
    [anon_sym_BQUOTE] = ACTIONS(241),
    [anon_sym_LT_LPAREN] = ACTIONS(243),
    [anon_sym_GT_LPAREN] = ACTIONS(243),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(245),
    [sym_test_operator] = ACTIONS(247),
  },
  [65] = {
    [sym__expression] = STATE(339),
    [sym_binary_expression] = STATE(339),
    [sym_unary_expression] = STATE(339),
    [sym_postfix_expression] = STATE(339),
    [sym_parenthesized_expression] = STATE(339),
    [sym_concatenation] = STATE(339),
    [sym_string] = STATE(162),
    [sym_simple_expansion] = STATE(162),
    [sym_string_expansion] = STATE(162),
    [sym_expansion] = STATE(162),
    [sym_command_substitution] = STATE(162),
    [sym_process_substitution] = STATE(162),
    [aux_sym__literal_repeat1] = STATE(164),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(249),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [sym__special_character] = ACTIONS(251),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [sym_raw_string] = ACTIONS(253),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(85),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [anon_sym_LT_LPAREN] = ACTIONS(91),
    [anon_sym_GT_LPAREN] = ACTIONS(91),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(255),
    [sym_test_operator] = ACTIONS(257),
  },
  [66] = {
    [sym_variable_assignment] = STATE(350),
    [sym_subscript] = STATE(349),
    [sym_concatenation] = STATE(350),
    [sym_string] = STATE(344),
    [sym_simple_expansion] = STATE(344),
    [sym_string_expansion] = STATE(344),
    [sym_expansion] = STATE(344),
    [sym_command_substitution] = STATE(344),
    [sym_process_substitution] = STATE(344),
    [aux_sym_declaration_command_repeat1] = STATE(350),
    [aux_sym__literal_repeat1] = STATE(351),
    [sym_file_descriptor] = ACTIONS(259),
    [sym_variable_name] = ACTIONS(583),
    [anon_sym_SEMI] = ACTIONS(263),
    [anon_sym_PIPE] = ACTIONS(263),
    [anon_sym_SEMI_SEMI] = ACTIONS(259),
    [anon_sym_PIPE_AMP] = ACTIONS(259),
    [anon_sym_AMP_AMP] = ACTIONS(259),
    [anon_sym_PIPE_PIPE] = ACTIONS(259),
    [anon_sym_LT] = ACTIONS(263),
    [anon_sym_GT] = ACTIONS(263),
    [anon_sym_GT_GT] = ACTIONS(259),
    [anon_sym_AMP_GT] = ACTIONS(263),
    [anon_sym_AMP_GT_GT] = ACTIONS(259),
    [anon_sym_LT_AMP] = ACTIONS(259),
    [anon_sym_GT_AMP] = ACTIONS(259),
    [anon_sym_LT_LT] = ACTIONS(263),
    [anon_sym_LT_LT_DASH] = ACTIONS(259),
    [anon_sym_LT_LT_LT] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(585),
    [sym__special_character] = ACTIONS(587),
    [anon_sym_DQUOTE] = ACTIONS(589),
    [sym_raw_string] = ACTIONS(591),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(593),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(595),
    [anon_sym_BQUOTE] = ACTIONS(597),
    [anon_sym_LT_LPAREN] = ACTIONS(599),
    [anon_sym_GT_LPAREN] = ACTIONS(599),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(601),
    [sym_word] = ACTIONS(603),
    [anon_sym_LF] = ACTIONS(259),
    [anon_sym_AMP] = ACTIONS(263),
  },
  [67] = {
    [sym_concatenation] = STATE(360),
    [sym_string] = STATE(355),
    [sym_simple_expansion] = STATE(355),
    [sym_string_expansion] = STATE(355),
    [sym_expansion] = STATE(355),
    [sym_command_substitution] = STATE(355),
    [sym_process_substitution] = STATE(355),
    [aux_sym_unset_command_repeat1] = STATE(360),
    [aux_sym__literal_repeat1] = STATE(361),
    [sym_file_descriptor] = ACTIONS(285),
    [anon_sym_SEMI] = ACTIONS(287),
    [anon_sym_PIPE] = ACTIONS(287),
    [anon_sym_SEMI_SEMI] = ACTIONS(285),
    [anon_sym_PIPE_AMP] = ACTIONS(285),
    [anon_sym_AMP_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(285),
    [anon_sym_LT] = ACTIONS(287),
    [anon_sym_GT] = ACTIONS(287),
    [anon_sym_GT_GT] = ACTIONS(285),
    [anon_sym_AMP_GT] = ACTIONS(287),
    [anon_sym_AMP_GT_GT] = ACTIONS(285),
    [anon_sym_LT_AMP] = ACTIONS(285),
    [anon_sym_GT_AMP] = ACTIONS(285),
    [anon_sym_LT_LT] = ACTIONS(287),
    [anon_sym_LT_LT_DASH] = ACTIONS(285),
    [anon_sym_LT_LT_LT] = ACTIONS(285),
    [anon_sym_DOLLAR] = ACTIONS(605),
    [sym__special_character] = ACTIONS(607),
    [anon_sym_DQUOTE] = ACTIONS(609),
    [sym_raw_string] = ACTIONS(611),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(613),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(615),
    [anon_sym_BQUOTE] = ACTIONS(617),
    [anon_sym_LT_LPAREN] = ACTIONS(619),
    [anon_sym_GT_LPAREN] = ACTIONS(619),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(621),
    [sym_word] = ACTIONS(623),
    [anon_sym_LF] = ACTIONS(285),
    [anon_sym_AMP] = ACTIONS(287),
  },
  [68] = {
    [sym_string] = STATE(363),
    [anon_sym_DASH] = ACTIONS(625),
    [anon_sym_DOLLAR] = ACTIONS(625),
    [anon_sym_DQUOTE] = ACTIONS(129),
    [sym_raw_string] = ACTIONS(627),
    [anon_sym_POUND] = ACTIONS(625),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(629),
    [anon_sym_STAR] = ACTIONS(631),
    [anon_sym_AT] = ACTIONS(631),
    [anon_sym_QMARK] = ACTIONS(631),
    [anon_sym_0] = ACTIONS(629),
    [anon_sym__] = ACTIONS(629),
  },
  [69] = {
    [aux_sym_concatenation_repeat1] = STATE(366),
    [sym_file_descriptor] = ACTIONS(335),
    [sym__concat] = ACTIONS(633),
    [anon_sym_SEMI] = ACTIONS(339),
    [anon_sym_PIPE] = ACTIONS(339),
    [anon_sym_SEMI_SEMI] = ACTIONS(335),
    [anon_sym_PIPE_AMP] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_PIPE_PIPE] = ACTIONS(335),
    [anon_sym_EQ_TILDE] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_LT] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(339),
    [anon_sym_GT_GT] = ACTIONS(335),
    [anon_sym_AMP_GT] = ACTIONS(339),
    [anon_sym_AMP_GT_GT] = ACTIONS(335),
    [anon_sym_LT_AMP] = ACTIONS(335),
    [anon_sym_GT_AMP] = ACTIONS(335),
    [anon_sym_LT_LT] = ACTIONS(339),
    [anon_sym_LT_LT_DASH] = ACTIONS(335),
    [anon_sym_LT_LT_LT] = ACTIONS(335),
    [anon_sym_DOLLAR] = ACTIONS(339),
    [sym__special_character] = ACTIONS(335),
    [anon_sym_DQUOTE] = ACTIONS(335),
    [sym_raw_string] = ACTIONS(335),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(335),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(335),
    [anon_sym_LT_LPAREN] = ACTIONS(335),
    [anon_sym_GT_LPAREN] = ACTIONS(335),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(339),
    [anon_sym_LF] = ACTIONS(335),
    [anon_sym_AMP] = ACTIONS(339),
  },
  [70] = {
    [sym_simple_expansion] = STATE(204),
    [sym_expansion] = STATE(204),
    [sym_command_substitution] = STATE(204),
    [aux_sym_string_repeat1] = STATE(369),
    [anon_sym_DOLLAR] = ACTIONS(635),
    [anon_sym_DQUOTE] = ACTIONS(637),
    [sym__string_content] = ACTIONS(345),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(347),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(329),
  },
  [71] = {
    [aux_sym_concatenation_repeat1] = STATE(366),
    [sym_file_descriptor] = ACTIONS(353),
    [sym__concat] = ACTIONS(633),
    [anon_sym_SEMI] = ACTIONS(355),
    [anon_sym_PIPE] = ACTIONS(355),
    [anon_sym_SEMI_SEMI] = ACTIONS(353),
    [anon_sym_PIPE_AMP] = ACTIONS(353),
    [anon_sym_AMP_AMP] = ACTIONS(353),
    [anon_sym_PIPE_PIPE] = ACTIONS(353),
    [anon_sym_EQ_TILDE] = ACTIONS(355),
    [anon_sym_EQ_EQ] = ACTIONS(355),
    [anon_sym_LT] = ACTIONS(355),
    [anon_sym_GT] = ACTIONS(355),
    [anon_sym_GT_GT] = ACTIONS(353),
    [anon_sym_AMP_GT] = ACTIONS(355),
    [anon_sym_AMP_GT_GT] = ACTIONS(353),
    [anon_sym_LT_AMP] = ACTIONS(353),
    [anon_sym_GT_AMP] = ACTIONS(353),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(353),
    [anon_sym_LT_LT_LT] = ACTIONS(353),
    [anon_sym_DOLLAR] = ACTIONS(355),
    [sym__special_character] = ACTIONS(353),
    [anon_sym_DQUOTE] = ACTIONS(353),
    [sym_raw_string] = ACTIONS(353),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(353),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [anon_sym_LT_LPAREN] = ACTIONS(353),
    [anon_sym_GT_LPAREN] = ACTIONS(353),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(355),
    [anon_sym_LF] = ACTIONS(353),
    [anon_sym_AMP] = ACTIONS(355),
  },
  [72] = {
    [sym_subscript] = STATE(373),
    [sym_variable_name] = ACTIONS(639),
    [anon_sym_BANG] = ACTIONS(641),
    [anon_sym_DASH] = ACTIONS(643),
    [anon_sym_DOLLAR] = ACTIONS(643),
    [anon_sym_POUND] = ACTIONS(641),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(645),
    [anon_sym_STAR] = ACTIONS(647),
    [anon_sym_AT] = ACTIONS(647),
    [anon_sym_QMARK] = ACTIONS(647),
    [anon_sym_0] = ACTIONS(645),
    [anon_sym__] = ACTIONS(645),
  },
  [73] = {
    [sym__statements] = STATE(374),
    [sym_redirected_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_c_style_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_case_statement] = STATE(105),
    [sym_function_definition] = STATE(105),
    [sym_compound_statement] = STATE(105),
    [sym_subshell] = STATE(105),
    [sym_pipeline] = STATE(105),
    [sym_list] = STATE(105),
    [sym_negated_command] = STATE(105),
    [sym_test_command] = STATE(105),
    [sym_declaration_command] = STATE(105),
    [sym_unset_command] = STATE(105),
    [sym_command] = STATE(105),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(107),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(375),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(109),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(371),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(371),
    [anon_sym_LT_AMP] = ACTIONS(371),
    [anon_sym_GT_AMP] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [74] = {
    [sym__statements] = STATE(376),
    [sym_redirected_statement] = STATE(225),
    [sym_for_statement] = STATE(225),
    [sym_c_style_for_statement] = STATE(225),
    [sym_while_statement] = STATE(225),
    [sym_if_statement] = STATE(225),
    [sym_case_statement] = STATE(225),
    [sym_function_definition] = STATE(225),
    [sym_compound_statement] = STATE(225),
    [sym_subshell] = STATE(225),
    [sym_pipeline] = STATE(225),
    [sym_list] = STATE(225),
    [sym_negated_command] = STATE(225),
    [sym_test_command] = STATE(225),
    [sym_declaration_command] = STATE(225),
    [sym_unset_command] = STATE(225),
    [sym_command] = STATE(225),
    [sym_command_name] = STATE(226),
    [sym_variable_assignment] = STATE(227),
    [sym_subscript] = STATE(228),
    [sym_file_redirect] = STATE(230),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(222),
    [sym_simple_expansion] = STATE(222),
    [sym_string_expansion] = STATE(222),
    [sym_expansion] = STATE(222),
    [sym_command_substitution] = STATE(222),
    [sym_process_substitution] = STATE(222),
    [aux_sym__statements_repeat1] = STATE(229),
    [aux_sym_command_repeat1] = STATE(230),
    [aux_sym__literal_repeat1] = STATE(231),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(375),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_typeset] = ACTIONS(377),
    [anon_sym_export] = ACTIONS(377),
    [anon_sym_readonly] = ACTIONS(377),
    [anon_sym_local] = ACTIONS(377),
    [anon_sym_unset] = ACTIONS(379),
    [anon_sym_unsetenv] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(381),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(383),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(385),
  },
  [75] = {
    [sym__statements] = STATE(377),
    [sym_redirected_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_c_style_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_case_statement] = STATE(105),
    [sym_function_definition] = STATE(105),
    [sym_compound_statement] = STATE(105),
    [sym_subshell] = STATE(105),
    [sym_pipeline] = STATE(105),
    [sym_list] = STATE(105),
    [sym_negated_command] = STATE(105),
    [sym_test_command] = STATE(105),
    [sym_declaration_command] = STATE(105),
    [sym_unset_command] = STATE(105),
    [sym_command] = STATE(105),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(107),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(110),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(109),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [76] = {
    [aux_sym_concatenation_repeat1] = STATE(366),
    [sym_file_descriptor] = ACTIONS(353),
    [sym__concat] = ACTIONS(633),
    [anon_sym_SEMI] = ACTIONS(355),
    [anon_sym_PIPE] = ACTIONS(355),
    [anon_sym_SEMI_SEMI] = ACTIONS(353),
    [anon_sym_LPAREN] = ACTIONS(649),
    [anon_sym_PIPE_AMP] = ACTIONS(353),
    [anon_sym_AMP_AMP] = ACTIONS(353),
    [anon_sym_PIPE_PIPE] = ACTIONS(353),
    [anon_sym_EQ_TILDE] = ACTIONS(355),
    [anon_sym_EQ_EQ] = ACTIONS(355),
    [anon_sym_LT] = ACTIONS(355),
    [anon_sym_GT] = ACTIONS(355),
    [anon_sym_GT_GT] = ACTIONS(353),
    [anon_sym_AMP_GT] = ACTIONS(355),
    [anon_sym_AMP_GT_GT] = ACTIONS(353),
    [anon_sym_LT_AMP] = ACTIONS(353),
    [anon_sym_GT_AMP] = ACTIONS(353),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(353),
    [anon_sym_LT_LT_LT] = ACTIONS(353),
    [anon_sym_DOLLAR] = ACTIONS(355),
    [sym__special_character] = ACTIONS(353),
    [anon_sym_DQUOTE] = ACTIONS(353),
    [sym_raw_string] = ACTIONS(353),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(353),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [anon_sym_LT_LPAREN] = ACTIONS(353),
    [anon_sym_GT_LPAREN] = ACTIONS(353),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(355),
    [anon_sym_LF] = ACTIONS(353),
    [anon_sym_AMP] = ACTIONS(355),
  },
  [77] = {
    [sym_do_group] = STATE(380),
    [anon_sym_do] = ACTIONS(651),
    [sym_comment] = ACTIONS(57),
  },
  [78] = {
    [sym_file_redirect] = STATE(388),
    [sym_heredoc_redirect] = STATE(388),
    [sym_herestring_redirect] = STATE(388),
    [aux_sym_redirected_statement_repeat1] = STATE(388),
    [sym_file_descriptor] = ACTIONS(653),
    [anon_sym_SEMI] = ACTIONS(655),
    [anon_sym_PIPE] = ACTIONS(657),
    [anon_sym_SEMI_SEMI] = ACTIONS(659),
    [anon_sym_PIPE_AMP] = ACTIONS(661),
    [anon_sym_AMP_AMP] = ACTIONS(663),
    [anon_sym_PIPE_PIPE] = ACTIONS(663),
    [anon_sym_LT] = ACTIONS(665),
    [anon_sym_GT] = ACTIONS(665),
    [anon_sym_GT_GT] = ACTIONS(667),
    [anon_sym_AMP_GT] = ACTIONS(665),
    [anon_sym_AMP_GT_GT] = ACTIONS(667),
    [anon_sym_LT_AMP] = ACTIONS(667),
    [anon_sym_GT_AMP] = ACTIONS(667),
    [anon_sym_LT_LT] = ACTIONS(669),
    [anon_sym_LT_LT_DASH] = ACTIONS(671),
    [anon_sym_LT_LT_LT] = ACTIONS(673),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(659),
    [anon_sym_AMP] = ACTIONS(655),
  },
  [79] = {
    [sym_concatenation] = STATE(391),
    [sym_string] = STATE(390),
    [sym_simple_expansion] = STATE(390),
    [sym_string_expansion] = STATE(390),
    [sym_expansion] = STATE(390),
    [sym_command_substitution] = STATE(390),
    [sym_process_substitution] = STATE(390),
    [aux_sym_command_repeat2] = STATE(391),
    [aux_sym__literal_repeat1] = STATE(392),
    [sym_file_descriptor] = ACTIONS(421),
    [anon_sym_SEMI] = ACTIONS(423),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_SEMI_SEMI] = ACTIONS(421),
    [anon_sym_PIPE_AMP] = ACTIONS(421),
    [anon_sym_AMP_AMP] = ACTIONS(421),
    [anon_sym_PIPE_PIPE] = ACTIONS(421),
    [anon_sym_EQ_TILDE] = ACTIONS(675),
    [anon_sym_EQ_EQ] = ACTIONS(675),
    [anon_sym_LT] = ACTIONS(423),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(421),
    [anon_sym_AMP_GT] = ACTIONS(423),
    [anon_sym_AMP_GT_GT] = ACTIONS(421),
    [anon_sym_LT_AMP] = ACTIONS(421),
    [anon_sym_GT_AMP] = ACTIONS(421),
    [anon_sym_LT_LT] = ACTIONS(423),
    [anon_sym_LT_LT_DASH] = ACTIONS(421),
    [anon_sym_LT_LT_LT] = ACTIONS(421),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [sym__special_character] = ACTIONS(677),
    [anon_sym_DQUOTE] = ACTIONS(129),
    [sym_raw_string] = ACTIONS(679),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(133),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(135),
    [anon_sym_BQUOTE] = ACTIONS(137),
    [anon_sym_LT_LPAREN] = ACTIONS(139),
    [anon_sym_GT_LPAREN] = ACTIONS(139),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(681),
    [anon_sym_LF] = ACTIONS(421),
    [anon_sym_AMP] = ACTIONS(423),
  },
  [80] = {
    [sym_file_redirect] = STATE(388),
    [sym_heredoc_redirect] = STATE(388),
    [sym_herestring_redirect] = STATE(388),
    [aux_sym_redirected_statement_repeat1] = STATE(388),
    [sym_file_descriptor] = ACTIONS(433),
    [sym_variable_name] = ACTIONS(433),
    [anon_sym_SEMI] = ACTIONS(655),
    [anon_sym_PIPE] = ACTIONS(657),
    [anon_sym_SEMI_SEMI] = ACTIONS(659),
    [anon_sym_PIPE_AMP] = ACTIONS(661),
    [anon_sym_AMP_AMP] = ACTIONS(663),
    [anon_sym_PIPE_PIPE] = ACTIONS(663),
    [anon_sym_LT] = ACTIONS(435),
    [anon_sym_GT] = ACTIONS(435),
    [anon_sym_GT_GT] = ACTIONS(433),
    [anon_sym_AMP_GT] = ACTIONS(435),
    [anon_sym_AMP_GT_GT] = ACTIONS(433),
    [anon_sym_LT_AMP] = ACTIONS(433),
    [anon_sym_GT_AMP] = ACTIONS(433),
    [anon_sym_LT_LT] = ACTIONS(669),
    [anon_sym_LT_LT_DASH] = ACTIONS(671),
    [anon_sym_LT_LT_LT] = ACTIONS(673),
    [anon_sym_DOLLAR] = ACTIONS(435),
    [sym__special_character] = ACTIONS(433),
    [anon_sym_DQUOTE] = ACTIONS(433),
    [sym_raw_string] = ACTIONS(433),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(433),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(433),
    [anon_sym_BQUOTE] = ACTIONS(433),
    [anon_sym_LT_LPAREN] = ACTIONS(433),
    [anon_sym_GT_LPAREN] = ACTIONS(433),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(435),
    [anon_sym_LF] = ACTIONS(659),
    [anon_sym_AMP] = ACTIONS(655),
  },
  [81] = {
    [anon_sym_EQ] = ACTIONS(571),
    [anon_sym_PLUS_EQ] = ACTIONS(571),
    [sym_comment] = ACTIONS(57),
  },
  [82] = {
    [sym_file_descriptor] = ACTIONS(353),
    [anon_sym_SEMI] = ACTIONS(355),
    [anon_sym_PIPE] = ACTIONS(355),
    [anon_sym_SEMI_SEMI] = ACTIONS(353),
    [anon_sym_PIPE_AMP] = ACTIONS(353),
    [anon_sym_AMP_AMP] = ACTIONS(353),
    [anon_sym_PIPE_PIPE] = ACTIONS(353),
    [anon_sym_EQ_TILDE] = ACTIONS(355),
    [anon_sym_EQ_EQ] = ACTIONS(355),
    [anon_sym_LT] = ACTIONS(355),
    [anon_sym_GT] = ACTIONS(355),
    [anon_sym_GT_GT] = ACTIONS(353),
    [anon_sym_AMP_GT] = ACTIONS(355),
    [anon_sym_AMP_GT_GT] = ACTIONS(353),
    [anon_sym_LT_AMP] = ACTIONS(353),
    [anon_sym_GT_AMP] = ACTIONS(353),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(353),
    [anon_sym_LT_LT_LT] = ACTIONS(353),
    [anon_sym_DOLLAR] = ACTIONS(355),
    [sym__special_character] = ACTIONS(353),
    [anon_sym_DQUOTE] = ACTIONS(353),
    [sym_raw_string] = ACTIONS(353),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(353),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [anon_sym_LT_LPAREN] = ACTIONS(353),
    [anon_sym_GT_LPAREN] = ACTIONS(353),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(355),
    [anon_sym_LF] = ACTIONS(353),
    [anon_sym_AMP] = ACTIONS(355),
  },
  [83] = {
    [sym_command_name] = STATE(393),
    [sym_variable_assignment] = STATE(253),
    [sym_subscript] = STATE(147),
    [sym_file_redirect] = STATE(253),
    [sym_concatenation] = STATE(82),
    [sym_string] = STATE(71),
    [sym_simple_expansion] = STATE(71),
    [sym_string_expansion] = STATE(71),
    [sym_expansion] = STATE(71),
    [sym_command_substitution] = STATE(71),
    [sym_process_substitution] = STATE(71),
    [aux_sym_command_repeat1] = STATE(253),
    [aux_sym__literal_repeat1] = STATE(84),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(223),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [sym__special_character] = ACTIONS(677),
    [anon_sym_DQUOTE] = ACTIONS(129),
    [sym_raw_string] = ACTIONS(131),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(133),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(135),
    [anon_sym_BQUOTE] = ACTIONS(137),
    [anon_sym_LT_LPAREN] = ACTIONS(139),
    [anon_sym_GT_LPAREN] = ACTIONS(139),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(131),
  },
  [84] = {
    [aux_sym__literal_repeat1] = STATE(395),
    [sym_file_descriptor] = ACTIONS(437),
    [anon_sym_SEMI] = ACTIONS(439),
    [anon_sym_PIPE] = ACTIONS(439),
    [anon_sym_SEMI_SEMI] = ACTIONS(437),
    [anon_sym_PIPE_AMP] = ACTIONS(437),
    [anon_sym_AMP_AMP] = ACTIONS(437),
    [anon_sym_PIPE_PIPE] = ACTIONS(437),
    [anon_sym_EQ_TILDE] = ACTIONS(439),
    [anon_sym_EQ_EQ] = ACTIONS(439),
    [anon_sym_LT] = ACTIONS(439),
    [anon_sym_GT] = ACTIONS(439),
    [anon_sym_GT_GT] = ACTIONS(437),
    [anon_sym_AMP_GT] = ACTIONS(439),
    [anon_sym_AMP_GT_GT] = ACTIONS(437),
    [anon_sym_LT_AMP] = ACTIONS(437),
    [anon_sym_GT_AMP] = ACTIONS(437),
    [anon_sym_LT_LT] = ACTIONS(439),
    [anon_sym_LT_LT_DASH] = ACTIONS(437),
    [anon_sym_LT_LT_LT] = ACTIONS(437),
    [anon_sym_DOLLAR] = ACTIONS(439),
    [sym__special_character] = ACTIONS(683),
    [anon_sym_DQUOTE] = ACTIONS(437),
    [sym_raw_string] = ACTIONS(437),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(437),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(437),
    [anon_sym_BQUOTE] = ACTIONS(437),
    [anon_sym_LT_LPAREN] = ACTIONS(437),
    [anon_sym_GT_LPAREN] = ACTIONS(437),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(439),
    [anon_sym_LF] = ACTIONS(437),
    [anon_sym_AMP] = ACTIONS(439),
  },
  [85] = {
    [anon_sym_then] = ACTIONS(685),
    [sym_comment] = ACTIONS(57),
  },
  [86] = {
    [sym_string] = STATE(398),
    [anon_sym_DASH] = ACTIONS(687),
    [anon_sym_DOLLAR] = ACTIONS(687),
    [anon_sym_DQUOTE] = ACTIONS(147),
    [sym_raw_string] = ACTIONS(689),
    [anon_sym_POUND] = ACTIONS(687),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(691),
    [anon_sym_STAR] = ACTIONS(693),
    [anon_sym_AT] = ACTIONS(693),
    [anon_sym_QMARK] = ACTIONS(693),
    [anon_sym_0] = ACTIONS(691),
    [anon_sym__] = ACTIONS(691),
  },
  [87] = {
    [aux_sym_concatenation_repeat1] = STATE(401),
    [sym__concat] = ACTIONS(695),
    [anon_sym_in] = ACTIONS(335),
    [anon_sym_SEMI] = ACTIONS(339),
    [anon_sym_SEMI_SEMI] = ACTIONS(335),
    [sym__special_character] = ACTIONS(335),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(335),
    [anon_sym_AMP] = ACTIONS(335),
  },
  [88] = {
    [sym_simple_expansion] = STATE(204),
    [sym_expansion] = STATE(204),
    [sym_command_substitution] = STATE(204),
    [aux_sym_string_repeat1] = STATE(404),
    [anon_sym_DOLLAR] = ACTIONS(697),
    [anon_sym_DQUOTE] = ACTIONS(699),
    [sym__string_content] = ACTIONS(345),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(347),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(329),
  },
  [89] = {
    [aux_sym_concatenation_repeat1] = STATE(401),
    [sym__concat] = ACTIONS(695),
    [anon_sym_in] = ACTIONS(701),
    [anon_sym_SEMI] = ACTIONS(703),
    [anon_sym_SEMI_SEMI] = ACTIONS(705),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(705),
    [anon_sym_AMP] = ACTIONS(705),
  },
  [90] = {
    [sym_subscript] = STATE(410),
    [sym_variable_name] = ACTIONS(707),
    [anon_sym_BANG] = ACTIONS(709),
    [anon_sym_DASH] = ACTIONS(711),
    [anon_sym_DOLLAR] = ACTIONS(711),
    [anon_sym_POUND] = ACTIONS(709),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(713),
    [anon_sym_STAR] = ACTIONS(715),
    [anon_sym_AT] = ACTIONS(715),
    [anon_sym_QMARK] = ACTIONS(715),
    [anon_sym_0] = ACTIONS(713),
    [anon_sym__] = ACTIONS(713),
  },
  [91] = {
    [sym__statements] = STATE(411),
    [sym_redirected_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_c_style_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_case_statement] = STATE(105),
    [sym_function_definition] = STATE(105),
    [sym_compound_statement] = STATE(105),
    [sym_subshell] = STATE(105),
    [sym_pipeline] = STATE(105),
    [sym_list] = STATE(105),
    [sym_negated_command] = STATE(105),
    [sym_test_command] = STATE(105),
    [sym_declaration_command] = STATE(105),
    [sym_unset_command] = STATE(105),
    [sym_command] = STATE(105),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(107),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(412),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(109),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(371),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(371),
    [anon_sym_LT_AMP] = ACTIONS(371),
    [anon_sym_GT_AMP] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [92] = {
    [sym__statements] = STATE(413),
    [sym_redirected_statement] = STATE(225),
    [sym_for_statement] = STATE(225),
    [sym_c_style_for_statement] = STATE(225),
    [sym_while_statement] = STATE(225),
    [sym_if_statement] = STATE(225),
    [sym_case_statement] = STATE(225),
    [sym_function_definition] = STATE(225),
    [sym_compound_statement] = STATE(225),
    [sym_subshell] = STATE(225),
    [sym_pipeline] = STATE(225),
    [sym_list] = STATE(225),
    [sym_negated_command] = STATE(225),
    [sym_test_command] = STATE(225),
    [sym_declaration_command] = STATE(225),
    [sym_unset_command] = STATE(225),
    [sym_command] = STATE(225),
    [sym_command_name] = STATE(226),
    [sym_variable_assignment] = STATE(227),
    [sym_subscript] = STATE(228),
    [sym_file_redirect] = STATE(230),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(222),
    [sym_simple_expansion] = STATE(222),
    [sym_string_expansion] = STATE(222),
    [sym_expansion] = STATE(222),
    [sym_command_substitution] = STATE(222),
    [sym_process_substitution] = STATE(222),
    [aux_sym__statements_repeat1] = STATE(229),
    [aux_sym_command_repeat1] = STATE(230),
    [aux_sym__literal_repeat1] = STATE(231),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(375),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_typeset] = ACTIONS(377),
    [anon_sym_export] = ACTIONS(377),
    [anon_sym_readonly] = ACTIONS(377),
    [anon_sym_local] = ACTIONS(377),
    [anon_sym_unset] = ACTIONS(379),
    [anon_sym_unsetenv] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(381),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(383),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(385),
  },
  [93] = {
    [sym__statements] = STATE(414),
    [sym_redirected_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_c_style_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_case_statement] = STATE(105),
    [sym_function_definition] = STATE(105),
    [sym_compound_statement] = STATE(105),
    [sym_subshell] = STATE(105),
    [sym_pipeline] = STATE(105),
    [sym_list] = STATE(105),
    [sym_negated_command] = STATE(105),
    [sym_test_command] = STATE(105),
    [sym_declaration_command] = STATE(105),
    [sym_unset_command] = STATE(105),
    [sym_command] = STATE(105),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(107),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(110),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(109),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [94] = {
    [anon_sym_in] = ACTIONS(701),
    [anon_sym_SEMI] = ACTIONS(703),
    [anon_sym_SEMI_SEMI] = ACTIONS(705),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(705),
    [anon_sym_AMP] = ACTIONS(705),
  },
  [95] = {
    [aux_sym__literal_repeat1] = STATE(418),
    [anon_sym_in] = ACTIONS(717),
    [anon_sym_SEMI] = ACTIONS(719),
    [anon_sym_SEMI_SEMI] = ACTIONS(721),
    [sym__special_character] = ACTIONS(723),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(721),
    [anon_sym_AMP] = ACTIONS(721),
  },
  [96] = {
    [sym_compound_statement] = STATE(420),
    [anon_sym_LPAREN] = ACTIONS(725),
    [anon_sym_LBRACE] = ACTIONS(25),
    [sym_comment] = ACTIONS(57),
  },
  [97] = {
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_EQ] = ACTIONS(727),
    [anon_sym_PLUS_EQ] = ACTIONS(727),
    [sym_comment] = ACTIONS(57),
  },
  [98] = {
    [sym_subshell] = STATE(146),
    [sym_test_command] = STATE(146),
    [sym_command] = STATE(146),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(110),
    [sym_subscript] = STATE(147),
    [sym_file_redirect] = STATE(110),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(223),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(171),
  },
  [99] = {
    [sym_variable_assignment] = STATE(426),
    [sym_subscript] = STATE(425),
    [sym_concatenation] = STATE(426),
    [sym_string] = STATE(424),
    [sym_simple_expansion] = STATE(424),
    [sym_string_expansion] = STATE(424),
    [sym_expansion] = STATE(424),
    [sym_command_substitution] = STATE(424),
    [sym_process_substitution] = STATE(424),
    [aux_sym_declaration_command_repeat1] = STATE(426),
    [aux_sym__literal_repeat1] = STATE(427),
    [sym__simple_heredoc_body] = ACTIONS(259),
    [sym__heredoc_body_beginning] = ACTIONS(259),
    [sym_file_descriptor] = ACTIONS(259),
    [sym_variable_name] = ACTIONS(729),
    [anon_sym_SEMI] = ACTIONS(263),
    [anon_sym_PIPE] = ACTIONS(263),
    [anon_sym_RPAREN] = ACTIONS(259),
    [anon_sym_SEMI_SEMI] = ACTIONS(259),
    [anon_sym_PIPE_AMP] = ACTIONS(259),
    [anon_sym_AMP_AMP] = ACTIONS(259),
    [anon_sym_PIPE_PIPE] = ACTIONS(259),
    [anon_sym_LT] = ACTIONS(263),
    [anon_sym_GT] = ACTIONS(263),
    [anon_sym_GT_GT] = ACTIONS(259),
    [anon_sym_AMP_GT] = ACTIONS(263),
    [anon_sym_AMP_GT_GT] = ACTIONS(259),
    [anon_sym_LT_AMP] = ACTIONS(259),
    [anon_sym_GT_AMP] = ACTIONS(259),
    [anon_sym_LT_LT] = ACTIONS(263),
    [anon_sym_LT_LT_DASH] = ACTIONS(259),
    [anon_sym_LT_LT_LT] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(265),
    [sym__special_character] = ACTIONS(731),
    [anon_sym_DQUOTE] = ACTIONS(269),
    [sym_raw_string] = ACTIONS(733),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(273),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(275),
    [anon_sym_BQUOTE] = ACTIONS(277),
    [anon_sym_LT_LPAREN] = ACTIONS(279),
    [anon_sym_GT_LPAREN] = ACTIONS(279),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(735),
    [sym_word] = ACTIONS(737),
    [anon_sym_LF] = ACTIONS(259),
    [anon_sym_AMP] = ACTIONS(263),
  },
  [100] = {
    [sym_concatenation] = STATE(430),
    [sym_string] = STATE(429),
    [sym_simple_expansion] = STATE(429),
    [sym_string_expansion] = STATE(429),
    [sym_expansion] = STATE(429),
    [sym_command_substitution] = STATE(429),
    [sym_process_substitution] = STATE(429),
    [aux_sym_unset_command_repeat1] = STATE(430),
    [aux_sym__literal_repeat1] = STATE(431),
    [sym__simple_heredoc_body] = ACTIONS(285),
    [sym__heredoc_body_beginning] = ACTIONS(285),
    [sym_file_descriptor] = ACTIONS(285),
    [anon_sym_SEMI] = ACTIONS(287),
    [anon_sym_PIPE] = ACTIONS(287),
    [anon_sym_RPAREN] = ACTIONS(285),
    [anon_sym_SEMI_SEMI] = ACTIONS(285),
    [anon_sym_PIPE_AMP] = ACTIONS(285),
    [anon_sym_AMP_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(285),
    [anon_sym_LT] = ACTIONS(287),
    [anon_sym_GT] = ACTIONS(287),
    [anon_sym_GT_GT] = ACTIONS(285),
    [anon_sym_AMP_GT] = ACTIONS(287),
    [anon_sym_AMP_GT_GT] = ACTIONS(285),
    [anon_sym_LT_AMP] = ACTIONS(285),
    [anon_sym_GT_AMP] = ACTIONS(285),
    [anon_sym_LT_LT] = ACTIONS(287),
    [anon_sym_LT_LT_DASH] = ACTIONS(285),
    [anon_sym_LT_LT_LT] = ACTIONS(285),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym__special_character] = ACTIONS(739),
    [anon_sym_DQUOTE] = ACTIONS(293),
    [sym_raw_string] = ACTIONS(741),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(297),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(299),
    [anon_sym_BQUOTE] = ACTIONS(301),
    [anon_sym_LT_LPAREN] = ACTIONS(303),
    [anon_sym_GT_LPAREN] = ACTIONS(303),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(743),
    [sym_word] = ACTIONS(745),
    [anon_sym_LF] = ACTIONS(285),
    [anon_sym_AMP] = ACTIONS(287),
  },
  [101] = {
    [aux_sym_concatenation_repeat1] = STATE(432),
    [sym__simple_heredoc_body] = ACTIONS(335),
    [sym__heredoc_body_beginning] = ACTIONS(335),
    [sym_file_descriptor] = ACTIONS(335),
    [sym__concat] = ACTIONS(337),
    [anon_sym_SEMI] = ACTIONS(339),
    [anon_sym_PIPE] = ACTIONS(339),
    [anon_sym_RPAREN] = ACTIONS(335),
    [anon_sym_SEMI_SEMI] = ACTIONS(335),
    [anon_sym_PIPE_AMP] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_PIPE_PIPE] = ACTIONS(335),
    [anon_sym_EQ_TILDE] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_LT] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(339),
    [anon_sym_GT_GT] = ACTIONS(335),
    [anon_sym_AMP_GT] = ACTIONS(339),
    [anon_sym_AMP_GT_GT] = ACTIONS(335),
    [anon_sym_LT_AMP] = ACTIONS(335),
    [anon_sym_GT_AMP] = ACTIONS(335),
    [anon_sym_LT_LT] = ACTIONS(339),
    [anon_sym_LT_LT_DASH] = ACTIONS(335),
    [anon_sym_LT_LT_LT] = ACTIONS(335),
    [anon_sym_DOLLAR] = ACTIONS(339),
    [sym__special_character] = ACTIONS(335),
    [anon_sym_DQUOTE] = ACTIONS(335),
    [sym_raw_string] = ACTIONS(335),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(335),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(335),
    [anon_sym_LT_LPAREN] = ACTIONS(335),
    [anon_sym_GT_LPAREN] = ACTIONS(335),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(339),
    [anon_sym_LF] = ACTIONS(335),
    [anon_sym_AMP] = ACTIONS(339),
  },
  [102] = {
    [aux_sym_concatenation_repeat1] = STATE(432),
    [sym__simple_heredoc_body] = ACTIONS(353),
    [sym__heredoc_body_beginning] = ACTIONS(353),
    [sym_file_descriptor] = ACTIONS(353),
    [sym__concat] = ACTIONS(337),
    [anon_sym_SEMI] = ACTIONS(355),
    [anon_sym_PIPE] = ACTIONS(355),
    [anon_sym_RPAREN] = ACTIONS(353),
    [anon_sym_SEMI_SEMI] = ACTIONS(353),
    [anon_sym_PIPE_AMP] = ACTIONS(353),
    [anon_sym_AMP_AMP] = ACTIONS(353),
    [anon_sym_PIPE_PIPE] = ACTIONS(353),
    [anon_sym_EQ_TILDE] = ACTIONS(355),
    [anon_sym_EQ_EQ] = ACTIONS(355),
    [anon_sym_LT] = ACTIONS(355),
    [anon_sym_GT] = ACTIONS(355),
    [anon_sym_GT_GT] = ACTIONS(353),
    [anon_sym_AMP_GT] = ACTIONS(355),
    [anon_sym_AMP_GT_GT] = ACTIONS(353),
    [anon_sym_LT_AMP] = ACTIONS(353),
    [anon_sym_GT_AMP] = ACTIONS(353),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(353),
    [anon_sym_LT_LT_LT] = ACTIONS(353),
    [anon_sym_DOLLAR] = ACTIONS(355),
    [sym__special_character] = ACTIONS(353),
    [anon_sym_DQUOTE] = ACTIONS(353),
    [sym_raw_string] = ACTIONS(353),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(353),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [anon_sym_LT_LPAREN] = ACTIONS(353),
    [anon_sym_GT_LPAREN] = ACTIONS(353),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(355),
    [anon_sym_LF] = ACTIONS(353),
    [anon_sym_AMP] = ACTIONS(355),
  },
  [103] = {
    [aux_sym_concatenation_repeat1] = STATE(432),
    [sym__simple_heredoc_body] = ACTIONS(353),
    [sym__heredoc_body_beginning] = ACTIONS(353),
    [sym_file_descriptor] = ACTIONS(353),
    [sym__concat] = ACTIONS(337),
    [anon_sym_SEMI] = ACTIONS(355),
    [anon_sym_PIPE] = ACTIONS(355),
    [anon_sym_RPAREN] = ACTIONS(353),
    [anon_sym_SEMI_SEMI] = ACTIONS(353),
    [anon_sym_LPAREN] = ACTIONS(387),
    [anon_sym_PIPE_AMP] = ACTIONS(353),
    [anon_sym_AMP_AMP] = ACTIONS(353),
    [anon_sym_PIPE_PIPE] = ACTIONS(353),
    [anon_sym_EQ_TILDE] = ACTIONS(355),
    [anon_sym_EQ_EQ] = ACTIONS(355),
    [anon_sym_LT] = ACTIONS(355),
    [anon_sym_GT] = ACTIONS(355),
    [anon_sym_GT_GT] = ACTIONS(353),
    [anon_sym_AMP_GT] = ACTIONS(355),
    [anon_sym_AMP_GT_GT] = ACTIONS(353),
    [anon_sym_LT_AMP] = ACTIONS(353),
    [anon_sym_GT_AMP] = ACTIONS(353),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(353),
    [anon_sym_LT_LT_LT] = ACTIONS(353),
    [anon_sym_DOLLAR] = ACTIONS(355),
    [sym__special_character] = ACTIONS(353),
    [anon_sym_DQUOTE] = ACTIONS(353),
    [sym_raw_string] = ACTIONS(353),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(353),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [anon_sym_LT_LPAREN] = ACTIONS(353),
    [anon_sym_GT_LPAREN] = ACTIONS(353),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(355),
    [anon_sym_LF] = ACTIONS(353),
    [anon_sym_AMP] = ACTIONS(355),
  },
  [104] = {
    [anon_sym_RPAREN] = ACTIONS(747),
    [sym_comment] = ACTIONS(57),
  },
  [105] = {
    [sym_file_redirect] = STATE(439),
    [sym_heredoc_redirect] = STATE(439),
    [sym_heredoc_body] = STATE(243),
    [sym_herestring_redirect] = STATE(439),
    [aux_sym_redirected_statement_repeat1] = STATE(439),
    [sym__simple_heredoc_body] = ACTIONS(393),
    [sym__heredoc_body_beginning] = ACTIONS(395),
    [sym_file_descriptor] = ACTIONS(749),
    [anon_sym_SEMI] = ACTIONS(401),
    [anon_sym_PIPE] = ACTIONS(751),
    [anon_sym_RPAREN] = ACTIONS(399),
    [anon_sym_SEMI_SEMI] = ACTIONS(405),
    [anon_sym_PIPE_AMP] = ACTIONS(753),
    [anon_sym_AMP_AMP] = ACTIONS(755),
    [anon_sym_PIPE_PIPE] = ACTIONS(755),
    [anon_sym_LT] = ACTIONS(757),
    [anon_sym_GT] = ACTIONS(757),
    [anon_sym_GT_GT] = ACTIONS(759),
    [anon_sym_AMP_GT] = ACTIONS(757),
    [anon_sym_AMP_GT_GT] = ACTIONS(759),
    [anon_sym_LT_AMP] = ACTIONS(759),
    [anon_sym_GT_AMP] = ACTIONS(759),
    [anon_sym_LT_LT] = ACTIONS(415),
    [anon_sym_LT_LT_DASH] = ACTIONS(417),
    [anon_sym_LT_LT_LT] = ACTIONS(761),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(405),
    [anon_sym_AMP] = ACTIONS(401),
  },
  [106] = {
    [sym_concatenation] = STATE(442),
    [sym_string] = STATE(441),
    [sym_simple_expansion] = STATE(441),
    [sym_string_expansion] = STATE(441),
    [sym_expansion] = STATE(441),
    [sym_command_substitution] = STATE(441),
    [sym_process_substitution] = STATE(441),
    [aux_sym_command_repeat2] = STATE(442),
    [aux_sym__literal_repeat1] = STATE(443),
    [sym__simple_heredoc_body] = ACTIONS(421),
    [sym__heredoc_body_beginning] = ACTIONS(421),
    [sym_file_descriptor] = ACTIONS(421),
    [anon_sym_SEMI] = ACTIONS(423),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_RPAREN] = ACTIONS(421),
    [anon_sym_SEMI_SEMI] = ACTIONS(421),
    [anon_sym_PIPE_AMP] = ACTIONS(421),
    [anon_sym_AMP_AMP] = ACTIONS(421),
    [anon_sym_PIPE_PIPE] = ACTIONS(421),
    [anon_sym_EQ_TILDE] = ACTIONS(763),
    [anon_sym_EQ_EQ] = ACTIONS(763),
    [anon_sym_LT] = ACTIONS(423),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(421),
    [anon_sym_AMP_GT] = ACTIONS(423),
    [anon_sym_AMP_GT_GT] = ACTIONS(421),
    [anon_sym_LT_AMP] = ACTIONS(421),
    [anon_sym_GT_AMP] = ACTIONS(421),
    [anon_sym_LT_LT] = ACTIONS(423),
    [anon_sym_LT_LT_DASH] = ACTIONS(421),
    [anon_sym_LT_LT_LT] = ACTIONS(421),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(765),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(767),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(769),
    [anon_sym_LF] = ACTIONS(421),
    [anon_sym_AMP] = ACTIONS(423),
  },
  [107] = {
    [sym_file_redirect] = STATE(439),
    [sym_heredoc_redirect] = STATE(439),
    [sym_heredoc_body] = STATE(243),
    [sym_herestring_redirect] = STATE(439),
    [aux_sym_redirected_statement_repeat1] = STATE(439),
    [sym__simple_heredoc_body] = ACTIONS(393),
    [sym__heredoc_body_beginning] = ACTIONS(395),
    [sym_file_descriptor] = ACTIONS(433),
    [sym_variable_name] = ACTIONS(433),
    [anon_sym_SEMI] = ACTIONS(401),
    [anon_sym_PIPE] = ACTIONS(751),
    [anon_sym_RPAREN] = ACTIONS(399),
    [anon_sym_SEMI_SEMI] = ACTIONS(405),
    [anon_sym_PIPE_AMP] = ACTIONS(753),
    [anon_sym_AMP_AMP] = ACTIONS(755),
    [anon_sym_PIPE_PIPE] = ACTIONS(755),
    [anon_sym_LT] = ACTIONS(435),
    [anon_sym_GT] = ACTIONS(435),
    [anon_sym_GT_GT] = ACTIONS(433),
    [anon_sym_AMP_GT] = ACTIONS(435),
    [anon_sym_AMP_GT_GT] = ACTIONS(433),
    [anon_sym_LT_AMP] = ACTIONS(433),
    [anon_sym_GT_AMP] = ACTIONS(433),
    [anon_sym_LT_LT] = ACTIONS(415),
    [anon_sym_LT_LT_DASH] = ACTIONS(417),
    [anon_sym_LT_LT_LT] = ACTIONS(761),
    [anon_sym_DOLLAR] = ACTIONS(435),
    [sym__special_character] = ACTIONS(433),
    [anon_sym_DQUOTE] = ACTIONS(433),
    [sym_raw_string] = ACTIONS(433),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(433),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(433),
    [anon_sym_BQUOTE] = ACTIONS(433),
    [anon_sym_LT_LPAREN] = ACTIONS(433),
    [anon_sym_GT_LPAREN] = ACTIONS(433),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(435),
    [anon_sym_LF] = ACTIONS(405),
    [anon_sym_AMP] = ACTIONS(401),
  },
  [108] = {
    [anon_sym_EQ] = ACTIONS(727),
    [anon_sym_PLUS_EQ] = ACTIONS(727),
    [sym_comment] = ACTIONS(57),
  },
  [109] = {
    [sym_redirected_statement] = STATE(444),
    [sym_for_statement] = STATE(444),
    [sym_c_style_for_statement] = STATE(444),
    [sym_while_statement] = STATE(444),
    [sym_if_statement] = STATE(444),
    [sym_case_statement] = STATE(444),
    [sym_function_definition] = STATE(444),
    [sym_compound_statement] = STATE(444),
    [sym_subshell] = STATE(444),
    [sym_pipeline] = STATE(444),
    [sym_list] = STATE(444),
    [sym_negated_command] = STATE(444),
    [sym_test_command] = STATE(444),
    [sym_declaration_command] = STATE(444),
    [sym_unset_command] = STATE(444),
    [sym_command] = STATE(444),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(445),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(110),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(251),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [110] = {
    [sym_command_name] = STATE(446),
    [sym_variable_assignment] = STATE(253),
    [sym_subscript] = STATE(147),
    [sym_file_redirect] = STATE(253),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym_command_repeat1] = STATE(253),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(223),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(765),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(171),
  },
  [111] = {
    [aux_sym__literal_repeat1] = STATE(447),
    [sym__simple_heredoc_body] = ACTIONS(437),
    [sym__heredoc_body_beginning] = ACTIONS(437),
    [sym_file_descriptor] = ACTIONS(437),
    [anon_sym_SEMI] = ACTIONS(439),
    [anon_sym_PIPE] = ACTIONS(439),
    [anon_sym_RPAREN] = ACTIONS(437),
    [anon_sym_SEMI_SEMI] = ACTIONS(437),
    [anon_sym_PIPE_AMP] = ACTIONS(437),
    [anon_sym_AMP_AMP] = ACTIONS(437),
    [anon_sym_PIPE_PIPE] = ACTIONS(437),
    [anon_sym_EQ_TILDE] = ACTIONS(439),
    [anon_sym_EQ_EQ] = ACTIONS(439),
    [anon_sym_LT] = ACTIONS(439),
    [anon_sym_GT] = ACTIONS(439),
    [anon_sym_GT_GT] = ACTIONS(437),
    [anon_sym_AMP_GT] = ACTIONS(439),
    [anon_sym_AMP_GT_GT] = ACTIONS(437),
    [anon_sym_LT_AMP] = ACTIONS(437),
    [anon_sym_GT_AMP] = ACTIONS(437),
    [anon_sym_LT_LT] = ACTIONS(439),
    [anon_sym_LT_LT_DASH] = ACTIONS(437),
    [anon_sym_LT_LT_LT] = ACTIONS(437),
    [anon_sym_DOLLAR] = ACTIONS(439),
    [sym__special_character] = ACTIONS(441),
    [anon_sym_DQUOTE] = ACTIONS(437),
    [sym_raw_string] = ACTIONS(437),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(437),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(437),
    [anon_sym_BQUOTE] = ACTIONS(437),
    [anon_sym_LT_LPAREN] = ACTIONS(437),
    [anon_sym_GT_LPAREN] = ACTIONS(437),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(439),
    [anon_sym_LF] = ACTIONS(437),
    [anon_sym_AMP] = ACTIONS(439),
  },
  [112] = {
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_EQ] = ACTIONS(771),
    [anon_sym_PLUS_EQ] = ACTIONS(771),
    [sym_comment] = ACTIONS(57),
  },
  [113] = {
    [anon_sym_LPAREN_LPAREN] = ACTIONS(773),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(775),
  },
  [114] = {
    [sym__expression] = STATE(451),
    [sym_binary_expression] = STATE(451),
    [sym_unary_expression] = STATE(451),
    [sym_postfix_expression] = STATE(451),
    [sym_parenthesized_expression] = STATE(451),
    [sym_concatenation] = STATE(451),
    [sym_string] = STATE(47),
    [sym_simple_expansion] = STATE(47),
    [sym_string_expansion] = STATE(47),
    [sym_expansion] = STATE(47),
    [sym_command_substitution] = STATE(47),
    [sym_process_substitution] = STATE(47),
    [aux_sym__literal_repeat1] = STATE(53),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [sym__special_character] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [sym_raw_string] = ACTIONS(83),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(85),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [anon_sym_LT_LPAREN] = ACTIONS(91),
    [anon_sym_GT_LPAREN] = ACTIONS(91),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(93),
    [sym_test_operator] = ACTIONS(95),
  },
  [115] = {
    [sym__terminated_statement] = STATE(452),
    [sym_redirected_statement] = STATE(78),
    [sym_for_statement] = STATE(78),
    [sym_c_style_for_statement] = STATE(78),
    [sym_while_statement] = STATE(78),
    [sym_if_statement] = STATE(78),
    [sym_case_statement] = STATE(78),
    [sym_function_definition] = STATE(78),
    [sym_compound_statement] = STATE(78),
    [sym_subshell] = STATE(78),
    [sym_pipeline] = STATE(78),
    [sym_list] = STATE(78),
    [sym_negated_command] = STATE(78),
    [sym_test_command] = STATE(78),
    [sym_declaration_command] = STATE(78),
    [sym_unset_command] = STATE(78),
    [sym_command] = STATE(78),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(80),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(83),
    [sym_concatenation] = STATE(82),
    [sym_string] = STATE(71),
    [sym_simple_expansion] = STATE(71),
    [sym_string_expansion] = STATE(71),
    [sym_expansion] = STATE(71),
    [sym_command_substitution] = STATE(71),
    [sym_process_substitution] = STATE(71),
    [aux_sym_command_repeat1] = STATE(83),
    [aux_sym__literal_repeat1] = STATE(84),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(103),
    [anon_sym_if] = ACTIONS(105),
    [anon_sym_case] = ACTIONS(107),
    [anon_sym_function] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [sym__special_character] = ACTIONS(127),
    [anon_sym_DQUOTE] = ACTIONS(129),
    [sym_raw_string] = ACTIONS(131),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(133),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(135),
    [anon_sym_BQUOTE] = ACTIONS(137),
    [anon_sym_LT_LPAREN] = ACTIONS(139),
    [anon_sym_GT_LPAREN] = ACTIONS(139),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(141),
  },
  [116] = {
    [sym__terminated_statement] = STATE(453),
    [sym_redirected_statement] = STATE(78),
    [sym_for_statement] = STATE(78),
    [sym_c_style_for_statement] = STATE(78),
    [sym_while_statement] = STATE(78),
    [sym_if_statement] = STATE(78),
    [sym_case_statement] = STATE(78),
    [sym_function_definition] = STATE(78),
    [sym_compound_statement] = STATE(78),
    [sym_subshell] = STATE(78),
    [sym_pipeline] = STATE(78),
    [sym_list] = STATE(78),
    [sym_negated_command] = STATE(78),
    [sym_test_command] = STATE(78),
    [sym_declaration_command] = STATE(78),
    [sym_unset_command] = STATE(78),
    [sym_command] = STATE(78),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(80),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(83),
    [sym_concatenation] = STATE(82),
    [sym_string] = STATE(71),
    [sym_simple_expansion] = STATE(71),
    [sym_string_expansion] = STATE(71),
    [sym_expansion] = STATE(71),
    [sym_command_substitution] = STATE(71),
    [sym_process_substitution] = STATE(71),
    [aux_sym_command_repeat1] = STATE(83),
    [aux_sym__literal_repeat1] = STATE(84),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(103),
    [anon_sym_if] = ACTIONS(105),
    [anon_sym_case] = ACTIONS(107),
    [anon_sym_function] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [sym__special_character] = ACTIONS(127),
    [anon_sym_DQUOTE] = ACTIONS(129),
    [sym_raw_string] = ACTIONS(131),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(133),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(135),
    [anon_sym_BQUOTE] = ACTIONS(137),
    [anon_sym_LT_LPAREN] = ACTIONS(139),
    [anon_sym_GT_LPAREN] = ACTIONS(139),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(141),
  },
  [117] = {
    [sym_concatenation] = STATE(455),
    [sym_string] = STATE(454),
    [sym_simple_expansion] = STATE(454),
    [sym_string_expansion] = STATE(454),
    [sym_expansion] = STATE(454),
    [sym_command_substitution] = STATE(454),
    [sym_process_substitution] = STATE(454),
    [aux_sym__literal_repeat1] = STATE(456),
    [anon_sym_DOLLAR] = ACTIONS(143),
    [sym__special_character] = ACTIONS(145),
    [anon_sym_DQUOTE] = ACTIONS(147),
    [sym_raw_string] = ACTIONS(777),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(151),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(153),
    [anon_sym_BQUOTE] = ACTIONS(155),
    [anon_sym_LT_LPAREN] = ACTIONS(157),
    [anon_sym_GT_LPAREN] = ACTIONS(157),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(777),
  },
  [118] = {
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(779),
  },
  [119] = {
    [sym__statements] = STATE(458),
    [sym_redirected_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_c_style_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_case_statement] = STATE(105),
    [sym_function_definition] = STATE(105),
    [sym_compound_statement] = STATE(105),
    [sym_subshell] = STATE(105),
    [sym_pipeline] = STATE(105),
    [sym_list] = STATE(105),
    [sym_negated_command] = STATE(105),
    [sym_test_command] = STATE(105),
    [sym_declaration_command] = STATE(105),
    [sym_unset_command] = STATE(105),
    [sym_command] = STATE(105),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(107),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(110),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(109),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [120] = {
    [sym__statements] = STATE(460),
    [sym_redirected_statement] = STATE(137),
    [sym_for_statement] = STATE(137),
    [sym_c_style_for_statement] = STATE(137),
    [sym_while_statement] = STATE(137),
    [sym_if_statement] = STATE(137),
    [sym_case_statement] = STATE(137),
    [sym_function_definition] = STATE(137),
    [sym_compound_statement] = STATE(137),
    [sym_subshell] = STATE(137),
    [sym_pipeline] = STATE(137),
    [sym_list] = STATE(137),
    [sym_negated_command] = STATE(137),
    [sym_test_command] = STATE(137),
    [sym_declaration_command] = STATE(137),
    [sym_unset_command] = STATE(137),
    [sym_command] = STATE(137),
    [sym_command_name] = STATE(138),
    [sym_variable_assignment] = STATE(139),
    [sym_subscript] = STATE(140),
    [sym_file_redirect] = STATE(143),
    [sym_concatenation] = STATE(141),
    [sym_string] = STATE(130),
    [sym_simple_expansion] = STATE(130),
    [sym_string_expansion] = STATE(130),
    [sym_expansion] = STATE(130),
    [sym_command_substitution] = STATE(130),
    [sym_process_substitution] = STATE(130),
    [aux_sym__statements_repeat1] = STATE(142),
    [aux_sym_command_repeat1] = STATE(143),
    [aux_sym__literal_repeat1] = STATE(144),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(175),
    [anon_sym_for] = ACTIONS(177),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(179),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_case] = ACTIONS(185),
    [anon_sym_function] = ACTIONS(187),
    [anon_sym_LPAREN] = ACTIONS(189),
    [anon_sym_LBRACE] = ACTIONS(191),
    [anon_sym_RBRACE] = ACTIONS(781),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LBRACK] = ACTIONS(197),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(199),
    [anon_sym_declare] = ACTIONS(201),
    [anon_sym_typeset] = ACTIONS(201),
    [anon_sym_export] = ACTIONS(201),
    [anon_sym_readonly] = ACTIONS(201),
    [anon_sym_local] = ACTIONS(201),
    [anon_sym_unset] = ACTIONS(203),
    [anon_sym_unsetenv] = ACTIONS(203),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(205),
    [sym__special_character] = ACTIONS(207),
    [anon_sym_DQUOTE] = ACTIONS(209),
    [sym_raw_string] = ACTIONS(211),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(213),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(215),
    [anon_sym_BQUOTE] = ACTIONS(217),
    [anon_sym_LT_LPAREN] = ACTIONS(219),
    [anon_sym_GT_LPAREN] = ACTIONS(219),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(221),
  },
  [121] = {
    [sym__simple_heredoc_body] = ACTIONS(783),
    [sym__heredoc_body_beginning] = ACTIONS(783),
    [sym_file_descriptor] = ACTIONS(783),
    [ts_builtin_sym_end] = ACTIONS(783),
    [anon_sym_SEMI] = ACTIONS(785),
    [anon_sym_done] = ACTIONS(783),
    [anon_sym_fi] = ACTIONS(783),
    [anon_sym_elif] = ACTIONS(783),
    [anon_sym_else] = ACTIONS(783),
    [anon_sym_esac] = ACTIONS(783),
    [anon_sym_PIPE] = ACTIONS(785),
    [anon_sym_RPAREN] = ACTIONS(783),
    [anon_sym_SEMI_SEMI] = ACTIONS(783),
    [anon_sym_PIPE_AMP] = ACTIONS(783),
    [anon_sym_AMP_AMP] = ACTIONS(783),
    [anon_sym_PIPE_PIPE] = ACTIONS(783),
    [anon_sym_LT] = ACTIONS(785),
    [anon_sym_GT] = ACTIONS(785),
    [anon_sym_GT_GT] = ACTIONS(783),
    [anon_sym_AMP_GT] = ACTIONS(785),
    [anon_sym_AMP_GT_GT] = ACTIONS(783),
    [anon_sym_LT_AMP] = ACTIONS(783),
    [anon_sym_GT_AMP] = ACTIONS(783),
    [anon_sym_LT_LT] = ACTIONS(785),
    [anon_sym_LT_LT_DASH] = ACTIONS(783),
    [anon_sym_LT_LT_LT] = ACTIONS(783),
    [anon_sym_BQUOTE] = ACTIONS(783),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(783),
    [anon_sym_AMP] = ACTIONS(785),
  },
  [122] = {
    [sym_subshell] = STATE(461),
    [sym_test_command] = STATE(461),
    [sym_command] = STATE(461),
    [sym_command_name] = STATE(138),
    [sym_variable_assignment] = STATE(143),
    [sym_subscript] = STATE(147),
    [sym_file_redirect] = STATE(143),
    [sym_concatenation] = STATE(141),
    [sym_string] = STATE(130),
    [sym_simple_expansion] = STATE(130),
    [sym_string_expansion] = STATE(130),
    [sym_expansion] = STATE(130),
    [sym_command_substitution] = STATE(130),
    [sym_process_substitution] = STATE(130),
    [aux_sym_command_repeat1] = STATE(143),
    [aux_sym__literal_repeat1] = STATE(144),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(223),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(179),
    [anon_sym_LPAREN] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(197),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(199),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(205),
    [sym__special_character] = ACTIONS(207),
    [anon_sym_DQUOTE] = ACTIONS(209),
    [sym_raw_string] = ACTIONS(211),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(213),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(215),
    [anon_sym_BQUOTE] = ACTIONS(217),
    [anon_sym_LT_LPAREN] = ACTIONS(219),
    [anon_sym_GT_LPAREN] = ACTIONS(219),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(211),
  },
  [123] = {
    [sym__expression] = STATE(462),
    [sym_binary_expression] = STATE(462),
    [sym_unary_expression] = STATE(462),
    [sym_postfix_expression] = STATE(462),
    [sym_parenthesized_expression] = STATE(462),
    [sym_concatenation] = STATE(462),
    [sym_string] = STATE(153),
    [sym_simple_expansion] = STATE(153),
    [sym_string_expansion] = STATE(153),
    [sym_expansion] = STATE(153),
    [sym_command_substitution] = STATE(153),
    [sym_process_substitution] = STATE(153),
    [aux_sym__literal_repeat1] = STATE(159),
    [anon_sym_LPAREN] = ACTIONS(225),
    [anon_sym_BANG] = ACTIONS(227),
    [anon_sym_DOLLAR] = ACTIONS(229),
    [sym__special_character] = ACTIONS(231),
    [anon_sym_DQUOTE] = ACTIONS(233),
    [sym_raw_string] = ACTIONS(235),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(237),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(239),
    [anon_sym_BQUOTE] = ACTIONS(241),
    [anon_sym_LT_LPAREN] = ACTIONS(243),
    [anon_sym_GT_LPAREN] = ACTIONS(243),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(245),
    [sym_test_operator] = ACTIONS(247),
  },
  [124] = {
    [sym__expression] = STATE(463),
    [sym_binary_expression] = STATE(463),
    [sym_unary_expression] = STATE(463),
    [sym_postfix_expression] = STATE(463),
    [sym_parenthesized_expression] = STATE(463),
    [sym_concatenation] = STATE(463),
    [sym_string] = STATE(162),
    [sym_simple_expansion] = STATE(162),
    [sym_string_expansion] = STATE(162),
    [sym_expansion] = STATE(162),
    [sym_command_substitution] = STATE(162),
    [sym_process_substitution] = STATE(162),
    [aux_sym__literal_repeat1] = STATE(164),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(249),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [sym__special_character] = ACTIONS(251),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [sym_raw_string] = ACTIONS(253),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(85),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [anon_sym_LT_LPAREN] = ACTIONS(91),
    [anon_sym_GT_LPAREN] = ACTIONS(91),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(255),
    [sym_test_operator] = ACTIONS(257),
  },
  [125] = {
    [sym_variable_assignment] = STATE(474),
    [sym_subscript] = STATE(473),
    [sym_concatenation] = STATE(474),
    [sym_string] = STATE(468),
    [sym_simple_expansion] = STATE(468),
    [sym_string_expansion] = STATE(468),
    [sym_expansion] = STATE(468),
    [sym_command_substitution] = STATE(468),
    [sym_process_substitution] = STATE(468),
    [aux_sym_declaration_command_repeat1] = STATE(474),
    [aux_sym__literal_repeat1] = STATE(475),
    [sym__simple_heredoc_body] = ACTIONS(259),
    [sym__heredoc_body_beginning] = ACTIONS(259),
    [sym_file_descriptor] = ACTIONS(259),
    [sym_variable_name] = ACTIONS(787),
    [anon_sym_SEMI] = ACTIONS(263),
    [anon_sym_PIPE] = ACTIONS(263),
    [anon_sym_SEMI_SEMI] = ACTIONS(259),
    [anon_sym_RBRACE] = ACTIONS(259),
    [anon_sym_PIPE_AMP] = ACTIONS(259),
    [anon_sym_AMP_AMP] = ACTIONS(259),
    [anon_sym_PIPE_PIPE] = ACTIONS(259),
    [anon_sym_LT] = ACTIONS(263),
    [anon_sym_GT] = ACTIONS(263),
    [anon_sym_GT_GT] = ACTIONS(259),
    [anon_sym_AMP_GT] = ACTIONS(263),
    [anon_sym_AMP_GT_GT] = ACTIONS(259),
    [anon_sym_LT_AMP] = ACTIONS(259),
    [anon_sym_GT_AMP] = ACTIONS(259),
    [anon_sym_LT_LT] = ACTIONS(263),
    [anon_sym_LT_LT_DASH] = ACTIONS(259),
    [anon_sym_LT_LT_LT] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(789),
    [sym__special_character] = ACTIONS(791),
    [anon_sym_DQUOTE] = ACTIONS(793),
    [sym_raw_string] = ACTIONS(795),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(797),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(799),
    [anon_sym_BQUOTE] = ACTIONS(801),
    [anon_sym_LT_LPAREN] = ACTIONS(803),
    [anon_sym_GT_LPAREN] = ACTIONS(803),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(805),
    [sym_word] = ACTIONS(807),
    [anon_sym_LF] = ACTIONS(259),
    [anon_sym_AMP] = ACTIONS(263),
  },
  [126] = {
    [sym_concatenation] = STATE(484),
    [sym_string] = STATE(479),
    [sym_simple_expansion] = STATE(479),
    [sym_string_expansion] = STATE(479),
    [sym_expansion] = STATE(479),
    [sym_command_substitution] = STATE(479),
    [sym_process_substitution] = STATE(479),
    [aux_sym_unset_command_repeat1] = STATE(484),
    [aux_sym__literal_repeat1] = STATE(485),
    [sym__simple_heredoc_body] = ACTIONS(285),
    [sym__heredoc_body_beginning] = ACTIONS(285),
    [sym_file_descriptor] = ACTIONS(285),
    [anon_sym_SEMI] = ACTIONS(287),
    [anon_sym_PIPE] = ACTIONS(287),
    [anon_sym_SEMI_SEMI] = ACTIONS(285),
    [anon_sym_RBRACE] = ACTIONS(285),
    [anon_sym_PIPE_AMP] = ACTIONS(285),
    [anon_sym_AMP_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(285),
    [anon_sym_LT] = ACTIONS(287),
    [anon_sym_GT] = ACTIONS(287),
    [anon_sym_GT_GT] = ACTIONS(285),
    [anon_sym_AMP_GT] = ACTIONS(287),
    [anon_sym_AMP_GT_GT] = ACTIONS(285),
    [anon_sym_LT_AMP] = ACTIONS(285),
    [anon_sym_GT_AMP] = ACTIONS(285),
    [anon_sym_LT_LT] = ACTIONS(287),
    [anon_sym_LT_LT_DASH] = ACTIONS(285),
    [anon_sym_LT_LT_LT] = ACTIONS(285),
    [anon_sym_DOLLAR] = ACTIONS(809),
    [sym__special_character] = ACTIONS(811),
    [anon_sym_DQUOTE] = ACTIONS(813),
    [sym_raw_string] = ACTIONS(815),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(817),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(819),
    [anon_sym_BQUOTE] = ACTIONS(821),
    [anon_sym_LT_LPAREN] = ACTIONS(823),
    [anon_sym_GT_LPAREN] = ACTIONS(823),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(825),
    [sym_word] = ACTIONS(827),
    [anon_sym_LF] = ACTIONS(285),
    [anon_sym_AMP] = ACTIONS(287),
  },
  [127] = {
    [sym_string] = STATE(487),
    [anon_sym_DASH] = ACTIONS(829),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [anon_sym_DQUOTE] = ACTIONS(209),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_POUND] = ACTIONS(829),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(833),
    [anon_sym_STAR] = ACTIONS(835),
    [anon_sym_AT] = ACTIONS(835),
    [anon_sym_QMARK] = ACTIONS(835),
    [anon_sym_0] = ACTIONS(833),
    [anon_sym__] = ACTIONS(833),
  },
  [128] = {
    [aux_sym_concatenation_repeat1] = STATE(490),
    [sym__simple_heredoc_body] = ACTIONS(335),
    [sym__heredoc_body_beginning] = ACTIONS(335),
    [sym_file_descriptor] = ACTIONS(335),
    [sym__concat] = ACTIONS(837),
    [anon_sym_SEMI] = ACTIONS(339),
    [anon_sym_PIPE] = ACTIONS(339),
    [anon_sym_SEMI_SEMI] = ACTIONS(335),
    [anon_sym_RBRACE] = ACTIONS(335),
    [anon_sym_PIPE_AMP] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_PIPE_PIPE] = ACTIONS(335),
    [anon_sym_EQ_TILDE] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_LT] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(339),
    [anon_sym_GT_GT] = ACTIONS(335),
    [anon_sym_AMP_GT] = ACTIONS(339),
    [anon_sym_AMP_GT_GT] = ACTIONS(335),
    [anon_sym_LT_AMP] = ACTIONS(335),
    [anon_sym_GT_AMP] = ACTIONS(335),
    [anon_sym_LT_LT] = ACTIONS(339),
    [anon_sym_LT_LT_DASH] = ACTIONS(335),
    [anon_sym_LT_LT_LT] = ACTIONS(335),
    [anon_sym_DOLLAR] = ACTIONS(339),
    [sym__special_character] = ACTIONS(339),
    [anon_sym_DQUOTE] = ACTIONS(335),
    [sym_raw_string] = ACTIONS(335),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(335),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(335),
    [anon_sym_LT_LPAREN] = ACTIONS(335),
    [anon_sym_GT_LPAREN] = ACTIONS(335),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(339),
    [anon_sym_LF] = ACTIONS(335),
    [anon_sym_AMP] = ACTIONS(339),
  },
  [129] = {
    [sym_simple_expansion] = STATE(204),
    [sym_expansion] = STATE(204),
    [sym_command_substitution] = STATE(204),
    [aux_sym_string_repeat1] = STATE(493),
    [anon_sym_DOLLAR] = ACTIONS(839),
    [anon_sym_DQUOTE] = ACTIONS(841),
    [sym__string_content] = ACTIONS(345),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(347),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(329),
  },
  [130] = {
    [aux_sym_concatenation_repeat1] = STATE(490),
    [sym__simple_heredoc_body] = ACTIONS(353),
    [sym__heredoc_body_beginning] = ACTIONS(353),
    [sym_file_descriptor] = ACTIONS(353),
    [sym__concat] = ACTIONS(837),
    [anon_sym_SEMI] = ACTIONS(355),
    [anon_sym_PIPE] = ACTIONS(355),
    [anon_sym_SEMI_SEMI] = ACTIONS(353),
    [anon_sym_RBRACE] = ACTIONS(353),
    [anon_sym_PIPE_AMP] = ACTIONS(353),
    [anon_sym_AMP_AMP] = ACTIONS(353),
    [anon_sym_PIPE_PIPE] = ACTIONS(353),
    [anon_sym_EQ_TILDE] = ACTIONS(355),
    [anon_sym_EQ_EQ] = ACTIONS(355),
    [anon_sym_LT] = ACTIONS(355),
    [anon_sym_GT] = ACTIONS(355),
    [anon_sym_GT_GT] = ACTIONS(353),
    [anon_sym_AMP_GT] = ACTIONS(355),
    [anon_sym_AMP_GT_GT] = ACTIONS(353),
    [anon_sym_LT_AMP] = ACTIONS(353),
    [anon_sym_GT_AMP] = ACTIONS(353),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(353),
    [anon_sym_LT_LT_LT] = ACTIONS(353),
    [anon_sym_DOLLAR] = ACTIONS(355),
    [sym__special_character] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(353),
    [sym_raw_string] = ACTIONS(353),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(353),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [anon_sym_LT_LPAREN] = ACTIONS(353),
    [anon_sym_GT_LPAREN] = ACTIONS(353),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(355),
    [anon_sym_LF] = ACTIONS(353),
    [anon_sym_AMP] = ACTIONS(355),
  },
  [131] = {
    [sym_subscript] = STATE(497),
    [sym_variable_name] = ACTIONS(843),
    [anon_sym_BANG] = ACTIONS(845),
    [anon_sym_DASH] = ACTIONS(847),
    [anon_sym_DOLLAR] = ACTIONS(847),
    [anon_sym_POUND] = ACTIONS(845),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(849),
    [anon_sym_STAR] = ACTIONS(851),
    [anon_sym_AT] = ACTIONS(851),
    [anon_sym_QMARK] = ACTIONS(851),
    [anon_sym_0] = ACTIONS(849),
    [anon_sym__] = ACTIONS(849),
  },
  [132] = {
    [sym__statements] = STATE(498),
    [sym_redirected_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_c_style_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_case_statement] = STATE(105),
    [sym_function_definition] = STATE(105),
    [sym_compound_statement] = STATE(105),
    [sym_subshell] = STATE(105),
    [sym_pipeline] = STATE(105),
    [sym_list] = STATE(105),
    [sym_negated_command] = STATE(105),
    [sym_test_command] = STATE(105),
    [sym_declaration_command] = STATE(105),
    [sym_unset_command] = STATE(105),
    [sym_command] = STATE(105),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(107),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(499),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(109),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(371),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(371),
    [anon_sym_LT_AMP] = ACTIONS(371),
    [anon_sym_GT_AMP] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [133] = {
    [sym__statements] = STATE(500),
    [sym_redirected_statement] = STATE(225),
    [sym_for_statement] = STATE(225),
    [sym_c_style_for_statement] = STATE(225),
    [sym_while_statement] = STATE(225),
    [sym_if_statement] = STATE(225),
    [sym_case_statement] = STATE(225),
    [sym_function_definition] = STATE(225),
    [sym_compound_statement] = STATE(225),
    [sym_subshell] = STATE(225),
    [sym_pipeline] = STATE(225),
    [sym_list] = STATE(225),
    [sym_negated_command] = STATE(225),
    [sym_test_command] = STATE(225),
    [sym_declaration_command] = STATE(225),
    [sym_unset_command] = STATE(225),
    [sym_command] = STATE(225),
    [sym_command_name] = STATE(226),
    [sym_variable_assignment] = STATE(227),
    [sym_subscript] = STATE(228),
    [sym_file_redirect] = STATE(230),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(222),
    [sym_simple_expansion] = STATE(222),
    [sym_string_expansion] = STATE(222),
    [sym_expansion] = STATE(222),
    [sym_command_substitution] = STATE(222),
    [sym_process_substitution] = STATE(222),
    [aux_sym__statements_repeat1] = STATE(229),
    [aux_sym_command_repeat1] = STATE(230),
    [aux_sym__literal_repeat1] = STATE(231),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(375),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_typeset] = ACTIONS(377),
    [anon_sym_export] = ACTIONS(377),
    [anon_sym_readonly] = ACTIONS(377),
    [anon_sym_local] = ACTIONS(377),
    [anon_sym_unset] = ACTIONS(379),
    [anon_sym_unsetenv] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(381),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(383),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(385),
  },
  [134] = {
    [sym__statements] = STATE(501),
    [sym_redirected_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_c_style_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_case_statement] = STATE(105),
    [sym_function_definition] = STATE(105),
    [sym_compound_statement] = STATE(105),
    [sym_subshell] = STATE(105),
    [sym_pipeline] = STATE(105),
    [sym_list] = STATE(105),
    [sym_negated_command] = STATE(105),
    [sym_test_command] = STATE(105),
    [sym_declaration_command] = STATE(105),
    [sym_unset_command] = STATE(105),
    [sym_command] = STATE(105),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(107),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(110),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(109),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [135] = {
    [aux_sym_concatenation_repeat1] = STATE(490),
    [sym__simple_heredoc_body] = ACTIONS(353),
    [sym__heredoc_body_beginning] = ACTIONS(353),
    [sym_file_descriptor] = ACTIONS(353),
    [sym__concat] = ACTIONS(837),
    [anon_sym_SEMI] = ACTIONS(355),
    [anon_sym_PIPE] = ACTIONS(355),
    [anon_sym_SEMI_SEMI] = ACTIONS(353),
    [anon_sym_LPAREN] = ACTIONS(853),
    [anon_sym_RBRACE] = ACTIONS(353),
    [anon_sym_PIPE_AMP] = ACTIONS(353),
    [anon_sym_AMP_AMP] = ACTIONS(353),
    [anon_sym_PIPE_PIPE] = ACTIONS(353),
    [anon_sym_EQ_TILDE] = ACTIONS(355),
    [anon_sym_EQ_EQ] = ACTIONS(355),
    [anon_sym_LT] = ACTIONS(355),
    [anon_sym_GT] = ACTIONS(355),
    [anon_sym_GT_GT] = ACTIONS(353),
    [anon_sym_AMP_GT] = ACTIONS(355),
    [anon_sym_AMP_GT_GT] = ACTIONS(353),
    [anon_sym_LT_AMP] = ACTIONS(353),
    [anon_sym_GT_AMP] = ACTIONS(353),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(353),
    [anon_sym_LT_LT_LT] = ACTIONS(353),
    [anon_sym_DOLLAR] = ACTIONS(355),
    [sym__special_character] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(353),
    [sym_raw_string] = ACTIONS(353),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(353),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [anon_sym_LT_LPAREN] = ACTIONS(353),
    [anon_sym_GT_LPAREN] = ACTIONS(353),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(355),
    [anon_sym_LF] = ACTIONS(353),
    [anon_sym_AMP] = ACTIONS(355),
  },
  [136] = {
    [anon_sym_RBRACE] = ACTIONS(855),
    [sym_comment] = ACTIONS(57),
  },
  [137] = {
    [sym_file_redirect] = STATE(514),
    [sym_heredoc_redirect] = STATE(514),
    [sym_heredoc_body] = STATE(513),
    [sym_herestring_redirect] = STATE(514),
    [aux_sym_redirected_statement_repeat1] = STATE(514),
    [sym__simple_heredoc_body] = ACTIONS(857),
    [sym__heredoc_body_beginning] = ACTIONS(859),
    [sym_file_descriptor] = ACTIONS(861),
    [anon_sym_SEMI] = ACTIONS(863),
    [anon_sym_PIPE] = ACTIONS(865),
    [anon_sym_SEMI_SEMI] = ACTIONS(867),
    [anon_sym_RBRACE] = ACTIONS(399),
    [anon_sym_PIPE_AMP] = ACTIONS(869),
    [anon_sym_AMP_AMP] = ACTIONS(871),
    [anon_sym_PIPE_PIPE] = ACTIONS(871),
    [anon_sym_LT] = ACTIONS(873),
    [anon_sym_GT] = ACTIONS(873),
    [anon_sym_GT_GT] = ACTIONS(875),
    [anon_sym_AMP_GT] = ACTIONS(873),
    [anon_sym_AMP_GT_GT] = ACTIONS(875),
    [anon_sym_LT_AMP] = ACTIONS(875),
    [anon_sym_GT_AMP] = ACTIONS(875),
    [anon_sym_LT_LT] = ACTIONS(877),
    [anon_sym_LT_LT_DASH] = ACTIONS(879),
    [anon_sym_LT_LT_LT] = ACTIONS(881),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(867),
    [anon_sym_AMP] = ACTIONS(863),
  },
  [138] = {
    [sym_concatenation] = STATE(517),
    [sym_string] = STATE(516),
    [sym_simple_expansion] = STATE(516),
    [sym_string_expansion] = STATE(516),
    [sym_expansion] = STATE(516),
    [sym_command_substitution] = STATE(516),
    [sym_process_substitution] = STATE(516),
    [aux_sym_command_repeat2] = STATE(517),
    [aux_sym__literal_repeat1] = STATE(518),
    [sym__simple_heredoc_body] = ACTIONS(421),
    [sym__heredoc_body_beginning] = ACTIONS(421),
    [sym_file_descriptor] = ACTIONS(421),
    [anon_sym_SEMI] = ACTIONS(423),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_SEMI_SEMI] = ACTIONS(421),
    [anon_sym_RBRACE] = ACTIONS(421),
    [anon_sym_PIPE_AMP] = ACTIONS(421),
    [anon_sym_AMP_AMP] = ACTIONS(421),
    [anon_sym_PIPE_PIPE] = ACTIONS(421),
    [anon_sym_EQ_TILDE] = ACTIONS(883),
    [anon_sym_EQ_EQ] = ACTIONS(883),
    [anon_sym_LT] = ACTIONS(423),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(421),
    [anon_sym_AMP_GT] = ACTIONS(423),
    [anon_sym_AMP_GT_GT] = ACTIONS(421),
    [anon_sym_LT_AMP] = ACTIONS(421),
    [anon_sym_GT_AMP] = ACTIONS(421),
    [anon_sym_LT_LT] = ACTIONS(423),
    [anon_sym_LT_LT_DASH] = ACTIONS(421),
    [anon_sym_LT_LT_LT] = ACTIONS(421),
    [anon_sym_DOLLAR] = ACTIONS(205),
    [sym__special_character] = ACTIONS(207),
    [anon_sym_DQUOTE] = ACTIONS(209),
    [sym_raw_string] = ACTIONS(885),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(213),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(215),
    [anon_sym_BQUOTE] = ACTIONS(217),
    [anon_sym_LT_LPAREN] = ACTIONS(219),
    [anon_sym_GT_LPAREN] = ACTIONS(219),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(887),
    [anon_sym_LF] = ACTIONS(421),
    [anon_sym_AMP] = ACTIONS(423),
  },
  [139] = {
    [sym_file_redirect] = STATE(514),
    [sym_heredoc_redirect] = STATE(514),
    [sym_heredoc_body] = STATE(513),
    [sym_herestring_redirect] = STATE(514),
    [aux_sym_redirected_statement_repeat1] = STATE(514),
    [sym__simple_heredoc_body] = ACTIONS(857),
    [sym__heredoc_body_beginning] = ACTIONS(859),
    [sym_file_descriptor] = ACTIONS(433),
    [sym_variable_name] = ACTIONS(433),
    [anon_sym_SEMI] = ACTIONS(863),
    [anon_sym_PIPE] = ACTIONS(865),
    [anon_sym_SEMI_SEMI] = ACTIONS(867),
    [anon_sym_RBRACE] = ACTIONS(399),
    [anon_sym_PIPE_AMP] = ACTIONS(869),
    [anon_sym_AMP_AMP] = ACTIONS(871),
    [anon_sym_PIPE_PIPE] = ACTIONS(871),
    [anon_sym_LT] = ACTIONS(435),
    [anon_sym_GT] = ACTIONS(435),
    [anon_sym_GT_GT] = ACTIONS(433),
    [anon_sym_AMP_GT] = ACTIONS(435),
    [anon_sym_AMP_GT_GT] = ACTIONS(433),
    [anon_sym_LT_AMP] = ACTIONS(433),
    [anon_sym_GT_AMP] = ACTIONS(433),
    [anon_sym_LT_LT] = ACTIONS(877),
    [anon_sym_LT_LT_DASH] = ACTIONS(879),
    [anon_sym_LT_LT_LT] = ACTIONS(881),
    [anon_sym_DOLLAR] = ACTIONS(435),
    [sym__special_character] = ACTIONS(435),
    [anon_sym_DQUOTE] = ACTIONS(433),
    [sym_raw_string] = ACTIONS(433),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(433),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(433),
    [anon_sym_BQUOTE] = ACTIONS(433),
    [anon_sym_LT_LPAREN] = ACTIONS(433),
    [anon_sym_GT_LPAREN] = ACTIONS(433),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(435),
    [anon_sym_LF] = ACTIONS(867),
    [anon_sym_AMP] = ACTIONS(863),
  },
  [140] = {
    [anon_sym_EQ] = ACTIONS(771),
    [anon_sym_PLUS_EQ] = ACTIONS(771),
    [sym_comment] = ACTIONS(57),
  },
  [141] = {
    [sym__simple_heredoc_body] = ACTIONS(353),
    [sym__heredoc_body_beginning] = ACTIONS(353),
    [sym_file_descriptor] = ACTIONS(353),
    [anon_sym_SEMI] = ACTIONS(355),
    [anon_sym_PIPE] = ACTIONS(355),
    [anon_sym_SEMI_SEMI] = ACTIONS(353),
    [anon_sym_RBRACE] = ACTIONS(353),
    [anon_sym_PIPE_AMP] = ACTIONS(353),
    [anon_sym_AMP_AMP] = ACTIONS(353),
    [anon_sym_PIPE_PIPE] = ACTIONS(353),
    [anon_sym_EQ_TILDE] = ACTIONS(355),
    [anon_sym_EQ_EQ] = ACTIONS(355),
    [anon_sym_LT] = ACTIONS(355),
    [anon_sym_GT] = ACTIONS(355),
    [anon_sym_GT_GT] = ACTIONS(353),
    [anon_sym_AMP_GT] = ACTIONS(355),
    [anon_sym_AMP_GT_GT] = ACTIONS(353),
    [anon_sym_LT_AMP] = ACTIONS(353),
    [anon_sym_GT_AMP] = ACTIONS(353),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(353),
    [anon_sym_LT_LT_LT] = ACTIONS(353),
    [anon_sym_DOLLAR] = ACTIONS(355),
    [sym__special_character] = ACTIONS(355),
    [anon_sym_DQUOTE] = ACTIONS(353),
    [sym_raw_string] = ACTIONS(353),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(353),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [anon_sym_LT_LPAREN] = ACTIONS(353),
    [anon_sym_GT_LPAREN] = ACTIONS(353),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(355),
    [anon_sym_LF] = ACTIONS(353),
    [anon_sym_AMP] = ACTIONS(355),
  },
  [142] = {
    [sym_redirected_statement] = STATE(519),
    [sym_for_statement] = STATE(519),
    [sym_c_style_for_statement] = STATE(519),
    [sym_while_statement] = STATE(519),
    [sym_if_statement] = STATE(519),
    [sym_case_statement] = STATE(519),
    [sym_function_definition] = STATE(519),
    [sym_compound_statement] = STATE(519),
    [sym_subshell] = STATE(519),
    [sym_pipeline] = STATE(519),
    [sym_list] = STATE(519),
    [sym_negated_command] = STATE(519),
    [sym_test_command] = STATE(519),
    [sym_declaration_command] = STATE(519),
    [sym_unset_command] = STATE(519),
    [sym_command] = STATE(519),
    [sym_command_name] = STATE(138),
    [sym_variable_assignment] = STATE(520),
    [sym_subscript] = STATE(140),
    [sym_file_redirect] = STATE(143),
    [sym_concatenation] = STATE(141),
    [sym_string] = STATE(130),
    [sym_simple_expansion] = STATE(130),
    [sym_string_expansion] = STATE(130),
    [sym_expansion] = STATE(130),
    [sym_command_substitution] = STATE(130),
    [sym_process_substitution] = STATE(130),
    [aux_sym__statements_repeat1] = STATE(251),
    [aux_sym_command_repeat1] = STATE(143),
    [aux_sym__literal_repeat1] = STATE(144),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(175),
    [anon_sym_for] = ACTIONS(177),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(179),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_case] = ACTIONS(185),
    [anon_sym_function] = ACTIONS(187),
    [anon_sym_LPAREN] = ACTIONS(189),
    [anon_sym_LBRACE] = ACTIONS(191),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_LBRACK] = ACTIONS(197),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(199),
    [anon_sym_declare] = ACTIONS(201),
    [anon_sym_typeset] = ACTIONS(201),
    [anon_sym_export] = ACTIONS(201),
    [anon_sym_readonly] = ACTIONS(201),
    [anon_sym_local] = ACTIONS(201),
    [anon_sym_unset] = ACTIONS(203),
    [anon_sym_unsetenv] = ACTIONS(203),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(205),
    [sym__special_character] = ACTIONS(207),
    [anon_sym_DQUOTE] = ACTIONS(209),
    [sym_raw_string] = ACTIONS(211),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(213),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(215),
    [anon_sym_BQUOTE] = ACTIONS(217),
    [anon_sym_LT_LPAREN] = ACTIONS(219),
    [anon_sym_GT_LPAREN] = ACTIONS(219),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(221),
  },
  [143] = {
    [sym_command_name] = STATE(521),
    [sym_variable_assignment] = STATE(253),
    [sym_subscript] = STATE(147),
    [sym_file_redirect] = STATE(253),
    [sym_concatenation] = STATE(141),
    [sym_string] = STATE(130),
    [sym_simple_expansion] = STATE(130),
    [sym_string_expansion] = STATE(130),
    [sym_expansion] = STATE(130),
    [sym_command_substitution] = STATE(130),
    [sym_process_substitution] = STATE(130),
    [aux_sym_command_repeat1] = STATE(253),
    [aux_sym__literal_repeat1] = STATE(144),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(223),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(205),
    [sym__special_character] = ACTIONS(889),
    [anon_sym_DQUOTE] = ACTIONS(209),
    [sym_raw_string] = ACTIONS(211),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(213),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(215),
    [anon_sym_BQUOTE] = ACTIONS(217),
    [anon_sym_LT_LPAREN] = ACTIONS(219),
    [anon_sym_GT_LPAREN] = ACTIONS(219),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(211),
  },
  [144] = {
    [aux_sym__literal_repeat1] = STATE(523),
    [sym__simple_heredoc_body] = ACTIONS(437),
    [sym__heredoc_body_beginning] = ACTIONS(437),
    [sym_file_descriptor] = ACTIONS(437),
    [anon_sym_SEMI] = ACTIONS(439),
    [anon_sym_PIPE] = ACTIONS(439),
    [anon_sym_SEMI_SEMI] = ACTIONS(437),
    [anon_sym_RBRACE] = ACTIONS(437),
    [anon_sym_PIPE_AMP] = ACTIONS(437),
    [anon_sym_AMP_AMP] = ACTIONS(437),
    [anon_sym_PIPE_PIPE] = ACTIONS(437),
    [anon_sym_EQ_TILDE] = ACTIONS(439),
    [anon_sym_EQ_EQ] = ACTIONS(439),
    [anon_sym_LT] = ACTIONS(439),
    [anon_sym_GT] = ACTIONS(439),
    [anon_sym_GT_GT] = ACTIONS(437),
    [anon_sym_AMP_GT] = ACTIONS(439),
    [anon_sym_AMP_GT_GT] = ACTIONS(437),
    [anon_sym_LT_AMP] = ACTIONS(437),
    [anon_sym_GT_AMP] = ACTIONS(437),
    [anon_sym_LT_LT] = ACTIONS(439),
    [anon_sym_LT_LT_DASH] = ACTIONS(437),
    [anon_sym_LT_LT_LT] = ACTIONS(437),
    [anon_sym_DOLLAR] = ACTIONS(439),
    [sym__special_character] = ACTIONS(891),
    [anon_sym_DQUOTE] = ACTIONS(437),
    [sym_raw_string] = ACTIONS(437),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(437),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(437),
    [anon_sym_BQUOTE] = ACTIONS(437),
    [anon_sym_LT_LPAREN] = ACTIONS(437),
    [anon_sym_GT_LPAREN] = ACTIONS(437),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(439),
    [anon_sym_LF] = ACTIONS(437),
    [anon_sym_AMP] = ACTIONS(439),
  },
  [145] = {
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_EQ] = ACTIONS(893),
    [anon_sym_PLUS_EQ] = ACTIONS(893),
    [sym_comment] = ACTIONS(57),
  },
  [146] = {
    [sym__simple_heredoc_body] = ACTIONS(895),
    [sym__heredoc_body_beginning] = ACTIONS(895),
    [sym_file_descriptor] = ACTIONS(895),
    [ts_builtin_sym_end] = ACTIONS(895),
    [anon_sym_SEMI] = ACTIONS(897),
    [anon_sym_done] = ACTIONS(895),
    [anon_sym_fi] = ACTIONS(895),
    [anon_sym_elif] = ACTIONS(895),
    [anon_sym_else] = ACTIONS(895),
    [anon_sym_esac] = ACTIONS(895),
    [anon_sym_PIPE] = ACTIONS(897),
    [anon_sym_RPAREN] = ACTIONS(895),
    [anon_sym_SEMI_SEMI] = ACTIONS(895),
    [anon_sym_PIPE_AMP] = ACTIONS(895),
    [anon_sym_AMP_AMP] = ACTIONS(895),
    [anon_sym_PIPE_PIPE] = ACTIONS(895),
    [anon_sym_LT] = ACTIONS(897),
    [anon_sym_GT] = ACTIONS(897),
    [anon_sym_GT_GT] = ACTIONS(895),
    [anon_sym_AMP_GT] = ACTIONS(897),
    [anon_sym_AMP_GT_GT] = ACTIONS(895),
    [anon_sym_LT_AMP] = ACTIONS(895),
    [anon_sym_GT_AMP] = ACTIONS(895),
    [anon_sym_LT_LT] = ACTIONS(897),
    [anon_sym_LT_LT_DASH] = ACTIONS(895),
    [anon_sym_LT_LT_LT] = ACTIONS(895),
    [anon_sym_BQUOTE] = ACTIONS(895),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(895),
    [anon_sym_AMP] = ACTIONS(897),
  },
  [147] = {
    [anon_sym_EQ] = ACTIONS(893),
    [anon_sym_PLUS_EQ] = ACTIONS(893),
    [sym_comment] = ACTIONS(57),
  },
  [148] = {
    [sym__expression] = STATE(525),
    [sym_binary_expression] = STATE(525),
    [sym_unary_expression] = STATE(525),
    [sym_postfix_expression] = STATE(525),
    [sym_parenthesized_expression] = STATE(525),
    [sym_concatenation] = STATE(525),
    [sym_string] = STATE(294),
    [sym_simple_expansion] = STATE(294),
    [sym_string_expansion] = STATE(294),
    [sym_expansion] = STATE(294),
    [sym_command_substitution] = STATE(294),
    [sym_process_substitution] = STATE(294),
    [aux_sym__literal_repeat1] = STATE(300),
    [anon_sym_LPAREN] = ACTIONS(503),
    [anon_sym_BANG] = ACTIONS(505),
    [anon_sym_DOLLAR] = ACTIONS(507),
    [sym__special_character] = ACTIONS(509),
    [anon_sym_DQUOTE] = ACTIONS(511),
    [sym_raw_string] = ACTIONS(513),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(515),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(517),
    [anon_sym_BQUOTE] = ACTIONS(519),
    [anon_sym_LT_LPAREN] = ACTIONS(521),
    [anon_sym_GT_LPAREN] = ACTIONS(521),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(523),
    [sym_test_operator] = ACTIONS(525),
  },
  [149] = {
    [sym__expression] = STATE(526),
    [sym_binary_expression] = STATE(526),
    [sym_unary_expression] = STATE(526),
    [sym_postfix_expression] = STATE(526),
    [sym_parenthesized_expression] = STATE(526),
    [sym_concatenation] = STATE(526),
    [sym_string] = STATE(153),
    [sym_simple_expansion] = STATE(153),
    [sym_string_expansion] = STATE(153),
    [sym_expansion] = STATE(153),
    [sym_command_substitution] = STATE(153),
    [sym_process_substitution] = STATE(153),
    [aux_sym__literal_repeat1] = STATE(159),
    [anon_sym_LPAREN] = ACTIONS(225),
    [anon_sym_BANG] = ACTIONS(227),
    [anon_sym_DOLLAR] = ACTIONS(229),
    [sym__special_character] = ACTIONS(231),
    [anon_sym_DQUOTE] = ACTIONS(233),
    [sym_raw_string] = ACTIONS(235),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(237),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(239),
    [anon_sym_BQUOTE] = ACTIONS(241),
    [anon_sym_LT_LPAREN] = ACTIONS(243),
    [anon_sym_GT_LPAREN] = ACTIONS(243),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(245),
    [sym_test_operator] = ACTIONS(247),
  },
  [150] = {
    [sym_string] = STATE(528),
    [anon_sym_DASH] = ACTIONS(899),
    [anon_sym_DOLLAR] = ACTIONS(899),
    [anon_sym_DQUOTE] = ACTIONS(233),
    [sym_raw_string] = ACTIONS(901),
    [anon_sym_POUND] = ACTIONS(899),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(903),
    [anon_sym_STAR] = ACTIONS(905),
    [anon_sym_AT] = ACTIONS(905),
    [anon_sym_QMARK] = ACTIONS(905),
    [anon_sym_0] = ACTIONS(903),
    [anon_sym__] = ACTIONS(903),
  },
  [151] = {
    [aux_sym_concatenation_repeat1] = STATE(531),
    [sym__concat] = ACTIONS(907),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_PIPE_PIPE] = ACTIONS(335),
    [anon_sym_RBRACK] = ACTIONS(335),
    [anon_sym_EQ_TILDE] = ACTIONS(335),
    [anon_sym_EQ_EQ] = ACTIONS(335),
    [anon_sym_EQ] = ACTIONS(339),
    [anon_sym_PLUS_EQ] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(335),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_DASH_EQ] = ACTIONS(335),
    [anon_sym_LT_EQ] = ACTIONS(335),
    [anon_sym_GT_EQ] = ACTIONS(335),
    [anon_sym_PLUS_PLUS] = ACTIONS(335),
    [anon_sym_DASH_DASH] = ACTIONS(335),
    [sym__special_character] = ACTIONS(339),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(335),
  },
  [152] = {
    [sym_simple_expansion] = STATE(204),
    [sym_expansion] = STATE(204),
    [sym_command_substitution] = STATE(204),
    [aux_sym_string_repeat1] = STATE(534),
    [anon_sym_DOLLAR] = ACTIONS(909),
    [anon_sym_DQUOTE] = ACTIONS(911),
    [sym__string_content] = ACTIONS(345),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(347),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(329),
  },
  [153] = {
    [aux_sym_concatenation_repeat1] = STATE(531),
    [sym__concat] = ACTIONS(907),
    [anon_sym_AMP_AMP] = ACTIONS(541),
    [anon_sym_PIPE_PIPE] = ACTIONS(541),
    [anon_sym_RBRACK] = ACTIONS(541),
    [anon_sym_EQ_TILDE] = ACTIONS(541),
    [anon_sym_EQ_EQ] = ACTIONS(541),
    [anon_sym_EQ] = ACTIONS(543),
    [anon_sym_PLUS_EQ] = ACTIONS(541),
    [anon_sym_LT] = ACTIONS(543),
    [anon_sym_GT] = ACTIONS(543),
    [anon_sym_BANG_EQ] = ACTIONS(541),
    [anon_sym_PLUS] = ACTIONS(543),
    [anon_sym_DASH] = ACTIONS(543),
    [anon_sym_DASH_EQ] = ACTIONS(541),
    [anon_sym_LT_EQ] = ACTIONS(541),
    [anon_sym_GT_EQ] = ACTIONS(541),
    [anon_sym_PLUS_PLUS] = ACTIONS(541),
    [anon_sym_DASH_DASH] = ACTIONS(541),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(541),
  },
  [154] = {
    [sym_subscript] = STATE(538),
    [sym_variable_name] = ACTIONS(913),
    [anon_sym_BANG] = ACTIONS(915),
    [anon_sym_DASH] = ACTIONS(917),
    [anon_sym_DOLLAR] = ACTIONS(917),
    [anon_sym_POUND] = ACTIONS(915),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(919),
    [anon_sym_STAR] = ACTIONS(921),
    [anon_sym_AT] = ACTIONS(921),
    [anon_sym_QMARK] = ACTIONS(921),
    [anon_sym_0] = ACTIONS(919),
    [anon_sym__] = ACTIONS(919),
  },
  [155] = {
    [sym__statements] = STATE(539),
    [sym_redirected_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_c_style_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_case_statement] = STATE(105),
    [sym_function_definition] = STATE(105),
    [sym_compound_statement] = STATE(105),
    [sym_subshell] = STATE(105),
    [sym_pipeline] = STATE(105),
    [sym_list] = STATE(105),
    [sym_negated_command] = STATE(105),
    [sym_test_command] = STATE(105),
    [sym_declaration_command] = STATE(105),
    [sym_unset_command] = STATE(105),
    [sym_command] = STATE(105),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(107),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(540),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(109),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(371),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(371),
    [anon_sym_LT_AMP] = ACTIONS(371),
    [anon_sym_GT_AMP] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [156] = {
    [sym__statements] = STATE(541),
    [sym_redirected_statement] = STATE(225),
    [sym_for_statement] = STATE(225),
    [sym_c_style_for_statement] = STATE(225),
    [sym_while_statement] = STATE(225),
    [sym_if_statement] = STATE(225),
    [sym_case_statement] = STATE(225),
    [sym_function_definition] = STATE(225),
    [sym_compound_statement] = STATE(225),
    [sym_subshell] = STATE(225),
    [sym_pipeline] = STATE(225),
    [sym_list] = STATE(225),
    [sym_negated_command] = STATE(225),
    [sym_test_command] = STATE(225),
    [sym_declaration_command] = STATE(225),
    [sym_unset_command] = STATE(225),
    [sym_command] = STATE(225),
    [sym_command_name] = STATE(226),
    [sym_variable_assignment] = STATE(227),
    [sym_subscript] = STATE(228),
    [sym_file_redirect] = STATE(230),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(222),
    [sym_simple_expansion] = STATE(222),
    [sym_string_expansion] = STATE(222),
    [sym_expansion] = STATE(222),
    [sym_command_substitution] = STATE(222),
    [sym_process_substitution] = STATE(222),
    [aux_sym__statements_repeat1] = STATE(229),
    [aux_sym_command_repeat1] = STATE(230),
    [aux_sym__literal_repeat1] = STATE(231),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(375),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_typeset] = ACTIONS(377),
    [anon_sym_export] = ACTIONS(377),
    [anon_sym_readonly] = ACTIONS(377),
    [anon_sym_local] = ACTIONS(377),
    [anon_sym_unset] = ACTIONS(379),
    [anon_sym_unsetenv] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(381),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(383),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(385),
  },
  [157] = {
    [sym__statements] = STATE(542),
    [sym_redirected_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_c_style_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_case_statement] = STATE(105),
    [sym_function_definition] = STATE(105),
    [sym_compound_statement] = STATE(105),
    [sym_subshell] = STATE(105),
    [sym_pipeline] = STATE(105),
    [sym_list] = STATE(105),
    [sym_negated_command] = STATE(105),
    [sym_test_command] = STATE(105),
    [sym_declaration_command] = STATE(105),
    [sym_unset_command] = STATE(105),
    [sym_command] = STATE(105),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(107),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(110),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(109),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [158] = {
    [anon_sym_AMP_AMP] = ACTIONS(923),
    [anon_sym_PIPE_PIPE] = ACTIONS(923),
    [anon_sym_RBRACK] = ACTIONS(555),
    [anon_sym_EQ_TILDE] = ACTIONS(925),
    [anon_sym_EQ_EQ] = ACTIONS(925),
    [anon_sym_EQ] = ACTIONS(927),
    [anon_sym_PLUS_EQ] = ACTIONS(923),
    [anon_sym_LT] = ACTIONS(927),
    [anon_sym_GT] = ACTIONS(927),
    [anon_sym_BANG_EQ] = ACTIONS(923),
    [anon_sym_PLUS] = ACTIONS(927),
    [anon_sym_DASH] = ACTIONS(927),
    [anon_sym_DASH_EQ] = ACTIONS(923),
    [anon_sym_LT_EQ] = ACTIONS(923),
    [anon_sym_GT_EQ] = ACTIONS(923),
    [anon_sym_PLUS_PLUS] = ACTIONS(929),
    [anon_sym_DASH_DASH] = ACTIONS(929),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(923),
  },
  [159] = {
    [aux_sym__literal_repeat1] = STATE(547),
    [anon_sym_AMP_AMP] = ACTIONS(565),
    [anon_sym_PIPE_PIPE] = ACTIONS(565),
    [anon_sym_RBRACK] = ACTIONS(565),
    [anon_sym_EQ_TILDE] = ACTIONS(565),
    [anon_sym_EQ_EQ] = ACTIONS(565),
    [anon_sym_EQ] = ACTIONS(567),
    [anon_sym_PLUS_EQ] = ACTIONS(565),
    [anon_sym_LT] = ACTIONS(567),
    [anon_sym_GT] = ACTIONS(567),
    [anon_sym_BANG_EQ] = ACTIONS(565),
    [anon_sym_PLUS] = ACTIONS(567),
    [anon_sym_DASH] = ACTIONS(567),
    [anon_sym_DASH_EQ] = ACTIONS(565),
    [anon_sym_LT_EQ] = ACTIONS(565),
    [anon_sym_GT_EQ] = ACTIONS(565),
    [anon_sym_PLUS_PLUS] = ACTIONS(565),
    [anon_sym_DASH_DASH] = ACTIONS(565),
    [sym__special_character] = ACTIONS(931),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(565),
  },
  [160] = {
    [sym__expression] = STATE(548),
    [sym_binary_expression] = STATE(548),
    [sym_unary_expression] = STATE(548),
    [sym_postfix_expression] = STATE(548),
    [sym_parenthesized_expression] = STATE(548),
    [sym_concatenation] = STATE(548),
    [sym_string] = STATE(162),
    [sym_simple_expansion] = STATE(162),
    [sym_string_expansion] = STATE(162),
    [sym_expansion] = STATE(162),
    [sym_command_substitution] = STATE(162),
    [sym_process_substitution] = STATE(162),
    [aux_sym__literal_repeat1] = STATE(164),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(249),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [sym__special_character] = ACTIONS(251),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [sym_raw_string] = ACTIONS(253),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(85),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [anon_sym_LT_LPAREN] = ACTIONS(91),
    [anon_sym_GT_LPAREN] = ACTIONS(91),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(255),
    [sym_test_operator] = ACTIONS(257),
  },
  [161] = {
    [aux_sym_concatenation_repeat1] = STATE(549),
    [sym__concat] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_PIPE_PIPE] = ACTIONS(335),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(335),
    [anon_sym_EQ_TILDE] = ACTIONS(335),
    [anon_sym_EQ_EQ] = ACTIONS(335),
    [anon_sym_EQ] = ACTIONS(339),
    [anon_sym_PLUS_EQ] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(335),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_DASH_EQ] = ACTIONS(335),
    [anon_sym_LT_EQ] = ACTIONS(335),
    [anon_sym_GT_EQ] = ACTIONS(335),
    [anon_sym_PLUS_PLUS] = ACTIONS(335),
    [anon_sym_DASH_DASH] = ACTIONS(335),
    [sym__special_character] = ACTIONS(339),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(335),
  },
  [162] = {
    [aux_sym_concatenation_repeat1] = STATE(549),
    [sym__concat] = ACTIONS(535),
    [anon_sym_AMP_AMP] = ACTIONS(541),
    [anon_sym_PIPE_PIPE] = ACTIONS(541),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(541),
    [anon_sym_EQ_TILDE] = ACTIONS(541),
    [anon_sym_EQ_EQ] = ACTIONS(541),
    [anon_sym_EQ] = ACTIONS(543),
    [anon_sym_PLUS_EQ] = ACTIONS(541),
    [anon_sym_LT] = ACTIONS(543),
    [anon_sym_GT] = ACTIONS(543),
    [anon_sym_BANG_EQ] = ACTIONS(541),
    [anon_sym_PLUS] = ACTIONS(543),
    [anon_sym_DASH] = ACTIONS(543),
    [anon_sym_DASH_EQ] = ACTIONS(541),
    [anon_sym_LT_EQ] = ACTIONS(541),
    [anon_sym_GT_EQ] = ACTIONS(541),
    [anon_sym_PLUS_PLUS] = ACTIONS(541),
    [anon_sym_DASH_DASH] = ACTIONS(541),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(541),
  },
  [163] = {
    [anon_sym_AMP_AMP] = ACTIONS(933),
    [anon_sym_PIPE_PIPE] = ACTIONS(933),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(555),
    [anon_sym_EQ_TILDE] = ACTIONS(935),
    [anon_sym_EQ_EQ] = ACTIONS(935),
    [anon_sym_EQ] = ACTIONS(937),
    [anon_sym_PLUS_EQ] = ACTIONS(933),
    [anon_sym_LT] = ACTIONS(937),
    [anon_sym_GT] = ACTIONS(937),
    [anon_sym_BANG_EQ] = ACTIONS(933),
    [anon_sym_PLUS] = ACTIONS(937),
    [anon_sym_DASH] = ACTIONS(937),
    [anon_sym_DASH_EQ] = ACTIONS(933),
    [anon_sym_LT_EQ] = ACTIONS(933),
    [anon_sym_GT_EQ] = ACTIONS(933),
    [anon_sym_PLUS_PLUS] = ACTIONS(563),
    [anon_sym_DASH_DASH] = ACTIONS(563),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(933),
  },
  [164] = {
    [aux_sym__literal_repeat1] = STATE(553),
    [anon_sym_AMP_AMP] = ACTIONS(565),
    [anon_sym_PIPE_PIPE] = ACTIONS(565),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(565),
    [anon_sym_EQ_TILDE] = ACTIONS(565),
    [anon_sym_EQ_EQ] = ACTIONS(565),
    [anon_sym_EQ] = ACTIONS(567),
    [anon_sym_PLUS_EQ] = ACTIONS(565),
    [anon_sym_LT] = ACTIONS(567),
    [anon_sym_GT] = ACTIONS(567),
    [anon_sym_BANG_EQ] = ACTIONS(565),
    [anon_sym_PLUS] = ACTIONS(567),
    [anon_sym_DASH] = ACTIONS(567),
    [anon_sym_DASH_EQ] = ACTIONS(565),
    [anon_sym_LT_EQ] = ACTIONS(565),
    [anon_sym_GT_EQ] = ACTIONS(565),
    [anon_sym_PLUS_PLUS] = ACTIONS(565),
    [anon_sym_DASH_DASH] = ACTIONS(565),
    [sym__special_character] = ACTIONS(939),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(565),
  },
  [165] = {
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_EQ] = ACTIONS(941),
    [anon_sym_PLUS_EQ] = ACTIONS(941),
    [sym_comment] = ACTIONS(57),
  },
  [166] = {
    [sym_string] = STATE(556),
    [anon_sym_DASH] = ACTIONS(943),
    [anon_sym_DOLLAR] = ACTIONS(943),
    [anon_sym_DQUOTE] = ACTIONS(269),
    [sym_raw_string] = ACTIONS(945),
    [anon_sym_POUND] = ACTIONS(943),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(947),
    [anon_sym_STAR] = ACTIONS(949),
    [anon_sym_AT] = ACTIONS(949),
    [anon_sym_QMARK] = ACTIONS(949),
    [anon_sym_0] = ACTIONS(947),
    [anon_sym__] = ACTIONS(947),
  },
  [167] = {
    [aux_sym_concatenation_repeat1] = STATE(559),
    [sym__simple_heredoc_body] = ACTIONS(335),
    [sym__heredoc_body_beginning] = ACTIONS(335),
    [sym_file_descriptor] = ACTIONS(335),
    [sym__concat] = ACTIONS(951),
    [sym_variable_name] = ACTIONS(335),
    [ts_builtin_sym_end] = ACTIONS(335),
    [anon_sym_SEMI] = ACTIONS(339),
    [anon_sym_PIPE] = ACTIONS(339),
    [anon_sym_SEMI_SEMI] = ACTIONS(335),
    [anon_sym_PIPE_AMP] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_PIPE_PIPE] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(339),
    [anon_sym_GT_GT] = ACTIONS(335),
    [anon_sym_AMP_GT] = ACTIONS(339),
    [anon_sym_AMP_GT_GT] = ACTIONS(335),
    [anon_sym_LT_AMP] = ACTIONS(335),
    [anon_sym_GT_AMP] = ACTIONS(335),
    [anon_sym_LT_LT] = ACTIONS(339),
    [anon_sym_LT_LT_DASH] = ACTIONS(335),
    [anon_sym_LT_LT_LT] = ACTIONS(335),
    [anon_sym_DOLLAR] = ACTIONS(339),
    [sym__special_character] = ACTIONS(335),
    [anon_sym_DQUOTE] = ACTIONS(335),
    [sym_raw_string] = ACTIONS(335),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(335),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(335),
    [anon_sym_LT_LPAREN] = ACTIONS(335),
    [anon_sym_GT_LPAREN] = ACTIONS(335),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(339),
    [sym_word] = ACTIONS(339),
    [anon_sym_LF] = ACTIONS(335),
    [anon_sym_AMP] = ACTIONS(339),
  },
  [168] = {
    [sym_simple_expansion] = STATE(204),
    [sym_expansion] = STATE(204),
    [sym_command_substitution] = STATE(204),
    [aux_sym_string_repeat1] = STATE(562),
    [anon_sym_DOLLAR] = ACTIONS(953),
    [anon_sym_DQUOTE] = ACTIONS(955),
    [sym__string_content] = ACTIONS(345),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(347),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(329),
  },
  [169] = {
    [aux_sym_concatenation_repeat1] = STATE(559),
    [sym__simple_heredoc_body] = ACTIONS(957),
    [sym__heredoc_body_beginning] = ACTIONS(957),
    [sym_file_descriptor] = ACTIONS(957),
    [sym__concat] = ACTIONS(951),
    [sym_variable_name] = ACTIONS(957),
    [ts_builtin_sym_end] = ACTIONS(957),
    [anon_sym_SEMI] = ACTIONS(959),
    [anon_sym_PIPE] = ACTIONS(959),
    [anon_sym_SEMI_SEMI] = ACTIONS(957),
    [anon_sym_PIPE_AMP] = ACTIONS(957),
    [anon_sym_AMP_AMP] = ACTIONS(957),
    [anon_sym_PIPE_PIPE] = ACTIONS(957),
    [anon_sym_LT] = ACTIONS(959),
    [anon_sym_GT] = ACTIONS(959),
    [anon_sym_GT_GT] = ACTIONS(957),
    [anon_sym_AMP_GT] = ACTIONS(959),
    [anon_sym_AMP_GT_GT] = ACTIONS(957),
    [anon_sym_LT_AMP] = ACTIONS(957),
    [anon_sym_GT_AMP] = ACTIONS(957),
    [anon_sym_LT_LT] = ACTIONS(959),
    [anon_sym_LT_LT_DASH] = ACTIONS(957),
    [anon_sym_LT_LT_LT] = ACTIONS(957),
    [anon_sym_DOLLAR] = ACTIONS(959),
    [sym__special_character] = ACTIONS(957),
    [anon_sym_DQUOTE] = ACTIONS(957),
    [sym_raw_string] = ACTIONS(957),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(957),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(957),
    [anon_sym_BQUOTE] = ACTIONS(957),
    [anon_sym_LT_LPAREN] = ACTIONS(957),
    [anon_sym_GT_LPAREN] = ACTIONS(957),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(959),
    [sym_word] = ACTIONS(959),
    [anon_sym_LF] = ACTIONS(957),
    [anon_sym_AMP] = ACTIONS(959),
  },
  [170] = {
    [sym_subscript] = STATE(566),
    [sym_variable_name] = ACTIONS(961),
    [anon_sym_BANG] = ACTIONS(963),
    [anon_sym_DASH] = ACTIONS(965),
    [anon_sym_DOLLAR] = ACTIONS(965),
    [anon_sym_POUND] = ACTIONS(963),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(967),
    [anon_sym_STAR] = ACTIONS(969),
    [anon_sym_AT] = ACTIONS(969),
    [anon_sym_QMARK] = ACTIONS(969),
    [anon_sym_0] = ACTIONS(967),
    [anon_sym__] = ACTIONS(967),
  },
  [171] = {
    [sym__statements] = STATE(567),
    [sym_redirected_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_c_style_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_case_statement] = STATE(105),
    [sym_function_definition] = STATE(105),
    [sym_compound_statement] = STATE(105),
    [sym_subshell] = STATE(105),
    [sym_pipeline] = STATE(105),
    [sym_list] = STATE(105),
    [sym_negated_command] = STATE(105),
    [sym_test_command] = STATE(105),
    [sym_declaration_command] = STATE(105),
    [sym_unset_command] = STATE(105),
    [sym_command] = STATE(105),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(107),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(568),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(109),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(371),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(371),
    [anon_sym_LT_AMP] = ACTIONS(371),
    [anon_sym_GT_AMP] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [172] = {
    [sym__statements] = STATE(569),
    [sym_redirected_statement] = STATE(225),
    [sym_for_statement] = STATE(225),
    [sym_c_style_for_statement] = STATE(225),
    [sym_while_statement] = STATE(225),
    [sym_if_statement] = STATE(225),
    [sym_case_statement] = STATE(225),
    [sym_function_definition] = STATE(225),
    [sym_compound_statement] = STATE(225),
    [sym_subshell] = STATE(225),
    [sym_pipeline] = STATE(225),
    [sym_list] = STATE(225),
    [sym_negated_command] = STATE(225),
    [sym_test_command] = STATE(225),
    [sym_declaration_command] = STATE(225),
    [sym_unset_command] = STATE(225),
    [sym_command] = STATE(225),
    [sym_command_name] = STATE(226),
    [sym_variable_assignment] = STATE(227),
    [sym_subscript] = STATE(228),
    [sym_file_redirect] = STATE(230),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(222),
    [sym_simple_expansion] = STATE(222),
    [sym_string_expansion] = STATE(222),
    [sym_expansion] = STATE(222),
    [sym_command_substitution] = STATE(222),
    [sym_process_substitution] = STATE(222),
    [aux_sym__statements_repeat1] = STATE(229),
    [aux_sym_command_repeat1] = STATE(230),
    [aux_sym__literal_repeat1] = STATE(231),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(375),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_typeset] = ACTIONS(377),
    [anon_sym_export] = ACTIONS(377),
    [anon_sym_readonly] = ACTIONS(377),
    [anon_sym_local] = ACTIONS(377),
    [anon_sym_unset] = ACTIONS(379),
    [anon_sym_unsetenv] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(381),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(383),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(385),
  },
  [173] = {
    [sym__statements] = STATE(570),
    [sym_redirected_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_c_style_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_case_statement] = STATE(105),
    [sym_function_definition] = STATE(105),
    [sym_compound_statement] = STATE(105),
    [sym_subshell] = STATE(105),
    [sym_pipeline] = STATE(105),
    [sym_list] = STATE(105),
    [sym_negated_command] = STATE(105),
    [sym_test_command] = STATE(105),
    [sym_declaration_command] = STATE(105),
    [sym_unset_command] = STATE(105),
    [sym_command] = STATE(105),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(107),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(110),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(109),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [174] = {
    [anon_sym_EQ] = ACTIONS(941),
    [anon_sym_PLUS_EQ] = ACTIONS(941),
    [sym_comment] = ACTIONS(57),
  },
  [175] = {
    [sym_variable_assignment] = STATE(571),
    [sym_subscript] = STATE(174),
    [sym_concatenation] = STATE(571),
    [sym_string] = STATE(169),
    [sym_simple_expansion] = STATE(169),
    [sym_string_expansion] = STATE(169),
    [sym_expansion] = STATE(169),
    [sym_command_substitution] = STATE(169),
    [sym_process_substitution] = STATE(169),
    [aux_sym_declaration_command_repeat1] = STATE(571),
    [aux_sym__literal_repeat1] = STATE(176),
    [sym__simple_heredoc_body] = ACTIONS(971),
    [sym__heredoc_body_beginning] = ACTIONS(971),
    [sym_file_descriptor] = ACTIONS(971),
    [sym_variable_name] = ACTIONS(261),
    [ts_builtin_sym_end] = ACTIONS(971),
    [anon_sym_SEMI] = ACTIONS(973),
    [anon_sym_PIPE] = ACTIONS(973),
    [anon_sym_SEMI_SEMI] = ACTIONS(971),
    [anon_sym_PIPE_AMP] = ACTIONS(971),
    [anon_sym_AMP_AMP] = ACTIONS(971),
    [anon_sym_PIPE_PIPE] = ACTIONS(971),
    [anon_sym_LT] = ACTIONS(973),
    [anon_sym_GT] = ACTIONS(973),
    [anon_sym_GT_GT] = ACTIONS(971),
    [anon_sym_AMP_GT] = ACTIONS(973),
    [anon_sym_AMP_GT_GT] = ACTIONS(971),
    [anon_sym_LT_AMP] = ACTIONS(971),
    [anon_sym_GT_AMP] = ACTIONS(971),
    [anon_sym_LT_LT] = ACTIONS(973),
    [anon_sym_LT_LT_DASH] = ACTIONS(971),
    [anon_sym_LT_LT_LT] = ACTIONS(971),
    [anon_sym_DOLLAR] = ACTIONS(265),
    [sym__special_character] = ACTIONS(267),
    [anon_sym_DQUOTE] = ACTIONS(269),
    [sym_raw_string] = ACTIONS(271),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(273),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(275),
    [anon_sym_BQUOTE] = ACTIONS(277),
    [anon_sym_LT_LPAREN] = ACTIONS(279),
    [anon_sym_GT_LPAREN] = ACTIONS(279),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(975),
    [sym_word] = ACTIONS(283),
    [anon_sym_LF] = ACTIONS(971),
    [anon_sym_AMP] = ACTIONS(973),
  },
  [176] = {
    [aux_sym__literal_repeat1] = STATE(573),
    [sym__simple_heredoc_body] = ACTIONS(977),
    [sym__heredoc_body_beginning] = ACTIONS(977),
    [sym_file_descriptor] = ACTIONS(977),
    [sym_variable_name] = ACTIONS(977),
    [ts_builtin_sym_end] = ACTIONS(977),
    [anon_sym_SEMI] = ACTIONS(979),
    [anon_sym_PIPE] = ACTIONS(979),
    [anon_sym_SEMI_SEMI] = ACTIONS(977),
    [anon_sym_PIPE_AMP] = ACTIONS(977),
    [anon_sym_AMP_AMP] = ACTIONS(977),
    [anon_sym_PIPE_PIPE] = ACTIONS(977),
    [anon_sym_LT] = ACTIONS(979),
    [anon_sym_GT] = ACTIONS(979),
    [anon_sym_GT_GT] = ACTIONS(977),
    [anon_sym_AMP_GT] = ACTIONS(979),
    [anon_sym_AMP_GT_GT] = ACTIONS(977),
    [anon_sym_LT_AMP] = ACTIONS(977),
    [anon_sym_GT_AMP] = ACTIONS(977),
    [anon_sym_LT_LT] = ACTIONS(979),
    [anon_sym_LT_LT_DASH] = ACTIONS(977),
    [anon_sym_LT_LT_LT] = ACTIONS(977),
    [anon_sym_DOLLAR] = ACTIONS(979),
    [sym__special_character] = ACTIONS(981),
    [anon_sym_DQUOTE] = ACTIONS(977),
    [sym_raw_string] = ACTIONS(977),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(977),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(977),
    [anon_sym_BQUOTE] = ACTIONS(977),
    [anon_sym_LT_LPAREN] = ACTIONS(977),
    [anon_sym_GT_LPAREN] = ACTIONS(977),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(979),
    [sym_word] = ACTIONS(979),
    [anon_sym_LF] = ACTIONS(977),
    [anon_sym_AMP] = ACTIONS(979),
  },
  [177] = {
    [sym_string] = STATE(575),
    [anon_sym_DASH] = ACTIONS(983),
    [anon_sym_DOLLAR] = ACTIONS(983),
    [anon_sym_DQUOTE] = ACTIONS(293),
    [sym_raw_string] = ACTIONS(985),
    [anon_sym_POUND] = ACTIONS(983),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(987),
    [anon_sym_STAR] = ACTIONS(989),
    [anon_sym_AT] = ACTIONS(989),
    [anon_sym_QMARK] = ACTIONS(989),
    [anon_sym_0] = ACTIONS(987),
    [anon_sym__] = ACTIONS(987),
  },
  [178] = {
    [aux_sym_concatenation_repeat1] = STATE(578),
    [sym__simple_heredoc_body] = ACTIONS(335),
    [sym__heredoc_body_beginning] = ACTIONS(335),
    [sym_file_descriptor] = ACTIONS(335),
    [sym__concat] = ACTIONS(991),
    [ts_builtin_sym_end] = ACTIONS(335),
    [anon_sym_SEMI] = ACTIONS(339),
    [anon_sym_PIPE] = ACTIONS(339),
    [anon_sym_SEMI_SEMI] = ACTIONS(335),
    [anon_sym_PIPE_AMP] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_PIPE_PIPE] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(339),
    [anon_sym_GT_GT] = ACTIONS(335),
    [anon_sym_AMP_GT] = ACTIONS(339),
    [anon_sym_AMP_GT_GT] = ACTIONS(335),
    [anon_sym_LT_AMP] = ACTIONS(335),
    [anon_sym_GT_AMP] = ACTIONS(335),
    [anon_sym_LT_LT] = ACTIONS(339),
    [anon_sym_LT_LT_DASH] = ACTIONS(335),
    [anon_sym_LT_LT_LT] = ACTIONS(335),
    [anon_sym_DOLLAR] = ACTIONS(339),
    [sym__special_character] = ACTIONS(335),
    [anon_sym_DQUOTE] = ACTIONS(335),
    [sym_raw_string] = ACTIONS(335),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(335),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(335),
    [anon_sym_LT_LPAREN] = ACTIONS(335),
    [anon_sym_GT_LPAREN] = ACTIONS(335),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(339),
    [sym_word] = ACTIONS(339),
    [anon_sym_LF] = ACTIONS(335),
    [anon_sym_AMP] = ACTIONS(339),
  },
  [179] = {
    [sym_simple_expansion] = STATE(204),
    [sym_expansion] = STATE(204),
    [sym_command_substitution] = STATE(204),
    [aux_sym_string_repeat1] = STATE(581),
    [anon_sym_DOLLAR] = ACTIONS(993),
    [anon_sym_DQUOTE] = ACTIONS(995),
    [sym__string_content] = ACTIONS(345),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(347),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(329),
  },
  [180] = {
    [aux_sym_concatenation_repeat1] = STATE(578),
    [sym__simple_heredoc_body] = ACTIONS(997),
    [sym__heredoc_body_beginning] = ACTIONS(997),
    [sym_file_descriptor] = ACTIONS(997),
    [sym__concat] = ACTIONS(991),
    [ts_builtin_sym_end] = ACTIONS(997),
    [anon_sym_SEMI] = ACTIONS(999),
    [anon_sym_PIPE] = ACTIONS(999),
    [anon_sym_SEMI_SEMI] = ACTIONS(997),
    [anon_sym_PIPE_AMP] = ACTIONS(997),
    [anon_sym_AMP_AMP] = ACTIONS(997),
    [anon_sym_PIPE_PIPE] = ACTIONS(997),
    [anon_sym_LT] = ACTIONS(999),
    [anon_sym_GT] = ACTIONS(999),
    [anon_sym_GT_GT] = ACTIONS(997),
    [anon_sym_AMP_GT] = ACTIONS(999),
    [anon_sym_AMP_GT_GT] = ACTIONS(997),
    [anon_sym_LT_AMP] = ACTIONS(997),
    [anon_sym_GT_AMP] = ACTIONS(997),
    [anon_sym_LT_LT] = ACTIONS(999),
    [anon_sym_LT_LT_DASH] = ACTIONS(997),
    [anon_sym_LT_LT_LT] = ACTIONS(997),
    [anon_sym_DOLLAR] = ACTIONS(999),
    [sym__special_character] = ACTIONS(997),
    [anon_sym_DQUOTE] = ACTIONS(997),
    [sym_raw_string] = ACTIONS(997),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(997),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(997),
    [anon_sym_BQUOTE] = ACTIONS(997),
    [anon_sym_LT_LPAREN] = ACTIONS(997),
    [anon_sym_GT_LPAREN] = ACTIONS(997),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(999),
    [sym_word] = ACTIONS(999),
    [anon_sym_LF] = ACTIONS(997),
    [anon_sym_AMP] = ACTIONS(999),
  },
  [181] = {
    [sym_subscript] = STATE(585),
    [sym_variable_name] = ACTIONS(1001),
    [anon_sym_BANG] = ACTIONS(1003),
    [anon_sym_DASH] = ACTIONS(1005),
    [anon_sym_DOLLAR] = ACTIONS(1005),
    [anon_sym_POUND] = ACTIONS(1003),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1007),
    [anon_sym_STAR] = ACTIONS(1009),
    [anon_sym_AT] = ACTIONS(1009),
    [anon_sym_QMARK] = ACTIONS(1009),
    [anon_sym_0] = ACTIONS(1007),
    [anon_sym__] = ACTIONS(1007),
  },
  [182] = {
    [sym__statements] = STATE(586),
    [sym_redirected_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_c_style_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_case_statement] = STATE(105),
    [sym_function_definition] = STATE(105),
    [sym_compound_statement] = STATE(105),
    [sym_subshell] = STATE(105),
    [sym_pipeline] = STATE(105),
    [sym_list] = STATE(105),
    [sym_negated_command] = STATE(105),
    [sym_test_command] = STATE(105),
    [sym_declaration_command] = STATE(105),
    [sym_unset_command] = STATE(105),
    [sym_command] = STATE(105),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(107),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(587),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(109),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(371),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(371),
    [anon_sym_LT_AMP] = ACTIONS(371),
    [anon_sym_GT_AMP] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [183] = {
    [sym__statements] = STATE(588),
    [sym_redirected_statement] = STATE(225),
    [sym_for_statement] = STATE(225),
    [sym_c_style_for_statement] = STATE(225),
    [sym_while_statement] = STATE(225),
    [sym_if_statement] = STATE(225),
    [sym_case_statement] = STATE(225),
    [sym_function_definition] = STATE(225),
    [sym_compound_statement] = STATE(225),
    [sym_subshell] = STATE(225),
    [sym_pipeline] = STATE(225),
    [sym_list] = STATE(225),
    [sym_negated_command] = STATE(225),
    [sym_test_command] = STATE(225),
    [sym_declaration_command] = STATE(225),
    [sym_unset_command] = STATE(225),
    [sym_command] = STATE(225),
    [sym_command_name] = STATE(226),
    [sym_variable_assignment] = STATE(227),
    [sym_subscript] = STATE(228),
    [sym_file_redirect] = STATE(230),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(222),
    [sym_simple_expansion] = STATE(222),
    [sym_string_expansion] = STATE(222),
    [sym_expansion] = STATE(222),
    [sym_command_substitution] = STATE(222),
    [sym_process_substitution] = STATE(222),
    [aux_sym__statements_repeat1] = STATE(229),
    [aux_sym_command_repeat1] = STATE(230),
    [aux_sym__literal_repeat1] = STATE(231),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(375),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_typeset] = ACTIONS(377),
    [anon_sym_export] = ACTIONS(377),
    [anon_sym_readonly] = ACTIONS(377),
    [anon_sym_local] = ACTIONS(377),
    [anon_sym_unset] = ACTIONS(379),
    [anon_sym_unsetenv] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(381),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(383),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(385),
  },
  [184] = {
    [sym__statements] = STATE(589),
    [sym_redirected_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_c_style_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_case_statement] = STATE(105),
    [sym_function_definition] = STATE(105),
    [sym_compound_statement] = STATE(105),
    [sym_subshell] = STATE(105),
    [sym_pipeline] = STATE(105),
    [sym_list] = STATE(105),
    [sym_negated_command] = STATE(105),
    [sym_test_command] = STATE(105),
    [sym_declaration_command] = STATE(105),
    [sym_unset_command] = STATE(105),
    [sym_command] = STATE(105),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(107),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(110),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(109),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [185] = {
    [sym_concatenation] = STATE(590),
    [sym_string] = STATE(180),
    [sym_simple_expansion] = STATE(180),
    [sym_string_expansion] = STATE(180),
    [sym_expansion] = STATE(180),
    [sym_command_substitution] = STATE(180),
    [sym_process_substitution] = STATE(180),
    [aux_sym_unset_command_repeat1] = STATE(590),
    [aux_sym__literal_repeat1] = STATE(186),
    [sym__simple_heredoc_body] = ACTIONS(1011),
    [sym__heredoc_body_beginning] = ACTIONS(1011),
    [sym_file_descriptor] = ACTIONS(1011),
    [ts_builtin_sym_end] = ACTIONS(1011),
    [anon_sym_SEMI] = ACTIONS(1013),
    [anon_sym_PIPE] = ACTIONS(1013),
    [anon_sym_SEMI_SEMI] = ACTIONS(1011),
    [anon_sym_PIPE_AMP] = ACTIONS(1011),
    [anon_sym_AMP_AMP] = ACTIONS(1011),
    [anon_sym_PIPE_PIPE] = ACTIONS(1011),
    [anon_sym_LT] = ACTIONS(1013),
    [anon_sym_GT] = ACTIONS(1013),
    [anon_sym_GT_GT] = ACTIONS(1011),
    [anon_sym_AMP_GT] = ACTIONS(1013),
    [anon_sym_AMP_GT_GT] = ACTIONS(1011),
    [anon_sym_LT_AMP] = ACTIONS(1011),
    [anon_sym_GT_AMP] = ACTIONS(1011),
    [anon_sym_LT_LT] = ACTIONS(1013),
    [anon_sym_LT_LT_DASH] = ACTIONS(1011),
    [anon_sym_LT_LT_LT] = ACTIONS(1011),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym__special_character] = ACTIONS(291),
    [anon_sym_DQUOTE] = ACTIONS(293),
    [sym_raw_string] = ACTIONS(295),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(297),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(299),
    [anon_sym_BQUOTE] = ACTIONS(301),
    [anon_sym_LT_LPAREN] = ACTIONS(303),
    [anon_sym_GT_LPAREN] = ACTIONS(303),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1015),
    [sym_word] = ACTIONS(307),
    [anon_sym_LF] = ACTIONS(1011),
    [anon_sym_AMP] = ACTIONS(1013),
  },
  [186] = {
    [aux_sym__literal_repeat1] = STATE(592),
    [sym__simple_heredoc_body] = ACTIONS(1017),
    [sym__heredoc_body_beginning] = ACTIONS(1017),
    [sym_file_descriptor] = ACTIONS(1017),
    [ts_builtin_sym_end] = ACTIONS(1017),
    [anon_sym_SEMI] = ACTIONS(1019),
    [anon_sym_PIPE] = ACTIONS(1019),
    [anon_sym_SEMI_SEMI] = ACTIONS(1017),
    [anon_sym_PIPE_AMP] = ACTIONS(1017),
    [anon_sym_AMP_AMP] = ACTIONS(1017),
    [anon_sym_PIPE_PIPE] = ACTIONS(1017),
    [anon_sym_LT] = ACTIONS(1019),
    [anon_sym_GT] = ACTIONS(1019),
    [anon_sym_GT_GT] = ACTIONS(1017),
    [anon_sym_AMP_GT] = ACTIONS(1019),
    [anon_sym_AMP_GT_GT] = ACTIONS(1017),
    [anon_sym_LT_AMP] = ACTIONS(1017),
    [anon_sym_GT_AMP] = ACTIONS(1017),
    [anon_sym_LT_LT] = ACTIONS(1019),
    [anon_sym_LT_LT_DASH] = ACTIONS(1017),
    [anon_sym_LT_LT_LT] = ACTIONS(1017),
    [anon_sym_DOLLAR] = ACTIONS(1019),
    [sym__special_character] = ACTIONS(1021),
    [anon_sym_DQUOTE] = ACTIONS(1017),
    [sym_raw_string] = ACTIONS(1017),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1017),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1017),
    [anon_sym_BQUOTE] = ACTIONS(1017),
    [anon_sym_LT_LPAREN] = ACTIONS(1017),
    [anon_sym_GT_LPAREN] = ACTIONS(1017),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1019),
    [sym_word] = ACTIONS(1019),
    [anon_sym_LF] = ACTIONS(1017),
    [anon_sym_AMP] = ACTIONS(1019),
  },
  [187] = {
    [sym_string] = STATE(594),
    [anon_sym_DASH] = ACTIONS(1023),
    [anon_sym_DOLLAR] = ACTIONS(1023),
    [anon_sym_DQUOTE] = ACTIONS(313),
    [sym_raw_string] = ACTIONS(1025),
    [anon_sym_POUND] = ACTIONS(1023),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1027),
    [anon_sym_STAR] = ACTIONS(1029),
    [anon_sym_AT] = ACTIONS(1029),
    [anon_sym_QMARK] = ACTIONS(1029),
    [anon_sym_0] = ACTIONS(1027),
    [anon_sym__] = ACTIONS(1027),
  },
  [188] = {
    [aux_sym_concatenation_repeat1] = STATE(597),
    [sym_file_descriptor] = ACTIONS(335),
    [sym__concat] = ACTIONS(1031),
    [sym_variable_name] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(339),
    [anon_sym_GT_GT] = ACTIONS(335),
    [anon_sym_AMP_GT] = ACTIONS(339),
    [anon_sym_AMP_GT_GT] = ACTIONS(335),
    [anon_sym_LT_AMP] = ACTIONS(335),
    [anon_sym_GT_AMP] = ACTIONS(335),
    [anon_sym_DOLLAR] = ACTIONS(339),
    [sym__special_character] = ACTIONS(335),
    [anon_sym_DQUOTE] = ACTIONS(335),
    [sym_raw_string] = ACTIONS(335),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(335),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(335),
    [anon_sym_LT_LPAREN] = ACTIONS(335),
    [anon_sym_GT_LPAREN] = ACTIONS(335),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(335),
  },
  [189] = {
    [sym_simple_expansion] = STATE(204),
    [sym_expansion] = STATE(204),
    [sym_command_substitution] = STATE(204),
    [aux_sym_string_repeat1] = STATE(600),
    [anon_sym_DOLLAR] = ACTIONS(1033),
    [anon_sym_DQUOTE] = ACTIONS(1035),
    [sym__string_content] = ACTIONS(345),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(347),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(329),
  },
  [190] = {
    [aux_sym_concatenation_repeat1] = STATE(597),
    [sym_file_descriptor] = ACTIONS(1037),
    [sym__concat] = ACTIONS(1031),
    [sym_variable_name] = ACTIONS(1037),
    [anon_sym_LT] = ACTIONS(1039),
    [anon_sym_GT] = ACTIONS(1039),
    [anon_sym_GT_GT] = ACTIONS(1037),
    [anon_sym_AMP_GT] = ACTIONS(1039),
    [anon_sym_AMP_GT_GT] = ACTIONS(1037),
    [anon_sym_LT_AMP] = ACTIONS(1037),
    [anon_sym_GT_AMP] = ACTIONS(1037),
    [anon_sym_DOLLAR] = ACTIONS(1039),
    [sym__special_character] = ACTIONS(1037),
    [anon_sym_DQUOTE] = ACTIONS(1037),
    [sym_raw_string] = ACTIONS(1037),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1037),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1037),
    [anon_sym_BQUOTE] = ACTIONS(1037),
    [anon_sym_LT_LPAREN] = ACTIONS(1037),
    [anon_sym_GT_LPAREN] = ACTIONS(1037),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1037),
  },
  [191] = {
    [sym_subscript] = STATE(604),
    [sym_variable_name] = ACTIONS(1041),
    [anon_sym_BANG] = ACTIONS(1043),
    [anon_sym_DASH] = ACTIONS(1045),
    [anon_sym_DOLLAR] = ACTIONS(1045),
    [anon_sym_POUND] = ACTIONS(1043),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1047),
    [anon_sym_STAR] = ACTIONS(1049),
    [anon_sym_AT] = ACTIONS(1049),
    [anon_sym_QMARK] = ACTIONS(1049),
    [anon_sym_0] = ACTIONS(1047),
    [anon_sym__] = ACTIONS(1047),
  },
  [192] = {
    [sym__statements] = STATE(605),
    [sym_redirected_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_c_style_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_case_statement] = STATE(105),
    [sym_function_definition] = STATE(105),
    [sym_compound_statement] = STATE(105),
    [sym_subshell] = STATE(105),
    [sym_pipeline] = STATE(105),
    [sym_list] = STATE(105),
    [sym_negated_command] = STATE(105),
    [sym_test_command] = STATE(105),
    [sym_declaration_command] = STATE(105),
    [sym_unset_command] = STATE(105),
    [sym_command] = STATE(105),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(107),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(606),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(109),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(371),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(371),
    [anon_sym_LT_AMP] = ACTIONS(371),
    [anon_sym_GT_AMP] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [193] = {
    [sym__statements] = STATE(607),
    [sym_redirected_statement] = STATE(225),
    [sym_for_statement] = STATE(225),
    [sym_c_style_for_statement] = STATE(225),
    [sym_while_statement] = STATE(225),
    [sym_if_statement] = STATE(225),
    [sym_case_statement] = STATE(225),
    [sym_function_definition] = STATE(225),
    [sym_compound_statement] = STATE(225),
    [sym_subshell] = STATE(225),
    [sym_pipeline] = STATE(225),
    [sym_list] = STATE(225),
    [sym_negated_command] = STATE(225),
    [sym_test_command] = STATE(225),
    [sym_declaration_command] = STATE(225),
    [sym_unset_command] = STATE(225),
    [sym_command] = STATE(225),
    [sym_command_name] = STATE(226),
    [sym_variable_assignment] = STATE(227),
    [sym_subscript] = STATE(228),
    [sym_file_redirect] = STATE(230),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(222),
    [sym_simple_expansion] = STATE(222),
    [sym_string_expansion] = STATE(222),
    [sym_expansion] = STATE(222),
    [sym_command_substitution] = STATE(222),
    [sym_process_substitution] = STATE(222),
    [aux_sym__statements_repeat1] = STATE(229),
    [aux_sym_command_repeat1] = STATE(230),
    [aux_sym__literal_repeat1] = STATE(231),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(375),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_typeset] = ACTIONS(377),
    [anon_sym_export] = ACTIONS(377),
    [anon_sym_readonly] = ACTIONS(377),
    [anon_sym_local] = ACTIONS(377),
    [anon_sym_unset] = ACTIONS(379),
    [anon_sym_unsetenv] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(381),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(383),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(385),
  },
  [194] = {
    [sym__statements] = STATE(608),
    [sym_redirected_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_c_style_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_case_statement] = STATE(105),
    [sym_function_definition] = STATE(105),
    [sym_compound_statement] = STATE(105),
    [sym_subshell] = STATE(105),
    [sym_pipeline] = STATE(105),
    [sym_list] = STATE(105),
    [sym_negated_command] = STATE(105),
    [sym_test_command] = STATE(105),
    [sym_declaration_command] = STATE(105),
    [sym_unset_command] = STATE(105),
    [sym_command] = STATE(105),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(107),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(110),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(109),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [195] = {
    [sym_file_descriptor] = ACTIONS(1037),
    [sym_variable_name] = ACTIONS(1037),
    [anon_sym_RPAREN] = ACTIONS(1037),
    [anon_sym_LT] = ACTIONS(1039),
    [anon_sym_GT] = ACTIONS(1039),
    [anon_sym_GT_GT] = ACTIONS(1037),
    [anon_sym_AMP_GT] = ACTIONS(1039),
    [anon_sym_AMP_GT_GT] = ACTIONS(1037),
    [anon_sym_LT_AMP] = ACTIONS(1037),
    [anon_sym_GT_AMP] = ACTIONS(1037),
    [anon_sym_DOLLAR] = ACTIONS(1039),
    [sym__special_character] = ACTIONS(1037),
    [anon_sym_DQUOTE] = ACTIONS(1037),
    [sym_raw_string] = ACTIONS(1037),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1037),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1037),
    [anon_sym_BQUOTE] = ACTIONS(1037),
    [anon_sym_LT_LPAREN] = ACTIONS(1037),
    [anon_sym_GT_LPAREN] = ACTIONS(1037),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1037),
  },
  [196] = {
    [aux_sym__literal_repeat1] = STATE(610),
    [sym_file_descriptor] = ACTIONS(1051),
    [sym_variable_name] = ACTIONS(1051),
    [anon_sym_LT] = ACTIONS(1053),
    [anon_sym_GT] = ACTIONS(1053),
    [anon_sym_GT_GT] = ACTIONS(1051),
    [anon_sym_AMP_GT] = ACTIONS(1053),
    [anon_sym_AMP_GT_GT] = ACTIONS(1051),
    [anon_sym_LT_AMP] = ACTIONS(1051),
    [anon_sym_GT_AMP] = ACTIONS(1051),
    [anon_sym_DOLLAR] = ACTIONS(1053),
    [sym__special_character] = ACTIONS(1055),
    [anon_sym_DQUOTE] = ACTIONS(1051),
    [sym_raw_string] = ACTIONS(1051),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1051),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1051),
    [anon_sym_BQUOTE] = ACTIONS(1051),
    [anon_sym_LT_LPAREN] = ACTIONS(1051),
    [anon_sym_GT_LPAREN] = ACTIONS(1051),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1051),
  },
  [197] = {
    [sym__simple_heredoc_body] = ACTIONS(1057),
    [sym__heredoc_body_beginning] = ACTIONS(1057),
    [sym_file_descriptor] = ACTIONS(1057),
    [sym__concat] = ACTIONS(1057),
    [ts_builtin_sym_end] = ACTIONS(1057),
    [anon_sym_SEMI] = ACTIONS(1059),
    [anon_sym_PIPE] = ACTIONS(1059),
    [anon_sym_RPAREN] = ACTIONS(1057),
    [anon_sym_SEMI_SEMI] = ACTIONS(1057),
    [anon_sym_PIPE_AMP] = ACTIONS(1057),
    [anon_sym_AMP_AMP] = ACTIONS(1057),
    [anon_sym_PIPE_PIPE] = ACTIONS(1057),
    [anon_sym_EQ_TILDE] = ACTIONS(1059),
    [anon_sym_EQ_EQ] = ACTIONS(1059),
    [anon_sym_LT] = ACTIONS(1059),
    [anon_sym_GT] = ACTIONS(1059),
    [anon_sym_GT_GT] = ACTIONS(1057),
    [anon_sym_AMP_GT] = ACTIONS(1059),
    [anon_sym_AMP_GT_GT] = ACTIONS(1057),
    [anon_sym_LT_AMP] = ACTIONS(1057),
    [anon_sym_GT_AMP] = ACTIONS(1057),
    [anon_sym_LT_LT] = ACTIONS(1059),
    [anon_sym_LT_LT_DASH] = ACTIONS(1057),
    [anon_sym_LT_LT_LT] = ACTIONS(1057),
    [anon_sym_DOLLAR] = ACTIONS(1059),
    [sym__special_character] = ACTIONS(1057),
    [anon_sym_DQUOTE] = ACTIONS(1057),
    [sym_raw_string] = ACTIONS(1057),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1057),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1057),
    [anon_sym_BQUOTE] = ACTIONS(1057),
    [anon_sym_LT_LPAREN] = ACTIONS(1057),
    [anon_sym_GT_LPAREN] = ACTIONS(1057),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1059),
    [anon_sym_LF] = ACTIONS(1057),
    [anon_sym_AMP] = ACTIONS(1059),
  },
  [198] = {
    [sym__simple_heredoc_body] = ACTIONS(1061),
    [sym__heredoc_body_beginning] = ACTIONS(1061),
    [sym_file_descriptor] = ACTIONS(1061),
    [sym__concat] = ACTIONS(1061),
    [ts_builtin_sym_end] = ACTIONS(1061),
    [anon_sym_SEMI] = ACTIONS(1063),
    [anon_sym_PIPE] = ACTIONS(1063),
    [anon_sym_RPAREN] = ACTIONS(1061),
    [anon_sym_SEMI_SEMI] = ACTIONS(1061),
    [anon_sym_PIPE_AMP] = ACTIONS(1061),
    [anon_sym_AMP_AMP] = ACTIONS(1061),
    [anon_sym_PIPE_PIPE] = ACTIONS(1061),
    [anon_sym_EQ_TILDE] = ACTIONS(1063),
    [anon_sym_EQ_EQ] = ACTIONS(1063),
    [anon_sym_LT] = ACTIONS(1063),
    [anon_sym_GT] = ACTIONS(1063),
    [anon_sym_GT_GT] = ACTIONS(1061),
    [anon_sym_AMP_GT] = ACTIONS(1063),
    [anon_sym_AMP_GT_GT] = ACTIONS(1061),
    [anon_sym_LT_AMP] = ACTIONS(1061),
    [anon_sym_GT_AMP] = ACTIONS(1061),
    [anon_sym_LT_LT] = ACTIONS(1063),
    [anon_sym_LT_LT_DASH] = ACTIONS(1061),
    [anon_sym_LT_LT_LT] = ACTIONS(1061),
    [anon_sym_DOLLAR] = ACTIONS(1063),
    [sym__special_character] = ACTIONS(1061),
    [anon_sym_DQUOTE] = ACTIONS(1061),
    [sym_raw_string] = ACTIONS(1061),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1061),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1061),
    [anon_sym_BQUOTE] = ACTIONS(1061),
    [anon_sym_LT_LPAREN] = ACTIONS(1061),
    [anon_sym_GT_LPAREN] = ACTIONS(1061),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1063),
    [anon_sym_LF] = ACTIONS(1061),
    [anon_sym_AMP] = ACTIONS(1063),
  },
  [199] = {
    [sym__simple_heredoc_body] = ACTIONS(1065),
    [sym__heredoc_body_beginning] = ACTIONS(1065),
    [sym_file_descriptor] = ACTIONS(1065),
    [sym__concat] = ACTIONS(1065),
    [ts_builtin_sym_end] = ACTIONS(1065),
    [anon_sym_SEMI] = ACTIONS(1067),
    [anon_sym_PIPE] = ACTIONS(1067),
    [anon_sym_RPAREN] = ACTIONS(1065),
    [anon_sym_SEMI_SEMI] = ACTIONS(1065),
    [anon_sym_PIPE_AMP] = ACTIONS(1065),
    [anon_sym_AMP_AMP] = ACTIONS(1065),
    [anon_sym_PIPE_PIPE] = ACTIONS(1065),
    [anon_sym_EQ_TILDE] = ACTIONS(1067),
    [anon_sym_EQ_EQ] = ACTIONS(1067),
    [anon_sym_LT] = ACTIONS(1067),
    [anon_sym_GT] = ACTIONS(1067),
    [anon_sym_GT_GT] = ACTIONS(1065),
    [anon_sym_AMP_GT] = ACTIONS(1067),
    [anon_sym_AMP_GT_GT] = ACTIONS(1065),
    [anon_sym_LT_AMP] = ACTIONS(1065),
    [anon_sym_GT_AMP] = ACTIONS(1065),
    [anon_sym_LT_LT] = ACTIONS(1067),
    [anon_sym_LT_LT_DASH] = ACTIONS(1065),
    [anon_sym_LT_LT_LT] = ACTIONS(1065),
    [anon_sym_DOLLAR] = ACTIONS(1067),
    [sym__special_character] = ACTIONS(1065),
    [anon_sym_DQUOTE] = ACTIONS(1065),
    [sym_raw_string] = ACTIONS(1065),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1065),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1065),
    [anon_sym_BQUOTE] = ACTIONS(1065),
    [anon_sym_LT_LPAREN] = ACTIONS(1065),
    [anon_sym_GT_LPAREN] = ACTIONS(1065),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1067),
    [anon_sym_LF] = ACTIONS(1065),
    [anon_sym_AMP] = ACTIONS(1067),
  },
  [200] = {
    [sym_string] = STATE(611),
    [sym_simple_expansion] = STATE(611),
    [sym_string_expansion] = STATE(611),
    [sym_expansion] = STATE(611),
    [sym_command_substitution] = STATE(611),
    [sym_process_substitution] = STATE(611),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(1069),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(1069),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1069),
  },
  [201] = {
    [aux_sym_concatenation_repeat1] = STATE(613),
    [sym__simple_heredoc_body] = ACTIONS(1071),
    [sym__heredoc_body_beginning] = ACTIONS(1071),
    [sym_file_descriptor] = ACTIONS(1071),
    [sym__concat] = ACTIONS(1073),
    [ts_builtin_sym_end] = ACTIONS(1071),
    [anon_sym_SEMI] = ACTIONS(1075),
    [anon_sym_PIPE] = ACTIONS(1075),
    [anon_sym_SEMI_SEMI] = ACTIONS(1071),
    [anon_sym_PIPE_AMP] = ACTIONS(1071),
    [anon_sym_AMP_AMP] = ACTIONS(1071),
    [anon_sym_PIPE_PIPE] = ACTIONS(1071),
    [anon_sym_EQ_TILDE] = ACTIONS(1075),
    [anon_sym_EQ_EQ] = ACTIONS(1075),
    [anon_sym_LT] = ACTIONS(1075),
    [anon_sym_GT] = ACTIONS(1075),
    [anon_sym_GT_GT] = ACTIONS(1071),
    [anon_sym_AMP_GT] = ACTIONS(1075),
    [anon_sym_AMP_GT_GT] = ACTIONS(1071),
    [anon_sym_LT_AMP] = ACTIONS(1071),
    [anon_sym_GT_AMP] = ACTIONS(1071),
    [anon_sym_LT_LT] = ACTIONS(1075),
    [anon_sym_LT_LT_DASH] = ACTIONS(1071),
    [anon_sym_LT_LT_LT] = ACTIONS(1071),
    [anon_sym_DOLLAR] = ACTIONS(1075),
    [sym__special_character] = ACTIONS(1071),
    [anon_sym_DQUOTE] = ACTIONS(1071),
    [sym_raw_string] = ACTIONS(1071),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1071),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1071),
    [anon_sym_BQUOTE] = ACTIONS(1071),
    [anon_sym_LT_LPAREN] = ACTIONS(1071),
    [anon_sym_GT_LPAREN] = ACTIONS(1071),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1075),
    [anon_sym_LF] = ACTIONS(1071),
    [anon_sym_AMP] = ACTIONS(1075),
  },
  [202] = {
    [anon_sym_DASH] = ACTIONS(1077),
    [anon_sym_DOLLAR] = ACTIONS(1079),
    [anon_sym_DQUOTE] = ACTIONS(1081),
    [sym__string_content] = ACTIONS(1083),
    [anon_sym_POUND] = ACTIONS(1077),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1085),
    [anon_sym_STAR] = ACTIONS(1087),
    [anon_sym_AT] = ACTIONS(1087),
    [anon_sym_QMARK] = ACTIONS(1087),
    [anon_sym_0] = ACTIONS(1085),
    [anon_sym__] = ACTIONS(1085),
  },
  [203] = {
    [sym__simple_heredoc_body] = ACTIONS(1089),
    [sym__heredoc_body_beginning] = ACTIONS(1089),
    [sym_file_descriptor] = ACTIONS(1089),
    [sym__concat] = ACTIONS(1089),
    [ts_builtin_sym_end] = ACTIONS(1089),
    [anon_sym_SEMI] = ACTIONS(1091),
    [anon_sym_PIPE] = ACTIONS(1091),
    [anon_sym_RPAREN] = ACTIONS(1089),
    [anon_sym_SEMI_SEMI] = ACTIONS(1089),
    [anon_sym_PIPE_AMP] = ACTIONS(1089),
    [anon_sym_AMP_AMP] = ACTIONS(1089),
    [anon_sym_PIPE_PIPE] = ACTIONS(1089),
    [anon_sym_EQ_TILDE] = ACTIONS(1091),
    [anon_sym_EQ_EQ] = ACTIONS(1091),
    [anon_sym_LT] = ACTIONS(1091),
    [anon_sym_GT] = ACTIONS(1091),
    [anon_sym_GT_GT] = ACTIONS(1089),
    [anon_sym_AMP_GT] = ACTIONS(1091),
    [anon_sym_AMP_GT_GT] = ACTIONS(1089),
    [anon_sym_LT_AMP] = ACTIONS(1089),
    [anon_sym_GT_AMP] = ACTIONS(1089),
    [anon_sym_LT_LT] = ACTIONS(1091),
    [anon_sym_LT_LT_DASH] = ACTIONS(1089),
    [anon_sym_LT_LT_LT] = ACTIONS(1089),
    [anon_sym_DOLLAR] = ACTIONS(1091),
    [sym__special_character] = ACTIONS(1089),
    [anon_sym_DQUOTE] = ACTIONS(1089),
    [sym_raw_string] = ACTIONS(1089),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1089),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1089),
    [anon_sym_BQUOTE] = ACTIONS(1089),
    [anon_sym_LT_LPAREN] = ACTIONS(1089),
    [anon_sym_GT_LPAREN] = ACTIONS(1089),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1091),
    [anon_sym_LF] = ACTIONS(1089),
    [anon_sym_AMP] = ACTIONS(1091),
  },
  [204] = {
    [sym__concat] = ACTIONS(1093),
    [anon_sym_DOLLAR] = ACTIONS(1095),
    [anon_sym_DQUOTE] = ACTIONS(1095),
    [sym__string_content] = ACTIONS(1097),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1095),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1095),
    [anon_sym_BQUOTE] = ACTIONS(1095),
    [sym_comment] = ACTIONS(329),
  },
  [205] = {
    [sym_subscript] = STATE(622),
    [sym_variable_name] = ACTIONS(1099),
    [anon_sym_BANG] = ACTIONS(1101),
    [anon_sym_DASH] = ACTIONS(1103),
    [anon_sym_DOLLAR] = ACTIONS(1103),
    [anon_sym_POUND] = ACTIONS(1101),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1105),
    [anon_sym_STAR] = ACTIONS(1107),
    [anon_sym_AT] = ACTIONS(1107),
    [anon_sym_QMARK] = ACTIONS(1107),
    [anon_sym_0] = ACTIONS(1105),
    [anon_sym__] = ACTIONS(1105),
  },
  [206] = {
    [sym__statements] = STATE(623),
    [sym_redirected_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_c_style_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_case_statement] = STATE(105),
    [sym_function_definition] = STATE(105),
    [sym_compound_statement] = STATE(105),
    [sym_subshell] = STATE(105),
    [sym_pipeline] = STATE(105),
    [sym_list] = STATE(105),
    [sym_negated_command] = STATE(105),
    [sym_test_command] = STATE(105),
    [sym_declaration_command] = STATE(105),
    [sym_unset_command] = STATE(105),
    [sym_command] = STATE(105),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(107),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(624),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(109),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(371),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(371),
    [anon_sym_LT_AMP] = ACTIONS(371),
    [anon_sym_GT_AMP] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [207] = {
    [sym__statements] = STATE(625),
    [sym_redirected_statement] = STATE(225),
    [sym_for_statement] = STATE(225),
    [sym_c_style_for_statement] = STATE(225),
    [sym_while_statement] = STATE(225),
    [sym_if_statement] = STATE(225),
    [sym_case_statement] = STATE(225),
    [sym_function_definition] = STATE(225),
    [sym_compound_statement] = STATE(225),
    [sym_subshell] = STATE(225),
    [sym_pipeline] = STATE(225),
    [sym_list] = STATE(225),
    [sym_negated_command] = STATE(225),
    [sym_test_command] = STATE(225),
    [sym_declaration_command] = STATE(225),
    [sym_unset_command] = STATE(225),
    [sym_command] = STATE(225),
    [sym_command_name] = STATE(226),
    [sym_variable_assignment] = STATE(227),
    [sym_subscript] = STATE(228),
    [sym_file_redirect] = STATE(230),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(222),
    [sym_simple_expansion] = STATE(222),
    [sym_string_expansion] = STATE(222),
    [sym_expansion] = STATE(222),
    [sym_command_substitution] = STATE(222),
    [sym_process_substitution] = STATE(222),
    [aux_sym__statements_repeat1] = STATE(229),
    [aux_sym_command_repeat1] = STATE(230),
    [aux_sym__literal_repeat1] = STATE(231),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(375),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_typeset] = ACTIONS(377),
    [anon_sym_export] = ACTIONS(377),
    [anon_sym_readonly] = ACTIONS(377),
    [anon_sym_local] = ACTIONS(377),
    [anon_sym_unset] = ACTIONS(379),
    [anon_sym_unsetenv] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(381),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(383),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(385),
  },
  [208] = {
    [sym_simple_expansion] = STATE(204),
    [sym_expansion] = STATE(204),
    [sym_command_substitution] = STATE(204),
    [aux_sym_string_repeat1] = STATE(627),
    [anon_sym_DOLLAR] = ACTIONS(1109),
    [anon_sym_DQUOTE] = ACTIONS(1081),
    [sym__string_content] = ACTIONS(345),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(347),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(329),
  },
  [209] = {
    [anon_sym_LBRACK] = ACTIONS(1111),
    [anon_sym_EQ] = ACTIONS(1113),
    [sym_comment] = ACTIONS(57),
  },
  [210] = {
    [sym_subscript] = STATE(632),
    [sym_variable_name] = ACTIONS(1115),
    [anon_sym_DASH] = ACTIONS(1117),
    [anon_sym_DOLLAR] = ACTIONS(1117),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1119),
    [anon_sym_STAR] = ACTIONS(1121),
    [anon_sym_AT] = ACTIONS(1121),
    [anon_sym_QMARK] = ACTIONS(1121),
    [anon_sym_0] = ACTIONS(1119),
    [anon_sym__] = ACTIONS(1119),
  },
  [211] = {
    [sym_concatenation] = STATE(644),
    [sym_string] = STATE(637),
    [sym_simple_expansion] = STATE(637),
    [sym_string_expansion] = STATE(637),
    [sym_expansion] = STATE(637),
    [sym_command_substitution] = STATE(637),
    [sym_process_substitution] = STATE(637),
    [aux_sym__literal_repeat1] = STATE(643),
    [aux_sym_expansion_repeat1] = STATE(644),
    [anon_sym_RBRACE] = ACTIONS(1123),
    [anon_sym_EQ] = ACTIONS(1125),
    [anon_sym_DASH] = ACTIONS(1125),
    [anon_sym_DOLLAR] = ACTIONS(1127),
    [sym__special_character] = ACTIONS(1129),
    [anon_sym_DQUOTE] = ACTIONS(1131),
    [sym_raw_string] = ACTIONS(1133),
    [anon_sym_POUND] = ACTIONS(1135),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1137),
    [anon_sym_SLASH] = ACTIONS(1139),
    [anon_sym_COLON] = ACTIONS(1125),
    [anon_sym_COLON_QMARK] = ACTIONS(1125),
    [anon_sym_COLON_DASH] = ACTIONS(1125),
    [anon_sym_PERCENT] = ACTIONS(1125),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1141),
    [anon_sym_BQUOTE] = ACTIONS(1143),
    [anon_sym_LT_LPAREN] = ACTIONS(1145),
    [anon_sym_GT_LPAREN] = ACTIONS(1145),
    [sym_comment] = ACTIONS(329),
    [sym_word] = ACTIONS(1147),
  },
  [212] = {
    [sym_concatenation] = STATE(647),
    [sym_string] = STATE(637),
    [sym_simple_expansion] = STATE(637),
    [sym_string_expansion] = STATE(637),
    [sym_expansion] = STATE(637),
    [sym_command_substitution] = STATE(637),
    [sym_process_substitution] = STATE(637),
    [aux_sym__literal_repeat1] = STATE(643),
    [aux_sym_expansion_repeat1] = STATE(647),
    [anon_sym_RBRACE] = ACTIONS(1149),
    [anon_sym_EQ] = ACTIONS(1151),
    [anon_sym_DASH] = ACTIONS(1151),
    [anon_sym_DOLLAR] = ACTIONS(1127),
    [sym__special_character] = ACTIONS(1129),
    [anon_sym_DQUOTE] = ACTIONS(1131),
    [sym_raw_string] = ACTIONS(1133),
    [anon_sym_POUND] = ACTIONS(1153),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1137),
    [anon_sym_SLASH] = ACTIONS(1155),
    [anon_sym_COLON] = ACTIONS(1151),
    [anon_sym_COLON_QMARK] = ACTIONS(1151),
    [anon_sym_COLON_DASH] = ACTIONS(1151),
    [anon_sym_PERCENT] = ACTIONS(1151),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1141),
    [anon_sym_BQUOTE] = ACTIONS(1143),
    [anon_sym_LT_LPAREN] = ACTIONS(1145),
    [anon_sym_GT_LPAREN] = ACTIONS(1145),
    [sym_comment] = ACTIONS(329),
    [sym_word] = ACTIONS(1147),
  },
  [213] = {
    [anon_sym_LT] = ACTIONS(1157),
    [anon_sym_GT] = ACTIONS(1157),
    [anon_sym_GT_GT] = ACTIONS(1159),
    [anon_sym_AMP_GT] = ACTIONS(1157),
    [anon_sym_AMP_GT_GT] = ACTIONS(1159),
    [anon_sym_LT_AMP] = ACTIONS(1159),
    [anon_sym_GT_AMP] = ACTIONS(1159),
    [sym_comment] = ACTIONS(57),
  },
  [214] = {
    [sym_concatenation] = STATE(195),
    [sym_string] = STATE(650),
    [sym_simple_expansion] = STATE(650),
    [sym_string_expansion] = STATE(650),
    [sym_expansion] = STATE(650),
    [sym_command_substitution] = STATE(650),
    [sym_process_substitution] = STATE(650),
    [aux_sym__literal_repeat1] = STATE(651),
    [anon_sym_DOLLAR] = ACTIONS(309),
    [sym__special_character] = ACTIONS(1161),
    [anon_sym_DQUOTE] = ACTIONS(313),
    [sym_raw_string] = ACTIONS(1163),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(317),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(319),
    [anon_sym_BQUOTE] = ACTIONS(321),
    [anon_sym_LT_LPAREN] = ACTIONS(323),
    [anon_sym_GT_LPAREN] = ACTIONS(323),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1163),
  },
  [215] = {
    [anon_sym_RPAREN] = ACTIONS(1165),
    [sym_comment] = ACTIONS(57),
  },
  [216] = {
    [sym_file_descriptor] = ACTIONS(433),
    [sym_variable_name] = ACTIONS(433),
    [anon_sym_RPAREN] = ACTIONS(1165),
    [anon_sym_LT] = ACTIONS(435),
    [anon_sym_GT] = ACTIONS(435),
    [anon_sym_GT_GT] = ACTIONS(433),
    [anon_sym_AMP_GT] = ACTIONS(435),
    [anon_sym_AMP_GT_GT] = ACTIONS(433),
    [anon_sym_LT_AMP] = ACTIONS(433),
    [anon_sym_GT_AMP] = ACTIONS(433),
    [anon_sym_DOLLAR] = ACTIONS(435),
    [sym__special_character] = ACTIONS(433),
    [anon_sym_DQUOTE] = ACTIONS(433),
    [sym_raw_string] = ACTIONS(433),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(433),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(433),
    [anon_sym_BQUOTE] = ACTIONS(433),
    [anon_sym_LT_LPAREN] = ACTIONS(433),
    [anon_sym_GT_LPAREN] = ACTIONS(433),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(433),
  },
  [217] = {
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_EQ] = ACTIONS(1167),
    [anon_sym_PLUS_EQ] = ACTIONS(1167),
    [sym_comment] = ACTIONS(57),
  },
  [218] = {
    [sym_subshell] = STATE(146),
    [sym_test_command] = STATE(146),
    [sym_command] = STATE(146),
    [sym_command_name] = STATE(226),
    [sym_variable_assignment] = STATE(230),
    [sym_subscript] = STATE(147),
    [sym_file_redirect] = STATE(230),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(222),
    [sym_simple_expansion] = STATE(222),
    [sym_string_expansion] = STATE(222),
    [sym_expansion] = STATE(222),
    [sym_command_substitution] = STATE(222),
    [sym_process_substitution] = STATE(222),
    [aux_sym_command_repeat1] = STATE(230),
    [aux_sym__literal_repeat1] = STATE(231),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(223),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(381),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(383),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(383),
  },
  [219] = {
    [sym_variable_assignment] = STATE(658),
    [sym_subscript] = STATE(657),
    [sym_concatenation] = STATE(658),
    [sym_string] = STATE(656),
    [sym_simple_expansion] = STATE(656),
    [sym_string_expansion] = STATE(656),
    [sym_expansion] = STATE(656),
    [sym_command_substitution] = STATE(656),
    [sym_process_substitution] = STATE(656),
    [aux_sym_declaration_command_repeat1] = STATE(658),
    [aux_sym__literal_repeat1] = STATE(659),
    [sym__simple_heredoc_body] = ACTIONS(259),
    [sym__heredoc_body_beginning] = ACTIONS(259),
    [sym_file_descriptor] = ACTIONS(259),
    [sym_variable_name] = ACTIONS(1169),
    [anon_sym_SEMI] = ACTIONS(263),
    [anon_sym_PIPE] = ACTIONS(263),
    [anon_sym_SEMI_SEMI] = ACTIONS(259),
    [anon_sym_PIPE_AMP] = ACTIONS(259),
    [anon_sym_AMP_AMP] = ACTIONS(259),
    [anon_sym_PIPE_PIPE] = ACTIONS(259),
    [anon_sym_LT] = ACTIONS(263),
    [anon_sym_GT] = ACTIONS(263),
    [anon_sym_GT_GT] = ACTIONS(259),
    [anon_sym_AMP_GT] = ACTIONS(263),
    [anon_sym_AMP_GT_GT] = ACTIONS(259),
    [anon_sym_LT_AMP] = ACTIONS(259),
    [anon_sym_GT_AMP] = ACTIONS(259),
    [anon_sym_LT_LT] = ACTIONS(263),
    [anon_sym_LT_LT_DASH] = ACTIONS(259),
    [anon_sym_LT_LT_LT] = ACTIONS(259),
    [anon_sym_DOLLAR] = ACTIONS(265),
    [sym__special_character] = ACTIONS(1171),
    [anon_sym_DQUOTE] = ACTIONS(269),
    [sym_raw_string] = ACTIONS(1173),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(273),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(275),
    [anon_sym_BQUOTE] = ACTIONS(259),
    [anon_sym_LT_LPAREN] = ACTIONS(279),
    [anon_sym_GT_LPAREN] = ACTIONS(279),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1175),
    [sym_word] = ACTIONS(1177),
    [anon_sym_LF] = ACTIONS(259),
    [anon_sym_AMP] = ACTIONS(263),
  },
  [220] = {
    [sym_concatenation] = STATE(662),
    [sym_string] = STATE(661),
    [sym_simple_expansion] = STATE(661),
    [sym_string_expansion] = STATE(661),
    [sym_expansion] = STATE(661),
    [sym_command_substitution] = STATE(661),
    [sym_process_substitution] = STATE(661),
    [aux_sym_unset_command_repeat1] = STATE(662),
    [aux_sym__literal_repeat1] = STATE(663),
    [sym__simple_heredoc_body] = ACTIONS(285),
    [sym__heredoc_body_beginning] = ACTIONS(285),
    [sym_file_descriptor] = ACTIONS(285),
    [anon_sym_SEMI] = ACTIONS(287),
    [anon_sym_PIPE] = ACTIONS(287),
    [anon_sym_SEMI_SEMI] = ACTIONS(285),
    [anon_sym_PIPE_AMP] = ACTIONS(285),
    [anon_sym_AMP_AMP] = ACTIONS(285),
    [anon_sym_PIPE_PIPE] = ACTIONS(285),
    [anon_sym_LT] = ACTIONS(287),
    [anon_sym_GT] = ACTIONS(287),
    [anon_sym_GT_GT] = ACTIONS(285),
    [anon_sym_AMP_GT] = ACTIONS(287),
    [anon_sym_AMP_GT_GT] = ACTIONS(285),
    [anon_sym_LT_AMP] = ACTIONS(285),
    [anon_sym_GT_AMP] = ACTIONS(285),
    [anon_sym_LT_LT] = ACTIONS(287),
    [anon_sym_LT_LT_DASH] = ACTIONS(285),
    [anon_sym_LT_LT_LT] = ACTIONS(285),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym__special_character] = ACTIONS(1179),
    [anon_sym_DQUOTE] = ACTIONS(293),
    [sym_raw_string] = ACTIONS(1181),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(297),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(299),
    [anon_sym_BQUOTE] = ACTIONS(285),
    [anon_sym_LT_LPAREN] = ACTIONS(303),
    [anon_sym_GT_LPAREN] = ACTIONS(303),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1183),
    [sym_word] = ACTIONS(1185),
    [anon_sym_LF] = ACTIONS(285),
    [anon_sym_AMP] = ACTIONS(287),
  },
  [221] = {
    [aux_sym_concatenation_repeat1] = STATE(664),
    [sym__simple_heredoc_body] = ACTIONS(335),
    [sym__heredoc_body_beginning] = ACTIONS(335),
    [sym_file_descriptor] = ACTIONS(335),
    [sym__concat] = ACTIONS(337),
    [anon_sym_SEMI] = ACTIONS(339),
    [anon_sym_PIPE] = ACTIONS(339),
    [anon_sym_SEMI_SEMI] = ACTIONS(335),
    [anon_sym_PIPE_AMP] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_PIPE_PIPE] = ACTIONS(335),
    [anon_sym_EQ_TILDE] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_LT] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(339),
    [anon_sym_GT_GT] = ACTIONS(335),
    [anon_sym_AMP_GT] = ACTIONS(339),
    [anon_sym_AMP_GT_GT] = ACTIONS(335),
    [anon_sym_LT_AMP] = ACTIONS(335),
    [anon_sym_GT_AMP] = ACTIONS(335),
    [anon_sym_LT_LT] = ACTIONS(339),
    [anon_sym_LT_LT_DASH] = ACTIONS(335),
    [anon_sym_LT_LT_LT] = ACTIONS(335),
    [anon_sym_DOLLAR] = ACTIONS(339),
    [sym__special_character] = ACTIONS(335),
    [anon_sym_DQUOTE] = ACTIONS(335),
    [sym_raw_string] = ACTIONS(335),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(335),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(335),
    [anon_sym_LT_LPAREN] = ACTIONS(335),
    [anon_sym_GT_LPAREN] = ACTIONS(335),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(339),
    [anon_sym_LF] = ACTIONS(335),
    [anon_sym_AMP] = ACTIONS(339),
  },
  [222] = {
    [aux_sym_concatenation_repeat1] = STATE(664),
    [sym__simple_heredoc_body] = ACTIONS(353),
    [sym__heredoc_body_beginning] = ACTIONS(353),
    [sym_file_descriptor] = ACTIONS(353),
    [sym__concat] = ACTIONS(337),
    [anon_sym_SEMI] = ACTIONS(355),
    [anon_sym_PIPE] = ACTIONS(355),
    [anon_sym_SEMI_SEMI] = ACTIONS(353),
    [anon_sym_PIPE_AMP] = ACTIONS(353),
    [anon_sym_AMP_AMP] = ACTIONS(353),
    [anon_sym_PIPE_PIPE] = ACTIONS(353),
    [anon_sym_EQ_TILDE] = ACTIONS(355),
    [anon_sym_EQ_EQ] = ACTIONS(355),
    [anon_sym_LT] = ACTIONS(355),
    [anon_sym_GT] = ACTIONS(355),
    [anon_sym_GT_GT] = ACTIONS(353),
    [anon_sym_AMP_GT] = ACTIONS(355),
    [anon_sym_AMP_GT_GT] = ACTIONS(353),
    [anon_sym_LT_AMP] = ACTIONS(353),
    [anon_sym_GT_AMP] = ACTIONS(353),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(353),
    [anon_sym_LT_LT_LT] = ACTIONS(353),
    [anon_sym_DOLLAR] = ACTIONS(355),
    [sym__special_character] = ACTIONS(353),
    [anon_sym_DQUOTE] = ACTIONS(353),
    [sym_raw_string] = ACTIONS(353),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(353),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [anon_sym_LT_LPAREN] = ACTIONS(353),
    [anon_sym_GT_LPAREN] = ACTIONS(353),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(355),
    [anon_sym_LF] = ACTIONS(353),
    [anon_sym_AMP] = ACTIONS(355),
  },
  [223] = {
    [aux_sym_concatenation_repeat1] = STATE(664),
    [sym__simple_heredoc_body] = ACTIONS(353),
    [sym__heredoc_body_beginning] = ACTIONS(353),
    [sym_file_descriptor] = ACTIONS(353),
    [sym__concat] = ACTIONS(337),
    [anon_sym_SEMI] = ACTIONS(355),
    [anon_sym_PIPE] = ACTIONS(355),
    [anon_sym_SEMI_SEMI] = ACTIONS(353),
    [anon_sym_LPAREN] = ACTIONS(387),
    [anon_sym_PIPE_AMP] = ACTIONS(353),
    [anon_sym_AMP_AMP] = ACTIONS(353),
    [anon_sym_PIPE_PIPE] = ACTIONS(353),
    [anon_sym_EQ_TILDE] = ACTIONS(355),
    [anon_sym_EQ_EQ] = ACTIONS(355),
    [anon_sym_LT] = ACTIONS(355),
    [anon_sym_GT] = ACTIONS(355),
    [anon_sym_GT_GT] = ACTIONS(353),
    [anon_sym_AMP_GT] = ACTIONS(355),
    [anon_sym_AMP_GT_GT] = ACTIONS(353),
    [anon_sym_LT_AMP] = ACTIONS(353),
    [anon_sym_GT_AMP] = ACTIONS(353),
    [anon_sym_LT_LT] = ACTIONS(355),
    [anon_sym_LT_LT_DASH] = ACTIONS(353),
    [anon_sym_LT_LT_LT] = ACTIONS(353),
    [anon_sym_DOLLAR] = ACTIONS(355),
    [sym__special_character] = ACTIONS(353),
    [anon_sym_DQUOTE] = ACTIONS(353),
    [sym_raw_string] = ACTIONS(353),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(353),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(353),
    [anon_sym_BQUOTE] = ACTIONS(353),
    [anon_sym_LT_LPAREN] = ACTIONS(353),
    [anon_sym_GT_LPAREN] = ACTIONS(353),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(355),
    [anon_sym_LF] = ACTIONS(353),
    [anon_sym_AMP] = ACTIONS(355),
  },
  [224] = {
    [anon_sym_BQUOTE] = ACTIONS(1165),
    [sym_comment] = ACTIONS(57),
  },
  [225] = {
    [sym_file_redirect] = STATE(672),
    [sym_heredoc_redirect] = STATE(672),
    [sym_heredoc_body] = STATE(671),
    [sym_herestring_redirect] = STATE(672),
    [aux_sym_redirected_statement_repeat1] = STATE(672),
    [sym__simple_heredoc_body] = ACTIONS(393),
    [sym__heredoc_body_beginning] = ACTIONS(395),
    [sym_file_descriptor] = ACTIONS(1187),
    [anon_sym_SEMI] = ACTIONS(1189),
    [anon_sym_PIPE] = ACTIONS(1191),
    [anon_sym_SEMI_SEMI] = ACTIONS(1193),
    [anon_sym_PIPE_AMP] = ACTIONS(1195),
    [anon_sym_AMP_AMP] = ACTIONS(1197),
    [anon_sym_PIPE_PIPE] = ACTIONS(1197),
    [anon_sym_LT] = ACTIONS(1199),
    [anon_sym_GT] = ACTIONS(1199),
    [anon_sym_GT_GT] = ACTIONS(1201),
    [anon_sym_AMP_GT] = ACTIONS(1199),
    [anon_sym_AMP_GT_GT] = ACTIONS(1201),
    [anon_sym_LT_AMP] = ACTIONS(1201),
    [anon_sym_GT_AMP] = ACTIONS(1201),
    [anon_sym_LT_LT] = ACTIONS(415),
    [anon_sym_LT_LT_DASH] = ACTIONS(417),
    [anon_sym_LT_LT_LT] = ACTIONS(1203),
    [anon_sym_BQUOTE] = ACTIONS(399),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(1193),
    [anon_sym_AMP] = ACTIONS(1189),
  },
  [226] = {
    [sym_concatenation] = STATE(675),
    [sym_string] = STATE(674),
    [sym_simple_expansion] = STATE(674),
    [sym_string_expansion] = STATE(674),
    [sym_expansion] = STATE(674),
    [sym_command_substitution] = STATE(674),
    [sym_process_substitution] = STATE(674),
    [aux_sym_command_repeat2] = STATE(675),
    [aux_sym__literal_repeat1] = STATE(676),
    [sym__simple_heredoc_body] = ACTIONS(421),
    [sym__heredoc_body_beginning] = ACTIONS(421),
    [sym_file_descriptor] = ACTIONS(421),
    [anon_sym_SEMI] = ACTIONS(423),
    [anon_sym_PIPE] = ACTIONS(423),
    [anon_sym_SEMI_SEMI] = ACTIONS(421),
    [anon_sym_PIPE_AMP] = ACTIONS(421),
    [anon_sym_AMP_AMP] = ACTIONS(421),
    [anon_sym_PIPE_PIPE] = ACTIONS(421),
    [anon_sym_EQ_TILDE] = ACTIONS(1205),
    [anon_sym_EQ_EQ] = ACTIONS(1205),
    [anon_sym_LT] = ACTIONS(423),
    [anon_sym_GT] = ACTIONS(423),
    [anon_sym_GT_GT] = ACTIONS(421),
    [anon_sym_AMP_GT] = ACTIONS(423),
    [anon_sym_AMP_GT_GT] = ACTIONS(421),
    [anon_sym_LT_AMP] = ACTIONS(421),
    [anon_sym_GT_AMP] = ACTIONS(421),
    [anon_sym_LT_LT] = ACTIONS(423),
    [anon_sym_LT_LT_DASH] = ACTIONS(421),
    [anon_sym_LT_LT_LT] = ACTIONS(421),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(1207),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(1209),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(421),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1211),
    [anon_sym_LF] = ACTIONS(421),
    [anon_sym_AMP] = ACTIONS(423),
  },
  [227] = {
    [sym_file_redirect] = STATE(672),
    [sym_heredoc_redirect] = STATE(672),
    [sym_heredoc_body] = STATE(671),
    [sym_herestring_redirect] = STATE(672),
    [aux_sym_redirected_statement_repeat1] = STATE(672),
    [sym__simple_heredoc_body] = ACTIONS(393),
    [sym__heredoc_body_beginning] = ACTIONS(395),
    [sym_file_descriptor] = ACTIONS(433),
    [sym_variable_name] = ACTIONS(433),
    [anon_sym_SEMI] = ACTIONS(1189),
    [anon_sym_PIPE] = ACTIONS(1191),
    [anon_sym_SEMI_SEMI] = ACTIONS(1193),
    [anon_sym_PIPE_AMP] = ACTIONS(1195),
    [anon_sym_AMP_AMP] = ACTIONS(1197),
    [anon_sym_PIPE_PIPE] = ACTIONS(1197),
    [anon_sym_LT] = ACTIONS(435),
    [anon_sym_GT] = ACTIONS(435),
    [anon_sym_GT_GT] = ACTIONS(433),
    [anon_sym_AMP_GT] = ACTIONS(435),
    [anon_sym_AMP_GT_GT] = ACTIONS(433),
    [anon_sym_LT_AMP] = ACTIONS(433),
    [anon_sym_GT_AMP] = ACTIONS(433),
    [anon_sym_LT_LT] = ACTIONS(415),
    [anon_sym_LT_LT_DASH] = ACTIONS(417),
    [anon_sym_LT_LT_LT] = ACTIONS(1203),
    [anon_sym_DOLLAR] = ACTIONS(435),
    [sym__special_character] = ACTIONS(433),
    [anon_sym_DQUOTE] = ACTIONS(433),
    [sym_raw_string] = ACTIONS(433),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(433),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(433),
    [anon_sym_BQUOTE] = ACTIONS(399),
    [anon_sym_LT_LPAREN] = ACTIONS(433),
    [anon_sym_GT_LPAREN] = ACTIONS(433),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(435),
    [anon_sym_LF] = ACTIONS(1193),
    [anon_sym_AMP] = ACTIONS(1189),
  },
  [228] = {
    [anon_sym_EQ] = ACTIONS(1167),
    [anon_sym_PLUS_EQ] = ACTIONS(1167),
    [sym_comment] = ACTIONS(57),
  },
  [229] = {
    [sym_redirected_statement] = STATE(677),
    [sym_for_statement] = STATE(677),
    [sym_c_style_for_statement] = STATE(677),
    [sym_while_statement] = STATE(677),
    [sym_if_statement] = STATE(677),
    [sym_case_statement] = STATE(677),
    [sym_function_definition] = STATE(677),
    [sym_compound_statement] = STATE(677),
    [sym_subshell] = STATE(677),
    [sym_pipeline] = STATE(677),
    [sym_list] = STATE(677),
    [sym_negated_command] = STATE(677),
    [sym_test_command] = STATE(677),
    [sym_declaration_command] = STATE(677),
    [sym_unset_command] = STATE(677),
    [sym_command] = STATE(677),
    [sym_command_name] = STATE(226),
    [sym_variable_assignment] = STATE(678),
    [sym_subscript] = STATE(228),
    [sym_file_redirect] = STATE(230),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(222),
    [sym_simple_expansion] = STATE(222),
    [sym_string_expansion] = STATE(222),
    [sym_expansion] = STATE(222),
    [sym_command_substitution] = STATE(222),
    [sym_process_substitution] = STATE(222),
    [aux_sym__statements_repeat1] = STATE(251),
    [aux_sym_command_repeat1] = STATE(230),
    [aux_sym__literal_repeat1] = STATE(231),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(375),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_typeset] = ACTIONS(377),
    [anon_sym_export] = ACTIONS(377),
    [anon_sym_readonly] = ACTIONS(377),
    [anon_sym_local] = ACTIONS(377),
    [anon_sym_unset] = ACTIONS(379),
    [anon_sym_unsetenv] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(381),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(383),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(385),
  },
  [230] = {
    [sym_command_name] = STATE(679),
    [sym_variable_assignment] = STATE(253),
    [sym_subscript] = STATE(147),
    [sym_file_redirect] = STATE(253),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(222),
    [sym_simple_expansion] = STATE(222),
    [sym_string_expansion] = STATE(222),
    [sym_expansion] = STATE(222),
    [sym_command_substitution] = STATE(222),
    [sym_process_substitution] = STATE(222),
    [aux_sym_command_repeat1] = STATE(253),
    [aux_sym__literal_repeat1] = STATE(231),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(223),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(1207),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(383),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(383),
  },
  [231] = {
    [aux_sym__literal_repeat1] = STATE(680),
    [sym__simple_heredoc_body] = ACTIONS(437),
    [sym__heredoc_body_beginning] = ACTIONS(437),
    [sym_file_descriptor] = ACTIONS(437),
    [anon_sym_SEMI] = ACTIONS(439),
    [anon_sym_PIPE] = ACTIONS(439),
    [anon_sym_SEMI_SEMI] = ACTIONS(437),
    [anon_sym_PIPE_AMP] = ACTIONS(437),
    [anon_sym_AMP_AMP] = ACTIONS(437),
    [anon_sym_PIPE_PIPE] = ACTIONS(437),
    [anon_sym_EQ_TILDE] = ACTIONS(439),
    [anon_sym_EQ_EQ] = ACTIONS(439),
    [anon_sym_LT] = ACTIONS(439),
    [anon_sym_GT] = ACTIONS(439),
    [anon_sym_GT_GT] = ACTIONS(437),
    [anon_sym_AMP_GT] = ACTIONS(439),
    [anon_sym_AMP_GT_GT] = ACTIONS(437),
    [anon_sym_LT_AMP] = ACTIONS(437),
    [anon_sym_GT_AMP] = ACTIONS(437),
    [anon_sym_LT_LT] = ACTIONS(439),
    [anon_sym_LT_LT_DASH] = ACTIONS(437),
    [anon_sym_LT_LT_LT] = ACTIONS(437),
    [anon_sym_DOLLAR] = ACTIONS(439),
    [sym__special_character] = ACTIONS(441),
    [anon_sym_DQUOTE] = ACTIONS(437),
    [sym_raw_string] = ACTIONS(437),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(437),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(437),
    [anon_sym_BQUOTE] = ACTIONS(437),
    [anon_sym_LT_LPAREN] = ACTIONS(437),
    [anon_sym_GT_LPAREN] = ACTIONS(437),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(439),
    [anon_sym_LF] = ACTIONS(437),
    [anon_sym_AMP] = ACTIONS(439),
  },
  [232] = {
    [anon_sym_RPAREN] = ACTIONS(1213),
    [sym_comment] = ACTIONS(57),
  },
  [233] = {
    [anon_sym_RPAREN] = ACTIONS(1215),
    [sym_comment] = ACTIONS(57),
  },
  [234] = {
    [ts_builtin_sym_end] = ACTIONS(1217),
    [anon_sym_SEMI] = ACTIONS(1219),
    [anon_sym_done] = ACTIONS(1217),
    [anon_sym_fi] = ACTIONS(1217),
    [anon_sym_elif] = ACTIONS(1217),
    [anon_sym_else] = ACTIONS(1217),
    [anon_sym_esac] = ACTIONS(1217),
    [anon_sym_RPAREN] = ACTIONS(1217),
    [anon_sym_SEMI_SEMI] = ACTIONS(1217),
    [anon_sym_BQUOTE] = ACTIONS(1217),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(1217),
    [anon_sym_AMP] = ACTIONS(1217),
  },
  [235] = {
    [sym_simple_expansion] = STATE(688),
    [sym_expansion] = STATE(688),
    [sym_command_substitution] = STATE(688),
    [aux_sym_heredoc_body_repeat1] = STATE(688),
    [sym__heredoc_body_middle] = ACTIONS(1221),
    [sym__heredoc_body_end] = ACTIONS(1223),
    [anon_sym_DOLLAR] = ACTIONS(1225),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1227),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1229),
    [anon_sym_BQUOTE] = ACTIONS(1231),
    [sym_comment] = ACTIONS(57),
  },
  [236] = {
    [anon_sym_LT] = ACTIONS(1233),
    [anon_sym_GT] = ACTIONS(1233),
    [anon_sym_GT_GT] = ACTIONS(1235),
    [anon_sym_AMP_GT] = ACTIONS(1233),
    [anon_sym_AMP_GT_GT] = ACTIONS(1235),
    [anon_sym_LT_AMP] = ACTIONS(1235),
    [anon_sym_GT_AMP] = ACTIONS(1235),
    [sym_comment] = ACTIONS(57),
  },
  [237] = {
    [sym_file_descriptor] = ACTIONS(1237),
    [sym_variable_name] = ACTIONS(1237),
    [ts_builtin_sym_end] = ACTIONS(1239),
    [anon_sym_for] = ACTIONS(1241),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(1237),
    [anon_sym_while] = ACTIONS(1241),
    [anon_sym_if] = ACTIONS(1241),
    [anon_sym_case] = ACTIONS(1241),
    [anon_sym_RPAREN] = ACTIONS(1239),
    [anon_sym_SEMI_SEMI] = ACTIONS(1239),
    [anon_sym_function] = ACTIONS(1241),
    [anon_sym_LPAREN] = ACTIONS(1241),
    [anon_sym_LBRACE] = ACTIONS(1237),
    [anon_sym_BANG] = ACTIONS(1241),
    [anon_sym_LBRACK] = ACTIONS(1241),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1237),
    [anon_sym_declare] = ACTIONS(1241),
    [anon_sym_typeset] = ACTIONS(1241),
    [anon_sym_export] = ACTIONS(1241),
    [anon_sym_readonly] = ACTIONS(1241),
    [anon_sym_local] = ACTIONS(1241),
    [anon_sym_unset] = ACTIONS(1241),
    [anon_sym_unsetenv] = ACTIONS(1241),
    [anon_sym_LT] = ACTIONS(1241),
    [anon_sym_GT] = ACTIONS(1241),
    [anon_sym_GT_GT] = ACTIONS(1237),
    [anon_sym_AMP_GT] = ACTIONS(1241),
    [anon_sym_AMP_GT_GT] = ACTIONS(1237),
    [anon_sym_LT_AMP] = ACTIONS(1237),
    [anon_sym_GT_AMP] = ACTIONS(1237),
    [anon_sym_DOLLAR] = ACTIONS(1241),
    [sym__special_character] = ACTIONS(1241),
    [anon_sym_DQUOTE] = ACTIONS(1237),
    [sym_raw_string] = ACTIONS(1237),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1237),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1237),
    [anon_sym_BQUOTE] = ACTIONS(1237),
    [anon_sym_LT_LPAREN] = ACTIONS(1237),
    [anon_sym_GT_LPAREN] = ACTIONS(1237),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1241),
  },
  [238] = {
    [sym_redirected_statement] = STATE(690),
    [sym_for_statement] = STATE(690),
    [sym_c_style_for_statement] = STATE(690),
    [sym_while_statement] = STATE(690),
    [sym_if_statement] = STATE(690),
    [sym_case_statement] = STATE(690),
    [sym_function_definition] = STATE(690),
    [sym_compound_statement] = STATE(690),
    [sym_subshell] = STATE(690),
    [sym_pipeline] = STATE(690),
    [sym_list] = STATE(690),
    [sym_negated_command] = STATE(690),
    [sym_test_command] = STATE(690),
    [sym_declaration_command] = STATE(690),
    [sym_unset_command] = STATE(690),
    [sym_command] = STATE(690),
    [sym_command_name] = STATE(30),
    [sym_variable_assignment] = STATE(691),
    [sym_subscript] = STATE(32),
    [sym_file_redirect] = STATE(35),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(21),
    [sym_simple_expansion] = STATE(21),
    [sym_string_expansion] = STATE(21),
    [sym_expansion] = STATE(21),
    [sym_command_substitution] = STATE(21),
    [sym_process_substitution] = STATE(21),
    [aux_sym_command_repeat1] = STATE(35),
    [aux_sym__literal_repeat1] = STATE(36),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(33),
    [anon_sym_typeset] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(33),
    [anon_sym_readonly] = ACTIONS(33),
    [anon_sym_local] = ACTIONS(33),
    [anon_sym_unset] = ACTIONS(35),
    [anon_sym_unsetenv] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(43),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(47),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(59),
  },
  [239] = {
    [sym_redirected_statement] = STATE(692),
    [sym_for_statement] = STATE(692),
    [sym_c_style_for_statement] = STATE(692),
    [sym_while_statement] = STATE(692),
    [sym_if_statement] = STATE(692),
    [sym_case_statement] = STATE(692),
    [sym_function_definition] = STATE(692),
    [sym_compound_statement] = STATE(692),
    [sym_subshell] = STATE(692),
    [sym_pipeline] = STATE(692),
    [sym_list] = STATE(692),
    [sym_negated_command] = STATE(692),
    [sym_test_command] = STATE(692),
    [sym_declaration_command] = STATE(692),
    [sym_unset_command] = STATE(692),
    [sym_command] = STATE(692),
    [sym_command_name] = STATE(30),
    [sym_variable_assignment] = STATE(693),
    [sym_subscript] = STATE(32),
    [sym_file_redirect] = STATE(35),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(21),
    [sym_simple_expansion] = STATE(21),
    [sym_string_expansion] = STATE(21),
    [sym_expansion] = STATE(21),
    [sym_command_substitution] = STATE(21),
    [sym_process_substitution] = STATE(21),
    [aux_sym_command_repeat1] = STATE(35),
    [aux_sym__literal_repeat1] = STATE(36),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(33),
    [anon_sym_typeset] = ACTIONS(33),
    [anon_sym_export] = ACTIONS(33),
    [anon_sym_readonly] = ACTIONS(33),
    [anon_sym_local] = ACTIONS(33),
    [anon_sym_unset] = ACTIONS(35),
    [anon_sym_unsetenv] = ACTIONS(35),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(43),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(47),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(59),
  },
  [240] = {
    [sym_concatenation] = STATE(696),
    [sym_string] = STATE(695),
    [sym_simple_expansion] = STATE(695),
    [sym_string_expansion] = STATE(695),
    [sym_expansion] = STATE(695),
    [sym_command_substitution] = STATE(695),
    [sym_process_substitution] = STATE(695),
    [aux_sym__literal_repeat1] = STATE(697),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(1243),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(1245),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1245),
  },
  [241] = {
    [sym_heredoc_start] = ACTIONS(1247),
    [sym_comment] = ACTIONS(57),
  },
  [242] = {
    [sym_concatenation] = STATE(700),
    [sym_string] = STATE(699),
    [sym_simple_expansion] = STATE(699),
    [sym_string_expansion] = STATE(699),
    [sym_expansion] = STATE(699),
    [sym_command_substitution] = STATE(699),
    [sym_process_substitution] = STATE(699),
    [aux_sym__literal_repeat1] = STATE(701),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(1243),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(1249),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1249),
  },
  [243] = {
    [ts_builtin_sym_end] = ACTIONS(1239),
    [anon_sym_SEMI] = ACTIONS(1251),
    [anon_sym_RPAREN] = ACTIONS(1239),
    [anon_sym_SEMI_SEMI] = ACTIONS(1253),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(1253),
    [anon_sym_AMP] = ACTIONS(1253),
  },
  [244] = {
    [sym_file_redirect] = STATE(703),
    [sym_heredoc_redirect] = STATE(703),
    [sym_herestring_redirect] = STATE(703),
    [aux_sym_redirected_statement_repeat1] = STATE(703),
    [sym__simple_heredoc_body] = ACTIONS(1255),
    [sym__heredoc_body_beginning] = ACTIONS(1255),
    [sym_file_descriptor] = ACTIONS(397),
    [ts_builtin_sym_end] = ACTIONS(1255),
    [anon_sym_SEMI] = ACTIONS(1257),
    [anon_sym_PIPE] = ACTIONS(1257),
    [anon_sym_SEMI_SEMI] = ACTIONS(1255),
    [anon_sym_PIPE_AMP] = ACTIONS(1255),
    [anon_sym_AMP_AMP] = ACTIONS(1255),
    [anon_sym_PIPE_PIPE] = ACTIONS(1255),
    [anon_sym_LT] = ACTIONS(411),
    [anon_sym_GT] = ACTIONS(411),
    [anon_sym_GT_GT] = ACTIONS(413),
    [anon_sym_AMP_GT] = ACTIONS(411),
    [anon_sym_AMP_GT_GT] = ACTIONS(413),
    [anon_sym_LT_AMP] = ACTIONS(413),
    [anon_sym_GT_AMP] = ACTIONS(413),
    [anon_sym_LT_LT] = ACTIONS(415),
    [anon_sym_LT_LT_DASH] = ACTIONS(417),
    [anon_sym_LT_LT_LT] = ACTIONS(419),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(1255),
    [anon_sym_AMP] = ACTIONS(1257),
  },
  [245] = {
    [sym_concatenation] = STATE(704),
    [sym_string] = STATE(705),
    [sym_simple_expansion] = STATE(705),
    [sym_string_expansion] = STATE(705),
    [sym_expansion] = STATE(705),
    [sym_command_substitution] = STATE(705),
    [sym_process_substitution] = STATE(705),
    [aux_sym__literal_repeat1] = STATE(706),
    [sym_regex] = ACTIONS(1259),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(427),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(1261),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1261),
  },
  [246] = {
    [aux_sym_concatenation_repeat1] = STATE(201),
    [sym__simple_heredoc_body] = ACTIONS(1263),
    [sym__heredoc_body_beginning] = ACTIONS(1263),
    [sym_file_descriptor] = ACTIONS(1263),
    [sym__concat] = ACTIONS(337),
    [ts_builtin_sym_end] = ACTIONS(1263),
    [anon_sym_SEMI] = ACTIONS(1265),
    [anon_sym_PIPE] = ACTIONS(1265),
    [anon_sym_SEMI_SEMI] = ACTIONS(1263),
    [anon_sym_PIPE_AMP] = ACTIONS(1263),
    [anon_sym_AMP_AMP] = ACTIONS(1263),
    [anon_sym_PIPE_PIPE] = ACTIONS(1263),
    [anon_sym_EQ_TILDE] = ACTIONS(1265),
    [anon_sym_EQ_EQ] = ACTIONS(1265),
    [anon_sym_LT] = ACTIONS(1265),
    [anon_sym_GT] = ACTIONS(1265),
    [anon_sym_GT_GT] = ACTIONS(1263),
    [anon_sym_AMP_GT] = ACTIONS(1265),
    [anon_sym_AMP_GT_GT] = ACTIONS(1263),
    [anon_sym_LT_AMP] = ACTIONS(1263),
    [anon_sym_GT_AMP] = ACTIONS(1263),
    [anon_sym_LT_LT] = ACTIONS(1265),
    [anon_sym_LT_LT_DASH] = ACTIONS(1263),
    [anon_sym_LT_LT_LT] = ACTIONS(1263),
    [anon_sym_DOLLAR] = ACTIONS(1265),
    [sym__special_character] = ACTIONS(1263),
    [anon_sym_DQUOTE] = ACTIONS(1263),
    [sym_raw_string] = ACTIONS(1263),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1263),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1263),
    [anon_sym_BQUOTE] = ACTIONS(1263),
    [anon_sym_LT_LPAREN] = ACTIONS(1263),
    [anon_sym_GT_LPAREN] = ACTIONS(1263),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1265),
    [anon_sym_LF] = ACTIONS(1263),
    [anon_sym_AMP] = ACTIONS(1265),
  },
  [247] = {
    [sym_concatenation] = STATE(707),
    [sym_string] = STATE(246),
    [sym_simple_expansion] = STATE(246),
    [sym_string_expansion] = STATE(246),
    [sym_expansion] = STATE(246),
    [sym_command_substitution] = STATE(246),
    [sym_process_substitution] = STATE(246),
    [aux_sym_command_repeat2] = STATE(707),
    [aux_sym__literal_repeat1] = STATE(248),
    [sym__simple_heredoc_body] = ACTIONS(1267),
    [sym__heredoc_body_beginning] = ACTIONS(1267),
    [sym_file_descriptor] = ACTIONS(1267),
    [ts_builtin_sym_end] = ACTIONS(1267),
    [anon_sym_SEMI] = ACTIONS(1269),
    [anon_sym_PIPE] = ACTIONS(1269),
    [anon_sym_SEMI_SEMI] = ACTIONS(1267),
    [anon_sym_PIPE_AMP] = ACTIONS(1267),
    [anon_sym_AMP_AMP] = ACTIONS(1267),
    [anon_sym_PIPE_PIPE] = ACTIONS(1267),
    [anon_sym_EQ_TILDE] = ACTIONS(425),
    [anon_sym_EQ_EQ] = ACTIONS(425),
    [anon_sym_LT] = ACTIONS(1269),
    [anon_sym_GT] = ACTIONS(1269),
    [anon_sym_GT_GT] = ACTIONS(1267),
    [anon_sym_AMP_GT] = ACTIONS(1269),
    [anon_sym_AMP_GT_GT] = ACTIONS(1267),
    [anon_sym_LT_AMP] = ACTIONS(1267),
    [anon_sym_GT_AMP] = ACTIONS(1267),
    [anon_sym_LT_LT] = ACTIONS(1269),
    [anon_sym_LT_LT_DASH] = ACTIONS(1267),
    [anon_sym_LT_LT_LT] = ACTIONS(1267),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(427),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(429),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(431),
    [anon_sym_LF] = ACTIONS(1267),
    [anon_sym_AMP] = ACTIONS(1269),
  },
  [248] = {
    [aux_sym__literal_repeat1] = STATE(255),
    [sym__simple_heredoc_body] = ACTIONS(1271),
    [sym__heredoc_body_beginning] = ACTIONS(1271),
    [sym_file_descriptor] = ACTIONS(1271),
    [ts_builtin_sym_end] = ACTIONS(1271),
    [anon_sym_SEMI] = ACTIONS(1273),
    [anon_sym_PIPE] = ACTIONS(1273),
    [anon_sym_SEMI_SEMI] = ACTIONS(1271),
    [anon_sym_PIPE_AMP] = ACTIONS(1271),
    [anon_sym_AMP_AMP] = ACTIONS(1271),
    [anon_sym_PIPE_PIPE] = ACTIONS(1271),
    [anon_sym_EQ_TILDE] = ACTIONS(1273),
    [anon_sym_EQ_EQ] = ACTIONS(1273),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_GT] = ACTIONS(1273),
    [anon_sym_GT_GT] = ACTIONS(1271),
    [anon_sym_AMP_GT] = ACTIONS(1273),
    [anon_sym_AMP_GT_GT] = ACTIONS(1271),
    [anon_sym_LT_AMP] = ACTIONS(1271),
    [anon_sym_GT_AMP] = ACTIONS(1271),
    [anon_sym_LT_LT] = ACTIONS(1273),
    [anon_sym_LT_LT_DASH] = ACTIONS(1271),
    [anon_sym_LT_LT_LT] = ACTIONS(1271),
    [anon_sym_DOLLAR] = ACTIONS(1273),
    [sym__special_character] = ACTIONS(441),
    [anon_sym_DQUOTE] = ACTIONS(1271),
    [sym_raw_string] = ACTIONS(1271),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1271),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1271),
    [anon_sym_BQUOTE] = ACTIONS(1271),
    [anon_sym_LT_LPAREN] = ACTIONS(1271),
    [anon_sym_GT_LPAREN] = ACTIONS(1271),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1273),
    [anon_sym_LF] = ACTIONS(1271),
    [anon_sym_AMP] = ACTIONS(1273),
  },
  [249] = {
    [sym_file_redirect] = STATE(244),
    [sym_heredoc_redirect] = STATE(244),
    [sym_heredoc_body] = STATE(709),
    [sym_herestring_redirect] = STATE(244),
    [aux_sym_redirected_statement_repeat1] = STATE(244),
    [sym__simple_heredoc_body] = ACTIONS(393),
    [sym__heredoc_body_beginning] = ACTIONS(395),
    [sym_file_descriptor] = ACTIONS(397),
    [ts_builtin_sym_end] = ACTIONS(1239),
    [anon_sym_SEMI] = ACTIONS(1275),
    [anon_sym_PIPE] = ACTIONS(403),
    [anon_sym_SEMI_SEMI] = ACTIONS(1277),
    [anon_sym_PIPE_AMP] = ACTIONS(407),
    [anon_sym_AMP_AMP] = ACTIONS(409),
    [anon_sym_PIPE_PIPE] = ACTIONS(409),
    [anon_sym_LT] = ACTIONS(411),
    [anon_sym_GT] = ACTIONS(411),
    [anon_sym_GT_GT] = ACTIONS(413),
    [anon_sym_AMP_GT] = ACTIONS(411),
    [anon_sym_AMP_GT_GT] = ACTIONS(413),
    [anon_sym_LT_AMP] = ACTIONS(413),
    [anon_sym_GT_AMP] = ACTIONS(413),
    [anon_sym_LT_LT] = ACTIONS(415),
    [anon_sym_LT_LT_DASH] = ACTIONS(417),
    [anon_sym_LT_LT_LT] = ACTIONS(419),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(1277),
    [anon_sym_AMP] = ACTIONS(1275),
  },
  [250] = {
    [sym_file_redirect] = STATE(244),
    [sym_heredoc_redirect] = STATE(244),
    [sym_heredoc_body] = STATE(709),
    [sym_herestring_redirect] = STATE(244),
    [aux_sym_redirected_statement_repeat1] = STATE(244),
    [sym__simple_heredoc_body] = ACTIONS(393),
    [sym__heredoc_body_beginning] = ACTIONS(395),
    [sym_file_descriptor] = ACTIONS(433),
    [sym_variable_name] = ACTIONS(433),
    [ts_builtin_sym_end] = ACTIONS(1239),
    [anon_sym_SEMI] = ACTIONS(1275),
    [anon_sym_PIPE] = ACTIONS(403),
    [anon_sym_SEMI_SEMI] = ACTIONS(1277),
    [anon_sym_PIPE_AMP] = ACTIONS(407),
    [anon_sym_AMP_AMP] = ACTIONS(409),
    [anon_sym_PIPE_PIPE] = ACTIONS(409),
    [anon_sym_LT] = ACTIONS(435),
    [anon_sym_GT] = ACTIONS(435),
    [anon_sym_GT_GT] = ACTIONS(433),
    [anon_sym_AMP_GT] = ACTIONS(435),
    [anon_sym_AMP_GT_GT] = ACTIONS(433),
    [anon_sym_LT_AMP] = ACTIONS(433),
    [anon_sym_GT_AMP] = ACTIONS(433),
    [anon_sym_LT_LT] = ACTIONS(415),
    [anon_sym_LT_LT_DASH] = ACTIONS(417),
    [anon_sym_LT_LT_LT] = ACTIONS(419),
    [anon_sym_DOLLAR] = ACTIONS(435),
    [sym__special_character] = ACTIONS(433),
    [anon_sym_DQUOTE] = ACTIONS(433),
    [sym_raw_string] = ACTIONS(433),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(433),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(433),
    [anon_sym_BQUOTE] = ACTIONS(433),
    [anon_sym_LT_LPAREN] = ACTIONS(433),
    [anon_sym_GT_LPAREN] = ACTIONS(433),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(435),
    [anon_sym_LF] = ACTIONS(1277),
    [anon_sym_AMP] = ACTIONS(1275),
  },
  [251] = {
    [sym_redirected_statement] = STATE(713),
    [sym_for_statement] = STATE(713),
    [sym_c_style_for_statement] = STATE(713),
    [sym_while_statement] = STATE(713),
    [sym_if_statement] = STATE(713),
    [sym_case_statement] = STATE(713),
    [sym_function_definition] = STATE(713),
    [sym_compound_statement] = STATE(713),
    [sym_subshell] = STATE(713),
    [sym_pipeline] = STATE(713),
    [sym_list] = STATE(713),
    [sym_negated_command] = STATE(713),
    [sym_test_command] = STATE(713),
    [sym_declaration_command] = STATE(713),
    [sym_unset_command] = STATE(713),
    [sym_command] = STATE(713),
    [sym_command_name] = STATE(714),
    [sym_variable_assignment] = STATE(715),
    [sym_subscript] = STATE(228),
    [sym_file_redirect] = STATE(716),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(222),
    [sym_simple_expansion] = STATE(222),
    [sym_string_expansion] = STATE(222),
    [sym_expansion] = STATE(222),
    [sym_command_substitution] = STATE(222),
    [sym_process_substitution] = STATE(222),
    [aux_sym__statements_repeat1] = STATE(251),
    [aux_sym_command_repeat1] = STATE(716),
    [aux_sym__literal_repeat1] = STATE(231),
    [sym_file_descriptor] = ACTIONS(1279),
    [sym_variable_name] = ACTIONS(1282),
    [anon_sym_for] = ACTIONS(1285),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(1288),
    [anon_sym_while] = ACTIONS(1291),
    [anon_sym_if] = ACTIONS(1294),
    [anon_sym_case] = ACTIONS(1297),
    [anon_sym_function] = ACTIONS(1300),
    [anon_sym_LPAREN] = ACTIONS(1303),
    [anon_sym_LBRACE] = ACTIONS(1306),
    [anon_sym_BANG] = ACTIONS(1309),
    [anon_sym_LBRACK] = ACTIONS(1312),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1315),
    [anon_sym_declare] = ACTIONS(1318),
    [anon_sym_typeset] = ACTIONS(1318),
    [anon_sym_export] = ACTIONS(1318),
    [anon_sym_readonly] = ACTIONS(1318),
    [anon_sym_local] = ACTIONS(1318),
    [anon_sym_unset] = ACTIONS(1321),
    [anon_sym_unsetenv] = ACTIONS(1321),
    [anon_sym_LT] = ACTIONS(1324),
    [anon_sym_GT] = ACTIONS(1324),
    [anon_sym_GT_GT] = ACTIONS(1327),
    [anon_sym_AMP_GT] = ACTIONS(1324),
    [anon_sym_AMP_GT_GT] = ACTIONS(1327),
    [anon_sym_LT_AMP] = ACTIONS(1327),
    [anon_sym_GT_AMP] = ACTIONS(1327),
    [anon_sym_DOLLAR] = ACTIONS(1330),
    [sym__special_character] = ACTIONS(1333),
    [anon_sym_DQUOTE] = ACTIONS(1336),
    [sym_raw_string] = ACTIONS(1339),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1342),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1345),
    [anon_sym_BQUOTE] = ACTIONS(1348),
    [anon_sym_LT_LPAREN] = ACTIONS(1351),
    [anon_sym_GT_LPAREN] = ACTIONS(1351),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1354),
  },
  [252] = {
    [sym_concatenation] = STATE(717),
    [sym_string] = STATE(246),
    [sym_simple_expansion] = STATE(246),
    [sym_string_expansion] = STATE(246),
    [sym_expansion] = STATE(246),
    [sym_command_substitution] = STATE(246),
    [sym_process_substitution] = STATE(246),
    [aux_sym_command_repeat2] = STATE(717),
    [aux_sym__literal_repeat1] = STATE(248),
    [sym__simple_heredoc_body] = ACTIONS(1267),
    [sym__heredoc_body_beginning] = ACTIONS(1267),
    [sym_file_descriptor] = ACTIONS(1267),
    [ts_builtin_sym_end] = ACTIONS(1267),
    [anon_sym_SEMI] = ACTIONS(1269),
    [anon_sym_PIPE] = ACTIONS(1269),
    [anon_sym_SEMI_SEMI] = ACTIONS(1267),
    [anon_sym_PIPE_AMP] = ACTIONS(1267),
    [anon_sym_AMP_AMP] = ACTIONS(1267),
    [anon_sym_PIPE_PIPE] = ACTIONS(1267),
    [anon_sym_EQ_TILDE] = ACTIONS(425),
    [anon_sym_EQ_EQ] = ACTIONS(425),
    [anon_sym_LT] = ACTIONS(1269),
    [anon_sym_GT] = ACTIONS(1269),
    [anon_sym_GT_GT] = ACTIONS(1267),
    [anon_sym_AMP_GT] = ACTIONS(1269),
    [anon_sym_AMP_GT_GT] = ACTIONS(1267),
    [anon_sym_LT_AMP] = ACTIONS(1267),
    [anon_sym_GT_AMP] = ACTIONS(1267),
    [anon_sym_LT_LT] = ACTIONS(1269),
    [anon_sym_LT_LT_DASH] = ACTIONS(1267),
    [anon_sym_LT_LT_LT] = ACTIONS(1267),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(427),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(429),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(431),
    [anon_sym_LF] = ACTIONS(1267),
    [anon_sym_AMP] = ACTIONS(1269),
  },
  [253] = {
    [sym_variable_assignment] = STATE(253),
    [sym_subscript] = STATE(147),
    [sym_file_redirect] = STATE(253),
    [aux_sym_command_repeat1] = STATE(253),
    [sym_file_descriptor] = ACTIONS(1357),
    [sym_variable_name] = ACTIONS(1360),
    [anon_sym_LT] = ACTIONS(1363),
    [anon_sym_GT] = ACTIONS(1363),
    [anon_sym_GT_GT] = ACTIONS(1366),
    [anon_sym_AMP_GT] = ACTIONS(1363),
    [anon_sym_AMP_GT_GT] = ACTIONS(1366),
    [anon_sym_LT_AMP] = ACTIONS(1366),
    [anon_sym_GT_AMP] = ACTIONS(1366),
    [anon_sym_DOLLAR] = ACTIONS(1369),
    [sym__special_character] = ACTIONS(1371),
    [anon_sym_DQUOTE] = ACTIONS(1371),
    [sym_raw_string] = ACTIONS(1371),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1371),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1371),
    [anon_sym_BQUOTE] = ACTIONS(1371),
    [anon_sym_LT_LPAREN] = ACTIONS(1371),
    [anon_sym_GT_LPAREN] = ACTIONS(1371),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1371),
  },
  [254] = {
    [sym__simple_heredoc_body] = ACTIONS(335),
    [sym__heredoc_body_beginning] = ACTIONS(335),
    [sym_file_descriptor] = ACTIONS(335),
    [ts_builtin_sym_end] = ACTIONS(335),
    [anon_sym_SEMI] = ACTIONS(339),
    [anon_sym_PIPE] = ACTIONS(339),
    [anon_sym_RPAREN] = ACTIONS(335),
    [anon_sym_SEMI_SEMI] = ACTIONS(335),
    [anon_sym_PIPE_AMP] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_PIPE_PIPE] = ACTIONS(335),
    [anon_sym_EQ_TILDE] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_LT] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(339),
    [anon_sym_GT_GT] = ACTIONS(335),
    [anon_sym_AMP_GT] = ACTIONS(339),
    [anon_sym_AMP_GT_GT] = ACTIONS(335),
    [anon_sym_LT_AMP] = ACTIONS(335),
    [anon_sym_GT_AMP] = ACTIONS(335),
    [anon_sym_LT_LT] = ACTIONS(339),
    [anon_sym_LT_LT_DASH] = ACTIONS(335),
    [anon_sym_LT_LT_LT] = ACTIONS(335),
    [anon_sym_DOLLAR] = ACTIONS(339),
    [sym__special_character] = ACTIONS(335),
    [anon_sym_DQUOTE] = ACTIONS(335),
    [sym_raw_string] = ACTIONS(335),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(335),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(335),
    [anon_sym_LT_LPAREN] = ACTIONS(335),
    [anon_sym_GT_LPAREN] = ACTIONS(335),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(339),
    [anon_sym_LF] = ACTIONS(335),
    [anon_sym_AMP] = ACTIONS(339),
  },
  [255] = {
    [aux_sym__literal_repeat1] = STATE(255),
    [sym__simple_heredoc_body] = ACTIONS(1373),
    [sym__heredoc_body_beginning] = ACTIONS(1373),
    [sym_file_descriptor] = ACTIONS(1373),
    [ts_builtin_sym_end] = ACTIONS(1373),
    [anon_sym_SEMI] = ACTIONS(1375),
    [anon_sym_PIPE] = ACTIONS(1375),
    [anon_sym_SEMI_SEMI] = ACTIONS(1373),
    [anon_sym_PIPE_AMP] = ACTIONS(1373),
    [anon_sym_AMP_AMP] = ACTIONS(1373),
    [anon_sym_PIPE_PIPE] = ACTIONS(1373),
    [anon_sym_EQ_TILDE] = ACTIONS(1375),
    [anon_sym_EQ_EQ] = ACTIONS(1375),
    [anon_sym_LT] = ACTIONS(1375),
    [anon_sym_GT] = ACTIONS(1375),
    [anon_sym_GT_GT] = ACTIONS(1373),
    [anon_sym_AMP_GT] = ACTIONS(1375),
    [anon_sym_AMP_GT_GT] = ACTIONS(1373),
    [anon_sym_LT_AMP] = ACTIONS(1373),
    [anon_sym_GT_AMP] = ACTIONS(1373),
    [anon_sym_LT_LT] = ACTIONS(1375),
    [anon_sym_LT_LT_DASH] = ACTIONS(1373),
    [anon_sym_LT_LT_LT] = ACTIONS(1373),
    [anon_sym_DOLLAR] = ACTIONS(1375),
    [sym__special_character] = ACTIONS(1377),
    [anon_sym_DQUOTE] = ACTIONS(1373),
    [sym_raw_string] = ACTIONS(1373),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1373),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1373),
    [anon_sym_BQUOTE] = ACTIONS(1373),
    [anon_sym_LT_LPAREN] = ACTIONS(1373),
    [anon_sym_GT_LPAREN] = ACTIONS(1373),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1375),
    [anon_sym_LF] = ACTIONS(1373),
    [anon_sym_AMP] = ACTIONS(1375),
  },
  [256] = {
    [aux_sym_concatenation_repeat1] = STATE(597),
    [sym_file_descriptor] = ACTIONS(1380),
    [sym__concat] = ACTIONS(1031),
    [sym_variable_name] = ACTIONS(1380),
    [anon_sym_LT] = ACTIONS(1382),
    [anon_sym_GT] = ACTIONS(1382),
    [anon_sym_GT_GT] = ACTIONS(1380),
    [anon_sym_AMP_GT] = ACTIONS(1382),
    [anon_sym_AMP_GT_GT] = ACTIONS(1380),
    [anon_sym_LT_AMP] = ACTIONS(1380),
    [anon_sym_GT_AMP] = ACTIONS(1380),
    [anon_sym_DOLLAR] = ACTIONS(1382),
    [sym__special_character] = ACTIONS(1380),
    [anon_sym_DQUOTE] = ACTIONS(1380),
    [sym_raw_string] = ACTIONS(1380),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1380),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1380),
    [anon_sym_BQUOTE] = ACTIONS(1380),
    [anon_sym_LT_LPAREN] = ACTIONS(1380),
    [anon_sym_GT_LPAREN] = ACTIONS(1380),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1380),
  },
  [257] = {
    [sym_file_descriptor] = ACTIONS(1380),
    [sym_variable_name] = ACTIONS(1380),
    [anon_sym_RPAREN] = ACTIONS(1380),
    [anon_sym_LT] = ACTIONS(1382),
    [anon_sym_GT] = ACTIONS(1382),
    [anon_sym_GT_GT] = ACTIONS(1380),
    [anon_sym_AMP_GT] = ACTIONS(1382),
    [anon_sym_AMP_GT_GT] = ACTIONS(1380),
    [anon_sym_LT_AMP] = ACTIONS(1380),
    [anon_sym_GT_AMP] = ACTIONS(1380),
    [anon_sym_DOLLAR] = ACTIONS(1382),
    [sym__special_character] = ACTIONS(1380),
    [anon_sym_DQUOTE] = ACTIONS(1380),
    [sym_raw_string] = ACTIONS(1380),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1380),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1380),
    [anon_sym_BQUOTE] = ACTIONS(1380),
    [anon_sym_LT_LPAREN] = ACTIONS(1380),
    [anon_sym_GT_LPAREN] = ACTIONS(1380),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1380),
  },
  [258] = {
    [aux_sym__literal_repeat1] = STATE(610),
    [sym_file_descriptor] = ACTIONS(1384),
    [sym_variable_name] = ACTIONS(1384),
    [anon_sym_LT] = ACTIONS(1386),
    [anon_sym_GT] = ACTIONS(1386),
    [anon_sym_GT_GT] = ACTIONS(1384),
    [anon_sym_AMP_GT] = ACTIONS(1386),
    [anon_sym_AMP_GT_GT] = ACTIONS(1384),
    [anon_sym_LT_AMP] = ACTIONS(1384),
    [anon_sym_GT_AMP] = ACTIONS(1384),
    [anon_sym_DOLLAR] = ACTIONS(1386),
    [sym__special_character] = ACTIONS(1055),
    [anon_sym_DQUOTE] = ACTIONS(1384),
    [sym_raw_string] = ACTIONS(1384),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1384),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1384),
    [anon_sym_BQUOTE] = ACTIONS(1384),
    [anon_sym_LT_LPAREN] = ACTIONS(1384),
    [anon_sym_GT_LPAREN] = ACTIONS(1384),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1384),
  },
  [259] = {
    [aux_sym_concatenation_repeat1] = STATE(718),
    [sym__concat] = ACTIONS(335),
    [anon_sym_RBRACK] = ACTIONS(335),
    [sym__special_character] = ACTIONS(339),
    [sym_comment] = ACTIONS(57),
  },
  [260] = {
    [aux_sym_concatenation_repeat1] = STATE(718),
    [sym__concat] = ACTIONS(1388),
    [anon_sym_RBRACK] = ACTIONS(1390),
    [sym_comment] = ACTIONS(57),
  },
  [261] = {
    [sym__concat] = ACTIONS(1392),
    [anon_sym_RBRACK] = ACTIONS(1390),
    [sym_comment] = ACTIONS(57),
  },
  [262] = {
    [aux_sym__literal_repeat1] = STATE(725),
    [sym__concat] = ACTIONS(1394),
    [anon_sym_RBRACK] = ACTIONS(1396),
    [sym__special_character] = ACTIONS(1398),
    [sym_comment] = ACTIONS(57),
  },
  [263] = {
    [sym__simple_heredoc_body] = ACTIONS(1400),
    [sym__heredoc_body_beginning] = ACTIONS(1400),
    [sym_file_descriptor] = ACTIONS(1400),
    [sym_variable_name] = ACTIONS(1400),
    [ts_builtin_sym_end] = ACTIONS(1400),
    [anon_sym_SEMI] = ACTIONS(1402),
    [anon_sym_PIPE] = ACTIONS(1402),
    [anon_sym_RPAREN] = ACTIONS(1400),
    [anon_sym_SEMI_SEMI] = ACTIONS(1400),
    [anon_sym_PIPE_AMP] = ACTIONS(1400),
    [anon_sym_AMP_AMP] = ACTIONS(1400),
    [anon_sym_PIPE_PIPE] = ACTIONS(1400),
    [anon_sym_LT] = ACTIONS(1402),
    [anon_sym_GT] = ACTIONS(1402),
    [anon_sym_GT_GT] = ACTIONS(1400),
    [anon_sym_AMP_GT] = ACTIONS(1402),
    [anon_sym_AMP_GT_GT] = ACTIONS(1400),
    [anon_sym_LT_AMP] = ACTIONS(1400),
    [anon_sym_GT_AMP] = ACTIONS(1400),
    [anon_sym_LT_LT] = ACTIONS(1402),
    [anon_sym_LT_LT_DASH] = ACTIONS(1400),
    [anon_sym_LT_LT_LT] = ACTIONS(1400),
    [anon_sym_DOLLAR] = ACTIONS(1402),
    [sym__special_character] = ACTIONS(1400),
    [anon_sym_DQUOTE] = ACTIONS(1400),
    [sym_raw_string] = ACTIONS(1400),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1400),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1400),
    [anon_sym_BQUOTE] = ACTIONS(1400),
    [anon_sym_LT_LPAREN] = ACTIONS(1400),
    [anon_sym_GT_LPAREN] = ACTIONS(1400),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1402),
    [anon_sym_LF] = ACTIONS(1400),
    [anon_sym_AMP] = ACTIONS(1402),
  },
  [264] = {
    [sym_concatenation] = STATE(735),
    [sym_string] = STATE(730),
    [sym_simple_expansion] = STATE(730),
    [sym_string_expansion] = STATE(730),
    [sym_expansion] = STATE(730),
    [sym_command_substitution] = STATE(730),
    [sym_process_substitution] = STATE(730),
    [aux_sym_for_statement_repeat1] = STATE(735),
    [aux_sym__literal_repeat1] = STATE(736),
    [anon_sym_RPAREN] = ACTIONS(1404),
    [anon_sym_DOLLAR] = ACTIONS(1406),
    [sym__special_character] = ACTIONS(1408),
    [anon_sym_DQUOTE] = ACTIONS(1410),
    [sym_raw_string] = ACTIONS(1412),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1414),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1416),
    [anon_sym_BQUOTE] = ACTIONS(1418),
    [anon_sym_LT_LPAREN] = ACTIONS(1420),
    [anon_sym_GT_LPAREN] = ACTIONS(1420),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1412),
  },
  [265] = {
    [sym_string] = STATE(738),
    [anon_sym_DASH] = ACTIONS(1422),
    [anon_sym_DOLLAR] = ACTIONS(1422),
    [anon_sym_DQUOTE] = ACTIONS(457),
    [sym_raw_string] = ACTIONS(1424),
    [anon_sym_POUND] = ACTIONS(1422),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1426),
    [anon_sym_STAR] = ACTIONS(1428),
    [anon_sym_AT] = ACTIONS(1428),
    [anon_sym_QMARK] = ACTIONS(1428),
    [anon_sym_0] = ACTIONS(1426),
    [anon_sym__] = ACTIONS(1426),
  },
  [266] = {
    [aux_sym_concatenation_repeat1] = STATE(741),
    [sym__simple_heredoc_body] = ACTIONS(335),
    [sym__heredoc_body_beginning] = ACTIONS(335),
    [sym_file_descriptor] = ACTIONS(335),
    [sym__concat] = ACTIONS(1430),
    [sym_variable_name] = ACTIONS(335),
    [ts_builtin_sym_end] = ACTIONS(335),
    [anon_sym_SEMI] = ACTIONS(339),
    [anon_sym_PIPE] = ACTIONS(339),
    [anon_sym_SEMI_SEMI] = ACTIONS(335),
    [anon_sym_PIPE_AMP] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_PIPE_PIPE] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(339),
    [anon_sym_GT_GT] = ACTIONS(335),
    [anon_sym_AMP_GT] = ACTIONS(339),
    [anon_sym_AMP_GT_GT] = ACTIONS(335),
    [anon_sym_LT_AMP] = ACTIONS(335),
    [anon_sym_GT_AMP] = ACTIONS(335),
    [anon_sym_LT_LT] = ACTIONS(339),
    [anon_sym_LT_LT_DASH] = ACTIONS(335),
    [anon_sym_LT_LT_LT] = ACTIONS(335),
    [anon_sym_DOLLAR] = ACTIONS(339),
    [sym__special_character] = ACTIONS(335),
    [anon_sym_DQUOTE] = ACTIONS(335),
    [sym_raw_string] = ACTIONS(335),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(335),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(335),
    [anon_sym_LT_LPAREN] = ACTIONS(335),
    [anon_sym_GT_LPAREN] = ACTIONS(335),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(339),
    [anon_sym_LF] = ACTIONS(335),
    [anon_sym_AMP] = ACTIONS(339),
  },
  [267] = {
    [sym_simple_expansion] = STATE(204),
    [sym_expansion] = STATE(204),
    [sym_command_substitution] = STATE(204),
    [aux_sym_string_repeat1] = STATE(744),
    [anon_sym_DOLLAR] = ACTIONS(1432),
    [anon_sym_DQUOTE] = ACTIONS(1434),
    [sym__string_content] = ACTIONS(345),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(347),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(329),
  },
  [268] = {
    [aux_sym_concatenation_repeat1] = STATE(741),
    [sym__simple_heredoc_body] = ACTIONS(1400),
    [sym__heredoc_body_beginning] = ACTIONS(1400),
    [sym_file_descriptor] = ACTIONS(1400),
    [sym__concat] = ACTIONS(1430),
    [sym_variable_name] = ACTIONS(1400),
    [ts_builtin_sym_end] = ACTIONS(1400),
    [anon_sym_SEMI] = ACTIONS(1402),
    [anon_sym_PIPE] = ACTIONS(1402),
    [anon_sym_SEMI_SEMI] = ACTIONS(1400),
    [anon_sym_PIPE_AMP] = ACTIONS(1400),
    [anon_sym_AMP_AMP] = ACTIONS(1400),
    [anon_sym_PIPE_PIPE] = ACTIONS(1400),
    [anon_sym_LT] = ACTIONS(1402),
    [anon_sym_GT] = ACTIONS(1402),
    [anon_sym_GT_GT] = ACTIONS(1400),
    [anon_sym_AMP_GT] = ACTIONS(1402),
    [anon_sym_AMP_GT_GT] = ACTIONS(1400),
    [anon_sym_LT_AMP] = ACTIONS(1400),
    [anon_sym_GT_AMP] = ACTIONS(1400),
    [anon_sym_LT_LT] = ACTIONS(1402),
    [anon_sym_LT_LT_DASH] = ACTIONS(1400),
    [anon_sym_LT_LT_LT] = ACTIONS(1400),
    [anon_sym_DOLLAR] = ACTIONS(1402),
    [sym__special_character] = ACTIONS(1400),
    [anon_sym_DQUOTE] = ACTIONS(1400),
    [sym_raw_string] = ACTIONS(1400),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1400),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1400),
    [anon_sym_BQUOTE] = ACTIONS(1400),
    [anon_sym_LT_LPAREN] = ACTIONS(1400),
    [anon_sym_GT_LPAREN] = ACTIONS(1400),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1402),
    [anon_sym_LF] = ACTIONS(1400),
    [anon_sym_AMP] = ACTIONS(1402),
  },
  [269] = {
    [sym_subscript] = STATE(748),
    [sym_variable_name] = ACTIONS(1436),
    [anon_sym_BANG] = ACTIONS(1438),
    [anon_sym_DASH] = ACTIONS(1440),
    [anon_sym_DOLLAR] = ACTIONS(1440),
    [anon_sym_POUND] = ACTIONS(1438),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1442),
    [anon_sym_STAR] = ACTIONS(1444),
    [anon_sym_AT] = ACTIONS(1444),
    [anon_sym_QMARK] = ACTIONS(1444),
    [anon_sym_0] = ACTIONS(1442),
    [anon_sym__] = ACTIONS(1442),
  },
  [270] = {
    [sym__statements] = STATE(749),
    [sym_redirected_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_c_style_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_case_statement] = STATE(105),
    [sym_function_definition] = STATE(105),
    [sym_compound_statement] = STATE(105),
    [sym_subshell] = STATE(105),
    [sym_pipeline] = STATE(105),
    [sym_list] = STATE(105),
    [sym_negated_command] = STATE(105),
    [sym_test_command] = STATE(105),
    [sym_declaration_command] = STATE(105),
    [sym_unset_command] = STATE(105),
    [sym_command] = STATE(105),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(107),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(750),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(109),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(371),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(371),
    [anon_sym_LT_AMP] = ACTIONS(371),
    [anon_sym_GT_AMP] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [271] = {
    [sym__statements] = STATE(751),
    [sym_redirected_statement] = STATE(225),
    [sym_for_statement] = STATE(225),
    [sym_c_style_for_statement] = STATE(225),
    [sym_while_statement] = STATE(225),
    [sym_if_statement] = STATE(225),
    [sym_case_statement] = STATE(225),
    [sym_function_definition] = STATE(225),
    [sym_compound_statement] = STATE(225),
    [sym_subshell] = STATE(225),
    [sym_pipeline] = STATE(225),
    [sym_list] = STATE(225),
    [sym_negated_command] = STATE(225),
    [sym_test_command] = STATE(225),
    [sym_declaration_command] = STATE(225),
    [sym_unset_command] = STATE(225),
    [sym_command] = STATE(225),
    [sym_command_name] = STATE(226),
    [sym_variable_assignment] = STATE(227),
    [sym_subscript] = STATE(228),
    [sym_file_redirect] = STATE(230),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(222),
    [sym_simple_expansion] = STATE(222),
    [sym_string_expansion] = STATE(222),
    [sym_expansion] = STATE(222),
    [sym_command_substitution] = STATE(222),
    [sym_process_substitution] = STATE(222),
    [aux_sym__statements_repeat1] = STATE(229),
    [aux_sym_command_repeat1] = STATE(230),
    [aux_sym__literal_repeat1] = STATE(231),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(375),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_typeset] = ACTIONS(377),
    [anon_sym_export] = ACTIONS(377),
    [anon_sym_readonly] = ACTIONS(377),
    [anon_sym_local] = ACTIONS(377),
    [anon_sym_unset] = ACTIONS(379),
    [anon_sym_unsetenv] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(381),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(383),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(385),
  },
  [272] = {
    [sym__statements] = STATE(752),
    [sym_redirected_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_c_style_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_case_statement] = STATE(105),
    [sym_function_definition] = STATE(105),
    [sym_compound_statement] = STATE(105),
    [sym_subshell] = STATE(105),
    [sym_pipeline] = STATE(105),
    [sym_list] = STATE(105),
    [sym_negated_command] = STATE(105),
    [sym_test_command] = STATE(105),
    [sym_declaration_command] = STATE(105),
    [sym_unset_command] = STATE(105),
    [sym_command] = STATE(105),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(107),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(110),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(109),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [273] = {
    [aux_sym__literal_repeat1] = STATE(754),
    [sym__simple_heredoc_body] = ACTIONS(1446),
    [sym__heredoc_body_beginning] = ACTIONS(1446),
    [sym_file_descriptor] = ACTIONS(1446),
    [sym_variable_name] = ACTIONS(1446),
    [ts_builtin_sym_end] = ACTIONS(1446),
    [anon_sym_SEMI] = ACTIONS(1448),
    [anon_sym_PIPE] = ACTIONS(1448),
    [anon_sym_SEMI_SEMI] = ACTIONS(1446),
    [anon_sym_PIPE_AMP] = ACTIONS(1446),
    [anon_sym_AMP_AMP] = ACTIONS(1446),
    [anon_sym_PIPE_PIPE] = ACTIONS(1446),
    [anon_sym_LT] = ACTIONS(1448),
    [anon_sym_GT] = ACTIONS(1448),
    [anon_sym_GT_GT] = ACTIONS(1446),
    [anon_sym_AMP_GT] = ACTIONS(1448),
    [anon_sym_AMP_GT_GT] = ACTIONS(1446),
    [anon_sym_LT_AMP] = ACTIONS(1446),
    [anon_sym_GT_AMP] = ACTIONS(1446),
    [anon_sym_LT_LT] = ACTIONS(1448),
    [anon_sym_LT_LT_DASH] = ACTIONS(1446),
    [anon_sym_LT_LT_LT] = ACTIONS(1446),
    [anon_sym_DOLLAR] = ACTIONS(1448),
    [sym__special_character] = ACTIONS(1450),
    [anon_sym_DQUOTE] = ACTIONS(1446),
    [sym_raw_string] = ACTIONS(1446),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1446),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1446),
    [anon_sym_BQUOTE] = ACTIONS(1446),
    [anon_sym_LT_LPAREN] = ACTIONS(1446),
    [anon_sym_GT_LPAREN] = ACTIONS(1446),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1448),
    [anon_sym_LF] = ACTIONS(1446),
    [anon_sym_AMP] = ACTIONS(1448),
  },
  [274] = {
    [sym__expression] = STATE(756),
    [sym_binary_expression] = STATE(756),
    [sym_unary_expression] = STATE(756),
    [sym_postfix_expression] = STATE(756),
    [sym_parenthesized_expression] = STATE(756),
    [sym_concatenation] = STATE(756),
    [sym_string] = STATE(280),
    [sym_simple_expansion] = STATE(280),
    [sym_string_expansion] = STATE(280),
    [sym_expansion] = STATE(280),
    [sym_command_substitution] = STATE(280),
    [sym_process_substitution] = STATE(280),
    [aux_sym__literal_repeat1] = STATE(286),
    [anon_sym_SEMI] = ACTIONS(1452),
    [anon_sym_SEMI_SEMI] = ACTIONS(1454),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_BANG] = ACTIONS(475),
    [anon_sym_DOLLAR] = ACTIONS(477),
    [sym__special_character] = ACTIONS(479),
    [anon_sym_DQUOTE] = ACTIONS(481),
    [sym_raw_string] = ACTIONS(483),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(485),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(487),
    [anon_sym_BQUOTE] = ACTIONS(489),
    [anon_sym_LT_LPAREN] = ACTIONS(491),
    [anon_sym_GT_LPAREN] = ACTIONS(491),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(493),
    [sym_test_operator] = ACTIONS(495),
    [anon_sym_LF] = ACTIONS(1454),
    [anon_sym_AMP] = ACTIONS(1454),
  },
  [275] = {
    [sym__expression] = STATE(757),
    [sym_binary_expression] = STATE(757),
    [sym_unary_expression] = STATE(757),
    [sym_postfix_expression] = STATE(757),
    [sym_parenthesized_expression] = STATE(757),
    [sym_concatenation] = STATE(757),
    [sym_string] = STATE(294),
    [sym_simple_expansion] = STATE(294),
    [sym_string_expansion] = STATE(294),
    [sym_expansion] = STATE(294),
    [sym_command_substitution] = STATE(294),
    [sym_process_substitution] = STATE(294),
    [aux_sym__literal_repeat1] = STATE(300),
    [anon_sym_LPAREN] = ACTIONS(503),
    [anon_sym_BANG] = ACTIONS(505),
    [anon_sym_DOLLAR] = ACTIONS(507),
    [sym__special_character] = ACTIONS(509),
    [anon_sym_DQUOTE] = ACTIONS(511),
    [sym_raw_string] = ACTIONS(513),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(515),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(517),
    [anon_sym_BQUOTE] = ACTIONS(519),
    [anon_sym_LT_LPAREN] = ACTIONS(521),
    [anon_sym_GT_LPAREN] = ACTIONS(521),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(523),
    [sym_test_operator] = ACTIONS(525),
  },
  [276] = {
    [sym__expression] = STATE(758),
    [sym_binary_expression] = STATE(758),
    [sym_unary_expression] = STATE(758),
    [sym_postfix_expression] = STATE(758),
    [sym_parenthesized_expression] = STATE(758),
    [sym_concatenation] = STATE(758),
    [sym_string] = STATE(280),
    [sym_simple_expansion] = STATE(280),
    [sym_string_expansion] = STATE(280),
    [sym_expansion] = STATE(280),
    [sym_command_substitution] = STATE(280),
    [sym_process_substitution] = STATE(280),
    [aux_sym__literal_repeat1] = STATE(286),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_BANG] = ACTIONS(475),
    [anon_sym_DOLLAR] = ACTIONS(477),
    [sym__special_character] = ACTIONS(479),
    [anon_sym_DQUOTE] = ACTIONS(481),
    [sym_raw_string] = ACTIONS(483),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(485),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(487),
    [anon_sym_BQUOTE] = ACTIONS(489),
    [anon_sym_LT_LPAREN] = ACTIONS(491),
    [anon_sym_GT_LPAREN] = ACTIONS(491),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(493),
    [sym_test_operator] = ACTIONS(495),
  },
  [277] = {
    [sym_string] = STATE(760),
    [anon_sym_DASH] = ACTIONS(1456),
    [anon_sym_DOLLAR] = ACTIONS(1456),
    [anon_sym_DQUOTE] = ACTIONS(481),
    [sym_raw_string] = ACTIONS(1458),
    [anon_sym_POUND] = ACTIONS(1456),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1460),
    [anon_sym_STAR] = ACTIONS(1462),
    [anon_sym_AT] = ACTIONS(1462),
    [anon_sym_QMARK] = ACTIONS(1462),
    [anon_sym_0] = ACTIONS(1460),
    [anon_sym__] = ACTIONS(1460),
  },
  [278] = {
    [aux_sym_concatenation_repeat1] = STATE(763),
    [sym__concat] = ACTIONS(1464),
    [anon_sym_SEMI] = ACTIONS(339),
    [anon_sym_SEMI_SEMI] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_PIPE_PIPE] = ACTIONS(335),
    [anon_sym_EQ_TILDE] = ACTIONS(335),
    [anon_sym_EQ_EQ] = ACTIONS(335),
    [anon_sym_EQ] = ACTIONS(339),
    [anon_sym_PLUS_EQ] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(335),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_DASH_EQ] = ACTIONS(335),
    [anon_sym_LT_EQ] = ACTIONS(335),
    [anon_sym_GT_EQ] = ACTIONS(335),
    [anon_sym_PLUS_PLUS] = ACTIONS(335),
    [anon_sym_DASH_DASH] = ACTIONS(335),
    [sym__special_character] = ACTIONS(335),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(335),
    [anon_sym_LF] = ACTIONS(335),
    [anon_sym_AMP] = ACTIONS(339),
  },
  [279] = {
    [sym_simple_expansion] = STATE(204),
    [sym_expansion] = STATE(204),
    [sym_command_substitution] = STATE(204),
    [aux_sym_string_repeat1] = STATE(766),
    [anon_sym_DOLLAR] = ACTIONS(1466),
    [anon_sym_DQUOTE] = ACTIONS(1468),
    [sym__string_content] = ACTIONS(345),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(347),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(329),
  },
  [280] = {
    [aux_sym_concatenation_repeat1] = STATE(763),
    [sym__concat] = ACTIONS(1464),
    [anon_sym_SEMI] = ACTIONS(543),
    [anon_sym_SEMI_SEMI] = ACTIONS(541),
    [anon_sym_AMP_AMP] = ACTIONS(541),
    [anon_sym_PIPE_PIPE] = ACTIONS(541),
    [anon_sym_EQ_TILDE] = ACTIONS(541),
    [anon_sym_EQ_EQ] = ACTIONS(541),
    [anon_sym_EQ] = ACTIONS(543),
    [anon_sym_PLUS_EQ] = ACTIONS(541),
    [anon_sym_LT] = ACTIONS(543),
    [anon_sym_GT] = ACTIONS(543),
    [anon_sym_BANG_EQ] = ACTIONS(541),
    [anon_sym_PLUS] = ACTIONS(543),
    [anon_sym_DASH] = ACTIONS(543),
    [anon_sym_DASH_EQ] = ACTIONS(541),
    [anon_sym_LT_EQ] = ACTIONS(541),
    [anon_sym_GT_EQ] = ACTIONS(541),
    [anon_sym_PLUS_PLUS] = ACTIONS(541),
    [anon_sym_DASH_DASH] = ACTIONS(541),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(541),
    [anon_sym_LF] = ACTIONS(541),
    [anon_sym_AMP] = ACTIONS(543),
  },
  [281] = {
    [sym_subscript] = STATE(770),
    [sym_variable_name] = ACTIONS(1470),
    [anon_sym_BANG] = ACTIONS(1472),
    [anon_sym_DASH] = ACTIONS(1474),
    [anon_sym_DOLLAR] = ACTIONS(1474),
    [anon_sym_POUND] = ACTIONS(1472),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1476),
    [anon_sym_STAR] = ACTIONS(1478),
    [anon_sym_AT] = ACTIONS(1478),
    [anon_sym_QMARK] = ACTIONS(1478),
    [anon_sym_0] = ACTIONS(1476),
    [anon_sym__] = ACTIONS(1476),
  },
  [282] = {
    [sym__statements] = STATE(771),
    [sym_redirected_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_c_style_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_case_statement] = STATE(105),
    [sym_function_definition] = STATE(105),
    [sym_compound_statement] = STATE(105),
    [sym_subshell] = STATE(105),
    [sym_pipeline] = STATE(105),
    [sym_list] = STATE(105),
    [sym_negated_command] = STATE(105),
    [sym_test_command] = STATE(105),
    [sym_declaration_command] = STATE(105),
    [sym_unset_command] = STATE(105),
    [sym_command] = STATE(105),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(107),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(772),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(109),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(371),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(371),
    [anon_sym_LT_AMP] = ACTIONS(371),
    [anon_sym_GT_AMP] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [283] = {
    [sym__statements] = STATE(773),
    [sym_redirected_statement] = STATE(225),
    [sym_for_statement] = STATE(225),
    [sym_c_style_for_statement] = STATE(225),
    [sym_while_statement] = STATE(225),
    [sym_if_statement] = STATE(225),
    [sym_case_statement] = STATE(225),
    [sym_function_definition] = STATE(225),
    [sym_compound_statement] = STATE(225),
    [sym_subshell] = STATE(225),
    [sym_pipeline] = STATE(225),
    [sym_list] = STATE(225),
    [sym_negated_command] = STATE(225),
    [sym_test_command] = STATE(225),
    [sym_declaration_command] = STATE(225),
    [sym_unset_command] = STATE(225),
    [sym_command] = STATE(225),
    [sym_command_name] = STATE(226),
    [sym_variable_assignment] = STATE(227),
    [sym_subscript] = STATE(228),
    [sym_file_redirect] = STATE(230),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(222),
    [sym_simple_expansion] = STATE(222),
    [sym_string_expansion] = STATE(222),
    [sym_expansion] = STATE(222),
    [sym_command_substitution] = STATE(222),
    [sym_process_substitution] = STATE(222),
    [aux_sym__statements_repeat1] = STATE(229),
    [aux_sym_command_repeat1] = STATE(230),
    [aux_sym__literal_repeat1] = STATE(231),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(375),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_typeset] = ACTIONS(377),
    [anon_sym_export] = ACTIONS(377),
    [anon_sym_readonly] = ACTIONS(377),
    [anon_sym_local] = ACTIONS(377),
    [anon_sym_unset] = ACTIONS(379),
    [anon_sym_unsetenv] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(381),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(383),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(385),
  },
  [284] = {
    [sym__statements] = STATE(774),
    [sym_redirected_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_c_style_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_case_statement] = STATE(105),
    [sym_function_definition] = STATE(105),
    [sym_compound_statement] = STATE(105),
    [sym_subshell] = STATE(105),
    [sym_pipeline] = STATE(105),
    [sym_list] = STATE(105),
    [sym_negated_command] = STATE(105),
    [sym_test_command] = STATE(105),
    [sym_declaration_command] = STATE(105),
    [sym_unset_command] = STATE(105),
    [sym_command] = STATE(105),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(107),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(110),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(109),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [285] = {
    [anon_sym_SEMI] = ACTIONS(1480),
    [anon_sym_SEMI_SEMI] = ACTIONS(1482),
    [anon_sym_AMP_AMP] = ACTIONS(1484),
    [anon_sym_PIPE_PIPE] = ACTIONS(1484),
    [anon_sym_EQ_TILDE] = ACTIONS(1486),
    [anon_sym_EQ_EQ] = ACTIONS(1486),
    [anon_sym_EQ] = ACTIONS(1488),
    [anon_sym_PLUS_EQ] = ACTIONS(1484),
    [anon_sym_LT] = ACTIONS(1488),
    [anon_sym_GT] = ACTIONS(1488),
    [anon_sym_BANG_EQ] = ACTIONS(1484),
    [anon_sym_PLUS] = ACTIONS(1488),
    [anon_sym_DASH] = ACTIONS(1488),
    [anon_sym_DASH_EQ] = ACTIONS(1484),
    [anon_sym_LT_EQ] = ACTIONS(1484),
    [anon_sym_GT_EQ] = ACTIONS(1484),
    [anon_sym_PLUS_PLUS] = ACTIONS(1490),
    [anon_sym_DASH_DASH] = ACTIONS(1490),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(1484),
    [anon_sym_LF] = ACTIONS(1482),
    [anon_sym_AMP] = ACTIONS(1480),
  },
  [286] = {
    [aux_sym__literal_repeat1] = STATE(780),
    [anon_sym_SEMI] = ACTIONS(567),
    [anon_sym_SEMI_SEMI] = ACTIONS(565),
    [anon_sym_AMP_AMP] = ACTIONS(565),
    [anon_sym_PIPE_PIPE] = ACTIONS(565),
    [anon_sym_EQ_TILDE] = ACTIONS(565),
    [anon_sym_EQ_EQ] = ACTIONS(565),
    [anon_sym_EQ] = ACTIONS(567),
    [anon_sym_PLUS_EQ] = ACTIONS(565),
    [anon_sym_LT] = ACTIONS(567),
    [anon_sym_GT] = ACTIONS(567),
    [anon_sym_BANG_EQ] = ACTIONS(565),
    [anon_sym_PLUS] = ACTIONS(567),
    [anon_sym_DASH] = ACTIONS(567),
    [anon_sym_DASH_EQ] = ACTIONS(565),
    [anon_sym_LT_EQ] = ACTIONS(565),
    [anon_sym_GT_EQ] = ACTIONS(565),
    [anon_sym_PLUS_PLUS] = ACTIONS(565),
    [anon_sym_DASH_DASH] = ACTIONS(565),
    [sym__special_character] = ACTIONS(1492),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(565),
    [anon_sym_LF] = ACTIONS(565),
    [anon_sym_AMP] = ACTIONS(567),
  },
  [287] = {
    [sym_concatenation] = STATE(789),
    [sym_string] = STATE(784),
    [sym_simple_expansion] = STATE(784),
    [sym_string_expansion] = STATE(784),
    [sym_expansion] = STATE(784),
    [sym_command_substitution] = STATE(784),
    [sym_process_substitution] = STATE(784),
    [aux_sym_for_statement_repeat1] = STATE(789),
    [aux_sym__literal_repeat1] = STATE(790),
    [anon_sym_DOLLAR] = ACTIONS(1494),
    [sym__special_character] = ACTIONS(1496),
    [anon_sym_DQUOTE] = ACTIONS(1498),
    [sym_raw_string] = ACTIONS(1500),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1502),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1504),
    [anon_sym_BQUOTE] = ACTIONS(1506),
    [anon_sym_LT_LPAREN] = ACTIONS(1508),
    [anon_sym_GT_LPAREN] = ACTIONS(1508),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1500),
  },
  [288] = {
    [sym_do_group] = STATE(791),
    [anon_sym_do] = ACTIONS(651),
    [sym_comment] = ACTIONS(57),
  },
  [289] = {
    [sym__expression] = STATE(792),
    [sym_binary_expression] = STATE(792),
    [sym_unary_expression] = STATE(792),
    [sym_postfix_expression] = STATE(792),
    [sym_parenthesized_expression] = STATE(792),
    [sym_concatenation] = STATE(792),
    [sym_string] = STATE(294),
    [sym_simple_expansion] = STATE(294),
    [sym_string_expansion] = STATE(294),
    [sym_expansion] = STATE(294),
    [sym_command_substitution] = STATE(294),
    [sym_process_substitution] = STATE(294),
    [aux_sym__literal_repeat1] = STATE(300),
    [anon_sym_LPAREN] = ACTIONS(503),
    [anon_sym_BANG] = ACTIONS(505),
    [anon_sym_DOLLAR] = ACTIONS(507),
    [sym__special_character] = ACTIONS(509),
    [anon_sym_DQUOTE] = ACTIONS(511),
    [sym_raw_string] = ACTIONS(513),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(515),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(517),
    [anon_sym_BQUOTE] = ACTIONS(519),
    [anon_sym_LT_LPAREN] = ACTIONS(521),
    [anon_sym_GT_LPAREN] = ACTIONS(521),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(523),
    [sym_test_operator] = ACTIONS(525),
  },
  [290] = {
    [sym__expression] = STATE(793),
    [sym_binary_expression] = STATE(793),
    [sym_unary_expression] = STATE(793),
    [sym_postfix_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(793),
    [sym_concatenation] = STATE(793),
    [sym_string] = STATE(294),
    [sym_simple_expansion] = STATE(294),
    [sym_string_expansion] = STATE(294),
    [sym_expansion] = STATE(294),
    [sym_command_substitution] = STATE(294),
    [sym_process_substitution] = STATE(294),
    [aux_sym__literal_repeat1] = STATE(300),
    [anon_sym_LPAREN] = ACTIONS(503),
    [anon_sym_BANG] = ACTIONS(505),
    [anon_sym_DOLLAR] = ACTIONS(507),
    [sym__special_character] = ACTIONS(509),
    [anon_sym_DQUOTE] = ACTIONS(511),
    [sym_raw_string] = ACTIONS(513),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(515),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(517),
    [anon_sym_BQUOTE] = ACTIONS(519),
    [anon_sym_LT_LPAREN] = ACTIONS(521),
    [anon_sym_GT_LPAREN] = ACTIONS(521),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(523),
    [sym_test_operator] = ACTIONS(525),
  },
  [291] = {
    [sym_string] = STATE(795),
    [anon_sym_DASH] = ACTIONS(1510),
    [anon_sym_DOLLAR] = ACTIONS(1510),
    [anon_sym_DQUOTE] = ACTIONS(511),
    [sym_raw_string] = ACTIONS(1512),
    [anon_sym_POUND] = ACTIONS(1510),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1514),
    [anon_sym_STAR] = ACTIONS(1516),
    [anon_sym_AT] = ACTIONS(1516),
    [anon_sym_QMARK] = ACTIONS(1516),
    [anon_sym_0] = ACTIONS(1514),
    [anon_sym__] = ACTIONS(1514),
  },
  [292] = {
    [aux_sym_concatenation_repeat1] = STATE(798),
    [sym__concat] = ACTIONS(1518),
    [anon_sym_RPAREN] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_PIPE_PIPE] = ACTIONS(335),
    [anon_sym_EQ_TILDE] = ACTIONS(335),
    [anon_sym_EQ_EQ] = ACTIONS(335),
    [anon_sym_EQ] = ACTIONS(339),
    [anon_sym_PLUS_EQ] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(335),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_DASH_EQ] = ACTIONS(335),
    [anon_sym_LT_EQ] = ACTIONS(335),
    [anon_sym_GT_EQ] = ACTIONS(335),
    [anon_sym_PLUS_PLUS] = ACTIONS(335),
    [anon_sym_DASH_DASH] = ACTIONS(335),
    [sym__special_character] = ACTIONS(335),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(335),
  },
  [293] = {
    [sym_simple_expansion] = STATE(204),
    [sym_expansion] = STATE(204),
    [sym_command_substitution] = STATE(204),
    [aux_sym_string_repeat1] = STATE(801),
    [anon_sym_DOLLAR] = ACTIONS(1520),
    [anon_sym_DQUOTE] = ACTIONS(1522),
    [sym__string_content] = ACTIONS(345),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(347),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(329),
  },
  [294] = {
    [aux_sym_concatenation_repeat1] = STATE(798),
    [sym__concat] = ACTIONS(1518),
    [anon_sym_RPAREN] = ACTIONS(541),
    [anon_sym_AMP_AMP] = ACTIONS(541),
    [anon_sym_PIPE_PIPE] = ACTIONS(541),
    [anon_sym_EQ_TILDE] = ACTIONS(541),
    [anon_sym_EQ_EQ] = ACTIONS(541),
    [anon_sym_EQ] = ACTIONS(543),
    [anon_sym_PLUS_EQ] = ACTIONS(541),
    [anon_sym_LT] = ACTIONS(543),
    [anon_sym_GT] = ACTIONS(543),
    [anon_sym_BANG_EQ] = ACTIONS(541),
    [anon_sym_PLUS] = ACTIONS(543),
    [anon_sym_DASH] = ACTIONS(543),
    [anon_sym_DASH_EQ] = ACTIONS(541),
    [anon_sym_LT_EQ] = ACTIONS(541),
    [anon_sym_GT_EQ] = ACTIONS(541),
    [anon_sym_PLUS_PLUS] = ACTIONS(541),
    [anon_sym_DASH_DASH] = ACTIONS(541),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(541),
  },
  [295] = {
    [sym_subscript] = STATE(805),
    [sym_variable_name] = ACTIONS(1524),
    [anon_sym_BANG] = ACTIONS(1526),
    [anon_sym_DASH] = ACTIONS(1528),
    [anon_sym_DOLLAR] = ACTIONS(1528),
    [anon_sym_POUND] = ACTIONS(1526),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1530),
    [anon_sym_STAR] = ACTIONS(1532),
    [anon_sym_AT] = ACTIONS(1532),
    [anon_sym_QMARK] = ACTIONS(1532),
    [anon_sym_0] = ACTIONS(1530),
    [anon_sym__] = ACTIONS(1530),
  },
  [296] = {
    [sym__statements] = STATE(806),
    [sym_redirected_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_c_style_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_case_statement] = STATE(105),
    [sym_function_definition] = STATE(105),
    [sym_compound_statement] = STATE(105),
    [sym_subshell] = STATE(105),
    [sym_pipeline] = STATE(105),
    [sym_list] = STATE(105),
    [sym_negated_command] = STATE(105),
    [sym_test_command] = STATE(105),
    [sym_declaration_command] = STATE(105),
    [sym_unset_command] = STATE(105),
    [sym_command] = STATE(105),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(107),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(807),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(109),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(371),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(371),
    [anon_sym_LT_AMP] = ACTIONS(371),
    [anon_sym_GT_AMP] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [297] = {
    [sym__statements] = STATE(808),
    [sym_redirected_statement] = STATE(225),
    [sym_for_statement] = STATE(225),
    [sym_c_style_for_statement] = STATE(225),
    [sym_while_statement] = STATE(225),
    [sym_if_statement] = STATE(225),
    [sym_case_statement] = STATE(225),
    [sym_function_definition] = STATE(225),
    [sym_compound_statement] = STATE(225),
    [sym_subshell] = STATE(225),
    [sym_pipeline] = STATE(225),
    [sym_list] = STATE(225),
    [sym_negated_command] = STATE(225),
    [sym_test_command] = STATE(225),
    [sym_declaration_command] = STATE(225),
    [sym_unset_command] = STATE(225),
    [sym_command] = STATE(225),
    [sym_command_name] = STATE(226),
    [sym_variable_assignment] = STATE(227),
    [sym_subscript] = STATE(228),
    [sym_file_redirect] = STATE(230),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(222),
    [sym_simple_expansion] = STATE(222),
    [sym_string_expansion] = STATE(222),
    [sym_expansion] = STATE(222),
    [sym_command_substitution] = STATE(222),
    [sym_process_substitution] = STATE(222),
    [aux_sym__statements_repeat1] = STATE(229),
    [aux_sym_command_repeat1] = STATE(230),
    [aux_sym__literal_repeat1] = STATE(231),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(375),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_typeset] = ACTIONS(377),
    [anon_sym_export] = ACTIONS(377),
    [anon_sym_readonly] = ACTIONS(377),
    [anon_sym_local] = ACTIONS(377),
    [anon_sym_unset] = ACTIONS(379),
    [anon_sym_unsetenv] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(381),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(383),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(385),
  },
  [298] = {
    [sym__statements] = STATE(809),
    [sym_redirected_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_c_style_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_case_statement] = STATE(105),
    [sym_function_definition] = STATE(105),
    [sym_compound_statement] = STATE(105),
    [sym_subshell] = STATE(105),
    [sym_pipeline] = STATE(105),
    [sym_list] = STATE(105),
    [sym_negated_command] = STATE(105),
    [sym_test_command] = STATE(105),
    [sym_declaration_command] = STATE(105),
    [sym_unset_command] = STATE(105),
    [sym_command] = STATE(105),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(107),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(110),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(109),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [299] = {
    [anon_sym_RPAREN] = ACTIONS(1534),
    [anon_sym_AMP_AMP] = ACTIONS(1536),
    [anon_sym_PIPE_PIPE] = ACTIONS(1536),
    [anon_sym_EQ_TILDE] = ACTIONS(1538),
    [anon_sym_EQ_EQ] = ACTIONS(1538),
    [anon_sym_EQ] = ACTIONS(1540),
    [anon_sym_PLUS_EQ] = ACTIONS(1536),
    [anon_sym_LT] = ACTIONS(1540),
    [anon_sym_GT] = ACTIONS(1540),
    [anon_sym_BANG_EQ] = ACTIONS(1536),
    [anon_sym_PLUS] = ACTIONS(1540),
    [anon_sym_DASH] = ACTIONS(1540),
    [anon_sym_DASH_EQ] = ACTIONS(1536),
    [anon_sym_LT_EQ] = ACTIONS(1536),
    [anon_sym_GT_EQ] = ACTIONS(1536),
    [anon_sym_PLUS_PLUS] = ACTIONS(1542),
    [anon_sym_DASH_DASH] = ACTIONS(1542),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(1536),
  },
  [300] = {
    [aux_sym__literal_repeat1] = STATE(815),
    [anon_sym_RPAREN] = ACTIONS(565),
    [anon_sym_AMP_AMP] = ACTIONS(565),
    [anon_sym_PIPE_PIPE] = ACTIONS(565),
    [anon_sym_EQ_TILDE] = ACTIONS(565),
    [anon_sym_EQ_EQ] = ACTIONS(565),
    [anon_sym_EQ] = ACTIONS(567),
    [anon_sym_PLUS_EQ] = ACTIONS(565),
    [anon_sym_LT] = ACTIONS(567),
    [anon_sym_GT] = ACTIONS(567),
    [anon_sym_BANG_EQ] = ACTIONS(565),
    [anon_sym_PLUS] = ACTIONS(567),
    [anon_sym_DASH] = ACTIONS(567),
    [anon_sym_DASH_EQ] = ACTIONS(565),
    [anon_sym_LT_EQ] = ACTIONS(565),
    [anon_sym_GT_EQ] = ACTIONS(565),
    [anon_sym_PLUS_PLUS] = ACTIONS(565),
    [anon_sym_DASH_DASH] = ACTIONS(565),
    [sym__special_character] = ACTIONS(1544),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(565),
  },
  [301] = {
    [anon_sym_RPAREN_RPAREN] = ACTIONS(1546),
    [anon_sym_AMP_AMP] = ACTIONS(557),
    [anon_sym_PIPE_PIPE] = ACTIONS(557),
    [anon_sym_EQ_TILDE] = ACTIONS(559),
    [anon_sym_EQ_EQ] = ACTIONS(559),
    [anon_sym_EQ] = ACTIONS(561),
    [anon_sym_PLUS_EQ] = ACTIONS(557),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_GT] = ACTIONS(561),
    [anon_sym_BANG_EQ] = ACTIONS(557),
    [anon_sym_PLUS] = ACTIONS(561),
    [anon_sym_DASH] = ACTIONS(561),
    [anon_sym_DASH_EQ] = ACTIONS(557),
    [anon_sym_LT_EQ] = ACTIONS(557),
    [anon_sym_GT_EQ] = ACTIONS(557),
    [anon_sym_PLUS_PLUS] = ACTIONS(563),
    [anon_sym_DASH_DASH] = ACTIONS(563),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(557),
  },
  [302] = {
    [sym__concat] = ACTIONS(1057),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(1057),
    [anon_sym_AMP_AMP] = ACTIONS(1057),
    [anon_sym_PIPE_PIPE] = ACTIONS(1057),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(1057),
    [anon_sym_EQ_TILDE] = ACTIONS(1057),
    [anon_sym_EQ_EQ] = ACTIONS(1057),
    [anon_sym_EQ] = ACTIONS(1059),
    [anon_sym_PLUS_EQ] = ACTIONS(1057),
    [anon_sym_LT] = ACTIONS(1059),
    [anon_sym_GT] = ACTIONS(1059),
    [anon_sym_BANG_EQ] = ACTIONS(1057),
    [anon_sym_PLUS] = ACTIONS(1059),
    [anon_sym_DASH] = ACTIONS(1059),
    [anon_sym_DASH_EQ] = ACTIONS(1057),
    [anon_sym_LT_EQ] = ACTIONS(1057),
    [anon_sym_GT_EQ] = ACTIONS(1057),
    [anon_sym_PLUS_PLUS] = ACTIONS(1057),
    [anon_sym_DASH_DASH] = ACTIONS(1057),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(1057),
  },
  [303] = {
    [sym__concat] = ACTIONS(1061),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(1061),
    [anon_sym_AMP_AMP] = ACTIONS(1061),
    [anon_sym_PIPE_PIPE] = ACTIONS(1061),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(1061),
    [anon_sym_EQ_TILDE] = ACTIONS(1061),
    [anon_sym_EQ_EQ] = ACTIONS(1061),
    [anon_sym_EQ] = ACTIONS(1063),
    [anon_sym_PLUS_EQ] = ACTIONS(1061),
    [anon_sym_LT] = ACTIONS(1063),
    [anon_sym_GT] = ACTIONS(1063),
    [anon_sym_BANG_EQ] = ACTIONS(1061),
    [anon_sym_PLUS] = ACTIONS(1063),
    [anon_sym_DASH] = ACTIONS(1063),
    [anon_sym_DASH_EQ] = ACTIONS(1061),
    [anon_sym_LT_EQ] = ACTIONS(1061),
    [anon_sym_GT_EQ] = ACTIONS(1061),
    [anon_sym_PLUS_PLUS] = ACTIONS(1061),
    [anon_sym_DASH_DASH] = ACTIONS(1061),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(1061),
  },
  [304] = {
    [sym__concat] = ACTIONS(1065),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(1065),
    [anon_sym_AMP_AMP] = ACTIONS(1065),
    [anon_sym_PIPE_PIPE] = ACTIONS(1065),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(1065),
    [anon_sym_EQ_TILDE] = ACTIONS(1065),
    [anon_sym_EQ_EQ] = ACTIONS(1065),
    [anon_sym_EQ] = ACTIONS(1067),
    [anon_sym_PLUS_EQ] = ACTIONS(1065),
    [anon_sym_LT] = ACTIONS(1067),
    [anon_sym_GT] = ACTIONS(1067),
    [anon_sym_BANG_EQ] = ACTIONS(1065),
    [anon_sym_PLUS] = ACTIONS(1067),
    [anon_sym_DASH] = ACTIONS(1067),
    [anon_sym_DASH_EQ] = ACTIONS(1065),
    [anon_sym_LT_EQ] = ACTIONS(1065),
    [anon_sym_GT_EQ] = ACTIONS(1065),
    [anon_sym_PLUS_PLUS] = ACTIONS(1065),
    [anon_sym_DASH_DASH] = ACTIONS(1065),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(1065),
  },
  [305] = {
    [sym_string] = STATE(816),
    [sym_simple_expansion] = STATE(816),
    [sym_string_expansion] = STATE(816),
    [sym_expansion] = STATE(816),
    [sym_command_substitution] = STATE(816),
    [sym_process_substitution] = STATE(816),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [sym__special_character] = ACTIONS(1548),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [sym_raw_string] = ACTIONS(1548),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(85),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [anon_sym_LT_LPAREN] = ACTIONS(91),
    [anon_sym_GT_LPAREN] = ACTIONS(91),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1548),
  },
  [306] = {
    [aux_sym_concatenation_repeat1] = STATE(818),
    [sym__concat] = ACTIONS(1550),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(1071),
    [anon_sym_AMP_AMP] = ACTIONS(1071),
    [anon_sym_PIPE_PIPE] = ACTIONS(1071),
    [anon_sym_EQ_TILDE] = ACTIONS(1071),
    [anon_sym_EQ_EQ] = ACTIONS(1071),
    [anon_sym_EQ] = ACTIONS(1075),
    [anon_sym_PLUS_EQ] = ACTIONS(1071),
    [anon_sym_LT] = ACTIONS(1075),
    [anon_sym_GT] = ACTIONS(1075),
    [anon_sym_BANG_EQ] = ACTIONS(1071),
    [anon_sym_PLUS] = ACTIONS(1075),
    [anon_sym_DASH] = ACTIONS(1075),
    [anon_sym_DASH_EQ] = ACTIONS(1071),
    [anon_sym_LT_EQ] = ACTIONS(1071),
    [anon_sym_GT_EQ] = ACTIONS(1071),
    [anon_sym_PLUS_PLUS] = ACTIONS(1071),
    [anon_sym_DASH_DASH] = ACTIONS(1071),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(1071),
  },
  [307] = {
    [anon_sym_DASH] = ACTIONS(1077),
    [anon_sym_DOLLAR] = ACTIONS(1079),
    [anon_sym_DQUOTE] = ACTIONS(1552),
    [sym__string_content] = ACTIONS(1083),
    [anon_sym_POUND] = ACTIONS(1077),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1085),
    [anon_sym_STAR] = ACTIONS(1087),
    [anon_sym_AT] = ACTIONS(1087),
    [anon_sym_QMARK] = ACTIONS(1087),
    [anon_sym_0] = ACTIONS(1085),
    [anon_sym__] = ACTIONS(1085),
  },
  [308] = {
    [sym__concat] = ACTIONS(1089),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(1089),
    [anon_sym_AMP_AMP] = ACTIONS(1089),
    [anon_sym_PIPE_PIPE] = ACTIONS(1089),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(1089),
    [anon_sym_EQ_TILDE] = ACTIONS(1089),
    [anon_sym_EQ_EQ] = ACTIONS(1089),
    [anon_sym_EQ] = ACTIONS(1091),
    [anon_sym_PLUS_EQ] = ACTIONS(1089),
    [anon_sym_LT] = ACTIONS(1091),
    [anon_sym_GT] = ACTIONS(1091),
    [anon_sym_BANG_EQ] = ACTIONS(1089),
    [anon_sym_PLUS] = ACTIONS(1091),
    [anon_sym_DASH] = ACTIONS(1091),
    [anon_sym_DASH_EQ] = ACTIONS(1089),
    [anon_sym_LT_EQ] = ACTIONS(1089),
    [anon_sym_GT_EQ] = ACTIONS(1089),
    [anon_sym_PLUS_PLUS] = ACTIONS(1089),
    [anon_sym_DASH_DASH] = ACTIONS(1089),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(1089),
  },
  [309] = {
    [sym_simple_expansion] = STATE(204),
    [sym_expansion] = STATE(204),
    [sym_command_substitution] = STATE(204),
    [aux_sym_string_repeat1] = STATE(627),
    [anon_sym_DOLLAR] = ACTIONS(1554),
    [anon_sym_DQUOTE] = ACTIONS(1552),
    [sym__string_content] = ACTIONS(345),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(347),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(329),
  },
  [310] = {
    [anon_sym_LBRACK] = ACTIONS(1111),
    [anon_sym_EQ] = ACTIONS(1556),
    [sym_comment] = ACTIONS(57),
  },
  [311] = {
    [sym_subscript] = STATE(824),
    [sym_variable_name] = ACTIONS(1558),
    [anon_sym_DASH] = ACTIONS(1560),
    [anon_sym_DOLLAR] = ACTIONS(1560),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1562),
    [anon_sym_STAR] = ACTIONS(1564),
    [anon_sym_AT] = ACTIONS(1564),
    [anon_sym_QMARK] = ACTIONS(1564),
    [anon_sym_0] = ACTIONS(1562),
    [anon_sym__] = ACTIONS(1562),
  },
  [312] = {
    [sym_concatenation] = STATE(827),
    [sym_string] = STATE(637),
    [sym_simple_expansion] = STATE(637),
    [sym_string_expansion] = STATE(637),
    [sym_expansion] = STATE(637),
    [sym_command_substitution] = STATE(637),
    [sym_process_substitution] = STATE(637),
    [aux_sym__literal_repeat1] = STATE(643),
    [aux_sym_expansion_repeat1] = STATE(827),
    [anon_sym_RBRACE] = ACTIONS(1566),
    [anon_sym_EQ] = ACTIONS(1568),
    [anon_sym_DASH] = ACTIONS(1568),
    [anon_sym_DOLLAR] = ACTIONS(1127),
    [sym__special_character] = ACTIONS(1129),
    [anon_sym_DQUOTE] = ACTIONS(1131),
    [sym_raw_string] = ACTIONS(1133),
    [anon_sym_POUND] = ACTIONS(1570),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1137),
    [anon_sym_SLASH] = ACTIONS(1572),
    [anon_sym_COLON] = ACTIONS(1568),
    [anon_sym_COLON_QMARK] = ACTIONS(1568),
    [anon_sym_COLON_DASH] = ACTIONS(1568),
    [anon_sym_PERCENT] = ACTIONS(1568),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1141),
    [anon_sym_BQUOTE] = ACTIONS(1143),
    [anon_sym_LT_LPAREN] = ACTIONS(1145),
    [anon_sym_GT_LPAREN] = ACTIONS(1145),
    [sym_comment] = ACTIONS(329),
    [sym_word] = ACTIONS(1147),
  },
  [313] = {
    [sym_concatenation] = STATE(830),
    [sym_string] = STATE(637),
    [sym_simple_expansion] = STATE(637),
    [sym_string_expansion] = STATE(637),
    [sym_expansion] = STATE(637),
    [sym_command_substitution] = STATE(637),
    [sym_process_substitution] = STATE(637),
    [aux_sym__literal_repeat1] = STATE(643),
    [aux_sym_expansion_repeat1] = STATE(830),
    [anon_sym_RBRACE] = ACTIONS(1574),
    [anon_sym_EQ] = ACTIONS(1576),
    [anon_sym_DASH] = ACTIONS(1576),
    [anon_sym_DOLLAR] = ACTIONS(1127),
    [sym__special_character] = ACTIONS(1129),
    [anon_sym_DQUOTE] = ACTIONS(1131),
    [sym_raw_string] = ACTIONS(1133),
    [anon_sym_POUND] = ACTIONS(1578),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1137),
    [anon_sym_SLASH] = ACTIONS(1580),
    [anon_sym_COLON] = ACTIONS(1576),
    [anon_sym_COLON_QMARK] = ACTIONS(1576),
    [anon_sym_COLON_DASH] = ACTIONS(1576),
    [anon_sym_PERCENT] = ACTIONS(1576),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1141),
    [anon_sym_BQUOTE] = ACTIONS(1143),
    [anon_sym_LT_LPAREN] = ACTIONS(1145),
    [anon_sym_GT_LPAREN] = ACTIONS(1145),
    [sym_comment] = ACTIONS(329),
    [sym_word] = ACTIONS(1147),
  },
  [314] = {
    [anon_sym_RPAREN] = ACTIONS(1582),
    [sym_comment] = ACTIONS(57),
  },
  [315] = {
    [sym_file_descriptor] = ACTIONS(433),
    [sym_variable_name] = ACTIONS(433),
    [anon_sym_RPAREN] = ACTIONS(1582),
    [anon_sym_LT] = ACTIONS(435),
    [anon_sym_GT] = ACTIONS(435),
    [anon_sym_GT_GT] = ACTIONS(433),
    [anon_sym_AMP_GT] = ACTIONS(435),
    [anon_sym_AMP_GT_GT] = ACTIONS(433),
    [anon_sym_LT_AMP] = ACTIONS(433),
    [anon_sym_GT_AMP] = ACTIONS(433),
    [anon_sym_DOLLAR] = ACTIONS(435),
    [sym__special_character] = ACTIONS(433),
    [anon_sym_DQUOTE] = ACTIONS(433),
    [sym_raw_string] = ACTIONS(433),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(433),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(433),
    [anon_sym_BQUOTE] = ACTIONS(433),
    [anon_sym_LT_LPAREN] = ACTIONS(433),
    [anon_sym_GT_LPAREN] = ACTIONS(433),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(433),
  },
  [316] = {
    [anon_sym_BQUOTE] = ACTIONS(1582),
    [sym_comment] = ACTIONS(57),
  },
  [317] = {
    [anon_sym_RPAREN] = ACTIONS(1584),
    [sym_comment] = ACTIONS(57),
  },
  [318] = {
    [sym__simple_heredoc_body] = ACTIONS(1586),
    [sym__heredoc_body_beginning] = ACTIONS(1586),
    [sym_file_descriptor] = ACTIONS(1586),
    [ts_builtin_sym_end] = ACTIONS(1586),
    [anon_sym_SEMI] = ACTIONS(1588),
    [anon_sym_done] = ACTIONS(1586),
    [anon_sym_fi] = ACTIONS(1586),
    [anon_sym_elif] = ACTIONS(1586),
    [anon_sym_else] = ACTIONS(1586),
    [anon_sym_esac] = ACTIONS(1586),
    [anon_sym_PIPE] = ACTIONS(1588),
    [anon_sym_RPAREN] = ACTIONS(1586),
    [anon_sym_SEMI_SEMI] = ACTIONS(1586),
    [anon_sym_PIPE_AMP] = ACTIONS(1586),
    [anon_sym_AMP_AMP] = ACTIONS(1586),
    [anon_sym_PIPE_PIPE] = ACTIONS(1586),
    [anon_sym_LT] = ACTIONS(1588),
    [anon_sym_GT] = ACTIONS(1588),
    [anon_sym_GT_GT] = ACTIONS(1586),
    [anon_sym_AMP_GT] = ACTIONS(1588),
    [anon_sym_AMP_GT_GT] = ACTIONS(1586),
    [anon_sym_LT_AMP] = ACTIONS(1586),
    [anon_sym_GT_AMP] = ACTIONS(1586),
    [anon_sym_LT_LT] = ACTIONS(1588),
    [anon_sym_LT_LT_DASH] = ACTIONS(1586),
    [anon_sym_LT_LT_LT] = ACTIONS(1586),
    [anon_sym_BQUOTE] = ACTIONS(1586),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(1586),
    [anon_sym_AMP] = ACTIONS(1588),
  },
  [319] = {
    [sym__expression] = STATE(833),
    [sym_binary_expression] = STATE(833),
    [sym_unary_expression] = STATE(833),
    [sym_postfix_expression] = STATE(833),
    [sym_parenthesized_expression] = STATE(833),
    [sym_concatenation] = STATE(833),
    [sym_string] = STATE(47),
    [sym_simple_expansion] = STATE(47),
    [sym_string_expansion] = STATE(47),
    [sym_expansion] = STATE(47),
    [sym_command_substitution] = STATE(47),
    [sym_process_substitution] = STATE(47),
    [aux_sym__literal_repeat1] = STATE(53),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [sym__special_character] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [sym_raw_string] = ACTIONS(83),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(85),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [anon_sym_LT_LPAREN] = ACTIONS(91),
    [anon_sym_GT_LPAREN] = ACTIONS(91),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(93),
    [sym_test_operator] = ACTIONS(95),
  },
  [320] = {
    [sym__expression] = STATE(833),
    [sym_binary_expression] = STATE(833),
    [sym_unary_expression] = STATE(833),
    [sym_postfix_expression] = STATE(833),
    [sym_parenthesized_expression] = STATE(833),
    [sym_concatenation] = STATE(833),
    [sym_string] = STATE(47),
    [sym_simple_expansion] = STATE(47),
    [sym_string_expansion] = STATE(47),
    [sym_expansion] = STATE(47),
    [sym_command_substitution] = STATE(47),
    [sym_process_substitution] = STATE(47),
    [aux_sym__literal_repeat1] = STATE(53),
    [sym_regex] = ACTIONS(1590),
    [anon_sym_LPAREN] = ACTIONS(73),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_DOLLAR] = ACTIONS(77),
    [sym__special_character] = ACTIONS(79),
    [anon_sym_DQUOTE] = ACTIONS(81),
    [sym_raw_string] = ACTIONS(83),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(85),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(87),
    [anon_sym_BQUOTE] = ACTIONS(89),
    [anon_sym_LT_LPAREN] = ACTIONS(91),
    [anon_sym_GT_LPAREN] = ACTIONS(91),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(93),
    [sym_test_operator] = ACTIONS(95),
  },
  [321] = {
    [anon_sym_RPAREN_RPAREN] = ACTIONS(1592),
    [anon_sym_AMP_AMP] = ACTIONS(1592),
    [anon_sym_PIPE_PIPE] = ACTIONS(1592),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(1592),
    [anon_sym_EQ_TILDE] = ACTIONS(1592),
    [anon_sym_EQ_EQ] = ACTIONS(1592),
    [anon_sym_EQ] = ACTIONS(1594),
    [anon_sym_PLUS_EQ] = ACTIONS(1592),
    [anon_sym_LT] = ACTIONS(1594),
    [anon_sym_GT] = ACTIONS(1594),
    [anon_sym_BANG_EQ] = ACTIONS(1592),
    [anon_sym_PLUS] = ACTIONS(1594),
    [anon_sym_DASH] = ACTIONS(1594),
    [anon_sym_DASH_EQ] = ACTIONS(1592),
    [anon_sym_LT_EQ] = ACTIONS(1592),
    [anon_sym_GT_EQ] = ACTIONS(1592),
    [anon_sym_PLUS_PLUS] = ACTIONS(1592),
    [anon_sym_DASH_DASH] = ACTIONS(1592),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(1592),
  },
  [322] = {
    [anon_sym_RPAREN_RPAREN] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_PIPE_PIPE] = ACTIONS(335),
    [anon_sym_EQ_TILDE] = ACTIONS(335),
    [anon_sym_EQ_EQ] = ACTIONS(335),
    [anon_sym_EQ] = ACTIONS(339),
    [anon_sym_PLUS_EQ] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(339),
    [anon_sym_BANG_EQ] = ACTIONS(335),
    [anon_sym_PLUS] = ACTIONS(339),
    [anon_sym_DASH] = ACTIONS(339),
    [anon_sym_DASH_EQ] = ACTIONS(335),
    [anon_sym_LT_EQ] = ACTIONS(335),
    [anon_sym_GT_EQ] = ACTIONS(335),
    [anon_sym_PLUS_PLUS] = ACTIONS(335),
    [anon_sym_DASH_DASH] = ACTIONS(335),
    [sym__special_character] = ACTIONS(335),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(335),
  },
  [323] = {
    [aux_sym__literal_repeat1] = STATE(323),
    [anon_sym_RPAREN_RPAREN] = ACTIONS(1373),
    [anon_sym_AMP_AMP] = ACTIONS(1373),
    [anon_sym_PIPE_PIPE] = ACTIONS(1373),
    [anon_sym_EQ_TILDE] = ACTIONS(1373),
    [anon_sym_EQ_EQ] = ACTIONS(1373),
    [anon_sym_EQ] = ACTIONS(1375),
    [anon_sym_PLUS_EQ] = ACTIONS(1373),
    [anon_sym_LT] = ACTIONS(1375),
    [anon_sym_GT] = ACTIONS(1375),
    [anon_sym_BANG_EQ] = ACTIONS(1373),
    [anon_sym_PLUS] = ACTIONS(1375),
    [anon_sym_DASH] = ACTIONS(1375),
    [anon_sym_DASH_EQ] = ACTIONS(1373),
    [anon_sym_LT_EQ] = ACTIONS(1373),
    [anon_sym_GT_EQ] = ACTIONS(1373),
    [anon_sym_PLUS_PLUS] = ACTIONS(1373),
    [anon_sym_DASH_DASH] = ACTIONS(1373),
    [sym__special_character] = ACTIONS(1596),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(1373),
  },
  [324] = {
    [sym_concatenation] = STATE(835),
    [sym_string] = STATE(840),
    [sym_array] = STATE(835),
    [sym_simple_expansion] = STATE(840),
    [sym_string_expansion] = STATE(840),
    [sym_expansion] = STATE(840),
    [sym_command_substitution] = STATE(840),
    [sym_process_substitution] = STATE(840),
    [aux_sym__literal_repeat1] = STATE(845),
    [sym__empty_value] = ACTIONS(1599),
    [anon_sym_LPAREN] = ACTIONS(1601),
    [anon_sym_DOLLAR] = ACTIONS(1603),
    [sym__special_character] = ACTIONS(1605),
    [anon_sym_DQUOTE] = ACTIONS(1607),
    [sym_raw_string] = ACTIONS(1609),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1611),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1613),
    [anon_sym_BQUOTE] = ACTIONS(1615),
    [anon_sym_LT_LPAREN] = ACTIONS(1617),
    [anon_sym_GT_LPAREN] = ACTIONS(1617),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1609),
  },
  [325] = {
    [sym__expression] = STATE(847),
    [sym_binary_expression] = STATE(847),
    [sym_unary_expression] = STATE(847),
    [sym_postfix_expression] = STATE(847),
    [sym_parenthesized_expression] = STATE(847),
    [sym_concatenation] = STATE(847),
    [sym_string] = STATE(280),
    [sym_simple_expansion] = STATE(280),
    [sym_string_expansion] = STATE(280),
    [sym_expansion] = STATE(280),
    [sym_command_substitution] = STATE(280),
    [sym_process_substitution] = STATE(280),
    [aux_sym__literal_repeat1] = STATE(286),
    [anon_sym_SEMI] = ACTIONS(1619),
    [anon_sym_SEMI_SEMI] = ACTIONS(1621),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_BANG] = ACTIONS(475),
    [anon_sym_DOLLAR] = ACTIONS(477),
    [sym__special_character] = ACTIONS(479),
    [anon_sym_DQUOTE] = ACTIONS(481),
    [sym_raw_string] = ACTIONS(483),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(485),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(487),
    [anon_sym_BQUOTE] = ACTIONS(489),
    [anon_sym_LT_LPAREN] = ACTIONS(491),
    [anon_sym_GT_LPAREN] = ACTIONS(491),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(493),
    [sym_test_operator] = ACTIONS(495),
    [anon_sym_LF] = ACTIONS(1621),
    [anon_sym_AMP] = ACTIONS(1621),
  },
  [326] = {
    [anon_sym_in] = ACTIONS(1623),
    [anon_sym_SEMI] = ACTIONS(1625),
    [anon_sym_SEMI_SEMI] = ACTIONS(1627),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(1627),
    [anon_sym_AMP] = ACTIONS(1627),
  },
  [327] = {
    [anon_sym_RPAREN_RPAREN] = ACTIONS(1629),
    [anon_sym_AMP_AMP] = ACTIONS(557),
    [anon_sym_PIPE_PIPE] = ACTIONS(557),
    [anon_sym_EQ_TILDE] = ACTIONS(559),
    [anon_sym_EQ_EQ] = ACTIONS(559),
    [anon_sym_EQ] = ACTIONS(561),
    [anon_sym_PLUS_EQ] = ACTIONS(557),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_GT] = ACTIONS(561),
    [anon_sym_BANG_EQ] = ACTIONS(557),
    [anon_sym_PLUS] = ACTIONS(561),
    [anon_sym_DASH] = ACTIONS(561),
    [anon_sym_DASH_EQ] = ACTIONS(557),
    [anon_sym_LT_EQ] = ACTIONS(557),
    [anon_sym_GT_EQ] = ACTIONS(557),
    [anon_sym_PLUS_PLUS] = ACTIONS(563),
    [anon_sym_DASH_DASH] = ACTIONS(563),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(557),
  },
  [328] = {
    [sym_do_group] = STATE(852),
    [anon_sym_do] = ACTIONS(1631),
    [sym_comment] = ACTIONS(57),
  },
  [329] = {
    [anon_sym_then] = ACTIONS(1633),
    [sym_comment] = ACTIONS(57),
  },
  [330] = {
    [aux_sym_concatenation_repeat1] = STATE(401),
    [sym__concat] = ACTIONS(695),
    [anon_sym_in] = ACTIONS(1635),
    [anon_sym_SEMI] = ACTIONS(1637),
    [anon_sym_SEMI_SEMI] = ACTIONS(1639),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(1639),
    [anon_sym_AMP] = ACTIONS(1639),
  },
  [331] = {
    [anon_sym_in] = ACTIONS(1635),
    [anon_sym_SEMI] = ACTIONS(1637),
    [anon_sym_SEMI_SEMI] = ACTIONS(1639),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(1639),
    [anon_sym_AMP] = ACTIONS(1639),
  },
  [332] = {
    [aux_sym__literal_repeat1] = STATE(418),
    [anon_sym_in] = ACTIONS(1641),
    [anon_sym_SEMI] = ACTIONS(1643),
    [anon_sym_SEMI_SEMI] = ACTIONS(1645),
    [sym__special_character] = ACTIONS(723),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(1645),
    [anon_sym_AMP] = ACTIONS(1645),
  },
  [333] = {
    [sym_compound_statement] = STATE(859),
    [anon_sym_LPAREN] = ACTIONS(1647),
    [anon_sym_LBRACE] = ACTIONS(113),
    [sym_comment] = ACTIONS(57),
  },
  [334] = {
    [anon_sym_RPAREN] = ACTIONS(1649),
    [sym_comment] = ACTIONS(57),
  },
  [335] = {
    [sym_file_descriptor] = ACTIONS(783),
    [anon_sym_SEMI] = ACTIONS(785),
    [anon_sym_PIPE] = ACTIONS(785),
    [anon_sym_SEMI_SEMI] = ACTIONS(783),
    [anon_sym_PIPE_AMP] = ACTIONS(783),
    [anon_sym_AMP_AMP] = ACTIONS(783),
    [anon_sym_PIPE_PIPE] = ACTIONS(783),
    [anon_sym_LT] = ACTIONS(785),
    [anon_sym_GT] = ACTIONS(785),
    [anon_sym_GT_GT] = ACTIONS(783),
    [anon_sym_AMP_GT] = ACTIONS(785),
    [anon_sym_AMP_GT_GT] = ACTIONS(783),
    [anon_sym_LT_AMP] = ACTIONS(783),
    [anon_sym_GT_AMP] = ACTIONS(783),
    [anon_sym_LT_LT] = ACTIONS(785),
    [anon_sym_LT_LT_DASH] = ACTIONS(783),
    [anon_sym_LT_LT_LT] = ACTIONS(783),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(783),
    [anon_sym_AMP] = ACTIONS(785),
  },
  [336] = {
    [anon_sym_RBRACE] = ACTIONS(1651),
    [sym_comment] = ACTIONS(57),
  },
  [337] = {
    [sym_file_descriptor] = ACTIONS(895),
    [anon_sym_SEMI] = ACTIONS(897),
    [anon_sym_PIPE] = ACTIONS(897),
    [anon_sym_SEMI_SEMI] = ACTIONS(895),
    [anon_sym_PIPE_AMP] = ACTIONS(895),
    [anon_sym_AMP_AMP] = ACTIONS(895),
    [anon_sym_PIPE_PIPE] = ACTIONS(895),
    [anon_sym_LT] = ACTIONS(897),
    [anon_sym_GT] = ACTIONS(897),
    [anon_sym_GT_GT] = ACTIONS(895),
    [anon_sym_AMP_GT] = ACTIONS(897),
    [anon_sym_AMP_GT_GT] = ACTIONS(895),
    [anon_sym_LT_AMP] = ACTIONS(895),
    [anon_sym_GT_AMP] = ACTIONS(895),
    [anon_sym_LT_LT] = ACTIONS(897),
    [anon_sym_LT_LT_DASH] = ACTIONS(895),
    [anon_sym_LT_LT_LT] = ACTIONS(895),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(895),
    [anon_sym_AMP] = ACTIONS(897),
  },
  [338] = {
    [anon_sym_AMP_AMP] = ACTIONS(923),
    [anon_sym_PIPE_PIPE] = ACTIONS(923),
    [anon_sym_RBRACK] = ACTIONS(1629),
    [anon_sym_EQ_TILDE] = ACTIONS(925),
    [anon_sym_EQ_EQ] = ACTIONS(925),
    [anon_sym_EQ] = ACTIONS(927),
    [anon_sym_PLUS_EQ] = ACTIONS(923),
    [anon_sym_LT] = ACTIONS(927),
    [anon_sym_GT] = ACTIONS(927),
    [anon_sym_BANG_EQ] = ACTIONS(923),
    [anon_sym_PLUS] = ACTIONS(927),
    [anon_sym_DASH] = ACTIONS(927),
    [anon_sym_DASH_EQ] = ACTIONS(923),
    [anon_sym_LT_EQ] = ACTIONS(923),
    [anon_sym_GT_EQ] = ACTIONS(923),
    [anon_sym_PLUS_PLUS] = ACTIONS(929),
    [anon_sym_DASH_DASH] = ACTIONS(929),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(923),
  },
  [339] = {
    [anon_sym_AMP_AMP] = ACTIONS(933),
    [anon_sym_PIPE_PIPE] = ACTIONS(933),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(1629),
    [anon_sym_EQ_TILDE] = ACTIONS(935),
    [anon_sym_EQ_EQ] = ACTIONS(935),
    [anon_sym_EQ] = ACTIONS(937),
    [anon_sym_PLUS_EQ] = ACTIONS(933),
    [anon_sym_LT] = ACTIONS(937),
    [anon_sym_GT] = ACTIONS(937),
    [anon_sym_BANG_EQ] = ACTIONS(933),
    [anon_sym_PLUS] = ACTIONS(937),
    [anon_sym_DASH] = ACTIONS(937),
    [anon_sym_DASH_EQ] = ACTIONS(933),
    [anon_sym_LT_EQ] = ACTIONS(933),
    [anon_sym_GT_EQ] = ACTIONS(933),
    [anon_sym_PLUS_PLUS] = ACTIONS(563),
    [anon_sym_DASH_DASH] = ACTIONS(563),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(933),
  },
  [340] = {
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_EQ] = ACTIONS(1653),
    [anon_sym_PLUS_EQ] = ACTIONS(1653),
    [sym_comment] = ACTIONS(57),
  },
  [341] = {
    [sym_string] = STATE(864),
    [anon_sym_DASH] = ACTIONS(1655),
    [anon_sym_DOLLAR] = ACTIONS(1655),
    [anon_sym_DQUOTE] = ACTIONS(589),
    [sym_raw_string] = ACTIONS(1657),
    [anon_sym_POUND] = ACTIONS(1655),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1659),
    [anon_sym_STAR] = ACTIONS(1661),
    [anon_sym_AT] = ACTIONS(1661),
    [anon_sym_QMARK] = ACTIONS(1661),
    [anon_sym_0] = ACTIONS(1659),
    [anon_sym__] = ACTIONS(1659),
  },
  [342] = {
    [aux_sym_concatenation_repeat1] = STATE(867),
    [sym_file_descriptor] = ACTIONS(335),
    [sym__concat] = ACTIONS(1663),
    [sym_variable_name] = ACTIONS(335),
    [anon_sym_SEMI] = ACTIONS(339),
    [anon_sym_PIPE] = ACTIONS(339),
    [anon_sym_SEMI_SEMI] = ACTIONS(335),
    [anon_sym_PIPE_AMP] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_PIPE_PIPE] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(339),
    [anon_sym_GT_GT] = ACTIONS(335),
    [anon_sym_AMP_GT] = ACTIONS(339),
    [anon_sym_AMP_GT_GT] = ACTIONS(335),
    [anon_sym_LT_AMP] = ACTIONS(335),
    [anon_sym_GT_AMP] = ACTIONS(335),
    [anon_sym_LT_LT] = ACTIONS(339),
    [anon_sym_LT_LT_DASH] = ACTIONS(335),
    [anon_sym_LT_LT_LT] = ACTIONS(335),
    [anon_sym_DOLLAR] = ACTIONS(339),
    [sym__special_character] = ACTIONS(335),
    [anon_sym_DQUOTE] = ACTIONS(335),
    [sym_raw_string] = ACTIONS(335),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(335),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(335),
    [anon_sym_LT_LPAREN] = ACTIONS(335),
    [anon_sym_GT_LPAREN] = ACTIONS(335),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(339),
    [sym_word] = ACTIONS(339),
    [anon_sym_LF] = ACTIONS(335),
    [anon_sym_AMP] = ACTIONS(339),
  },
  [343] = {
    [sym_simple_expansion] = STATE(204),
    [sym_expansion] = STATE(204),
    [sym_command_substitution] = STATE(204),
    [aux_sym_string_repeat1] = STATE(870),
    [anon_sym_DOLLAR] = ACTIONS(1665),
    [anon_sym_DQUOTE] = ACTIONS(1667),
    [sym__string_content] = ACTIONS(345),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(347),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(329),
  },
  [344] = {
    [aux_sym_concatenation_repeat1] = STATE(867),
    [sym_file_descriptor] = ACTIONS(957),
    [sym__concat] = ACTIONS(1663),
    [sym_variable_name] = ACTIONS(957),
    [anon_sym_SEMI] = ACTIONS(959),
    [anon_sym_PIPE] = ACTIONS(959),
    [anon_sym_SEMI_SEMI] = ACTIONS(957),
    [anon_sym_PIPE_AMP] = ACTIONS(957),
    [anon_sym_AMP_AMP] = ACTIONS(957),
    [anon_sym_PIPE_PIPE] = ACTIONS(957),
    [anon_sym_LT] = ACTIONS(959),
    [anon_sym_GT] = ACTIONS(959),
    [anon_sym_GT_GT] = ACTIONS(957),
    [anon_sym_AMP_GT] = ACTIONS(959),
    [anon_sym_AMP_GT_GT] = ACTIONS(957),
    [anon_sym_LT_AMP] = ACTIONS(957),
    [anon_sym_GT_AMP] = ACTIONS(957),
    [anon_sym_LT_LT] = ACTIONS(959),
    [anon_sym_LT_LT_DASH] = ACTIONS(957),
    [anon_sym_LT_LT_LT] = ACTIONS(957),
    [anon_sym_DOLLAR] = ACTIONS(959),
    [sym__special_character] = ACTIONS(957),
    [anon_sym_DQUOTE] = ACTIONS(957),
    [sym_raw_string] = ACTIONS(957),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(957),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(957),
    [anon_sym_BQUOTE] = ACTIONS(957),
    [anon_sym_LT_LPAREN] = ACTIONS(957),
    [anon_sym_GT_LPAREN] = ACTIONS(957),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(959),
    [sym_word] = ACTIONS(959),
    [anon_sym_LF] = ACTIONS(957),
    [anon_sym_AMP] = ACTIONS(959),
  },
  [345] = {
    [sym_subscript] = STATE(874),
    [sym_variable_name] = ACTIONS(1669),
    [anon_sym_BANG] = ACTIONS(1671),
    [anon_sym_DASH] = ACTIONS(1673),
    [anon_sym_DOLLAR] = ACTIONS(1673),
    [anon_sym_POUND] = ACTIONS(1671),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1675),
    [anon_sym_STAR] = ACTIONS(1677),
    [anon_sym_AT] = ACTIONS(1677),
    [anon_sym_QMARK] = ACTIONS(1677),
    [anon_sym_0] = ACTIONS(1675),
    [anon_sym__] = ACTIONS(1675),
  },
  [346] = {
    [sym__statements] = STATE(875),
    [sym_redirected_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_c_style_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_case_statement] = STATE(105),
    [sym_function_definition] = STATE(105),
    [sym_compound_statement] = STATE(105),
    [sym_subshell] = STATE(105),
    [sym_pipeline] = STATE(105),
    [sym_list] = STATE(105),
    [sym_negated_command] = STATE(105),
    [sym_test_command] = STATE(105),
    [sym_declaration_command] = STATE(105),
    [sym_unset_command] = STATE(105),
    [sym_command] = STATE(105),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(107),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(876),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(109),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(371),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(371),
    [anon_sym_LT_AMP] = ACTIONS(371),
    [anon_sym_GT_AMP] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [347] = {
    [sym__statements] = STATE(877),
    [sym_redirected_statement] = STATE(225),
    [sym_for_statement] = STATE(225),
    [sym_c_style_for_statement] = STATE(225),
    [sym_while_statement] = STATE(225),
    [sym_if_statement] = STATE(225),
    [sym_case_statement] = STATE(225),
    [sym_function_definition] = STATE(225),
    [sym_compound_statement] = STATE(225),
    [sym_subshell] = STATE(225),
    [sym_pipeline] = STATE(225),
    [sym_list] = STATE(225),
    [sym_negated_command] = STATE(225),
    [sym_test_command] = STATE(225),
    [sym_declaration_command] = STATE(225),
    [sym_unset_command] = STATE(225),
    [sym_command] = STATE(225),
    [sym_command_name] = STATE(226),
    [sym_variable_assignment] = STATE(227),
    [sym_subscript] = STATE(228),
    [sym_file_redirect] = STATE(230),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(222),
    [sym_simple_expansion] = STATE(222),
    [sym_string_expansion] = STATE(222),
    [sym_expansion] = STATE(222),
    [sym_command_substitution] = STATE(222),
    [sym_process_substitution] = STATE(222),
    [aux_sym__statements_repeat1] = STATE(229),
    [aux_sym_command_repeat1] = STATE(230),
    [aux_sym__literal_repeat1] = STATE(231),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(375),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_typeset] = ACTIONS(377),
    [anon_sym_export] = ACTIONS(377),
    [anon_sym_readonly] = ACTIONS(377),
    [anon_sym_local] = ACTIONS(377),
    [anon_sym_unset] = ACTIONS(379),
    [anon_sym_unsetenv] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(381),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(383),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(385),
  },
  [348] = {
    [sym__statements] = STATE(878),
    [sym_redirected_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_c_style_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_case_statement] = STATE(105),
    [sym_function_definition] = STATE(105),
    [sym_compound_statement] = STATE(105),
    [sym_subshell] = STATE(105),
    [sym_pipeline] = STATE(105),
    [sym_list] = STATE(105),
    [sym_negated_command] = STATE(105),
    [sym_test_command] = STATE(105),
    [sym_declaration_command] = STATE(105),
    [sym_unset_command] = STATE(105),
    [sym_command] = STATE(105),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(107),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(110),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(109),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [349] = {
    [anon_sym_EQ] = ACTIONS(1653),
    [anon_sym_PLUS_EQ] = ACTIONS(1653),
    [sym_comment] = ACTIONS(57),
  },
  [350] = {
    [sym_variable_assignment] = STATE(879),
    [sym_subscript] = STATE(349),
    [sym_concatenation] = STATE(879),
    [sym_string] = STATE(344),
    [sym_simple_expansion] = STATE(344),
    [sym_string_expansion] = STATE(344),
    [sym_expansion] = STATE(344),
    [sym_command_substitution] = STATE(344),
    [sym_process_substitution] = STATE(344),
    [aux_sym_declaration_command_repeat1] = STATE(879),
    [aux_sym__literal_repeat1] = STATE(351),
    [sym_file_descriptor] = ACTIONS(971),
    [sym_variable_name] = ACTIONS(583),
    [anon_sym_SEMI] = ACTIONS(973),
    [anon_sym_PIPE] = ACTIONS(973),
    [anon_sym_SEMI_SEMI] = ACTIONS(971),
    [anon_sym_PIPE_AMP] = ACTIONS(971),
    [anon_sym_AMP_AMP] = ACTIONS(971),
    [anon_sym_PIPE_PIPE] = ACTIONS(971),
    [anon_sym_LT] = ACTIONS(973),
    [anon_sym_GT] = ACTIONS(973),
    [anon_sym_GT_GT] = ACTIONS(971),
    [anon_sym_AMP_GT] = ACTIONS(973),
    [anon_sym_AMP_GT_GT] = ACTIONS(971),
    [anon_sym_LT_AMP] = ACTIONS(971),
    [anon_sym_GT_AMP] = ACTIONS(971),
    [anon_sym_LT_LT] = ACTIONS(973),
    [anon_sym_LT_LT_DASH] = ACTIONS(971),
    [anon_sym_LT_LT_LT] = ACTIONS(971),
    [anon_sym_DOLLAR] = ACTIONS(585),
    [sym__special_character] = ACTIONS(587),
    [anon_sym_DQUOTE] = ACTIONS(589),
    [sym_raw_string] = ACTIONS(591),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(593),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(595),
    [anon_sym_BQUOTE] = ACTIONS(597),
    [anon_sym_LT_LPAREN] = ACTIONS(599),
    [anon_sym_GT_LPAREN] = ACTIONS(599),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1679),
    [sym_word] = ACTIONS(603),
    [anon_sym_LF] = ACTIONS(971),
    [anon_sym_AMP] = ACTIONS(973),
  },
  [351] = {
    [aux_sym__literal_repeat1] = STATE(881),
    [sym_file_descriptor] = ACTIONS(977),
    [sym_variable_name] = ACTIONS(977),
    [anon_sym_SEMI] = ACTIONS(979),
    [anon_sym_PIPE] = ACTIONS(979),
    [anon_sym_SEMI_SEMI] = ACTIONS(977),
    [anon_sym_PIPE_AMP] = ACTIONS(977),
    [anon_sym_AMP_AMP] = ACTIONS(977),
    [anon_sym_PIPE_PIPE] = ACTIONS(977),
    [anon_sym_LT] = ACTIONS(979),
    [anon_sym_GT] = ACTIONS(979),
    [anon_sym_GT_GT] = ACTIONS(977),
    [anon_sym_AMP_GT] = ACTIONS(979),
    [anon_sym_AMP_GT_GT] = ACTIONS(977),
    [anon_sym_LT_AMP] = ACTIONS(977),
    [anon_sym_GT_AMP] = ACTIONS(977),
    [anon_sym_LT_LT] = ACTIONS(979),
    [anon_sym_LT_LT_DASH] = ACTIONS(977),
    [anon_sym_LT_LT_LT] = ACTIONS(977),
    [anon_sym_DOLLAR] = ACTIONS(979),
    [sym__special_character] = ACTIONS(1681),
    [anon_sym_DQUOTE] = ACTIONS(977),
    [sym_raw_string] = ACTIONS(977),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(977),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(977),
    [anon_sym_BQUOTE] = ACTIONS(977),
    [anon_sym_LT_LPAREN] = ACTIONS(977),
    [anon_sym_GT_LPAREN] = ACTIONS(977),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(979),
    [sym_word] = ACTIONS(979),
    [anon_sym_LF] = ACTIONS(977),
    [anon_sym_AMP] = ACTIONS(979),
  },
  [352] = {
    [sym_string] = STATE(883),
    [anon_sym_DASH] = ACTIONS(1683),
    [anon_sym_DOLLAR] = ACTIONS(1683),
    [anon_sym_DQUOTE] = ACTIONS(609),
    [sym_raw_string] = ACTIONS(1685),
    [anon_sym_POUND] = ACTIONS(1683),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1687),
    [anon_sym_STAR] = ACTIONS(1689),
    [anon_sym_AT] = ACTIONS(1689),
    [anon_sym_QMARK] = ACTIONS(1689),
    [anon_sym_0] = ACTIONS(1687),
    [anon_sym__] = ACTIONS(1687),
  },
  [353] = {
    [aux_sym_concatenation_repeat1] = STATE(886),
    [sym_file_descriptor] = ACTIONS(335),
    [sym__concat] = ACTIONS(1691),
    [anon_sym_SEMI] = ACTIONS(339),
    [anon_sym_PIPE] = ACTIONS(339),
    [anon_sym_SEMI_SEMI] = ACTIONS(335),
    [anon_sym_PIPE_AMP] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_PIPE_PIPE] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(339),
    [anon_sym_GT_GT] = ACTIONS(335),
    [anon_sym_AMP_GT] = ACTIONS(339),
    [anon_sym_AMP_GT_GT] = ACTIONS(335),
    [anon_sym_LT_AMP] = ACTIONS(335),
    [anon_sym_GT_AMP] = ACTIONS(335),
    [anon_sym_LT_LT] = ACTIONS(339),
    [anon_sym_LT_LT_DASH] = ACTIONS(335),
    [anon_sym_LT_LT_LT] = ACTIONS(335),
    [anon_sym_DOLLAR] = ACTIONS(339),
    [sym__special_character] = ACTIONS(335),
    [anon_sym_DQUOTE] = ACTIONS(335),
    [sym_raw_string] = ACTIONS(335),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(335),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(335),
    [anon_sym_LT_LPAREN] = ACTIONS(335),
    [anon_sym_GT_LPAREN] = ACTIONS(335),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(339),
    [sym_word] = ACTIONS(339),
    [anon_sym_LF] = ACTIONS(335),
    [anon_sym_AMP] = ACTIONS(339),
  },
  [354] = {
    [sym_simple_expansion] = STATE(204),
    [sym_expansion] = STATE(204),
    [sym_command_substitution] = STATE(204),
    [aux_sym_string_repeat1] = STATE(889),
    [anon_sym_DOLLAR] = ACTIONS(1693),
    [anon_sym_DQUOTE] = ACTIONS(1695),
    [sym__string_content] = ACTIONS(345),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(347),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(329),
  },
  [355] = {
    [aux_sym_concatenation_repeat1] = STATE(886),
    [sym_file_descriptor] = ACTIONS(997),
    [sym__concat] = ACTIONS(1691),
    [anon_sym_SEMI] = ACTIONS(999),
    [anon_sym_PIPE] = ACTIONS(999),
    [anon_sym_SEMI_SEMI] = ACTIONS(997),
    [anon_sym_PIPE_AMP] = ACTIONS(997),
    [anon_sym_AMP_AMP] = ACTIONS(997),
    [anon_sym_PIPE_PIPE] = ACTIONS(997),
    [anon_sym_LT] = ACTIONS(999),
    [anon_sym_GT] = ACTIONS(999),
    [anon_sym_GT_GT] = ACTIONS(997),
    [anon_sym_AMP_GT] = ACTIONS(999),
    [anon_sym_AMP_GT_GT] = ACTIONS(997),
    [anon_sym_LT_AMP] = ACTIONS(997),
    [anon_sym_GT_AMP] = ACTIONS(997),
    [anon_sym_LT_LT] = ACTIONS(999),
    [anon_sym_LT_LT_DASH] = ACTIONS(997),
    [anon_sym_LT_LT_LT] = ACTIONS(997),
    [anon_sym_DOLLAR] = ACTIONS(999),
    [sym__special_character] = ACTIONS(997),
    [anon_sym_DQUOTE] = ACTIONS(997),
    [sym_raw_string] = ACTIONS(997),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(997),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(997),
    [anon_sym_BQUOTE] = ACTIONS(997),
    [anon_sym_LT_LPAREN] = ACTIONS(997),
    [anon_sym_GT_LPAREN] = ACTIONS(997),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(999),
    [sym_word] = ACTIONS(999),
    [anon_sym_LF] = ACTIONS(997),
    [anon_sym_AMP] = ACTIONS(999),
  },
  [356] = {
    [sym_subscript] = STATE(893),
    [sym_variable_name] = ACTIONS(1697),
    [anon_sym_BANG] = ACTIONS(1699),
    [anon_sym_DASH] = ACTIONS(1701),
    [anon_sym_DOLLAR] = ACTIONS(1701),
    [anon_sym_POUND] = ACTIONS(1699),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1703),
    [anon_sym_STAR] = ACTIONS(1705),
    [anon_sym_AT] = ACTIONS(1705),
    [anon_sym_QMARK] = ACTIONS(1705),
    [anon_sym_0] = ACTIONS(1703),
    [anon_sym__] = ACTIONS(1703),
  },
  [357] = {
    [sym__statements] = STATE(894),
    [sym_redirected_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_c_style_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_case_statement] = STATE(105),
    [sym_function_definition] = STATE(105),
    [sym_compound_statement] = STATE(105),
    [sym_subshell] = STATE(105),
    [sym_pipeline] = STATE(105),
    [sym_list] = STATE(105),
    [sym_negated_command] = STATE(105),
    [sym_test_command] = STATE(105),
    [sym_declaration_command] = STATE(105),
    [sym_unset_command] = STATE(105),
    [sym_command] = STATE(105),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(107),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(895),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(109),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(371),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(371),
    [anon_sym_LT_AMP] = ACTIONS(371),
    [anon_sym_GT_AMP] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [358] = {
    [sym__statements] = STATE(896),
    [sym_redirected_statement] = STATE(225),
    [sym_for_statement] = STATE(225),
    [sym_c_style_for_statement] = STATE(225),
    [sym_while_statement] = STATE(225),
    [sym_if_statement] = STATE(225),
    [sym_case_statement] = STATE(225),
    [sym_function_definition] = STATE(225),
    [sym_compound_statement] = STATE(225),
    [sym_subshell] = STATE(225),
    [sym_pipeline] = STATE(225),
    [sym_list] = STATE(225),
    [sym_negated_command] = STATE(225),
    [sym_test_command] = STATE(225),
    [sym_declaration_command] = STATE(225),
    [sym_unset_command] = STATE(225),
    [sym_command] = STATE(225),
    [sym_command_name] = STATE(226),
    [sym_variable_assignment] = STATE(227),
    [sym_subscript] = STATE(228),
    [sym_file_redirect] = STATE(230),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(222),
    [sym_simple_expansion] = STATE(222),
    [sym_string_expansion] = STATE(222),
    [sym_expansion] = STATE(222),
    [sym_command_substitution] = STATE(222),
    [sym_process_substitution] = STATE(222),
    [aux_sym__statements_repeat1] = STATE(229),
    [aux_sym_command_repeat1] = STATE(230),
    [aux_sym__literal_repeat1] = STATE(231),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(375),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(377),
    [anon_sym_typeset] = ACTIONS(377),
    [anon_sym_export] = ACTIONS(377),
    [anon_sym_readonly] = ACTIONS(377),
    [anon_sym_local] = ACTIONS(377),
    [anon_sym_unset] = ACTIONS(379),
    [anon_sym_unsetenv] = ACTIONS(379),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(381),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(383),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(385),
  },
  [359] = {
    [sym__statements] = STATE(897),
    [sym_redirected_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_c_style_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_case_statement] = STATE(105),
    [sym_function_definition] = STATE(105),
    [sym_compound_statement] = STATE(105),
    [sym_subshell] = STATE(105),
    [sym_pipeline] = STATE(105),
    [sym_list] = STATE(105),
    [sym_negated_command] = STATE(105),
    [sym_test_command] = STATE(105),
    [sym_declaration_command] = STATE(105),
    [sym_unset_command] = STATE(105),
    [sym_command] = STATE(105),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(107),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(110),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(109),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [360] = {
    [sym_concatenation] = STATE(898),
    [sym_string] = STATE(355),
    [sym_simple_expansion] = STATE(355),
    [sym_string_expansion] = STATE(355),
    [sym_expansion] = STATE(355),
    [sym_command_substitution] = STATE(355),
    [sym_process_substitution] = STATE(355),
    [aux_sym_unset_command_repeat1] = STATE(898),
    [aux_sym__literal_repeat1] = STATE(361),
    [sym_file_descriptor] = ACTIONS(1011),
    [anon_sym_SEMI] = ACTIONS(1013),
    [anon_sym_PIPE] = ACTIONS(1013),
    [anon_sym_SEMI_SEMI] = ACTIONS(1011),
    [anon_sym_PIPE_AMP] = ACTIONS(1011),
    [anon_sym_AMP_AMP] = ACTIONS(1011),
    [anon_sym_PIPE_PIPE] = ACTIONS(1011),
    [anon_sym_LT] = ACTIONS(1013),
    [anon_sym_GT] = ACTIONS(1013),
    [anon_sym_GT_GT] = ACTIONS(1011),
    [anon_sym_AMP_GT] = ACTIONS(1013),
    [anon_sym_AMP_GT_GT] = ACTIONS(1011),
    [anon_sym_LT_AMP] = ACTIONS(1011),
    [anon_sym_GT_AMP] = ACTIONS(1011),
    [anon_sym_LT_LT] = ACTIONS(1013),
    [anon_sym_LT_LT_DASH] = ACTIONS(1011),
    [anon_sym_LT_LT_LT] = ACTIONS(1011),
    [anon_sym_DOLLAR] = ACTIONS(605),
    [sym__special_character] = ACTIONS(607),
    [anon_sym_DQUOTE] = ACTIONS(609),
    [sym_raw_string] = ACTIONS(611),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(613),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(615),
    [anon_sym_BQUOTE] = ACTIONS(617),
    [anon_sym_LT_LPAREN] = ACTIONS(619),
    [anon_sym_GT_LPAREN] = ACTIONS(619),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1707),
    [sym_word] = ACTIONS(623),
    [anon_sym_LF] = ACTIONS(1011),
    [anon_sym_AMP] = ACTIONS(1013),
  },
  [361] = {
    [aux_sym__literal_repeat1] = STATE(900),
    [sym_file_descriptor] = ACTIONS(1017),
    [anon_sym_SEMI] = ACTIONS(1019),
    [anon_sym_PIPE] = ACTIONS(1019),
    [anon_sym_SEMI_SEMI] = ACTIONS(1017),
    [anon_sym_PIPE_AMP] = ACTIONS(1017),
    [anon_sym_AMP_AMP] = ACTIONS(1017),
    [anon_sym_PIPE_PIPE] = ACTIONS(1017),
    [anon_sym_LT] = ACTIONS(1019),
    [anon_sym_GT] = ACTIONS(1019),
    [anon_sym_GT_GT] = ACTIONS(1017),
    [anon_sym_AMP_GT] = ACTIONS(1019),
    [anon_sym_AMP_GT_GT] = ACTIONS(1017),
    [anon_sym_LT_AMP] = ACTIONS(1017),
    [anon_sym_GT_AMP] = ACTIONS(1017),
    [anon_sym_LT_LT] = ACTIONS(1019),
    [anon_sym_LT_LT_DASH] = ACTIONS(1017),
    [anon_sym_LT_LT_LT] = ACTIONS(1017),
    [anon_sym_DOLLAR] = ACTIONS(1019),
    [sym__special_character] = ACTIONS(1709),
    [anon_sym_DQUOTE] = ACTIONS(1017),
    [sym_raw_string] = ACTIONS(1017),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1017),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1017),
    [anon_sym_BQUOTE] = ACTIONS(1017),
    [anon_sym_LT_LPAREN] = ACTIONS(1017),
    [anon_sym_GT_LPAREN] = ACTIONS(1017),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1019),
    [sym_word] = ACTIONS(1019),
    [anon_sym_LF] = ACTIONS(1017),
    [anon_sym_AMP] = ACTIONS(1019),
  },
  [362] = {
    [sym_file_descriptor] = ACTIONS(1057),
    [sym__concat] = ACTIONS(1057),
    [anon_sym_SEMI] = ACTIONS(1059),
    [anon_sym_PIPE] = ACTIONS(1059),
    [anon_sym_SEMI_SEMI] = ACTIONS(1057),
    [anon_sym_PIPE_AMP] = ACTIONS(1057),
    [anon_sym_AMP_AMP] = ACTIONS(1057),
    [anon_sym_PIPE_PIPE] = ACTIONS(1057),
    [anon_sym_EQ_TILDE] = ACTIONS(1059),
    [anon_sym_EQ_EQ] = ACTIONS(1059),
    [anon_sym_LT] = ACTIONS(1059),
    [anon_sym_GT] = ACTIONS(1059),
    [anon_sym_GT_GT] = ACTIONS(1057),
    [anon_sym_AMP_GT] = ACTIONS(1059),
    [anon_sym_AMP_GT_GT] = ACTIONS(1057),
    [anon_sym_LT_AMP] = ACTIONS(1057),
    [anon_sym_GT_AMP] = ACTIONS(1057),
    [anon_sym_LT_LT] = ACTIONS(1059),
    [anon_sym_LT_LT_DASH] = ACTIONS(1057),
    [anon_sym_LT_LT_LT] = ACTIONS(1057),
    [anon_sym_DOLLAR] = ACTIONS(1059),
    [sym__special_character] = ACTIONS(1057),
    [anon_sym_DQUOTE] = ACTIONS(1057),
    [sym_raw_string] = ACTIONS(1057),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1057),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1057),
    [anon_sym_BQUOTE] = ACTIONS(1057),
    [anon_sym_LT_LPAREN] = ACTIONS(1057),
    [anon_sym_GT_LPAREN] = ACTIONS(1057),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1059),
    [anon_sym_LF] = ACTIONS(1057),
    [anon_sym_AMP] = ACTIONS(1059),
  },
  [363] = {
    [sym_file_descriptor] = ACTIONS(1061),
    [sym__concat] = ACTIONS(1061),
    [anon_sym_SEMI] = ACTIONS(1063),
    [anon_sym_PIPE] = ACTIONS(1063),
    [anon_sym_SEMI_SEMI] = ACTIONS(1061),
    [anon_sym_PIPE_AMP] = ACTIONS(1061),
    [anon_sym_AMP_AMP] = ACTIONS(1061),
    [anon_sym_PIPE_PIPE] = ACTIONS(1061),
    [anon_sym_EQ_TILDE] = ACTIONS(1063),
    [anon_sym_EQ_EQ] = ACTIONS(1063),
    [anon_sym_LT] = ACTIONS(1063),
    [anon_sym_GT] = ACTIONS(1063),
    [anon_sym_GT_GT] = ACTIONS(1061),
    [anon_sym_AMP_GT] = ACTIONS(1063),
    [anon_sym_AMP_GT_GT] = ACTIONS(1061),
    [anon_sym_LT_AMP] = ACTIONS(1061),
    [anon_sym_GT_AMP] = ACTIONS(1061),
    [anon_sym_LT_LT] = ACTIONS(1063),
    [anon_sym_LT_LT_DASH] = ACTIONS(1061),
    [anon_sym_LT_LT_LT] = ACTIONS(1061),
    [anon_sym_DOLLAR] = ACTIONS(1063),
    [sym__special_character] = ACTIONS(1061),
    [anon_sym_DQUOTE] = ACTIONS(1061),
    [sym_raw_string] = ACTIONS(1061),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1061),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1061),
    [anon_sym_BQUOTE] = ACTIONS(1061),
    [anon_sym_LT_LPAREN] = ACTIONS(1061),
    [anon_sym_GT_LPAREN] = ACTIONS(1061),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1063),
    [anon_sym_LF] = ACTIONS(1061),
    [anon_sym_AMP] = ACTIONS(1063),
  },
  [364] = {
    [sym_file_descriptor] = ACTIONS(1065),
    [sym__concat] = ACTIONS(1065),
    [anon_sym_SEMI] = ACTIONS(1067),
    [anon_sym_PIPE] = ACTIONS(1067),
    [anon_sym_SEMI_SEMI] = ACTIONS(1065),
    [anon_sym_PIPE_AMP] = ACTIONS(1065),
    [anon_sym_AMP_AMP] = ACTIONS(1065),
    [anon_sym_PIPE_PIPE] = ACTIONS(1065),
    [anon_sym_EQ_TILDE] = ACTIONS(1067),
    [anon_sym_EQ_EQ] = ACTIONS(1067),
    [anon_sym_LT] = ACTIONS(1067),
    [anon_sym_GT] = ACTIONS(1067),
    [anon_sym_GT_GT] = ACTIONS(1065),
    [anon_sym_AMP_GT] = ACTIONS(1067),
    [anon_sym_AMP_GT_GT] = ACTIONS(1065),
    [anon_sym_LT_AMP] = ACTIONS(1065),
    [anon_sym_GT_AMP] = ACTIONS(1065),
    [anon_sym_LT_LT] = ACTIONS(1067),
    [anon_sym_LT_LT_DASH] = ACTIONS(1065),
    [anon_sym_LT_LT_LT] = ACTIONS(1065),
    [anon_sym_DOLLAR] = ACTIONS(1067),
    [sym__special_character] = ACTIONS(1065),
    [anon_sym_DQUOTE] = ACTIONS(1065),
    [sym_raw_string] = ACTIONS(1065),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1065),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1065),
    [anon_sym_BQUOTE] = ACTIONS(1065),
    [anon_sym_LT_LPAREN] = ACTIONS(1065),
    [anon_sym_GT_LPAREN] = ACTIONS(1065),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1067),
    [anon_sym_LF] = ACTIONS(1065),
    [anon_sym_AMP] = ACTIONS(1067),
  },
  [365] = {
    [sym_string] = STATE(901),
    [sym_simple_expansion] = STATE(901),
    [sym_string_expansion] = STATE(901),
    [sym_expansion] = STATE(901),
    [sym_command_substitution] = STATE(901),
    [sym_process_substitution] = STATE(901),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [sym__special_character] = ACTIONS(1711),
    [anon_sym_DQUOTE] = ACTIONS(129),
    [sym_raw_string] = ACTIONS(1711),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(133),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(135),
    [anon_sym_BQUOTE] = ACTIONS(137),
    [anon_sym_LT_LPAREN] = ACTIONS(139),
    [anon_sym_GT_LPAREN] = ACTIONS(139),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1711),
  },
  [366] = {
    [aux_sym_concatenation_repeat1] = STATE(903),
    [sym_file_descriptor] = ACTIONS(1071),
    [sym__concat] = ACTIONS(1713),
    [anon_sym_SEMI] = ACTIONS(1075),
    [anon_sym_PIPE] = ACTIONS(1075),
    [anon_sym_SEMI_SEMI] = ACTIONS(1071),
    [anon_sym_PIPE_AMP] = ACTIONS(1071),
    [anon_sym_AMP_AMP] = ACTIONS(1071),
    [anon_sym_PIPE_PIPE] = ACTIONS(1071),
    [anon_sym_EQ_TILDE] = ACTIONS(1075),
    [anon_sym_EQ_EQ] = ACTIONS(1075),
    [anon_sym_LT] = ACTIONS(1075),
    [anon_sym_GT] = ACTIONS(1075),
    [anon_sym_GT_GT] = ACTIONS(1071),
    [anon_sym_AMP_GT] = ACTIONS(1075),
    [anon_sym_AMP_GT_GT] = ACTIONS(1071),
    [anon_sym_LT_AMP] = ACTIONS(1071),
    [anon_sym_GT_AMP] = ACTIONS(1071),
    [anon_sym_LT_LT] = ACTIONS(1075),
    [anon_sym_LT_LT_DASH] = ACTIONS(1071),
    [anon_sym_LT_LT_LT] = ACTIONS(1071),
    [anon_sym_DOLLAR] = ACTIONS(1075),
    [sym__special_character] = ACTIONS(1071),
    [anon_sym_DQUOTE] = ACTIONS(1071),
    [sym_raw_string] = ACTIONS(1071),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1071),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1071),
    [anon_sym_BQUOTE] = ACTIONS(1071),
    [anon_sym_LT_LPAREN] = ACTIONS(1071),
    [anon_sym_GT_LPAREN] = ACTIONS(1071),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1075),
    [anon_sym_LF] = ACTIONS(1071),
    [anon_sym_AMP] = ACTIONS(1075),
  },
  [367] = {
    [anon_sym_DASH] = ACTIONS(1077),
    [anon_sym_DOLLAR] = ACTIONS(1079),
    [anon_sym_DQUOTE] = ACTIONS(1715),
    [sym__string_content] = ACTIONS(1083),
    [anon_sym_POUND] = ACTIONS(1077),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1085),
    [anon_sym_STAR] = ACTIONS(1087),
    [anon_sym_AT] = ACTIONS(1087),
    [anon_sym_QMARK] = ACTIONS(1087),
    [anon_sym_0] = ACTIONS(1085),
    [anon_sym__] = ACTIONS(1085),
  },
  [368] = {
    [sym_file_descriptor] = ACTIONS(1089),
    [sym__concat] = ACTIONS(1089),
    [anon_sym_SEMI] = ACTIONS(1091),
    [anon_sym_PIPE] = ACTIONS(1091),
    [anon_sym_SEMI_SEMI] = ACTIONS(1089),
    [anon_sym_PIPE_AMP] = ACTIONS(1089),
    [anon_sym_AMP_AMP] = ACTIONS(1089),
    [anon_sym_PIPE_PIPE] = ACTIONS(1089),
    [anon_sym_EQ_TILDE] = ACTIONS(1091),
    [anon_sym_EQ_EQ] = ACTIONS(1091),
    [anon_sym_LT] = ACTIONS(1091),
    [anon_sym_GT] = ACTIONS(1091),
    [anon_sym_GT_GT] = ACTIONS(1089),
    [anon_sym_AMP_GT] = ACTIONS(1091),
    [anon_sym_AMP_GT_GT] = ACTIONS(1089),
    [anon_sym_LT_AMP] = ACTIONS(1089),
    [anon_sym_GT_AMP] = ACTIONS(1089),
    [anon_sym_LT_LT] = ACTIONS(1091),
    [anon_sym_LT_LT_DASH] = ACTIONS(1089),
    [anon_sym_LT_LT_LT] = ACTIONS(1089),
    [anon_sym_DOLLAR] = ACTIONS(1091),
    [sym__special_character] = ACTIONS(1089),
    [anon_sym_DQUOTE] = ACTIONS(1089),
    [sym_raw_string] = ACTIONS(1089),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1089),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1089),
    [anon_sym_BQUOTE] = ACTIONS(1089),
    [anon_sym_LT_LPAREN] = ACTIONS(1089),
    [anon_sym_GT_LPAREN] = ACTIONS(1089),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1091),
    [anon_sym_LF] = ACTIONS(1089),
    [anon_sym_AMP] = ACTIONS(1091),
  },
  [369] = {
    [sym_simple_expansion] = STATE(204),
    [sym_expansion] = STATE(204),
    [sym_command_substitution] = STATE(204),
    [aux_sym_string_repeat1] = STATE(627),
    [anon_sym_DOLLAR] = ACTIONS(1717),
    [anon_sym_DQUOTE] = ACTIONS(1715),
    [sym__string_content] = ACTIONS(345),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(347),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(329),
  },
  [370] = {
    [anon_sym_LBRACK] = ACTIONS(1111),
    [anon_sym_EQ] = ACTIONS(1719),
    [sym_comment] = ACTIONS(57),
  },
  [371] = {
    [sym_subscript] = STATE(909),
    [sym_variable_name] = ACTIONS(1721),
    [anon_sym_DASH] = ACTIONS(1723),
    [anon_sym_DOLLAR] = ACTIONS(1723),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1725),
    [anon_sym_STAR] = ACTIONS(1727),
    [anon_sym_AT] = ACTIONS(1727),
    [anon_sym_QMARK] = ACTIONS(1727),
    [anon_sym_0] = ACTIONS(1725),
    [anon_sym__] = ACTIONS(1725),
  },
  [372] = {
    [sym_concatenation] = STATE(912),
    [sym_string] = STATE(637),
    [sym_simple_expansion] = STATE(637),
    [sym_string_expansion] = STATE(637),
    [sym_expansion] = STATE(637),
    [sym_command_substitution] = STATE(637),
    [sym_process_substitution] = STATE(637),
    [aux_sym__literal_repeat1] = STATE(643),
    [aux_sym_expansion_repeat1] = STATE(912),
    [anon_sym_RBRACE] = ACTIONS(1729),
    [anon_sym_EQ] = ACTIONS(1731),
    [anon_sym_DASH] = ACTIONS(1731),
    [anon_sym_DOLLAR] = ACTIONS(1127),
    [sym__special_character] = ACTIONS(1129),
    [anon_sym_DQUOTE] = ACTIONS(1131),
    [sym_raw_string] = ACTIONS(1133),
    [anon_sym_POUND] = ACTIONS(1733),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1137),
    [anon_sym_SLASH] = ACTIONS(1735),
    [anon_sym_COLON] = ACTIONS(1731),
    [anon_sym_COLON_QMARK] = ACTIONS(1731),
    [anon_sym_COLON_DASH] = ACTIONS(1731),
    [anon_sym_PERCENT] = ACTIONS(1731),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1141),
    [anon_sym_BQUOTE] = ACTIONS(1143),
    [anon_sym_LT_LPAREN] = ACTIONS(1145),
    [anon_sym_GT_LPAREN] = ACTIONS(1145),
    [sym_comment] = ACTIONS(329),
    [sym_word] = ACTIONS(1147),
  },
  [373] = {
    [sym_concatenation] = STATE(915),
    [sym_string] = STATE(637),
    [sym_simple_expansion] = STATE(637),
    [sym_string_expansion] = STATE(637),
    [sym_expansion] = STATE(637),
    [sym_command_substitution] = STATE(637),
    [sym_process_substitution] = STATE(637),
    [aux_sym__literal_repeat1] = STATE(643),
    [aux_sym_expansion_repeat1] = STATE(915),
    [anon_sym_RBRACE] = ACTIONS(1737),
    [anon_sym_EQ] = ACTIONS(1739),
    [anon_sym_DASH] = ACTIONS(1739),
    [anon_sym_DOLLAR] = ACTIONS(1127),
    [sym__special_character] = ACTIONS(1129),
    [anon_sym_DQUOTE] = ACTIONS(1131),
    [sym_raw_string] = ACTIONS(1133),
    [anon_sym_POUND] = ACTIONS(1741),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1137),
    [anon_sym_SLASH] = ACTIONS(1743),
    [anon_sym_COLON] = ACTIONS(1739),
    [anon_sym_COLON_QMARK] = ACTIONS(1739),
    [anon_sym_COLON_DASH] = ACTIONS(1739),
    [anon_sym_PERCENT] = ACTIONS(1739),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1141),
    [anon_sym_BQUOTE] = ACTIONS(1143),
    [anon_sym_LT_LPAREN] = ACTIONS(1145),
    [anon_sym_GT_LPAREN] = ACTIONS(1145),
    [sym_comment] = ACTIONS(329),
    [sym_word] = ACTIONS(1147),
  },
  [374] = {
    [anon_sym_RPAREN] = ACTIONS(1745),
    [sym_comment] = ACTIONS(57),
  },
  [375] = {
    [sym_file_descriptor] = ACTIONS(433),
    [sym_variable_name] = ACTIONS(433),
    [anon_sym_RPAREN] = ACTIONS(1745),
    [anon_sym_LT] = ACTIONS(435),
    [anon_sym_GT] = ACTIONS(435),
    [anon_sym_GT_GT] = ACTIONS(433),
    [anon_sym_AMP_GT] = ACTIONS(435),
    [anon_sym_AMP_GT_GT] = ACTIONS(433),
    [anon_sym_LT_AMP] = ACTIONS(433),
    [anon_sym_GT_AMP] = ACTIONS(433),
    [anon_sym_DOLLAR] = ACTIONS(435),
    [sym__special_character] = ACTIONS(433),
    [anon_sym_DQUOTE] = ACTIONS(433),
    [sym_raw_string] = ACTIONS(433),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(433),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(433),
    [anon_sym_BQUOTE] = ACTIONS(433),
    [anon_sym_LT_LPAREN] = ACTIONS(433),
    [anon_sym_GT_LPAREN] = ACTIONS(433),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(433),
  },
  [376] = {
    [anon_sym_BQUOTE] = ACTIONS(1745),
    [sym_comment] = ACTIONS(57),
  },
  [377] = {
    [anon_sym_RPAREN] = ACTIONS(1747),
    [sym_comment] = ACTIONS(57),
  },
  [378] = {
    [anon_sym_RPAREN] = ACTIONS(1749),
    [sym_comment] = ACTIONS(57),
  },
  [379] = {
    [sym__statements] = STATE(933),
    [sym_redirected_statement] = STATE(934),
    [sym_for_statement] = STATE(934),
    [sym_c_style_for_statement] = STATE(934),
    [sym_while_statement] = STATE(934),
    [sym_if_statement] = STATE(934),
    [sym_case_statement] = STATE(934),
    [sym_function_definition] = STATE(934),
    [sym_compound_statement] = STATE(934),
    [sym_subshell] = STATE(934),
    [sym_pipeline] = STATE(934),
    [sym_list] = STATE(934),
    [sym_negated_command] = STATE(934),
    [sym_test_command] = STATE(934),
    [sym_declaration_command] = STATE(934),
    [sym_unset_command] = STATE(934),
    [sym_command] = STATE(934),
    [sym_command_name] = STATE(935),
    [sym_variable_assignment] = STATE(936),
    [sym_subscript] = STATE(937),
    [sym_file_redirect] = STATE(940),
    [sym_concatenation] = STATE(938),
    [sym_string] = STATE(927),
    [sym_simple_expansion] = STATE(927),
    [sym_string_expansion] = STATE(927),
    [sym_expansion] = STATE(927),
    [sym_command_substitution] = STATE(927),
    [sym_process_substitution] = STATE(927),
    [aux_sym__statements_repeat1] = STATE(939),
    [aux_sym_command_repeat1] = STATE(940),
    [aux_sym__literal_repeat1] = STATE(941),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(1751),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_done] = ACTIONS(1753),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(1755),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(1757),
    [anon_sym_typeset] = ACTIONS(1757),
    [anon_sym_export] = ACTIONS(1757),
    [anon_sym_readonly] = ACTIONS(1757),
    [anon_sym_local] = ACTIONS(1757),
    [anon_sym_unset] = ACTIONS(1759),
    [anon_sym_unsetenv] = ACTIONS(1759),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(1761),
    [sym__special_character] = ACTIONS(1763),
    [anon_sym_DQUOTE] = ACTIONS(1765),
    [sym_raw_string] = ACTIONS(1767),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1769),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1771),
    [anon_sym_BQUOTE] = ACTIONS(1773),
    [anon_sym_LT_LPAREN] = ACTIONS(1775),
    [anon_sym_GT_LPAREN] = ACTIONS(1775),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1777),
  },
  [380] = {
    [sym__simple_heredoc_body] = ACTIONS(1779),
    [sym__heredoc_body_beginning] = ACTIONS(1779),
    [sym_file_descriptor] = ACTIONS(1779),
    [ts_builtin_sym_end] = ACTIONS(1779),
    [anon_sym_SEMI] = ACTIONS(1781),
    [anon_sym_done] = ACTIONS(1779),
    [anon_sym_fi] = ACTIONS(1779),
    [anon_sym_elif] = ACTIONS(1779),
    [anon_sym_else] = ACTIONS(1779),
    [anon_sym_esac] = ACTIONS(1779),
    [anon_sym_PIPE] = ACTIONS(1781),
    [anon_sym_RPAREN] = ACTIONS(1779),
    [anon_sym_SEMI_SEMI] = ACTIONS(1779),
    [anon_sym_PIPE_AMP] = ACTIONS(1779),
    [anon_sym_AMP_AMP] = ACTIONS(1779),
    [anon_sym_PIPE_PIPE] = ACTIONS(1779),
    [anon_sym_LT] = ACTIONS(1781),
    [anon_sym_GT] = ACTIONS(1781),
    [anon_sym_GT_GT] = ACTIONS(1779),
    [anon_sym_AMP_GT] = ACTIONS(1781),
    [anon_sym_AMP_GT_GT] = ACTIONS(1779),
    [anon_sym_LT_AMP] = ACTIONS(1779),
    [anon_sym_GT_AMP] = ACTIONS(1779),
    [anon_sym_LT_LT] = ACTIONS(1781),
    [anon_sym_LT_LT_DASH] = ACTIONS(1779),
    [anon_sym_LT_LT_LT] = ACTIONS(1779),
    [anon_sym_BQUOTE] = ACTIONS(1779),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(1779),
    [anon_sym_AMP] = ACTIONS(1781),
  },
  [381] = {
    [anon_sym_LT] = ACTIONS(1783),
    [anon_sym_GT] = ACTIONS(1783),
    [anon_sym_GT_GT] = ACTIONS(1785),
    [anon_sym_AMP_GT] = ACTIONS(1783),
    [anon_sym_AMP_GT_GT] = ACTIONS(1785),
    [anon_sym_LT_AMP] = ACTIONS(1785),
    [anon_sym_GT_AMP] = ACTIONS(1785),
    [sym_comment] = ACTIONS(57),
  },
  [382] = {
    [anon_sym_do] = ACTIONS(1787),
    [anon_sym_then] = ACTIONS(1787),
    [sym_comment] = ACTIONS(57),
  },
  [383] = {
    [sym_redirected_statement] = STATE(943),
    [sym_for_statement] = STATE(943),
    [sym_c_style_for_statement] = STATE(943),
    [sym_while_statement] = STATE(943),
    [sym_if_statement] = STATE(943),
    [sym_case_statement] = STATE(943),
    [sym_function_definition] = STATE(943),
    [sym_compound_statement] = STATE(943),
    [sym_subshell] = STATE(943),
    [sym_pipeline] = STATE(943),
    [sym_list] = STATE(943),
    [sym_negated_command] = STATE(943),
    [sym_test_command] = STATE(943),
    [sym_declaration_command] = STATE(943),
    [sym_unset_command] = STATE(943),
    [sym_command] = STATE(943),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(944),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(83),
    [sym_concatenation] = STATE(82),
    [sym_string] = STATE(71),
    [sym_simple_expansion] = STATE(71),
    [sym_string_expansion] = STATE(71),
    [sym_expansion] = STATE(71),
    [sym_command_substitution] = STATE(71),
    [sym_process_substitution] = STATE(71),
    [aux_sym_command_repeat1] = STATE(83),
    [aux_sym__literal_repeat1] = STATE(84),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(103),
    [anon_sym_if] = ACTIONS(105),
    [anon_sym_case] = ACTIONS(107),
    [anon_sym_function] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [sym__special_character] = ACTIONS(127),
    [anon_sym_DQUOTE] = ACTIONS(129),
    [sym_raw_string] = ACTIONS(131),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(133),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(135),
    [anon_sym_BQUOTE] = ACTIONS(137),
    [anon_sym_LT_LPAREN] = ACTIONS(139),
    [anon_sym_GT_LPAREN] = ACTIONS(139),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(141),
  },
  [384] = {
    [sym_redirected_statement] = STATE(945),
    [sym_for_statement] = STATE(945),
    [sym_c_style_for_statement] = STATE(945),
    [sym_while_statement] = STATE(945),
    [sym_if_statement] = STATE(945),
    [sym_case_statement] = STATE(945),
    [sym_function_definition] = STATE(945),
    [sym_compound_statement] = STATE(945),
    [sym_subshell] = STATE(945),
    [sym_pipeline] = STATE(945),
    [sym_list] = STATE(945),
    [sym_negated_command] = STATE(945),
    [sym_test_command] = STATE(945),
    [sym_declaration_command] = STATE(945),
    [sym_unset_command] = STATE(945),
    [sym_command] = STATE(945),
    [sym_command_name] = STATE(79),
    [sym_variable_assignment] = STATE(946),
    [sym_subscript] = STATE(81),
    [sym_file_redirect] = STATE(83),
    [sym_concatenation] = STATE(82),
    [sym_string] = STATE(71),
    [sym_simple_expansion] = STATE(71),
    [sym_string_expansion] = STATE(71),
    [sym_expansion] = STATE(71),
    [sym_command_substitution] = STATE(71),
    [sym_process_substitution] = STATE(71),
    [aux_sym_command_repeat1] = STATE(83),
    [aux_sym__literal_repeat1] = STATE(84),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(97),
    [anon_sym_for] = ACTIONS(99),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(101),
    [anon_sym_while] = ACTIONS(103),
    [anon_sym_if] = ACTIONS(105),
    [anon_sym_case] = ACTIONS(107),
    [anon_sym_function] = ACTIONS(109),
    [anon_sym_LPAREN] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(113),
    [anon_sym_BANG] = ACTIONS(115),
    [anon_sym_LBRACK] = ACTIONS(117),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(119),
    [anon_sym_declare] = ACTIONS(121),
    [anon_sym_typeset] = ACTIONS(121),
    [anon_sym_export] = ACTIONS(121),
    [anon_sym_readonly] = ACTIONS(121),
    [anon_sym_local] = ACTIONS(121),
    [anon_sym_unset] = ACTIONS(123),
    [anon_sym_unsetenv] = ACTIONS(123),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [sym__special_character] = ACTIONS(127),
    [anon_sym_DQUOTE] = ACTIONS(129),
    [sym_raw_string] = ACTIONS(131),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(133),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(135),
    [anon_sym_BQUOTE] = ACTIONS(137),
    [anon_sym_LT_LPAREN] = ACTIONS(139),
    [anon_sym_GT_LPAREN] = ACTIONS(139),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(141),
  },
  [385] = {
    [sym_concatenation] = STATE(949),
    [sym_string] = STATE(948),
    [sym_simple_expansion] = STATE(948),
    [sym_string_expansion] = STATE(948),
    [sym_expansion] = STATE(948),
    [sym_command_substitution] = STATE(948),
    [sym_process_substitution] = STATE(948),
    [aux_sym__literal_repeat1] = STATE(950),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [sym__special_character] = ACTIONS(1789),
    [anon_sym_DQUOTE] = ACTIONS(129),
    [sym_raw_string] = ACTIONS(1791),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(133),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(135),
    [anon_sym_BQUOTE] = ACTIONS(137),
    [anon_sym_LT_LPAREN] = ACTIONS(139),
    [anon_sym_GT_LPAREN] = ACTIONS(139),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1791),
  },
  [386] = {
    [sym_heredoc_start] = ACTIONS(1793),
    [sym_comment] = ACTIONS(57),
  },
  [387] = {
    [sym_concatenation] = STATE(953),
    [sym_string] = STATE(952),
    [sym_simple_expansion] = STATE(952),
    [sym_string_expansion] = STATE(952),
    [sym_expansion] = STATE(952),
    [sym_command_substitution] = STATE(952),
    [sym_process_substitution] = STATE(952),
    [aux_sym__literal_repeat1] = STATE(954),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [sym__special_character] = ACTIONS(1789),
    [anon_sym_DQUOTE] = ACTIONS(129),
    [sym_raw_string] = ACTIONS(1795),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(133),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(135),
    [anon_sym_BQUOTE] = ACTIONS(137),
    [anon_sym_LT_LPAREN] = ACTIONS(139),
    [anon_sym_GT_LPAREN] = ACTIONS(139),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1795),
  },
  [388] = {
    [sym_file_redirect] = STATE(955),
    [sym_heredoc_redirect] = STATE(955),
    [sym_herestring_redirect] = STATE(955),
    [aux_sym_redirected_statement_repeat1] = STATE(955),
    [sym_file_descriptor] = ACTIONS(653),
    [anon_sym_SEMI] = ACTIONS(1257),
    [anon_sym_PIPE] = ACTIONS(1257),
    [anon_sym_SEMI_SEMI] = ACTIONS(1255),
    [anon_sym_PIPE_AMP] = ACTIONS(1255),
    [anon_sym_AMP_AMP] = ACTIONS(1255),
    [anon_sym_PIPE_PIPE] = ACTIONS(1255),
    [anon_sym_LT] = ACTIONS(665),
    [anon_sym_GT] = ACTIONS(665),
    [anon_sym_GT_GT] = ACTIONS(667),
    [anon_sym_AMP_GT] = ACTIONS(665),
    [anon_sym_AMP_GT_GT] = ACTIONS(667),
    [anon_sym_LT_AMP] = ACTIONS(667),
    [anon_sym_GT_AMP] = ACTIONS(667),
    [anon_sym_LT_LT] = ACTIONS(669),
    [anon_sym_LT_LT_DASH] = ACTIONS(671),
    [anon_sym_LT_LT_LT] = ACTIONS(673),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(1255),
    [anon_sym_AMP] = ACTIONS(1257),
  },
  [389] = {
    [sym_concatenation] = STATE(956),
    [sym_string] = STATE(957),
    [sym_simple_expansion] = STATE(957),
    [sym_string_expansion] = STATE(957),
    [sym_expansion] = STATE(957),
    [sym_command_substitution] = STATE(957),
    [sym_process_substitution] = STATE(957),
    [aux_sym__literal_repeat1] = STATE(958),
    [sym_regex] = ACTIONS(1797),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [sym__special_character] = ACTIONS(677),
    [anon_sym_DQUOTE] = ACTIONS(129),
    [sym_raw_string] = ACTIONS(1799),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(133),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(135),
    [anon_sym_BQUOTE] = ACTIONS(137),
    [anon_sym_LT_LPAREN] = ACTIONS(139),
    [anon_sym_GT_LPAREN] = ACTIONS(139),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1799),
  },
  [390] = {
    [aux_sym_concatenation_repeat1] = STATE(366),
    [sym_file_descriptor] = ACTIONS(1263),
    [sym__concat] = ACTIONS(633),
    [anon_sym_SEMI] = ACTIONS(1265),
    [anon_sym_PIPE] = ACTIONS(1265),
    [anon_sym_SEMI_SEMI] = ACTIONS(1263),
    [anon_sym_PIPE_AMP] = ACTIONS(1263),
    [anon_sym_AMP_AMP] = ACTIONS(1263),
    [anon_sym_PIPE_PIPE] = ACTIONS(1263),
    [anon_sym_EQ_TILDE] = ACTIONS(1265),
    [anon_sym_EQ_EQ] = ACTIONS(1265),
    [anon_sym_LT] = ACTIONS(1265),
    [anon_sym_GT] = ACTIONS(1265),
    [anon_sym_GT_GT] = ACTIONS(1263),
    [anon_sym_AMP_GT] = ACTIONS(1265),
    [anon_sym_AMP_GT_GT] = ACTIONS(1263),
    [anon_sym_LT_AMP] = ACTIONS(1263),
    [anon_sym_GT_AMP] = ACTIONS(1263),
    [anon_sym_LT_LT] = ACTIONS(1265),
    [anon_sym_LT_LT_DASH] = ACTIONS(1263),
    [anon_sym_LT_LT_LT] = ACTIONS(1263),
    [anon_sym_DOLLAR] = ACTIONS(1265),
    [sym__special_character] = ACTIONS(1263),
    [anon_sym_DQUOTE] = ACTIONS(1263),
    [sym_raw_string] = ACTIONS(1263),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1263),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1263),
    [anon_sym_BQUOTE] = ACTIONS(1263),
    [anon_sym_LT_LPAREN] = ACTIONS(1263),
    [anon_sym_GT_LPAREN] = ACTIONS(1263),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1265),
    [anon_sym_LF] = ACTIONS(1263),
    [anon_sym_AMP] = ACTIONS(1265),
  },
  [391] = {
    [sym_concatenation] = STATE(959),
    [sym_string] = STATE(390),
    [sym_simple_expansion] = STATE(390),
    [sym_string_expansion] = STATE(390),
    [sym_expansion] = STATE(390),
    [sym_command_substitution] = STATE(390),
    [sym_process_substitution] = STATE(390),
    [aux_sym_command_repeat2] = STATE(959),
    [aux_sym__literal_repeat1] = STATE(392),
    [sym_file_descriptor] = ACTIONS(1267),
    [anon_sym_SEMI] = ACTIONS(1269),
    [anon_sym_PIPE] = ACTIONS(1269),
    [anon_sym_SEMI_SEMI] = ACTIONS(1267),
    [anon_sym_PIPE_AMP] = ACTIONS(1267),
    [anon_sym_AMP_AMP] = ACTIONS(1267),
    [anon_sym_PIPE_PIPE] = ACTIONS(1267),
    [anon_sym_EQ_TILDE] = ACTIONS(675),
    [anon_sym_EQ_EQ] = ACTIONS(675),
    [anon_sym_LT] = ACTIONS(1269),
    [anon_sym_GT] = ACTIONS(1269),
    [anon_sym_GT_GT] = ACTIONS(1267),
    [anon_sym_AMP_GT] = ACTIONS(1269),
    [anon_sym_AMP_GT_GT] = ACTIONS(1267),
    [anon_sym_LT_AMP] = ACTIONS(1267),
    [anon_sym_GT_AMP] = ACTIONS(1267),
    [anon_sym_LT_LT] = ACTIONS(1269),
    [anon_sym_LT_LT_DASH] = ACTIONS(1267),
    [anon_sym_LT_LT_LT] = ACTIONS(1267),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [sym__special_character] = ACTIONS(677),
    [anon_sym_DQUOTE] = ACTIONS(129),
    [sym_raw_string] = ACTIONS(679),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(133),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(135),
    [anon_sym_BQUOTE] = ACTIONS(137),
    [anon_sym_LT_LPAREN] = ACTIONS(139),
    [anon_sym_GT_LPAREN] = ACTIONS(139),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(681),
    [anon_sym_LF] = ACTIONS(1267),
    [anon_sym_AMP] = ACTIONS(1269),
  },
  [392] = {
    [aux_sym__literal_repeat1] = STATE(395),
    [sym_file_descriptor] = ACTIONS(1271),
    [anon_sym_SEMI] = ACTIONS(1273),
    [anon_sym_PIPE] = ACTIONS(1273),
    [anon_sym_SEMI_SEMI] = ACTIONS(1271),
    [anon_sym_PIPE_AMP] = ACTIONS(1271),
    [anon_sym_AMP_AMP] = ACTIONS(1271),
    [anon_sym_PIPE_PIPE] = ACTIONS(1271),
    [anon_sym_EQ_TILDE] = ACTIONS(1273),
    [anon_sym_EQ_EQ] = ACTIONS(1273),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_GT] = ACTIONS(1273),
    [anon_sym_GT_GT] = ACTIONS(1271),
    [anon_sym_AMP_GT] = ACTIONS(1273),
    [anon_sym_AMP_GT_GT] = ACTIONS(1271),
    [anon_sym_LT_AMP] = ACTIONS(1271),
    [anon_sym_GT_AMP] = ACTIONS(1271),
    [anon_sym_LT_LT] = ACTIONS(1273),
    [anon_sym_LT_LT_DASH] = ACTIONS(1271),
    [anon_sym_LT_LT_LT] = ACTIONS(1271),
    [anon_sym_DOLLAR] = ACTIONS(1273),
    [sym__special_character] = ACTIONS(683),
    [anon_sym_DQUOTE] = ACTIONS(1271),
    [sym_raw_string] = ACTIONS(1271),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1271),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1271),
    [anon_sym_BQUOTE] = ACTIONS(1271),
    [anon_sym_LT_LPAREN] = ACTIONS(1271),
    [anon_sym_GT_LPAREN] = ACTIONS(1271),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1273),
    [anon_sym_LF] = ACTIONS(1271),
    [anon_sym_AMP] = ACTIONS(1273),
  },
  [393] = {
    [sym_concatenation] = STATE(960),
    [sym_string] = STATE(390),
    [sym_simple_expansion] = STATE(390),
    [sym_string_expansion] = STATE(390),
    [sym_expansion] = STATE(390),
    [sym_command_substitution] = STATE(390),
    [sym_process_substitution] = STATE(390),
    [aux_sym_command_repeat2] = STATE(960),
    [aux_sym__literal_repeat1] = STATE(392),
    [sym_file_descriptor] = ACTIONS(1267),
    [anon_sym_SEMI] = ACTIONS(1269),
    [anon_sym_PIPE] = ACTIONS(1269),
    [anon_sym_SEMI_SEMI] = ACTIONS(1267),
    [anon_sym_PIPE_AMP] = ACTIONS(1267),
    [anon_sym_AMP_AMP] = ACTIONS(1267),
    [anon_sym_PIPE_PIPE] = ACTIONS(1267),
    [anon_sym_EQ_TILDE] = ACTIONS(675),
    [anon_sym_EQ_EQ] = ACTIONS(675),
    [anon_sym_LT] = ACTIONS(1269),
    [anon_sym_GT] = ACTIONS(1269),
    [anon_sym_GT_GT] = ACTIONS(1267),
    [anon_sym_AMP_GT] = ACTIONS(1269),
    [anon_sym_AMP_GT_GT] = ACTIONS(1267),
    [anon_sym_LT_AMP] = ACTIONS(1267),
    [anon_sym_GT_AMP] = ACTIONS(1267),
    [anon_sym_LT_LT] = ACTIONS(1269),
    [anon_sym_LT_LT_DASH] = ACTIONS(1267),
    [anon_sym_LT_LT_LT] = ACTIONS(1267),
    [anon_sym_DOLLAR] = ACTIONS(125),
    [sym__special_character] = ACTIONS(677),
    [anon_sym_DQUOTE] = ACTIONS(129),
    [sym_raw_string] = ACTIONS(679),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(133),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(135),
    [anon_sym_BQUOTE] = ACTIONS(137),
    [anon_sym_LT_LPAREN] = ACTIONS(139),
    [anon_sym_GT_LPAREN] = ACTIONS(139),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(681),
    [anon_sym_LF] = ACTIONS(1267),
    [anon_sym_AMP] = ACTIONS(1269),
  },
  [394] = {
    [sym_file_descriptor] = ACTIONS(335),
    [anon_sym_SEMI] = ACTIONS(339),
    [anon_sym_PIPE] = ACTIONS(339),
    [anon_sym_SEMI_SEMI] = ACTIONS(335),
    [anon_sym_PIPE_AMP] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_PIPE_PIPE] = ACTIONS(335),
    [anon_sym_EQ_TILDE] = ACTIONS(339),
    [anon_sym_EQ_EQ] = ACTIONS(339),
    [anon_sym_LT] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(339),
    [anon_sym_GT_GT] = ACTIONS(335),
    [anon_sym_AMP_GT] = ACTIONS(339),
    [anon_sym_AMP_GT_GT] = ACTIONS(335),
    [anon_sym_LT_AMP] = ACTIONS(335),
    [anon_sym_GT_AMP] = ACTIONS(335),
    [anon_sym_LT_LT] = ACTIONS(339),
    [anon_sym_LT_LT_DASH] = ACTIONS(335),
    [anon_sym_LT_LT_LT] = ACTIONS(335),
    [anon_sym_DOLLAR] = ACTIONS(339),
    [sym__special_character] = ACTIONS(335),
    [anon_sym_DQUOTE] = ACTIONS(335),
    [sym_raw_string] = ACTIONS(335),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(335),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(335),
    [anon_sym_LT_LPAREN] = ACTIONS(335),
    [anon_sym_GT_LPAREN] = ACTIONS(335),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(339),
    [anon_sym_LF] = ACTIONS(335),
    [anon_sym_AMP] = ACTIONS(339),
  },
  [395] = {
    [aux_sym__literal_repeat1] = STATE(395),
    [sym_file_descriptor] = ACTIONS(1373),
    [anon_sym_SEMI] = ACTIONS(1375),
    [anon_sym_PIPE] = ACTIONS(1375),
    [anon_sym_SEMI_SEMI] = ACTIONS(1373),
    [anon_sym_PIPE_AMP] = ACTIONS(1373),
    [anon_sym_AMP_AMP] = ACTIONS(1373),
    [anon_sym_PIPE_PIPE] = ACTIONS(1373),
    [anon_sym_EQ_TILDE] = ACTIONS(1375),
    [anon_sym_EQ_EQ] = ACTIONS(1375),
    [anon_sym_LT] = ACTIONS(1375),
    [anon_sym_GT] = ACTIONS(1375),
    [anon_sym_GT_GT] = ACTIONS(1373),
    [anon_sym_AMP_GT] = ACTIONS(1375),
    [anon_sym_AMP_GT_GT] = ACTIONS(1373),
    [anon_sym_LT_AMP] = ACTIONS(1373),
    [anon_sym_GT_AMP] = ACTIONS(1373),
    [anon_sym_LT_LT] = ACTIONS(1375),
    [anon_sym_LT_LT_DASH] = ACTIONS(1373),
    [anon_sym_LT_LT_LT] = ACTIONS(1373),
    [anon_sym_DOLLAR] = ACTIONS(1375),
    [sym__special_character] = ACTIONS(1801),
    [anon_sym_DQUOTE] = ACTIONS(1373),
    [sym_raw_string] = ACTIONS(1373),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1373),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1373),
    [anon_sym_BQUOTE] = ACTIONS(1373),
    [anon_sym_LT_LPAREN] = ACTIONS(1373),
    [anon_sym_GT_LPAREN] = ACTIONS(1373),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1375),
    [anon_sym_LF] = ACTIONS(1373),
    [anon_sym_AMP] = ACTIONS(1375),
  },
  [396] = {
    [sym__statements] = STATE(977),
    [sym_redirected_statement] = STATE(978),
    [sym_for_statement] = STATE(978),
    [sym_c_style_for_statement] = STATE(978),
    [sym_while_statement] = STATE(978),
    [sym_if_statement] = STATE(978),
    [sym_elif_clause] = STATE(985),
    [sym_else_clause] = STATE(979),
    [sym_case_statement] = STATE(978),
    [sym_function_definition] = STATE(978),
    [sym_compound_statement] = STATE(978),
    [sym_subshell] = STATE(978),
    [sym_pipeline] = STATE(978),
    [sym_list] = STATE(978),
    [sym_negated_command] = STATE(978),
    [sym_test_command] = STATE(978),
    [sym_declaration_command] = STATE(978),
    [sym_unset_command] = STATE(978),
    [sym_command] = STATE(978),
    [sym_command_name] = STATE(980),
    [sym_variable_assignment] = STATE(981),
    [sym_subscript] = STATE(982),
    [sym_file_redirect] = STATE(986),
    [sym_concatenation] = STATE(983),
    [sym_string] = STATE(971),
    [sym_simple_expansion] = STATE(971),
    [sym_string_expansion] = STATE(971),
    [sym_expansion] = STATE(971),
    [sym_command_substitution] = STATE(971),
    [sym_process_substitution] = STATE(971),
    [aux_sym__statements_repeat1] = STATE(984),
    [aux_sym_if_statement_repeat1] = STATE(985),
    [aux_sym_command_repeat1] = STATE(986),
    [aux_sym__literal_repeat1] = STATE(987),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(1804),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_fi] = ACTIONS(1806),
    [anon_sym_elif] = ACTIONS(1808),
    [anon_sym_else] = ACTIONS(1810),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(1812),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(1814),
    [anon_sym_typeset] = ACTIONS(1814),
    [anon_sym_export] = ACTIONS(1814),
    [anon_sym_readonly] = ACTIONS(1814),
    [anon_sym_local] = ACTIONS(1814),
    [anon_sym_unset] = ACTIONS(1816),
    [anon_sym_unsetenv] = ACTIONS(1816),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(1818),
    [sym__special_character] = ACTIONS(1820),
    [anon_sym_DQUOTE] = ACTIONS(1822),
    [sym_raw_string] = ACTIONS(1824),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1826),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1828),
    [anon_sym_BQUOTE] = ACTIONS(1830),
    [anon_sym_LT_LPAREN] = ACTIONS(1832),
    [anon_sym_GT_LPAREN] = ACTIONS(1832),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1834),
  },
  [397] = {
    [sym__concat] = ACTIONS(1057),
    [anon_sym_in] = ACTIONS(1057),
    [anon_sym_SEMI] = ACTIONS(1059),
    [anon_sym_SEMI_SEMI] = ACTIONS(1057),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(1057),
    [anon_sym_AMP] = ACTIONS(1057),
  },
  [398] = {
    [sym__concat] = ACTIONS(1061),
    [anon_sym_in] = ACTIONS(1061),
    [anon_sym_SEMI] = ACTIONS(1063),
    [anon_sym_SEMI_SEMI] = ACTIONS(1061),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(1061),
    [anon_sym_AMP] = ACTIONS(1061),
  },
  [399] = {
    [sym__concat] = ACTIONS(1065),
    [anon_sym_in] = ACTIONS(1065),
    [anon_sym_SEMI] = ACTIONS(1067),
    [anon_sym_SEMI_SEMI] = ACTIONS(1065),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(1065),
    [anon_sym_AMP] = ACTIONS(1065),
  },
  [400] = {
    [sym_string] = STATE(988),
    [sym_simple_expansion] = STATE(988),
    [sym_string_expansion] = STATE(988),
    [sym_expansion] = STATE(988),
    [sym_command_substitution] = STATE(988),
    [sym_process_substitution] = STATE(988),
    [anon_sym_DOLLAR] = ACTIONS(143),
    [sym__special_character] = ACTIONS(1836),
    [anon_sym_DQUOTE] = ACTIONS(147),
    [sym_raw_string] = ACTIONS(1836),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(151),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(153),
    [anon_sym_BQUOTE] = ACTIONS(155),
    [anon_sym_LT_LPAREN] = ACTIONS(157),
    [anon_sym_GT_LPAREN] = ACTIONS(157),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1836),
  },
  [401] = {
    [aux_sym_concatenation_repeat1] = STATE(990),
    [sym__concat] = ACTIONS(1838),
    [anon_sym_in] = ACTIONS(1071),
    [anon_sym_SEMI] = ACTIONS(1075),
    [anon_sym_SEMI_SEMI] = ACTIONS(1071),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(1071),
    [anon_sym_AMP] = ACTIONS(1071),
  },
  [402] = {
    [anon_sym_DASH] = ACTIONS(1077),
    [anon_sym_DOLLAR] = ACTIONS(1079),
    [anon_sym_DQUOTE] = ACTIONS(1840),
    [sym__string_content] = ACTIONS(1083),
    [anon_sym_POUND] = ACTIONS(1077),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1085),
    [anon_sym_STAR] = ACTIONS(1087),
    [anon_sym_AT] = ACTIONS(1087),
    [anon_sym_QMARK] = ACTIONS(1087),
    [anon_sym_0] = ACTIONS(1085),
    [anon_sym__] = ACTIONS(1085),
  },
  [403] = {
    [sym__concat] = ACTIONS(1089),
    [anon_sym_in] = ACTIONS(1089),
    [anon_sym_SEMI] = ACTIONS(1091),
    [anon_sym_SEMI_SEMI] = ACTIONS(1089),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(1089),
    [anon_sym_AMP] = ACTIONS(1089),
  },
  [404] = {
    [sym_simple_expansion] = STATE(204),
    [sym_expansion] = STATE(204),
    [sym_command_substitution] = STATE(204),
    [aux_sym_string_repeat1] = STATE(627),
    [anon_sym_DOLLAR] = ACTIONS(1842),
    [anon_sym_DQUOTE] = ACTIONS(1840),
    [sym__string_content] = ACTIONS(345),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(347),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(329),
  },
  [405] = {
    [anon_sym_SEMI] = ACTIONS(1844),
    [anon_sym_SEMI_SEMI] = ACTIONS(1846),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(1846),
    [anon_sym_AMP] = ACTIONS(1846),
  },
  [406] = {
    [anon_sym_in] = ACTIONS(1848),
    [sym_comment] = ACTIONS(57),
  },
  [407] = {
    [anon_sym_LBRACK] = ACTIONS(1111),
    [anon_sym_EQ] = ACTIONS(1850),
    [sym_comment] = ACTIONS(57),
  },
  [408] = {
    [sym_subscript] = STATE(998),
    [sym_variable_name] = ACTIONS(1852),
    [anon_sym_DASH] = ACTIONS(1854),
    [anon_sym_DOLLAR] = ACTIONS(1854),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1856),
    [anon_sym_STAR] = ACTIONS(1858),
    [anon_sym_AT] = ACTIONS(1858),
    [anon_sym_QMARK] = ACTIONS(1858),
    [anon_sym_0] = ACTIONS(1856),
    [anon_sym__] = ACTIONS(1856),
  },
  [409] = {
    [sym_concatenation] = STATE(1001),
    [sym_string] = STATE(637),
    [sym_simple_expansion] = STATE(637),
    [sym_string_expansion] = STATE(637),
    [sym_expansion] = STATE(637),
    [sym_command_substitution] = STATE(637),
    [sym_process_substitution] = STATE(637),
    [aux_sym__literal_repeat1] = STATE(643),
    [aux_sym_expansion_repeat1] = STATE(1001),
    [anon_sym_RBRACE] = ACTIONS(1860),
    [anon_sym_EQ] = ACTIONS(1862),
    [anon_sym_DASH] = ACTIONS(1862),
    [anon_sym_DOLLAR] = ACTIONS(1127),
    [sym__special_character] = ACTIONS(1129),
    [anon_sym_DQUOTE] = ACTIONS(1131),
    [sym_raw_string] = ACTIONS(1133),
    [anon_sym_POUND] = ACTIONS(1864),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1137),
    [anon_sym_SLASH] = ACTIONS(1866),
    [anon_sym_COLON] = ACTIONS(1862),
    [anon_sym_COLON_QMARK] = ACTIONS(1862),
    [anon_sym_COLON_DASH] = ACTIONS(1862),
    [anon_sym_PERCENT] = ACTIONS(1862),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1141),
    [anon_sym_BQUOTE] = ACTIONS(1143),
    [anon_sym_LT_LPAREN] = ACTIONS(1145),
    [anon_sym_GT_LPAREN] = ACTIONS(1145),
    [sym_comment] = ACTIONS(329),
    [sym_word] = ACTIONS(1147),
  },
  [410] = {
    [sym_concatenation] = STATE(1004),
    [sym_string] = STATE(637),
    [sym_simple_expansion] = STATE(637),
    [sym_string_expansion] = STATE(637),
    [sym_expansion] = STATE(637),
    [sym_command_substitution] = STATE(637),
    [sym_process_substitution] = STATE(637),
    [aux_sym__literal_repeat1] = STATE(643),
    [aux_sym_expansion_repeat1] = STATE(1004),
    [anon_sym_RBRACE] = ACTIONS(1868),
    [anon_sym_EQ] = ACTIONS(1870),
    [anon_sym_DASH] = ACTIONS(1870),
    [anon_sym_DOLLAR] = ACTIONS(1127),
    [sym__special_character] = ACTIONS(1129),
    [anon_sym_DQUOTE] = ACTIONS(1131),
    [sym_raw_string] = ACTIONS(1133),
    [anon_sym_POUND] = ACTIONS(1872),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1137),
    [anon_sym_SLASH] = ACTIONS(1874),
    [anon_sym_COLON] = ACTIONS(1870),
    [anon_sym_COLON_QMARK] = ACTIONS(1870),
    [anon_sym_COLON_DASH] = ACTIONS(1870),
    [anon_sym_PERCENT] = ACTIONS(1870),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1141),
    [anon_sym_BQUOTE] = ACTIONS(1143),
    [anon_sym_LT_LPAREN] = ACTIONS(1145),
    [anon_sym_GT_LPAREN] = ACTIONS(1145),
    [sym_comment] = ACTIONS(329),
    [sym_word] = ACTIONS(1147),
  },
  [411] = {
    [anon_sym_RPAREN] = ACTIONS(1876),
    [sym_comment] = ACTIONS(57),
  },
  [412] = {
    [sym_file_descriptor] = ACTIONS(433),
    [sym_variable_name] = ACTIONS(433),
    [anon_sym_RPAREN] = ACTIONS(1876),
    [anon_sym_LT] = ACTIONS(435),
    [anon_sym_GT] = ACTIONS(435),
    [anon_sym_GT_GT] = ACTIONS(433),
    [anon_sym_AMP_GT] = ACTIONS(435),
    [anon_sym_AMP_GT_GT] = ACTIONS(433),
    [anon_sym_LT_AMP] = ACTIONS(433),
    [anon_sym_GT_AMP] = ACTIONS(433),
    [anon_sym_DOLLAR] = ACTIONS(435),
    [sym__special_character] = ACTIONS(433),
    [anon_sym_DQUOTE] = ACTIONS(433),
    [sym_raw_string] = ACTIONS(433),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(433),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(433),
    [anon_sym_BQUOTE] = ACTIONS(433),
    [anon_sym_LT_LPAREN] = ACTIONS(433),
    [anon_sym_GT_LPAREN] = ACTIONS(433),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(433),
  },
  [413] = {
    [anon_sym_BQUOTE] = ACTIONS(1876),
    [sym_comment] = ACTIONS(57),
  },
  [414] = {
    [anon_sym_RPAREN] = ACTIONS(1878),
    [sym_comment] = ACTIONS(57),
  },
  [415] = {
    [anon_sym_SEMI] = ACTIONS(1880),
    [anon_sym_SEMI_SEMI] = ACTIONS(1882),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(1882),
    [anon_sym_AMP] = ACTIONS(1882),
  },
  [416] = {
    [anon_sym_in] = ACTIONS(1884),
    [sym_comment] = ACTIONS(57),
  },
  [417] = {
    [anon_sym_in] = ACTIONS(335),
    [anon_sym_SEMI] = ACTIONS(339),
    [anon_sym_SEMI_SEMI] = ACTIONS(335),
    [sym__special_character] = ACTIONS(335),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(335),
    [anon_sym_AMP] = ACTIONS(335),
  },
  [418] = {
    [aux_sym__literal_repeat1] = STATE(418),
    [anon_sym_in] = ACTIONS(1373),
    [anon_sym_SEMI] = ACTIONS(1375),
    [anon_sym_SEMI_SEMI] = ACTIONS(1373),
    [sym__special_character] = ACTIONS(1886),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(1373),
    [anon_sym_AMP] = ACTIONS(1373),
  },
  [419] = {
    [anon_sym_RPAREN] = ACTIONS(1889),
    [sym_comment] = ACTIONS(57),
  },
  [420] = {
    [sym__simple_heredoc_body] = ACTIONS(1891),
    [sym__heredoc_body_beginning] = ACTIONS(1891),
    [sym_file_descriptor] = ACTIONS(1891),
    [ts_builtin_sym_end] = ACTIONS(1891),
    [anon_sym_SEMI] = ACTIONS(1893),
    [anon_sym_done] = ACTIONS(1891),
    [anon_sym_fi] = ACTIONS(1891),
    [anon_sym_elif] = ACTIONS(1891),
    [anon_sym_else] = ACTIONS(1891),
    [anon_sym_esac] = ACTIONS(1891),
    [anon_sym_PIPE] = ACTIONS(1893),
    [anon_sym_RPAREN] = ACTIONS(1891),
    [anon_sym_SEMI_SEMI] = ACTIONS(1891),
    [anon_sym_PIPE_AMP] = ACTIONS(1891),
    [anon_sym_AMP_AMP] = ACTIONS(1891),
    [anon_sym_PIPE_PIPE] = ACTIONS(1891),
    [anon_sym_LT] = ACTIONS(1893),
    [anon_sym_GT] = ACTIONS(1893),
    [anon_sym_GT_GT] = ACTIONS(1891),
    [anon_sym_AMP_GT] = ACTIONS(1893),
    [anon_sym_AMP_GT_GT] = ACTIONS(1891),
    [anon_sym_LT_AMP] = ACTIONS(1891),
    [anon_sym_GT_AMP] = ACTIONS(1891),
    [anon_sym_LT_LT] = ACTIONS(1893),
    [anon_sym_LT_LT_DASH] = ACTIONS(1891),
    [anon_sym_LT_LT_LT] = ACTIONS(1891),
    [anon_sym_BQUOTE] = ACTIONS(1891),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(1891),
    [anon_sym_AMP] = ACTIONS(1893),
  },
  [421] = {
    [sym_concatenation] = STATE(263),
    [sym_string] = STATE(1011),
    [sym_array] = STATE(263),
    [sym_simple_expansion] = STATE(1011),
    [sym_string_expansion] = STATE(1011),
    [sym_expansion] = STATE(1011),
    [sym_command_substitution] = STATE(1011),
    [sym_process_substitution] = STATE(1011),
    [aux_sym__literal_repeat1] = STATE(1012),
    [sym__empty_value] = ACTIONS(449),
    [anon_sym_LPAREN] = ACTIONS(451),
    [anon_sym_DOLLAR] = ACTIONS(453),
    [sym__special_character] = ACTIONS(1895),
    [anon_sym_DQUOTE] = ACTIONS(457),
    [sym_raw_string] = ACTIONS(1897),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(461),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(463),
    [anon_sym_BQUOTE] = ACTIONS(465),
    [anon_sym_LT_LPAREN] = ACTIONS(467),
    [anon_sym_GT_LPAREN] = ACTIONS(467),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1897),
  },
  [422] = {
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_EQ] = ACTIONS(1899),
    [anon_sym_PLUS_EQ] = ACTIONS(1899),
    [sym_comment] = ACTIONS(57),
  },
  [423] = {
    [aux_sym_concatenation_repeat1] = STATE(1014),
    [sym__simple_heredoc_body] = ACTIONS(335),
    [sym__heredoc_body_beginning] = ACTIONS(335),
    [sym_file_descriptor] = ACTIONS(335),
    [sym__concat] = ACTIONS(951),
    [sym_variable_name] = ACTIONS(335),
    [anon_sym_SEMI] = ACTIONS(339),
    [anon_sym_PIPE] = ACTIONS(339),
    [anon_sym_RPAREN] = ACTIONS(335),
    [anon_sym_SEMI_SEMI] = ACTIONS(335),
    [anon_sym_PIPE_AMP] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_PIPE_PIPE] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(339),
    [anon_sym_GT_GT] = ACTIONS(335),
    [anon_sym_AMP_GT] = ACTIONS(339),
    [anon_sym_AMP_GT_GT] = ACTIONS(335),
    [anon_sym_LT_AMP] = ACTIONS(335),
    [anon_sym_GT_AMP] = ACTIONS(335),
    [anon_sym_LT_LT] = ACTIONS(339),
    [anon_sym_LT_LT_DASH] = ACTIONS(335),
    [anon_sym_LT_LT_LT] = ACTIONS(335),
    [anon_sym_DOLLAR] = ACTIONS(339),
    [sym__special_character] = ACTIONS(335),
    [anon_sym_DQUOTE] = ACTIONS(335),
    [sym_raw_string] = ACTIONS(335),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(335),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(335),
    [anon_sym_LT_LPAREN] = ACTIONS(335),
    [anon_sym_GT_LPAREN] = ACTIONS(335),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(339),
    [sym_word] = ACTIONS(339),
    [anon_sym_LF] = ACTIONS(335),
    [anon_sym_AMP] = ACTIONS(339),
  },
  [424] = {
    [aux_sym_concatenation_repeat1] = STATE(1014),
    [sym__simple_heredoc_body] = ACTIONS(957),
    [sym__heredoc_body_beginning] = ACTIONS(957),
    [sym_file_descriptor] = ACTIONS(957),
    [sym__concat] = ACTIONS(951),
    [sym_variable_name] = ACTIONS(957),
    [anon_sym_SEMI] = ACTIONS(959),
    [anon_sym_PIPE] = ACTIONS(959),
    [anon_sym_RPAREN] = ACTIONS(957),
    [anon_sym_SEMI_SEMI] = ACTIONS(957),
    [anon_sym_PIPE_AMP] = ACTIONS(957),
    [anon_sym_AMP_AMP] = ACTIONS(957),
    [anon_sym_PIPE_PIPE] = ACTIONS(957),
    [anon_sym_LT] = ACTIONS(959),
    [anon_sym_GT] = ACTIONS(959),
    [anon_sym_GT_GT] = ACTIONS(957),
    [anon_sym_AMP_GT] = ACTIONS(959),
    [anon_sym_AMP_GT_GT] = ACTIONS(957),
    [anon_sym_LT_AMP] = ACTIONS(957),
    [anon_sym_GT_AMP] = ACTIONS(957),
    [anon_sym_LT_LT] = ACTIONS(959),
    [anon_sym_LT_LT_DASH] = ACTIONS(957),
    [anon_sym_LT_LT_LT] = ACTIONS(957),
    [anon_sym_DOLLAR] = ACTIONS(959),
    [sym__special_character] = ACTIONS(957),
    [anon_sym_DQUOTE] = ACTIONS(957),
    [sym_raw_string] = ACTIONS(957),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(957),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(957),
    [anon_sym_BQUOTE] = ACTIONS(957),
    [anon_sym_LT_LPAREN] = ACTIONS(957),
    [anon_sym_GT_LPAREN] = ACTIONS(957),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(959),
    [sym_word] = ACTIONS(959),
    [anon_sym_LF] = ACTIONS(957),
    [anon_sym_AMP] = ACTIONS(959),
  },
  [425] = {
    [anon_sym_EQ] = ACTIONS(1899),
    [anon_sym_PLUS_EQ] = ACTIONS(1899),
    [sym_comment] = ACTIONS(57),
  },
  [426] = {
    [sym_variable_assignment] = STATE(1015),
    [sym_subscript] = STATE(425),
    [sym_concatenation] = STATE(1015),
    [sym_string] = STATE(424),
    [sym_simple_expansion] = STATE(424),
    [sym_string_expansion] = STATE(424),
    [sym_expansion] = STATE(424),
    [sym_command_substitution] = STATE(424),
    [sym_process_substitution] = STATE(424),
    [aux_sym_declaration_command_repeat1] = STATE(1015),
    [aux_sym__literal_repeat1] = STATE(427),
    [sym__simple_heredoc_body] = ACTIONS(971),
    [sym__heredoc_body_beginning] = ACTIONS(971),
    [sym_file_descriptor] = ACTIONS(971),
    [sym_variable_name] = ACTIONS(729),
    [anon_sym_SEMI] = ACTIONS(973),
    [anon_sym_PIPE] = ACTIONS(973),
    [anon_sym_RPAREN] = ACTIONS(971),
    [anon_sym_SEMI_SEMI] = ACTIONS(971),
    [anon_sym_PIPE_AMP] = ACTIONS(971),
    [anon_sym_AMP_AMP] = ACTIONS(971),
    [anon_sym_PIPE_PIPE] = ACTIONS(971),
    [anon_sym_LT] = ACTIONS(973),
    [anon_sym_GT] = ACTIONS(973),
    [anon_sym_GT_GT] = ACTIONS(971),
    [anon_sym_AMP_GT] = ACTIONS(973),
    [anon_sym_AMP_GT_GT] = ACTIONS(971),
    [anon_sym_LT_AMP] = ACTIONS(971),
    [anon_sym_GT_AMP] = ACTIONS(971),
    [anon_sym_LT_LT] = ACTIONS(973),
    [anon_sym_LT_LT_DASH] = ACTIONS(971),
    [anon_sym_LT_LT_LT] = ACTIONS(971),
    [anon_sym_DOLLAR] = ACTIONS(265),
    [sym__special_character] = ACTIONS(731),
    [anon_sym_DQUOTE] = ACTIONS(269),
    [sym_raw_string] = ACTIONS(733),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(273),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(275),
    [anon_sym_BQUOTE] = ACTIONS(277),
    [anon_sym_LT_LPAREN] = ACTIONS(279),
    [anon_sym_GT_LPAREN] = ACTIONS(279),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1901),
    [sym_word] = ACTIONS(737),
    [anon_sym_LF] = ACTIONS(971),
    [anon_sym_AMP] = ACTIONS(973),
  },
  [427] = {
    [aux_sym__literal_repeat1] = STATE(1016),
    [sym__simple_heredoc_body] = ACTIONS(977),
    [sym__heredoc_body_beginning] = ACTIONS(977),
    [sym_file_descriptor] = ACTIONS(977),
    [sym_variable_name] = ACTIONS(977),
    [anon_sym_SEMI] = ACTIONS(979),
    [anon_sym_PIPE] = ACTIONS(979),
    [anon_sym_RPAREN] = ACTIONS(977),
    [anon_sym_SEMI_SEMI] = ACTIONS(977),
    [anon_sym_PIPE_AMP] = ACTIONS(977),
    [anon_sym_AMP_AMP] = ACTIONS(977),
    [anon_sym_PIPE_PIPE] = ACTIONS(977),
    [anon_sym_LT] = ACTIONS(979),
    [anon_sym_GT] = ACTIONS(979),
    [anon_sym_GT_GT] = ACTIONS(977),
    [anon_sym_AMP_GT] = ACTIONS(979),
    [anon_sym_AMP_GT_GT] = ACTIONS(977),
    [anon_sym_LT_AMP] = ACTIONS(977),
    [anon_sym_GT_AMP] = ACTIONS(977),
    [anon_sym_LT_LT] = ACTIONS(979),
    [anon_sym_LT_LT_DASH] = ACTIONS(977),
    [anon_sym_LT_LT_LT] = ACTIONS(977),
    [anon_sym_DOLLAR] = ACTIONS(979),
    [sym__special_character] = ACTIONS(981),
    [anon_sym_DQUOTE] = ACTIONS(977),
    [sym_raw_string] = ACTIONS(977),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(977),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(977),
    [anon_sym_BQUOTE] = ACTIONS(977),
    [anon_sym_LT_LPAREN] = ACTIONS(977),
    [anon_sym_GT_LPAREN] = ACTIONS(977),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(979),
    [sym_word] = ACTIONS(979),
    [anon_sym_LF] = ACTIONS(977),
    [anon_sym_AMP] = ACTIONS(979),
  },
  [428] = {
    [aux_sym_concatenation_repeat1] = STATE(1017),
    [sym__simple_heredoc_body] = ACTIONS(335),
    [sym__heredoc_body_beginning] = ACTIONS(335),
    [sym_file_descriptor] = ACTIONS(335),
    [sym__concat] = ACTIONS(991),
    [anon_sym_SEMI] = ACTIONS(339),
    [anon_sym_PIPE] = ACTIONS(339),
    [anon_sym_RPAREN] = ACTIONS(335),
    [anon_sym_SEMI_SEMI] = ACTIONS(335),
    [anon_sym_PIPE_AMP] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_PIPE_PIPE] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(339),
    [anon_sym_GT_GT] = ACTIONS(335),
    [anon_sym_AMP_GT] = ACTIONS(339),
    [anon_sym_AMP_GT_GT] = ACTIONS(335),
    [anon_sym_LT_AMP] = ACTIONS(335),
    [anon_sym_GT_AMP] = ACTIONS(335),
    [anon_sym_LT_LT] = ACTIONS(339),
    [anon_sym_LT_LT_DASH] = ACTIONS(335),
    [anon_sym_LT_LT_LT] = ACTIONS(335),
    [anon_sym_DOLLAR] = ACTIONS(339),
    [sym__special_character] = ACTIONS(335),
    [anon_sym_DQUOTE] = ACTIONS(335),
    [sym_raw_string] = ACTIONS(335),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(335),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(335),
    [anon_sym_LT_LPAREN] = ACTIONS(335),
    [anon_sym_GT_LPAREN] = ACTIONS(335),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(339),
    [sym_word] = ACTIONS(339),
    [anon_sym_LF] = ACTIONS(335),
    [anon_sym_AMP] = ACTIONS(339),
  },
  [429] = {
    [aux_sym_concatenation_repeat1] = STATE(1017),
    [sym__simple_heredoc_body] = ACTIONS(997),
    [sym__heredoc_body_beginning] = ACTIONS(997),
    [sym_file_descriptor] = ACTIONS(997),
    [sym__concat] = ACTIONS(991),
    [anon_sym_SEMI] = ACTIONS(999),
    [anon_sym_PIPE] = ACTIONS(999),
    [anon_sym_RPAREN] = ACTIONS(997),
    [anon_sym_SEMI_SEMI] = ACTIONS(997),
    [anon_sym_PIPE_AMP] = ACTIONS(997),
    [anon_sym_AMP_AMP] = ACTIONS(997),
    [anon_sym_PIPE_PIPE] = ACTIONS(997),
    [anon_sym_LT] = ACTIONS(999),
    [anon_sym_GT] = ACTIONS(999),
    [anon_sym_GT_GT] = ACTIONS(997),
    [anon_sym_AMP_GT] = ACTIONS(999),
    [anon_sym_AMP_GT_GT] = ACTIONS(997),
    [anon_sym_LT_AMP] = ACTIONS(997),
    [anon_sym_GT_AMP] = ACTIONS(997),
    [anon_sym_LT_LT] = ACTIONS(999),
    [anon_sym_LT_LT_DASH] = ACTIONS(997),
    [anon_sym_LT_LT_LT] = ACTIONS(997),
    [anon_sym_DOLLAR] = ACTIONS(999),
    [sym__special_character] = ACTIONS(997),
    [anon_sym_DQUOTE] = ACTIONS(997),
    [sym_raw_string] = ACTIONS(997),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(997),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(997),
    [anon_sym_BQUOTE] = ACTIONS(997),
    [anon_sym_LT_LPAREN] = ACTIONS(997),
    [anon_sym_GT_LPAREN] = ACTIONS(997),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(999),
    [sym_word] = ACTIONS(999),
    [anon_sym_LF] = ACTIONS(997),
    [anon_sym_AMP] = ACTIONS(999),
  },
  [430] = {
    [sym_concatenation] = STATE(1018),
    [sym_string] = STATE(429),
    [sym_simple_expansion] = STATE(429),
    [sym_string_expansion] = STATE(429),
    [sym_expansion] = STATE(429),
    [sym_command_substitution] = STATE(429),
    [sym_process_substitution] = STATE(429),
    [aux_sym_unset_command_repeat1] = STATE(1018),
    [aux_sym__literal_repeat1] = STATE(431),
    [sym__simple_heredoc_body] = ACTIONS(1011),
    [sym__heredoc_body_beginning] = ACTIONS(1011),
    [sym_file_descriptor] = ACTIONS(1011),
    [anon_sym_SEMI] = ACTIONS(1013),
    [anon_sym_PIPE] = ACTIONS(1013),
    [anon_sym_RPAREN] = ACTIONS(1011),
    [anon_sym_SEMI_SEMI] = ACTIONS(1011),
    [anon_sym_PIPE_AMP] = ACTIONS(1011),
    [anon_sym_AMP_AMP] = ACTIONS(1011),
    [anon_sym_PIPE_PIPE] = ACTIONS(1011),
    [anon_sym_LT] = ACTIONS(1013),
    [anon_sym_GT] = ACTIONS(1013),
    [anon_sym_GT_GT] = ACTIONS(1011),
    [anon_sym_AMP_GT] = ACTIONS(1013),
    [anon_sym_AMP_GT_GT] = ACTIONS(1011),
    [anon_sym_LT_AMP] = ACTIONS(1011),
    [anon_sym_GT_AMP] = ACTIONS(1011),
    [anon_sym_LT_LT] = ACTIONS(1013),
    [anon_sym_LT_LT_DASH] = ACTIONS(1011),
    [anon_sym_LT_LT_LT] = ACTIONS(1011),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym__special_character] = ACTIONS(739),
    [anon_sym_DQUOTE] = ACTIONS(293),
    [sym_raw_string] = ACTIONS(741),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(297),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(299),
    [anon_sym_BQUOTE] = ACTIONS(301),
    [anon_sym_LT_LPAREN] = ACTIONS(303),
    [anon_sym_GT_LPAREN] = ACTIONS(303),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1903),
    [sym_word] = ACTIONS(745),
    [anon_sym_LF] = ACTIONS(1011),
    [anon_sym_AMP] = ACTIONS(1013),
  },
  [431] = {
    [aux_sym__literal_repeat1] = STATE(1019),
    [sym__simple_heredoc_body] = ACTIONS(1017),
    [sym__heredoc_body_beginning] = ACTIONS(1017),
    [sym_file_descriptor] = ACTIONS(1017),
    [anon_sym_SEMI] = ACTIONS(1019),
    [anon_sym_PIPE] = ACTIONS(1019),
    [anon_sym_RPAREN] = ACTIONS(1017),
    [anon_sym_SEMI_SEMI] = ACTIONS(1017),
    [anon_sym_PIPE_AMP] = ACTIONS(1017),
    [anon_sym_AMP_AMP] = ACTIONS(1017),
    [anon_sym_PIPE_PIPE] = ACTIONS(1017),
    [anon_sym_LT] = ACTIONS(1019),
    [anon_sym_GT] = ACTIONS(1019),
    [anon_sym_GT_GT] = ACTIONS(1017),
    [anon_sym_AMP_GT] = ACTIONS(1019),
    [anon_sym_AMP_GT_GT] = ACTIONS(1017),
    [anon_sym_LT_AMP] = ACTIONS(1017),
    [anon_sym_GT_AMP] = ACTIONS(1017),
    [anon_sym_LT_LT] = ACTIONS(1019),
    [anon_sym_LT_LT_DASH] = ACTIONS(1017),
    [anon_sym_LT_LT_LT] = ACTIONS(1017),
    [anon_sym_DOLLAR] = ACTIONS(1019),
    [sym__special_character] = ACTIONS(1021),
    [anon_sym_DQUOTE] = ACTIONS(1017),
    [sym_raw_string] = ACTIONS(1017),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1017),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1017),
    [anon_sym_BQUOTE] = ACTIONS(1017),
    [anon_sym_LT_LPAREN] = ACTIONS(1017),
    [anon_sym_GT_LPAREN] = ACTIONS(1017),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1019),
    [sym_word] = ACTIONS(1019),
    [anon_sym_LF] = ACTIONS(1017),
    [anon_sym_AMP] = ACTIONS(1019),
  },
  [432] = {
    [aux_sym_concatenation_repeat1] = STATE(1020),
    [sym__simple_heredoc_body] = ACTIONS(1071),
    [sym__heredoc_body_beginning] = ACTIONS(1071),
    [sym_file_descriptor] = ACTIONS(1071),
    [sym__concat] = ACTIONS(1073),
    [anon_sym_SEMI] = ACTIONS(1075),
    [anon_sym_PIPE] = ACTIONS(1075),
    [anon_sym_RPAREN] = ACTIONS(1071),
    [anon_sym_SEMI_SEMI] = ACTIONS(1071),
    [anon_sym_PIPE_AMP] = ACTIONS(1071),
    [anon_sym_AMP_AMP] = ACTIONS(1071),
    [anon_sym_PIPE_PIPE] = ACTIONS(1071),
    [anon_sym_EQ_TILDE] = ACTIONS(1075),
    [anon_sym_EQ_EQ] = ACTIONS(1075),
    [anon_sym_LT] = ACTIONS(1075),
    [anon_sym_GT] = ACTIONS(1075),
    [anon_sym_GT_GT] = ACTIONS(1071),
    [anon_sym_AMP_GT] = ACTIONS(1075),
    [anon_sym_AMP_GT_GT] = ACTIONS(1071),
    [anon_sym_LT_AMP] = ACTIONS(1071),
    [anon_sym_GT_AMP] = ACTIONS(1071),
    [anon_sym_LT_LT] = ACTIONS(1075),
    [anon_sym_LT_LT_DASH] = ACTIONS(1071),
    [anon_sym_LT_LT_LT] = ACTIONS(1071),
    [anon_sym_DOLLAR] = ACTIONS(1075),
    [sym__special_character] = ACTIONS(1071),
    [anon_sym_DQUOTE] = ACTIONS(1071),
    [sym_raw_string] = ACTIONS(1071),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1071),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1071),
    [anon_sym_BQUOTE] = ACTIONS(1071),
    [anon_sym_LT_LPAREN] = ACTIONS(1071),
    [anon_sym_GT_LPAREN] = ACTIONS(1071),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1075),
    [anon_sym_LF] = ACTIONS(1071),
    [anon_sym_AMP] = ACTIONS(1075),
  },
  [433] = {
    [sym__simple_heredoc_body] = ACTIONS(1905),
    [sym__heredoc_body_beginning] = ACTIONS(1905),
    [sym_file_descriptor] = ACTIONS(1905),
    [ts_builtin_sym_end] = ACTIONS(1905),
    [anon_sym_SEMI] = ACTIONS(1907),
    [anon_sym_done] = ACTIONS(1905),
    [anon_sym_fi] = ACTIONS(1905),
    [anon_sym_elif] = ACTIONS(1905),
    [anon_sym_else] = ACTIONS(1905),
    [anon_sym_esac] = ACTIONS(1905),
    [anon_sym_PIPE] = ACTIONS(1907),
    [anon_sym_RPAREN] = ACTIONS(1905),
    [anon_sym_SEMI_SEMI] = ACTIONS(1905),
    [anon_sym_PIPE_AMP] = ACTIONS(1905),
    [anon_sym_AMP_AMP] = ACTIONS(1905),
    [anon_sym_PIPE_PIPE] = ACTIONS(1905),
    [anon_sym_LT] = ACTIONS(1907),
    [anon_sym_GT] = ACTIONS(1907),
    [anon_sym_GT_GT] = ACTIONS(1905),
    [anon_sym_AMP_GT] = ACTIONS(1907),
    [anon_sym_AMP_GT_GT] = ACTIONS(1905),
    [anon_sym_LT_AMP] = ACTIONS(1905),
    [anon_sym_GT_AMP] = ACTIONS(1905),
    [anon_sym_LT_LT] = ACTIONS(1907),
    [anon_sym_LT_LT_DASH] = ACTIONS(1905),
    [anon_sym_LT_LT_LT] = ACTIONS(1905),
    [anon_sym_BQUOTE] = ACTIONS(1905),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(1905),
    [anon_sym_AMP] = ACTIONS(1907),
  },
  [434] = {
    [anon_sym_LT] = ACTIONS(1909),
    [anon_sym_GT] = ACTIONS(1909),
    [anon_sym_GT_GT] = ACTIONS(1911),
    [anon_sym_AMP_GT] = ACTIONS(1909),
    [anon_sym_AMP_GT_GT] = ACTIONS(1911),
    [anon_sym_LT_AMP] = ACTIONS(1911),
    [anon_sym_GT_AMP] = ACTIONS(1911),
    [sym_comment] = ACTIONS(57),
  },
  [435] = {
    [sym_redirected_statement] = STATE(1022),
    [sym_for_statement] = STATE(1022),
    [sym_c_style_for_statement] = STATE(1022),
    [sym_while_statement] = STATE(1022),
    [sym_if_statement] = STATE(1022),
    [sym_case_statement] = STATE(1022),
    [sym_function_definition] = STATE(1022),
    [sym_compound_statement] = STATE(1022),
    [sym_subshell] = STATE(1022),
    [sym_pipeline] = STATE(1022),
    [sym_list] = STATE(1022),
    [sym_negated_command] = STATE(1022),
    [sym_test_command] = STATE(1022),
    [sym_declaration_command] = STATE(1022),
    [sym_unset_command] = STATE(1022),
    [sym_command] = STATE(1022),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(1023),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(110),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [436] = {
    [sym_redirected_statement] = STATE(1024),
    [sym_for_statement] = STATE(1024),
    [sym_c_style_for_statement] = STATE(1024),
    [sym_while_statement] = STATE(1024),
    [sym_if_statement] = STATE(1024),
    [sym_case_statement] = STATE(1024),
    [sym_function_definition] = STATE(1024),
    [sym_compound_statement] = STATE(1024),
    [sym_subshell] = STATE(1024),
    [sym_pipeline] = STATE(1024),
    [sym_list] = STATE(1024),
    [sym_negated_command] = STATE(1024),
    [sym_test_command] = STATE(1024),
    [sym_declaration_command] = STATE(1024),
    [sym_unset_command] = STATE(1024),
    [sym_command] = STATE(1024),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(1025),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(110),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(37),
    [anon_sym_GT] = ACTIONS(37),
    [anon_sym_GT_GT] = ACTIONS(39),
    [anon_sym_AMP_GT] = ACTIONS(37),
    [anon_sym_AMP_GT_GT] = ACTIONS(39),
    [anon_sym_LT_AMP] = ACTIONS(39),
    [anon_sym_GT_AMP] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [437] = {
    [sym_concatenation] = STATE(696),
    [sym_string] = STATE(1027),
    [sym_simple_expansion] = STATE(1027),
    [sym_string_expansion] = STATE(1027),
    [sym_expansion] = STATE(1027),
    [sym_command_substitution] = STATE(1027),
    [sym_process_substitution] = STATE(1027),
    [aux_sym__literal_repeat1] = STATE(1028),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(1913),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(1915),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1915),
  },
  [438] = {
    [sym_concatenation] = STATE(700),
    [sym_string] = STATE(1029),
    [sym_simple_expansion] = STATE(1029),
    [sym_string_expansion] = STATE(1029),
    [sym_expansion] = STATE(1029),
    [sym_command_substitution] = STATE(1029),
    [sym_process_substitution] = STATE(1029),
    [aux_sym__literal_repeat1] = STATE(1030),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(1913),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(1917),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1917),
  },
  [439] = {
    [sym_file_redirect] = STATE(1031),
    [sym_heredoc_redirect] = STATE(1031),
    [sym_herestring_redirect] = STATE(1031),
    [aux_sym_redirected_statement_repeat1] = STATE(1031),
    [sym__simple_heredoc_body] = ACTIONS(1255),
    [sym__heredoc_body_beginning] = ACTIONS(1255),
    [sym_file_descriptor] = ACTIONS(749),
    [anon_sym_SEMI] = ACTIONS(1257),
    [anon_sym_PIPE] = ACTIONS(1257),
    [anon_sym_RPAREN] = ACTIONS(1255),
    [anon_sym_SEMI_SEMI] = ACTIONS(1255),
    [anon_sym_PIPE_AMP] = ACTIONS(1255),
    [anon_sym_AMP_AMP] = ACTIONS(1255),
    [anon_sym_PIPE_PIPE] = ACTIONS(1255),
    [anon_sym_LT] = ACTIONS(757),
    [anon_sym_GT] = ACTIONS(757),
    [anon_sym_GT_GT] = ACTIONS(759),
    [anon_sym_AMP_GT] = ACTIONS(757),
    [anon_sym_AMP_GT_GT] = ACTIONS(759),
    [anon_sym_LT_AMP] = ACTIONS(759),
    [anon_sym_GT_AMP] = ACTIONS(759),
    [anon_sym_LT_LT] = ACTIONS(415),
    [anon_sym_LT_LT_DASH] = ACTIONS(417),
    [anon_sym_LT_LT_LT] = ACTIONS(761),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(1255),
    [anon_sym_AMP] = ACTIONS(1257),
  },
  [440] = {
    [sym_concatenation] = STATE(704),
    [sym_string] = STATE(1032),
    [sym_simple_expansion] = STATE(1032),
    [sym_string_expansion] = STATE(1032),
    [sym_expansion] = STATE(1032),
    [sym_command_substitution] = STATE(1032),
    [sym_process_substitution] = STATE(1032),
    [aux_sym__literal_repeat1] = STATE(1033),
    [sym_regex] = ACTIONS(1259),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(765),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(1919),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1919),
  },
  [441] = {
    [aux_sym_concatenation_repeat1] = STATE(432),
    [sym__simple_heredoc_body] = ACTIONS(1263),
    [sym__heredoc_body_beginning] = ACTIONS(1263),
    [sym_file_descriptor] = ACTIONS(1263),
    [sym__concat] = ACTIONS(337),
    [anon_sym_SEMI] = ACTIONS(1265),
    [anon_sym_PIPE] = ACTIONS(1265),
    [anon_sym_RPAREN] = ACTIONS(1263),
    [anon_sym_SEMI_SEMI] = ACTIONS(1263),
    [anon_sym_PIPE_AMP] = ACTIONS(1263),
    [anon_sym_AMP_AMP] = ACTIONS(1263),
    [anon_sym_PIPE_PIPE] = ACTIONS(1263),
    [anon_sym_EQ_TILDE] = ACTIONS(1265),
    [anon_sym_EQ_EQ] = ACTIONS(1265),
    [anon_sym_LT] = ACTIONS(1265),
    [anon_sym_GT] = ACTIONS(1265),
    [anon_sym_GT_GT] = ACTIONS(1263),
    [anon_sym_AMP_GT] = ACTIONS(1265),
    [anon_sym_AMP_GT_GT] = ACTIONS(1263),
    [anon_sym_LT_AMP] = ACTIONS(1263),
    [anon_sym_GT_AMP] = ACTIONS(1263),
    [anon_sym_LT_LT] = ACTIONS(1265),
    [anon_sym_LT_LT_DASH] = ACTIONS(1263),
    [anon_sym_LT_LT_LT] = ACTIONS(1263),
    [anon_sym_DOLLAR] = ACTIONS(1265),
    [sym__special_character] = ACTIONS(1263),
    [anon_sym_DQUOTE] = ACTIONS(1263),
    [sym_raw_string] = ACTIONS(1263),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1263),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1263),
    [anon_sym_BQUOTE] = ACTIONS(1263),
    [anon_sym_LT_LPAREN] = ACTIONS(1263),
    [anon_sym_GT_LPAREN] = ACTIONS(1263),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1265),
    [anon_sym_LF] = ACTIONS(1263),
    [anon_sym_AMP] = ACTIONS(1265),
  },
  [442] = {
    [sym_concatenation] = STATE(1034),
    [sym_string] = STATE(441),
    [sym_simple_expansion] = STATE(441),
    [sym_string_expansion] = STATE(441),
    [sym_expansion] = STATE(441),
    [sym_command_substitution] = STATE(441),
    [sym_process_substitution] = STATE(441),
    [aux_sym_command_repeat2] = STATE(1034),
    [aux_sym__literal_repeat1] = STATE(443),
    [sym__simple_heredoc_body] = ACTIONS(1267),
    [sym__heredoc_body_beginning] = ACTIONS(1267),
    [sym_file_descriptor] = ACTIONS(1267),
    [anon_sym_SEMI] = ACTIONS(1269),
    [anon_sym_PIPE] = ACTIONS(1269),
    [anon_sym_RPAREN] = ACTIONS(1267),
    [anon_sym_SEMI_SEMI] = ACTIONS(1267),
    [anon_sym_PIPE_AMP] = ACTIONS(1267),
    [anon_sym_AMP_AMP] = ACTIONS(1267),
    [anon_sym_PIPE_PIPE] = ACTIONS(1267),
    [anon_sym_EQ_TILDE] = ACTIONS(763),
    [anon_sym_EQ_EQ] = ACTIONS(763),
    [anon_sym_LT] = ACTIONS(1269),
    [anon_sym_GT] = ACTIONS(1269),
    [anon_sym_GT_GT] = ACTIONS(1267),
    [anon_sym_AMP_GT] = ACTIONS(1269),
    [anon_sym_AMP_GT_GT] = ACTIONS(1267),
    [anon_sym_LT_AMP] = ACTIONS(1267),
    [anon_sym_GT_AMP] = ACTIONS(1267),
    [anon_sym_LT_LT] = ACTIONS(1269),
    [anon_sym_LT_LT_DASH] = ACTIONS(1267),
    [anon_sym_LT_LT_LT] = ACTIONS(1267),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(765),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(767),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(769),
    [anon_sym_LF] = ACTIONS(1267),
    [anon_sym_AMP] = ACTIONS(1269),
  },
  [443] = {
    [aux_sym__literal_repeat1] = STATE(447),
    [sym__simple_heredoc_body] = ACTIONS(1271),
    [sym__heredoc_body_beginning] = ACTIONS(1271),
    [sym_file_descriptor] = ACTIONS(1271),
    [anon_sym_SEMI] = ACTIONS(1273),
    [anon_sym_PIPE] = ACTIONS(1273),
    [anon_sym_RPAREN] = ACTIONS(1271),
    [anon_sym_SEMI_SEMI] = ACTIONS(1271),
    [anon_sym_PIPE_AMP] = ACTIONS(1271),
    [anon_sym_AMP_AMP] = ACTIONS(1271),
    [anon_sym_PIPE_PIPE] = ACTIONS(1271),
    [anon_sym_EQ_TILDE] = ACTIONS(1273),
    [anon_sym_EQ_EQ] = ACTIONS(1273),
    [anon_sym_LT] = ACTIONS(1273),
    [anon_sym_GT] = ACTIONS(1273),
    [anon_sym_GT_GT] = ACTIONS(1271),
    [anon_sym_AMP_GT] = ACTIONS(1273),
    [anon_sym_AMP_GT_GT] = ACTIONS(1271),
    [anon_sym_LT_AMP] = ACTIONS(1271),
    [anon_sym_GT_AMP] = ACTIONS(1271),
    [anon_sym_LT_LT] = ACTIONS(1273),
    [anon_sym_LT_LT_DASH] = ACTIONS(1271),
    [anon_sym_LT_LT_LT] = ACTIONS(1271),
    [anon_sym_DOLLAR] = ACTIONS(1273),
    [sym__special_character] = ACTIONS(441),
    [anon_sym_DQUOTE] = ACTIONS(1271),
    [sym_raw_string] = ACTIONS(1271),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1271),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1271),
    [anon_sym_BQUOTE] = ACTIONS(1271),
    [anon_sym_LT_LPAREN] = ACTIONS(1271),
    [anon_sym_GT_LPAREN] = ACTIONS(1271),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1273),
    [anon_sym_LF] = ACTIONS(1271),
    [anon_sym_AMP] = ACTIONS(1273),
  },
  [444] = {
    [sym_file_redirect] = STATE(439),
    [sym_heredoc_redirect] = STATE(439),
    [sym_heredoc_body] = STATE(709),
    [sym_herestring_redirect] = STATE(439),
    [aux_sym_redirected_statement_repeat1] = STATE(439),
    [sym__simple_heredoc_body] = ACTIONS(393),
    [sym__heredoc_body_beginning] = ACTIONS(395),
    [sym_file_descriptor] = ACTIONS(749),
    [anon_sym_SEMI] = ACTIONS(1275),
    [anon_sym_PIPE] = ACTIONS(751),
    [anon_sym_RPAREN] = ACTIONS(1239),
    [anon_sym_SEMI_SEMI] = ACTIONS(1277),
    [anon_sym_PIPE_AMP] = ACTIONS(753),
    [anon_sym_AMP_AMP] = ACTIONS(755),
    [anon_sym_PIPE_PIPE] = ACTIONS(755),
    [anon_sym_LT] = ACTIONS(757),
    [anon_sym_GT] = ACTIONS(757),
    [anon_sym_GT_GT] = ACTIONS(759),
    [anon_sym_AMP_GT] = ACTIONS(757),
    [anon_sym_AMP_GT_GT] = ACTIONS(759),
    [anon_sym_LT_AMP] = ACTIONS(759),
    [anon_sym_GT_AMP] = ACTIONS(759),
    [anon_sym_LT_LT] = ACTIONS(415),
    [anon_sym_LT_LT_DASH] = ACTIONS(417),
    [anon_sym_LT_LT_LT] = ACTIONS(761),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(1277),
    [anon_sym_AMP] = ACTIONS(1275),
  },
  [445] = {
    [sym_file_redirect] = STATE(439),
    [sym_heredoc_redirect] = STATE(439),
    [sym_heredoc_body] = STATE(709),
    [sym_herestring_redirect] = STATE(439),
    [aux_sym_redirected_statement_repeat1] = STATE(439),
    [sym__simple_heredoc_body] = ACTIONS(393),
    [sym__heredoc_body_beginning] = ACTIONS(395),
    [sym_file_descriptor] = ACTIONS(433),
    [sym_variable_name] = ACTIONS(433),
    [anon_sym_SEMI] = ACTIONS(1275),
    [anon_sym_PIPE] = ACTIONS(751),
    [anon_sym_RPAREN] = ACTIONS(1239),
    [anon_sym_SEMI_SEMI] = ACTIONS(1277),
    [anon_sym_PIPE_AMP] = ACTIONS(753),
    [anon_sym_AMP_AMP] = ACTIONS(755),
    [anon_sym_PIPE_PIPE] = ACTIONS(755),
    [anon_sym_LT] = ACTIONS(435),
    [anon_sym_GT] = ACTIONS(435),
    [anon_sym_GT_GT] = ACTIONS(433),
    [anon_sym_AMP_GT] = ACTIONS(435),
    [anon_sym_AMP_GT_GT] = ACTIONS(433),
    [anon_sym_LT_AMP] = ACTIONS(433),
    [anon_sym_GT_AMP] = ACTIONS(433),
    [anon_sym_LT_LT] = ACTIONS(415),
    [anon_sym_LT_LT_DASH] = ACTIONS(417),
    [anon_sym_LT_LT_LT] = ACTIONS(761),
    [anon_sym_DOLLAR] = ACTIONS(435),
    [sym__special_character] = ACTIONS(433),
    [anon_sym_DQUOTE] = ACTIONS(433),
    [sym_raw_string] = ACTIONS(433),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(433),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(433),
    [anon_sym_BQUOTE] = ACTIONS(433),
    [anon_sym_LT_LPAREN] = ACTIONS(433),
    [anon_sym_GT_LPAREN] = ACTIONS(433),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(435),
    [anon_sym_LF] = ACTIONS(1277),
    [anon_sym_AMP] = ACTIONS(1275),
  },
  [446] = {
    [sym_concatenation] = STATE(1035),
    [sym_string] = STATE(441),
    [sym_simple_expansion] = STATE(441),
    [sym_string_expansion] = STATE(441),
    [sym_expansion] = STATE(441),
    [sym_command_substitution] = STATE(441),
    [sym_process_substitution] = STATE(441),
    [aux_sym_command_repeat2] = STATE(1035),
    [aux_sym__literal_repeat1] = STATE(443),
    [sym__simple_heredoc_body] = ACTIONS(1267),
    [sym__heredoc_body_beginning] = ACTIONS(1267),
    [sym_file_descriptor] = ACTIONS(1267),
    [anon_sym_SEMI] = ACTIONS(1269),
    [anon_sym_PIPE] = ACTIONS(1269),
    [anon_sym_RPAREN] = ACTIONS(1267),
    [anon_sym_SEMI_SEMI] = ACTIONS(1267),
    [anon_sym_PIPE_AMP] = ACTIONS(1267),
    [anon_sym_AMP_AMP] = ACTIONS(1267),
    [anon_sym_PIPE_PIPE] = ACTIONS(1267),
    [anon_sym_EQ_TILDE] = ACTIONS(763),
    [anon_sym_EQ_EQ] = ACTIONS(763),
    [anon_sym_LT] = ACTIONS(1269),
    [anon_sym_GT] = ACTIONS(1269),
    [anon_sym_GT_GT] = ACTIONS(1267),
    [anon_sym_AMP_GT] = ACTIONS(1269),
    [anon_sym_AMP_GT_GT] = ACTIONS(1267),
    [anon_sym_LT_AMP] = ACTIONS(1267),
    [anon_sym_GT_AMP] = ACTIONS(1267),
    [anon_sym_LT_LT] = ACTIONS(1269),
    [anon_sym_LT_LT_DASH] = ACTIONS(1267),
    [anon_sym_LT_LT_LT] = ACTIONS(1267),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(765),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(767),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(769),
    [anon_sym_LF] = ACTIONS(1267),
    [anon_sym_AMP] = ACTIONS(1269),
  },
  [447] = {
    [aux_sym__literal_repeat1] = STATE(447),
    [sym__simple_heredoc_body] = ACTIONS(1373),
    [sym__heredoc_body_beginning] = ACTIONS(1373),
    [sym_file_descriptor] = ACTIONS(1373),
    [anon_sym_SEMI] = ACTIONS(1375),
    [anon_sym_PIPE] = ACTIONS(1375),
    [anon_sym_RPAREN] = ACTIONS(1373),
    [anon_sym_SEMI_SEMI] = ACTIONS(1373),
    [anon_sym_PIPE_AMP] = ACTIONS(1373),
    [anon_sym_AMP_AMP] = ACTIONS(1373),
    [anon_sym_PIPE_PIPE] = ACTIONS(1373),
    [anon_sym_EQ_TILDE] = ACTIONS(1375),
    [anon_sym_EQ_EQ] = ACTIONS(1375),
    [anon_sym_LT] = ACTIONS(1375),
    [anon_sym_GT] = ACTIONS(1375),
    [anon_sym_GT_GT] = ACTIONS(1373),
    [anon_sym_AMP_GT] = ACTIONS(1375),
    [anon_sym_AMP_GT_GT] = ACTIONS(1373),
    [anon_sym_LT_AMP] = ACTIONS(1373),
    [anon_sym_GT_AMP] = ACTIONS(1373),
    [anon_sym_LT_LT] = ACTIONS(1375),
    [anon_sym_LT_LT_DASH] = ACTIONS(1373),
    [anon_sym_LT_LT_LT] = ACTIONS(1373),
    [anon_sym_DOLLAR] = ACTIONS(1375),
    [sym__special_character] = ACTIONS(1377),
    [anon_sym_DQUOTE] = ACTIONS(1373),
    [sym_raw_string] = ACTIONS(1373),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1373),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1373),
    [anon_sym_BQUOTE] = ACTIONS(1373),
    [anon_sym_LT_LPAREN] = ACTIONS(1373),
    [anon_sym_GT_LPAREN] = ACTIONS(1373),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1375),
    [anon_sym_LF] = ACTIONS(1373),
    [anon_sym_AMP] = ACTIONS(1375),
  },
  [448] = {
    [sym_concatenation] = STATE(1036),
    [sym_string] = STATE(1041),
    [sym_array] = STATE(1036),
    [sym_simple_expansion] = STATE(1041),
    [sym_string_expansion] = STATE(1041),
    [sym_expansion] = STATE(1041),
    [sym_command_substitution] = STATE(1041),
    [sym_process_substitution] = STATE(1041),
    [aux_sym__literal_repeat1] = STATE(1046),
    [sym__empty_value] = ACTIONS(1921),
    [anon_sym_LPAREN] = ACTIONS(1923),
    [anon_sym_DOLLAR] = ACTIONS(1925),
    [sym__special_character] = ACTIONS(1927),
    [anon_sym_DQUOTE] = ACTIONS(1929),
    [sym_raw_string] = ACTIONS(1931),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1933),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1935),
    [anon_sym_BQUOTE] = ACTIONS(1937),
    [anon_sym_LT_LPAREN] = ACTIONS(1939),
    [anon_sym_GT_LPAREN] = ACTIONS(1939),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(1931),
  },
  [449] = {
    [sym__expression] = STATE(1048),
    [sym_binary_expression] = STATE(1048),
    [sym_unary_expression] = STATE(1048),
    [sym_postfix_expression] = STATE(1048),
    [sym_parenthesized_expression] = STATE(1048),
    [sym_concatenation] = STATE(1048),
    [sym_string] = STATE(280),
    [sym_simple_expansion] = STATE(280),
    [sym_string_expansion] = STATE(280),
    [sym_expansion] = STATE(280),
    [sym_command_substitution] = STATE(280),
    [sym_process_substitution] = STATE(280),
    [aux_sym__literal_repeat1] = STATE(286),
    [anon_sym_SEMI] = ACTIONS(1941),
    [anon_sym_SEMI_SEMI] = ACTIONS(1943),
    [anon_sym_LPAREN] = ACTIONS(473),
    [anon_sym_BANG] = ACTIONS(475),
    [anon_sym_DOLLAR] = ACTIONS(477),
    [sym__special_character] = ACTIONS(479),
    [anon_sym_DQUOTE] = ACTIONS(481),
    [sym_raw_string] = ACTIONS(483),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(485),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(487),
    [anon_sym_BQUOTE] = ACTIONS(489),
    [anon_sym_LT_LPAREN] = ACTIONS(491),
    [anon_sym_GT_LPAREN] = ACTIONS(491),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(493),
    [sym_test_operator] = ACTIONS(495),
    [anon_sym_LF] = ACTIONS(1943),
    [anon_sym_AMP] = ACTIONS(1943),
  },
  [450] = {
    [anon_sym_in] = ACTIONS(1945),
    [anon_sym_SEMI] = ACTIONS(1947),
    [anon_sym_SEMI_SEMI] = ACTIONS(1949),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(1949),
    [anon_sym_AMP] = ACTIONS(1949),
  },
  [451] = {
    [anon_sym_RPAREN_RPAREN] = ACTIONS(1951),
    [anon_sym_AMP_AMP] = ACTIONS(557),
    [anon_sym_PIPE_PIPE] = ACTIONS(557),
    [anon_sym_EQ_TILDE] = ACTIONS(559),
    [anon_sym_EQ_EQ] = ACTIONS(559),
    [anon_sym_EQ] = ACTIONS(561),
    [anon_sym_PLUS_EQ] = ACTIONS(557),
    [anon_sym_LT] = ACTIONS(561),
    [anon_sym_GT] = ACTIONS(561),
    [anon_sym_BANG_EQ] = ACTIONS(557),
    [anon_sym_PLUS] = ACTIONS(561),
    [anon_sym_DASH] = ACTIONS(561),
    [anon_sym_DASH_EQ] = ACTIONS(557),
    [anon_sym_LT_EQ] = ACTIONS(557),
    [anon_sym_GT_EQ] = ACTIONS(557),
    [anon_sym_PLUS_PLUS] = ACTIONS(563),
    [anon_sym_DASH_DASH] = ACTIONS(563),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(557),
  },
  [452] = {
    [sym_do_group] = STATE(1053),
    [anon_sym_do] = ACTIONS(1953),
    [sym_comment] = ACTIONS(57),
  },
  [453] = {
    [anon_sym_then] = ACTIONS(1955),
    [sym_comment] = ACTIONS(57),
  },
  [454] = {
    [aux_sym_concatenation_repeat1] = STATE(401),
    [sym__concat] = ACTIONS(695),
    [anon_sym_in] = ACTIONS(1957),
    [anon_sym_SEMI] = ACTIONS(1959),
    [anon_sym_SEMI_SEMI] = ACTIONS(1961),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(1961),
    [anon_sym_AMP] = ACTIONS(1961),
  },
  [455] = {
    [anon_sym_in] = ACTIONS(1957),
    [anon_sym_SEMI] = ACTIONS(1959),
    [anon_sym_SEMI_SEMI] = ACTIONS(1961),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(1961),
    [anon_sym_AMP] = ACTIONS(1961),
  },
  [456] = {
    [aux_sym__literal_repeat1] = STATE(418),
    [anon_sym_in] = ACTIONS(1963),
    [anon_sym_SEMI] = ACTIONS(1965),
    [anon_sym_SEMI_SEMI] = ACTIONS(1967),
    [sym__special_character] = ACTIONS(723),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(1967),
    [anon_sym_AMP] = ACTIONS(1967),
  },
  [457] = {
    [sym_compound_statement] = STATE(1060),
    [anon_sym_LPAREN] = ACTIONS(1969),
    [anon_sym_LBRACE] = ACTIONS(191),
    [sym_comment] = ACTIONS(57),
  },
  [458] = {
    [anon_sym_RPAREN] = ACTIONS(1971),
    [sym_comment] = ACTIONS(57),
  },
  [459] = {
    [sym__simple_heredoc_body] = ACTIONS(783),
    [sym__heredoc_body_beginning] = ACTIONS(783),
    [sym_file_descriptor] = ACTIONS(783),
    [anon_sym_SEMI] = ACTIONS(785),
    [anon_sym_PIPE] = ACTIONS(785),
    [anon_sym_SEMI_SEMI] = ACTIONS(783),
    [anon_sym_RBRACE] = ACTIONS(783),
    [anon_sym_PIPE_AMP] = ACTIONS(783),
    [anon_sym_AMP_AMP] = ACTIONS(783),
    [anon_sym_PIPE_PIPE] = ACTIONS(783),
    [anon_sym_LT] = ACTIONS(785),
    [anon_sym_GT] = ACTIONS(785),
    [anon_sym_GT_GT] = ACTIONS(783),
    [anon_sym_AMP_GT] = ACTIONS(785),
    [anon_sym_AMP_GT_GT] = ACTIONS(783),
    [anon_sym_LT_AMP] = ACTIONS(783),
    [anon_sym_GT_AMP] = ACTIONS(783),
    [anon_sym_LT_LT] = ACTIONS(785),
    [anon_sym_LT_LT_DASH] = ACTIONS(783),
    [anon_sym_LT_LT_LT] = ACTIONS(783),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(783),
    [anon_sym_AMP] = ACTIONS(785),
  },
  [460] = {
    [anon_sym_RBRACE] = ACTIONS(1973),
    [sym_comment] = ACTIONS(57),
  },
  [461] = {
    [sym__simple_heredoc_body] = ACTIONS(895),
    [sym__heredoc_body_beginning] = ACTIONS(895),
    [sym_file_descriptor] = ACTIONS(895),
    [anon_sym_SEMI] = ACTIONS(897),
    [anon_sym_PIPE] = ACTIONS(897),
    [anon_sym_SEMI_SEMI] = ACTIONS(895),
    [anon_sym_RBRACE] = ACTIONS(895),
    [anon_sym_PIPE_AMP] = ACTIONS(895),
    [anon_sym_AMP_AMP] = ACTIONS(895),
    [anon_sym_PIPE_PIPE] = ACTIONS(895),
    [anon_sym_LT] = ACTIONS(897),
    [anon_sym_GT] = ACTIONS(897),
    [anon_sym_GT_GT] = ACTIONS(895),
    [anon_sym_AMP_GT] = ACTIONS(897),
    [anon_sym_AMP_GT_GT] = ACTIONS(895),
    [anon_sym_LT_AMP] = ACTIONS(895),
    [anon_sym_GT_AMP] = ACTIONS(895),
    [anon_sym_LT_LT] = ACTIONS(897),
    [anon_sym_LT_LT_DASH] = ACTIONS(895),
    [anon_sym_LT_LT_LT] = ACTIONS(895),
    [sym_comment] = ACTIONS(57),
    [anon_sym_LF] = ACTIONS(895),
    [anon_sym_AMP] = ACTIONS(897),
  },
  [462] = {
    [anon_sym_AMP_AMP] = ACTIONS(923),
    [anon_sym_PIPE_PIPE] = ACTIONS(923),
    [anon_sym_RBRACK] = ACTIONS(1951),
    [anon_sym_EQ_TILDE] = ACTIONS(925),
    [anon_sym_EQ_EQ] = ACTIONS(925),
    [anon_sym_EQ] = ACTIONS(927),
    [anon_sym_PLUS_EQ] = ACTIONS(923),
    [anon_sym_LT] = ACTIONS(927),
    [anon_sym_GT] = ACTIONS(927),
    [anon_sym_BANG_EQ] = ACTIONS(923),
    [anon_sym_PLUS] = ACTIONS(927),
    [anon_sym_DASH] = ACTIONS(927),
    [anon_sym_DASH_EQ] = ACTIONS(923),
    [anon_sym_LT_EQ] = ACTIONS(923),
    [anon_sym_GT_EQ] = ACTIONS(923),
    [anon_sym_PLUS_PLUS] = ACTIONS(929),
    [anon_sym_DASH_DASH] = ACTIONS(929),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(923),
  },
  [463] = {
    [anon_sym_AMP_AMP] = ACTIONS(933),
    [anon_sym_PIPE_PIPE] = ACTIONS(933),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(1951),
    [anon_sym_EQ_TILDE] = ACTIONS(935),
    [anon_sym_EQ_EQ] = ACTIONS(935),
    [anon_sym_EQ] = ACTIONS(937),
    [anon_sym_PLUS_EQ] = ACTIONS(933),
    [anon_sym_LT] = ACTIONS(937),
    [anon_sym_GT] = ACTIONS(937),
    [anon_sym_BANG_EQ] = ACTIONS(933),
    [anon_sym_PLUS] = ACTIONS(937),
    [anon_sym_DASH] = ACTIONS(937),
    [anon_sym_DASH_EQ] = ACTIONS(933),
    [anon_sym_LT_EQ] = ACTIONS(933),
    [anon_sym_GT_EQ] = ACTIONS(933),
    [anon_sym_PLUS_PLUS] = ACTIONS(563),
    [anon_sym_DASH_DASH] = ACTIONS(563),
    [sym_comment] = ACTIONS(57),
    [sym_test_operator] = ACTIONS(933),
  },
  [464] = {
    [anon_sym_LBRACK] = ACTIONS(65),
    [anon_sym_EQ] = ACTIONS(1975),
    [anon_sym_PLUS_EQ] = ACTIONS(1975),
    [sym_comment] = ACTIONS(57),
  },
  [465] = {
    [sym_string] = STATE(1065),
    [anon_sym_DASH] = ACTIONS(1977),
    [anon_sym_DOLLAR] = ACTIONS(1977),
    [anon_sym_DQUOTE] = ACTIONS(793),
    [sym_raw_string] = ACTIONS(1979),
    [anon_sym_POUND] = ACTIONS(1977),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1981),
    [anon_sym_STAR] = ACTIONS(1983),
    [anon_sym_AT] = ACTIONS(1983),
    [anon_sym_QMARK] = ACTIONS(1983),
    [anon_sym_0] = ACTIONS(1981),
    [anon_sym__] = ACTIONS(1981),
  },
  [466] = {
    [aux_sym_concatenation_repeat1] = STATE(1068),
    [sym__simple_heredoc_body] = ACTIONS(335),
    [sym__heredoc_body_beginning] = ACTIONS(335),
    [sym_file_descriptor] = ACTIONS(335),
    [sym__concat] = ACTIONS(1985),
    [sym_variable_name] = ACTIONS(335),
    [anon_sym_SEMI] = ACTIONS(339),
    [anon_sym_PIPE] = ACTIONS(339),
    [anon_sym_SEMI_SEMI] = ACTIONS(335),
    [anon_sym_RBRACE] = ACTIONS(335),
    [anon_sym_PIPE_AMP] = ACTIONS(335),
    [anon_sym_AMP_AMP] = ACTIONS(335),
    [anon_sym_PIPE_PIPE] = ACTIONS(335),
    [anon_sym_LT] = ACTIONS(339),
    [anon_sym_GT] = ACTIONS(339),
    [anon_sym_GT_GT] = ACTIONS(335),
    [anon_sym_AMP_GT] = ACTIONS(339),
    [anon_sym_AMP_GT_GT] = ACTIONS(335),
    [anon_sym_LT_AMP] = ACTIONS(335),
    [anon_sym_GT_AMP] = ACTIONS(335),
    [anon_sym_LT_LT] = ACTIONS(339),
    [anon_sym_LT_LT_DASH] = ACTIONS(335),
    [anon_sym_LT_LT_LT] = ACTIONS(335),
    [anon_sym_DOLLAR] = ACTIONS(339),
    [sym__special_character] = ACTIONS(339),
    [anon_sym_DQUOTE] = ACTIONS(335),
    [sym_raw_string] = ACTIONS(335),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(335),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(335),
    [anon_sym_BQUOTE] = ACTIONS(335),
    [anon_sym_LT_LPAREN] = ACTIONS(335),
    [anon_sym_GT_LPAREN] = ACTIONS(335),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(339),
    [sym_word] = ACTIONS(339),
    [anon_sym_LF] = ACTIONS(335),
    [anon_sym_AMP] = ACTIONS(339),
  },
  [467] = {
    [sym_simple_expansion] = STATE(204),
    [sym_expansion] = STATE(204),
    [sym_command_substitution] = STATE(204),
    [aux_sym_string_repeat1] = STATE(1071),
    [anon_sym_DOLLAR] = ACTIONS(1987),
    [anon_sym_DQUOTE] = ACTIONS(1989),
    [sym__string_content] = ACTIONS(345),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(347),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(349),
    [anon_sym_BQUOTE] = ACTIONS(351),
    [sym_comment] = ACTIONS(329),
  },
  [468] = {
    [aux_sym_concatenation_repeat1] = STATE(1068),
    [sym__simple_heredoc_body] = ACTIONS(957),
    [sym__heredoc_body_beginning] = ACTIONS(957),
    [sym_file_descriptor] = ACTIONS(957),
    [sym__concat] = ACTIONS(1985),
    [sym_variable_name] = ACTIONS(957),
    [anon_sym_SEMI] = ACTIONS(959),
    [anon_sym_PIPE] = ACTIONS(959),
    [anon_sym_SEMI_SEMI] = ACTIONS(957),
    [anon_sym_RBRACE] = ACTIONS(957),
    [anon_sym_PIPE_AMP] = ACTIONS(957),
    [anon_sym_AMP_AMP] = ACTIONS(957),
    [anon_sym_PIPE_PIPE] = ACTIONS(957),
    [anon_sym_LT] = ACTIONS(959),
    [anon_sym_GT] = ACTIONS(959),
    [anon_sym_GT_GT] = ACTIONS(957),
    [anon_sym_AMP_GT] = ACTIONS(959),
    [anon_sym_AMP_GT_GT] = ACTIONS(957),
    [anon_sym_LT_AMP] = ACTIONS(957),
    [anon_sym_GT_AMP] = ACTIONS(957),
    [anon_sym_LT_LT] = ACTIONS(959),
    [anon_sym_LT_LT_DASH] = ACTIONS(957),
    [anon_sym_LT_LT_LT] = ACTIONS(957),
    [anon_sym_DOLLAR] = ACTIONS(959),
    [sym__special_character] = ACTIONS(959),
    [anon_sym_DQUOTE] = ACTIONS(957),
    [sym_raw_string] = ACTIONS(957),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(957),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(957),
    [anon_sym_BQUOTE] = ACTIONS(957),
    [anon_sym_LT_LPAREN] = ACTIONS(957),
    [anon_sym_GT_LPAREN] = ACTIONS(957),
    [sym_comment] = ACTIONS(57),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(959),
    [sym_word] = ACTIONS(959),
    [anon_sym_LF] = ACTIONS(957),
    [anon_sym_AMP] = ACTIONS(959),
  },
  [469] = {
    [sym_subscript] = STATE(1075),
    [sym_variable_name] = ACTIONS(1991),
    [anon_sym_BANG] = ACTIONS(1993),
    [anon_sym_DASH] = ACTIONS(1995),
    [anon_sym_DOLLAR] = ACTIONS(1995),
    [anon_sym_POUND] = ACTIONS(1993),
    [sym_comment] = ACTIONS(329),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1997),
    [anon_sym_STAR] = ACTIONS(1999),
    [anon_sym_AT] = ACTIONS(1999),
    [anon_sym_QMARK] = ACTIONS(1999),
    [anon_sym_0] = ACTIONS(1997),
    [anon_sym__] = ACTIONS(1997),
  },
  [470] = {
    [sym__statements] = STATE(1076),
    [sym_redirected_statement] = STATE(105),
    [sym_for_statement] = STATE(105),
    [sym_c_style_for_statement] = STATE(105),
    [sym_while_statement] = STATE(105),
    [sym_if_statement] = STATE(105),
    [sym_case_statement] = STATE(105),
    [sym_function_definition] = STATE(105),
    [sym_compound_statement] = STATE(105),
    [sym_subshell] = STATE(105),
    [sym_pipeline] = STATE(105),
    [sym_list] = STATE(105),
    [sym_negated_command] = STATE(105),
    [sym_test_command] = STATE(105),
    [sym_declaration_command] = STATE(105),
    [sym_unset_command] = STATE(105),
    [sym_command] = STATE(105),
    [sym_command_name] = STATE(106),
    [sym_variable_assignment] = STATE(107),
    [sym_subscript] = STATE(108),
    [sym_file_redirect] = STATE(1077),
    [sym_concatenation] = STATE(33),
    [sym_string] = STATE(102),
    [sym_simple_expansion] = STATE(102),
    [sym_string_expansion] = STATE(102),
    [sym_expansion] = STATE(102),
    [sym_command_substitution] = STATE(102),
    [sym_process_substitution] = STATE(102),
    [aux_sym__statements_repeat1] = STATE(109),
    [aux_sym_command_repeat1] = STATE(110),
    [aux_sym__literal_repeat1] = STATE(111),
    [sym_file_descriptor] = ACTIONS(367),
    [sym_variable_name] = ACTIONS(161),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_LPAREN_LPAREN] = ACTIONS(13),
    [anon_sym_while] = ACTIONS(15),
    [anon_sym_if] = ACTIONS(17),
    [anon_sym_case] = ACTIONS(19),
    [anon_sym_function] = ACTIONS(21),
    [anon_sym_LPAREN] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_BANG] = ACTIONS(163),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(31),
    [anon_sym_declare] = ACTIONS(165),
    [anon_sym_typeset] = ACTIONS(165),
    [anon_sym_export] = ACTIONS(165),
    [anon_sym_readonly] = ACTIONS(165),
    [anon_sym_local] = ACTIONS(165),
    [anon_sym_unset] = ACTIONS(167),
    [anon_sym_unsetenv] = ACTIONS(167),
    [anon_sym_LT] = ACTIONS(369),
    [anon_sym_GT] = ACTIONS(369),
    [anon_sym_GT_GT] = ACTIONS(371),
    [anon_sym_AMP_GT] = ACTIONS(369),
    [anon_sym_AMP_GT_GT] = ACTIONS(371),
    [anon_sym_LT_AMP] = ACTIONS(371),
    [anon_sym_GT_AMP] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym__special_character] = ACTIONS(169),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [sym_raw_string] = ACTIONS(171),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(49),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(51),
    [anon_sym_BQUOTE] = ACTIONS(53),
    [anon_sym_LT_LPAREN] = ACTIONS(55),
    [anon_sym_GT_LPAREN] = ACTIONS(55),
    [sym_comment] = ACTIONS(57),
    [sym_word] = ACTIONS(173),
  },
  [471] = {
    [sym__statements] = STATE(1078),
    [sym_redirected_statement] = STATE(225),
    [sym_for_statement] = STATE(225),
    [sym_c_style_for_statement] = STATE(225),
    [sym_while_statement] = STATE(225),
    [sym_if_statement] = STATE(225),
    [sym_case_statement] = STATE(225),
    [sym_function_definition] = STATE(225),
    [sym_compound_statement] = STATE(225),
    [sym_subshell] = STATE(225),
    [sym_pipeline] = STATE(225),
    [sym_list] = STATE(225),
    [sym_negated_command] = STATE(225),
    [sym_test_command] = STATE(225),
    [sym_declaration_command] = STATE(225),
    [sym_unset_command] = STATE(225),
    [sym_command] = STATE(225),
    [sym_command_name] = STATE(226),
    [sym_variable_assignment] = STATE(227),
   