/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import net.sf.freecol.common.io.FreeColDataFile;
import net.sf.freecol.common.io.FreeColXMLReader;

public class FreeColSavegameFile
extends FreeColDataFile {
    public static final String VERSION_TAG = "version";
    public static final String SAVEGAME_FILE = "savegame.xml";
    public static final String SAVEGAME_PROPERTIES = "savegame.properties";
    public static final String CLIENT_OPTIONS = "client-options.xml";
    public static final String THUMBNAIL_FILE = "thumbnail.png";
    private static final FileFilter fileFilter = FreeColSavegameFile.makeFileFilter("savegame.xml", "fsg", "zip");

    public FreeColSavegameFile(File file) throws IOException {
        super(file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getSavegameVersion() {
        try (FreeColXMLReader xr = this.getFreeColXMLReader();){
            xr.nextTag();
            int n = xr.getAttribute(VERSION_TAG, -1);
            return n;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public BufferedInputStream getSavegameInputStream() throws IOException {
        return this.getInputStream(SAVEGAME_FILE);
    }

    public FreeColXMLReader getFreeColXMLReader() throws IOException {
        return new FreeColXMLReader(this.getSavegameInputStream());
    }

    public static FileFilter getFileFilter() {
        return fileFilter;
    }
}

