/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;

public class HighSeas
extends UnitLocation {
    private static final Logger logger = Logger.getLogger(HighSeas.class.getName());
    private final List<Location> destinations = new ArrayList<Location>();
    private static final String DESTINATION_TAG = "destination";

    public HighSeas(Game game) {
        super(game);
    }

    public HighSeas(Game game, String id) {
        super(game, id);
    }

    public final List<Location> getDestinations() {
        return this.destinations;
    }

    public void addDestination(Location destination) {
        if (destination != null) {
            if (!this.destinations.contains(destination)) {
                this.destinations.add(destination);
            } else {
                logger.warning(this.getId() + " already included destination " + destination.getId());
            }
        } else {
            logger.warning("Tried to add null destination to " + this.getId());
        }
    }

    public void removeDestination(Location destination) {
        this.destinations.remove(destination);
    }

    @Override
    public FreeColGameObject getLinkTarget(Player player) {
        return player.getEurope();
    }

    @Override
    public StringTemplate getLocationLabel() {
        return StringTemplate.key("model.tile.highSeas.name");
    }

    @Override
    public Location up() {
        return this;
    }

    @Override
    public int getRank() {
        return -1;
    }

    @Override
    public String toShortString() {
        return "HighSeas";
    }

    @Override
    public UnitLocation.NoAddReason getNoAddReason(Locatable locatable) {
        return locatable instanceof Unit && ((Unit)locatable).isNaval() ? UnitLocation.NoAddReason.NONE : UnitLocation.NoAddReason.WRONG_TYPE;
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        for (Location destination : this.destinations) {
            if (destination == null) continue;
            xw.writeStartElement(DESTINATION_TAG);
            xw.writeLocationAttribute("id", destination);
            xw.writeEndElement();
        }
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.destinations.clear();
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Game game = this.getGame();
        String tag = xr.getLocalName();
        if (DESTINATION_TAG.equals(tag)) {
            this.addDestination(xr.getLocationAttribute(game, "id", true));
            xr.closeTag(DESTINATION_TAG);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String toString() {
        return this.getId();
    }

    @Override
    public String getXMLTagName() {
        return HighSeas.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "highSeas";
    }
}

