/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.health;

import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Spec;
import org.gradle.launcher.daemon.server.health.DaemonHealthStats;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectionStats;
import org.gradle.launcher.daemon.server.health.gc.GarbageCollectorMonitoringStrategy;

public class DaemonMemoryStatus {
    private static final Logger LOGGER = Logging.getLogger(DaemonMemoryStatus.class);
    public static final String ENABLE_PERFORMANCE_MONITORING = "org.gradle.daemon.performance.enable-monitoring";
    public static final String TENURED_USAGE_EXPIRE_AT = "org.gradle.daemon.performance.tenured-usage-expire-at";
    public static final String TENURED_RATE_EXPIRE_AT = "org.gradle.daemon.performance.tenured-rate-expire-at";
    public static final String PERMGEN_USAGE_EXPIRE_AT = "org.gradle.daemon.performance.permgen-usage-expire-at";
    public static final String THRASHING_EXPIRE_AT = "org.gradle.daemon.performance.thrashing-expire-at";
    private static final String TENURED = "tenured";
    private static final String PERMGEN = "perm gen";
    private final DaemonHealthStats stats;
    private final GarbageCollectorMonitoringStrategy strategy;
    private final int tenuredUsageThreshold;
    private final double tenuredRateThreshold;
    private final int permgenUsageThreshold;
    private final double thrashingThreshold;

    public DaemonMemoryStatus(DaemonHealthStats stats) {
        this.stats = stats;
        this.strategy = stats.getGcMonitor().getGcStrategy();
        this.tenuredUsageThreshold = DaemonMemoryStatus.parseValue(TENURED_USAGE_EXPIRE_AT, this.strategy.getTenuredUsageThreshold());
        this.tenuredRateThreshold = DaemonMemoryStatus.parseValue(TENURED_RATE_EXPIRE_AT, this.strategy.getGcRateThreshold());
        this.permgenUsageThreshold = DaemonMemoryStatus.parseValue(PERMGEN_USAGE_EXPIRE_AT, this.strategy.getPermGenUsageThreshold());
        this.thrashingThreshold = DaemonMemoryStatus.parseValue(THRASHING_EXPIRE_AT, this.strategy.getThrashingThreshold());
    }

    public boolean isTenuredSpaceExhausted() {
        GarbageCollectionStats gcStats = this.stats.getGcMonitor().getTenuredStats();
        return this.exceedsThreshold(TENURED, gcStats, new Spec<GarbageCollectionStats>(){

            @Override
            public boolean isSatisfiedBy(GarbageCollectionStats gcStats) {
                return DaemonMemoryStatus.this.tenuredUsageThreshold != 0 && DaemonMemoryStatus.this.tenuredRateThreshold != 0.0 && gcStats.getEventCount() >= 5L && gcStats.getUsage() >= DaemonMemoryStatus.this.tenuredUsageThreshold && gcStats.getRate() >= DaemonMemoryStatus.this.tenuredRateThreshold;
            }
        });
    }

    public boolean isPermGenSpaceExhausted() {
        GarbageCollectionStats gcStats = this.stats.getGcMonitor().getPermGenStats();
        return this.exceedsThreshold(PERMGEN, gcStats, new Spec<GarbageCollectionStats>(){

            @Override
            public boolean isSatisfiedBy(GarbageCollectionStats gcStats) {
                return DaemonMemoryStatus.this.permgenUsageThreshold != 0 && gcStats.getEventCount() >= 5L && gcStats.getUsage() >= DaemonMemoryStatus.this.permgenUsageThreshold;
            }
        });
    }

    public boolean isThrashing() {
        GarbageCollectionStats gcStats = this.stats.getGcMonitor().getTenuredStats();
        return this.exceedsThreshold(TENURED, gcStats, new Spec<GarbageCollectionStats>(){

            @Override
            public boolean isSatisfiedBy(GarbageCollectionStats gcStats) {
                return DaemonMemoryStatus.this.tenuredUsageThreshold != 0 && DaemonMemoryStatus.this.thrashingThreshold != 0.0 && gcStats.getEventCount() >= 5L && gcStats.getUsage() >= DaemonMemoryStatus.this.tenuredUsageThreshold && gcStats.getRate() >= DaemonMemoryStatus.this.thrashingThreshold;
            }
        });
    }

    private boolean exceedsThreshold(String pool, GarbageCollectionStats gcStats, Spec<GarbageCollectionStats> spec) {
        if (this.isEnabled() && this.strategy != GarbageCollectorMonitoringStrategy.UNKNOWN && spec.isSatisfiedBy(gcStats)) {
            if (gcStats.getUsage() > 0) {
                LOGGER.debug(String.format("GC rate: %.2f/s %s usage: %s%%", gcStats.getRate(), pool, gcStats.getUsage()));
            } else {
                LOGGER.debug("GC rate: 0.0/s");
            }
            return true;
        }
        return false;
    }

    private boolean isEnabled() {
        String enabledValue = System.getProperty(ENABLE_PERFORMANCE_MONITORING, "true");
        return Boolean.parseBoolean(enabledValue);
    }

    private static int parseValue(String property, int defaultValue) {
        String expireAt = System.getProperty(property);
        if (expireAt == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(expireAt);
        }
        catch (Exception e) {
            throw new GradleException(String.format("System property '%s' has incorrect value: '%s'. The value needs to be an integer.", property, expireAt));
        }
    }

    private static double parseValue(String property, double defaultValue) {
        String expireAt = System.getProperty(property);
        if (expireAt == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(expireAt);
        }
        catch (Exception e) {
            throw new GradleException(String.format("System property '%s' has incorrect value: '%s'. The value needs to be a double.", property, expireAt));
        }
    }
}

