/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import com.google.common.collect.Lists;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.VersionConflictException;
import org.gradle.api.specs.Spec;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.locking.LockOutOfDateException;
import org.gradle.internal.logging.text.StyledTextOutput;

class ResolutionErrorRenderer
implements Action<Throwable> {
    private final Spec<DependencyResult> dependencySpec;
    private final List<Action<StyledTextOutput>> errorActions = Lists.newArrayListWithExpectedSize((int)1);

    public ResolutionErrorRenderer(Spec<DependencyResult> dependencySpec) {
        this.dependencySpec = dependencySpec;
    }

    public void execute(Throwable throwable) {
        if (!(throwable instanceof ResolveException)) {
            throw UncheckedException.throwAsUncheckedException((Throwable)throwable);
        }
        Throwable cause = throwable.getCause();
        this.handleResolutionError(cause);
    }

    private void handleResolutionError(Throwable cause) {
        if (cause instanceof VersionConflictException) {
            this.handleConflict((VersionConflictException)cause);
        } else if (cause instanceof LockOutOfDateException) {
            this.handleOutOfDateLocks((LockOutOfDateException)cause);
        } else {
            throw UncheckedException.throwAsUncheckedException((Throwable)cause);
        }
    }

    private void handleOutOfDateLocks(final LockOutOfDateException cause) {
        this.registerError(new Action<StyledTextOutput>(){

            public void execute(StyledTextOutput output) {
                List errors = cause.getErrors();
                output.text((Object)"The dependency locks are out-of-date:");
                output.println();
                for (String error : errors) {
                    output.text((Object)("   - " + error));
                    output.println();
                }
                output.println();
            }
        });
    }

    private void handleConflict(final VersionConflictException conflict) {
        this.registerError(new Action<StyledTextOutput>(){

            public void execute(StyledTextOutput output) {
                for (List moduleVersionIdentifiers : conflict.getConflicts()) {
                    boolean matchesSpec = ResolutionErrorRenderer.this.hasVersionConflictOnRequestedDependency(moduleVersionIdentifiers);
                    if (!matchesSpec) continue;
                    output.text((Object)"Dependency resolution failed because of conflicts between the following modules:");
                    output.println();
                    for (ModuleVersionIdentifier moduleVersionIdentifier : moduleVersionIdentifiers) {
                        output.text((Object)"   - ");
                        output.withStyle(StyledTextOutput.Style.Error).text((Object)moduleVersionIdentifier.toString());
                        output.println();
                    }
                    output.println();
                }
            }
        });
    }

    public void renderErrors(StyledTextOutput output) {
        for (Action<StyledTextOutput> errorAction : this.errorActions) {
            errorAction.execute((Object)output);
        }
    }

    private void registerError(Action<StyledTextOutput> errorAction) {
        this.errorActions.add(errorAction);
    }

    private boolean hasVersionConflictOnRequestedDependency(List<ModuleVersionIdentifier> moduleVersionIdentifiers) {
        boolean matchesSpec = false;
        for (final ModuleVersionIdentifier mvi : moduleVersionIdentifiers) {
            matchesSpec |= this.dependencySpec.isSatisfiedBy((Object)new DependencyResult(){

                public ComponentSelector getRequested() {
                    return DefaultModuleComponentSelector.newSelector((ModuleIdentifier)mvi.getModule(), (String)mvi.getVersion());
                }

                public ResolvedComponentResult getFrom() {
                    return null;
                }

                public boolean isConstraint() {
                    return false;
                }
            });
        }
        return matchesSpec;
    }
}

