/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.xml;

public class XmlValidation {
    public static boolean isValidXmlName(CharSequence name) {
        int pos;
        int nsPos = 0;
        int nsCount = 0;
        for (pos = 0; pos < name.length(); ++pos) {
            char ch = name.charAt(pos);
            if (ch == ':') {
                if (++nsCount > 1) {
                    return false;
                }
                if (pos <= 0) continue;
                nsPos = pos + 1;
                continue;
            }
            if (!(pos == nsPos ? !XmlValidation.isValidNameStartChar(ch) : !XmlValidation.isValidNameChar(ch))) continue;
            return false;
        }
        return pos != nsPos;
    }

    private static boolean isValidNameChar(char ch) {
        if (XmlValidation.isValidNameStartChar(ch)) {
            return true;
        }
        if (ch >= '0' && ch <= '9') {
            return true;
        }
        if (ch == '-' || ch == '.' || ch == '\u00b7') {
            return true;
        }
        if (ch >= '\u0300' && ch <= '\u036f') {
            return true;
        }
        return ch >= '\u203f' && ch <= '\u2040';
    }

    private static boolean isValidNameStartChar(char ch) {
        if (ch >= 'A' && ch <= 'Z') {
            return true;
        }
        if (ch >= 'a' && ch <= 'z') {
            return true;
        }
        if (ch == ':' || ch == '_') {
            return true;
        }
        if (ch >= '\u00c0' && ch <= '\u00d6') {
            return true;
        }
        if (ch >= '\u00d8' && ch <= '\u00f6') {
            return true;
        }
        if (ch >= '\u00f8' && ch <= '\u02ff') {
            return true;
        }
        if (ch >= '\u0370' && ch <= '\u037d') {
            return true;
        }
        if (ch >= '\u037f' && ch <= '\u1fff') {
            return true;
        }
        if (ch >= '\u200c' && ch <= '\u200d') {
            return true;
        }
        if (ch >= '\u2070' && ch <= '\u218f') {
            return true;
        }
        if (ch >= '\u2c00' && ch <= '\u2fef') {
            return true;
        }
        if (ch >= '\u3001' && ch <= '\ud7ff') {
            return true;
        }
        if (ch >= '\uf900' && ch <= '\ufdcf') {
            return true;
        }
        return ch >= '\ufdf0' && ch <= '\ufffd';
    }

    public static boolean isLegalCharacter(char c) {
        if (c == '\t' || c == '\n' || c == '\r') {
            return true;
        }
        if (c < ' ') {
            return false;
        }
        if (c <= '\ud7ff') {
            return true;
        }
        if (c < '\ue000') {
            return false;
        }
        if (c <= '\ufffd') {
            return true;
        }
        if (c < '\u10000') {
            return false;
        }
        return c <= '\u10ffff';
    }

    public static boolean isRestrictedCharacter(char c) {
        if (c == '\t' || c == '\n' || c == '\r' || c == '\u0085') {
            return false;
        }
        if (c <= '\u001f') {
            return true;
        }
        if (c < '\u007f') {
            return false;
        }
        return c <= '\u009f';
    }
}

