/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.context;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.binding.MutableClosure;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.org.objectweb.asm.Type;

public class ConstructorContext
extends MethodContext {
    private boolean thisInitialized = false;
    private final KotlinTypeMapper kotlinTypeMapper;

    public ConstructorContext(@NotNull ConstructorDescriptor contextDescriptor, @NotNull OwnerKind kind, @NotNull CodegenContext parent2, @Nullable MutableClosure closure, @NotNull KotlinTypeMapper kotlinTypeMapper) {
        super(contextDescriptor, kind, parent2, closure, false);
        this.kotlinTypeMapper = kotlinTypeMapper;
    }

    @Override
    public StackValue getOuterExpression(StackValue prefix, boolean ignoreNoOuter) {
        StackValue.Local stackValue;
        ClassDescriptor capturedOuterClassDescriptor;
        ClassDescriptor classDescriptor2 = capturedOuterClassDescriptor = this.closure != null ? this.closure.getCapturedOuterClassDescriptor() : null;
        if (capturedOuterClassDescriptor != null) {
            if (capturedOuterClassDescriptor.isInline()) {
                SimpleType outerClassKotlinType = capturedOuterClassDescriptor.getDefaultType();
                Type outerClassType = this.kotlinTypeMapper.mapType(capturedOuterClassDescriptor);
                stackValue = StackValue.local(1, outerClassType, outerClassKotlinType);
            } else {
                stackValue = StackValue.local(1, AsmTypes.OBJECT_TYPE);
            }
        } else {
            stackValue = null;
        }
        if (!ignoreNoOuter && stackValue == null) {
            throw new UnsupportedOperationException("Don't know how to generate outer expression for " + this.getContextDescriptor());
        }
        return stackValue;
    }

    public ConstructorDescriptor getConstructorDescriptor() {
        return (ConstructorDescriptor)this.getContextDescriptor();
    }

    public boolean isThisInitialized() {
        return this.thisInitialized;
    }

    public void setThisInitialized(boolean thisInitialized) {
        this.thisInitialized = thisInitialized;
    }

    @Override
    public boolean isContextWithUninitializedThis() {
        return !this.isThisInitialized();
    }

    @Override
    public String toString() {
        return "Constructor: " + (this.isThisInitialized() ? "" : "UNINITIALIZED ") + this.getContextDescriptor();
    }
}

