/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.updatesite.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.osgi.updatesite.xml.Archive;
import org.apache.ivy.osgi.updatesite.xml.CategoryDef;
import org.apache.ivy.osgi.updatesite.xml.EclipseFeature;
import org.apache.ivy.osgi.updatesite.xml.UpdateSite;
import org.apache.ivy.osgi.util.DelegetingHandler;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.util.XMLHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EclipseUpdateSiteParser {
    public static UpdateSite parse(InputStream in) throws ParseException, IOException, SAXException {
        SiteHandler handler = new SiteHandler();
        try {
            XMLHelper.parse(in, null, (DefaultHandler)handler, null);
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
        return handler.updatesite;
    }

    static class CategoryDefHandler
    extends DelegetingHandler {
        private static final String CATEGORY_DEF = "category-def";
        private static final String NAME = "name";
        private static final String LABEL = "label";
        private CategoryDef categoryDef;

        public CategoryDefHandler() {
            super(CATEGORY_DEF);
            this.addChild(new DescriptionHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                    CategoryDefHandler.this.categoryDef.setDescription(child.getBufferedChars().trim());
                }
            });
        }

        protected void handleAttributes(Attributes atts) throws SAXException {
            this.categoryDef = new CategoryDef();
            String name = atts.getValue(NAME);
            this.categoryDef.setName(name);
            String label = atts.getValue(LABEL);
            this.categoryDef.setLabel(label);
        }
    }

    static class ArchiveHandler
    extends DelegetingHandler {
        private static final String ARCHIVE = "archive";
        private static final String URL = "url";
        private static final String PATH = "path";
        private Archive archive;

        public ArchiveHandler() {
            super(ARCHIVE);
        }

        protected void handleAttributes(Attributes atts) throws SAXException {
            this.archive = new Archive();
            String path = atts.getValue(PATH);
            this.archive.setPath(path);
            String url = atts.getValue(URL);
            this.archive.setURL(url);
        }
    }

    static class CategoryHandler
    extends DelegetingHandler {
        private static final String CATEGORY = "category";
        private static final String NAME = "name";
        String name;

        public CategoryHandler() {
            super(CATEGORY);
        }

        protected void handleAttributes(Attributes atts) throws SAXException {
            this.name = atts.getValue(NAME);
        }
    }

    static class FeatureHandler
    extends DelegetingHandler {
        private static final String FEATURE = "feature";
        private static final String VERSION = "version";
        private static final String ID = "id";
        private static final String URL = "url";
        private static final String PATCH = "patch";
        private static final String ARCH = "arch";
        private static final String NL = "nl";
        private static final String WS = "ws";
        private static final String OS = "os";
        private static final String LABEL = "label";
        private static final String TYPE = "type";
        private EclipseFeature feature;

        public FeatureHandler() {
            super(FEATURE);
            this.addChild(new CategoryHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                    FeatureHandler.this.feature.addCategory(((CategoryHandler)child).name);
                }
            });
        }

        protected void handleAttributes(Attributes atts) throws SAXException {
            String id = atts.getValue(ID);
            String version = atts.getValue(VERSION);
            try {
                this.feature = new EclipseFeature(id, new Version(version));
            }
            catch (ParseException e) {
                throw new SAXException("Incorrect version on the feature '" + id + "': " + version + " (" + e.getMessage() + ")");
            }
            String url = atts.getValue(URL);
            if (url != null) {
                this.feature.setURL(url);
            }
            this.feature.setType(atts.getValue(TYPE));
            this.feature.setLabel(atts.getValue(LABEL));
            this.feature.setOS(atts.getValue(OS));
            this.feature.setWS(atts.getValue(WS));
            this.feature.setNL(atts.getValue(NL));
            this.feature.setArch(atts.getValue(ARCH));
            this.feature.setPatch(atts.getValue(PATCH));
        }
    }

    static class DescriptionHandler
    extends DelegetingHandler {
        private static final String DESCRIPTION = "description";
        private static final String URL = "url";

        public DescriptionHandler() {
            super(DESCRIPTION);
            this.setBufferingChar(true);
        }

        protected void handleAttributes(Attributes atts) {
            String url = atts.getValue(URL);
        }
    }

    static class SiteHandler
    extends DelegetingHandler {
        private static final String SITE = "site";
        private static final String URL = "url";
        private static final String PACK200 = "pack200";
        private static final String MIRRORS_URL = "mirrorsURL";
        private static final String ASSOCIATE_SITES_URL = "associateSitesURL";
        private static final String DIGEST_URL = "digestURL";
        UpdateSite updatesite;

        public SiteHandler() {
            super(SITE);
            this.addChild(new FeatureHandler(), new DelegetingHandler.ChildElementHandler(){

                public void childHanlded(DelegetingHandler child) {
                    SiteHandler.this.updatesite.addFeature(((FeatureHandler)child).feature);
                }
            });
        }

        protected void handleAttributes(Attributes atts) {
            String associateSitesURL;
            String digestURL;
            String pack200;
            String mirrorsURL;
            this.updatesite = new UpdateSite();
            String url = atts.getValue(URL);
            if (url != null && !"".equals(url.trim())) {
                if (!url.endsWith("/") && !url.endsWith(File.separator)) {
                    url = url + "/";
                }
                try {
                    this.updatesite.setUri(new URI(url));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("illegal url", e);
                }
            }
            if ((mirrorsURL = atts.getValue(MIRRORS_URL)) != null && mirrorsURL.trim().length() > 0) {
                this.updatesite.setMirrorsURL(mirrorsURL);
            }
            if ((pack200 = atts.getValue(PACK200)) != null && new Boolean(pack200).booleanValue()) {
                this.updatesite.setPack200(true);
            }
            if ((digestURL = atts.getValue(DIGEST_URL)) != null) {
                try {
                    this.updatesite.setDigestUri(new URI(digestURL));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("illegal url", e);
                }
            }
            if ((associateSitesURL = atts.getValue(ASSOCIATE_SITES_URL)) != null) {
                this.updatesite.setAssociateSitesURL(associateSitesURL);
            }
        }
    }
}

