/*
 * Copyright 2009 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.api.reporting.internal;

import org.gradle.api.Task;
import org.gradle.internal.Factory;

public abstract class TaskGeneratedReport extends SimpleReport {

    private static String getDisplayName(String name, Task task) {
        return "Report generated by task '" + task.getPath() + "' (" + name + ")";
    }

    public TaskGeneratedReport(final String name, OutputType outputType, final Task task) {
        super(name, new Factory<String>() {
            @Override
            public String create() {
                return getDisplayName(name, task);
            }
        }, outputType, task.getProject());
    }

}
