/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize;

import javajs.util.BS;
import javajs.util.Lst;
import org.jmol.minimize.MinBond;
import org.jmol.minimize.forcefield.AtomType;
import org.jmol.modelset.Atom;

public class MinAtom {
    int index;
    public String sType;
    public Atom atom;
    public AtomType ffAtomType;
    public int ffType;
    public Integer vdwKey;
    public double[] coord = new double[3];
    public double[] force = new double[3];
    private Lst<MinBond> bonds = new Lst();
    public int nBonds;
    public int hCount;
    public double partialCharge;
    public BS bsVdw = new BS();
    public BS bs14 = new BS();
    int[] bondedAtoms;

    public String toString() {
        return "#" + this.index + " " + this.sType;
    }

    MinAtom(int index, Atom atom, double[] coord, int ac) {
        this.index = index;
        this.atom = atom;
        this.coord = coord;
        this.bsVdw.setBits(index + 1, ac);
        this.bsVdw.clear(index);
        this.hCount = atom.getCovalentHydrogenCount();
    }

    void set() {
        this.coord[0] = this.atom.x;
        this.coord[1] = this.atom.y;
        this.coord[2] = this.atom.z;
    }

    public MinBond getBondTo(int iAtom) {
        this.getBondedAtomIndexes();
        for (int i = 0; i < this.nBonds; ++i) {
            if (this.bondedAtoms[i] != iAtom) continue;
            return (MinBond)this.bonds.get(i);
        }
        return null;
    }

    public int[] getBondedAtomIndexes() {
        if (this.bondedAtoms == null) {
            this.bondedAtoms = new int[this.nBonds];
            int i = this.nBonds;
            while (--i >= 0) {
                this.bondedAtoms[i] = ((MinBond)this.bonds.get(i)).getOtherAtom(this.index);
            }
        }
        return this.bondedAtoms;
    }

    public String getIdentity() {
        return this.atom.getInfo();
    }

    public void addBond(MinBond bond, int i) {
        this.bonds.addLast(bond);
        ++this.nBonds;
        this.bsVdw.clear(i);
    }

    public int getBondIndex(int j) {
        return ((MinBond)this.bonds.get((int)j)).index;
    }

    public static boolean isLinear(MinAtom minAtom) {
        switch (minAtom.ffType) {
            case 4: 
            case 53: 
            case 61: {
                return true;
            }
        }
        return false;
    }
}

