/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.molxyz;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.PT;
import org.jmol.adapter.readers.molxyz.MolReader;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class V3000Rdr {
    private MolReader mr;
    private String line;
    private Map<String, String[]> userData;

    V3000Rdr set(AtomSetCollectionReader atomSetCollectionReader) {
        this.mr = (MolReader)atomSetCollectionReader;
        return this;
    }

    void readAtomsAndBonds(String[] stringArray) throws Exception {
        int n = this.mr.parseIntStr(stringArray[3]);
        this.readAtoms(n);
        this.readBonds(this.mr.parseIntStr(stringArray[4]));
        this.readUserData(n);
    }

    private void readAtoms(int n) throws Exception {
        this.mr.discardLinesUntilContains("BEGIN ATOM");
        int n2 = 0;
        while (n2 < n) {
            this.rd();
            this.checkLineContinuation();
            String[] stringArray = this.mr.getTokens();
            int n3 = this.mr.parseIntStr(stringArray[2]);
            String string = stringArray[3];
            if (!string.equals("*")) {
                float f = this.mr.parseFloatStr(stringArray[4]);
                float f2 = this.mr.parseFloatStr(stringArray[5]);
                float f3 = this.mr.parseFloatStr(stringArray[6]);
                int n4 = 0;
                int n5 = 0;
                int n6 = 7;
                while (n6 < stringArray.length) {
                    String string2 = stringArray[n6].toUpperCase();
                    if (string2.startsWith("CHG=")) {
                        n4 = this.mr.parseIntAt(stringArray[n6], 4);
                    } else if (string2.startsWith("MASS=")) {
                        n5 = this.mr.parseIntAt(stringArray[n6], 5);
                    }
                    ++n6;
                }
                if (n5 > 1 && string.equals("H")) {
                    n5 = 1 - n5;
                }
                this.mr.addMolAtom(n3, n5, string, n4, f, f2, f3);
            }
            ++n2;
        }
        this.mr.discardLinesUntilContains("END ATOM");
    }

    private void readBonds(int n) throws Exception {
        this.mr.discardLinesUntilContains("BEGIN BOND");
        if (n == 0) {
            this.mr.asc.setNoAutoBond();
        }
        int n2 = 0;
        while (n2 < n) {
            this.rd();
            int n3 = 0;
            this.checkLineContinuation();
            String[] stringArray = this.mr.getTokens();
            int n4 = this.mr.parseIntStr(stringArray[3]);
            String string = stringArray[4];
            String string2 = stringArray[5];
            String string3 = this.getField("CFG");
            if (string3 == null) {
                String string4 = this.getField("ENDPTS");
                if (string4 != null && this.line.indexOf("ATTACH=ALL") >= 0) {
                    stringArray = PT.getTokens(string4);
                    int n5 = this.mr.parseIntStr(stringArray[0]);
                    int n6 = this.mr.fixOrder(n4, 0);
                    int n7 = 1;
                    while (n7 <= n5) {
                        this.mr.asc.addNewBondFromNames(string, stringArray[n7], n6);
                        ++n7;
                    }
                }
            } else {
                n3 = this.mr.parseIntStr(string3);
            }
            this.mr.addMolBond(string, string2, n4, n3);
            ++n2;
        }
        this.mr.discardLinesUntilContains("END BOND");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void readUserData(int var1_1) throws Exception {
        this.userData = null;
        var2_2 = null;
        while (!this.rd().contains("END CTAB")) {
            if (this.line.contains("BEGIN SGROUP")) ** GOTO lbl47
            continue;
lbl-1000:
            // 1 sources

            {
                if (this.userData == null) {
                    this.userData = new Hashtable<String, String[]>();
                }
                if ((var3_3 = this.getField("ATOMS")) == null || (var4_4 = this.getField("FIELDNAME")) == null || (var5_5 /* !! */  = this.getField("FIELDDATA")) == null) continue;
                v0 = var6_6 = (var4_4 = var4_4.toLowerCase()).indexOf("partial") >= 0;
                if (var6_6) {
                    if (var2_2 == null) {
                        var2_2 = var4_4;
                    } else if (!var2_2.equals(var4_4)) {
                        var6_6 = false;
                    }
                }
                if (var6_6) {
                    var7_9 = this.mr.asc.atoms;
                    var8_13 = this.mr.asc.getLastAtomSetAtomIndex();
                    var9_15 = this.mr.asc.ac;
                    while (var8_13 < var9_15) {
                        var7_9[var8_13].partialCharge = 0.0f;
                        ++var8_13;
                    }
                }
                var7_9 = null;
                var8_12 = 0.0f;
                if (var6_6) {
                    var8_12 = this.mr.parseFloatStr((String)var5_5 /* !! */ );
                } else {
                    var7_9 = this.userData.get(var4_4);
                    if (var7_9 == null) {
                        var7_9 = new String[var1_1];
                        this.userData.put((String)var4_4, (String[])var7_9);
                    }
                }
                try {
                    var9_14 = PT.getTokens(var3_3);
                    var10_17 = var9_14.length;
                    while (--var10_17 >= 1) {
                        var11_18 = var9_14[var10_17];
                        if (var6_6) {
                            this.mr.asc.getAtomFromName((String)var11_18).partialCharge = var8_12;
                            continue;
                        }
                        var7_9[this.mr.parseIntStr((String)var11_18) - 1] = var5_5 /* !! */ ;
                    }
                    continue;
                }
                catch (Exception var9_16) {
                    // empty catch block
                }
lbl47:
                // 4 sources

                ** while (!this.rd().contains((CharSequence)"END SGROUP"))
            }
lbl48:
            // 1 sources

        }
        if (this.userData == null) {
            return;
        }
        for (String var3_3 : this.userData.keySet()) {
            var5_5 /* !! */  = this.userData.get(var3_3);
            var6_8 = new float[var5_5 /* !! */ .length];
            var7_11 = 0;
            while (var7_11 < var5_5 /* !! */ .length) {
                var6_8[var7_11] = var5_5 /* !! */ [var7_11] == null ? 0.0f : this.mr.parseFloatStr(var5_5 /* !! */ [var7_11]);
                ++var7_11;
            }
            this.mr.asc.setAtomProperties(var3_3, var6_8, -1, false);
        }
    }

    private String getField(String string) {
        int n = this.line.indexOf(String.valueOf(string) + "=");
        if (n < 0) {
            return null;
        }
        char c = ' ';
        switch (this.line.charAt(n += string.length() + 1)) {
            case '\"': {
                c = '\"';
                break;
            }
            case '(': {
                c = ')';
                break;
            }
            case '+': {
                break;
            }
            default: {
                --n;
            }
        }
        return this.line.substring(n + 1, (String.valueOf(this.line) + c).indexOf(c, n + 1));
    }

    private String rd() throws Exception {
        this.line = this.mr.rd();
        return this.line;
    }

    private void checkLineContinuation() throws Exception {
        while (this.line.endsWith("-")) {
            String string = this.line;
            this.rd();
            this.line = String.valueOf(string) + this.line;
        }
    }
}

