/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import javajs.util.PT;
import javajs.util.T3;
import org.jmol.adapter.readers.more.ForceFieldReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;

public class Mol2Reader
extends ForceFieldReader {
    private int nAtoms = 0;
    private int ac = 0;
    private boolean isPDB = false;
    private int lastSequenceNumber = Integer.MAX_VALUE;
    private int chainID = 64;

    @Override
    protected void initializeReader() throws Exception {
        this.setUserAtomTypes();
    }

    @Override
    public boolean checkLine() throws Exception {
        if (this.line.equals("@<TRIPOS>MOLECULE")) {
            if (!this.processMolecule()) {
                return true;
            }
            this.continuing = !this.isLastModel(this.modelNumber);
            return false;
        }
        if (this.line.length() != 0 && this.line.charAt(0) == '#') {
            this.checkCurrentLineForScript();
        }
        return true;
    }

    private boolean processMolecule() throws Exception {
        this.isPDB = false;
        String string = this.rd().trim();
        if (!this.doGetModel(++this.modelNumber, string)) {
            return false;
        }
        this.lastSequenceNumber = Integer.MAX_VALUE;
        this.chainID = 64;
        this.rd();
        this.line = String.valueOf(this.line) + " 0 0 0 0 0 0";
        this.ac = this.parseIntStr(this.line);
        int n = this.parseInt();
        if (n == 0) {
            this.asc.setNoAutoBond();
        }
        int n2 = this.parseInt();
        this.rd();
        this.rd();
        if (this.rd() != null && (this.line.length() == 0 || this.line.charAt(0) != '@') && this.rd() != null && this.line.length() != 0 && this.line.charAt(0) != '@') {
            if (this.line.indexOf("jmolscript:") >= 0) {
                this.checkCurrentLineForScript();
                if (this.line.equals("#")) {
                    this.line = "";
                }
            }
            if (this.line.length() != 0) {
                string = String.valueOf(string) + ": " + this.line.trim();
            }
        }
        this.newAtomSet(string);
        while (this.line != null && !this.line.equals("@<TRIPOS>MOLECULE")) {
            if (this.line.equals("@<TRIPOS>ATOM")) {
                this.readAtoms(this.ac);
                this.asc.setAtomSetName(string);
            } else if (this.line.equals("@<TRIPOS>BOND")) {
                this.readBonds(n);
            } else if (this.line.equals("@<TRIPOS>SUBSTRUCTURE")) {
                this.readResInfo(n2);
            } else if (this.line.equals("@<TRIPOS>CRYSIN")) {
                this.readCrystalInfo();
            }
            this.rd();
        }
        this.nAtoms += this.ac;
        if (this.isPDB) {
            this.setIsPDB();
            this.setModelPDB(true);
        }
        this.applySymmetryAndSetTrajectory();
        return true;
    }

    private void readAtoms(int n) throws Exception {
        Object object;
        if (n == 0) {
            return;
        }
        int n2 = this.asc.ac;
        int n3 = 0;
        while (n3 < n) {
            object = this.asc.addNewAtom();
            String[] stringArray = PT.getTokens(this.rd());
            String string = stringArray[5];
            String string2 = stringArray[1];
            int n4 = string.indexOf(".");
            if (n4 >= 0) {
                ((Atom)object).elementSymbol = string.substring(0, n4);
            } else {
                ((Atom)object).atomName = string2;
                ((Atom)object).elementSymbol = ((Atom)object).getElementSymbol();
            }
            ((Atom)object).atomName = String.valueOf(string2) + '\u0000' + string;
            ((T3)object).set(this.parseFloatStr(stringArray[2]), this.parseFloatStr(stringArray[3]), this.parseFloatStr(stringArray[4]));
            if (stringArray.length > 6) {
                ((Atom)object).sequenceNumber = this.parseIntStr(stringArray[6]);
                if (((Atom)object).sequenceNumber < this.lastSequenceNumber) {
                    if (this.chainID == 90) {
                        this.chainID = 96;
                    }
                    ++this.chainID;
                }
                this.lastSequenceNumber = ((Atom)object).sequenceNumber;
                this.setChainID((Atom)object, "" + (char)this.chainID);
            }
            if (stringArray.length > 7) {
                ((Atom)object).group3 = stringArray[7];
            }
            if (stringArray.length > 8) {
                ((Atom)object).partialCharge = this.parseFloatStr(stringArray[8]);
                if (((Atom)object).partialCharge == (float)((int)((Atom)object).partialCharge)) {
                    ((Atom)object).formalCharge = (int)((Atom)object).partialCharge;
                }
            }
            ++n3;
        }
        Atom[] atomArray = this.asc.atoms;
        object = atomArray[n2].group3;
        if (object == null) {
            return;
        }
        boolean bl = false;
        if (!((String)object).equals("UNK") && !((String)object).startsWith("RES")) {
            int n5 = this.asc.ac;
            while (--n5 >= n2) {
                if (((String)object).equals(atomArray[this.asc.ac - 1].group3)) continue;
                bl = true;
                break;
            }
            if (bl) {
                bl = false;
                n5 = this.asc.ac;
                while (--n5 >= n2) {
                    int n6 = this.getPDBGroupLength(atomArray[n5].group3);
                    if (n6 == 0 || n6 > 3) break;
                    if (!this.vwr.getJBR().isKnownPDBGroup(((String)object).substring(0, n6), Integer.MAX_VALUE)) continue;
                    this.isPDB = true;
                    bl = true;
                    break;
                }
            }
        }
        int n7 = this.asc.ac;
        while (--n7 >= n2) {
            if (bl) {
                object = atomArray[n7].group3;
                object = ((String)object).substring(0, this.getPDBGroupLength((String)object));
                atomArray[n7].isHetero = this.vwr.getJBR().isHetero((String)object);
            } else {
                object = null;
            }
            atomArray[n7].group3 = object;
        }
    }

    private int getPDBGroupLength(String string) {
        int n;
        int n2 = n = string.length();
        while (--n2 > 0 && Character.isDigit(string.charAt(n2))) {
        }
        return ++n2;
    }

    private void readBonds(int n) throws Exception {
        int n2 = 0;
        while (n2 < n) {
            String[] stringArray = PT.getTokens(this.rd());
            int n3 = this.parseIntStr(stringArray[1]);
            int n4 = this.parseIntStr(stringArray[2]);
            int n5 = this.parseIntStr(stringArray[3]);
            if (n5 == Integer.MIN_VALUE) {
                n5 = stringArray[3].equals("ar") ? 515 : (stringArray[3].equals("am") ? 1 : 17);
            }
            this.asc.addBond(new Bond(this.nAtoms + n3 - 1, this.nAtoms + n4 - 1, n5));
            ++n2;
        }
    }

    private void readResInfo(int n) throws Exception {
        int n2 = 0;
        while (n2 < n) {
            this.rd();
            ++n2;
        }
    }

    private void readCrystalInfo() throws Exception {
        this.rd();
        String[] stringArray = this.getTokens();
        if (stringArray.length < 6) {
            return;
        }
        String string = "";
        int n = 6;
        while (n < stringArray.length) {
            string = String.valueOf(string) + " " + stringArray[n];
            ++n;
        }
        string = string == "" ? " P1" : String.valueOf(string) + " *";
        string = string.substring(1);
        this.setSpaceGroupName(string);
        if (this.ignoreFileUnitCell) {
            return;
        }
        n = 0;
        while (n < 6) {
            this.setUnitCellItem(n, this.parseFloatStr(stringArray[n]));
            ++n;
        }
        Atom[] atomArray = this.asc.atoms;
        int n2 = 0;
        while (n2 < this.ac) {
            this.setAtomCoord(atomArray[this.nAtoms + n2]);
            ++n2;
        }
    }
}

