/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.readers.quantum.MOReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Elements;
import org.jmol.util.Logger;

public class NWChemReader
extends MOReader {
    private int taskNumber = 1;
    private int equivalentAtomSets = 0;
    private String energyKey = "";
    private String energyValue = "";
    private boolean converged;
    private boolean haveEnergy;
    private boolean haveAt;
    private boolean inInput;
    private Lst<String> atomTypes;
    private Map<String, Lst<String>> htMOs = new Hashtable<String, Lst<String>>();
    int nBasisFunctions;
    private static String DS_LIST = "d2-   d1-   d0    d1+   d2+";
    private static String FS_LIST = "f3-   f2-   f1-   f0    f1+   f2+   f3+";
    private static String DC_LIST = "DXX   DXY   DXZ   DYY   DYZ   DZZ";
    private static String FC_LIST = "XXX   XXY   XXZ   XYY   XYZ   XZZ   YYY   YYZ   YZZ   ZZZ";
    int moCount;
    private boolean purging;

    @Override
    protected void initializeReader() {
        this.calculationType = "(NWCHEM)";
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.trim().startsWith("NWChem")) {
            boolean bl = this.inInput = this.line.indexOf("NWChem Input Module") >= 0;
            if (this.inInput) {
                this.checkMOs();
            }
        }
        if (this.line.startsWith("          Step")) {
            this.init();
            return true;
        }
        if (this.line.indexOf("  wavefunction    = ") >= 0) {
            this.calculationType = String.valueOf(this.line.substring(this.line.indexOf("=") + 1).trim()) + "(NWCHEM)";
            this.moData.put("calculationType", this.calculationType);
            return true;
        }
        if (this.line.indexOf("Total") >= 0) {
            this.readTotal();
            return true;
        }
        if (this.line.indexOf("@") >= 0) {
            this.readAtSign();
            return true;
        }
        if (this.line.startsWith(" Task  times")) {
            this.init();
            ++this.taskNumber;
            return true;
        }
        if (this.line.startsWith("      Optimization converged")) {
            this.converged = true;
            return true;
        }
        if (this.line.startsWith("      Symmetry information")) {
            this.readSymmetry();
            return true;
        }
        if (this.line.indexOf("Output coordinates in ") >= 0) {
            String string = this.line;
            if (!this.htMOs.isEmpty()) {
                this.checkMOs();
            }
            if (!this.doGetModel(++this.modelNumber, null)) {
                return this.checkLastModel();
            }
            ++this.equivalentAtomSets;
            this.readAtoms(string);
            return true;
        }
        if (this.line.indexOf("Vibrational analysis") >= 0) {
            this.readFrequencies();
            return true;
        }
        if (!this.doProcessLines) {
            return true;
        }
        if (this.line.startsWith("  Mulliken analysis of the total density")) {
            if (this.equivalentAtomSets != 0) {
                this.readPartialCharges();
            }
            return true;
        }
        if (this.line.contains("Basis \"ao basis\"") && this.doReadMolecularOrbitals) {
            return this.readBasis();
        }
        if (this.line.contains("Molecular Orbital Analysis")) {
            if (this.equivalentAtomSets != 0) {
                this.readMOs();
            }
            return true;
        }
        return true;
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        this.checkMOs();
        this.finalizeReaderASCR();
    }

    private void init() {
        this.haveEnergy = false;
        this.haveAt = false;
        this.converged = false;
        this.inInput = false;
        this.equivalentAtomSets = 0;
    }

    private void setEnergies(String string, String string2, int n) {
        this.energyKey = string;
        this.energyValue = string2;
        this.setProps(this.energyKey, this.energyValue, this.equivalentAtomSets);
        this.setNames(String.valueOf(this.energyKey) + " = " + this.energyValue, null, this.equivalentAtomSets);
        this.asc.setAtomSetEnergy(string2, this.parseFloatStr(string2));
        this.haveEnergy = true;
    }

    private void setEnergy(String string, String string2) {
        this.energyKey = string;
        this.energyValue = string2;
        this.asc.setAtomSetModelProperty(this.energyKey, this.energyValue);
        this.asc.setAtomSetName(String.valueOf(this.energyKey) + " = " + this.energyValue);
        this.haveEnergy = true;
    }

    private void readSymmetry() throws Exception {
        String[] stringArray = PT.getTokens(this.readLines(3));
        this.setProps("Symmetry group name", stringArray[stringArray.length - 1], this.equivalentAtomSets);
    }

    private void readTotal() {
        String[] stringArray = this.getTokens();
        try {
            if (stringArray[2].startsWith("energy") && !this.haveAt) {
                this.setEnergies("E(" + stringArray[1] + ")", stringArray[stringArray.length - 1], this.equivalentAtomSets);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readAtSign() throws Exception {
        if (this.line.charAt(2) == 'S' && this.readLines(2) == null) {
            return;
        }
        String[] stringArray = this.getTokens();
        if (!this.haveEnergy) {
            this.setEnergies("E", stringArray[2], this.equivalentAtomSets);
        } else {
            this.setEnergies(this.energyKey, this.energyValue, this.equivalentAtomSets);
        }
        this.setProps("Step", stringArray[1], this.equivalentAtomSets);
        this.haveAt = true;
    }

    private void setProps(String string, String string2, int n) {
        int n2 = this.asc.iSet;
        while (--n >= 0 && n2 >= 0) {
            this.asc.setAtomSetModelPropertyForSet(string, string2, n2);
            --n2;
        }
    }

    private void setNames(String string, BS bS, int n) {
        int n2 = this.asc.iSet;
        while (--n >= 0 && n2 >= 0) {
            if (bS == null || !bS.get(n2)) {
                this.asc.setModelInfoForSet("name", string, n2);
            }
            --n2;
        }
    }

    private void readAtoms(String string) throws Exception {
        float f = string.indexOf("angstroms") < 0 ? 0.5291772f : 1.0f;
        this.readLines(3);
        this.haveEnergy = false;
        this.asc.newAtomSet();
        this.asc.setAtomSetModelProperty(".PATH", "Task " + this.taskNumber + (this.inInput ? String.valueOf(SmarterJmolAdapter.PATH_SEPARATOR) + "Input" : String.valueOf(SmarterJmolAdapter.PATH_SEPARATOR) + "Geometry"));
        this.atomTypes = new Lst();
        while (this.rd() != null && this.line.length() > 0) {
            String string2;
            String[] stringArray = this.getTokens();
            if (stringArray.length < 6) break;
            this.setAtomCoordScaled(null, (String[])stringArray, (int)3, (float)f).atomName = string2 = this.fixTag(stringArray[1]);
            this.atomTypes.addLast(string2);
        }
        if (this.converged) {
            this.setEnergy(this.energyKey, this.energyValue);
            this.asc.setAtomSetModelProperty("Step", "converged");
        } else if (this.inInput) {
            this.asc.setAtomSetName("Input");
        }
    }

    private void readGradients() throws Exception {
        Properties properties;
        this.readLines(3);
        this.asc.newAtomSet();
        if (this.equivalentAtomSets > 1 && (properties = (Properties)this.asc.getAtomSetAuxiliaryInfoValue(this.asc.iSet - 1, "modelProperties")) != null) {
            this.asc.setCurrentModelInfo("modelProperties", properties.clone());
        }
        this.asc.setAtomSetModelProperty("vector", "gradient");
        this.asc.setAtomSetModelProperty(".PATH", "Task " + this.taskNumber + SmarterJmolAdapter.PATH_SEPARATOR + "Gradients");
        float f = 0.5291772f;
        while (this.rd() != null && this.line.length() > 0) {
            String[] stringArray = this.getTokens();
            if (stringArray.length < 8) break;
            Atom atom = this.setAtomCoordScaled(null, stringArray, 2, f);
            atom.atomName = this.fixTag(stringArray[1]);
            this.asc.addVibrationVector(atom.index, -this.parseFloatStr(stringArray[5]), -this.parseFloatStr(stringArray[6]), -this.parseFloatStr(stringArray[7]));
        }
    }

    private void readFrequencies() throws Exception {
        int n;
        int n2;
        int n3;
        String[] stringArray;
        int n4 = this.asc.atomSetCount;
        int n5 = this.vibrationNumber;
        String string = "Task " + this.taskNumber + SmarterJmolAdapter.PATH_SEPARATOR + "Frequencies";
        this.discardLinesUntilContains("Atom information");
        this.readLines(2);
        this.asc.newAtomSet();
        while (this.rd() != null && this.line.indexOf("---") < 0) {
            stringArray = this.getTokens();
            this.setAtomCoordScaled(null, (String[])stringArray, (int)2, (float)0.5291772f).atomName = this.fixTag(stringArray[0]);
        }
        this.discardLinesUntilContains("(Projected Frequencies expressed in cm-1)");
        this.readLines(3);
        boolean bl = true;
        BS bS = new BS();
        while (this.rd() != null && this.line.indexOf("P.Frequency") >= 0) {
            stringArray = PT.getTokensAt(this.line, 12);
            n3 = stringArray.length;
            n2 = this.asc.ac;
            n = this.asc.getLastAtomSetAtomCount();
            if (bl) {
                n2 -= n;
            }
            boolean[] blArray = new boolean[n3];
            int n6 = 0;
            while (n6 < n3) {
                boolean bl2 = blArray[n6] = stringArray[n6].equals("0.00") || !this.doGetVibration(++this.vibrationNumber);
                if (blArray[n6]) {
                    bS.set(this.vibrationNumber);
                } else {
                    if (!bl) {
                        this.asc.cloneLastAtomSet();
                    }
                    bl = false;
                    this.asc.setAtomSetFrequency(this.vibrationNumber, string, null, stringArray[n6], null);
                }
                ++n6;
            }
            this.readLines(1);
            this.fillFrequencyData(n2, n, n, blArray, false, 0, 0, null, 0, null);
            this.readLines(3);
        }
        try {
            this.discardLinesUntilContains("Infra Red Intensities");
            this.readLines(2);
            n3 = n4;
            n2 = n5;
            while (n2 < this.vibrationNumber) {
                if (this.rd() == null) {
                    return;
                }
                if (!bS.get(n2)) {
                    stringArray = this.getTokens();
                    n = this.asc.iSet;
                    this.asc.iSet = n3++;
                    this.asc.setAtomSetModelProperty("IRIntensity", String.valueOf(stringArray[3]) + " au");
                    this.asc.iSet = n;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            System.out.println("nwchem infra red issue" + exception);
        }
    }

    /*
     * Unable to fully structure code
     */
    void readPartialCharges() throws Exception {
        this.readLines(4);
        var2_1 = this.asc.ac;
        var3_2 = this.asc.getLastAtomSetAtomIndex();
        var4_3 = this.asc.atoms;
        var5_4 = var3_2;
        ** GOTO lbl17
        {
            ++var5_4;
            do {
                if (var4_3[var5_4].elementNumber == 0) continue block0;
                do {
                    if (this.rd() != null && this.line.length() >= 3) continue;
                    return;
                } while ((var1_5 = this.getTokens())[0].indexOf(".") >= 0);
                var4_3[var5_4].partialCharge = (float)this.parseIntStr(var1_5[2]) - this.parseFloatStr(var1_5[3]);
                ++var5_4;
lbl17:
                // 2 sources

            } while (var5_4 < var2_1);
        }
    }

    private String fixTag(String string) {
        if (string.equalsIgnoreCase("bq")) {
            return "X";
        }
        if (string.toLowerCase().startsWith("bq")) {
            string = String.valueOf(string.substring(2)) + "-Bq";
        }
        return Character.toUpperCase(string.charAt(0)) + (string.length() == 1 ? "" : "" + Character.toLowerCase(string.charAt(1)));
    }

    /*
     * Unable to fully structure code
     */
    private boolean readBasis() throws Exception {
        this.gaussianCount = 0;
        this.shellCount = 0;
        this.nBasisFunctions = 0;
        v0 = var1_1 = this.line.indexOf("cartesian") >= 0;
        if (var1_1) {
            this.getDFMap("DC", NWChemReader.DC_LIST, 4, "DXX   DYY   DZZ   DXY   DXZ   DYZ", 3);
            this.getDFMap("FC", NWChemReader.FC_LIST, 6, "XXX   YYY   ZZZ   XYY   XXY   XXZ   XZZ   YZZ   YYZ   XYZ", 3);
        } else {
            this.getDFMap("DS", NWChemReader.DS_LIST, 3, "d0    d1+   d1-   d2+   d2-", 2);
            this.getDFMap("FS", NWChemReader.FS_LIST, 5, "f0    f1+   f1-   f2+   f2-   f3+   f3-", 2);
        }
        this.shells = new Lst<V>();
        var2_2 = new Hashtable<String, Lst<V>>();
        var3_3 = null;
        var4_4 = null;
        var5_5 = null;
        while (this.line != null) {
            var6_6 = 0;
            while (this.line.length() < 3 || this.line.charAt(2) == ' ') {
                var5_5 = new Lst();
                this.rd();
                if (this.line.length() >= 3) continue;
                ++var6_6;
            }
            if (var6_6 >= 2) break;
            if (this.parseIntStr(this.line) != -2147483648) ** GOTO lbl48
            var3_3 = this.getTokens()[0];
            if (var3_3.length() > 2) {
                var3_3 = JmolAdapter.getElementSymbol(Elements.elementNumberFromName(var3_3));
            }
            var4_4 = new Lst<Lst>();
            var2_2.put(var3_3, var4_4);
            this.rd();
            this.rd();
            continue;
lbl-1000:
            // 1 sources

            {
                var7_7 = this.getTokens();
                var8_9 = new Object[]{var7_7[1], new float[]{this.parseFloatStr(var7_7[2]), this.parseFloatStr(var7_7[3])}};
                var5_5.addLast(var8_9);
                this.rd();
lbl48:
                // 2 sources

                ** while (this.line != null && this.line.length() > 3)
            }
lbl49:
            // 1 sources

            var4_4.addLast(var5_5);
        }
        var6_6 = var1_1 != false ? 6 : 5;
        var7_8 = var1_1 != false ? 10 : 7;
        var8_9 = new Lst();
        var9_10 = 0;
        while (var9_10 < this.atomTypes.size()) {
            var4_4 = (Lst<Lst>)var2_2.get(this.atomTypes.get(var9_10));
            var10_11 = var4_4.size();
            var11_12 = 0;
            while (var11_12 < var10_11) {
                ++this.shellCount;
                var5_5 = (Lst)var4_4.get(var11_12);
                var12_13 = var5_5.size();
                var13_14 = (String)((Object[])var5_5.get(0))[0];
                switch (var13_14.charAt(0)) {
                    case 'S': {
                        ++this.nBasisFunctions;
                        break;
                    }
                    case 'P': {
                        this.nBasisFunctions += 3;
                        break;
                    }
                    case 'D': {
                        this.nBasisFunctions += var6_6;
                        break;
                    }
                    case 'F': {
                        this.nBasisFunctions += var7_8;
                    }
                }
                var14_15 = new int[]{var9_10 + 1, var1_1 != false ? BasisFunctionReader.getQuantumShellTagID(var13_14) : BasisFunctionReader.getQuantumShellTagIDSpherical(var13_14), this.gaussianCount + 1, var12_13};
                this.shells.addLast(var14_15);
                var15_16 = 0;
                while (var15_16 < var12_13) {
                    var8_9.addLast((float[])((Object[])var5_5.get(var15_16))[1]);
                    ++var15_16;
                }
                this.gaussianCount += var12_13;
                ++var11_12;
            }
            ++var9_10;
        }
        this.gaussians = AU.newFloat2(this.gaussianCount);
        var9_10 = 0;
        while (var9_10 < this.gaussianCount) {
            this.gaussians[var9_10] = (float[])var8_9.get(var9_10);
            ++var9_10;
        }
        Logger.info(String.valueOf(this.gaussianCount) + " Gaussians read");
        return true;
    }

    private boolean readMOs() throws Exception {
        Lst<String> lst = new Lst<String>();
        this.htMOs.put(this.line, lst);
        lst.addLast(this.line);
        int n = 0;
        while (n != 2 && this.rd() != null) {
            lst.addLast(this.line);
            if (this.line.length() < 2) {
                ++n;
                continue;
            }
            n = 0;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private void checkMOs() throws Exception {
        if (this.shells == null) {
            return;
        }
        block0: for (Map.Entry<String, Lst<String>> var1_2 : this.htMOs.entrySet()) {
            this.line = var1_2.getKey();
            this.alphaBeta = String.valueOf(this.line.substring(0, this.line.indexOf("Final")).trim()) + " ";
            var3_3 = 0;
            if (!this.filterMO()) continue;
            var4_4 = var1_2.getValue();
            var5_5 = var4_4.size();
            Logger.info(this.line);
            var6_6 = 3;
            ** GOTO lbl46
            {
                ++var6_6;
                do {
                    if (var6_6 < var5_5 && ((this.line = (String)var4_4.get(var6_6)).length() < 2 || this.line.charAt(1) != 'V')) continue block1;
                    if (var6_6 == var5_5) continue block0;
                    this.line = this.line.replace('=', ' ');
                    var7_7 = this.getTokens();
                    var8_8 = this.parseFloatStr(var7_7[3]);
                    var9_9 = this.parseFloatStr(var7_7[5]);
                    var10_10 = var7_7.length > 7 ? var7_7[7] : null;
                    var11_11 = new Hashtable<String, Object>();
                    var11_11.put("occupancy", Float.valueOf(var8_8));
                    var11_11.put("energy", Float.valueOf(var9_9));
                    if (var10_10 != null) {
                        var11_11.put("symmetry", var10_10);
                    }
                    var12_12 = null;
                    this.setMO(var11_11);
                    var11_11.put("type", String.valueOf(this.alphaBeta) + ++var3_3);
                    var12_12 = new float[this.nBasisFunctions];
                    var11_11.put("coefficients", var12_12);
                    var6_6 += 3;
                    while ((this.line = (String)var4_4.get(++var6_6)) != null && this.line.length() > 3) {
                        var7_7 = this.getTokens();
                        var12_12[this.parseIntStr((String)var7_7[0]) - 1] = this.parseFloatStr(var7_7[1]);
                        var13_13 = var7_7.length / 2;
                        if (var13_13 != 5 && var13_13 != 6) continue;
                        var12_12[this.parseIntStr((String)var7_7[var13_13]) - 1] = this.parseFloatStr(var7_7[var13_13 + 1]);
                    }
                    ++var6_6;
lbl46:
                    // 2 sources

                } while (var6_6 < var5_5);
            }
        }
        this.energyUnits = "a.u.";
        this.setMOData(true);
        this.htMOs.clear();
    }

    @Override
    public String rd() throws Exception {
        this.RL();
        if (!this.purging && this.line != null && this.line.startsWith("--")) {
            this.purging = true;
            this.discardLinesUntilStartsWith("*");
            this.rd();
            this.purging = false;
            this.RL();
        }
        return this.line;
    }
}

