/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences.sources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.sources.ExtendedSourceEntry;
import org.openstreetmap.josm.data.preferences.sources.SourceEntry;
import org.openstreetmap.josm.data.preferences.sources.SourcePrefHelper;
import org.openstreetmap.josm.data.preferences.sources.SourceType;
import org.openstreetmap.josm.data.validation.tests.MapCSSTagChecker;
import org.openstreetmap.josm.tools.I18n;

public class ValidatorPrefHelper
extends SourcePrefHelper {
    public static final ValidatorPrefHelper INSTANCE = new ValidatorPrefHelper();
    public static final String PREFIX = "validator";
    public static final BooleanProperty PREF_LAYER = new BooleanProperty("validator.layer", true);
    public static final String PREF_SKIP_TESTS = "validator.skip";
    public static final BooleanProperty PREF_USE_IGNORE = new BooleanProperty("validator.ignore", true);
    public static final String PREF_SKIP_TESTS_BEFORE_UPLOAD = "validator.skipBeforeUpload";
    public static final BooleanProperty PREF_OTHER_UPLOAD = new BooleanProperty("validator.otherUpload", false);
    public static final BooleanProperty PREF_OTHER = new BooleanProperty("validator.other", false);
    public static final String PREF_IGNORELIST = "validator.ignorelist";
    public static final String PREF_FILTER_BY_SELECTION = "validator.selectionFilter";

    public ValidatorPrefHelper() {
        super(MapCSSTagChecker.ENTRIES_PREF_KEY, SourceType.TAGCHECKER_RULE);
    }

    @Override
    public Collection<ExtendedSourceEntry> getDefault() {
        ArrayList<ExtendedSourceEntry> def = new ArrayList<ExtendedSourceEntry>();
        this.addDefault(def, "addresses", I18n.tr("Addresses", new Object[0]), I18n.tr("Checks for errors on addresses", new Object[0]));
        this.addDefault(def, "combinations", I18n.tr("Tag combinations", new Object[0]), I18n.tr("Checks for missing tag or suspicious combinations", new Object[0]));
        this.addDefault(def, "deprecated", I18n.tr("Deprecated features", new Object[0]), I18n.tr("Checks for deprecated features", new Object[0]));
        this.addDefault(def, "geometry", I18n.tr("Geometry", new Object[0]), I18n.tr("Checks for geometry errors", new Object[0]));
        this.addDefault(def, "highway", I18n.tr("Highways", new Object[0]), I18n.tr("Checks for errors on highways", new Object[0]));
        this.addDefault(def, "multiple", I18n.tr("Multiple values", new Object[0]), I18n.tr("Checks for wrong multiple values", new Object[0]));
        this.addDefault(def, "numeric", I18n.tr("Numeric values", new Object[0]), I18n.tr("Checks for wrong numeric values", new Object[0]));
        this.addDefault(def, "religion", I18n.tr("Religion", new Object[0]), I18n.tr("Checks for errors on religious objects", new Object[0]));
        this.addDefault(def, "relation", I18n.tr("Relations", new Object[0]), I18n.tr("Checks for errors on relations", new Object[0]));
        this.addDefault(def, "territories", I18n.tr("Territories", new Object[0]), I18n.tr("Checks for territories-specific features", new Object[0]));
        this.addDefault(def, "unnecessary", I18n.tr("Unnecessary tags", new Object[0]), I18n.tr("Checks for unnecessary tags", new Object[0]));
        this.addDefault(def, "wikipedia", I18n.tr("Wikipedia", new Object[0]), I18n.tr("Checks for wrong wikipedia tags", new Object[0]));
        return def;
    }

    private void addDefault(List<ExtendedSourceEntry> defaults, String filename, String title, String description) {
        ExtendedSourceEntry i = new ExtendedSourceEntry(this.type, filename + ".mapcss", "resource://data/validator/" + filename + ".mapcss");
        i.title = title;
        i.description = description;
        defaults.add(i);
    }

    @Override
    public Map<String, String> serialize(SourceEntry entry) {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("url", entry.url);
        res.put("title", entry.title == null ? "" : entry.title);
        res.put("active", Boolean.toString(entry.active));
        return res;
    }

    @Override
    public SourceEntry deserialize(Map<String, String> s) {
        return new SourceEntry(this.type, s.get("url"), null, s.get("title"), Boolean.parseBoolean(s.get("active")));
    }
}

