/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import org.bouncycastle.jsse.BCSSLConnection;
import org.bouncycastle.jsse.provider.ProvSSLSession;
import org.bouncycastle.tls.ProtocolName;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsContext;

class ProvSSLConnection
implements BCSSLConnection {
    protected final TlsContext tlsContext;
    protected final ProvSSLSession session;

    ProvSSLConnection(TlsContext tlsContext, ProvSSLSession provSSLSession) {
        this.tlsContext = tlsContext;
        this.session = provSSLSession;
    }

    public String getApplicationProtocol() {
        ProtocolName protocolName;
        SecurityParameters securityParameters = this.tlsContext.getSecurityParametersConnection();
        if (null != securityParameters && null != (protocolName = securityParameters.getApplicationProtocol())) {
            return protocolName.getUtf8Decoding();
        }
        return "";
    }

    public byte[] getChannelBinding(String string) {
        if (string.equals("tls-server-end-point")) {
            return this.tlsContext.exportChannelBinding(0);
        }
        if (string.equals("tls-unique")) {
            return this.tlsContext.exportChannelBinding(1);
        }
        throw new UnsupportedOperationException();
    }

    public ProvSSLSession getSession() {
        return this.session;
    }
}

