/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsSecret;

public abstract class TlsRSAUtils {
    private TlsRSAUtils() {
    }

    public static TlsSecret generateEncryptedPreMasterSecret(TlsContext tlsContext, TlsCertificate tlsCertificate, OutputStream outputStream) throws IOException {
        TlsSecret tlsSecret = tlsContext.getCrypto().generateRSAPreMasterSecret(tlsContext.getClientVersion());
        byte[] byArray = tlsSecret.encrypt(tlsCertificate);
        TlsUtils.writeOpaque16(byArray, outputStream);
        return tlsSecret;
    }
}

