/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.InvalidKeyException;
import java.util.Hashtable;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.util.Integers;

public class JceTlsHMAC
implements TlsHMAC {
    private static final Hashtable internalBlockSizes = new Hashtable();
    private final Mac hmac;
    private final String algorithm;
    private final Integer internalBlockSize;

    public JceTlsHMAC(Mac mac, String string) {
        this(mac, string, JceTlsHMAC.getInternalBlockSize(string));
    }

    private static int getInternalBlockSize(String string) {
        if (!internalBlockSizes.containsKey(string)) {
            throw new IllegalArgumentException("HMAC " + string + " unknown");
        }
        return (Integer)internalBlockSizes.get(string);
    }

    public JceTlsHMAC(Mac mac, String string, int n) {
        this.hmac = mac;
        this.algorithm = string;
        this.internalBlockSize = Integers.valueOf((int)n);
    }

    public void setKey(byte[] byArray, int n, int n2) {
        try {
            this.hmac.init(new SecretKeySpec(byArray, n, n2, this.algorithm));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException(invalidKeyException.getMessage());
        }
    }

    public void update(byte[] byArray, int n, int n2) {
        this.hmac.update(byArray, n, n2);
    }

    public byte[] calculateMAC() {
        return this.hmac.doFinal();
    }

    public int getInternalBlockSize() {
        return this.internalBlockSize;
    }

    public int getMacLength() {
        return this.hmac.getMacLength();
    }

    public void reset() {
        this.hmac.reset();
    }

    static {
        internalBlockSizes.put("HmacMD5", Integers.valueOf((int)64));
        internalBlockSizes.put("HmacSHA1", Integers.valueOf((int)64));
        internalBlockSizes.put("HmacSHA256", Integers.valueOf((int)64));
        internalBlockSizes.put("HmacSHA384", Integers.valueOf((int)128));
        internalBlockSizes.put("HmacSHA512", Integers.valueOf((int)128));
    }
}

