/*
 * Decompiled with CFR 0.152.
 */
package jnr.constants.platform.darwin;

import java.util.EnumMap;
import java.util.Map;
import jnr.constants.Constant;

public enum TCP implements Constant
{
    TCP_MAX_SACK(4L),
    TCP_MSS(512L),
    TCP_MINMSS(216L),
    TCP_MAXWIN(65535L),
    TCP_MAX_WINSHIFT(14L),
    TCP_MAXHLEN(60L),
    TCP_MAXOLEN(40L),
    TCP_NODELAY(1L),
    TCP_MAXSEG(2L),
    TCP_NOPUSH(4L),
    TCP_NOOPT(8L),
    TCP_KEEPALIVE(16L);

    private final long value;
    public static final long MIN_VALUE = 1L;
    public static final long MAX_VALUE = 65535L;

    private TCP(long value2) {
        this.value = value2;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    public final int value() {
        return (int)this.value;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final boolean defined() {
        return true;
    }

    static final class StringTable {
        public static final Map<TCP, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<TCP, String> generateTable() {
            EnumMap<TCP, String> map2 = new EnumMap<TCP, String>(TCP.class);
            map2.put(TCP_MAX_SACK, "TCP_MAX_SACK");
            map2.put(TCP_MSS, "TCP_MSS");
            map2.put(TCP_MINMSS, "TCP_MINMSS");
            map2.put(TCP_MAXWIN, "TCP_MAXWIN");
            map2.put(TCP_MAX_WINSHIFT, "TCP_MAX_WINSHIFT");
            map2.put(TCP_MAXHLEN, "TCP_MAXHLEN");
            map2.put(TCP_MAXOLEN, "TCP_MAXOLEN");
            map2.put(TCP_NODELAY, "TCP_NODELAY");
            map2.put(TCP_MAXSEG, "TCP_MAXSEG");
            map2.put(TCP_NOPUSH, "TCP_NOPUSH");
            map2.put(TCP_NOOPT, "TCP_NOOPT");
            map2.put(TCP_KEEPALIVE, "TCP_KEEPALIVE");
            return map2;
        }
    }
}

