/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jvm.abi;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.CompilationErrorHandler;
import org.jetbrains.kotlin.codegen.KotlinCodegenFacade;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollector;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.container.ComponentProvider;
import org.jetbrains.kotlin.context.ProjectContext;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.incremental.FileUtilsKt;
import org.jetbrains.kotlin.jvm.abi.JvmAbiAnalysisHandlerExtension;
import org.jetbrains.kotlin.jvm.abi.JvmAbiAnalysisHandlerExtension$WhenMappings;
import org.jetbrains.kotlin.jvm.abi.asm.AbiClassBuilder;
import org.jetbrains.kotlin.jvm.abi.asm.FilterInnerClassesVisitor;
import org.jetbrains.kotlin.jvm.abi.asm.InnerClassesCollectingVisitor;
import org.jetbrains.kotlin.load.kotlin.FileBasedKotlinClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmProtoBufUtil;
import org.jetbrains.kotlin.modules.TargetId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.extensions.AnalysisHandlerExtension;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u0015\u0016\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/jvm/abi/JvmAbiAnalysisHandlerExtension;", "Lorg/jetbrains/kotlin/resolve/jvm/extensions/AnalysisHandlerExtension;", "compilerConfiguration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;)V", "analysisCompleted", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "bindingTrace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "removeUnneededClasses", "", "outputs", "", "Lorg/jetbrains/kotlin/jvm/abi/JvmAbiAnalysisHandlerExtension$AbiOutput;", "AbiBinaries", "AbiOutput", "ClassData", "jvm-abi-gen"})
public final class JvmAbiAnalysisHandlerExtension
implements AnalysisHandlerExtension {
    private final CompilerConfiguration compilerConfiguration;

    @Nullable
    public AnalysisResult analysisCompleted(@NotNull Project project, @NotNull ModuleDescriptor module, @NotNull BindingTrace bindingTrace, @NotNull Collection<? extends KtFile> files) {
        boolean bl;
        BindingContext bindingContext;
        block9: {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Intrinsics.checkParameterIsNotNull((Object)bindingTrace, (String)"bindingTrace");
            Intrinsics.checkParameterIsNotNull(files, (String)"files");
            BindingContext bindingContext2 = bindingTrace.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"bindingTrace.bindingContext");
            bindingContext = bindingContext2;
            Diagnostics diagnostics = bindingContext.getDiagnostics();
            Intrinsics.checkExpressionValueIsNotNull((Object)diagnostics, (String)"bindingContext.diagnostics");
            Iterable $this$any$iv = (Iterable)diagnostics;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Diagnostic it = (Diagnostic)element$iv;
                    boolean bl2 = false;
                    if (!(it.getSeverity() == Severity.ERROR)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        String string = (String)this.compilerConfiguration.get(CommonConfigurationKeys.MODULE_NAME);
        if (string == null) {
            String string2 = module.getName().asString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"module.name.asString()");
        }
        TargetId targetId = new TargetId(string, "java-production");
        GenerationState generationState = new GenerationState.Builder(project, (ClassBuilderFactory)AbiBinaries.INSTANCE, module, bindingContext, CollectionsKt.toList((Iterable)files), this.compilerConfiguration).targetId(targetId).build();
        KotlinCodegenFacade.compileCorrectFiles((GenerationState)generationState, (CompilationErrorHandler)CompilationErrorHandler.THROW_EXCEPTION);
        Object object = this.compilerConfiguration.get(JVMConfigurationKeys.OUTPUT_DIRECTORY);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"compilerConfiguration.ge\u2026nKeys.OUTPUT_DIRECTORY)!!");
        File outputDir = (File)object;
        ArrayList<AbiOutput> outputs = new ArrayList<AbiOutput>();
        for (OutputFile outputFile : generationState.getFactory().asList()) {
            File file = new File(outputDir, outputFile.getRelativePath());
            outputs.add(new AbiOutput(file, outputFile.getSourceFiles(), outputFile.asByteArray()));
        }
        MessageCollector messageCollector = (MessageCollector)this.compilerConfiguration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        if (messageCollector == null) {
            messageCollector = (MessageCollector)new PrintingMessageCollector(System.err, MessageRenderer.PLAIN_FULL_PATHS, false);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)messageCollector, (String)"compilerConfiguration.ge\u2026.PLAIN_FULL_PATHS, false)");
        MessageCollector messageCollector2 = messageCollector;
        boolean reportOutputFiles = generationState.getConfiguration().getBoolean(CommonConfigurationKeys.REPORT_OUTPUT_FILES);
        OutputItemsCollector outputItemsCollector2 = new OutputItemsCollector(messageCollector2){
            final /* synthetic */ MessageCollector $messageCollector;

            public final void add(Collection<File> sourceFiles, File outputFile) {
                String string = OutputMessageUtil.formatOutputMessage(sourceFiles, (File)outputFile);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"OutputMessageUtil.format\u2026(sourceFiles, outputFile)");
                MessageCollector.DefaultImpls.report$default((MessageCollector)this.$messageCollector, (CompilerMessageSeverity)CompilerMessageSeverity.OUTPUT, (String)string, null, (int)4, null);
            }
            {
                this.$messageCollector = messageCollector;
            }
        };
        boolean bl3 = false;
        boolean bl4 = false;
        OutputItemsCollector it = outputItemsCollector2;
        boolean bl5 = false;
        OutputItemsCollector outputItemsCollector3 = (OutputItemsCollector)(reportOutputFiles ? outputItemsCollector2 : null);
        Iterable $this$forEach$iv = outputs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbiOutput it2 = (AbiOutput)element$iv;
            boolean bl6 = false;
            it2.flush(outputItemsCollector3);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void removeUnneededClasses(Iterable<AbiOutput> outputs) {
        void $this$mapTo$iv;
        Object visitor;
        HashMap innerClasses = new HashMap();
        HashMap internalNameToFile = new HashMap();
        for (AbiOutput output : outputs) {
            String outputInternalName;
            if (!FileUtilsKt.isClassFile((File)output.getFile())) continue;
            visitor = new InnerClassesCollectingVisitor();
            output.accept((ClassVisitor)visitor);
            if (((InnerClassesCollectingVisitor)((Object)visitor)).getOwnInternalName() == null) {
                Intrinsics.throwNpe();
            }
            ((Map)internalNameToFile).put(outputInternalName, output.getFile());
            ((Map)innerClasses).put(outputInternalName, ((InnerClassesCollectingVisitor)((Object)visitor)).getInnerClasses());
        }
        ArrayDeque<String> classesToRemoveQueue = new ArrayDeque<String>();
        for (AbiOutput output : outputs) {
            JvmClassName jvmClassName;
            boolean isNeededForAbi;
            boolean bl;
            ClassData classData2;
            if (!FileUtilsKt.isClassFile((File)output.getFile())) continue;
            if (output.classData() == null) {
                continue;
            }
            KotlinClassHeader header = classData2.getClassHeader();
            switch (JvmAbiAnalysisHandlerExtension$WhenMappings.$EnumSwitchMapping$0[header.getKind().ordinal()]) {
                case 1: {
                    Pair pair;
                    ProtoBuf.Class classProto;
                    ProtoBuf.Visibility visibility;
                    String[] stringArray = header.getData();
                    if (stringArray == null) {
                        Intrinsics.throwNpe();
                    }
                    String[] stringArray2 = header.getStrings();
                    if (stringArray2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((visibility = (ProtoBuf.Visibility)Flags.VISIBILITY.get((classProto = (ProtoBuf.Class)(pair = JvmProtoBufUtil.readClassDataFrom((String[])stringArray, (String[])stringArray2)).component2()).getFlags())) != ProtoBuf.Visibility.PRIVATE && visibility != ProtoBuf.Visibility.LOCAL) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: {
                    bl = false;
                    break;
                }
                default: {
                    bl = true;
                }
            }
            if (isNeededForAbi = bl) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)JvmClassName.byClassId((ClassId)classData2.getClassId()), (String)"JvmClassName.byClassId(classData.classId)");
            classesToRemoveQueue.add(jvmClassName.getInternalName());
        }
        HashSet<String> classesToRemove = new HashSet<String>();
        classesToRemove.addAll((Collection)classesToRemoveQueue);
        block6: while (true) {
            visitor = classesToRemoveQueue;
            boolean classData2 = false;
            if (!(!visitor.isEmpty())) break;
            String classToRemove = (String)classesToRemoveQueue.removeFirst();
            Collection collection = (Collection)innerClasses.get(classToRemove);
            if (collection == null) continue;
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            Iterator isNeededForAbi = $this$forEach$iv.iterator();
            while (true) {
                if (!isNeededForAbi.hasNext()) continue block6;
                Object element$iv = isNeededForAbi.next();
                String it = (String)element$iv;
                boolean bl = false;
                if (!classesToRemove.add(it)) continue;
                classesToRemoveQueue.add(it);
            }
        }
        Iterable $this$forEach$iv = classesToRemove;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            String bl = (String)item$iv;
            Collection collection = destination$iv;
            boolean bl2 = false;
            File file = (File)internalNameToFile.get(it);
            collection.add(file);
        }
        HashSet classFilesToRemove = (HashSet)destination$iv;
        for (AbiOutput output : outputs) {
            if (!FileUtilsKt.isClassFile((File)output.getFile())) continue;
            if (classFilesToRemove.contains(output.getFile())) {
                output.delete();
                continue;
            }
            output.transform((Function1<? super ClassWriter, ? extends ClassVisitor>)((Function1)new Function1<ClassWriter, FilterInnerClassesVisitor>(classesToRemove){
                final /* synthetic */ HashSet $classesToRemove;

                @NotNull
                public final FilterInnerClassesVisitor invoke(@NotNull ClassWriter writer) {
                    Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
                    return new FilterInnerClassesVisitor(this.$classesToRemove, 458752, (ClassVisitor)writer);
                }
                {
                    this.$classesToRemove = hashSet;
                    super(1);
                }
            }));
        }
    }

    public JvmAbiAnalysisHandlerExtension(@NotNull CompilerConfiguration compilerConfiguration) {
        Intrinsics.checkParameterIsNotNull((Object)compilerConfiguration, (String)"compilerConfiguration");
        this.compilerConfiguration = compilerConfiguration;
    }

    @Nullable
    public AnalysisResult doAnalysis(@NotNull Project project, @NotNull ModuleDescriptor module, @NotNull ProjectContext projectContext, @NotNull Collection<? extends KtFile> files, @NotNull BindingTrace bindingTrace, @NotNull ComponentProvider componentProvider) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)projectContext, (String)"projectContext");
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)bindingTrace, (String)"bindingTrace");
        Intrinsics.checkParameterIsNotNull((Object)componentProvider, (String)"componentProvider");
        return AnalysisHandlerExtension.DefaultImpls.doAnalysis((AnalysisHandlerExtension)this, (Project)project, (ModuleDescriptor)module, (ProjectContext)projectContext, files, (BindingTrace)bindingTrace, (ComponentProvider)componentProvider);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/jvm/abi/JvmAbiAnalysisHandlerExtension$AbiBinaries;", "Lorg/jetbrains/kotlin/codegen/ClassBuilderFactory;", "()V", "asBytes", "", "builder", "Lorg/jetbrains/kotlin/codegen/ClassBuilder;", "asText", "", "close", "", "getClassBuilderMode", "Lorg/jetbrains/kotlin/codegen/ClassBuilderMode;", "newClassBuilder", "origin", "Lorg/jetbrains/kotlin/resolve/jvm/diagnostics/JvmDeclarationOrigin;", "jvm-abi-gen"})
    private static final class AbiBinaries
    implements ClassBuilderFactory {
        public static final AbiBinaries INSTANCE;

        @NotNull
        public ClassBuilderMode getClassBuilderMode() {
            ClassBuilderMode classBuilderMode = ClassBuilderMode.ABI;
            Intrinsics.checkExpressionValueIsNotNull((Object)classBuilderMode, (String)"ClassBuilderMode.ABI");
            return classBuilderMode;
        }

        @NotNull
        public ClassBuilder newClassBuilder(@NotNull JvmDeclarationOrigin origin) {
            Intrinsics.checkParameterIsNotNull((Object)origin, (String)"origin");
            return (ClassBuilder)new AbiClassBuilder((ClassVisitor)new ClassWriter(0));
        }

        @NotNull
        public String asText(@NotNull ClassBuilder builder) {
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            throw (Throwable)new UnsupportedOperationException("AbiBinaries generator asked for text");
        }

        @NotNull
        public byte[] asBytes(@NotNull ClassBuilder builder) {
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            ClassVisitor classVisitor = builder.getVisitor();
            if (classVisitor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.ClassWriter");
            }
            ClassWriter visitor = (ClassWriter)classVisitor;
            byte[] byArray = visitor.toByteArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"visitor.toByteArray()");
            return byArray;
        }

        public void close() {
        }

        private AbiBinaries() {
        }

        static {
            AbiBinaries abiBinaries;
            INSTANCE = abiBinaries = new AbiBinaries();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/jvm/abi/JvmAbiAnalysisHandlerExtension$ClassData;", "", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "classVersion", "", "classHeader", "Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;", "(Lorg/jetbrains/kotlin/name/ClassId;ILorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;)V", "getClassHeader", "()Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "getClassVersion", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "jvm-abi-gen"})
    private static final class ClassData {
        @NotNull
        private final ClassId classId;
        private final int classVersion;
        @NotNull
        private final KotlinClassHeader classHeader;

        @NotNull
        public final ClassId getClassId() {
            return this.classId;
        }

        public final int getClassVersion() {
            return this.classVersion;
        }

        @NotNull
        public final KotlinClassHeader getClassHeader() {
            return this.classHeader;
        }

        public ClassData(@NotNull ClassId classId, int classVersion, @NotNull KotlinClassHeader classHeader) {
            Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
            Intrinsics.checkParameterIsNotNull((Object)classHeader, (String)"classHeader");
            this.classId = classId;
            this.classVersion = classVersion;
            this.classHeader = classHeader;
        }

        @NotNull
        public final ClassId component1() {
            return this.classId;
        }

        public final int component2() {
            return this.classVersion;
        }

        @NotNull
        public final KotlinClassHeader component3() {
            return this.classHeader;
        }

        @NotNull
        public final ClassData copy(@NotNull ClassId classId, int classVersion, @NotNull KotlinClassHeader classHeader) {
            Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
            Intrinsics.checkParameterIsNotNull((Object)classHeader, (String)"classHeader");
            return new ClassData(classId, classVersion, classHeader);
        }

        public static /* synthetic */ ClassData copy$default(ClassData classData2, ClassId classId, int n, KotlinClassHeader kotlinClassHeader, int n2, Object object) {
            if ((n2 & 1) != 0) {
                classId = classData2.classId;
            }
            if ((n2 & 2) != 0) {
                n = classData2.classVersion;
            }
            if ((n2 & 4) != 0) {
                kotlinClassHeader = classData2.classHeader;
            }
            return classData2.copy(classId, n, kotlinClassHeader);
        }

        @NotNull
        public String toString() {
            return "ClassData(classId=" + this.classId + ", classVersion=" + this.classVersion + ", classHeader=" + this.classHeader + ")";
        }

        public int hashCode() {
            ClassId classId = this.classId;
            KotlinClassHeader kotlinClassHeader = this.classHeader;
            return ((classId != null ? classId.hashCode() : 0) * 31 + Integer.hashCode(this.classVersion)) * 31 + (kotlinClassHeader != null ? kotlinClassHeader.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ClassData)) break block3;
                    ClassData classData2 = (ClassData)object;
                    if (!Intrinsics.areEqual((Object)this.classId, (Object)classData2.classId) || !(this.classVersion == classData2.classVersion) || !Intrinsics.areEqual((Object)this.classHeader, (Object)classData2.classHeader)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0006\u0010\u0013\u001a\u00020\u000eJ\u0010\u0010\u0014\u001a\u00020\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J)\u0010\u0017\u001a\u00020\u000e2!\u0010\u0018\u001a\u001d\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u00100\u0019R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/jvm/abi/JvmAbiAnalysisHandlerExtension$AbiOutput;", "", "file", "Ljava/io/File;", "sources", "", "bytes", "", "(Ljava/io/File;Ljava/util/List;[B)V", "getFile", "()Ljava/io/File;", "getSources", "()Ljava/util/List;", "accept", "", "visitor", "Lorg/jetbrains/org/objectweb/asm/ClassVisitor;", "classData", "Lorg/jetbrains/kotlin/jvm/abi/JvmAbiAnalysisHandlerExtension$ClassData;", "delete", "flush", "outputItemsCollector", "Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollector;", "transform", "fn", "Lkotlin/Function1;", "Lorg/jetbrains/org/objectweb/asm/ClassWriter;", "Lkotlin/ParameterName;", "name", "writer", "jvm-abi-gen"})
    private static final class AbiOutput {
        @NotNull
        private final File file;
        @NotNull
        private final List<File> sources;
        private byte[] bytes;

        @Nullable
        public final ClassData classData() {
            ClassData classData2;
            if (this.bytes == null) {
                classData2 = null;
            } else if (!FileUtilsKt.isClassFile((File)this.file)) {
                classData2 = null;
            } else {
                if (this.bytes == null) {
                    Intrinsics.throwNpe();
                }
                classData2 = (ClassData)FileBasedKotlinClass.create((byte[])this.bytes, (Function4)classData.1.INSTANCE);
            }
            return classData2;
        }

        public final void delete() {
            this.bytes = null;
        }

        public final void transform(@NotNull Function1<? super ClassWriter, ? extends ClassVisitor> fn) {
            Intrinsics.checkParameterIsNotNull(fn, (String)"fn");
            if (this.bytes == null) {
                return;
            }
            byte[] bytes = this.bytes;
            ClassReader cr = new ClassReader(bytes);
            ClassWriter cw = new ClassWriter(0);
            ClassVisitor visitor = (ClassVisitor)fn.invoke((Object)cw);
            cr.accept(visitor, 0);
            this.bytes = cw.toByteArray();
        }

        public final void accept(@NotNull ClassVisitor visitor) {
            Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
            if (this.bytes == null) {
                return;
            }
            byte[] bytes = this.bytes;
            ClassReader cr = new ClassReader(bytes);
            cr.accept(visitor, 0);
        }

        public final void flush(@Nullable OutputItemsCollector outputItemsCollector2) {
            block1: {
                if (this.bytes == null) {
                    return;
                }
                byte[] bytes = this.bytes;
                FileUtil.writeToFile((File)this.file, (byte[])bytes);
                OutputItemsCollector outputItemsCollector3 = outputItemsCollector2;
                if (outputItemsCollector3 == null) break block1;
                outputItemsCollector3.add((Collection)this.sources, this.file);
            }
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        @NotNull
        public final List<File> getSources() {
            return this.sources;
        }

        public AbiOutput(@NotNull File file, @NotNull List<? extends File> sources, @Nullable byte[] bytes) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull(sources, (String)"sources");
            this.file = file;
            this.sources = sources;
            this.bytes = bytes;
        }
    }
}

