/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.osmand.data.LatLon;
import net.osmand.osm.edit.Entity;

public class Relation
extends Entity {
    Map<Entity.EntityId, String> members = null;
    Map<Entity, String> memberEntities = null;

    public Relation(long id2) {
        super(id2);
    }

    public void addMember(Long id2, Entity.EntityType type, String role) {
        if (this.members == null) {
            this.members = new LinkedHashMap<Entity.EntityId, String>();
        }
        this.members.put(new Entity.EntityId(type, id2), role);
    }

    public String removeMember(Entity.EntityType e, Long id2) {
        if (this.members == null) {
            return null;
        }
        return this.members.remove(id2);
    }

    public String getRole(Entity e) {
        return this.members.get(e.getId());
    }

    public String getRole(Long id2) {
        return this.members.get(id2);
    }

    public Collection<Entity.EntityId> getMemberIds() {
        return this.getMemberIds(null);
    }

    public Map<Entity.EntityId, String> getMembersMap() {
        if (this.members == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.members);
    }

    public Collection<Entity.EntityId> getMemberIds(String role) {
        if (this.members == null) {
            return Collections.emptyList();
        }
        if (role == null) {
            return this.members.keySet();
        }
        ArrayList<Entity.EntityId> l = new ArrayList<Entity.EntityId>();
        for (Entity.EntityId m : this.members.keySet()) {
            if (!role.equals(this.members.get(m))) continue;
            l.add(m);
        }
        return l;
    }

    public Map<Entity, String> getMemberEntities() {
        if (this.memberEntities == null) {
            return Collections.emptyMap();
        }
        return this.memberEntities;
    }

    public Collection<Entity> getMembers(String role) {
        if (this.memberEntities == null) {
            return Collections.emptyList();
        }
        if (role == null) {
            return this.memberEntities.keySet();
        }
        ArrayList<Entity> l = new ArrayList<Entity>();
        for (Entity m : this.memberEntities.keySet()) {
            if (!role.equals(this.memberEntities.get(m))) continue;
            l.add(m);
        }
        return l;
    }

    @Override
    public void initializeLinks(Map<Entity.EntityId, Entity> entities) {
        if (this.members != null) {
            if (this.memberEntities == null) {
                this.memberEntities = new LinkedHashMap<Entity, String>();
            } else {
                this.memberEntities.clear();
            }
            for (Entity.EntityId l : this.members.keySet()) {
                if (l == null || entities.get(l) == null) continue;
                this.memberEntities.put(entities.get(l), this.members.get(l));
            }
        }
    }

    @Override
    public LatLon getLatLon() {
        return null;
    }
}

