/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Random;
import javax.swing.SwingUtilities;
import net.osmand.PlatformUtil;
import net.osmand.data.LatLon;
import net.sourceforge.offroad.OsmWindow;
import org.apache.commons.logging.Log;

public class GeoServer
extends Thread {
    private static final Log log = PlatformUtil.getLog(GeoServer.class);
    private final OsmWindow mFrame;
    private String portFile;
    private ServerSocket socket;
    private int authKey;
    private boolean ok;
    private boolean abort;

    public static boolean isUnix() {
        return File.separatorChar == '/';
    }

    public static void setPermissions(String path, int permissions) {
        if (permissions != 0 && GeoServer.isUnix()) {
            String[] cmdarray = new String[]{"chmod", Integer.toString(permissions, 8), path};
            try {
                Process process = Runtime.getRuntime().exec(cmdarray);
                process.getInputStream().close();
                process.getOutputStream().close();
                process.getErrorStream().close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GeoServer(String portFile, OsmWindow pFrame) {
        super("OffRoad server daemon [" + portFile + "]");
        this.mFrame = pFrame;
        this.setDaemon(true);
        this.portFile = portFile;
        try {
            if (GeoServer.isUnix()) {
                new File(portFile).createNewFile();
                GeoServer.setPermissions(portFile, 384);
            }
            this.socket = new ServerSocket(0, 2, InetAddress.getByName("127.0.0.1"));
            this.authKey = new Random().nextInt(Integer.MAX_VALUE);
            int port = this.socket.getLocalPort();
            try (FileWriter out = new FileWriter(portFile);){
                out.write("b\n");
                out.write(String.valueOf(port));
                out.write("\n");
                out.write(String.valueOf(this.authKey));
                out.write("\n");
            }
            this.ok = true;
            log.info((Object)("OffRoad server started on port " + this.socket.getLocalPort()));
            log.info((Object)("Authorization key is " + this.authKey));
        }
        catch (IOException io) {
            log.info((Object)("" + io));
        }
    }

    @Override
    public void run() {
        while (!this.abort) {
            Socket client = null;
            try {
                client = this.socket.accept();
                client.setSoTimeout(1000);
                log.info((Object)(client + ": connected"));
                DataInputStream in = new DataInputStream(client.getInputStream());
                if (this.handleClient(client, in)) continue;
            }
            catch (Exception e) {
                if (!this.abort) {
                    log.info((Object)("" + e));
                }
                this.abort = true;
            }
        }
        return;
    }

    boolean isOK() {
        return this.ok;
    }

    public int getPort() {
        return this.socket.getLocalPort();
    }

    void stopServer() {
        this.abort = true;
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        new File(this.portFile).delete();
    }

    private boolean handleClient(Socket client, DataInputStream in) throws Exception {
        int key = in.readInt();
        if (key != this.authKey) {
            log.info((Object)(client + ": wrong authorization key (got " + key + ", expected " + this.authKey + ")"));
            in.close();
            client.close();
            return false;
        }
        client.setSoTimeout(0);
        log.info((Object)(client + ": authenticated successfully"));
        final String script = in.readUTF();
        log.info((Object)script);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String[] coords = script.split(":");
                if (coords.length != 2) {
                    log.info((Object)("Wrong argument count. Expected 2, got " + coords.length));
                    return;
                }
                Double lat = Double.parseDouble(coords[0]);
                Double lon = Double.parseDouble(coords[1]);
                GeoServer.this.mFrame.move(new LatLon(lat, lon), null);
            }
        });
        in.close();
        client.close();
        return true;
    }

    public static void main(String[] args) {
        String portFile = args[0];
        if (portFile == null) {
            return;
        }
        if (portFile != null && new File(portFile).exists()) {
            try {
                BufferedReader in = new BufferedReader(new FileReader(portFile));
                String check = in.readLine();
                if (!check.equals("b")) {
                    throw new Exception("Wrong port file format");
                }
                int port = Integer.parseInt(in.readLine());
                int key = Integer.parseInt(in.readLine());
                Socket socket = new Socket(InetAddress.getByName("127.0.0.1"), port);
                DataOutputStream out = new DataOutputStream(socket.getOutputStream());
                out.writeInt(key);
                String script = args[1];
                out.writeUTF(script);
                System.out.println("Waiting for server");
                try {
                    socket.getInputStream().read();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                in.close();
                out.close();
                System.exit(0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

