/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebConnectionIRIMapper
implements OWLOntologyIRIMapper {
    private final Logger logger = LoggerFactory.getLogger(WebConnectionIRIMapper.class);

    public IRI getDocumentIRI(IRI ontologyIRI) {
        URI documentURI = ontologyIRI.toURI();
        try {
            URL documentURL = documentURI.toURL();
            URLConnection conn = documentURL.openConnection();
            InputStream is = conn.getInputStream();
            is.close();
            return ontologyIRI;
        }
        catch (MalformedURLException e) {
            this.logger.info("Imported ontology document IRI {} is malformed.", (Object)ontologyIRI);
        }
        catch (FileNotFoundException e) {
            this.logger.info("Imported ontology document {} does not exist on the Web (File Not Found).", (Object)ontologyIRI);
        }
        catch (UnknownHostException e) {
            String host = e.getMessage();
            this.logger.info("Imported ontology document {} could not be retrieved. Cannot connect to {} (Unknown Host).", (Object)ontologyIRI, (Object)host);
        }
        catch (IOException e) {
            this.logger.info("Imported ontology document {} could not be retrieved: {}", (Object)ontologyIRI, (Object)e.getMessage());
        }
        return null;
    }
}

