/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.conflict;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Stack;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.IvyNodeBlacklist;
import org.apache.ivy.core.resolve.IvyNodeCallers;
import org.apache.ivy.core.resolve.IvyNodeEviction;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.RestartResolveProcess;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.conflict.LatestConflictManager;
import org.apache.ivy.plugins.conflict.StrictConflictException;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.Message;

public class LatestCompatibleConflictManager
extends LatestConflictManager {
    public LatestCompatibleConflictManager() {
    }

    public LatestCompatibleConflictManager(String string, LatestStrategy latestStrategy) {
        super(string, latestStrategy);
    }

    @Override
    public Collection resolveConflicts(IvyNode ivyNode, Collection collection) {
        Iterator iterator;
        IvyNode ivyNode2;
        ModuleRevisionId moduleRevisionId;
        if (collection.size() < 2) {
            return collection;
        }
        VersionMatcher versionMatcher = this.getSettings().getVersionMatcher();
        if (versionMatcher.isDynamic(moduleRevisionId = (ivyNode2 = (IvyNode)(iterator = collection.iterator()).next()).getResolvedId())) {
            Object object;
            while (iterator.hasNext()) {
                object = (IvyNode)iterator.next();
                if (versionMatcher.isDynamic(((IvyNode)object).getResolvedId())) {
                    return null;
                }
                if (versionMatcher.accept(moduleRevisionId, ((IvyNode)object).getResolvedId()) || this.handleIncompatibleConflict(ivyNode, collection, ivyNode2, (IvyNode)object)) continue;
                return null;
            }
            if (collection.size() == 2) {
                object = collection.iterator();
                object.next();
                return Collections.singleton(object.next());
            }
            object = new LinkedHashSet(collection);
            object.remove(ivyNode2);
            return super.resolveConflicts(ivyNode, (Collection)object);
        }
        while (iterator.hasNext()) {
            IvyNode ivyNode3 = (IvyNode)iterator.next();
            if (versionMatcher.accept(ivyNode3.getResolvedId(), moduleRevisionId) || this.handleIncompatibleConflict(ivyNode, collection, ivyNode2, ivyNode3)) continue;
            return null;
        }
        return Collections.singleton(ivyNode2);
    }

    private boolean handleIncompatibleConflict(IvyNode ivyNode, Collection collection, IvyNode ivyNode2, IvyNode ivyNode3) {
        try {
            LatestConflictManager.IvyNodeArtifactInfo ivyNodeArtifactInfo = (LatestConflictManager.IvyNodeArtifactInfo)this.getStrategy().findLatest(this.toArtifactInfo(Arrays.asList(ivyNode2, ivyNode3)), null);
            if (ivyNodeArtifactInfo != null) {
                IvyNode ivyNode4 = ivyNodeArtifactInfo.getNode();
                IvyNode ivyNode5 = ivyNode4 == ivyNode2 ? ivyNode3 : ivyNode2;
                this.blackListIncompatibleCallerAndRestartResolveIfPossible(this.getSettings(), ivyNode, ivyNode5, ivyNode4);
                this.blackListIncompatibleCallerAndRestartResolveIfPossible(this.getSettings(), ivyNode, ivyNode4, ivyNode5);
                this.handleUnsolvableConflict(ivyNode, collection, ivyNode2, ivyNode3);
                return true;
            }
            return false;
        }
        catch (LatestConflictManager.NoConflictResolvedYetException noConflictResolvedYetException) {
            return false;
        }
    }

    private void blackListIncompatibleCallerAndRestartResolveIfPossible(IvySettings ivySettings, IvyNode ivyNode, IvyNode ivyNode2, IvyNode ivyNode3) {
        Stack<IvyNode> stack = new Stack<IvyNode>();
        stack.push(ivyNode3);
        Collection collection = this.blackListIncompatibleCaller(ivySettings.getVersionMatcher(), ivyNode, ivyNode2, ivyNode3, stack);
        if (collection != null) {
            StringBuffer stringBuffer = new StringBuffer();
            Object object = collection.iterator();
            while (object.hasNext()) {
                IvyNodeBlacklist ivyNodeBlacklist = (IvyNodeBlacklist)object.next();
                ivyNodeBlacklist.getBlacklistedNode().blacklist(ivyNodeBlacklist);
                stringBuffer.append(ivyNodeBlacklist.getBlacklistedNode());
                if (!object.hasNext()) continue;
                stringBuffer.append(" ");
            }
            object = ivyNode.getData().getReport().getConfiguration();
            ivyNode3.markEvicted(new IvyNodeEviction.EvictionData((String)object, ivyNode, this, Collections.singleton(ivyNode2), "with blacklisting of " + stringBuffer));
            if (ivySettings.debugConflictResolution()) {
                Message.debug("evicting " + ivyNode3 + " by " + ivyNode3.getEvictedData((String)object));
            }
            throw new RestartResolveProcess("trying to handle incompatibilities between " + ivyNode2 + " and " + ivyNode3);
        }
    }

    private boolean handleIncompatibleCaller(Stack stack, IvyNode ivyNode, IvyNode ivyNode2, IvyNode ivyNode3, IvyNode ivyNode4, IvyNode ivyNode5, Collection collection, VersionMatcher versionMatcher) {
        if (stack.subList(0, stack.size() - 1).contains(ivyNode)) {
            return true;
        }
        stack.push(ivyNode2);
        Collection collection2 = this.blackListIncompatibleCaller(versionMatcher, ivyNode3, ivyNode4, ivyNode5, stack);
        stack.pop();
        if (collection2 == null) {
            return false;
        }
        collection.addAll(collection2);
        return true;
    }

    private Collection blackListIncompatibleCaller(VersionMatcher versionMatcher, IvyNode ivyNode, IvyNode ivyNode2, IvyNode ivyNode3, Stack stack) {
        ArrayList<IvyNodeBlacklist> arrayList = new ArrayList<IvyNodeBlacklist>();
        IvyNode ivyNode4 = (IvyNode)stack.peek();
        String string = ivyNode.getData().getReport().getConfiguration();
        IvyNodeCallers.Caller[] callerArray = ivyNode4.getCallers(string);
        for (int i = 0; i < callerArray.length; ++i) {
            IvyNode ivyNode5 = ivyNode4.findNode(callerArray[i].getModuleRevisionId());
            if (ivyNode5.isBlacklisted(string)) continue;
            if (versionMatcher.isDynamic(callerArray[i].getAskedDependencyId(ivyNode4.getData()))) {
                arrayList.add(new IvyNodeBlacklist(ivyNode, ivyNode2, ivyNode3, ivyNode4, string));
                if (!ivyNode4.isEvicted(string) || this.handleIncompatibleCaller(stack, ivyNode4, ivyNode5, ivyNode, ivyNode2, ivyNode3, arrayList, versionMatcher)) continue;
                return null;
            }
            if (this.handleIncompatibleCaller(stack, ivyNode4, ivyNode5, ivyNode, ivyNode2, ivyNode3, arrayList, versionMatcher)) continue;
            return null;
        }
        if (arrayList.isEmpty() && !stack.subList(0, stack.size() - 1).contains(ivyNode4)) {
            return null;
        }
        return arrayList;
    }

    protected void handleUnsolvableConflict(IvyNode ivyNode, Collection collection, IvyNode ivyNode2, IvyNode ivyNode3) {
        throw new StrictConflictException(ivyNode2, ivyNode3);
    }

    @Override
    public void handleAllBlacklistedRevisions(DependencyDescriptor dependencyDescriptor, Collection collection) {
        ResolveData resolveData = IvyContext.getContext().getResolveData();
        HashSet<IvyNode> hashSet = new HashSet<IvyNode>();
        for (ModuleRevisionId object : collection) {
            hashSet.add(resolveData.getNode(object));
        }
        for (IvyNode ivyNode : hashSet) {
            IvyNodeBlacklist ivyNodeBlacklist = ivyNode.getBlacklistData(resolveData.getReport().getConfiguration());
            this.handleUnsolvableConflict(ivyNodeBlacklist.getConflictParent(), Arrays.asList(ivyNodeBlacklist.getEvictedNode(), ivyNodeBlacklist.getSelectedNode()), ivyNodeBlacklist.getEvictedNode(), ivyNodeBlacklist.getSelectedNode());
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

