/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.drawable;

import java.awt.Color;
import java.awt.Graphics2D;
import net.sf.sdedit.config.SequenceConfiguration;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.drawable.ExtensibleDrawable;
import net.sf.sdedit.drawable.Strokes;

public class Rectangle
extends ExtensibleDrawable {
    private final Color color;
    private final String thread = String.valueOf(this.getLifeline().getThread());
    private final SequenceConfiguration configuration;

    public Rectangle(int width, Lifeline lifeline) {
        super(width, lifeline);
        int l = lifeline.getDiagram().getConfiguration().isColorizeThreads() ? lifeline.getDiagram().threadColors.length : 1;
        this.color = lifeline.isAlwaysActive() ? Color.WHITE : lifeline.getDiagram().threadColors[lifeline.getThread() % l];
        this.configuration = lifeline.getDiagram().getConfiguration();
    }

    public final Color getColor() {
        return this.color;
    }

    @Override
    protected void drawObject(Graphics2D g2d) {
        this.drawPartially(g2d, -1, -1);
    }

    private void drawPartially(Graphics2D g2d, int from, int to) {
        int height;
        int top;
        if (from == -1) {
            top = this.getTop();
            height = this.getHeight();
        } else {
            top = Math.max(this.getTop(), from);
            int remainingHeight = this.getHeight() - top + this.getTop();
            height = Math.min(remainingHeight, to - from);
        }
        g2d.setStroke(Strokes.getStroke(Strokes.StrokeType.SOLID, this.getLifeline().getDiagram().activationBarBorderThickness));
        g2d.setColor(this.color);
        g2d.fillRect(this.getLeft(), top, this.getWidth(), height);
        g2d.setColor(Color.BLACK);
        g2d.drawRect(this.getLeft(), top, this.getWidth(), height);
        if (this.getLifeline().getDiagram().isThreaded() && !this.getLifeline().isAlwaysActive() && this.configuration.isThreadNumbersVisible()) {
            g2d.drawString(this.thread, this.getLeft() + 1, this.getTop() + 1 + g2d.getFontMetrics().getHeight());
        }
    }
}

