/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Enumeration;
import javax.media.j3d.AlternateAppearanceRetained;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.Bounds;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.Group;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Leaf;
import javax.media.j3d.Node;
import javax.media.j3d.NodeReferenceTable;
import javax.media.j3d.SceneGraphObject;

public class AlternateAppearance
extends Leaf {
    public static final int ALLOW_INFLUENCING_BOUNDS_READ = 12;
    public static final int ALLOW_INFLUENCING_BOUNDS_WRITE = 13;
    public static final int ALLOW_APPEARANCE_READ = 14;
    public static final int ALLOW_APPEARANCE_WRITE = 15;
    public static final int ALLOW_SCOPE_READ = 16;
    public static final int ALLOW_SCOPE_WRITE = 17;
    private static final int[] readCapabilities = new int[]{12, 14, 16};

    public AlternateAppearance() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public AlternateAppearance(Appearance appearance) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((AlternateAppearanceRetained)this.retained).initAppearance(appearance);
    }

    @Override
    void createRetained() {
        this.retained = new AlternateAppearanceRetained();
        this.retained.setSource(this);
    }

    public void setAppearance(Appearance appearance) {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AlternateAppearance0"));
        }
        if (this.isLive()) {
            ((AlternateAppearanceRetained)this.retained).setAppearance(appearance);
        } else {
            ((AlternateAppearanceRetained)this.retained).initAppearance(appearance);
        }
    }

    public Appearance getAppearance() {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AlternateAppearance2"));
        }
        return ((AlternateAppearanceRetained)this.retained).getAppearance();
    }

    public void setInfluencingBounds(Bounds bounds) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AlternateAppearance3"));
        }
        if (this.isLive()) {
            ((AlternateAppearanceRetained)this.retained).setInfluencingBounds(bounds);
        } else {
            ((AlternateAppearanceRetained)this.retained).initInfluencingBounds(bounds);
        }
    }

    public Bounds getInfluencingBounds() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AlternateAppearance4"));
        }
        return ((AlternateAppearanceRetained)this.retained).getInfluencingBounds();
    }

    public void setInfluencingBoundingLeaf(BoundingLeaf boundingLeaf) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AlternateAppearance3"));
        }
        if (this.isLive()) {
            ((AlternateAppearanceRetained)this.retained).setInfluencingBoundingLeaf(boundingLeaf);
        } else {
            ((AlternateAppearanceRetained)this.retained).initInfluencingBoundingLeaf(boundingLeaf);
        }
    }

    public BoundingLeaf getInfluencingBoundingLeaf() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AlternateAppearance4"));
        }
        return ((AlternateAppearanceRetained)this.retained).getInfluencingBoundingLeaf();
    }

    public void setScope(Group group, int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AlternateAppearance7"));
        }
        if (this.isLive()) {
            ((AlternateAppearanceRetained)this.retained).setScope(group, n);
        } else {
            ((AlternateAppearanceRetained)this.retained).initScope(group, n);
        }
    }

    public Group getScope(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AlternateAppearance8"));
        }
        return ((AlternateAppearanceRetained)this.retained).getScope(n);
    }

    public void insertScope(Group group, int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AlternateAppearance9"));
        }
        if (this.isLive()) {
            ((AlternateAppearanceRetained)this.retained).insertScope(group, n);
        } else {
            ((AlternateAppearanceRetained)this.retained).initInsertScope(group, n);
        }
    }

    public void removeScope(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AlternateAppearance10"));
        }
        if (this.isLive()) {
            ((AlternateAppearanceRetained)this.retained).removeScope(n);
        } else {
            ((AlternateAppearanceRetained)this.retained).initRemoveScope(n);
        }
    }

    public Enumeration<Group> getAllScopes() {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AlternateAppearance11"));
        }
        return ((AlternateAppearanceRetained)this.retained).getAllScopes();
    }

    public void addScope(Group group) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AlternateAppearance12"));
        }
        if (this.isLive()) {
            ((AlternateAppearanceRetained)this.retained).addScope(group);
        } else {
            ((AlternateAppearanceRetained)this.retained).initAddScope(group);
        }
    }

    public int numScopes() {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AlternateAppearance11"));
        }
        return ((AlternateAppearanceRetained)this.retained).numScopes();
    }

    public int indexOfScope(Group group) {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AlternateAppearance8"));
        }
        return ((AlternateAppearanceRetained)this.retained).indexOfScope(group);
    }

    public void removeScope(Group group) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AlternateAppearance10"));
        }
        if (this.isLive()) {
            ((AlternateAppearanceRetained)this.retained).removeScope(group);
        } else {
            ((AlternateAppearanceRetained)this.retained).initRemoveScope(group);
        }
    }

    public void removeAllScopes() {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("AlternateAppearance10"));
        }
        if (this.isLive()) {
            ((AlternateAppearanceRetained)this.retained).removeAllScopes();
        } else {
            ((AlternateAppearanceRetained)this.retained).initRemoveAllScopes();
        }
    }

    @Override
    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        AlternateAppearanceRetained alternateAppearanceRetained = (AlternateAppearanceRetained)node.retained;
        AlternateAppearanceRetained alternateAppearanceRetained2 = (AlternateAppearanceRetained)this.retained;
        alternateAppearanceRetained2.initAppearance((Appearance)this.getNodeComponent(alternateAppearanceRetained.getAppearance(), bl, node.nodeHashtable));
        alternateAppearanceRetained2.initInfluencingBounds(alternateAppearanceRetained.getInfluencingBounds());
        Enumeration<Group> enumeration = alternateAppearanceRetained.getAllScopes();
        while (enumeration.hasMoreElements()) {
            alternateAppearanceRetained2.initAddScope(enumeration.nextElement());
        }
        alternateAppearanceRetained2.initInfluencingBoundingLeaf(alternateAppearanceRetained.getInfluencingBoundingLeaf());
    }

    @Override
    public void updateNodeReferences(NodeReferenceTable nodeReferenceTable) {
        AlternateAppearanceRetained alternateAppearanceRetained = (AlternateAppearanceRetained)this.retained;
        BoundingLeaf boundingLeaf = alternateAppearanceRetained.getInfluencingBoundingLeaf();
        if (boundingLeaf != null) {
            SceneGraphObject sceneGraphObject = nodeReferenceTable.getNewObjectReference(boundingLeaf);
            alternateAppearanceRetained.initInfluencingBoundingLeaf((BoundingLeaf)sceneGraphObject);
        }
        int n = alternateAppearanceRetained.numScopes();
        for (int i = 0; i < n; ++i) {
            alternateAppearanceRetained.initScope((Group)nodeReferenceTable.getNewObjectReference(alternateAppearanceRetained.getScope(i)), i);
        }
    }

    @Override
    public Node cloneNode(boolean bl) {
        AlternateAppearance alternateAppearance = new AlternateAppearance();
        alternateAppearance.duplicateNode(this, bl);
        return alternateAppearance;
    }
}

