/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BHLeafInterface;
import javax.media.j3d.BehaviorRetained;
import javax.media.j3d.BehaviorStructure;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.Bounds;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.MorphRetained;
import javax.media.j3d.Node;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.UnorderList;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupIndexedList;
import javax.media.j3d.WakeupOnCollisionEntry;

public final class WakeupOnCollisionExit
extends WakeupCriterion {
    static final int COND_IN_GS_LIST = 0;
    static final int COLLIDEEXIT_IN_BS_LIST = 1;
    static final int TOTAL_INDEXED_UNORDER_SET_TYPES = 2;
    public static final int USE_GEOMETRY = 10;
    public static final int USE_BOUNDS = 11;
    int accuracyMode;
    NodeRetained armingNode;
    Bounds vwcBounds;
    Bounds localBounds = null;
    BoundingLeafRetained boundingLeaf = null;
    UnorderList geometryAtoms = null;
    int nodeType;
    SceneGraphPath armingPath = null;
    Bounds armingBounds = null;
    SceneGraphPath collidingPath = null;
    Bounds collidingBounds = null;

    public WakeupOnCollisionExit(SceneGraphPath sceneGraphPath) {
        this(sceneGraphPath, 11);
    }

    public WakeupOnCollisionExit(SceneGraphPath sceneGraphPath, int n) {
        this(new SceneGraphPath(sceneGraphPath), n, null);
    }

    public WakeupOnCollisionExit(Node node) {
        this(node, 11);
    }

    public WakeupOnCollisionExit(Node node, int n) {
        this(new SceneGraphPath(null, node), n, null);
    }

    public WakeupOnCollisionExit(Bounds bounds) {
        this(null, 11, (Bounds)bounds.clone());
    }

    WakeupOnCollisionExit(SceneGraphPath sceneGraphPath, int n, Bounds bounds) {
        if (sceneGraphPath != null) {
            this.armingNode = (NodeRetained)sceneGraphPath.getObject().retained;
            this.nodeType = WakeupOnCollisionEntry.getNodeType(this.armingNode, sceneGraphPath, "WakeupOnCollisionExit");
            this.armingPath = sceneGraphPath;
            WakeupOnCollisionEntry.validateSpeedHint(n, "WakeupOnCollisionExit4");
        } else {
            this.armingBounds = bounds;
            this.nodeType = 0;
        }
        this.accuracyMode = n;
        WakeupIndexedList.init(this, 2);
    }

    public SceneGraphPath getArmingPath() {
        return this.armingPath != null ? new SceneGraphPath(this.armingPath) : null;
    }

    public Bounds getArmingBounds() {
        return this.armingBounds != null ? (Bounds)this.armingBounds.clone() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SceneGraphPath getTriggeringPath() {
        if (this.behav == null) {
            throw new IllegalStateException(J3dI18N.getString("WakeupOnCollisionExit5"));
        }
        BehaviorRetained behaviorRetained = this.behav;
        synchronized (behaviorRetained) {
            if (!this.behav.inCallback) {
                throw new IllegalStateException(J3dI18N.getString("WakeupOnCollisionExit5"));
            }
        }
        return this.collidingPath != null ? new SceneGraphPath(this.collidingPath) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bounds getTriggeringBounds() {
        if (this.behav == null) {
            throw new IllegalStateException(J3dI18N.getString("WakeupOnCollisionExit6"));
        }
        BehaviorRetained behaviorRetained = this.behav;
        synchronized (behaviorRetained) {
            if (!this.behav.inCallback) {
                throw new IllegalStateException(J3dI18N.getString("WakeupOnCollisionExit6"));
            }
        }
        return this.collidingBounds != null ? (Bounds)this.collidingBounds.clone() : null;
    }

    void addBehaviorCondition(BehaviorStructure behaviorStructure) {
        switch (this.nodeType) {
            case 11: 
            case 28: {
                if (!this.armingNode.source.isLive()) {
                    return;
                }
                if (this.geometryAtoms == null) {
                    this.geometryAtoms = new UnorderList(1, GeometryAtom.class);
                }
                Shape3DRetained shape3DRetained = (Shape3DRetained)this.armingNode;
                this.geometryAtoms.add(Shape3DRetained.getGeomAtom(shape3DRetained.getMirrorShape(this.armingPath)));
                break;
            }
            case 10: {
                if (!this.armingNode.source.isLive()) {
                    return;
                }
                if (this.geometryAtoms == null) {
                    this.geometryAtoms = new UnorderList(1, GeometryAtom.class);
                }
                MorphRetained morphRetained = (MorphRetained)this.armingNode;
                this.geometryAtoms.add(Shape3DRetained.getGeomAtom(morphRetained.getMirrorShape(this.armingPath)));
                break;
            }
            case 25: {
                if (!this.armingNode.source.isLive()) {
                    return;
                }
                this.boundingLeaf = ((BoundingLeafRetained)this.armingNode).mirrorBoundingLeaf;
                break;
            }
            case 0: {
                this.vwcBounds = (Bounds)this.armingBounds.clone();
                this.armingNode = this.behav;
                break;
            }
            case 23: {
                if (!this.armingNode.source.isLive()) {
                    return;
                }
                if (this.accuracyMode != 10) break;
                if (this.geometryAtoms == null) {
                    this.geometryAtoms = new UnorderList(1, GeometryAtom.class);
                }
                ((GroupRetained)this.armingNode).searchGeometryAtoms(this.geometryAtoms);
            }
        }
        this.behav.universe.geometryStructure.addWakeupOnCollision(this);
    }

    void removeBehaviorCondition(BehaviorStructure behaviorStructure) {
        this.vwcBounds = null;
        if (this.geometryAtoms != null) {
            this.geometryAtoms.clear();
        }
        this.boundingLeaf = null;
        this.behav.universe.geometryStructure.removeWakeupOnCollision(this);
    }

    void setTarget(BHLeafInterface bHLeafInterface) {
        Bounds bounds;
        SceneGraphPath sceneGraphPath;
        if (bHLeafInterface instanceof GeometryAtom) {
            GeometryAtom geometryAtom = (GeometryAtom)bHLeafInterface;
            Shape3DRetained shape3DRetained = geometryAtom.source;
            sceneGraphPath = WakeupOnCollisionEntry.getSceneGraphPath(shape3DRetained.sourceNode, shape3DRetained.key, shape3DRetained.getCurrentLocalToVworld(0));
            bounds = WakeupOnCollisionEntry.getTriggeringBounds(shape3DRetained);
        } else {
            GroupRetained groupRetained = (GroupRetained)bHLeafInterface;
            sceneGraphPath = WakeupOnCollisionEntry.getSceneGraphPath(groupRetained);
            bounds = WakeupOnCollisionEntry.getTriggeringBounds(groupRetained);
        }
        if (sceneGraphPath != null) {
            this.collidingPath = sceneGraphPath;
            this.collidingBounds = bounds;
        }
    }

    void updateCollisionBounds(boolean bl) {
        if (this.nodeType == 23) {
            GroupRetained groupRetained = (GroupRetained)this.armingNode;
            this.vwcBounds = groupRetained.collisionBound != null ? (Bounds)groupRetained.collisionBound.clone() : groupRetained.getEffectiveBounds();
            groupRetained.transformBounds(this.armingPath, this.vwcBounds);
        } else if (this.nodeType == 0) {
            this.vwcBounds.transform(this.armingBounds, this.behav.getCurrentLocalToVworld());
        }
        if (bl && this.nodeType == 23 && this.accuracyMode == 10) {
            this.geometryAtoms.clear();
            ((GroupRetained)this.armingNode).searchGeometryAtoms(this.geometryAtoms);
        }
    }

    void setTriggered() {
        if (this.collidingPath != null) {
            super.setTriggered();
        }
    }

    void resetBehaviorCondition(BehaviorStructure behaviorStructure) {
    }
}

