/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.benchlab.har;

import edu.umass.cs.benchlab.har.AbstractNameValueComment;
import edu.umass.cs.benchlab.har.HarCustomFields;
import edu.umass.cs.benchlab.har.HarDatabaseConfig;
import edu.umass.cs.benchlab.har.HarWarning;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class HarPostDataParam
extends AbstractNameValueComment {
    public static String TABLE_NAME = "post_params";
    private String fileName;
    private String contentType;
    private HarCustomFields customFields = new HarCustomFields();

    public HarPostDataParam(String name, String value, String fileName, String contentType, String comment) {
        super(name, value, comment);
        this.fileName = fileName;
        this.contentType = contentType;
    }

    public HarPostDataParam(HarDatabaseConfig config, long postDataParamId, String name, String value, String fileName, String contentType, String comment) throws SQLException {
        this(name, value, fileName, contentType, comment);
        this.customFields.readCustomFieldsJDBC(config, HarCustomFields.Type.HARPOSTDATAPARAM, postDataParamId);
    }

    public HarPostDataParam(String name, String value) {
        super(name, value);
    }

    public HarPostDataParam(JsonParser jp, List<HarWarning> warnings) throws JsonParseException, IOException {
        super(jp);
        if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
            throw new JsonParseException("{ missing after \"params\" element", jp.getCurrentLocation());
        }
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String name = jp.getCurrentName();
            if ("name".equals(name)) {
                this.setName(jp.getText());
                continue;
            }
            if ("value".equals(name)) {
                this.setValue(jp.getText());
                continue;
            }
            if ("fileName".equals(name)) {
                this.setFileName(jp.getText());
                continue;
            }
            if ("contentType".equals(name)) {
                this.setContentType(jp.getText());
                continue;
            }
            if ("comment".equals(name)) {
                this.setComment(jp.getText());
                continue;
            }
            if (name != null && name.startsWith("_")) {
                this.customFields.addHarCustomFields(name, jp);
                continue;
            }
            throw new JsonParseException("Unrecognized field '" + name + "' in params element", jp.getCurrentLocation());
        }
        if (this.getName() == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing name field in postData element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing name field in postData element", jp.getCurrentLocation());
            }
        }
    }

    @Override
    public void writeHar(JsonGenerator g) throws JsonGenerationException, IOException {
        g.writeStartObject();
        g.writeStringField("name", this.getName());
        if (this.getValue() != null) {
            g.writeStringField("value", this.getValue());
        }
        if (this.getFileName() != null) {
            g.writeStringField("fileName", this.fileName);
        }
        if (this.getContentType() != null) {
            g.writeStringField("contentType", this.contentType);
        }
        if (this.getComment() != null) {
            g.writeStringField("comment", this.getComment());
        }
        this.customFields.writeHar(g);
        g.writeEndObject();
    }

    @Override
    public void writeJDBC(HarDatabaseConfig config, long id, PreparedStatement ps, long logId) throws SQLException {
        ps.setString(1, this.getName());
        if (this.getValue() == null) {
            ps.setNull(2, -1);
        } else {
            ps.setString(2, this.getValue());
        }
        if (this.fileName == null) {
            ps.setNull(3, -1);
        } else {
            ps.setString(3, this.fileName);
        }
        if (this.contentType == null) {
            ps.setNull(4, -1);
        } else {
            ps.setString(4, this.contentType);
        }
        if (this.getComment() == null) {
            ps.setNull(5, -1);
        } else {
            ps.setString(5, this.getComment());
        }
        ps.setLong(6, id);
        ps.executeUpdate();
        ResultSet rs = ps.getGeneratedKeys();
        if (!rs.next()) {
            throw new SQLException("The database did not generate a key for an HarPage entry");
        }
        long postDataParamId = rs.getLong(1);
        this.customFields.writeCustomFieldsJDBC(config, HarCustomFields.Type.HARPOSTDATAPARAM, postDataParamId, logId);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public HarCustomFields getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(HarCustomFields customFields) {
        this.customFields = customFields;
    }

    @Override
    public String toString() {
        return "{ \"name\": \"" + this.getName() + "\", \"value\": \"" + this.getValue() + "\", \"fileName\": \"" + this.getFileName() + "\", \"contentType\": \"" + this.getContentType() + "\", \"comment\": \"" + this.getComment() + "\", " + this.customFields + " }";
    }
}

