/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.spider;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import org.apache.commons.httpclient.URI;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.zaproxy.zap.extension.spider.ExtensionSpider;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.StructuralNode;
import org.zaproxy.zap.model.StructuralSiteNode;
import org.zaproxy.zap.model.Target;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.filters.HttpPrefixFetchFilter;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.view.StandardFieldsDialog;

public class SpiderDialog
extends StandardFieldsDialog {
    private static final String FIELD_START = "spider.custom.label.start";
    private static final String FIELD_CONTEXT = "spider.custom.label.context";
    private static final String FIELD_USER = "spider.custom.label.user";
    private static final String FIELD_RECURSE = "spider.custom.label.recurse";
    private static final String FIELD_SUBTREE_ONLY = "spider.custom.label.spiderSubtreeOnly";
    private static final String FIELD_ADVANCED = "spider.custom.label.adv";
    private static final String FIELD_MAX_DEPTH = "spider.custom.label.maxDepth";
    private static final String FIELD_MAX_CHILDREN = "spider.custom.label.maxChildren";
    private static final String FIELD_MAX_DURATION = "spider.custom.label.maxDuration";
    private static final String FIELD_MAX_PARSE_SIZE_BYTES = "spider.custom.label.maxParseSizeBytes";
    private static final String FIELD_SEND_REFERER = "spider.custom.label.sendReferer";
    private static final String FIELD_ACCEPT_COOKIES = "spider.custom.label.acceptcookies";
    private static final String FIELD_PROCESS_FORMS = "spider.custom.label.processForms";
    private static final String FIELD_POST_FORMS = "spider.custom.label.postForms";
    private static final String FIELD_PARSE_COMMENTS = "spider.custom.label.parseComments";
    private static final String FIELD_PARSE_ROBOTS = "spider.custom.label.parseRobots";
    private static final String FIELD_PARSE_SITEMAP = "spider.custom.label.sitemap";
    private static final String FIELD_PARSE_SVN = "spider.custom.label.parseSvn";
    private static final String FIELD_PARSE_GIT = "spider.custom.label.parseGit";
    private static final String FIELD_HANDLE_ODATA = "spider.custom.label.handleOdata";
    private static Logger logger = Logger.getLogger(SpiderDialog.class);
    private static final long serialVersionUID = 1L;
    private JButton[] extraButtons = null;
    private ExtensionSpider extension = null;
    private SpiderParam spiderParam = null;
    private boolean subtreeOnlyPreviousCheckedState;
    private ExtensionUserManagement extUserMgmt = Control.getSingleton().getExtensionLoader().getExtension(ExtensionUserManagement.class);
    private Target target = null;

    public SpiderDialog(ExtensionSpider ext, Frame owner, Dimension dim) {
        super(owner, "spider.custom.title", dim, new String[]{"spider.custom.tab.scope", "spider.custom.tab.adv"});
        this.extension = ext;
        this.reset(false);
    }

    public void init(Target target) {
        if (target != null) {
            this.target = target;
        }
        logger.debug((Object)("init " + this.target));
        this.removeAllFields();
        this.addTargetSelectField(0, FIELD_START, this.target, true, false);
        this.addComboField(0, FIELD_CONTEXT, new String[0], "");
        this.addComboField(0, FIELD_USER, new String[0], "");
        this.setUsers();
        this.addCheckBoxField(0, FIELD_RECURSE, true);
        this.addCheckBoxField(0, FIELD_SUBTREE_ONLY, this.subtreeOnlyPreviousCheckedState);
        this.addCheckBoxField(0, FIELD_ADVANCED, this.extension.getSpiderParam().isShowAdvancedDialog());
        this.addPadding(0);
        this.addNumberField(1, FIELD_MAX_DEPTH, 1, 19, this.getSpiderParam().getMaxDepth());
        this.addNumberField(1, FIELD_MAX_CHILDREN, 0, Integer.MAX_VALUE, this.getSpiderParam().getMaxChildren());
        this.addNumberField(1, FIELD_MAX_DURATION, 0, Integer.MAX_VALUE, this.getSpiderParam().getMaxDuration());
        this.addNumberField(1, FIELD_MAX_PARSE_SIZE_BYTES, 0, Integer.MAX_VALUE, this.getSpiderParam().getMaxParseSizeBytes());
        this.addCheckBoxField(1, FIELD_SEND_REFERER, this.getSpiderParam().isSendRefererHeader());
        this.addCheckBoxField(1, FIELD_ACCEPT_COOKIES, this.getSpiderParam().isAcceptCookies());
        this.addCheckBoxField(1, FIELD_PROCESS_FORMS, this.getSpiderParam().isProcessForm());
        this.addCheckBoxField(1, FIELD_POST_FORMS, this.getSpiderParam().isPostForm());
        this.addCheckBoxField(1, FIELD_PARSE_COMMENTS, this.getSpiderParam().isParseComments());
        this.addCheckBoxField(1, FIELD_PARSE_ROBOTS, this.getSpiderParam().isParseRobotsTxt());
        this.addCheckBoxField(1, FIELD_PARSE_SITEMAP, this.getSpiderParam().isParseSitemapXml());
        this.addCheckBoxField(1, FIELD_PARSE_SVN, this.getSpiderParam().isParseSVNEntries());
        this.addCheckBoxField(1, FIELD_PARSE_GIT, this.getSpiderParam().isParseGit());
        this.addCheckBoxField(1, FIELD_HANDLE_ODATA, this.getSpiderParam().isHandleODataParametersVisited());
        this.addPadding(1);
        if (!this.getBoolValue(FIELD_PROCESS_FORMS).booleanValue()) {
            this.setFieldValue(FIELD_POST_FORMS, false);
            this.getField(FIELD_POST_FORMS).setEnabled(false);
        }
        this.addFieldListener(FIELD_CONTEXT, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpiderDialog.this.setUsers();
            }
        });
        this.addFieldListener(FIELD_PROCESS_FORMS, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SpiderDialog.this.getBoolValue(SpiderDialog.FIELD_PROCESS_FORMS).booleanValue()) {
                    SpiderDialog.this.getField(SpiderDialog.FIELD_POST_FORMS).setEnabled(true);
                } else {
                    SpiderDialog.this.setFieldValue(SpiderDialog.FIELD_POST_FORMS, false);
                    SpiderDialog.this.getField(SpiderDialog.FIELD_POST_FORMS).setEnabled(false);
                }
            }
        });
        this.addFieldListener(FIELD_ADVANCED, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpiderDialog.this.setAdvancedTabs(SpiderDialog.this.getBoolValue(SpiderDialog.FIELD_ADVANCED));
            }
        });
        if (target != null) {
            this.targetSelected(FIELD_START, this.target);
            this.setUsers();
        }
        if (!this.extension.getSpiderParam().isShowAdvancedDialog()) {
            this.setAdvancedTabs(false);
        }
        this.setTabScrollable("spider.custom.tab.adv", true);
        this.pack();
    }

    private SpiderParam getSpiderParam() {
        if (this.spiderParam == null) {
            this.spiderParam = (SpiderParam)this.extension.getSpiderParam().clone();
        }
        return this.spiderParam;
    }

    private void setAdvancedTabs(boolean visible) {
        this.setTabsVisible(new String[]{"spider.custom.tab.adv"}, visible);
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.spider";
    }

    @Override
    public void targetSelected(String field, Target node) {
        ArrayList<String> ctxNames = new ArrayList<String>();
        if (node != null) {
            this.target = node;
            if (node.getStartNode() != null) {
                Session session = Model.getSingleton().getSession();
                List<Context> contexts = session.getContextsForNode(node.getStartNode());
                for (Context context : contexts) {
                    ctxNames.add(context.getName());
                }
            } else if (node.getContext() != null) {
                ctxNames.add(node.getContext().getName());
            }
        }
        this.setComboFields(FIELD_CONTEXT, ctxNames, "");
        this.getField(FIELD_CONTEXT).setEnabled(ctxNames.size() > 0);
    }

    private Context getSelectedContext() {
        String ctxName = this.getStringValue(FIELD_CONTEXT);
        if (this.extUserMgmt != null && !this.isEmptyField(FIELD_CONTEXT)) {
            Session session = Model.getSingleton().getSession();
            return session.getContext(ctxName);
        }
        return null;
    }

    private User getSelectedUser() {
        Context context = this.getSelectedContext();
        if (context != null) {
            String userName = this.getStringValue(FIELD_USER);
            List<User> users = this.extUserMgmt.getContextUserAuthManager(context.getIndex()).getUsers();
            for (User user : users) {
                if (!userName.equals(user.getName())) continue;
                return user;
            }
        }
        return null;
    }

    private void setUsers() {
        Context context = this.getSelectedContext();
        ArrayList<String> userNames = new ArrayList<String>();
        if (context != null) {
            List<User> users = this.extUserMgmt.getContextUserAuthManager(context.getIndex()).getUsers();
            userNames.add("");
            for (User user : users) {
                userNames.add(user.getName());
            }
        }
        this.setComboFields(FIELD_USER, userNames, "");
        this.getField(FIELD_USER).setEnabled(userNames.size() > 1);
    }

    private void reset(boolean refreshUi) {
        this.spiderParam = null;
        this.subtreeOnlyPreviousCheckedState = false;
        if (refreshUi) {
            this.init(this.target);
            this.repaint();
        }
    }

    @Override
    public String getSaveButtonText() {
        return Constant.messages.getString("spider.custom.button.scan");
    }

    @Override
    public JButton[] getExtraButtons() {
        if (this.extraButtons == null) {
            JButton resetButton = new JButton(Constant.messages.getString("spider.custom.button.reset"));
            resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpiderDialog.this.reset(true);
                }
            });
            this.extraButtons = new JButton[]{resetButton};
        }
        return this.extraButtons;
    }

    @Override
    public void save() {
        ArrayList<Object> contextSpecificObjects = new ArrayList<Object>();
        URI startUri = null;
        try {
            startUri = new URI(this.getStringValue(FIELD_START), true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.getBoolValue(FIELD_ADVANCED).booleanValue()) {
            this.spiderParam.setMaxDepth(this.getIntValue(FIELD_MAX_DEPTH));
            this.spiderParam.setMaxDuration(this.getIntValue(FIELD_MAX_DURATION));
            this.spiderParam.setMaxChildren(this.getIntValue(FIELD_MAX_CHILDREN));
            this.spiderParam.setMaxParseSizeBytes(this.getIntValue(FIELD_MAX_PARSE_SIZE_BYTES));
            this.spiderParam.setSendRefererHeader(this.getBoolValue(FIELD_SEND_REFERER));
            this.spiderParam.setAcceptCookies(this.getBoolValue(FIELD_ACCEPT_COOKIES));
            this.spiderParam.setProcessForm(this.getBoolValue(FIELD_PROCESS_FORMS));
            this.spiderParam.setPostForm(this.getBoolValue(FIELD_POST_FORMS));
            this.spiderParam.setParseComments(this.getBoolValue(FIELD_PARSE_COMMENTS));
            this.spiderParam.setParseRobotsTxt(this.getBoolValue(FIELD_PARSE_ROBOTS));
            this.spiderParam.setParseSitemapXml(this.getBoolValue(FIELD_PARSE_SITEMAP));
            this.spiderParam.setParseSVNEntries(this.getBoolValue(FIELD_PARSE_SVN));
            this.spiderParam.setParseGit(this.getBoolValue(FIELD_PARSE_GIT));
            this.spiderParam.setHandleODataParametersVisited(this.getBoolValue(FIELD_HANDLE_ODATA));
            this.spiderParam.setThreadCount(this.extension.getSpiderParam().getThreadCount());
            contextSpecificObjects.add(this.spiderParam);
        }
        if (startUri != null) {
            contextSpecificObjects.add(startUri);
            if (this.getBoolValue(FIELD_SUBTREE_ONLY).booleanValue()) {
                contextSpecificObjects.add(new HttpPrefixFetchFilter(startUri));
            }
        }
        if (this.target == null || !this.getStringValue(FIELD_START).equals(SpiderDialog.getTargetText(this.target))) {
            this.target = new Target((StructuralNode)null);
        }
        this.extension.getSpiderParam().setShowAdvancedDialog(this.getBoolValue(FIELD_ADVANCED));
        this.target.setRecurse(this.getBoolValue(FIELD_RECURSE));
        if (this.target.getContext() == null && this.getSelectedContext() != null) {
            this.target.setContext(this.getSelectedContext());
        }
        this.subtreeOnlyPreviousCheckedState = this.getBoolValue(FIELD_SUBTREE_ONLY);
        this.extension.startScan(this.target, this.getSelectedUser(), contextSpecificObjects.toArray());
    }

    @Override
    public String validateFields() {
        if (Control.Mode.safe == Control.getSingleton().getMode()) {
            return Constant.messages.getString("spider.custom.notSafe.error");
        }
        if (this.isEmptyField(FIELD_START)) {
            return Constant.messages.getString("spider.custom.nostart.error");
        }
        boolean noStartUri = true;
        if (!this.getStringValue(FIELD_START).equals(SpiderDialog.getTargetText(this.target))) {
            String url = this.getStringValue(FIELD_START);
            try {
                new URI(url, true);
                new URL(url);
            }
            catch (Exception e) {
                return Constant.messages.getString("spider.custom.nostart.error");
            }
            if (Control.getSingleton().getMode() == Control.Mode.protect && !this.extension.isTargetUriInScope(url)) {
                return Constant.messages.getString("spider.custom.targetNotInScope.error", url);
            }
            noStartUri = false;
        }
        if (this.target != null) {
            String uri;
            if (!this.target.isValid()) {
                return Constant.messages.getString("spider.custom.nostart.error");
            }
            if (Control.getSingleton().getMode() == Control.Mode.protect && (uri = this.extension.getTargetUriOutOfScope(this.target)) != null) {
                return Constant.messages.getString("spider.custom.targetNotInScope.error", uri);
            }
            List<StructuralNode> nodes = this.target.getStartNodes();
            if (nodes != null) {
                for (StructuralNode node : nodes) {
                    if (!(node instanceof StructuralSiteNode)) continue;
                    noStartUri = false;
                    break;
                }
            }
        }
        if (this.getBoolValue(FIELD_SUBTREE_ONLY).booleanValue() && noStartUri) {
            return Constant.messages.getString("spider.custom.noStartSubtreeOnly.error");
        }
        return null;
    }

    void reset() {
        this.target = null;
        this.reset(true);
    }

    @Override
    public void cancelPressed() {
        this.target = null;
        super.cancelPressed();
    }
}

