/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import java.util.Collection;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.input.InputEvent;
import javafx.scene.input.InputMethodTextRun;

public class InputMethodEvent
extends InputEvent {
    public static final EventType<InputMethodEvent> INPUT_METHOD_TEXT_CHANGED = new EventType<InputEvent>(InputEvent.ANY, "INPUT_METHOD_TEXT_CHANGED");
    private ObservableList<InputMethodTextRun> composed;
    private String committed = "";
    private int caretPosition;

    private InputMethodEvent(EventType<? extends InputMethodEvent> eventType) {
        super((EventType<? extends InputEvent>)eventType);
    }

    private InputMethodEvent(Object object, EventTarget eventTarget, EventType<? extends InputMethodEvent> eventType) {
        super(object, eventTarget, (EventType<? extends InputEvent>)eventType);
    }

    @Deprecated
    public static InputMethodEvent impl_copy(EventTarget eventTarget, InputMethodEvent inputMethodEvent) {
        return (InputMethodEvent)inputMethodEvent.copyFor(inputMethodEvent.source, eventTarget);
    }

    @Deprecated
    public static InputMethodEvent impl_inputMethodEvent(EventTarget eventTarget, ObservableList<InputMethodTextRun> observableList, String string, int n, EventType<? extends InputMethodEvent> eventType) {
        InputMethodEvent inputMethodEvent = new InputMethodEvent((Object)null, eventTarget, eventType);
        inputMethodEvent.getComposed().addAll((Collection<InputMethodTextRun>)observableList);
        inputMethodEvent.committed = string;
        inputMethodEvent.caretPosition = n;
        return inputMethodEvent;
    }

    public final ObservableList<InputMethodTextRun> getComposed() {
        if (this.composed == null) {
            this.composed = FXCollections.observableArrayList();
        }
        return this.composed;
    }

    public final String getCommitted() {
        return this.committed;
    }

    public final int getCaretPosition() {
        return this.caretPosition;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("InputMethodEvent [");
        stringBuilder.append("source = ").append(this.getSource());
        stringBuilder.append(", target = ").append(this.getTarget());
        stringBuilder.append(", eventType = ").append(this.getEventType());
        stringBuilder.append(", consumed = ").append(this.isConsumed());
        stringBuilder.append(", composed = ").append(this.getComposed());
        stringBuilder.append(", committed = ").append(this.getCommitted());
        stringBuilder.append(", caretPosition = ").append(this.getCaretPosition());
        return stringBuilder.append("]").toString();
    }
}

