//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.2
//
// <auto-generated>
//
// Generated from file `Connection.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __Ice_Connection_h__
#define __Ice_Connection_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/OutgoingAsync.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ObjectAdapterF.h>
#include <Ice/Identity.h>
#include <Ice/Endpoint.h>
#include <IceUtil/UndefSysMacros.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 2
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICE_API
#   if defined(ICE_STATIC_LIBS)
#       define ICE_API /**/
#   elif defined(ICE_API_EXPORTS)
#       define ICE_API ICE_DECLSPEC_EXPORT
#   else
#       define ICE_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace Ice
{

class ConnectionInfo;
class Connection;
class IPConnectionInfo;
class TCPConnectionInfo;
class UDPConnectionInfo;
class WSConnectionInfo;

}

namespace Ice
{

/**
 * The batch compression option when flushing queued batch requests.
 */
enum class CompressBatch : unsigned char
{
    /**
     * Compress the batch requests.
     */
    Yes,
    /**
     * Don't compress the batch requests.
     */
    No,
    /**
     * Compress the batch requests if at least one request was
     * made on a compressed proxy.
     */
    BasedOnProxy
};

/**
 * Specifies the close semantics for Active Connection Management.
 */
enum class ACMClose : unsigned char
{
    /**
     * Disables automatic connection closure.
     */
    CloseOff,
    /**
     * Gracefully closes a connection that has been idle for the configured timeout period.
     */
    CloseOnIdle,
    /**
     * Forcefully closes a connection that has been idle for the configured timeout period,
     * but only if the connection has pending invocations.
     */
    CloseOnInvocation,
    /**
     * Combines the behaviors of CloseOnIdle and CloseOnInvocation.
     */
    CloseOnInvocationAndIdle,
    /**
     * Forcefully closes a connection that has been idle for the configured timeout period,
     * regardless of whether the connection has pending invocations or dispatch.
     */
    CloseOnIdleForceful
};

/**
 * Specifies the heartbeat semantics for Active Connection Management.
 */
enum class ACMHeartbeat : unsigned char
{
    /**
     * Disables heartbeats.
     */
    HeartbeatOff,
    /**
     * Send a heartbeat at regular intervals if the connection is idle and only if there are pending dispatch.
     */
    HeartbeatOnDispatch,
    /**
     * Send a heartbeat at regular intervals when the connection is idle.
     */
    HeartbeatOnIdle,
    /**
     * Send a heartbeat at regular intervals until the connection is closed.
     */
    HeartbeatAlways
};

/**
 * A collection of Active Connection Management configuration settings.
 * \headerfile Ice/Ice.h
 */
struct ACM
{
    /**
     * A timeout value in seconds.
     */
    int timeout;
    /**
     * The close semantics.
     */
    ACMClose close;
    /**
     * The heartbeat semantics.
     */
    ACMHeartbeat heartbeat;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */

    std::tuple<const int&, const ACMClose&, const ACMHeartbeat&> ice_tuple() const
    {
        return std::tie(timeout, close, heartbeat);
    }
};

/**
 * Determines the behavior when manually closing a connection.
 */
enum class ConnectionClose : unsigned char
{
    /**
     * Close the connection immediately without sending a close connection protocol message to the peer
     * and waiting for the peer to acknowledge it.
     */
    Forcefully,
    /**
     * Close the connection by notifying the peer but do not wait for pending outgoing invocations to complete.
     * On the server side, the connection will not be closed until all incoming invocations have completed.
     */
    Gracefully,
    /**
     * Wait for all pending invocations to complete before closing the connection.
     */
    GracefullyWithWait
};

/**
 * A collection of HTTP headers.
 */
using HeaderDict = ::std::map<::std::string, ::std::string>;

using Ice::operator<;
using Ice::operator<=;
using Ice::operator>;
using Ice::operator>=;
using Ice::operator==;
using Ice::operator!=;

}

namespace Ice
{

/**
 * Base class providing access to the connection details.
 * \headerfile Ice/Ice.h
 */
class ICE_CLASS(ICE_API) ConnectionInfo
{
public:

    ICE_MEMBER(ICE_API) virtual ~ConnectionInfo();

    ConnectionInfo() = default;

    ConnectionInfo(const ConnectionInfo&) = default;
    ConnectionInfo(ConnectionInfo&&) = default;
    ConnectionInfo& operator=(const ConnectionInfo&) = default;
    ConnectionInfo& operator=(ConnectionInfo&&) = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param underlying The information of the underyling transport or null if there's no underlying transport.
     * @param incoming Whether or not the connection is an incoming or outgoing connection.
     * @param adapterName The name of the adapter associated with the connection.
     * @param connectionId The connection id.
     */
    ConnectionInfo(const ::std::shared_ptr<ConnectionInfo>& underlying, bool incoming, const ::std::string& adapterName, const ::std::string& connectionId) :
        underlying(::std::move(underlying)),
        incoming(incoming),
        adapterName(::std::move(adapterName)),
        connectionId(::std::move(connectionId))
    {
    }

    /**
     * The information of the underyling transport or null if there's
     * no underlying transport.
     */
    ::std::shared_ptr<ConnectionInfo> underlying;
    /**
     * Whether or not the connection is an incoming or outgoing
     * connection.
     */
    bool incoming;
    /**
     * The name of the adapter associated with the connection.
     */
    ::std::string adapterName;
    /**
     * The connection id.
     */
    ::std::string connectionId;
};

/**
 * This method is called by the the connection when the connection
 * is closed. If the callback needs more information about the closure,
 * it can call {@link Connection#throwException}.
 * @param con The connection that closed.
 */
using CloseCallback = ::std::function<void(const ::std::shared_ptr<Connection>& con)>;

/**
 * This method is called by the the connection when a heartbeat is
 * received from the peer.
 * @param con The connection on which a heartbeat was received.
 */
using HeartbeatCallback = ::std::function<void(const ::std::shared_ptr<Connection>& con)>;

/**
 * The user-level interface to a connection.
 * \headerfile Ice/Ice.h
 */
class ICE_CLASS(ICE_API) Connection
{
public:

    ICE_MEMBER(ICE_API) virtual ~Connection();

    /**
     * Manually close the connection using the specified closure mode.
     * @param mode Determines how the connection will be closed.
     * @see ConnectionClose
     */
    virtual void close(ConnectionClose mode) noexcept = 0;

    /**
     * Create a special proxy that always uses this connection. This
     * can be used for callbacks from a server to a client if the
     * server cannot directly establish a connection to the client,
     * for example because of firewalls. In this case, the server
     * would create a proxy using an already established connection
     * from the client.
     * @param id The identity for which a proxy is to be created.
     * @return A proxy that matches the given identity and uses this
     * connection.
     * @see #setAdapter
     */
    virtual ::std::shared_ptr<::Ice::ObjectPrx> createProxy(const Identity& id) const = 0;

    /**
     * Explicitly set an object adapter that dispatches requests that
     * are received over this connection. A client can invoke an
     * operation on a server using a proxy, and then set an object
     * adapter for the outgoing connection that is used by the proxy
     * in order to receive callbacks. This is useful if the server
     * cannot establish a connection back to the client, for example
     * because of firewalls.
     * @param adapter The object adapter that should be used by this
     * connection to dispatch requests. The object adapter must be
     * activated. When the object adapter is deactivated, it is
     * automatically removed from the connection. Attempts to use a
     * deactivated object adapter raise {@link ObjectAdapterDeactivatedException}
     * @see #createProxy
     * @see #getAdapter
     */
    virtual void setAdapter(const ::std::shared_ptr<ObjectAdapter>& adapter) = 0;

    /**
     * Get the object adapter that dispatches requests for this
     * connection.
     * @return The object adapter that dispatches requests for the
     * connection, or null if no adapter is set.
     * @see #setAdapter
     */
    virtual ::std::shared_ptr<::Ice::ObjectAdapter> getAdapter() const noexcept = 0;

    /**
     * Get the endpoint from which the connection was created.
     * @return The endpoint from which the connection was created.
     */
    virtual ::std::shared_ptr<::Ice::Endpoint> getEndpoint() const noexcept = 0;

    /**
     * Flush any pending batch requests for this connection.
     * This means all batch requests invoked on fixed proxies
     * associated with the connection.
     * @param compress Specifies whether or not the queued batch requests
     * should be compressed before being sent over the wire.
     */
    virtual void flushBatchRequests(CompressBatch compress)
    {
        flushBatchRequestsAsync(compress).get();
    }

    /**
     * Flush any pending batch requests for this connection.
     * This means all batch requests invoked on fixed proxies
     * associated with the connection.
     * @param compress Specifies whether or not the queued batch requests
     * should be compressed before being sent over the wire.
     * @param exception The exception callback.
     * @param sent The sent callback.
     * @return A function that can be called to cancel the invocation locally.
     */
    virtual ::std::function<void()>
    flushBatchRequestsAsync(CompressBatch compress,
                            ::std::function<void(::std::exception_ptr)> exception,
                            ::std::function<void(bool)> sent = nullptr) = 0;

    /**
     * Flush any pending batch requests for this connection.
     * This means all batch requests invoked on fixed proxies
     * associated with the connection.
     * @param compress Specifies whether or not the queued batch requests
     * should be compressed before being sent over the wire.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto flushBatchRequestsAsync(CompressBatch compress)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        using Promise = P<void>;
        auto promise = ::std::make_shared<Promise>();
        flushBatchRequestsAsync(compress,
                                [promise](::std::exception_ptr ex)
                                {
                                    promise->set_exception(::std::move(ex));
                                },
                                [promise](bool)
                                {
                                    promise->set_value();
                                });
        return promise->get_future();
    }

    /**
     * Set a close callback on the connection. The callback is called by the
     * connection when it's closed. The callback is called from the
     * Ice thread pool associated with the connection. If the callback needs
     * more information about the closure, it can call {@link Connection#throwException}.
     * @param callback The close callback object.
     */
    virtual void setCloseCallback(CloseCallback callback) = 0;

    /**
     * Set a heartbeat callback on the connection. The callback is called by the
     * connection when a heartbeat is received. The callback is called
     * from the Ice thread pool associated with the connection.
     * @param callback The heartbeat callback object.
     */
    virtual void setHeartbeatCallback(HeartbeatCallback callback) = 0;

    /**
     * Send a heartbeat message.
     */
    virtual void heartbeat()
    {
        heartbeatAsync().get();
    }

    /**
     * Send a heartbeat message.
     * @param exception The exception callback.
     * @param sent The sent callback.
     * @return A function that can be called to cancel the invocation locally.
     */
    virtual ::std::function<void()>
    heartbeatAsync(::std::function<void(::std::exception_ptr)> exception,
                   ::std::function<void(bool)> sent = nullptr) = 0;

    /**
     * Send a heartbeat message.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto heartbeatAsync()
        -> decltype(::std::declval<P<void>>().get_future())
    {
        using Promise = P<void>;
        auto promise = ::std::make_shared<Promise>();
        heartbeatAsync([promise](::std::exception_ptr ex)
                       {
                           promise->set_exception(::std::move(ex));
                       },
                       [promise](bool)
                       {
                           promise->set_value();
                       });
        return promise->get_future();
    }

    /**
     * Set the active connection management parameters.
     * @param timeout The timeout value in seconds. It must be positive or 0, if a negative
     * value is given, an invalid argument exception will be raised.
     * @param close The close condition
     * @param heartbeat The hertbeat condition
     */
    virtual void setACM(const Ice::optional<int>& timeout, const Ice::optional<ACMClose>& close, const Ice::optional<ACMHeartbeat>& heartbeat) = 0;

    /**
     * Get the ACM parameters.
     * @return The ACM parameters.
     */
    virtual ::Ice::ACM getACM() noexcept = 0;

    /**
     * Return the connection type. This corresponds to the endpoint
     * type, i.e., "tcp", "udp", etc.
     * @return The type of the connection.
     */
    virtual ::std::string type() const noexcept = 0;

    /**
     * Get the timeout for the connection.
     * @return The connection's timeout.
     */
    virtual int timeout() const noexcept = 0;

    /**
     * Return a description of the connection as human readable text,
     * suitable for logging or error messages.
     * @return The description of the connection as human readable
     * text.
     */
    virtual ::std::string toString() const noexcept = 0;

    /**
     * Returns the connection information.
     * @return The connection information.
     */
    virtual ::std::shared_ptr<::Ice::ConnectionInfo> getInfo() const = 0;

    /**
     * Set the connection buffer receive/send size.
     * @param rcvSize The connection receive buffer size.
     * @param sndSize The connection send buffer size.
     */
    virtual void setBufferSize(int rcvSize, int sndSize) = 0;

    /**
     * Throw an exception indicating the reason for connection closure. For example,
     * {@link CloseConnectionException} is raised if the connection was closed gracefully,
     * whereas {@link ConnectionManuallyClosedException} is raised if the connection was
     * manually closed by the application. This operation does nothing if the connection is
     * not yet closed.
     */
    virtual void throwException() const = 0;
};

/**
 * Provides access to the connection details of an IP connection
 * \headerfile Ice/Ice.h
 */
class ICE_CLASS(ICE_API) IPConnectionInfo : public ::Ice::ConnectionInfo
{
public:

    ICE_MEMBER(ICE_API) virtual ~IPConnectionInfo();

    IPConnectionInfo() :
        localAddress(u8""),
        localPort(-1),
        remoteAddress(u8""),
        remotePort(-1)
    {
    }

    IPConnectionInfo(const IPConnectionInfo&) = default;
    IPConnectionInfo(IPConnectionInfo&&) = default;
    IPConnectionInfo& operator=(const IPConnectionInfo&) = default;
    IPConnectionInfo& operator=(IPConnectionInfo&&) = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param underlying The information of the underyling transport or null if there's no underlying transport.
     * @param incoming Whether or not the connection is an incoming or outgoing connection.
     * @param adapterName The name of the adapter associated with the connection.
     * @param connectionId The connection id.
     * @param localAddress The local address.
     * @param localPort The local port.
     * @param remoteAddress The remote address.
     * @param remotePort The remote port.
     */
    IPConnectionInfo(const ::std::shared_ptr<ConnectionInfo>& underlying, bool incoming, const ::std::string& adapterName, const ::std::string& connectionId, const ::std::string& localAddress, int localPort, const ::std::string& remoteAddress, int remotePort) :
        ConnectionInfo(::std::move(underlying), incoming, ::std::move(adapterName), ::std::move(connectionId)),
        localAddress(::std::move(localAddress)),
        localPort(localPort),
        remoteAddress(::std::move(remoteAddress)),
        remotePort(remotePort)
    {
    }

    /**
     * The local address.
     */
    ::std::string localAddress;
    /**
     * The local port.
     */
    int localPort = -1;
    /**
     * The remote address.
     */
    ::std::string remoteAddress;
    /**
     * The remote port.
     */
    int remotePort = -1;
};

/**
 * Provides access to the connection details of a TCP connection
 * \headerfile Ice/Ice.h
 */
class ICE_CLASS(ICE_API) TCPConnectionInfo : public ::Ice::IPConnectionInfo
{
public:

    ICE_MEMBER(ICE_API) virtual ~TCPConnectionInfo();

    TCPConnectionInfo() :
        rcvSize(0),
        sndSize(0)
    {
    }

    TCPConnectionInfo(const TCPConnectionInfo&) = default;
    TCPConnectionInfo(TCPConnectionInfo&&) = default;
    TCPConnectionInfo& operator=(const TCPConnectionInfo&) = default;
    TCPConnectionInfo& operator=(TCPConnectionInfo&&) = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param underlying The information of the underyling transport or null if there's no underlying transport.
     * @param incoming Whether or not the connection is an incoming or outgoing connection.
     * @param adapterName The name of the adapter associated with the connection.
     * @param connectionId The connection id.
     * @param localAddress The local address.
     * @param localPort The local port.
     * @param remoteAddress The remote address.
     * @param remotePort The remote port.
     * @param rcvSize The connection buffer receive size.
     * @param sndSize The connection buffer send size.
     */
    TCPConnectionInfo(const ::std::shared_ptr<ConnectionInfo>& underlying, bool incoming, const ::std::string& adapterName, const ::std::string& connectionId, const ::std::string& localAddress, int localPort, const ::std::string& remoteAddress, int remotePort, int rcvSize, int sndSize) :
        IPConnectionInfo(::std::move(underlying), incoming, ::std::move(adapterName), ::std::move(connectionId), ::std::move(localAddress), localPort, ::std::move(remoteAddress), remotePort),
        rcvSize(rcvSize),
        sndSize(sndSize)
    {
    }

    /**
     * The connection buffer receive size.
     */
    int rcvSize = 0;
    /**
     * The connection buffer send size.
     */
    int sndSize = 0;
};

/**
 * Provides access to the connection details of a UDP connection
 * \headerfile Ice/Ice.h
 */
class ICE_CLASS(ICE_API) UDPConnectionInfo : public ::Ice::IPConnectionInfo
{
public:

    ICE_MEMBER(ICE_API) virtual ~UDPConnectionInfo();

    UDPConnectionInfo() :
        mcastPort(-1),
        rcvSize(0),
        sndSize(0)
    {
    }

    UDPConnectionInfo(const UDPConnectionInfo&) = default;
    UDPConnectionInfo(UDPConnectionInfo&&) = default;
    UDPConnectionInfo& operator=(const UDPConnectionInfo&) = default;
    UDPConnectionInfo& operator=(UDPConnectionInfo&&) = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param underlying The information of the underyling transport or null if there's no underlying transport.
     * @param incoming Whether or not the connection is an incoming or outgoing connection.
     * @param adapterName The name of the adapter associated with the connection.
     * @param connectionId The connection id.
     * @param localAddress The local address.
     * @param localPort The local port.
     * @param remoteAddress The remote address.
     * @param remotePort The remote port.
     * @param mcastAddress The multicast address.
     * @param mcastPort The multicast port.
     * @param rcvSize The connection buffer receive size.
     * @param sndSize The connection buffer send size.
     */
    UDPConnectionInfo(const ::std::shared_ptr<ConnectionInfo>& underlying, bool incoming, const ::std::string& adapterName, const ::std::string& connectionId, const ::std::string& localAddress, int localPort, const ::std::string& remoteAddress, int remotePort, const ::std::string& mcastAddress, int mcastPort, int rcvSize, int sndSize) :
        IPConnectionInfo(::std::move(underlying), incoming, ::std::move(adapterName), ::std::move(connectionId), ::std::move(localAddress), localPort, ::std::move(remoteAddress), remotePort),
        mcastAddress(::std::move(mcastAddress)),
        mcastPort(mcastPort),
        rcvSize(rcvSize),
        sndSize(sndSize)
    {
    }

    /**
     * The multicast address.
     */
    ::std::string mcastAddress;
    /**
     * The multicast port.
     */
    int mcastPort = -1;
    /**
     * The connection buffer receive size.
     */
    int rcvSize = 0;
    /**
     * The connection buffer send size.
     */
    int sndSize = 0;
};

/**
 * Provides access to the connection details of a WebSocket connection
 * \headerfile Ice/Ice.h
 */
class ICE_CLASS(ICE_API) WSConnectionInfo : public ::Ice::ConnectionInfo
{
public:

    ICE_MEMBER(ICE_API) virtual ~WSConnectionInfo();

    WSConnectionInfo() = default;

    WSConnectionInfo(const WSConnectionInfo&) = default;
    WSConnectionInfo(WSConnectionInfo&&) = default;
    WSConnectionInfo& operator=(const WSConnectionInfo&) = default;
    WSConnectionInfo& operator=(WSConnectionInfo&&) = default;

    /**
     * One-shot constructor to initialize all data members.
     * @param underlying The information of the underyling transport or null if there's no underlying transport.
     * @param incoming Whether or not the connection is an incoming or outgoing connection.
     * @param adapterName The name of the adapter associated with the connection.
     * @param connectionId The connection id.
     * @param headers The headers from the HTTP upgrade request.
     */
    WSConnectionInfo(const ::std::shared_ptr<ConnectionInfo>& underlying, bool incoming, const ::std::string& adapterName, const ::std::string& connectionId, const HeaderDict& headers) :
        ConnectionInfo(::std::move(underlying), incoming, ::std::move(adapterName), ::std::move(connectionId)),
        headers(::std::move(headers))
    {
    }

    /**
     * The headers from the HTTP upgrade request.
     */
    HeaderDict headers;
};

}

/// \cond STREAM
namespace Ice
{

}
/// \endcond

/// \cond INTERNAL
namespace Ice
{

using ConnectionInfoPtr = ::std::shared_ptr<ConnectionInfo>;

using ConnectionPtr = ::std::shared_ptr<Connection>;

using IPConnectionInfoPtr = ::std::shared_ptr<IPConnectionInfo>;

using TCPConnectionInfoPtr = ::std::shared_ptr<TCPConnectionInfo>;

using UDPConnectionInfoPtr = ::std::shared_ptr<UDPConnectionInfo>;

using WSConnectionInfoPtr = ::std::shared_ptr<WSConnectionInfo>;

}
/// \endcond

#else // C++98 mapping

namespace Ice
{

class ConnectionInfo;
/// \cond INTERNAL
ICE_API LocalObject* upCast(ConnectionInfo*);
/// \endcond
typedef ::IceInternal::Handle< ConnectionInfo> ConnectionInfoPtr;

class Connection;
/// \cond INTERNAL
ICE_API LocalObject* upCast(Connection*);
/// \endcond
typedef ::IceInternal::Handle< Connection> ConnectionPtr;

class CloseCallback;
/// \cond INTERNAL
ICE_API LocalObject* upCast(CloseCallback*);
/// \endcond
typedef ::IceInternal::Handle< CloseCallback> CloseCallbackPtr;

class HeartbeatCallback;
/// \cond INTERNAL
ICE_API LocalObject* upCast(HeartbeatCallback*);
/// \endcond
typedef ::IceInternal::Handle< HeartbeatCallback> HeartbeatCallbackPtr;

class IPConnectionInfo;
/// \cond INTERNAL
ICE_API LocalObject* upCast(IPConnectionInfo*);
/// \endcond
typedef ::IceInternal::Handle< IPConnectionInfo> IPConnectionInfoPtr;

class TCPConnectionInfo;
/// \cond INTERNAL
ICE_API LocalObject* upCast(TCPConnectionInfo*);
/// \endcond
typedef ::IceInternal::Handle< TCPConnectionInfo> TCPConnectionInfoPtr;

class UDPConnectionInfo;
/// \cond INTERNAL
ICE_API LocalObject* upCast(UDPConnectionInfo*);
/// \endcond
typedef ::IceInternal::Handle< UDPConnectionInfo> UDPConnectionInfoPtr;

class WSConnectionInfo;
/// \cond INTERNAL
ICE_API LocalObject* upCast(WSConnectionInfo*);
/// \endcond
typedef ::IceInternal::Handle< WSConnectionInfo> WSConnectionInfoPtr;

}

namespace Ice
{

/**
 * The batch compression option when flushing queued batch requests.
 */
enum CompressBatch
{
    /**
     * Compress the batch requests.
     */
    CompressBatchYes,
    /**
     * Don't compress the batch requests.
     */
    CompressBatchNo,
    /**
     * Compress the batch requests if at least one request was
     * made on a compressed proxy.
     */
    CompressBatchBasedOnProxy
};

/**
 * Specifies the close semantics for Active Connection Management.
 */
enum ACMClose
{
    /**
     * Disables automatic connection closure.
     */
    CloseOff,
    /**
     * Gracefully closes a connection that has been idle for the configured timeout period.
     */
    CloseOnIdle,
    /**
     * Forcefully closes a connection that has been idle for the configured timeout period,
     * but only if the connection has pending invocations.
     */
    CloseOnInvocation,
    /**
     * Combines the behaviors of CloseOnIdle and CloseOnInvocation.
     */
    CloseOnInvocationAndIdle,
    /**
     * Forcefully closes a connection that has been idle for the configured timeout period,
     * regardless of whether the connection has pending invocations or dispatch.
     */
    CloseOnIdleForceful
};

/**
 * Specifies the heartbeat semantics for Active Connection Management.
 */
enum ACMHeartbeat
{
    /**
     * Disables heartbeats.
     */
    HeartbeatOff,
    /**
     * Send a heartbeat at regular intervals if the connection is idle and only if there are pending dispatch.
     */
    HeartbeatOnDispatch,
    /**
     * Send a heartbeat at regular intervals when the connection is idle.
     */
    HeartbeatOnIdle,
    /**
     * Send a heartbeat at regular intervals until the connection is closed.
     */
    HeartbeatAlways
};

/**
 * A collection of Active Connection Management configuration settings.
 * \headerfile Ice/Ice.h
 */
struct ACM
{
    /**
     * A timeout value in seconds.
     */
    Int timeout;
    /**
     * The close semantics.
     */
    ACMClose close;
    /**
     * The heartbeat semantics.
     */
    ACMHeartbeat heartbeat;

    bool operator==(const ACM& rhs_) const
    {
        if(this == &rhs_)
        {
            return true;
        }
        if(timeout != rhs_.timeout)
        {
            return false;
        }
        if(close != rhs_.close)
        {
            return false;
        }
        if(heartbeat != rhs_.heartbeat)
        {
            return false;
        }
        return true;
    }

    bool operator<(const ACM& rhs_) const
    {
        if(this == &rhs_)
        {
            return false;
        }
        if(timeout < rhs_.timeout)
        {
            return true;
        }
        else if(rhs_.timeout < timeout)
        {
            return false;
        }
        if(close < rhs_.close)
        {
            return true;
        }
        else if(rhs_.close < close)
        {
            return false;
        }
        if(heartbeat < rhs_.heartbeat)
        {
            return true;
        }
        else if(rhs_.heartbeat < heartbeat)
        {
            return false;
        }
        return false;
    }

    bool operator!=(const ACM& rhs_) const
    {
        return !operator==(rhs_);
    }
    bool operator<=(const ACM& rhs_) const
    {
        return operator<(rhs_) || operator==(rhs_);
    }
    bool operator>(const ACM& rhs_) const
    {
        return !operator<(rhs_) && !operator==(rhs_);
    }
    bool operator>=(const ACM& rhs_) const
    {
        return !operator<(rhs_);
    }
};

/**
 * Determines the behavior when manually closing a connection.
 */
enum ConnectionClose
{
    /**
     * Close the connection immediately without sending a close connection protocol message to the peer
     * and waiting for the peer to acknowledge it.
     */
    ConnectionCloseForcefully,
    /**
     * Close the connection by notifying the peer but do not wait for pending outgoing invocations to complete.
     * On the server side, the connection will not be closed until all incoming invocations have completed.
     */
    ConnectionCloseGracefully,
    /**
     * Wait for all pending invocations to complete before closing the connection.
     */
    ConnectionCloseGracefullyWithWait
};

/**
 * A collection of HTTP headers.
 */
typedef ::std::map< ::std::string, ::std::string> HeaderDict;

}

namespace Ice
{

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Ice::Connection::begin_flushBatchRequests.
 * Create a wrapper instance by calling ::Ice::newCallback_Connection_flushBatchRequests.
 */
class Callback_Connection_flushBatchRequests_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Connection_flushBatchRequests_Base> Callback_Connection_flushBatchRequestsPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Ice::Connection::begin_heartbeat.
 * Create a wrapper instance by calling ::Ice::newCallback_Connection_heartbeat.
 */
class Callback_Connection_heartbeat_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Connection_heartbeat_Base> Callback_Connection_heartbeatPtr;

}

namespace Ice
{

/**
 * Base class providing access to the connection details.
 * \headerfile Ice/Ice.h
 */
class ICE_API ConnectionInfo : public virtual LocalObject
{
public:

    typedef ConnectionInfoPtr PointerType;

    virtual ~ConnectionInfo();

    ConnectionInfo()
    {
    }

    /**
     * One-shot constructor to initialize all data members.
     * @param underlying The information of the underyling transport or null if there's no underlying transport.
     * @param incoming Whether or not the connection is an incoming or outgoing connection.
     * @param adapterName The name of the adapter associated with the connection.
     * @param connectionId The connection id.
     */
    ConnectionInfo(const ConnectionInfoPtr& underlying, bool incoming, const ::std::string& adapterName, const ::std::string& connectionId) :
        underlying(underlying),
        incoming(incoming),
        adapterName(adapterName),
        connectionId(connectionId)
    {
    }

    /**
     * The information of the underyling transport or null if there's
     * no underlying transport.
     */
    ConnectionInfoPtr underlying;
    /**
     * Whether or not the connection is an incoming or outgoing
     * connection.
     */
    bool incoming;
    /**
     * The name of the adapter associated with the connection.
     */
    ::std::string adapterName;
    /**
     * The connection id.
     */
    ::std::string connectionId;
};

/// \cond INTERNAL
inline bool operator==(const ConnectionInfo& lhs, const ConnectionInfo& rhs)
{
    return static_cast<const LocalObject&>(lhs) == static_cast<const LocalObject&>(rhs);
}

inline bool operator<(const ConnectionInfo& lhs, const ConnectionInfo& rhs)
{
    return static_cast<const LocalObject&>(lhs) < static_cast<const LocalObject&>(rhs);
}
/// \endcond

/**
 * An application can implement this interface to receive notifications when
 * a connection closes.
 * @see Connection#setCloseCallback
 * \headerfile Ice/Ice.h
 */
class ICE_API CloseCallback : public virtual LocalObject
{
public:

    typedef CloseCallbackPtr PointerType;

    virtual ~CloseCallback();

    /**
     * This method is called by the the connection when the connection
     * is closed. If the callback needs more information about the closure,
     * it can call {@link Connection#throwException}.
     * @param con The connection that closed.
     */
    virtual void closed(const ConnectionPtr& con) = 0;
};

/// \cond INTERNAL
inline bool operator==(const CloseCallback& lhs, const CloseCallback& rhs)
{
    return static_cast<const LocalObject&>(lhs) == static_cast<const LocalObject&>(rhs);
}

inline bool operator<(const CloseCallback& lhs, const CloseCallback& rhs)
{
    return static_cast<const LocalObject&>(lhs) < static_cast<const LocalObject&>(rhs);
}
/// \endcond

/**
 * An application can implement this interface to receive notifications when
 * a connection receives a heartbeat message.
 * @see Connection#setHeartbeatCallback
 * \headerfile Ice/Ice.h
 */
class ICE_API HeartbeatCallback : public virtual LocalObject
{
public:

    typedef HeartbeatCallbackPtr PointerType;

    virtual ~HeartbeatCallback();

    /**
     * This method is called by the the connection when a heartbeat is
     * received from the peer.
     * @param con The connection on which a heartbeat was received.
     */
    virtual void heartbeat(const ConnectionPtr& con) = 0;
};

/// \cond INTERNAL
inline bool operator==(const HeartbeatCallback& lhs, const HeartbeatCallback& rhs)
{
    return static_cast<const LocalObject&>(lhs) == static_cast<const LocalObject&>(rhs);
}

inline bool operator<(const HeartbeatCallback& lhs, const HeartbeatCallback& rhs)
{
    return static_cast<const LocalObject&>(lhs) < static_cast<const LocalObject&>(rhs);
}
/// \endcond

/**
 * The user-level interface to a connection.
 * \headerfile Ice/Ice.h
 */
class ICE_API Connection : public virtual LocalObject
{
public:

    typedef ConnectionPtr PointerType;

    virtual ~Connection();

    /**
     * Manually close the connection using the specified closure mode.
     * @param mode Determines how the connection will be closed.
     * @see ConnectionClose
     */
    virtual void close(ConnectionClose mode) ICE_NOEXCEPT = 0;

    /**
     * Create a special proxy that always uses this connection. This
     * can be used for callbacks from a server to a client if the
     * server cannot directly establish a connection to the client,
     * for example because of firewalls. In this case, the server
     * would create a proxy using an already established connection
     * from the client.
     * @param id The identity for which a proxy is to be created.
     * @return A proxy that matches the given identity and uses this
     * connection.
     * @see #setAdapter
     */
    virtual ObjectPrx createProxy(const Identity& id) const = 0;

    /**
     * Explicitly set an object adapter that dispatches requests that
     * are received over this connection. A client can invoke an
     * operation on a server using a proxy, and then set an object
     * adapter for the outgoing connection that is used by the proxy
     * in order to receive callbacks. This is useful if the server
     * cannot establish a connection back to the client, for example
     * because of firewalls.
     * @param adapter The object adapter that should be used by this
     * connection to dispatch requests. The object adapter must be
     * activated. When the object adapter is deactivated, it is
     * automatically removed from the connection. Attempts to use a
     * deactivated object adapter raise {@link ObjectAdapterDeactivatedException}
     * @see #createProxy
     * @see #getAdapter
     */
    virtual void setAdapter(const ObjectAdapterPtr& adapter) = 0;

    /**
     * Get the object adapter that dispatches requests for this
     * connection.
     * @return The object adapter that dispatches requests for the
     * connection, or null if no adapter is set.
     * @see #setAdapter
     */
    virtual ObjectAdapterPtr getAdapter() const ICE_NOEXCEPT = 0;

    /**
     * Get the endpoint from which the connection was created.
     * @return The endpoint from which the connection was created.
     */
    virtual EndpointPtr getEndpoint() const ICE_NOEXCEPT = 0;

    /**
     * Flush any pending batch requests for this connection.
     * This means all batch requests invoked on fixed proxies
     * associated with the connection.
     * @param compress Specifies whether or not the queued batch requests
     * should be compressed before being sent over the wire.
     */
    virtual void flushBatchRequests(CompressBatch compress) = 0;

    /**
     * Flush any pending batch requests for this connection.
     * This means all batch requests invoked on fixed proxies
     * associated with the connection.
     * @param compress Specifies whether or not the queued batch requests
     * should be compressed before being sent over the wire.
     * @return The asynchronous result object for the invocation.
     */
    virtual AsyncResultPtr begin_flushBatchRequests(CompressBatch compress) = 0;

    /**
     * Flush any pending batch requests for this connection.
     * This means all batch requests invoked on fixed proxies
     * associated with the connection.
     * @param compress Specifies whether or not the queued batch requests
     * should be compressed before being sent over the wire.
     * @param cb Callback to be invoked when the invocation completes
     * @param cookie Extra data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    virtual AsyncResultPtr begin_flushBatchRequests(CompressBatch compress, const CallbackPtr& cb, const LocalObjectPtr& cookie = 0) = 0;

    /**
     * Flush any pending batch requests for this connection.
     * This means all batch requests invoked on fixed proxies
     * associated with the connection.
     * @param compress Specifies whether or not the queued batch requests
     * should be compressed before being sent over the wire.
     * @param cb Callback to be invoked when the invocation completes
     * @param cookie Extra data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    virtual AsyncResultPtr begin_flushBatchRequests(CompressBatch compress, const Callback_Connection_flushBatchRequestsPtr& cb, const LocalObjectPtr& cookie = 0) = 0;

    /**
     * Flush any pending batch requests for this connection.
     * This means all batch requests invoked on fixed proxies
     * associated with the connection.
     * @param result The asynchronous result object returned by the begin_ method.
     */
    virtual void end_flushBatchRequests(const AsyncResultPtr& result) = 0;

    /**
     * Set a close callback on the connection. The callback is called by the
     * connection when it's closed. The callback is called from the
     * Ice thread pool associated with the connection. If the callback needs
     * more information about the closure, it can call {@link Connection#throwException}.
     * @param callback The close callback object.
     */
    virtual void setCloseCallback(const CloseCallbackPtr& callback) = 0;

    /**
     * Set a heartbeat callback on the connection. The callback is called by the
     * connection when a heartbeat is received. The callback is called
     * from the Ice thread pool associated with the connection.
     * @param callback The heartbeat callback object.
     */
    virtual void setHeartbeatCallback(const HeartbeatCallbackPtr& callback) = 0;

    /**
     * Send a heartbeat message.
     */
    virtual void heartbeat() = 0;

    /**
     * Send a heartbeat message.
     * @return The asynchronous result object for the invocation.
     */
    virtual AsyncResultPtr begin_heartbeat() = 0;

    /**
     * Send a heartbeat message.
     * @param cb Callback to be invoked when the invocation completes
     * @param cookie Extra data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    virtual AsyncResultPtr begin_heartbeat(const CallbackPtr& cb, const LocalObjectPtr& cookie = 0) = 0;

    /**
     * Send a heartbeat message.
     * @param cb Callback to be invoked when the invocation completes
     * @param cookie Extra data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    virtual AsyncResultPtr begin_heartbeat(const Callback_Connection_heartbeatPtr& cb, const LocalObjectPtr& cookie = 0) = 0;

    /**
     * Send a heartbeat message.
     * @param result The asynchronous result object returned by the begin_ method.
     */
    virtual void end_heartbeat(const AsyncResultPtr& result) = 0;

    /**
     * Set the active connection management parameters.
     * @param timeout The timeout value in seconds. It must be positive or 0, if a negative
     * value is given, an invalid argument exception will be raised.
     * @param close The close condition
     * @param heartbeat The hertbeat condition
     */
    virtual void setACM(const IceUtil::Optional<Int>& timeout, const IceUtil::Optional<ACMClose>& close, const IceUtil::Optional<ACMHeartbeat>& heartbeat) = 0;

    /**
     * Get the ACM parameters.
     * @return The ACM parameters.
     */
    virtual ACM getACM() ICE_NOEXCEPT = 0;

    /**
     * Return the connection type. This corresponds to the endpoint
     * type, i.e., "tcp", "udp", etc.
     * @return The type of the connection.
     */
    virtual ::std::string type() const ICE_NOEXCEPT = 0;

    /**
     * Get the timeout for the connection.
     * @return The connection's timeout.
     */
    virtual Int timeout() const ICE_NOEXCEPT = 0;

    /**
     * Return a description of the connection as human readable text,
     * suitable for logging or error messages.
     * @return The description of the connection as human readable
     * text.
     */
    virtual ::std::string toString() const ICE_NOEXCEPT = 0;

    /**
     * Returns the connection information.
     * @return The connection information.
     */
    virtual ConnectionInfoPtr getInfo() const = 0;

    /**
     * Set the connection buffer receive/send size.
     * @param rcvSize The connection receive buffer size.
     * @param sndSize The connection send buffer size.
     */
    virtual void setBufferSize(Int rcvSize, Int sndSize) = 0;

    /**
     * Throw an exception indicating the reason for connection closure. For example,
     * {@link CloseConnectionException} is raised if the connection was closed gracefully,
     * whereas {@link ConnectionManuallyClosedException} is raised if the connection was
     * manually closed by the application. This operation does nothing if the connection is
     * not yet closed.
     */
    virtual void throwException() const = 0;
};

/// \cond INTERNAL
inline bool operator==(const Connection& lhs, const Connection& rhs)
{
    return static_cast<const LocalObject&>(lhs) == static_cast<const LocalObject&>(rhs);
}

inline bool operator<(const Connection& lhs, const Connection& rhs)
{
    return static_cast<const LocalObject&>(lhs) < static_cast<const LocalObject&>(rhs);
}
/// \endcond

/**
 * Provides access to the connection details of an IP connection
 * \headerfile Ice/Ice.h
 */
class ICE_API IPConnectionInfo : public ConnectionInfo
{
public:

    typedef IPConnectionInfoPtr PointerType;

    virtual ~IPConnectionInfo();

    /** Default constructor that assigns default values to members as specified in the Slice definition. */
    IPConnectionInfo() :
        localAddress(""),
        localPort(-1),
        remoteAddress(""),
        remotePort(-1)
    {
    }

    /**
     * One-shot constructor to initialize all data members.
     * @param underlying The information of the underyling transport or null if there's no underlying transport.
     * @param incoming Whether or not the connection is an incoming or outgoing connection.
     * @param adapterName The name of the adapter associated with the connection.
     * @param connectionId The connection id.
     * @param localAddress The local address.
     * @param localPort The local port.
     * @param remoteAddress The remote address.
     * @param remotePort The remote port.
     */
    IPConnectionInfo(const ConnectionInfoPtr& underlying, bool incoming, const ::std::string& adapterName, const ::std::string& connectionId, const ::std::string& localAddress, Int localPort, const ::std::string& remoteAddress, Int remotePort) :
        ::Ice::ConnectionInfo(underlying, incoming, adapterName, connectionId),
        localAddress(localAddress),
        localPort(localPort),
        remoteAddress(remoteAddress),
        remotePort(remotePort)
    {
    }

    /**
     * The local address.
     */
    ::std::string localAddress;
    /**
     * The local port.
     */
    Int localPort;
    /**
     * The remote address.
     */
    ::std::string remoteAddress;
    /**
     * The remote port.
     */
    Int remotePort;
};

/// \cond INTERNAL
inline bool operator==(const IPConnectionInfo& lhs, const IPConnectionInfo& rhs)
{
    return static_cast<const LocalObject&>(lhs) == static_cast<const LocalObject&>(rhs);
}

inline bool operator<(const IPConnectionInfo& lhs, const IPConnectionInfo& rhs)
{
    return static_cast<const LocalObject&>(lhs) < static_cast<const LocalObject&>(rhs);
}
/// \endcond

/**
 * Provides access to the connection details of a TCP connection
 * \headerfile Ice/Ice.h
 */
class ICE_API TCPConnectionInfo : public IPConnectionInfo
{
public:

    typedef TCPConnectionInfoPtr PointerType;

    virtual ~TCPConnectionInfo();

    /** Default constructor that assigns default values to members as specified in the Slice definition. */
    TCPConnectionInfo() :
        rcvSize(0),
        sndSize(0)
    {
    }

    /**
     * One-shot constructor to initialize all data members.
     * @param underlying The information of the underyling transport or null if there's no underlying transport.
     * @param incoming Whether or not the connection is an incoming or outgoing connection.
     * @param adapterName The name of the adapter associated with the connection.
     * @param connectionId The connection id.
     * @param localAddress The local address.
     * @param localPort The local port.
     * @param remoteAddress The remote address.
     * @param remotePort The remote port.
     * @param rcvSize The connection buffer receive size.
     * @param sndSize The connection buffer send size.
     */
    TCPConnectionInfo(const ConnectionInfoPtr& underlying, bool incoming, const ::std::string& adapterName, const ::std::string& connectionId, const ::std::string& localAddress, Int localPort, const ::std::string& remoteAddress, Int remotePort, Int rcvSize, Int sndSize) :
        ::Ice::IPConnectionInfo(underlying, incoming, adapterName, connectionId, localAddress, localPort, remoteAddress, remotePort),
        rcvSize(rcvSize),
        sndSize(sndSize)
    {
    }

    /**
     * The connection buffer receive size.
     */
    Int rcvSize;
    /**
     * The connection buffer send size.
     */
    Int sndSize;
};

/// \cond INTERNAL
inline bool operator==(const TCPConnectionInfo& lhs, const TCPConnectionInfo& rhs)
{
    return static_cast<const LocalObject&>(lhs) == static_cast<const LocalObject&>(rhs);
}

inline bool operator<(const TCPConnectionInfo& lhs, const TCPConnectionInfo& rhs)
{
    return static_cast<const LocalObject&>(lhs) < static_cast<const LocalObject&>(rhs);
}
/// \endcond

/**
 * Provides access to the connection details of a UDP connection
 * \headerfile Ice/Ice.h
 */
class ICE_API UDPConnectionInfo : public IPConnectionInfo
{
public:

    typedef UDPConnectionInfoPtr PointerType;

    virtual ~UDPConnectionInfo();

    /** Default constructor that assigns default values to members as specified in the Slice definition. */
    UDPConnectionInfo() :
        mcastPort(-1),
        rcvSize(0),
        sndSize(0)
    {
    }

    /**
     * One-shot constructor to initialize all data members.
     * @param underlying The information of the underyling transport or null if there's no underlying transport.
     * @param incoming Whether or not the connection is an incoming or outgoing connection.
     * @param adapterName The name of the adapter associated with the connection.
     * @param connectionId The connection id.
     * @param localAddress The local address.
     * @param localPort The local port.
     * @param remoteAddress The remote address.
     * @param remotePort The remote port.
     * @param mcastAddress The multicast address.
     * @param mcastPort The multicast port.
     * @param rcvSize The connection buffer receive size.
     * @param sndSize The connection buffer send size.
     */
    UDPConnectionInfo(const ConnectionInfoPtr& underlying, bool incoming, const ::std::string& adapterName, const ::std::string& connectionId, const ::std::string& localAddress, Int localPort, const ::std::string& remoteAddress, Int remotePort, const ::std::string& mcastAddress, Int mcastPort, Int rcvSize, Int sndSize) :
        ::Ice::IPConnectionInfo(underlying, incoming, adapterName, connectionId, localAddress, localPort, remoteAddress, remotePort),
        mcastAddress(mcastAddress),
        mcastPort(mcastPort),
        rcvSize(rcvSize),
        sndSize(sndSize)
    {
    }

    /**
     * The multicast address.
     */
    ::std::string mcastAddress;
    /**
     * The multicast port.
     */
    Int mcastPort;
    /**
     * The connection buffer receive size.
     */
    Int rcvSize;
    /**
     * The connection buffer send size.
     */
    Int sndSize;
};

/// \cond INTERNAL
inline bool operator==(const UDPConnectionInfo& lhs, const UDPConnectionInfo& rhs)
{
    return static_cast<const LocalObject&>(lhs) == static_cast<const LocalObject&>(rhs);
}

inline bool operator<(const UDPConnectionInfo& lhs, const UDPConnectionInfo& rhs)
{
    return static_cast<const LocalObject&>(lhs) < static_cast<const LocalObject&>(rhs);
}
/// \endcond

/**
 * Provides access to the connection details of a WebSocket connection
 * \headerfile Ice/Ice.h
 */
class ICE_API WSConnectionInfo : public ConnectionInfo
{
public:

    typedef WSConnectionInfoPtr PointerType;

    virtual ~WSConnectionInfo();

    WSConnectionInfo()
    {
    }

    /**
     * One-shot constructor to initialize all data members.
     * @param underlying The information of the underyling transport or null if there's no underlying transport.
     * @param incoming Whether or not the connection is an incoming or outgoing connection.
     * @param adapterName The name of the adapter associated with the connection.
     * @param connectionId The connection id.
     * @param headers The headers from the HTTP upgrade request.
     */
    WSConnectionInfo(const ConnectionInfoPtr& underlying, bool incoming, const ::std::string& adapterName, const ::std::string& connectionId, const HeaderDict& headers) :
        ::Ice::ConnectionInfo(underlying, incoming, adapterName, connectionId),
        headers(headers)
    {
    }

    /**
     * The headers from the HTTP upgrade request.
     */
    HeaderDict headers;
};

/// \cond INTERNAL
inline bool operator==(const WSConnectionInfo& lhs, const WSConnectionInfo& rhs)
{
    return static_cast<const LocalObject&>(lhs) == static_cast<const LocalObject&>(rhs);
}

inline bool operator<(const WSConnectionInfo& lhs, const WSConnectionInfo& rhs)
{
    return static_cast<const LocalObject&>(lhs) < static_cast<const LocalObject&>(rhs);
}
/// \endcond

}

/// \cond STREAM
namespace Ice
{

}
/// \endcond

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
