/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.network;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.parosproxy.paros.network.HttpBody;

public class HttpResponseBody
extends HttpBody {
    private static final Logger log = Logger.getLogger(HttpResponseBody.class);
    private static final Pattern patternCharset = Pattern.compile("<META +[^>]+charset *= *['\\x22]?([^>'\\x22;]+)['\\x22]? *[/]?>", 2);

    public HttpResponseBody() {
    }

    public HttpResponseBody(int capacity) {
        super(capacity);
    }

    public HttpResponseBody(String contents) {
        super(contents);
    }

    public HttpResponseBody(byte[] contents) {
        super(contents);
    }

    @Override
    protected Charset determineCharset(String contents) {
        Matcher matcher = patternCharset.matcher(contents);
        if (matcher.find()) {
            try {
                return Charset.forName(matcher.group(1));
            }
            catch (IllegalArgumentException e) {
                log.warn((Object)("Unable to determine (valid) charset with the (X)HTML meta charset: " + e.getMessage()));
            }
        } else if (HttpResponseBody.isUtf8String(contents)) {
            return StandardCharsets.UTF_8;
        }
        return null;
    }

    private static boolean isUtf8String(String string) {
        return new String(string.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8).length() == string.length();
    }

    @Override
    protected String createString(Charset currentCharset) {
        if (currentCharset != null) {
            return super.createString(currentCharset);
        }
        return this.createStringWithMetaCharset();
    }

    private String createStringWithMetaCharset() {
        String result = null;
        String resultDefaultCharset = null;
        try {
            resultDefaultCharset = new String(this.getBytes(), 0, this.getPos(), StandardCharsets.ISO_8859_1);
            Matcher matcher = patternCharset.matcher(resultDefaultCharset);
            if (matcher.find()) {
                String charset = matcher.group(1);
                result = new String(this.getBytes(), 0, this.getPos(), charset);
                this.setCharset(charset);
            } else {
                String utf8 = this.toUTF8();
                if (utf8 != null) {
                    this.setCharset(StandardCharsets.UTF_8.name());
                    result = utf8;
                } else {
                    result = resultDefaultCharset;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("Unable to encode with the (X)HTML meta charset: " + e.getMessage()));
            log.warn((Object)("Using default charset: " + DEFAULT_CHARSET));
            result = resultDefaultCharset;
        }
        return result;
    }

    private String toUTF8() {
        String utf8 = new String(this.getBytes(), 0, this.getPos(), StandardCharsets.UTF_8);
        int length2 = utf8.getBytes(StandardCharsets.UTF_8).length;
        if (this.getPos() != length2) {
            return null;
        }
        return utf8;
    }
}

