/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo.builders;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import org.elasticsearch.common.geo.GeoShapeType;
import org.elasticsearch.common.geo.builders.LineStringBuilder;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.geo.parsers.ShapeParser;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.geo.geometry.Geometry;
import org.elasticsearch.geo.geometry.Line;
import org.elasticsearch.geo.geometry.MultiLine;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;

public class MultiLineStringBuilder
extends ShapeBuilder<JtsGeometry, Geometry, MultiLineStringBuilder> {
    public static final GeoShapeType TYPE = GeoShapeType.MULTILINESTRING;
    private final ArrayList<LineStringBuilder> lines = new ArrayList();

    public MultiLineStringBuilder(StreamInput in) throws IOException {
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            this.linestring(new LineStringBuilder(in));
        }
    }

    public MultiLineStringBuilder() {
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.lines.size());
        for (LineStringBuilder line : this.lines) {
            line.writeTo(out);
        }
    }

    public MultiLineStringBuilder linestring(LineStringBuilder line) {
        this.lines.add(line);
        return this;
    }

    public Coordinate[][] coordinates() {
        Coordinate[][] result = new Coordinate[this.lines.size()][];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.lines.get(i).coordinates(false);
        }
        return result;
    }

    @Override
    public GeoShapeType type() {
        return TYPE;
    }

    @Override
    protected StringBuilder contentToWKT() {
        StringBuilder sb = new StringBuilder();
        if (this.lines.isEmpty()) {
            sb.append("EMPTY");
        } else {
            sb.append("(");
            if (this.lines.size() > 0) {
                sb.append((CharSequence)ShapeBuilder.coordinateListToWKT(this.lines.get((int)0).coordinates));
            }
            for (int i = 1; i < this.lines.size(); ++i) {
                sb.append(",");
                sb.append((CharSequence)ShapeBuilder.coordinateListToWKT(this.lines.get((int)i).coordinates));
            }
            sb.append(")");
        }
        return sb;
    }

    @Override
    public int numDimensions() {
        if (this.lines == null || this.lines.isEmpty()) {
            throw new IllegalStateException("unable to get number of dimensions, LineStrings have not yet been initialized");
        }
        return this.lines.get(0).numDimensions();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ShapeParser.FIELD_TYPE.getPreferredName(), TYPE.shapeName());
        builder.field(ShapeParser.FIELD_COORDINATES.getPreferredName());
        builder.startArray();
        for (LineStringBuilder line : this.lines) {
            line.coordinatesToXcontent(builder, false);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    @Override
    public JtsGeometry buildS4J() {
        MultiLineString geometry;
        if (this.wrapdateline) {
            ArrayList<LineString> parts = new ArrayList<LineString>();
            for (LineStringBuilder line : this.lines) {
                LineStringBuilder.decomposeS4J(FACTORY, line.coordinates(false), parts);
            }
            if (parts.size() == 1) {
                geometry = (org.locationtech.jts.geom.Geometry)parts.get(0);
            } else {
                LineString[] lineStrings = parts.toArray(new LineString[parts.size()]);
                geometry = FACTORY.createMultiLineString(lineStrings);
            }
        } else {
            LineString[] lineStrings = new LineString[this.lines.size()];
            Iterator<LineStringBuilder> iterator = this.lines.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                lineStrings[i] = FACTORY.createLineString(iterator.next().coordinates(false));
                ++i;
            }
            geometry = FACTORY.createMultiLineString(lineStrings);
        }
        return this.jtsGeometry((org.locationtech.jts.geom.Geometry)geometry);
    }

    @Override
    public Geometry buildGeometry() {
        if (this.lines.isEmpty()) {
            return MultiLine.EMPTY;
        }
        if (this.wrapdateline) {
            ArrayList<Line> parts = new ArrayList<Line>();
            for (LineStringBuilder line : this.lines) {
                LineStringBuilder.decomposeGeometry(line.coordinates(false), parts);
            }
            if (parts.size() == 1) {
                return (Geometry)parts.get(0);
            }
            return new MultiLine(parts);
        }
        ArrayList<Line> linestrings = new ArrayList<Line>(this.lines.size());
        for (int i = 0; i < this.lines.size(); ++i) {
            LineStringBuilder lsb = this.lines.get(i);
            linestrings.add(new Line(lsb.coordinates.stream().mapToDouble(c -> c.y).toArray(), lsb.coordinates.stream().mapToDouble(c -> c.x).toArray()));
        }
        return new MultiLine(linestrings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.lines);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MultiLineStringBuilder other = (MultiLineStringBuilder)obj;
        return Objects.equals(this.lines, other.lines);
    }
}

